<?php

namespace App\Http\Controllers\LifeAtGainup\Merchandiser;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class ProductionController extends Controller
{
    public function production_gar_dashboard()
    {
        return view('LifeAtGainup.Production.production_gar_dashboard');
    }

    public function production_gar_dashboard_beta()
    {
        return view('LifeAtGainup.Production.prod_gar_static');
    }

    public function history_dashboard()
    {
        return view('LifeAtGainup.Production.history_dashboard');
    }

    public function history_dashboard_portal(Request $request)
    {
        $portal_type = ucfirst($request->portal );
        $fromdate    = $request->query('fromdate');
        $enddate     = $request->query('enddate');
        return view('LifeAtGainup.Production.history_dashboard',  compact('portal_type', 'fromdate', 'enddate'));
    }

    public function cutting_output()
    {
        return view('LifeAtGainup.Production.Cutting_output_dashboard');
    }

	public function wip()
    {
        return view('LifeAtGainup.Production.wip');
    }

	public function smstock()
    {
        return view('LifeAtGainup.Production.smstock');
    }

	public function directlabour()
    {
        return view('LifeAtGainup.Production.directlabour');
    }

    public function linestop_analysis()
    {
        return view('LifeAtGainup.Production.Linestop_analysis_dashboard');
    }

    public function issued()
    {
        return view('LifeAtGainup.Production.issued');
    }

    public function dailysnapshot(Request $request)
    {
        try {
            $type = $request->input('type');
            $fdate = $request->input('fromdate')
                ? Carbon::parse($request->input('fromdate'))->format('d-M-Y')
                : Carbon::today()->format('d-M-Y');
            $enddate = $request->input('enddate')
                ? Carbon::parse($request->input('enddate'))->format('d-M-Y')
                : $fdate;

            $cacheKey = "daily_snapshot_{$fdate}_{$enddate}_{$type}";

            // Optionally cache the built payload for a short time
            $payload = Cache::remember($cacheKey, 600, function () use ($fdate, $enddate) {
                // Raw data from stored procedures
                $resultData = DB::select(
                    'exec VAAHINI_ERP_GAINUP.DBO.Audit_Details_DB_Details_Proc @Fdate = ?, @Tdate = ?',
                    [$fdate, $enddate]
                );
                $dashboardData = DB::select(
                    'exec VAAHINI_ERP_GAINUP.DBO.Production_Main_DB_Proc @Fdate = ?, @Tdate = ?',
                    [$fdate, $enddate]
                );

                $rows = json_decode(json_encode($resultData), true);
                $collection = collect($rows);

                $normalizeEff = function ($val) {
                    if ($val === null || $val === '') return 0.0;
                    if (is_string($val)) { $val = str_replace([',','%'], '', trim($val)); }
                    return (float)$val;
                };

                // Group by Unit → Zone and aggregate
                $units = $collection
                    ->groupBy('Unit')
                    ->map(function ($unitGroup, $unitName) use ($normalizeEff) {
                        $zones = collect($unitGroup)
                            ->groupBy('Zone')
                            ->map(function ($zoneGroup, $zoneName) use ($normalizeEff) {
                                $totalOutput = $zoneGroup->sum(fn($it) => (float)($it['Output_Qty'] ?? 0));
                                $totalErnMins = $zoneGroup->sum(fn($it) => (float)($it['Ern_Mins'] ?? 0));
                                $samPerPiece = $totalOutput > 0 ? ($totalErnMins / $totalOutput) : 0;

                                $lineEffs = collect($zoneGroup)
                                    ->map(fn($it) => $normalizeEff($it['Eff_Perc'] ?? 0))
                                    ->filter(fn($eff) => $eff > 0);
                                $avgZoneEff = $lineEffs->count() > 0 ? $lineEffs->avg() : 0;

                                return [
                                    'Zone' => $zoneName,
                                    'Total_Output_Qty' => $totalOutput,
                                    'Total_Line_WIP'   => $zoneGroup->sum(fn($it) => (float)($it['Line_WIP'] ?? 0)),
                                    'Total_Ern_Mins'   => round($totalErnMins, 2),
                                    'Total_Ern_Sam'    => round($samPerPiece, 2),
                                    'Total_Tailors'    => $zoneGroup->sum(fn($it) => (float)($it['Tailors'] ?? 0)),
                                    'Total_Dir_Lab'    => $zoneGroup->sum(fn($it) => (float)($it['Dir_Cnt'] ?? 0)),
                                    'Total_Ern_Rundays'=> $zoneGroup->sum(fn($it) => (float)($it['Run_Days'] ?? 0)),
                                    'Total_Ern_EfficiencyPerc' => $avgZoneEff,
                                    'data' => $zoneGroup->values()->all(),
                                ];
                            })
                            ->values()
                            ->all();

                        $unitTotalOutput = $unitGroup->sum(fn($it) => (float)($it['Output_Qty'] ?? 0));
                        $unitTotalErnMins = $unitGroup->sum(fn($it) => (float)($it['Ern_Mins'] ?? 0));
                        $samPerPieceUnit = $unitTotalOutput > 0 ? ($unitTotalErnMins / $unitTotalOutput) : 0;

                        $unitEfficiency = count($zones) > 0
                            ? round(collect($zones)->sum(fn($z) => $z['Total_Ern_EfficiencyPerc']) / count($zones), 2)
                            : 0;

                        return [
                            'Unit' => $unitName,
                            'Total_Output_Qty' => $unitTotalOutput,
                            'Total_Line_WIP'   => $unitGroup->sum(fn($it) => (float)($it['Line_WIP'] ?? 0)),
                            'Total_Ern_Mins'   => round($unitTotalErnMins, 2),
                            'Total_Ern_Sam'    => round($samPerPieceUnit, 2),
                            'Total_Tailors'    => $unitGroup->sum(fn($it) => (float)($it['Tailors'] ?? 0)),
                            'Total_Dir_Lab'    => $unitGroup->sum(fn($it) => (float)($it['Dir_Cnt'] ?? 0)),
                            'Total_Ern_Rundays'=> $unitGroup->sum(fn($it) => (float)($it['Run_Days'] ?? 0)),
                            'Total_Ern_EfficiencyPerc' => $unitEfficiency,
                            'zones' => $zones,
                        ];
                    })
                    ->values()
                    ->all();

                // Build overall totals and efficiency metric
                $overallTotals = json_decode(json_encode($dashboardData), true);
                $overallEfficiency = count($units) > 0
                    ? round(collect($units)->avg(fn($u) => $u['Total_Ern_EfficiencyPerc']), 2)
                    : 0;
                $overallTotals[] = [
                    'Type' => 'Efficiency',
                    'Cutting' => $overallEfficiency,
                    'Slno' => 6,
                ];

                return [
                    'overall_totals' => $overallTotals,
                    'units' => $units,
                ];
            });

            return response()->json([
                'success' => true,
                'overall_totals' => $payload['overall_totals'],
                'units' => $payload['units'],
            ]);
        } catch (\Throwable $e) {
            Log::error('dailysnapshot failed: '.$e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Failed to load daily snapshot.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }

    public function productionhistoricaldata(Request $request)
    {
        ini_set('memory_limit', '512M');
        try {
            $type = $request->input('type') ?? 1;
            $fdate = $request->input('fromdate') ? Carbon::parse($request->input('fromdate'))->format('d-M-Y') : null;
            $enddate = $request->input('enddate') ? Carbon::parse($request->input('enddate'))->format('d-M-Y') : null;

            $rows = $fdate && $enddate
                ? DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.Audit_Details_History_DB_Proc @Arg = ?, @Fdate = ?, @Tdate = ?', [$type, $fdate, $enddate])
                : DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.Audit_Details_History_DB_Proc @Arg = ?', [$type]);

            $data = collect($rows)->map(fn($r) => (array)$r)
                ->groupBy('Mon_Name')
                ->map(function ($monthGroup) {
                    $units = $monthGroup->groupBy('Unit')->map(function ($unitGroup) {
                        $buyers = $unitGroup->groupBy('Buyer')->map(function ($buyerGroup) {
                            $lines = $buyerGroup->groupBy('Line_No')->map(function ($lineGroup) {
                                return [
                                    'Line_No' => $lineGroup->first()['Line_No'] ?? null,
                                    'line_total_Audit_Qty' => $lineGroup->sum(fn($r) => (int)($r['Qty'] ?? 0)),
                                    'data' => array_values($lineGroup->toArray()),
                                ];
                            })->values()->toArray();
                            return [
                                'Buyer' => $buyerGroup->first()['Buyer'] ?? null,
                                'buyer_total_Audit_Qty' => $buyerGroup->sum(fn($r) => (int)($r['Qty'] ?? 0)),
                                'lines' => $lines,
                            ];
                        })->values()->toArray();
                        return [
                            'Unit' => $unitGroup->first()['Unit'] ?? null,
                            'buyers' => $buyers,
                        ];
                    })->values()->toArray();

                    return [
                        'Mon_Name' => $monthGroup->first()['Mon_Name'] ?? '',
                        'units' => $units,
                    ];
                })->values()->toArray();

            return response()->json(['success' => true, 'data' => $data]);
        } catch (\Throwable $e) {
            Log::error('productionhistoricaldata failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function production_minis_historicaldata(Request $request)
    {
        ini_set('memory_limit', '512M');
        try {
            $type = $request->input('type') ?? 1;
            $fdate = $request->input('fromdate') ? Carbon::parse($request->input('fromdate'))->format('d-M-Y') : null;
            $enddate = $request->input('enddate') ? Carbon::parse($request->input('enddate'))->format('d-M-Y') : null;

            $rows = $fdate && $enddate
                ? DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.DTM_Details_History_DB_Proc @Arg = ?, @Fdate = ?, @Tdate = ?', [$type, $fdate, $enddate])
                : DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.DTM_Details_History_DB_Proc @Arg = ?', [$type]);

            $data = collect($rows)->map(fn($r) => (array)$r)
                ->groupBy('Mon_Name')
                ->map(function ($monthGroup) {
                    $units = $monthGroup->groupBy('Unit')->map(function ($unitGroup) {
                        $buyers = $unitGroup->groupBy('Buyer')->map(function ($buyerGroup) {
                            $lines = $buyerGroup->groupBy('Line_No')->map(function ($lineGroup) {
                                return [
                                    'Line_No' => $lineGroup->first()['Line_No'] ?? null,
                                    'line_total_Audit_Qty' => $lineGroup->sum(fn($r) => (int)($r['Qty'] ?? 0)),
                                    'data' => array_values($lineGroup->toArray()),
                                ];
                            })->values()->toArray();
                            return [
                                'Buyer' => $buyerGroup->first()['Buyer'] ?? null,
                                'buyer_total_Audit_Qty' => $buyerGroup->sum(fn($r) => (int)($r['Qty'] ?? 0)),
                                'lines' => $lines,
                            ];
                        })->values()->toArray();
                        return [
                            'Unit' => $unitGroup->first()['Unit'] ?? null,
                            'buyers' => $buyers,
                        ];
                    })->values()->toArray();

                    return [
                        'Mon_Name' => $monthGroup->first()['Mon_Name'] ?? '',
                        'units' => $units,
                    ];
                })->values()->toArray();

            return response()->json(['success' => true, 'data' => $data]);
        } catch (\Throwable $e) {
            Log::error('production_minis_historicaldata failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

	public function production_cutting_historicaldata(Request $request){
        ini_set('memory_limit', '512M');
        try {
            $type = $request->input('type') ?? 1;
            $fdate = $request->input('fromdate') ? Carbon::parse($request->input('fromdate'))->format('d-M-Y') : null;
            $enddate = $request->input('enddate') ? Carbon::parse($request->input('enddate'))->format('d-M-Y') : null;

            $rows = $fdate && $enddate
                ? DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.Cutting_History_DB_Proc @Arg = ?, @Fdate = ?, @Tdate = ?', [$type, $fdate, $enddate])
                : DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.Cutting_History_DB_Proc @Arg = ?', [$type]);

            $data = collect($rows)->map(fn($r) => (array)$r)
                ->groupBy('Mon_Name')
                ->map(function ($monthGroup) {
                    $units = $monthGroup->groupBy('Unit')->map(function ($unitGroup) {
                        $buyers = $unitGroup->groupBy('Buyer')->map(function ($buyerGroup) {
                            return [
                                'Buyer' => $buyerGroup->first()['Buyer'] ?? null,
                                'buyer_total_Audit_Qty' => $buyerGroup->sum(fn($r) => (int)($r['Qty'] ?? 0)),
                                'data' => array_values($buyerGroup->toArray()),
                            ];
                        })->values()->toArray();
                        return [
                            'Unit' => $unitGroup->first()['Unit'] ?? null,
                            'buyers' => $buyers,
                        ];
                    })->values()->toArray();

                    return [
                        'Mon_Name' => $monthGroup->first()['Mon_Name'] ?? '',
                        'units' => $units,
                    ];
                })->values()->toArray();

            return response()->json(['success' => true, 'data' => $data]);
        } catch (\Throwable $e) {
            Log::error('production_cutting_historicaldata failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function linestopminis(Request $request)
    {
        try {
            $fdate = $request->input('fromdate') ? Carbon::parse($request->input('fromdate'))->format('d-M-Y') : Carbon::today()->format('d-M-Y');
            $enddate = $request->input('enddate') ? Carbon::parse($request->input('enddate'))->format('d-M-Y') : $fdate;

            $result = DB::select('exec Chennai_Erp.DBO.Line_Stop_Minis @Fdate = ?, @Tdate = ?', [$fdate, $enddate]);
            $collection = collect($result);

            $units = $collection
                ->groupBy('Unit')
                ->map(function ($unitGroup, $unitName) {
                    $zones = $unitGroup
                        ->groupBy('Zone')
                        ->map(function ($zoneGroup, $zoneName) {
                            $lines = $zoneGroup
                                ->groupBy('Line_No')
                                ->map(function ($lineRows, $lineNo) {
                                    $linesData = $lineRows->map(function ($row) {
                                        $rowArr = (array) $row;
                                        $dateField = $rowArr['DTM_Date'] ?? ($rowArr['Date'] ?? null);
                                        $rowArr['Date'] = $dateField ? Carbon::parse($dateField)->format('d-m-y') : null;
                                        if (!empty($rowArr['Start_Time'])) {
                                            $rowArr['Start_Time'] = Carbon::parse($rowArr['Start_Time'])->format('h:i A');
                                        }
                                        if (!empty($rowArr['End_Time'])) {
                                            $rowArr['End_Time'] = Carbon::parse($rowArr['End_Time'])->format('h:i A');
                                        }
                                        if (isset($rowArr['Tot_DTM'])) {
                                            $rowArr['Tot_DTM'] = (float) $rowArr['Tot_DTM'];
                                        }
                                        return $rowArr;
                                    });

                                    return [
                                        'Line_No' => $lineNo,
                                        'data' => $linesData->values(),
                                    ];
                                })
                                ->values();

                            return [
                                'Zone' => $zoneName,
                                'lines' => $lines,
                            ];
                        })
                        ->values();

                    return [
                        'Unit' => $unitName,
                        'zones' => $zones,
                    ];
                })
                ->values();

            return response()->json([
                'success' => true,
                'units' => $units,
            ]);
        } catch (\Throwable $e) {
            Log::error('linestopminis failed: '.$e->getMessage(), ['trace' => $e->getTraceAsString()]);
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function cuttingreport(Request $request)
    {
        try {
            $unitCode = $request->input('unit_code');
            $fdate = $request->input('fromdate') ? Carbon::parse($request->input('fromdate'))->format('d-M-Y') : Carbon::today()->format('d-M-Y');
            $enddate = $request->input('enddate') ? Carbon::parse($request->input('enddate'))->format('d-M-Y') : $fdate;

            $rows = DB::select('exec Chennai_Erp.DBO.GetCuttingDetails @Fdate = ?, @Tdate = ?', [$fdate, $enddate]);

            $collection = collect($rows)->map(function ($r) { return (array)$r; });

            if (!empty($unitCode)) {
                $collection = $collection->filter(fn($row) => isset($row['Unit']) && $row['Unit'] == $unitCode);
            }

            $units = $collection->groupBy('Unit')->map(function ($unitItems) {
                $unitCutQtySum = $unitItems->sum(fn($item) => (float)($item['Cut_Qty'] ?? 0));
                $machines = $unitItems->groupBy('Machine_type')->map(function ($machineItems) {
                    $machineCutQtySum = $machineItems->sum(fn($item) => (float)($item['Cut_Qty'] ?? 0));
                    return [
                        'Cut_Qty_Sum' => $machineCutQtySum,
                        'data' => $machineItems->values(),
                    ];
                });

                return [
                    'Cut_Qty_Sum' => $unitCutQtySum,
                    'machines' => $machines,
                ];
            });

            return response()->json([
                'success' => true,
                'units' => $units,
            ]);
        } catch (\Throwable $e) {
            Log::error('cuttingreport failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function wipdetail(Request $request)
    {
        try {
            $rows = DB::select('exec VAAHINI_ERP_GAINUP.DBO.WIP_Proc');
            $collection = collect($rows)->map(fn($r) => (array)$r);

            $units = $collection->groupBy('Unit')->map(function ($unitGroup, $unitName) {
                $types = $unitGroup->groupBy('Type')->map(function ($typeGroup, $typeName) {
                    $buyers = $typeGroup->groupBy('Buyer')->map(function ($buyerGroup, $buyerName) {
                        return [
                            'Buyer' => $buyerName,
                            'data'  => $buyerGroup->values(),
                        ];
                    })->values();

                    return [
                        'Type'   => $typeName,
                        'buyers' => $buyers,
                    ];
                })->values();

                return [
                    'Unit'  => $unitName,
                    'types' => $types,
                ];
            })->values();

            return response()->json([
                'success' => true,
                'units'   => $units,
            ]);
        } catch (\Throwable $e) {
            Log::error('wipdetail failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function smstockdetail(Request $request)
    {
        try {
            $rows = DB::select('exec VAAHINI_ERP_GAINUP.DBO.SM_Proc');
            $collection = collect($rows)->map(fn($r) => (array)$r);

            $units = $collection->groupBy('Unit')->map(function ($unitGroup, $unitName) {
                $buyers = $unitGroup->groupBy('Buyer')->map(function ($buyerGroup, $buyerName) {
                    return [
                        'Buyer' => substr($buyerName ?? '', 0, 6),
                        'data'  => $buyerGroup->values(),
                    ];
                })->values();

                return [
                    'Unit'   => $unitName,
                    'buyers' => $buyers,
                ];
            })->values();

            return response()->json([
                'success' => true,
                'units'   => $units,
            ]);
        } catch (\Throwable $e) {
            Log::error('smstockdetail failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function directlabour_details(Request $request)
    {
        try {
            $fdate = $request->input('fromdate')
                ? Carbon::parse($request->input('fromdate'))->format('d-M-Y')
                : Carbon::today()->format('d-M-Y');

            $raw = DB::select('EXEC Vaahini_Erp_Gainup.Dbo.Garments_Emp_Allocation_Proc @Fdate = ?', [$fdate]);
            $rows = collect($raw)->map(fn($r) => (array)$r);

            $units = $rows->groupBy('Unit')->map(function ($unitGroup, $unitName) {
                $zones = $unitGroup->groupBy('Zone')->map(function ($zoneGroup, $zoneName) {
                    return [
                        'Zone' => $zoneName,
                        'Total_Emp_Cnt' => $zoneGroup->sum(fn($it) => (int)($it['Emp_Cnt'] ?? 0)),
                        'data' => $zoneGroup->values(),
                    ];
                })->values();

                return [
                    'Unit' => $unitName,
                    'Unit_Code' => $unitName,
                    'Total_Emp_Cnt' => $unitGroup->sum(fn($it) => (int)($it['Emp_Cnt'] ?? 0)),
                    'zones' => $zones,
                ];
            })->values();

            return response()->json([
                'success' => true,
                'units' => $units,
            ]);
        } catch (\Throwable $e) {
            Log::error('directlabour_details failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function sizeBreakupCutting(Request $request)
    {
        try {
            $layid = $request->input('layid');
            $rows = DB::select('exec VAAHINI_ERP_GAINUP.DBO.SIze_Brkup_Cutting_Proc @Masid = ?', [$layid]);
            return response()->json(['success' => true, 'data' => $rows]);
        } catch (\Throwable $e) {
            Log::error('sizeBreakupCutting failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function getAckBreakdown(Request $request)
    {
        try {
            $layid = $request->input('layid');
            $arg = $request->input('arg');
            $rows = DB::select('exec VAAHINI_ERP_GAINUP.DBO.SIze_Brkup_AckPending_Proc @Masid = ?, @Arg = ?', [$layid, $arg]);
            return response()->json(['success' => true, 'data' => $rows]);
        } catch (\Throwable $e) {
            Log::error('getAckBreakdown failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function smstockissued(Request $request)
    {
        try {
            $ocn = $request->input('ocnno');
            $itemid = $request->input('itemid');
            $colorid = $request->input('colorid');
            $sizeid = $request->input('sizeid');

            $rows = DB::select('CHENNAI_ERP.dbo.Line_Issued_Proc_woven @Order_No = ?, @Itemid = ?, @Colorid = ?, @Sizeid = ?', [$ocn, $itemid, $colorid, $sizeid]);

            $collection = collect($rows)->map(fn($r) => (array)$r);

            $grouped = $collection
                ->groupBy(function ($r) { return (string)($r['Line'] ?? $r['line'] ?? ''); })
                ->map(function ($items, $line) {
                    $sorted = $items->sortByDesc(function ($it) {
                        return Carbon::parse($it['Edate'] ?? $it['Date'] ?? '1970-01-01');
                    })->values();

                    return [
                        'Line' => $line,
                        'Total_Iss_Qty' => $sorted->sum(fn($x) => (int)($x['Iss_Qty'] ?? 0)),
                        'Entries' => $sorted->map(function ($x) {
                            return [
                                'Entry_No' => $x['Entry_No'] ?? $x['Entry'] ?? null,
                                'Line' => (string)($x['Line'] ?? ''),
                                'Iss_Qty' => (int)($x['Iss_Qty'] ?? 0),
                                'Unit' => $x['Unit'] ?? null,
                                'Edate' => $x['Edate'] ?? $x['Date'] ?? null,
                            ];
                        })->all(),
                    ];
                })
                ->values();

            return response()->json(['success' => true, 'data' => $grouped]);
        } catch (\Throwable $e) {
            Log::error('smstockissued failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }

    public function sizerollbreakup(Request $request)
    {
        try {
            $layid = $request->input('layid');
            $rows = DB::select('exec VAAHINI_ERP_GAINUP.DBO.Rollwise_Breakup_Cutting_Proc @Masid = ?', [$layid]);
            return response()->json(['success' => true, 'data' => $rows]);
        } catch (\Throwable $e) {
            Log::error('sizerollbreakup failed: '.$e->getMessage());
            return response()->json(['success' => false, 'message' => 'Failed to load data'], 500);
        }
    }
}