<?php

namespace App\Http\Controllers\LifeAtGainup\Merchandiser;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class RawMaterialController extends Controller

{
    public function raw_material_dashboard()
    {
        return view('LifeAtGainup.Chart.raw_material_dashboard');
    }

    public function index(Request $request)
    {
        $orderno = $request->orderno;
        $type = $request->type;

        $result = DB::select("exec Fiterp1314.Dbo.RM_Primary_Portal_Proc @Ocn = ?", [$orderno]);
        $fabricprocess = DB::select("exec VAAHINI_ERP_GAINUP.dbo.Portal_Fabric_Req_Proc @Ocn = ?", [$orderno]);
        $dashboardresult = DB::select("exec Fiterp1314.Dbo.RM_Primary_Portal_Proc @Ocn = ?, @Type = ?", [$orderno, 1]);

        if (!empty($result)) {

            $collection = collect($result);

            if ($type) {
                if ($type == 'po_delay') {
                    $collection = $collection->where('Po_Iss_Time', 'Delayed');
                }
                if ($type == 'rm_delay') {
                    $collection = $collection->where('Grn_Perc', '<', 100);
                }
                if ($type == 'ret_to_supplier') {
                    $collection = $collection->where('Clr_Status', '=', 6);
                }
            }

            $groupedData = $collection->groupBy('Item_Type')->toArray();

            return $this->sendResponse([
                'success' => true,
                'recordsTotal' => count($result),
                'recordsFiltered' => count($result),
                'draw' => 1,
                'data' => $groupedData,
                'fabricprocess' => $fabricprocess,
                'dashboard' => $dashboardresult,
                'message' => 'details'
            ], 'details');
        }

        return $this->sendError('No data found for the provided order number.', 404);
    }


    public function buyer_ocn_details(Request $request)
    {
        $result = DB::select("Exec Chennai_Erp.Dbo.Line_Planning_Ocn_Proc");

        if (!empty($result)) {
            return $this->sendResponse($result, 'details');
        }

        return $this->sendError('No data found', 404);
    }


    public function materialpostatus(Request $request)
    {
        $orderno = $request->orderno;
        $colorid = $request->colorid;
        $itemid = $request->itemid;
        $sizeid = $request->sizeid;
        $type = $request->type ?? 'NULL';

        $typeinput = $type == 0 ? 'Normal' : 'Special';

        $result = DB::select(
            "EXEC Fiterp1314.Dbo.Po_Detail_RW_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?, @Sizeid = ?, @Type = ?",
            [$orderno, $itemid, $colorid, $sizeid, $typeinput]
        );

        if (!empty($result)) {
            return $this->sendResponse($result, 'details');
        }

        return $this->sendError('No data', 404);
    }


    public function materialgrnstatus(Request $request)
    {
        $orderno = $request->orderno;
        $colorid = $request->colorid;
        $itemid = $request->itemid;
        $sizeid = $request->sizeid;
        $type = $request->type ?? 'NULL';

        $typeinput = $type == 0 ? 'Normal' : 'Special';

        $result = DB::select(
            "EXEC Fiterp1314.Dbo.RM_Grn_Details_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?, @Sizeid = ?, @Type = ?",
            [$orderno, $itemid, $colorid, $sizeid, $typeinput]
        );

        if (!empty($result)) {
            return $this->sendResponse($result, 'details');
        }

        return $this->sendError('No data', 404);
    }


    public function raw_material_commit_history(Request $request)
    {
        $orderno = $request->orderno;
        $itemid = $request->itemid;
        $colorid = $request->colorid;
        $sizeid = $request->sizeid;
        $type = $request->type;

        $result = DB::table('cxo_ck_review_commit_date')
            ->where('ocn_no', $orderno)
            ->where('itemid', $itemid)
            ->where('colorid', $colorid)
            ->where('sizeid', $sizeid)
            ->where('type', $type)
            ->orderBy('id', 'desc')
            ->take(3)
            ->get();

        return response()->json([
            'success' => true,
            'latest_history' => $result,
            'message' => 'details'
        ]);
    }


    public function savecommitment(Request $request)
    {
        $commitDate = $request->commit_date
            ? Carbon::createFromFormat('d-m-y', $request->commit_date)->format('Y-m-d')
            : null;

        DB::table('cxo_ck_review_commit_date')->insert([
            'ocn_no' => $request->orderno,
            'itemid' => $request->itemid,
            'colorid' => $request->colorid,
            'commit_date' => $commitDate,
            'review_comments' => $request->reason,
            'review_date' => now(),
            'added_date' => now(),
            'type' => $request->type,
            'sizeid' => ($request->sizeid !== 'null' && $request->sizeid !== null) ? $request->sizeid : null,
            'emp_id' => $request->emp_id
        ]);

        // Fetch latest record inserted for this combination
        $latest = DB::table('cxo_ck_review_commit_date')
            ->where('ocn_no', $request->orderno)
            ->where('itemid', $request->itemid)
            ->where('colorid', $request->colorid)
            ->where('sizeid', $request->sizeid)
            ->where('type', $request->type)
            ->orderBy('id', 'desc')
            ->first();

        return response()->json([
            'success' => true,
            'latest_history' => $latest,
            'message' => 'Record inserted successfully'
        ]);
    }


    public function fabricProcessDetails(Request $request)
    {
        $orderno = $request->orderno;

        $result = DB::select(
            "EXEC VAAHINI_ERP_GAINUP.Dbo.Process_Po_RM_Proc @Ocn = ?",
            [$orderno]
        );

        if (!empty($result)) {
            return $this->sendResponse($result, 'details');
        }

        return $this->sendError('No data found for the provided order number.', 404);
    }


    public function fabricProcessingDetails(Request $request)
    {
        $orderno = $request->orderno;
        $Processid = $request->process_id;

        $result = DB::select(
            "EXEC VAAHINI_ERP_GAINUP.Dbo.Process_Po_RM_Proc @Ocn = ?, @Processid = ?",
            [$orderno, $Processid]
        );

        if (!empty($result)) {
            return $this->sendResponse($result, 'details');
        }

        return $this->sendError('No data found for the provided order number.', 404);
    }


	public function returnsupplierstatus(Request $request){
        $input = $request->input();
        $response = Http::get(env('API_URL') . 'return-to-supply', $input);
        $res_set = json_decode($response, true);
        return response()->json($res_set);  
    }
    
    // ------------------------------------------------------------------
    // Local response helpers (to avoid undefined sendResponse/sendError)
    // ------------------------------------------------------------------
    protected function sendResponse($result, $message = 'details', $success = true)
    {
        return response()->json([
            'success' => $success,
            'data' => $result,
            'message' => $message,
        ]);
    }

    protected function sendError($message, $code = 400, $data = null)
    {
        return response()->json([
            'success' => false,
            'message' => $message,
            'data' => $data,
        ], $code);
    }
}