<?php

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Support\Str;


class MerchandiserController extends Controller
{

    
    // public function __construct()
    // {
    //     // Seed a static session user for development if not present
    //     if (!Session::has('empl_id')) {
    //         Session::put('empl_id', '47781');
    //         Session::put('emp_name', 'Static User');
    //     }
    // }

    // public function ingest(Request $request)
    // {
    //     $empId = $request->input('emp_id');
    //     $empName = $request->input('emp_name', '');

    //     if (!empty($empId)) {
    //         Session::put('empl_id', $empId);
    //     }
    //     if ($empName !== null) {
    //         Session::put('emp_name', $empName);
    //     }

    //     return redirect()->route('merchandiserdashboard');
    // }

    public function merchandiserdashboard(Request $request)
    {
        if ($request->has('payload')) {
            try {
                $decoded = decrypt($request->query('payload'));
                $qid = $decoded['emp_id'] ?? null;
                $qname = $decoded['emp_name'] ?? null;
            } catch (\Throwable $e) {
                abort(403, 'Invalid or tampered payload');
            }
        } else {
            $qid = $request->query('emp_id');
            $qname = $request->query('emp_name');
        }
        if (!empty($qid)) { Session::put('empl_id', $qid); }
        if ($qname !== null) { Session::put('emp_name', $qname); }
        $empId = Session('empl_id');

        
        $countCacheKey = 'dashboard_counts_' . $empId;

        $countData = Cache::remember($countCacheKey, 86400, function () use ($empId) {

            $id = $empId;
            if ($id == '5108' || $id == '46987' || $id == '51052' || $id == '9549' || $id == '47781') {
                $id = 5545;
            }

            $order_status = 'N';

            $query = 'exec merch_Garments_Order_Details @EmpId = ?';
            $bindings = [$id];

            if ($order_status !== null) {
                $query .= ', @order_status = ?';
                $bindings[] = $order_status;
            }

            $merchcollection = DB::select($query, $bindings);
            $merchCollection = collect($merchcollection);

            $buyerCount = $merchCollection->pluck('Buyer')->unique()->count();
            $totalCount = $merchCollection->count();

            return [
                'buyer' => $buyerCount,
                'total' => $totalCount,
            ];
        });


        
        $capacityCacheKey = 'capacity_plan_2025';

        $capacityData = Cache::remember($capacityCacheKey, 86400, function () {

            // ✅ Query DB instead of API call
            $CapBookQty = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Capacity_Plan_Qty_Mns_Portal_Proc_FinYear @Pivot_Col = ?, @Year=?',
                ['Booked_Qty', 2025]
            );

            $CapBookMis = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Capacity_Plan_Qty_Mns_Portal_Proc_FinYear @Pivot_Col = ?, @Year=?',
                ['Booked_Mins', 2025]
            );

            return [
                'CapBookMis' => $CapBookMis,
                'CapBookQty' => $CapBookQty,
            ];
        });


        
        $buyerCnt = $countData['buyer'];
        $Ocntotal = $countData['total'];
        $capacityMinsArr = $capacityData['CapBookMis'];
        $capacityQtyArr = $capacityData['CapBookQty'];

        
        return view('LifeAtGainup.Merchandiser.merchandiser', compact('buyerCnt', 'Ocntotal', 'capacityMinsArr', 'capacityQtyArr'));
    }

        public function mddashboard(Request $request)
        {
            $empId = Session('empl_id');

            $id = $empId;
            if (in_array($id, ['5108','46987','51052','9549','47781'])) {
                $id = 5545;
            }

            $order_status = 'N';

            $startDate = $request->input('start_date');
            $endDate   = $request->input('end_date');

            if ($startDate && $endDate) {
                $shfromdate = Carbon::createFromFormat('Y-m-d', trim($startDate));
                $shtodate   = Carbon::createFromFormat('Y-m-d', trim($endDate));
            } else {
                $shfromdate = Carbon::now()->subDays(30);
                $shtodate   = Carbon::now();
            }

            $fromconDate = $shfromdate->format('d-M-Y');
            $toconDate   = $shtodate->format('d-M-Y');

            $query = 'exec merch_Garments_Order_Details @EmpId = ?';
            $bindings = [$id];

            if ($startDate && $endDate) {
                $query .= ', @Shipstart_date = ?, @Shipend_date = ?';
                $bindings[] = $fromconDate;
                $bindings[] = $toconDate;
            }

            if ($order_status !== null) {
                $query .= ', @order_status = ?';
                $bindings[] = $order_status;
            }

            $merchcollection = DB::select($query, $bindings);
            $merchCollection = collect($merchcollection);

            $uniqueMerch      = $merchCollection->pluck('Merch')->unique()->values();
            $uniqueMerchArray = $uniqueMerch->toArray();
            $filteredOrders   = $uniqueMerchArray;

            $separatedMerchBuyers = [];

            foreach ($filteredOrders as $merch) {

                $query = 'exec merch_Garments_Order_Details @EmpId = ?, @order_status = ?, @Merch = ?';
                $bindings = [$id, 'N', $merch];

                if ($startDate && $endDate) {
                    $query .= ', @Shipstart_date = ?, @Shipend_date = ?';
                    $bindings[] = $fromconDate;
                    $bindings[] = $toconDate;
                }

                $buyercollection = DB::select($query, $bindings);
                $buyercollection = collect($buyercollection);

                $buyersArr = $buyercollection->pluck('Buyer')->unique()->values()->toArray();

                $order_qty = [];
                $shipped_qty = [];
                $totalorder = [];

                foreach ($buyersArr as $buyer) {

                    $query = 'exec merch_Garments_Order_Details @EmpId = ?, @order_status = ?, @Merch = ?, @Buyer = ?';
                    $bindings = [$id, 'N', $merch, $buyer];

                    if ($startDate && $endDate) {
                        $query .= ', @Shipstart_date = ?, @Shipend_date = ?';
                        $bindings[] = $fromconDate;
                        $bindings[] = $toconDate;
                    }

                    $buyerwise = DB::select($query, $bindings);
                    $totalorder[] = count($buyerwise);

                    foreach ($buyerwise as $r) {
                        $order_qty[]   = $r->Order_Qty;
                        $shipped_qty[] = $r->Shipped_Qty;
                    }
                }

                $separatedMerchBuyers[] = [
                    'merch'       => $merch,
                    'buyers'      => count($buyersArr),
                    'order_qty'   => array_sum($order_qty),
                    'shipped_qty' => array_sum($shipped_qty),
                    'pending'     => array_sum($totalorder),
                ];
            }

            $data = [
                'success' => true,
                'data'    => [
                    'merch_buyers' => $separatedMerchBuyers
                ]
            ];

            if ($request->ajax()) {
                return response()->json($data);
            }

            return view('LifeAtGainup.Merchandiser.merchandiser', [
                'mddata' => $data
            ]);
        }



    public function merchandiserorderbeta(Request $request)
    {
        // Fetch all the data from the API
	
        $inputdata = $request->input();
        if (empty($inputdata)) {
            $inputdata = [
                'emp_id' => Session('empl_id'),
                'order_status' => 'N',
                
                
            ];  
        }
        // Fetch all the data from the API
        $response = Http::get(env('API_URL').'merchandiser',$inputdata);
        //dd($response);
        $res_set = json_decode($response, true);
        $result = $res_set['data'];

        // Collect all buyers (before filtering) for the dropdown
        $allBuyers = collect($result)->pluck('buyer')->unique();
        $uniquePO = collect($result)->pluck('buyer_po')->unique();

        // On initial page load, filter by order_status = 'N' if no status is selected
        if (!$request->has('order_status') || $request->input('order_status') == 'N') {
            $result = array_filter($result, function ($item) {
                return $item['order_status'] === 'N';
            });
        }

        // Apply other filters if present
        if ($request->filled('buyer_name')) {
            $buyerName = $request->input('buyer_name');
            $result = array_filter($result, function ($item) use ($buyerName) {
                return $item['buyer'] === $buyerName;
            });
        }
        if ($request->filled('file_status')) {
            $file_status = $request->input('file_status');
            $result = array_filter($result, function ($item) use ($file_status) {
                return $item['file_status'] === $file_status;
            });
        }

        if ($request->filled('uniquePO')) {
            $uniquePO = $request->input('uniquePO');
            $result = array_filter($result, function ($item) use ($uniquePO) {
                return $item['buyer_po'] === $uniquePO;
            });
        }

        if ($request->filled('ocn_no')) {
            $ocn_no = $request->input('ocn_no');
            $result = array_filter($result, function ($item) use ($ocn_no) {
                return $item['order_no'] === $ocn_no;
            });
        }

        if ($request->filled('order_status')) {
            $orderStatus = $request->input('order_status');
            if ($orderStatus != 'all') {
                $result = array_filter($result, function ($item) use ($orderStatus) {
                    return $item['order_status'] === $orderStatus;
                });
            }else{
               $orderStatus = 'N' ;
            }
        }

        // Return the filtered data and all unique buyers
        if ($request->ajax()) {
            return response()->json([
                'result' => $result,
                'allBuyers' => $allBuyers, // Send all buyers to the frontend
            ]);
        }

        // Render the view with all unique buyers
        return view('LifeAtGainup.Merchandiser.merchandiserorder', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }

    public function merchandiserorder(Request $request)
    {


        $empId = Session('empl_id');        
        if ($request->ajax()) {
            // Build params as in API controller merchandiserbeta_new
            $queryArray = $request->all();
            $Buyer_name   = !empty($queryArray['buyer_name']) ? str_replace('---','&',$queryArray['buyer_name']) : null;
            $Order_No     = !empty($queryArray['ocn_no']) ? $queryArray['ocn_no'] : null;
            $Order_Status = !empty($queryArray['order_status']) ? $queryArray['order_status'] : null;
            $fileStaus    = !empty($queryArray['file_status']) ? $queryArray['file_status'] : null;
            $empid        = !empty($queryArray['emp_id']) ? $queryArray['emp_id'] : Session('empl_id');
            $loadid       = !empty($queryArray['id']) ? $queryArray['id'] : null;
            $order_date_s = !empty($queryArray['order_date']) ? $queryArray['order_date'] : null;
            $shipment_s   = !empty($queryArray['shipment_date']) ? $queryArray['shipment_date'] : null;
            $ckdatesplit  = !empty($queryArray['kit_date']) ? $queryArray['kit_date'] : null;

            $ckdate = ($ckdatesplit!='' && $ckdatesplit!=null) ? explode('to', $ckdatesplit) : null;
            $shipment_date = ($shipment_s!='' && $shipment_s!=null) ? explode('to', $shipment_s) : null;
            $order_date = ($order_date_s!='' && $order_date_s!=null) ? explode('to', $order_date_s) : null;

            if (isset($ckdate)) {
                $fromdate = Carbon::createFromFormat('d-m-Y', trim($ckdate[0]));
                $todate   = Carbon::createFromFormat('d-m-Y', trim(isset($ckdate[1])?$ckdate[1]:$ckdate[0]));
                $fromconDate = $fromdate->format('d-M-Y');
                $toconDate   = $todate->format('d-M-Y');
            }
            if (isset($shipment_date)) {
                $shfromdate = Carbon::createFromFormat('d-m-Y', trim($shipment_date[0]));
                $shtodate   = Carbon::createFromFormat('d-m-Y', trim(isset($shipment_date[1])?$shipment_date[1]:$shipment_date[0]));
                $fromconDate = $shfromdate->format('d-M-Y');
                $toconDate   = $shtodate->format('d-M-Y');
            }
            if (isset($order_date)) {
                $orfromdate = Carbon::createFromFormat('d-m-Y', trim($order_date[0]));
                $ortodate   = Carbon::createFromFormat('d-m-Y', trim(isset($order_date[1])?$order_date[1]:$order_date[0]));
                $orfromconDate = $orfromdate->format('d-M-Y');
                $ortoconDate   = $ortodate->format('d-M-Y');
            }

            $id = $empid;
            if ($id == '47781' || $id == '51052') { $id = 5545; }

            $query = 'exec merch_Garments_Order_Details_new_Sync  @EmpId = ?';
            $bindings = [$id];
            if ($fileStaus !== null) { $query .= ', @File_Status = ?'; $bindings[] = $fileStaus; }
            if ($Order_Status !== null) { $query .= ', @Order_Status = ?'; $bindings[] = $Order_Status; }
            if (isset($ckdate)) { $query .= ', @ckstart_date = ?, @ckend_date = ?'; $bindings[] = $fromconDate; $bindings[] = $toconDate; }
            if (isset($shipment_date)) { $query .= ', @Shipstart_date = ?, @Shipend_date = ?'; $bindings[] = $fromconDate; $bindings[] = $toconDate; }
            if (isset($order_date)) { $query .= ', @Orderstart_date = ?, @Orderend_date = ?'; $bindings[] = $orfromconDate; $bindings[] = $ortoconDate; }
            if ($Buyer_name !== null) { $query .= ', @Buyer = ?'; $bindings[] = $Buyer_name; }

            try {
                $merchcollection = DB::select($query, $bindings);
            } catch (\Throwable $e) {
                Log::error('merchandiserorder DB error: '.$e->getMessage());
                $merchcollection = [];
            }
            return response()->json(['data' => ['listdata' => $merchcollection]]);
        }
        $allBuyers=[];
        $uniquePO=[];

        // Render the view with all unique buyers
        return view('LifeAtGainup.Merchandiser.merchandiserorderbeta1', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);

        // $inputdata = $request->input();
    
        // if (empty($inputdata)) {
        //     $inputdata = [
        //         'emp_id' => Session('empl_id'),
        //         'order_status' => 'N',
        //     ];
        // }
    
        // // 🔑 Create a unique cache key based on employee and query params
        // $cacheKey = 'merch_order_' . Session('empl_id') . '_' . md5(json_encode($inputdata));
    
        // try {
        //     // ⚡ Cache the API response for 1 day (86400 seconds)
        //     $res_set = Cache::remember($cacheKey, 600, function () use ($inputdata) {
        //         $response = Http::get(env('API_URL') . 'merchandiser', $inputdata);
        //         if ($response->successful()) {
        //             return json_decode($response, true);
        //         } else {
        //             Log::error('Merchandiser API Error: ' . $response->body());
        //             return ['data' => []];
        //         }
        //     });
    
        //     $result = $res_set['data'] ?? [];
    
        //     // 👕 Extract unique values for filters
        //     $allBuyers = collect($result)->pluck('buyer')->unique();
        //     $uniquePO = collect($result)->pluck('buyer_po')->unique();
    
        //     // 🧹 Filters (as usual)
        //     if (!$request->has('order_status') || $request->input('order_status') == 'N') {
        //         $result = array_filter($result, fn($item) => $item['order_status'] === 'N');
        //     }
    
        //     if ($request->filled('buyer_name')) {
        //         $buyerName = $request->input('buyer_name');
        //         $result = array_filter($result, fn($item) => $item['buyer'] === $buyerName);
        //     }
    
        //     if ($request->filled('file_status')) {
        //         $file_status = $request->input('file_status');
        //         $result = array_filter($result, fn($item) => $item['file_status'] === $file_status);
        //     }
    
        //     if ($request->filled('uniquePO')) {
        //         $po = $request->input('uniquePO');
        //         $result = array_filter($result, fn($item) => $item['buyer_po'] === $po);
        //     }
    
        //     if ($request->filled('ocn_no')) {
        //         $ocn_no = $request->input('ocn_no');
        //         $result = array_filter($result, fn($item) => $item['order_no'] === $ocn_no);
        //     }
    
        //     // if ($request->filled('order_status')) {
        //     //     $orderStatus = $request->input('order_status');
        //     //     if ($orderStatus !== 'all') {
        //     //         $result = array_filter($result, fn($item) => $item['order_status'] === $orderStatus);
        //     //     }
        //     // }
    
        //     // ⚡ If it's AJAX, return JSON
        //     if ($request->ajax()) {
        //         return response()->json([
        //             'result' => array_values($result), // reindex after filtering
        //             'allBuyers' => $allBuyers,
        //         ]);
        //     }
    
        //     // 🖥️ Else render full view
        //     return view('LifeAtGainup.Merchandiser.merchandiserorderbeta1', [
        //         'uniqueBuyers' => $allBuyers,
        //         'uniquePO' => $uniquePO,
        //     ]);
    
        // } catch (\Exception $e) {
        //     Log::error('MerchandiserOrder Controller Error: ' . $e->getMessage());
        //     return response()->json(['error' => 'Something went wrong, contact support.'], 500);
        // }
    }

    public function merchandiserorder_new(Request $request)
    {
        $empId = Session('empl_id');

        if ($request->ajax()) {
            $queryArray = $request->all();

            $Buyer_name   = !empty($queryArray['buyer_name']) ? str_replace('---', '&', $queryArray['buyer_name']) : null;
            $Order_No     = !empty($queryArray['ocn_no']) ? $queryArray['ocn_no'] : null;
            $Order_Status = !empty($queryArray['order_status']) ? $queryArray['order_status'] : null;
            $fileStaus    = !empty($queryArray['file_status']) ? $queryArray['file_status'] : null;
            $empid        = !empty($queryArray['emp_id']) ? $queryArray['emp_id'] : Session('empl_id');
            $order_date_s = !empty($queryArray['order_date']) ? $queryArray['order_date'] : null;
            $shipment_s   = !empty($queryArray['shipment_date']) ? $queryArray['shipment_date'] : null;
            $ckdatesplit  = !empty($queryArray['kit_date']) ? $queryArray['kit_date'] : null;

            $ckdate = ($ckdatesplit != '' && $ckdatesplit != null) ? explode('to', $ckdatesplit) : null;
            $shipment_date = ($shipment_s != '' && $shipment_s != null) ? explode('to', $shipment_s) : null;
            $order_date = ($order_date_s != '' && $order_date_s != null) ? explode('to', $order_date_s) : null;

            if (isset($ckdate)) {
                $fromdate = Carbon::createFromFormat('d-m-Y', trim($ckdate[0]));
                $todate = Carbon::createFromFormat('d-m-Y', trim(isset($ckdate[1]) ? $ckdate[1] : $ckdate[0]));
                $fromconDate = $fromdate->format('d-M-Y');
                $toconDate = $todate->format('d-M-Y');
            }

            if (isset($shipment_date)) {
                $shfromdate = Carbon::createFromFormat('d-m-Y', trim($shipment_date[0]));
                $shtodate = Carbon::createFromFormat('d-m-Y', trim(isset($shipment_date[1]) ? $shipment_date[1] : $shipment_date[0]));
                $fromconDate = $shfromdate->format('d-M-Y');
                $toconDate = $shtodate->format('d-M-Y');
            }

            if (isset($order_date)) {
                $orfromdate = Carbon::createFromFormat('d-m-Y', trim($order_date[0]));
                $ortodate = Carbon::createFromFormat('d-m-Y', trim(isset($order_date[1]) ? $order_date[1] : $order_date[0]));
                $orfromconDate = $orfromdate->format('d-M-Y');
                $ortoconDate = $ortodate->format('d-M-Y');
            }

            $id = $empid;
            if (in_array($id, ['5108', '46987', '51052', '9549', '47781'])) {
                $id = 5545;
            }

            // ✅ Same Stored Procedure as in merchandiserbeta
            $query = 'exec merch_Garments_Order_Details_New @EmpId = ?';
            $bindings = [$id];

            if (isset($ckdate)) {
                $query .= ', @ckstart_date = ?, @ckend_date = ?';
                $bindings[] = $fromconDate;
                $bindings[] = $toconDate;
            }

            if (isset($shipment_date)) {
                $query .= ', @Shipstart_date = ?, @Shipend_date = ?';
                $bindings[] = $fromconDate;
                $bindings[] = $toconDate;
            }

            if (isset($order_date)) {
                $query .= ', @Orderstart_date = ?, @Orderend_date = ?';
                $bindings[] = $orfromconDate;
                $bindings[] = $ortoconDate;
            }

            if ($Order_Status !== null) {
                $query .= ', @order_status = ?';
                $bindings[] = $Order_Status;
            }

            if ($Order_No !== null) {
                $query .= ', @Order_No = ?';
                $bindings[] = $Order_No;
            }

            if ($Buyer_name !== null) {
                $query .= ', @Buyer = ?';
                $bindings[] = $Buyer_name;
            }

            if ($fileStaus !== null) {
                $query .= ', @File_Status = ?';
                $bindings[] = $fileStaus;
            }

            // ✅ Optional filters used in merchandiserbeta
            $filter = isset($queryArray['filter']) ? $queryArray['filter'] : null;
            if ($filter !== null) {
                $query .= ', @Filter = ?';
                $bindings[] = $filter;
            }

            try {
                $merchcollection = DB::select($query, $bindings);
            } catch (\Throwable $e) {
                Log::error('merchandiserorder_new DB error: ' . $e->getMessage());
                $merchcollection = [];
            }

            // ✅ Return same JSON structure as merchandiserbeta
            return response()->json([
                'success' => true,
                'message' => 'Data loaded successfully',
                'data' => [
                    'listdata' => $merchcollection,
                    'reportlist' => []
                ]
            ]);
        }

        $allBuyers = [];
        $uniquePO = [];

        return view('LifeAtGainup.Merchandiser.merchandiserorderbeta1', [
            'uniqueBuyers' => $allBuyers,
            'uniquePO' => $uniquePO,
        ]);
    }


    // public function merchandiserorder_new(Request $request)
    // {
    //     $empId = Session('empl_id');        

    //     $queryArray = $request->all();
    //     $Buyer_name   = !empty($queryArray['buyer_name']) ? str_replace('---','&',$queryArray['buyer_name']) : null;
    //     $Order_No     = !empty($queryArray['ocn_no']) ? $queryArray['ocn_no'] : null;
    //     $Order_Status = !empty($queryArray['order_status']) ? $queryArray['order_status'] : null;
    //     $fileStaus    = !empty($queryArray['file_status']) ? $queryArray['file_status'] : null;
    //     $empid        = !empty($queryArray['emp_id']) ? $queryArray['emp_id'] : Session('empl_id');
    //     $order_date_s = !empty($queryArray['order_date']) ? $queryArray['order_date'] : null;
    //     $shipment_s   = !empty($queryArray['shipment_date']) ? $queryArray['shipment_date'] : null;
    //     $ckdatesplit  = !empty($queryArray['kit_date']) ? $queryArray['kit_date'] : null;

    //     $ckdate = ($ckdatesplit!='' && $ckdatesplit!=null) ? explode('to', $ckdatesplit) : null;
    //     $shipment_date = ($shipment_s!='' && $shipment_s!=null) ? explode('to', $shipment_s) : null;
    //     $order_date = ($order_date_s!='' && $order_date_s!=null) ? explode('to', $order_date_s) : null;

    //     if (isset($ckdate)) { 
    //         $fromdate = Carbon::createFromFormat('d-m-Y', trim($ckdate[0])); 
    //         $todate = Carbon::createFromFormat('d-m-Y', trim(isset($ckdate[1])?$ckdate[1]:$ckdate[0])); 
    //         $fromconDate=$fromdate->format('d-M-Y'); 
    //         $toconDate=$todate->format('d-M-Y'); 
    //     }
    //     if (isset($shipment_date)) { 
    //         $shfromdate = Carbon::createFromFormat('d-m-Y', trim($shipment_date[0])); 
    //         $shtodate = Carbon::createFromFormat('d-m-Y', trim(isset($shipment_date[1])?$shipment_date[1]:$shipment_date[0])); 
    //         $fromconDate=$shfromdate->format('d-M-Y'); 
    //         $toconDate=$shtodate->format('d-M-Y'); 
    //     }
    //     if (isset($order_date)) { 
    //         $orfromdate = Carbon::createFromFormat('d-m-Y', trim($order_date[0])); 
    //         $ortodate = Carbon::createFromFormat('d-m-Y', trim(isset($order_date[1])?$order_date[1]:$order_date[0])); 
    //         $orfromconDate=$orfromdate->format('d-M-Y'); 
    //         $ortoconDate=$ortodate->format('d-M-Y'); 
    //     }

    //     $id = $empid; 
    //     if (in_array($id, ['5108', '46987', '51052', '9549', '47781'])) { 
    //         $id = 5545; 
    //     }

    //     $query = 'exec merch_Garments_Order_Details  @EmpId = ?';
    //     $bindings = [$id];

    //     if (isset($ckdate)) { $query .= ', @ckstart_date = ?, @ckend_date = ?'; $bindings[] = $fromconDate; $bindings[] = $toconDate; }
    //     if (isset($shipment_date)) { $query .= ', @Shipstart_date = ?, @Shipend_date = ?'; $bindings[] = $fromconDate; $bindings[] = $toconDate; }
    //     if (isset($order_date)) { $query .= ', @Orderstart_date = ?, @Orderend_date = ?'; $bindings[] = $orfromconDate; $bindings[] = $ortoconDate; }
    //     if ($Order_Status !== null) { $query .= ', @order_status = ?'; $bindings[] = $Order_Status; }
    //     if ($Order_No !== null) { $query .= ', @Order_No = ?'; $bindings[] = $Order_No; }
    //     if ($Buyer_name !== null) { $query .= ', @Buyer = ?'; $bindings[] = $Buyer_name; }
    //     if ($fileStaus !== null) { $query .= ', @File_Status = ?'; $bindings[] = $fileStaus; }

    //     try { 
    //         $merchcollection = DB::select($query, $bindings); 
    //     } catch (\Throwable $e) { 
    //         Log::error('merchandiserorder_new DB error: '.$e->getMessage()); 
    //         $merchcollection = []; 
    //     }

    //     $responseData = [
    //         'data' => [
    //             'listdata' => $merchcollection,
    //             'reportlist' => [],
    //         ],
    //     ];

    //     // ✅ Always return JSON
    //     return response()->json($responseData);
    // }



    public function merchandiserorder_beta_new(Request $request)
    {

       
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input); 
            $apiUrl = env('API_URL') . 'merchandiserbeta_new/abc=1&' . $cleanedString;
            $response = Http::get($apiUrl);

            //dd($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        $allBuyers=[];
        $uniquePO=[];

        // Render the view with all unique buyers
        return view('LifeAtGainup.Merchandiser.merchandiserorderbeta_1', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }

    public function optcommonsearch_portal(Request $request)
    {
        // DB-backed search for unit list, buyer list, and report list
        $empId = $request->empId;
        $Unitresults = DB::table('VAAHINI_ERP_GAINUP.DBO.company_Unit()')
            ->select('Unit_Short_Name', 'Compcode as Unit_Code')
            ->where('Compname', 'like', '%gar%')
            ->whereNotIn('Compcode', [5])
            ->get();
        $Buyerresults = DB::select('exec VAAHINI_ERP_GAINUP.DBO.Buyer_Dtls_Proc_For_Portal  @Emplno = ?', [$empId]);
        $buyers = [];
        foreach ($Buyerresults as $row) { $buyers[] = ['buyer' => $row->Buyer]; }
        $reportlist = DB::table('report_custom_setting')->orderBy('id', 'desc')
            ->where('emp_id', $empId)
            ->where('portal_id', $request->portal_id)
            ->get();
        return response()->json(['data' => ['unitlist' => $Unitresults, 'buyerlist' => $buyers, 'reportlist' => $reportlist]]);
    }



    public function getOcnByBuyer(Request $request)
    {
        $buyerName = $request->input('buyer_name');
        $orderStatus = $request->input('order_status');
        $file_Status = $request->input('file_status');

        $inputdata = [
            'emp_id' => Session('empl_id'),
            'order_status' => $orderStatus,
            'buyer_name'    => $buyerName,
            'file_status' => $file_Status,

            
        ]; 

        $response = Http::get(env('API_URL').'merchandiser',$inputdata);
        $res_set = json_decode($response, true);
        $result = $res_set['data'];

        // Filter based on both buyer name and order status
        $ocnNumbers = collect($result)
                        ->when($buyerName, function ($query) use ($buyerName) {
                            return $query->where('buyer', $buyerName);
                        })
                        ->when($orderStatus && $orderStatus !== 'all', function ($query) use ($orderStatus) {
                            return $query->where('order_status', $orderStatus);
                        })
                        ->when($file_Status, function ($query) use ($file_Status) {
                            return $query->where('file_status', $file_Status);
                        })
                        ->pluck('order_no')
                        ->unique();

        return response()->json($ocnNumbers);
    }
    //Dashboard log
    public function userlogmerch_opt(Request $request)
    {
        $emp_id = $request->emp_id;

        $logdata = DB::select(
            'exec Merch_Operation_usage_analysis_Proc @EmpCode = ?',
            [$emp_id]
        );

        return response()->json([
            'success' => true,
            'message' => 'list',
            'data'    => $logdata
        ]);
    }




    public function merchlayout(Request $request)
    {
        $ocno = $request->orderNo;

        if (!$ocno) {
            return response()->json([
                'success' => false,
                'message' => 'Order number is required',
                'data' => []
            ], 400);
        }

        $ocnNo = Str::replace("-", "\\", $ocno);
        $data = DB::select('exec Merch_Port_Stylesheet ?', [$ocnNo]);

        return response()->json([
            'success' => true,
            'message' => 'List fetched successfully.',
            'data' => $data
        ]);
    }

    public function alertinfo(Request $request)
    {
        $ocno = str_replace('-', '\\', $request->orderNo);

        $notificationdata = DB::select('EXEC Merch_Port_Alert_Details_Proc ?', [$ocno]);

        return response()->json([
            'success' => true,
            'message' => 'Alert details fetched successfully.',
            'data' => $notificationdata
        ]);
    }

    public function timetoaction(Request $request)
    {
        // Get OCN number and replace '-' with '\'
        $ocnno = Str::replace('-', '\\', $request->orderNo);

        // Execute the stored procedure directly
        $merchproductcollection = DB::select(
            'exec VAAHINI_ERP_GAINUP.dbo.Time_Action_Proc @Ocn = ?',
            [$ocnno]
        );

        // Return the response in the same structure as Timetoaction()
        return response()->json([
            'success' => true,
            'message' => 'Product list.',
            'data' => $merchproductcollection,
        ]);
    }


    public function rawmaterialstatus(Request $request)
    {
        // Get OCN number and replace '-' with '\'
        $ocnno = Str::replace('-', '\\', $request->orderNo);

        // Execute stored procedure directly
        $merchproductcollection = DB::select(
            'exec VAAHINI_ERP_GAINUP.dbo.Merch_Portal_Rawmaterial_Status_Proc @Ocn = ?',
            [$ocnno]
        );

        // Return consistent JSON response
        return response()->json([
            'success' => true,
            'message' => 'Product list.',
            'data'    => $merchproductcollection,
        ]);
    }


     //budgetstatus popup
    public function budgetstatus(Request $request)
    {
        // Get OCN number and replace '-' with '\'
        $ocnno = Str::replace('-', '\\', $request->orderNo);

        // Execute the same stored procedures as in Budgetstatus()
        $merchcollection = DB::select(
            'exec VAAHINI_ERP_GAINUP.dbo.Merch_Portal_Budget_Proc @Ocn = ?',
            [$ocnno]
        );

        $appstrike = DB::select(
            'exec VAAHINI_ERP_GAINUP.dbo.Merch_Portal_Budget_Proc @Ocn = ?, @Sum = ?',
            [$ocnno, 1]
        );

        $mdappstrike = DB::select(
            'exec VAAHINI_ERP_GAINUP.dbo.Budget_Summary_Proc_Merch_Portal @Ocn = ?',
            [$ocnno]
        );

        // Combine results
        $result = [
            'appstrike'   => $appstrike,
            'listdata'    => $merchcollection,
            'mdappstrike' => $mdappstrike,
        ];

        // Return consistent JSON response
        return response()->json([
            'success' => true,
            'message' => 'audit list.',
            'data'    => $result,
        ]);
    }



    //production status popup

    public function productstatus(Request $request)
    {
        $ocno = $request->orderNo;

        // Replace "-" with "\" to match ERP format
        $replacedText = Str::replace("-", "\\", $ocno);
        $ocno = $replacedText;

        // Execute stored procedure directly
        $data = DB::select(
            'EXEC VAAHINI_ERP_GAINUP.DBO.Merch_Portal_Prod_Status_Proc @Ocn = ?',
            [$ocno]
        );

        // Return JSON response (consistent with sendResponse style)
        return response()->json([
            'success' => true,
            'message' => 'Product list.',
            'data' => $data
        ]);
    }


    public function sizebreakup(Request $request)
    {
        $ocno = $request->orderNo;

        // Replace hyphen with backslash like the first function
        $replacedText = Str::replace("-", "\\", $ocno);
        $ocno = $replacedText;

        // Execute stored procedure directly
        $sizebreakup = DB::select(
            'EXEC VAAHINI_ERP_GAINUP.DBO.Merch_Portal_Prod_Status_Proc_Sizewise ?',
            [$ocno]
        );

        // Return JSON response in same structure
        return response()->json([
            'success' => true,
            'message' => 'list.',
            'data' => $sizebreakup
        ]);
    }


    public function Process_Po_Summary_Proc(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'processposum'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function Process_Po_Detail_Proc(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'processpoitemdet'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function Process_Po_Summary_Proc_new(Request $request)
    {
        // Get parameter from request
        $ocnNo = $request->orderNo;

        // Replace '-' with '\'
        $replacedText = Str::replace("-", "\\", $ocnNo);
        $ocnNo = $replacedText;

        // Execute both stored procedures directly
        $list['FabricReq'] = DB::select('exec VAAHINI_ERP_GAINUP.dbo.Portal_Fabric_Req_Proc ?', [$ocnNo]);
        $list['sizebreakup'] = DB::select('exec VAAHINI_ERP_GAINUP.dbo.Process_Po_Summary_Proc_New ?', [$ocnNo]);

        // Return JSON response in same format as sendResponse()
        return response()->json([
            'success' => true,
            'message' => 'list.',
            'data' => $list,
        ]);
    }


    public function Process_Po_Detail_Proc_new(Request $request){
        $ocno = $request->orderNo;
        $id = $request->id;
        $response = Http::get(env('API_URL').'processpoitemdet_new'.'/'.$ocno.'/'.$id);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
    }
 
    public function buyerpostatus(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'buyerpostatus'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function buyerpostatussummary(Request $request)
    {
        // Get parameter (same as ocnno used in the first function)
        $ocnno = $request->ocnno;

        // first: table-valued function
        $Unitresults = DB::select(
            "SELECT * FROM VAAHINI_ERP_GAINUP.DBO.Idwise_Breakup_Summary_Fn(?)",
            [$ocnno]
        );

        // second: stored procedure
        $unittitle = DB::select(
            "exec FITERP1314.dbo.OCN_Pack_Pcs_UOm_Proc ?",
            [$ocnno]
        );

        // return both results (same response format)
        return response()->json([
            'success' => true,
            'message' => 'result data',
            'data' => [
                'unit_results' => $Unitresults,
                'unit_title'   => $unittitle,
            ],
        ]);
    }


    public function sizewisepobreakup(Request $request)
    {
        $ocnno = $request->ocnno;
        $pono = $request->pono;

        // Execute the same stored procedure used in operationdetailsidwisedetails
        $sizebreakup = DB::select(
            'exec VAAHINI_ERP_GAINUP.DBO.Idwise_Breakup_Detail_Proc ?,?,?',
            [$ocnno, $pono, 'Ord_Qty']
        );

        // Return the same type of response
        return response()->json([
            'success' => true,
            'message' => ' list.',
            'data' => $sizebreakup,
        ]);
    }


    public function cutpendingdetails(Request $request)
    {
        try {
            $ocnno = $request->ocnno;

            if (!$ocnno) {
                return response()->json([
                    'status'  => false,
                    'message' => 'Missing parameter: ocnno',
                ], 400);
            }

            // ✅ Unique cache key for each OCN number
            $cacheKey = "cut_pending_details_{$ocnno}";

            // ✅ Cache result for 10 minutes (same logic as main function)
            $data = Cache::remember($cacheKey, now()->addMinutes(10), function () use ($ocnno) {
                return DB::select(
                    'EXEC VAAHINI_ERP_GAINUP.DBO.Merch_Cutting_Details_OCN_Proc @Ocn = ?',
                    [$ocnno]
                );
            });

            return response()->json([
                'status'  => true,
                'message' => 'Cutting pending details fetched successfully.',
                'data'    => $data,
            ]);
        } catch (\Exception $e) {
            // ✅ Log error for debugging
            Log::error('Error fetching cut pending details: ' . $e->getMessage(), [
                'ocnno' => $request->ocnno,
                'trace' => $e->getTraceAsString(),
            ]);

            return response()->json([
                'status'  => false,
                'message' => 'Failed to load cutting pending details.',
            ], 500);
        }
    }


    public function ocn_cutpendingdetails(Request $request)
    {
        try {
            $ocnno   = trim($request->ocnno);
            $itemid  = $request->itemid;
            $colorid = $request->colorid;

            if (empty($ocnno)) {
                return response()->json([
                    'status'  => false,
                    'message' => 'Missing or invalid parameter: ocnno'
                ], 400);
            }

            // ✅ Create a unique cache key for each combination
            $cacheKey = "ocn_cut_pending_details_{$ocnno}_{$itemid}_{$colorid}";

            // ✅ Cache the result for 10 minutes
            $data = Cache::remember($cacheKey, now()->addMinutes(10), function () use ($ocnno, $itemid, $colorid) {
                return DB::select(
                    'SELECT * FROM VAAHINI_ERP_GAINUP.DBO.Cutting_Details_Main_Fn() WHERE Order_No = ? AND Item_Code = ? AND Colorid = ?',
                    [$ocnno, $itemid, $colorid]
                );
            });

            // ✅ Return consistent response
            return response()->json([
                'status'  => true,
                'message' => 'OCN Cut Pending Details fetched successfully.',
                'cached'  => Cache::has($cacheKey),
                'data'    => $data,
            ]);

        } catch (\Exception $e) {
            // ✅ Log detailed error
            Log::error('❌ Error in ocn_cutpendingdetails', [
                'ocnno'   => $request->ocnno,
                'message' => $e->getMessage(),
                'trace'   => $e->getTraceAsString(),
            ]);

            return response()->json([
                'status'  => false,
                'message' => 'Failed to fetch OCN Cut Pending Details.',
                'error'   => $e->getMessage(),
            ], 500);
        }
    }


    public function rollcheckdetails(Request $request){
        $inputdata = $request->input();
        $response = Http::GET(env('API_URL') . 'rollcheckdetails', $inputdata);
       
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function fabricrolldetails(Request $request){
        $inputdata = $request->input();
        $response = Http::GET(env('API_URL') . 'fabricrolldetails', $inputdata);
       
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function ooptcommonsearch_portal(Request $request)
    {
        // Direct DB-backed equivalent of optcommonsearch_portal
        $empId = $request->empId ?: Session('empl_id');
        $portalId = $request->portal_id ?: 2;

        $Unitresults = DB::table('VAAHINI_ERP_GAINUP.DBO.company_Unit()')
            ->select('Unit_Short_Name', 'Compcode as Unit_Code')
            ->where('Compname', 'like', '%gar%')
            ->whereNotIn('Compcode', [5])
            ->get();

        $Buyerresults = DB::select('exec VAAHINI_ERP_GAINUP.DBO.Buyer_Dtls_Proc_For_Portal  @Emplno = ?', [$empId]);
        $buyers = [];
        foreach ($Buyerresults as $row) {
            $buyers[] = ['buyer' => $row->Buyer];
        }

        $reportlist = DB::table('report_custom_setting')->orderBy('id', 'desc')
            ->where('emp_id', $empId)
            ->where('portal_id', $portalId)
            ->get();

        return response()->json(['data' => [
            'unitlist' => $Unitresults,
            'buyerlist' => $buyers,
            'reportlist' => $reportlist
        ]]);
    }

    public function merchlistreport(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'merchlistreport'.'/'.$ocno);       
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function viewreportitem(Request $request){
        $ocno = $request->reportid;
        $response = Http::get(env('API_URL').'merchlistreport'.'/'.$ocno);       
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function updatefilterdata(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'updatefilterdata', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }
    public function alertinfo_store(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'alertinfo_store', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    // ✅ Backend API Controller (main logic)
    public function endlinepresentation(Request $request)
    {
        $ocnno = $request->input('ocnno');
        $item_id = $request->input('itemid') ?: null;
        $color_id = $request->input('colorid') ?: null;
        $type = $request->input('type');

        $ocnbreakup = [];
        $chartdata = [];

        if ($type === 'EL') {
            $ocnbreakup = DB::select(
                'EXEC VAAHINI_ERP_GAINUP.DBO.Ocnwise_EL_Chk_Mer_Portal_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$ocnno, $item_id, $color_id]
            );

            $chartdata = DB::select(
                'EXEC VAAHINI_ERP_GAINUP.DBO.TOP5_Def_EL_OCnwise_Proc @Ocn = ?',
                [$ocnno]
            );
        } else {
            $ocnbreakup = DB::select(
                'EXEC VAAHINI_ERP_GAINUP.DBO.Ocnwise_PC_Chk_Mer_Portal_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$ocnno, $item_id, $color_id]
            );

            $chartdata = DB::select(
                'EXEC VAAHINI_ERP_GAINUP.DBO.TOP5_Def_PC_OCnwise_Proc @Ocn = ?',
                [$ocnno]
            );
        }

        return response()->json([
            'success' => true,
            'message' => 'details',
            'data' => [
                'ocnbreakup' => $ocnbreakup,
                'chartdata' => $chartdata,
            ],
        ]);
    }


    public function merchandiserorder_portal(Request $request){
        $inputdata = $request->input();
        $response = Http::GET(env('API_URL') . 'Merchandiserorder_portal');
       
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function test_DB(Request $request)
    {
        $startTime = microtime(true);
    
        try {
            // 🟡 1. Get emp_id from session
            $emp_id = session('emp_id'); // make sure it's set in session before
    
            // 🟡 2. Build full URL with query string
            $url = env('API_URL') . 'Merchandiserorder_portal?emp_id=' . $emp_id;
    
            // 🟢 3. Send GET request with emp_id
            $response = Http::get($url);
    
            // 🟢 4. Handle success/failure
            $status = $response->successful()
                ? 'Connection succeeded'
                : 'Connection failed: HTTP ' . $response->status() . ' for URL ' . $url;
    
            $data = $response->successful() ? $response->json()['data'] : [];
    
        } catch (\Exception $e) {
            $status = 'Connection failed: ' . $e->getMessage() . ' for URL ' . $url;
            $data = [];
        }
    
        $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);
    
        return view('test_db', [
            'status' => $status,
            'executionTime' => $executionTime,
            'data' => $data
        ]);
    }
    


    public function test_db_merch (Request $request)
    {
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input); 
            $apiUrl = env('API_URL') . 'Merchandiserorder_portal' . $cleanedString;
        dd($apiUrl);
            $response = Http::get($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        $allBuyers=[];
        $uniquePO=[];

        // Render the view with all unique buyers
        return view('test_db', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }
}
