<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Carbon\Carbon;
class MicroplanningController extends Controller
{
    public function __construct()
    {
        // Set static user ID for development
        Session::put('empl_id', '51052');
        Session::put('emp_name', 'Static User');
        
        // Set session lifetime to a very long time (10 years)
        config(['session.lifetime' => 5256000]);
    }

    public function microplan()
    {
        // Force set session values on every request
        Session::put('empl_id', '51052');
        Session::put('emp_name', 'Static User');
        
        return view('Micro_planning');
    }    

    public function unitdata(Request $request)
    {
        $unitresult = DB::select('exec chennai_erp.dbo.Unit_Selection_Withdate_Proc');
        $sortedResult = collect($unitresult)->sortBy('Unit')->values()->all();
        return response()->json(['success' => true, 'data' => $sortedResult]);
    }

    public function microplaningfilter(Request $request)
    {
        $fromdate = $request->input('from_date');
        $todate = $request->input('to_date');
        $unitcode = $request->input('unit_code');

        $linedate = DB::select("exec vaahini_erp_gainup.dbo.NH_Days_Mic_Plan_Proc @Fdate = ? , @Tdate = ?", [$fromdate, $todate]);
        $linedetails = DB::select("exec vaahini_erp_gainup.dbo.LP_Unitwise_Lines_Proc @Unit = ?", [$unitcode]);
        $swlinedetails = DB::select("exec vaahini_erp_gainup.dbo.LP_Unitwise_Lines_Proc_NewLine @Unit = ?", [$unitcode]);
        $plandata = DB::select("exec CHENNAI_ERP.dbo.View_For_Micro_Plan @unit_ID = ?", [$unitcode]);
        $pobacklog = DB::select("exec Micro_Planning_Input_N @Unit_Code = ?", [$unitcode]);
        $ocndetails = DB::select("exec Micro_Planning_Input @Unit_Code = ?, @Fdate = ?, @Tdate = ?", [$unitcode, $fromdate, $todate]);
        return response()->json([
            'result' => [
                'data' => [
                    'linedate' => $linedate ?? [],
                    'sftlinedetails' => $swlinedetails ?? [], // assign the detailed array
                    'linedetails' => $linedetails ?? [],      // optional, old data
                    'ocndetails' => $ocndetails ?? [],
                    'plandata' => $plandata ?? [],
                    'pobacklog' => $pobacklog ?? [],
                    'swlinedetails' => $swlinedetails ?? [],  // keep original if needed
                ],
                'message' => 'details',
                'success' => true,
                'recordsTotal' => 6,
                'recordsFiltered' => 6,
                'draw' => 1
            ]
        ]);
      
    }

    public function insertOrUpdateMicroPlan(Request $request)
    {
        // Decode and validate input
        $data = $request->all();
        $data = is_string($data) ? json_decode($data, true) : $data;
        if (!is_array($data)) {
            return response()->json(['status' => 'error', 'message' => 'Invalid input data.'], 422);
        }

        try {
            // Performance safeguards for large payloads
            DB::disableQueryLog();
            if (function_exists('set_time_limit')) { @set_time_limit(180); }
            @ini_set('max_execution_time', '180');
            DB::beginTransaction();
            $results = [];

            foreach ($data as $keydatas => $entry) {
                $details = $entry['details'] ?? [];
                $details = is_string($details) ? json_decode($details, true) : $details;

                if (!isset($entry['factory_id'], $entry['unit_id'], $entry['plan_date'], $entry['created_by']) || !is_array($details)) {
                    $results[] = ['status' => 'error', 'message' => 'Missing required fields in entry.', 'entry' => $entry];
                    continue;
                }

                $plan_startdate = Carbon::parse($entry['plan_date']);
                $plan_enddate = isset($entry['plan_enddate']) ? Carbon::parse($entry['plan_enddate']) : null;

                // Step 1: Upsert header
                $ocn_no = 'GIL\\OCN' . $entry['ocn_no'];
                $headerId = DB::table('micro_line_plan_header')
                    //->where('factory_id', $entry['factory_id'])
                    ->where('unit_id', $entry['unit_id'])
                    ->whereDate('plan_date', Carbon::now()->format('Y-m-d'))
                    ->value('id');

                if (!$headerId && empty($headerId)) {
                    $headerId = DB::table('micro_line_plan_header')->insertGetId([
                        'factory_id' => 3,
                        'unit_id' => $entry['unit_id'],
                        'item_name' => $entry['item_name'] ?? '',
                        'order_qty' => $entry['order_qty'] ?? 0,
                        'ship_date' => $entry['ship_date'] ?? null,
                        'plan_date' => Carbon::now()->format('Y-m-d'),
                        'created_by' => $entry['created_by'],
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                // Step 2: Get existing details
                $existingDetails = DB::table('micro_line_plan_detail')
                    ->where('header_id', $headerId)
                    ->select('id', 'unit_code', 'line_no', 'item_id', 'color_id', 'planned_date', 'planned_qty', 'ocn_no')
                    ->get()
                    ->keyBy(function ($item) {
                        return "{$item->unit_code}_{$item->line_no}_{$item->item_id}_{$item->color_id}_{$item->ocn_no}";
                    });

                $insertedCount = 0;
                $updatedCount = 0;
                $alreadyDeleted = [];
                $deletedIds = [];
                // Cache to avoid repeating stored proc calls for same (ocn,item,color)
                $spCalled = [];

                foreach ($details as $item) {

                    if (!isset($item['unit_code'], $item['line_no'], $item['planned_date'], $item['planned_qty'], $item['item_id'], $item['color_id'])) {
                        continue;
                    }

                    $ocnKey = 'GIL\\OCN' . $entry['ocn_no'];

                    $isSplit = isset($item['is_split']) ? $item['is_split'] : 'false';
                    $taskstatus = isset($item['taskstatus']) ? $item['taskstatus'] : '0';

                    $deleteKey = "{$item['item_id']}_{$item['color_id']}_{$ocnKey}_{$isSplit}";
                    $plannerdeleteKey = "{$item['item_id']}_{$item['line_no']}_{$item['color_id']}_{$ocnKey}_{$item['planner_opr']}";
                    $plannerdragKey = "{$item['item_id']}_{$item['line_no']}_{$item['color_id']}_{$ocnKey}_{$item['taskisdragg']}";
                    //echo '<pre>';
                    //print_r($plannerdeleteKey);
                    //echo $deleteKey. '--'. $keydatas;
                    
                
                
                    if ($isSplit == 'true'  && !isset($alreadyDeleted[$deleteKey])) {

                    

                    // echo(count($alreadyDeleted)) .'<br>';

                        // Mark as deleted
                        $alreadyDeleted[$deleteKey] = true;
                        $existingDetails = [];
            
                        $planDetailIds = DB::table('micro_line_plan_detail')
                                ->where('item_id', $item['item_id'])
                                ->where('color_id', $item['color_id'])
                                ->where('ocn_no', $ocnKey)
                                ->where('unit_code', $item['unit_code'])
                                ->pluck('id')
                                ->toArray();
                                //dd($planDetailIds);

                            if (!empty($planDetailIds)) {
                                // Collect for output
                                $deletedIds = array_merge($deletedIds, $planDetailIds);

                                // Delete related data
                                DB::table('micro_plan_machine')
                                    ->whereIn('plan_detail_id', $planDetailIds)
                                    ->delete();

                                DB::table('micro_plan_operator')
                                    ->whereIn('plan_detail_id', $planDetailIds)
                                    ->delete();

                                DB::table('micro_line_plan_detail')
                                    ->whereIn('id', $planDetailIds)
                                    ->delete();
                            }

                            //dd($planDetailIds);
                    }


                    if ($item['planner_opr'] != '0'  && !isset($alreadyDeleted[$plannerdeleteKey])) {

                        // echo(count($alreadyDeleted)) .'<br>';
    
                        // Mark as deleted
                        $alreadyDeleted[$plannerdeleteKey] = true;
                        $existingDetails = [];
                
                        $planDetailIds = DB::table('micro_line_plan_detail')
                                ->where('item_id', $item['item_id'])
                                ->where('color_id', $item['color_id'])
                                ->where('ocn_no', $ocnKey)
                                ->where('line_no',$item['line_no'] )
                                ->where('unit_code', $item['unit_code'])
                                ->pluck('id')
                                ->toArray();
                                //dd($planDetailIds);
    
                            if (!empty($planDetailIds)) {
                                // Collect for output
                                $deletedIds = array_merge($deletedIds, $planDetailIds);
    
                                // Delete related data
                                DB::table('micro_plan_machine')
                                    ->whereIn('plan_detail_id', $planDetailIds)
                                    ->delete();
    
                                DB::table('micro_plan_operator')
                                    ->whereIn('plan_detail_id', $planDetailIds)
                                    ->delete();
    
                                DB::table('micro_line_plan_detail')
                                    ->whereIn('id', $planDetailIds)
                                    ->delete();
                            }
    
                            //dd($planDetailIds);
                    }if($item['taskisdragg'] != '0' && !isset($alreadyDeleted[$plannerdragKey]) && $taskstatus != '0' ){

                        $alreadyDeleted[$plannerdragKey] = true;
                        $existingDetails = [];
                    

                    
                        

                        $exitinglinechange = DB::table('micro_line_plan_detail')
                        
                        ->where('id', $item['taskstatus'])
                        
                        ->first();
                        
                    


                    
            if(!empty($plannerdragKey)){

            

                $input = explode('_',$plannerdragKey);

            if($exitinglinechange == ''){
                        $planDetaildragIds = DB::table('micro_line_plan_detail')
                                ->where('item_id', $input['0'])
                                ->where('color_id', $input['2'])
                                ->where('ocn_no', $ocnKey)
                            ->where('line_no',$input['1'])
                                ->where('unit_code',$item['unit_code'])
                            
                                ->pluck('id')
                                ->toArray();}else{

                                    $planDetaildragIds = DB::table('micro_line_plan_detail')
                                    ->where('item_id', $exitinglinechange->item_id)
                                    ->where('color_id',$exitinglinechange->color_id)
                                    ->where('ocn_no', $ocnKey)
                                ->where('line_no',$exitinglinechange->line_no)
                                    ->where('unit_code',$item['unit_code'])
                                    ->pluck('id')
                                    ->toArray();
                                }
                            //dd($planDetaildragIds);

                            if (!empty($planDetaildragIds)) {
                                // Collect for output
                                $deletedIds = array_merge($deletedIds, $planDetaildragIds);

                                // Delete related data
                                DB::table('micro_plan_machine')
                                    ->whereIn('plan_detail_id', $planDetaildragIds)
                                    ->delete();

                                DB::table('micro_plan_operator')
                                    ->whereIn('plan_detail_id', $planDetaildragIds)
                                    ->delete();
                                $toBeDeletedRows = DB::table('micro_line_plan_detail')->whereIn('id', $planDetaildragIds)->get();
                                foreach ($toBeDeletedRows as $deletedRow) {
                                    $this->logMicroDetail('DELETE', $deletedRow->id, $deletedRow, $entry['created_by']);
                                }

                                DB::table('micro_line_plan_detail')
                                    ->whereIn('id', $planDetaildragIds)
                                    ->delete();
                            }

                        }

                    }

                    $selectedDates = $item['selected_dates'] ?? [];
                    // De-duplicate any repeated dates to avoid redundant processing
                    $selectedDates = array_values(array_unique($selectedDates));
                    $ocnKey = 'GIL\\OCN' . $entry['ocn_no'];
                    $lookupKey = "{$item['unit_code']}_{$item['line_no']}_{$item['item_id']}_{$item['color_id']}_{$ocnKey}";

                

                    

                    if (isset($existingDetails[$lookupKey])) {
                        $existing = $existingDetails[$lookupKey];
                        foreach ($selectedDates as $selectedDate) {
                        // if($ocnKey== 'GIL\OCN04388'){
                        //     dd('test');
                        // }
                            

                        
                            if ((int)$existing->planned_qty !== (int)$item['planned_qty']) {
                                DB::table('micro_line_plan_detail')
                                    ->where('id', $existing->id)
                                    ->update([
                                        
                                        'updated_at' => now(),
                                        'task_type' => '7'.'-'.$item['taskisdragg'].'-'.(int)$existing->planned_qty.'-'.(int)$item['planned_qty'],
                                        'updated_by' => $entry['created_by']
                                        
                                    ]);
                                $updatedCount++;
                                $this->logMicroDetail('UPDATE', $existing->id, $existing, $entry['created_by']);
                                //echo '<pre>';
                                //print_r(Carbon::parse($selectedDate)->toDateString());
                            }

                        } 
                        // if($item['planner_opr'] == '5'){
                        //     dd('stop');
                        // }
                        
                    } else {
                        if($item['planner_qty']){
                            $totalQty = $item['is_split_unit'] == 0 ? $item['planned_qty'] : $item['is_split_unit'];
                            $maxPerDay = $item['planner_qty'];
                            $target_day_qty = $item['planner_qty'];

                        }else{
                            $totalQty = $item['is_split_unit'] == 0 ? $item['planned_qty'] : $item['is_split_unit'];
                            $maxPerDay = $item['per_day_qty'];
                            $target_day_qty = $item['per_day_qty'];
                        

                        }
                        
                        foreach ($selectedDates as $selectedDate) {
                            if ($totalQty <= 0) { break; }
                            // Compute per-day qty chunk
                            $qty = $totalQty >= $maxPerDay ? $maxPerDay : $totalQty;

                            // Production balance based on planner qty or per-day
                            if (!empty($item['planner_qty'])) {
                                $production_bal_saw = $totalQty < $item['planner_qty'] ? $totalQty : $item['planner_qty'];
                            } else {
                                $production_bal_saw = $totalQty < ($item['per_day_qty'] ?? 0) ? $totalQty : ($item['per_day_qty'] ?? 0);
                            }

                       
                        

                        $isSplit = !empty($item['is_split']) ? (int)$item['is_split'] : 0;

                            $detailId = DB::table('micro_line_plan_detail')->insertGetId([
                                'line_no' => $item['line_no'],
                                'header_id' => $headerId,
                                'unit_code' => $item['unit_code'],
                                'line_name' => $item['line_name'] ?? null,
                                
                                'item_id' => $item['item_id'],
                                'color_id' => $item['color_id'],
                                'color_name' => $item['color_name'] ?? '',
                                'planned_date' => Carbon::parse($selectedDates[0]),
                                'plan_enddate' => Carbon::parse($selectedDate),
                                // Use actual per-day qty chunk to avoid over-inserting work
                                'planned_qty' => $qty,
                                'created_by' => $entry['created_by'],
                                'no_mach' => $item['no_of_machines'] ?? null,
                                'no_opr' => $item['no_operators'] ,
                                'item' => $item['item'],
                                'per_day_qty' => $item['per_day_qty'] ?? null,
                                'New_Targ_Qty' => $target_day_qty,
                                'color' => $item['color'],
                                'ocn_no' => $ocnKey,
                                'ck_date' => $item['ck_date'],
                                'fi_date' => $item['FI_date'],
                                'planner_opr' => $item['planner_opr'] ?? null,
                                'planner_qty' => $item['planner_qty'] ?? null,
                                'buyer' => $item['buyer'] ?? null,
                                'priority' => $keydatas,
                                'created_at' => now(),
                                'updated_at' => now(),
                                'efficiency' => $item['planner_efficiency'] ?? Null,
                                'production_bal_sew' => $production_bal_saw,
                                'task_type' => ($isSplit == 0) ? ($item['taskisdragg'] ?? 0) : 3

                            ]);
                            $newDetail = DB::table('micro_line_plan_detail')->where('id', $detailId)->first();
                            $this->logMicroDetail('INSERT', $detailId, $newDetail, $entry['created_by']);

                            $totalQty -= $qty;

                            // Stored procedures only once per (OCN,Item,Color) and only if qty > 0
                            if ($qty > 0) {
                                $spKey = $ocnKey.'|'.$item['item_id'].'|'.$item['color_id'];
                                if (!isset($spCalled[$spKey])) {
                                    $spCalled[$spKey] = true;
                                    $procResultsmech = DB::select(
                                        "exec vaahini_erp_gainup.dbo.Mch_Type_Grade_Details_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?, @Type = ?",
                                        [$ocnKey, $item['item_id'], $item['color_id'], $item['type'] ?? 'Mch']
                                    );
                                    $procResultsopr = DB::select(
                                        "exec vaahini_erp_gainup.dbo.Mch_Type_Grade_Details_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?, @Type = ?",
                                        [$ocnKey, $item['item_id'], $item['color_id'], $item['type'] ?? 'Opr']
                                    );
                                    foreach ($procResultsmech as $row) {
                                        DB::table('micro_plan_machine')->insert([
                                            'plan_detail_id' => $detailId,
                                            'ocn' => $row->Order_No ?? null,
                                            'type' => $row->Type ?? null,
                                            'cnt' => $row->Cnt ?? null,
                                        ]);
                                    }
                                    foreach ($procResultsopr as $row) {
                                        DB::table('micro_plan_operator')->insert([
                                            'plan_detail_id' => $detailId,
                                            'ocn' => $row->Order_No ?? null,
                                            'type' => $row->Type ?? null,
                                            'cnt' => $row->Cnt ?? null,
                                        ]);
                                    }
                                }
                            }

                            $insertedCount++;
                        }
                    }
                }

                $results[] = [
                    'status' => 'success',
                    'header_id' => $headerId,
                    'inserted' => $insertedCount,
                    'updated' => $updatedCount,
                    'skipped' => count($details) - $insertedCount - $updatedCount,
                    'deleted' => $alreadyDeleted,
                    'ocn_no' => $entry['ocn_no'],
                    'deleted' => $alreadyDeleted,
                    'deleted_ids' => $deletedIds,
                ];
            }

            DB::commit();

            return response()->json([
                'success' => true,
                'status' => 'success',
                'message' => 'Records processed successfully.',
                'summary' => [
                    'total' => count($results),
                    'successful' => collect($results)->where('status', 'success')->count(),
                    'errors' => collect($results)->where('status', 'error')->count(),
                ],
                'results' => $results,
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('InsertOrUpdateMicroPlan Error: ' . $e->getMessage());
            return response()->json(['status' => 'error', 'message' => $e->getMessage()], 500);
        }
    }

    // public function deleteMicroPlan(Request $request)
    // {
    //     $inputdata = $request->input();
    //     $response = Http::Post(env('API_URL') . 'deleteMicroPlan', $inputdata);
    //     $res_set = json_decode($response, true);
    //     return response()->json($res_set);
    // }

    public function deleteMicroPlanSingle(Request $request)
    {
        try {
            $ocn_no = $request->filled('ocn_no') && $request->get('ocn_no') !== 'GIL\\'
                ? 'GIL\\OCN' . $request->get('ocn_no')
                : null;

            $item_id = $request->input('item_id');
            $color_id = $request->input('color_id');
            $unit_id = $request->input('unit_id');
            $line_no = $request->input('line_no');

            if (!$ocn_no || !$item_id || !$color_id || !$unit_id || !$line_no) {
                return response()->json(['error' => 'Missing required fields'], 400);
            }

            // Get all plan detail IDs
            $planDetailIds = DB::table('micro_line_plan_detail')
                ->where('item_id', $item_id)
                
                ->where('unit_code', $unit_id)
                ->where('ocn_no', $ocn_no)
                ->pluck('id');

            if ($planDetailIds->isEmpty()) {
                return response()->json(['error' => 'Task not found in database'], 404);
            }

            // Delete in chunks to handle large number of records
            $chunkSize = 1000; // you can increase/decrease depending on server
            $planDetailIds->chunk($chunkSize)->each(function ($chunk) {
                DB::table('micro_plan_machine')->whereIn('plan_detail_id', $chunk)->delete();
                DB::table('micro_plan_operator')->whereIn('plan_detail_id', $chunk)->delete();
                DB::table('micro_line_plan_detail')->whereIn('id', $chunk)->delete();
            });

            return response()->json(['message' => 'Task deleted successfully and restored to backlog'], 200);

        } catch (\Exception $e) {
            Log::error("Failed to delete micro plan: {$e->getMessage()}");
            return response()->json(['error' => 'Failed to delete task', 'details' => $e->getMessage()], 500);
        }
    }

    public function ordersummary(Request $request)
    {
        // Normalize order number to ensure single GIL\\OCN prefix
        $orderno = null;
        if ($request->filled('orderno')) {
            $raw = $request->get('orderno');
            if (strpos($raw, 'GIL\\OCN') === 0) {
                $orderno = $raw; // already normalized
            } else {
                // extract digits and prefix
                $digits = preg_replace('/\D+/', '', (string)$raw);
                $orderno = $digits ? 'GIL\\OCN' . $digits : null;
            }
        }
        $itemid = $request->input('itemid');
        $colorid = $request->input('colorid');
        $unitid = $request->input('unit_code');

        $ordersummary = DB::select(
            'exec vaahini_erp_gainup.dbo.Order_Summary_For_Mic_Plan_Proc  @Ocn = ?  , @Itemid = ? , @Colorid = ?, @U_Code = ?',
            [$orderno, $itemid, $colorid, $unitid]
        );
        // Match the expected response shape: response.data.data[0]
        return response()->json([
            'data' => [
                'data' => $ordersummary,
            ],
        ]);
    }


        public function machinedetails(Request $request)
        {
            $unit = $request->input('unit');
            $mach = 'Mch';
            $opr = 'OPr';
        
            // Machine data using stored procedure
            $machdata = DB::select(
                'exec VAAHINI_ERP_GAINUP.DBO.Operator_MCh_Cnt_Unit_Proc @Unit_Code = ?, @Arg = ?',
                [$unit, $mach]
            );
        
            // Operator data using same stored procedure but different params
            $oprdata = DB::select(
                'exec VAAHINI_ERP_GAINUP.DBO.Operator_MCh_Cnt_Unit_Proc @Unit_Code = ?, @Arg = ?',
                [$unit, $opr]
            );
        
            return response()->json([
                'data' => [
                    'data' => [
                        'machine' => $machdata,
                        'operator' => $oprdata
                    ]
                ]
            ]);   
    
        }

        public function updateTailorQuantity(Request $request)
        {
            $inputdata = $request->input();
            $response = Http::Post(env('API_URL') . 'operatorupdate', $inputdata);
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }

        public function ocnItemlineplan(Request $request){
            $orderno = ($request->filled('ocn_no') && $request->get('ocn_no') !== 'GIL\\') 
            ? 'GIL\\OCN'.$request->get('ocn_no') 
            : null;
            $itemid = $request->input('itemid') ?? NULL;
            $unitid = $request->input('unit_code');
            $plandetails = DB::select('exec vaahini_erp_gainup.dbo.Macro_Plan_New_Proc  @Type = ?  ,@Month_Name = ? , @Unit_Code = ?, @Capacity_Type = ? ,@Ocn = ?,  @Itemid = ?' , ['LinePlan_N' , NULL , $unitid ,NULL, $orderno,$itemid]);
        
            return response()->json([
                'data' => $plandetails,
            ]);
        }


        public function allocnsearch()
        {
            $result = DB::select("exec CHENNAI_ERP.dbo.View_For_Micro_Plan_N @unit_ID = NULL");
            return $this->sendResponse($result, 'details');
        } 
        
        public function plannedvsactual(Request $request)
        {
            // $unitCode = $request->query('unit_code'); // Get unit_code from query parameter
            // $apiUrl = env('API_URL') . 'plannedvsactual?unit_code=' . urlencode($unitCode); // Append unit_code to API URL
            // $response = Http::get($apiUrl);
            // return response()->json($response->json());
                $unitid = $request->input('unit_code') ?? null;
                $unitid=null;
                $plandetails = DB::select('exec chennai_erp.dbo.Planned_Vs_Actual_Proc @Unit_Code = ? ' , [$unitid]);
                return $this->sendResponse($plandetails, 'details');
        }

        private function sendResponse($result, $message = 'details', $success = true)
        {
            return response()->json([
                'success' => $success,
                'data' => $result,
                'message' => $message,
            ]);
        }

        public function plandelete(Request $request)
        {
            // $inputdata = $request->input();
            // $response = Http::get(env('API_URL') . 'plandelete', $inputdata);
            // $res_set = json_decode($response, true);

            
            return response()->json($res_set);
        }

        public function planlogoutUpdate(Request $request)
        {
            $inputdata = $request->input();
            $response = Http::post(env('API_URL') . 'planlogin_update', $inputdata);
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }

    /**
     * Lightweight audit logger for micro plan detail changes.
     */
    protected function logMicroDetail($action, $detailId, $data, $userId)
    {
        try {
            Log::info('MicroPlanDetail '.$action, [
                'detail_id' => $detailId,
                'user_id' => $userId,
                'data' => is_array($data) ? $data : (is_object($data) ? (array) $data : $data),
                'timestamp' => now()->toDateTimeString(),
            ]);
        } catch (\Throwable $e) {
            // no-op
        }
    }

}