<?php

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;



class OperationController extends Controller
{

    public function operationlist1_old(Request $request)
    {
        $empId = Session('empl_id');

        $input = http_build_query($request->input());
        $cleanedString = str_replace('+', '%20', $input);
        //$input =$request->input();
        //dd($input);
        $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
        //dd($apiUrl);

        $response = Http::get($apiUrl);
        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }

        return view(
            'LifeAtGainup.Operation.operationlist'
        );
    }

    //venkatesh_22/04/25

    public function operationlist(Request $request)
    {
        $empId = session('empl_id');
    
        if ($request->ajax()) {
            try {
                $input = http_build_query($request->input());
                $cleanedString = str_replace('+', '%20', $input);
                $cacheKey = 'operationlist_' . $empId . '_' . md5($cleanedString);
    
                // 🔁 Check if data is already cached
                if (Cache::has($cacheKey)) {
                    $dataaa = Cache::get($cacheKey);
                } else {
                    // 🔥 Call API and cache result
                    $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
                    $response = Http::get($apiUrl);
    
                    if ($response->successful()) {
                        $dataaa = $response->json();
                        Cache::put($cacheKey, $dataaa, now()->addHours(1)); // Cache for 1 hour
                    
                        // Save current cache key
                        Cache::put('operationlist_current_key_' . $empId, $cacheKey, now()->addHours(1));
                    
                        // Track all cache keys created for this emp
                        $allKeysKey = 'operationlist_keys_list_' . $empId;
                        $allKeys = Cache::get($allKeysKey, []);
                        $allKeys[] = $cacheKey;
                        Cache::put($allKeysKey, array_unique($allKeys), now()->addHours(1));
                    }
                    
                }
    
                return response()->json($dataaa);
    
            } catch (\Exception $e) {
                Log::error('OperationList Error: ' . $e->getMessage());
                return response()->json(['error' => 'Something went wrong. Please contact dev.'], 500);
            }
        }
    
        // 🖥️ Non-AJAX page reload
        $lastCacheKey = Cache::get('operationlist_current_key_' . $empId);
        $cachedData = $lastCacheKey ? Cache::get($lastCacheKey) : null;
    
        return view('LifeAtGainup.Operation.operationlist1', [
            'defaultData' => $cachedData
        ]);
    }

    public function operationlist_old1(Request $request)
    {
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input);            
            $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
            $response = Http::get($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        return view('LifeAtGainup.Operation.operationlist1');
    }

    // public function operationlist(Request $request)
    // {
    //     $empId = Session('empl_id');
    
    //     if ($request->ajax()) {
    //         try {
    //             $input = http_build_query($request->input());
    //             $cleanedString = str_replace('+', '%20', $input);
    
    //             $cacheKey = 'operationlist_' . $empId . '_' . md5($cleanedString);
    
    //             $dataaa = Cache::remember($cacheKey, 86400, function () use ($cleanedString) {
    //                 $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
    //                 $response = Http::get($apiUrl);
    
                    
    //                 if ($response->successful()) {
    //                     return $response->json();
    //                 } else {
    //                     Log::error('API Error: ' . $response->body());
    //                     return ['error' => 'API returned error'];
    //                 }
    //             });
    
    //             return response()->json($dataaa);
    //         } catch (\Exception $e) {
    //             Log::error('OperationList Error: ' . $e->getMessage());
    //             return response()->json(['error' => 'Something went wrong. Please contact dev.'], 500);
    //         }
    //     }
    
    //     return view('LifeAtGainup.Operation.operationlist1');
    // }


    public function operationlist1(Request $request)
    {
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input);            
            $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
            $response = Http::get($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        return view('LifeAtGainup.Operation.operationlistbeta');
    }


    public function operationdashboard(Request $request)
    {
        // \Log::info('Start');
        $empId = Session('empl_id');
        $apiUrl = env('API_URL') . 'operationdayreport/' . $empId;
    
        // If AJAX, just return JSON
        if ($request->ajax()) {
            $response = Http::get($apiUrl);
            if ($response->failed()) {
                return response()->json(['error' => 'API call failed'], 500);
            }
            return response()->json($response->json());
        }
    
        // Else load the blade view
        // \Log::info('End');
        return view('LifeAtGainup.Operation.dahboard');
    }

    public function operation_dashboard_beta(Request $request)
    {
        // \Log::info('Start');
        $empId = Session('empl_id');
        $apiUrl = env('API_URL') . 'operationdayreport/' . $empId;
    
        // If AJAX, just return JSON
        if ($request->ajax()) {
            $response = Http::get($apiUrl);
            if ($response->failed()) {
                return response()->json(['error' => 'API call failed'], 500);
            }
            return response()->json($response->json());
        }
    
        // Else load the blade view
        // \Log::info('End');
        return view('LifeAtGainup.Operation.operation_dashboard_beta');
    }

    // public function operationdashboard(Request $request)
    // {
    //     $empId = Session('empl_id');
    //     $apiUrl = env('API_URL') . 'operationdayreport/' . $empId;


    //     $response = Http::get($apiUrl);
    //     $dataaa = $response->json();
    //     if ($request->ajax()) {
    //         //dd($dataaa);
    //         return response()->json($dataaa);
    //     }

    //     return view(
    //         'LifeAtGainup.Operation.dahboard'
    //     );
    // }

    public function todayreport(Request $request) {}

    //userlogmerch_opt

    public function userlogmerch_opt(Request $request)
    {
        $emp_id = $request->emp_id;

        $logdata = DB::select(
            'exec Merch_Operation_usage_analysis_Proc @EmpCode = ?',
            [$emp_id]
        );

        return response()->json([
            'success' => true,
            'message' => 'list',
            'data'    => $logdata
        ]);
    }

    public function operationreport(Request $request)
    {
        $data = [
            'year' => $request->year,
            'month' => $request->month
        ];
        $response = Http::get(env('API_URL') . 'monthwishturnover', $data);
        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
        return view(
            'LifeAtGainup.Operation.dahboardreport'
        );
    }
    public function operationreporttmins(Request $request)
    {
        $data = [
            'year' => $request->year,
            'month' => $request->month
        ];
        $response = Http::get(env('API_URL') . 'monthwishstatusmins', $data);
        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
    }
    public function operationreportqty(Request $request)
    {
        $data = [
            'year' => $request->year,
            'month' => $request->month
        ];
        $response = Http::get(env('API_URL') . 'monthwishstatusqty', $data);


        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
    }

    public function operationreportowe(Request $request)
    {
        $data = [
            'year' => $request->year,
            'month' => $request->month,
            'type' => $request->type
        ];
        $response = Http::timeout(120)->get(env('API_URL') . 'monthwishtwl', $data);

        //dd(env('API_URL').'monthwishtwl',$data);

        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
    }

    public function operationcutting(Request $request)
    {


        $data = [
            'year' => $request->year,
            'month' => $request->month,
        ];
        $response = Http::timeout(120)->get(env('API_URL') . 'monthwishcuttingselected', $data);

        //dd(env('API_URL').'monthwishcuttingselected',$data);

        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
    }
    public function operationpacking(Request $request)
    {


        $data = [
            'year' => $request->year,
            'month' => $request->month,
        ];
        $response = Http::timeout(120)->get(env('API_URL') . 'monthwishpacking', $data);

        //dd(env('API_URL').'monthwishcuttingselected',$data);

        $dataaa = $response->json();
        if ($request->ajax()) {
            //dd($dataaa);
            return response()->json($dataaa);
        }
    }

    public function buyerorderstatus(Request $request)
    {
        try {
            // 🧩 Get order number from request
            $ocno = $request->orderNo;

            if (empty($ocno)) {
                return response()->json([
                    'success' => false,
                    'message' => 'Order number is required',
                    'data' => []
                ], 400);
            }

            // 🔁 Replace "-" with "\" (as in your original logic)
            $replacedText = Str::replace("-", "\\", $ocno);

            // 🗄️ Execute your stored procedure directly
            $sizebreakup = DB::select('exec VAAHINI_ERP_GAINUP.DBO.Ob_Chart_Details_Portal_Proc ?', [$replacedText]);

            // ✅ Return same structured JSON as API response
            return response()->json([
                'success' => true,
                'message' => 'List fetched successfully.',
                'data' => $sizebreakup
            ], 200);

        } catch (\Throwable $e) {
            // 🧾 Log the error
            Log::error('buyerorderstatus DB error: ' . $e->getMessage());

            // Return the exact exception message in the API response
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(), // <--- show exact error
                'data' => []
            ], 500);
        }
    }


    public function wipdetails(Request $request)
    {
        $type = $request->type;

        $fdate = $request->fromdate
            ? Carbon::parse($request->fromdate)->format('d-M-Y')
            : Carbon::today()->format('d-M-Y');

        $enddate = $request->enddate
            ? Carbon::parse($request->enddate)->format('d-M-Y')
            : $fdate;

        $cacheKey = "wip_details_{$fdate}_{$enddate}_{$type}";

        // Cache for 5 minutes
        $resultData = Cache::remember($cacheKey, 60 * 5, function () {
            return DB::select('EXEC VAAHINI_ERP_GAINUP.DBO.WIP_Proc');
        });

        $collection = collect($resultData);

        // Group by Unit → Type → Buyer
        $units = $collection->groupBy('Unit')->map(function ($unitGroup, $unitName) {
            $types = $unitGroup->groupBy('Type')->map(function ($typeGroup, $typeName) {
                $buyers = $typeGroup->groupBy('Buyer')->map(function ($buyerGroup, $buyerName) {
                    return [
                        'Buyer' => $buyerName,
                        'data'  => $buyerGroup->values()
                    ];
                })->values();

                return [
                    'Type'   => $typeName,
                    'buyers' => $buyers
                ];
            })->values();

            return [
                'Unit'  => $unitName,
                'types' => $types
            ];
        })->values();

        return response()->json([
            'success' => true,
            'units'   => $units
        ], 200);
    }


    //venkat_22/04/25

    public function filtersetting(Request $request)
    {
        $emp_id = $request->emp_id;
        $inputdata = $request->input();
    
        
        $lastCacheKey = Cache::get('operationlist_current_key_' . $emp_id);
    
        if ($lastCacheKey) {
            Cache::forget($lastCacheKey);
            Cache::forget('operationlist_current_key_' . $emp_id);
        }
    
        
        $response = Http::post(env('API_URL') . 'filtersetting', $inputdata);
    
        if ($response->successful()) {
            $filteredData = $response->json();
    
            
            try {
                $inputQuery = http_build_query($inputdata);
                $cleanedString = str_replace('+', '%20', $inputQuery);
                $operationUrl = env('API_URL') . 'operationlist/' . $cleanedString;
    
                $opResponse = Http::get($operationUrl);
    
                if ($opResponse->successful()) {
                    $opData = $opResponse->json();
                    $opCacheKey = 'operationlist_' . $emp_id . '_' . md5($cleanedString);
    
                    Cache::put($opCacheKey, $opData, now()->addMinutes(30));
                    Cache::put('operationlist_current_key_' . $emp_id, $opCacheKey, now()->addMinutes(30));
                } else {
                    Log::error('Auto-Trigger OperationList API Failed: ' . $opResponse->body());
                }
            } catch (\Exception $e) {
                Log::error('Auto-Trigger OperationList Cache Error: ' . $e->getMessage());
            }
    
            return response()->json($filteredData);
        } else {
            Log::error('FilterSetting API Error: ' . $response->body());
            return response()->json(['error' => 'Filter API error'], 500);
        }
    }

    public function filtersetting_old1(Request $request)
    {
        $emp_id = $request->emp_id;
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'filtersetting', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function operationlistreport(Request $request)
    {
        $reportid = $request->reportid;
        $response = Http::get(env('API_URL') . 'operationlistreport/' . $reportid);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }


    //venkatesh_22/04/25

    public function deletereportitem(Request $request)
    {
        $reportid = $request->reportid;
        $emp_id = session('empl_id'); 
    
       
        $response = Http::get(env('API_URL') . 'deletereportitem/' . $reportid);
        $res_set = json_decode($response, true);
    
        
        $lastCacheKey = Cache::get('operationlist_current_key_' . $emp_id);
    
        if ($lastCacheKey) {
            Cache::forget($lastCacheKey);
            Cache::forget('operationlist_current_key_' . $emp_id);
        }
    
        
        try {
            
            $inputQuery = http_build_query(['emp_id' => $emp_id]);
            $cleanedString = str_replace('+', '%20', $inputQuery);
            $apiUrl = env('API_URL') . 'operationlist/' . $cleanedString;
    
            $opResponse = Http::get($apiUrl);
    
            if ($opResponse->successful()) {
                $opData = $opResponse->json();
                $opCacheKey = 'operationlist_' . $emp_id . '_' . md5($cleanedString);
    
                Cache::put($opCacheKey, $opData, now()->addMinutes(30));
                Cache::put('operationlist_current_key_' . $emp_id, $opCacheKey, now()->addMinutes(30));
            } else {
                Log::error('OperationList Refresh Failed After Delete: ' . $opResponse->body());
            }
        } catch (\Exception $e) {
            Log::error('Error Refreshing OperationList Cache After Delete: ' . $e->getMessage());
        }
    
        return response()->json($res_set);
    }


    public function deletereportitem_old1(Request $request)
    {
        $reportid = $request->reportid;
        $response = Http::get(env('API_URL') . 'deletereportitem/' . $reportid);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function optcommonsearch(Request $request)
    {
        $empId = $request->empId;
        $response1 = Http::get(env('API_URL') . 'optcommonsearch' . '/' . $empId);
        $res_set = json_decode($response1, true);
        return response()->json($res_set);
    }


    public function feedbackstore(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'followupstore', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function followdetails(Request $request)
    {
        $emplno   = session('empl_id');
        $portalid = $request->portal_id ?? 1;
        $type     = $request->type ?? 1;

        if ($request->type == '3') {
            $portalid = 3;
            $type = ($request->type == 3) ? 1 : $request->type;
        }

        $headerdetailcollection = DB::table('followup')
            ->where('emp_id', $emplno)
            ->where('ocn_no', $request->ocnno)
            ->where('type', $type)
            ->where('Portal_Id', $portalid)
            ->get();

        if ($headerdetailcollection->isNotEmpty()) {
            return response()->json([
                'success' => true,
                'data' => $headerdetailcollection,
                'message' => 'Record found successfully.'
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'No record found.'
            ], 404);
        }

    }


    // FILE UPLOAD - BY SURYA ON 26-12-2024
    public function submitFile(Request $request)
    {
        $empId = Session('empl_id');
        $orderId = $request->input('orderId');
        $lotNo = $request->input('lotNo');
        $files = $request->file('files'); // Get all uploaded files

        try {
            $res_set = [];

            foreach ($files as $file) {
                $sanitizedOrderId = str_replace('\\', '$', $orderId);
                // $uniqueId = substr(uniqid(), 0, 5);
                $uniqueId = uniqid();
                $newName = $sanitizedOrderId . '-' . $lotNo . '-' . $uniqueId . '-' . $file->getClientOriginalName();

                // Store each file in the 'operationListFile' disk
                $filePath = Storage::disk('operationListFile')->put($newName, file_get_contents($file->path()));

                // Prepare the data to send to the API for each file
                $inputdata = [
                    'orderno'  => $orderId,
                    'lotno'    => $lotNo,
                    'filesinput' => $newName, // Save individual file path
                    'userid'   => $empId
                ];

                // Send file data to the external API for each file
                $response = Http::post(env('API_URL') . 'fileupload', $inputdata);
                $res_set[] = json_decode($response, true); // Store response for each file
            }

            // Return success response
            return response()->json([
                'success' => true,
                'message' => 'File uploaded successfully.',
                'path' => $filePath,
            ]);
            // Return the API response to the front-end
            // return response()->json($res_set);
        } catch (\Exception $e) {
            // Handle errors
            return response()->json(['success' => false, 'message' => 'File upload failed: ' . $e->getMessage()]);
        }
    }

    // FILE VIEW - BY SURYA ON 26-12-2024
    public function viewFile(Request $request)
    {
        $orderId = $request->input('orderId');
        $lotNo = $request->input('lotNo');
        $inputdata = [
            'orderno'  => $orderId,
            'lotno'    => $lotNo,
        ];
        $response = Http::Post(env('API_URL') . 'fileview', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json(['filePath' => $res_set]);
    }

    public function clearCaches()
    {
        // Clear application cache
        Artisan::call('cache:clear');
        // Clear route cache
        Artisan::call('route:clear');
        // Clear view cache
        Artisan::call('view:clear');
        // Clear config cache
        Artisan::call('config:clear');
        // Response to clear browser cache headers
        return response()->json(['message' => 'All caches cleared successfully!'], 200)
                        ->header('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0')
                        ->header('Pragma', 'no-cache')
                        ->header('Expires', '0');
    }



    public function clearCaches1()
    {
        // Clear application cache
        Artisan::call('cache:clear');
        // Clear route cache
        Artisan::call('route:clear');
        // Clear view cache
        Artisan::call('view:clear');
        // Clear config cache
        Artisan::call('config:clear');
        // Response to clear browser cache headers
        return response()->json(['message' => 'All caches cleared successfully!'], 200)
                        ->header('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0')
                        ->header('Pragma', 'no-cache')
                        ->header('Expires', '0');
    }

    public function productionfilter(Request $request)
    {
        $replacedText = Str::replace("-", "\\", $request->orderNo);

        // Determine which stored procedure to call
        if ($request->filter_type == 'Cut') {
            $prodfilter = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Cut_Portal_Link_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$replacedText, $request->itemid, $request->colorid]
            );
        } 
        else if ($request->filter_type == 'Input') {
            $prodfilter = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Input_Portal_Link_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$replacedText, $request->itemid, $request->colorid]
            );
        } 
        else if ($request->filter_type == 'Audit') {
            $prodfilter = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Audit_Portal_Link_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$replacedText, $request->itemid, $request->colorid]
            );
        } 
        else if ($request->filter_type == 'Fgs') {
            $prodfilter = DB::select(
                'exec VAAHINI_ERP_GAINUP.dbo.Fgs_Portal_Link_Proc @Ocn = ?, @Itemid = ?, @Colorid = ?',
                [$replacedText, $request->itemid, $request->colorid]
            );
        }

        // Return same structure as DB function
        if ($prodfilter) {
            return response()->json([
                'success' => true,
                'message' => 'Record found successfully.',
                'data'    => $prodfilter
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'No record found.',
            'data'    => []
        ], 404);
    }

    public function TodayOperationDash(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::get(env('API_URL') . 'TodayOperationDash', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }
    public function datewiseproduction(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::get(env('API_URL') . 'datewiseproduction', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }
}
