 // (Tvl, Tminis, Tqty, Total_OWE, Tailor, packing, cutting ) charts - start pooja
 let chartpred;
 // let qltyFromDate;
 // let qltyToDate;
 // let qltyFromMonth;
 // let qltyToMonth;
 let qltystart;
 let qltyend;

 document.addEventListener("DOMContentLoaded", function () {
     const calendarBtn = document.getElementById("QltycalendarIcon");
     const dropdown = document.getElementById("calendarDropdown");
     const container = document.getElementById("calendarContainer");
   
     let fpInstance = null;
   
     calendarBtn.addEventListener("click", function () {
       dropdown.style.display = dropdown.style.display === "none" ? "block" : "none";
     });
   
     dropdown.querySelectorAll("button").forEach((btn) => {
       btn.addEventListener("click", function () {
         let mode = this.dataset.mode;
         //dropdown.style.display = "none";
   
         // Clear container
         container.innerHTML = "";
   
         if (fpInstance) {
           fpInstance.destroy();
         }
   
         if (mode === "date") {
             qltystart = '';
             qltyend = '';
           fpInstance = flatpickr(container, {
             mode: "range",
             dateFormat: "Y-m-d",
             onChange: function (selectedDates) {
                 if (selectedDates.length) {
                     const formatDate = (date) => {
                         return `${String(date.getDate()).padStart(2, '0')}/${String(date.getMonth() + 1).padStart(2, '0')}/${date.getFullYear()}`;
                     };
             
                     qltystart = formatDate(selectedDates[0]);
                     qltyend = selectedDates[1] ? formatDate(selectedDates[1]) : '';
             
                     console.log("Selected dates:", qltystart, qltyend);
                 }
                 updateQltyChart(mode);
             }
           });
         } else if (mode === "month") {
             qltystart = '';
             qltyend = '';
           fpInstance = flatpickr(container, {
             mode: "range", 
             plugins: [
               new monthSelectPlugin({
                 shorthand: true,
                 dateFormat: "Y-m",
                 altFormat: "F Y"
               })
             ],
             onChange: function (selectedMonths) {
                 if (selectedMonths.length) {
                     const formatMonth = (date) => {
                         return `${String(date.getMonth() + 1).padStart(2, '0')}/${date.getFullYear()}`;
                     };
             
                     qltystart = formatMonth(selectedMonths[0]);
                     qltyend = selectedMonths[1] ? formatMonth(selectedMonths[1]) : '';
             
                     console.log("Selected months:", qltystart, qltyend);
                 }
                 updateQltyChart(mode);
             }
           });
         }        
         fpInstance.open();
       });
     });
 });
    
 document.addEventListener("DOMContentLoaded", function () {
     const chartOptions = {
     chart: {
         type: 'area',
         height: 240,
         id: 'chartpred',
         toolbar: {
             show: false 
         },
     },
     legend: {
        show: true,
        position: 'top',   
     },
     tooltip: {
         enabled: true 
     },
     dataLabels: {
         enabled: false 
     },
     series: [],
     xaxis: {
         categories: []
     },
 };

 chartpred = new ApexCharts(document.querySelector("#chartpred"), chartOptions);
 chartpred.render();

 });

function updateQltyChart(mode) {
    let monthNames = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ];

     let qltyType = $(".dropdown-item.method.opt.active").data("value") || "Tvl";
     let unitFilter = $(".dropdown-item.method.unit.active").data("value") || "ALL";
     let buyerFilter = $(".dropdown-item.method.buyer.active").data("value") || "ALL";
     let qltyTypeNames = {
        "Tvl": "Turn Over",
        "Tminis": "Earned Minutes",
        "Tqty": "Production Qty",
        "Total_OWE": "OWE",
        "Tailor": "Tailor",
        "cutting_status": "Cutting Status",
        "packing": "Packing"
    };    
 
     let ajaxUrl = routesMap[qltyType] || "{{ route('operationreport') }}";
     let month = "Mar";
     let monthIndex = parseInt(month, 10) - 1;
     let monthName = monthNames[monthIndex] || "March";
     
     let requestData = {
         year: 2025,
         month: 'Mar',
         mode: mode,
         start: qltystart,
         end: qltyend,
         type: qltyType,
         unit: unitFilter,
         buyer: buyerFilter 
     };
 
     $.ajax({
         url: ajaxUrl,
         method: "GET",
         data: requestData,
         success: function (response) {
             
             if (!response || !response.data) {
                 console.error("Invalid response format:", response);
                 return;
             }
 
             let tableData = response.data;
 
             if (Array.isArray(tableData)) {
              
             } else if (tableData && typeof tableData === "object" && Array.isArray(tableData.monthdata)) {
                 tableData = tableData.monthdata;
             } else {
                 console.warn("Unexpected data format. Cannot render chart.");
                 return;
             }

             // Detect what kind of data this is: Buyer-based or Unit-based
             let isBuyerBased = tableData.length && "Buyer" in tableData[0];
             let isUnitBased = tableData.length && "Unit" in tableData[0];

             // Auto-reset irrelevant dropdown to "ALL"
             if (isBuyerBased) {
                 $(".dropdown-item.method.unit").removeClass("active");
                 $(".dropdown-item.method.unit[data-value='ALL']").addClass("active");
                 unitFilter = "ALL";
             } else if (isUnitBased) {
                 $(".dropdown-item.method.buyer").removeClass("active");
                 $(".dropdown-item.method.buyer[data-value='ALL']").addClass("active");
                 buyerFilter = "ALL";
             }

             if ((qltyType == "Tvl") || (qltyType == "Tminis") || (qltyType == "Tqty")) {
                populateAbstractTable(tableData, monthName, 'monthTable');

                $('.monthly_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
                $('.six_month_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
            }
            else{
                populateWorksTable(tableData, monthName, 'monthTable');
                $('.monthly_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
                $('.six_month_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
            }
 
             //const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");
             let filteredData = tableData.filter(item => {
                 if (item.Unit === "Total" || item.Buyer === "Total") return false;
             
                 if (isBuyerBased) {
                     return !buyerFilter || buyerFilter === "ALL" || item.Buyer === buyerFilter;
                 }
             
                 if (isUnitBased) {
                     return !unitFilter || unitFilter === "ALL" || item.Unit === unitFilter;
                 }
             
                 return true; // fallback if structure unexpected
             });
             
             if (!filteredData.length) {
                 console.warn("No data after filtering. Check response structure.");
                 alert(" Selected field is not available in the response for this type. Please select another field.");
                 return;
             }
 
             let labels = Object.keys(filteredData[0]).filter(key => {
                 return key !== "Unit" && key !== "Total" && !isNaN(Number(filteredData[0][key].toString().replace(/,/g, '').trim()));
             });
 
            let seriesData = filteredData.map((unitData, index) => {
                 let unitName = unitData["Unit"] || unitData["Buyer"];
                 let dataPoints = labels.map(date => {
                     let value = unitData[date];
 
                     if (typeof value === "string") {
                         value = value.replace(/,/g, "").trim();
                     }
 
                     let num = Number(value);
                     return isNaN(num) || value === "" || value === null || value === undefined ? 0 : num;
                 });
 
                 return {
                     name: unitName,
                     data: dataPoints
                 };
            });
            
            // // Render table headers
            // let tableHeadHtml = "<tr><th>" + (isBuyerBased ? "Buyer" : "Unit") + "</th>";
            // labels.forEach(label => {
            //     let dayOnly = label.split("_")[2]; // Only the day part
            //     tableHeadHtml += "<th>" + dayOnly + "</th>";
            // });
            // tableHeadHtml += "</tr>";
            // $("#monthTable thead").html(tableHeadHtml);

            // // Render table rows
            // let tableBodyHtml = "";
            // filteredData.forEach(row => {
            //     let rowLabel = row[isBuyerBased ? "Buyer" : "Unit"];
            //     tableBodyHtml += "<tr><td>" + rowLabel + "</td>";

            //     labels.forEach(key => {
            //         let value = row[key] || 0;
            //         if (typeof value === "string") {
            //             value = value.replace(/,/g, "").trim();
            //         }
            //         let num = Number(value);
            //         let displayVal = isNaN(num) ? "0" : (num / 100000).toFixed(1); // Value in lakhs
            //         tableBodyHtml += '<td onclick="datewiseproduction(this);" data-unit="'+(row['Unit'] || row['Buyer'])+'" style="cursor: pointer ; color: blue">' + displayVal + '</td>';
            //     });

            //     tableBodyHtml += "</tr>";
            // });
            // $("#monthTable tbody").html(tableBodyHtml);

            // $(".six_month_table_title").text(
            //     month+ " month | " +(qltyTypeNames[qltyType] || qltyType) + " Table | " + unitFilter + " Unit | " + buyerFilter + " Buyer"
            // );
 
            let desiredDays = [1, 7, 14, 21, 28];
            let matchedDays = new Set(); // to avoid duplicates
            let displayLabels = [];
            let allLabels = []; // <- NEW array with full label strings (e.g., 2025-03-01)
            
            for (let i = 0; i < labels.length; i++) {
                let label = labels[i];
                let cleanDateStr = label.replace(/_/g, "-");
                let dateObj = new Date(cleanDateStr);
            
                allLabels.push(cleanDateStr); // Save full label for tooltip
            
                if (isNaN(dateObj)) {
                    displayLabels.push(""); // Not a valid date
                    continue;
                }
            
                let day = dateObj.getDate();
            
                // Try to match to the nearest desired day
                let matched = false;
                for (let targetDay of desiredDays) {
                    if (day >= targetDay && !matchedDays.has(targetDay)) {
                        matchedDays.add(targetDay);
                        displayLabels.push(String(day).padStart(2, '0'));
                        matched = true;
                        break;
                    }
                }
            
                if (!matched) {
                    displayLabels.push(""); // Fill rest with blanks
                }
            }
            

            chartpred.updateOptions({
                chart: {
                    zoom: {
                        enabled: true,
                        type: 'x',
                        autoScaleYaxis: true
                    }
                },
                xaxis: {
                    labels: {
                        showDuplicates: true
                    }
                },
                title: {
                     text: month+ " month | " +(qltyTypeNames[qltyType])+" Chart | "+unitFilter+" Unit | "+buyerFilter+" Buyer",
                     align: 'center',
                     style: {
                         fontSize: '12px',
                         color: 'black',
                     }
                 },
                xaxis: {
                    categories: displayLabels
                },
                yaxis: {
                    labels: {
                        formatter: function (val) {
                            if (val >= 10000000) return (val / 10000000).toFixed(1) + " Cr"; // Crore
                            else if (val >= 100000) return (val / 100000) + " L"; // Lakh
                            else if (val >= 1000) return (val / 1000) + " K";     // Thousand
                            return val;
                        }
                    }
                },
                tooltip: {
                    enabled: true,
                    shared: true,
                    intersect: false,
                    x: {
                        formatter: function (val, opts) {
                            return allLabels[opts.dataPointIndex] || "";
                        }
                    },
                    y: {
                        formatter: function (val) {
                            if (val >= 10000000) return (val / 10000000).toFixed(1) + " Cr";
                            if (val >= 100000) return (val / 100000).toFixed(1) + " L";
                            if (val >= 1000) return (val / 1000).toFixed(1) + " K";
                            return val.toLocaleString();
                        },
                        title: {
                            formatter: function (seriesName) {
                                return seriesName;
                            }
                        }
                    }
                },
                
                series: seriesData
            });
         },
         error: function (xhr, status, error) {
             console.error("Error fetching data:", error);
         }
     });
} // fdate tdate 

 // Event Listeners for dropdowns
 $(document).on("click", ".dropdown-item.method.opt", function () {
     $(".dropdown-item.method.opt").removeClass("active");
     $(this).addClass("active");
     updateQltyChart(); 
 });
 $(document).on("click", ".dropdown-item.method.unit", function () {
     $(".dropdown-item.method.unit").removeClass("active");
     $(this).addClass("active");
     updateQltyChart();
 });
 
 $(document).on("click", ".dropdown-item.method.buyer", function () {
     $(".dropdown-item.method.buyer").removeClass("active");
     $(this).addClass("active");
     updateQltyChart();
 });
 

 $(document).on("click", "#full_screendefect", function () {
     let chartContainer = document.querySelector("#chartpred");
     if (chartpred) {
        chartpred.updateOptions({
            chart: {
                height: 750 // your default height
            }
        });
    }
 
     function removeFullscreenMode() {
         chartContainer.classList.remove("fullscreen-mode");
 
         // Reset chart height
         if (chartpred) {
             chartpred.updateOptions({
                 chart: {
                     height: 230 // your default height
                 }
             });
         }
     }
 
     if (!document.fullscreenElement) {
         chartContainer.classList.add("fullscreen-mode");
 
         if (chartContainer.requestFullscreen) {
             chartContainer.requestFullscreen();
         } else if (chartContainer.webkitRequestFullscreen) {
             chartContainer.webkitRequestFullscreen();
         } else if (chartContainer.msRequestFullscreen) {
             chartContainer.msRequestFullscreen();
         }
 
         // Expand chart height to match full screen
         if (chartpred) {
             chartpred.updateOptions({
                 chart: {
                     height: window.innerHeight - 50 // leave a little padding
                 }
             });
         }
 
         document.addEventListener("fullscreenchange", () => {
             if (!document.fullscreenElement) removeFullscreenMode();
         });
         document.addEventListener("webkitfullscreenchange", () => {
             if (!document.webkitFullscreenElement) removeFullscreenMode();
         });
         document.addEventListener("mozfullscreenchange", () => {
             if (!document.mozFullScreenElement) removeFullscreenMode();
         });
         document.addEventListener("MSFullscreenChange", () => {
             if (!document.msFullscreenElement) removeFullscreenMode();
         });
 
     } else {
         document.exitFullscreen();
         
     }
 });
 
$(document).ready(function() {
    $(".dropdown-item.method.opt[data-value='Tvl']").addClass("active");
    $(".dropdown-item.method.unit[data-value='ALL']").addClass("active"); 
    $(".dropdown-item.method.buyer[data-value='ALL']").addClass("active"); 

    updateQltyChart().done(function() {
        $(".dropdown-item.month.opt[data-value='Tvl']").addClass("active");  
        updatemonthlyChart();   
    });
});


// (Tvl, Tminis, Tqty, Total_OWE, Tailor, packing, cutting ) charts - end pooja    

// static daily chart - start pooja
$(document).ready(function() {
$("#preloder").fadeIn();

$.ajax({
 url: routesMap.barChart,
 method: 'GET',
 success: function(response) {
         if (response.success) {
             // Execute the functions after the fadeOut is complete
             populateAppstrikeTable(response.data.listdata);
             generateBarChart(response.data.listdata);
             //populateMonthData(response.data.monthdata, response.data.monthkey);
             //populatePortalTVL(response.data.portaltval, response.data.portalkey);
             //populatePortalQTY(response.data.portaltqty, response.data.portqtykey);
         } else {
             console.error("API returned success false.");
             
         }  
                      
 },
 error: function() {
     console.log("Error fetching data.");
 }
});

});

function formatIndianNumber12(x) {
var parts = x.toString().split(".");
var lastThree = parts[0].slice(-3);
var otherNumbers = parts[0].slice(0, -3);
if (otherNumbers !== '') {
 lastThree = ',' + lastThree;
}
return formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
//return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
}

function populateAppstrikeTable(data) {
const $tableBody = $('#tableAppstrike tbody');
const $accessTypeDropdown = $('#accessTypeDropdown');
const accessTypes = new Set();

$tableBody.empty();
let totalAppAmount = 0;
let totalUnAppAmount = 0;
let earnminis = 0;
let wip = 0;
let ackped = 0;
let smstock = 0;

$.each(data, function(index, item) {
 let appAmount = item.Input;
 let unappAmount = item.Output;
 let totalearn = item.Ern_Mins;
 let totalackped = item.Ack_Pend;
 let totalsmstock = item.SM_Stock;
 let totalwip = item.Wip;

 const row = `
 <tr>
     <td>${index + 1}</td>
     <td>${item.Unit}</td>
     <td >${formatIndianNumber12(item.Input)}</td>
     <td >${formatIndianNumber12(item.Output)}</td>
     <td >${formatIndianNumber12(item.Ern_Mins)}</td>
     <td >${formatIndianNumber12(item.Ack_Pend)}</td>
     <td >${formatIndianNumber12(item.SM_Stock)}</td>
     <td >${formatIndianNumber12(item.Wip)}</td>
  
 </tr>
`;
 $tableBody.append(row);

 totalAppAmount += parseFloat(appAmount) || 0;
 totalUnAppAmount += parseFloat(unappAmount) || 0;
 earnminis += parseFloat(totalearn) || 0;
 wip += parseFloat(totalwip) || 0;
 ackped += parseFloat(totalackped) || 0;
 smstock += parseFloat(totalsmstock) || 0;

 accessTypes.add(item.Access_Type);
});

$('#inputqty').text(formatIndianNumber12(totalAppAmount));
$('#outputqty').text(formatIndianNumber12(totalUnAppAmount));
$('#earnminis').text(formatIndianNumber12(earnminis));
$('#wip').text(formatIndianNumber12(wip));
$('#ack_ped').text(formatIndianNumber12(ackped));
$('#sm_stock').text(formatIndianNumber12(smstock));

$accessTypeDropdown.empty();
$accessTypeDropdown.append('<option value="">All Access Types</option>');
accessTypes.forEach(function(accessType) {
 $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
});

if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
 appstrikeTable = $('#tableAppstrike').DataTable({
     paging: false,
     searching: false,
     ordering: false,
     info: false,
 });
}
}

function getTableData() {
var labels = [];
var inputData = [];
var outputData = [];
var earnMinisData = [];
var ackpedData = [];
var smstockData = [];
var wipData = [];

$('#tableAppstrike tbody tr').each(function() {
 var machineName = $(this).find('td').eq(1).text();
 var input = $(this).find('td').eq(2).text();
 var output = $(this).find('td').eq(3).text();
 var earnMinis = $(this).find('td').eq(4).text();
 var ackped = $(this).find('td').eq(5).text();
 var smstock = $(this).find('td').eq(6).text();
 var wip = $(this).find('td').eq(7).text();

 labels.push(machineName.trim());
 inputData.push(parseInt(input.replace(/,/g, '')) || 0);
 outputData.push(parseInt(output.replace(/,/g, '')) || 0);
 earnMinisData.push(parseInt(earnMinis.replace(/,/g, '')) || 0);
 ackpedData.push(parseInt(ackped.replace(/,/g, '')) || 0);
 smstockData.push(parseInt(smstock.replace(/,/g, '')) || 0);
 wipData.push(parseInt(wip.replace(/,/g, '')) || 0);
});

return {
 labels,
 inputData,
 outputData,
 earnMinisData,
 ackpedData,
 smstockData,
 wipData
};
}

function generateBarChart() {
const data = getTableData();
const options = {
 chart: {
     type: 'bar',
     height: 250,
     toolbar: { show: false },
 },
 series: [
     {
         name: 'Input Qty',
         data: data.inputData
     },
     {
         name: 'Output Qty',
         data: data.outputData
     },
     {
         name: 'Earned Mins',
         data: data.earnMinisData
     },
     {
         name: 'Ack Ped',
         data: data.ackpedData
     },
     {
         name: 'SM Stock',
         data: data.smstockData
     },
     {
         name: 'WIP Qty',
         data: data.wipData
     }
 ],
 dataLabels: { enabled: false },
 xaxis: {
     categories: data.labels,
     title: {
         text: 'Units'
     }
 },
 yaxis: {
     title: {
         text: 'Quantities / Minutes'
     },
     labels: {
        formatter: function (val) {
            if (val >= 10000000) return (val / 10000000).toFixed(1) + " Cr"; // Crore
            else if (val >= 100000) return (val / 100000) + " L"; // Lakh
            else if (val >= 1000) return (val / 1000) + " K";     // Thousand
            return val;
        }
    }
 },
 legend: {
     position: 'top'
 },
 colors: ['#4bc0c0', '#36a2eb', '#ffce56', '#ff6384', '#65cb5a', '#9966ff'],
 tooltip: {
     shared: true,
     intersect: false
 },
 plotOptions: {
     bar: {
         horizontal: false,
     }
 }
};

// Destroy existing chart if any
if (window.apexChart) {
 window.apexChart.destroy();
}

// Create new ApexChart instance
window.apexChart = new ApexCharts(document.querySelector("#barChart"), options);
window.apexChart.render();
$("#preloder").fadeOut();
}
// static daily chart - end pooja

// monthly table - start pooja
let monthlychart;
document.addEventListener("DOMContentLoaded", function () {
    const chartOptions = {
    chart: {
        type: 'area',
        height: 250,
        id: 'monthlychart',
        toolbar: {
            show: false 
        },
    },
    tooltip: {
        enabled: false 
    },
    dataLabels: {
        enabled: false 
    },
    series: [],
    xaxis: {
        categories: []
    },
};

monthlychart = new ApexCharts(document.querySelector("#monthlychart"), chartOptions);
monthlychart.render();

});

function formatCompactNumber(value) {
    var selectedoption = $('#select_option').val();
    //console.log(selectedoption);
    if (selectedoption == 'Tqty') {
        return (value);
    } else {
        return (value / 100000).toFixed(2);
    }

}

// Function to populate Abstract Table
function populateAbstractTable(data, orderNo, tableId) {
    //console.log(data);
    const $table = $('#' + tableId);
    const $tableBody = $table.find('tbody');
    $tableBody.empty();

    if (!data || data.length === 0) {
        //("No data available to populate.");
        return;
    }

    var headers = Object.keys(data[0]);

    // Dynamically create table headers
    var thead = '<tr>';
    headers.forEach(function(header) {
        var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
        if (dateFormatRegex.test(header)) {
            var parts = header.split('_');
            var month = parts[0];
            var year = parts[1];
            var day = parts[2];
            var headercol = day;

        } else {
            var headercol = header;
        }

        thead += '<th>' + headercol + '</th>';
    });
    thead += '</tr>';
    $table.find('thead').html(thead);

    // Dynamically create table rows
    var tbody = '';
    data.forEach(function(row) {
        tbody += '<tr>';
        headers.forEach(function(header) {
            if ($.isNumeric(row[header])) {

                var tdata = formatCompactNumber(row[header]);
            } else {
                var tdata = row[header];
            }
            if(header=='Unit' || header=='Total'|| row['Unit']=='Total' ){
                tbody += '<td data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
            }else{
                tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
            }
        });
        tbody += '</tr>';
    });
    $table.find('tbody').html(tbody); // Insert rows into abstract table


}

function populateWorksTable(data, orderNo, tableId) {
    const $table = $('#' + tableId);
    const $tableBody = $table.find('tbody');
    $tableBody.empty();

    if (!data || data.length === 0) {
        console.log("No data available to populate.");
        return;
    }

    var headers = Object.keys(data[0]);

    // Dynamically create table headers
    var thead = '<tr>';
    headers.forEach(function(header, index) {
        var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
        if (index !== headers.length - 1) {
            if (dateFormatRegex.test(header)) {
                var parts = header.split('_');
                var month = parts[0];
                var year = parts[1];
                var day = parts[2];
                var headercol = day;

            } else {
                var headercol = header;
            }

            thead += '<th>' + headercol + '</th>';
        }
    });
    thead += '</tr>';
    $table.find('thead').html(thead);


    // Dynamically create table rows
    var tbody = '';
    data.forEach(function(row) {
        tbody += '<tr>';
        headers.forEach(function(header, index) {
            // Check if it's the last column and skip adding it
            if (index !== headers.length - 1) {
                //tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + row[header] + '</td>';

                if(header=='Unit' || header=='Total'  || header=='Buyer' || row['Unit']=='Over All' || row['Unit']=='Total' || row['Buyer']=='Total' ){
                    tbody += '<td data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + row[header] + '</td>';
                }else{
                        tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+(row['Unit'] || row['Buyer'])+'" data-dateno="'+header+'">' + row[header] + '</td>';
                    
                }
            }
        });
        tbody += '</tr>';
    });
    $table.find('tbody').html(tbody);
}

function datewiseproduction(val) {
    let Unit = $(val).data("unit");
    let optdate = $(val).data("dateno");
    //let qltyType = $(".dropdown-item.month.opt.active").data("value") || "Tvl";
    let qltyType = $(".dropdown-item.method.opt.active").data("value") || "Tvl";
    let qltyTypeNames = {
        "Tvl": "Turn Over",
        "Tminis": "Earned Minutes",
        "Tqty": "Production Qty",
        "Total_OWE": "OWE",
        "Tailor": "Tailor",
        "cutting_status": "Cutting Status",
        "packing": "Packing"
    };
    let optname = qltyType;
    let selectedText = qltyTypeNames[qltyType];
    $("#preloder").fadeIn();

    $.ajax({
        url: routesMap.datewiseproduction,
        method: 'GET',
        data: { optdate: optdate, Unit: Unit, optname: optname },
        success: function (response) {
            //console.log(response);
            // Destroy old DataTable if it exists
            if ($.fn.DataTable.isDataTable('#productionTable')) {
                $('#productionTable').DataTable().clear().destroy();
            }

            if ((!response.data) || (response.data.length === 0)) {
                alert("No data found");
                $("#preloder").fadeOut();
                return;
            }

            // If modal doesn't exist, append it
            if ($('#productionModal').length === 0) {
                $('body').append(`
                    <div class="modal fade" id="productionModal" tabindex="-1">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="productionModalLabel"></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <table id="productionTable" class="table table-bordered" style="width:100%">
                                        <thead></thead>
                                        <tbody></tbody>
                                        <tfoot></tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                `);
            }
            if (optdate) {
                let parts = optdate.split('_');
                formatdate = `${parts[2]}/${parts[1]}/${parts[0]}`; // dd/mm/yyyy
            }
            
            $('#productionModalLabel').text(`${selectedText} Datewise Production - ${formatdate}`);

            // Extract columns
            const columns = Object.keys(response.data[0]);

            // Build table header
            let theadHtml = '<tr>';
            columns.forEach(col => {
                theadHtml += `<th>${col}</th>`;
            });
            theadHtml += '</tr>';
            $('#productionTable thead').html(theadHtml);

            let totalColumns = ['Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Turn_Over_Val', 'Tailor', 'Worker', 'Total', 'Production', 'OWE', 'Cut_Qty', 'Packed'];

            // Build table body
            let tbodyHtml = '';
            response.data.forEach(row => {
                tbodyHtml += '<tr>';
                columns.forEach(col => {
                    let tdClass = totalColumns.includes(col) ? 'text-end' : '';
                    tbodyHtml += `<td class="${tdClass}">${row[col]}</td>`;
                });
                tbodyHtml += '</tr>';
            });
            $('#productionTable tbody').html(tbodyHtml);

            // Build table footer
            let tfootHtml = '<tr>'; 
            columns.forEach((col, index) => {
                if (index === 0) {
                    tfootHtml += `<th class="text-end">Total :</th>`;
                } else {
                    tfootHtml += `<th class="text-end"></th>`;
                }
            });
            tfootHtml += '</tr>';

            $('#productionTable tfoot').html(tfootHtml);

            // Initialize DataTable
            let dt = $('#productionTable').DataTable({
                responsive: true,
                autoWidth: false,
                paging: false,
                ordering: true,
                footerCallback: function (row, data, start, end, display) {
                    let api = this.api();
                    let totalColumns = ['Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Turn_Over_Val', 'Tailor', 'Worker', 'Total', 'Production', 'OWE', 'Cut_Qty', 'Packed'];

                    let columnIndicesToTotal = [];
                    
                    // Find indices based on header names
                    api.columns().every(function (index) {
                        let colTitle = $(this.header()).clone().children('select').remove().end().text().trim();
                        if (totalColumns.includes(colTitle)) {
                            columnIndicesToTotal.push(index);
                        }
                    });

                    // Recalculate totals for visible (filtered) data only
                    columnIndicesToTotal.forEach(function (colIdx) {
                        let total = api.column(colIdx, { search: 'applied' }).data().reduce((a, b) => {
                            const x = parseFloat(String(a).replace(/,/g, '')) || 0;
                            const y = parseFloat(String(b).replace(/,/g, '')) || 0;
                            return x + y;
                        }, 0);

                        $(api.column(colIdx).footer()).html(
                            total.toLocaleString(undefined, { maximumFractionDigits: 2 })
                        );
                    });
                }
            });

            // Show the modal
            let modalEl = document.getElementById('productionModal');
            let modal = new bootstrap.Modal(modalEl);
            $("#preloder").fadeOut();
            modal.show();

            // Redraw table after modal shown
            $(modalEl).off('shown.bs.modal').on('shown.bs.modal', function () {
                dt.columns.adjust().draw();
            });
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            alert("Error loading data.");
        }
    });
}

let selectedMonth = null;
let selectedYear = null;
let monthPickerInstance = null;

$(document).on("click", "#monthlycalendarIcon", function () {
    monthPickerInstance = flatpickr("#monthPicker", {
        dateFormat: "Y-m",
        defaultDate: new Date(),
        plugins: [
            new monthSelectPlugin({
                shorthand: true,
                dateFormat: "Y-m",
                altFormat: "F Y",
                theme: "light"
            })
        ],
        onChange: function(selectedDates, dateStr) {
            let [year, month] = dateStr.split("-");
            selectedMonth = month;
            selectedYear = year;
            updatemonthlyChart();
        }
    });

    monthPickerInstance.open();
});

let monthNames = [
    "January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
];

function updatemonthlyChart() {

    let qltyType = $(".dropdown-item.month.opt.active").data("value") || "Tvl";
    let qltyTypeNames = {
        "Tvl": "Turn Over",
        "Tminis": "Earned Minutes",
        "Tqty": "Production Qty",
        "Total_OWE": "OWE",
        "Tailor": "Tailor",
        "cutting_status": "Cutting Status",
        "packing": "Packing"
    };
    let month = selectedMonth || "Mar";
    let year = selectedYear || 2025; 
    let monthIndex = parseInt(month, 10) - 1;
    let monthName = monthNames[monthIndex] || "March";
    let ajaxUrl = routesMap[qltyType] || "{{ route('operationreport') }}";
    let requestData = {
        year: year,
        month: month,
        type: qltyType,
    };

    $.ajax({
        url: ajaxUrl,
        method: "GET",
        data: requestData,
        success: function (response) {
            
            if (!response || !response.data) {
                console.error("Invalid response format:", response);
                return;
            }

            let tableData = response.data;
            
            if (Array.isArray(tableData)) {
             
            } else if (tableData && typeof tableData === "object" && Array.isArray(tableData.monthdata)) {
                tableData = tableData.monthdata;
            } else {
                console.warn("Unexpected data format. Cannot render chart.");
                return;
            } 

            if ((qltyType == "Tvl") || (qltyType == "Tminis") || (qltyType == "Tqty")) {
                populateAbstractTable(tableData, monthName);
                $('.monthly_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
            }
            else{
                populateWorksTable(tableData, monthName);
                $('.monthly_table_title').text(monthName + ' Month (Sewing) '+(qltyTypeNames[qltyType])+' Details');
            }

            let filteredData = tableData.filter(unitData => unitData.Unit !== "Total");
            
            if (!filteredData.length) {
                console.warn("No data after filtering. Check response structure.");
                //alert(" Selected field is not available in the response for this type. Please select another field.");
                return;
            }

            let labels = Object.keys(filteredData[0]).filter(key => {
                return key !== "Unit" && key !== "Total" && !isNaN(Number(filteredData[0][key].toString().replace(/,/g, '').trim()));
            });

            let seriesData = filteredData.map((unitData, index) => {
                let unitName = unitData["Unit"] || unitData["Buyer"];
                let dataPoints = labels.map(date => {
                    let value = unitData[date];

                    if (typeof value === "string") {
                        value = value.replace(/,/g, "").trim();
                    }

                    let num = Number(value);
                    return isNaN(num) || value === "" || value === null || value === undefined ? 0 : num;
                });

                return {
                    name: unitName,
                    data: dataPoints
                };
            });

            monthlychart.updateOptions({
                chart: {
                    type: 'area',
                    height: 230,
                    id: 'monthlychart',
                    toolbar: {
                        show: false 
                    },
                },
                title: {
                    text: monthName+" Month - "+(qltyTypeNames[qltyType])+" Chart ",
                    align: 'center',
                    style: {
                        fontSize: '12px',
                        color: 'black',
                    }
                },
                xaxis: { categories: labels },
                yaxis: {
                    labels: {
                        formatter: function (val) {
                            if (val >= 10000000) return (val / 10000000).toFixed(1) + " Cr"; // Crore
                            else if (val >= 100000) return (val / 100000) + " L"; // Lakh
                            else if (val >= 1000) return (val / 1000) + " K";     // Thousand
                            return val;
                        }
                    }
                },
                series: seriesData
            });
            
        },
        error: function (xhr, status, error) {
            console.error("Error fetching data:", error);
        }
    });
} 

// Event Listeners for dropdowns
$(document).on("click", ".dropdown-item.month.opt", function () {
    $(".dropdown-item.month.opt").removeClass("active");
    $(this).addClass("active");
    updatemonthlyChart(); 
});

// monthly table - end pooja

//Today production drilldown popup
$(document).on('click', '.tdayFooterTotal', function (e) {
    e.preventDefault();

        const optdate = $(this).data('opt');

        $("#DefectDetailsModal").modal("show");
        $("#DefectOcnDetailsModalLabel").text(`Today's Production Details - ${optdate}`);
        $("#OcnDefectDetailsContent").html("<p class='text-center fw-bold'>Loading Data</p>");

        $.ajax({
            url: routesMap.defectDetails,
            method: 'GET',
            data: { optdate },
            success: function (response) {
                

                let data = response.data || [];
                if (data.length === 0) {
                    $("#OcnDefectDetailsContent").html("<p>No data available.</p>");
                    return;
                }

                // Build table headers and body
                let tableHtml = `<table class='table table-hover table-bordered' id='presentationchkdef'>
                    <thead style='position: sticky; top: 0; z-index: 10'><tr>` +
                    Object.keys(response.data[0]).map((key, index) =>
                        `<th id="header-${key}">${key}<br><select style="width: 100%;" id="filter-${index}"><option value="">All</option></select></th>`
                    ).join('') +
                    `</tr></thead><tbody>`;

                let totalColumns = ['Input', 'Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Ack_Pend', 'Stock', 'Wip'];

                response.data.forEach((row, rowIndex) => {
                    tableHtml += `<tr>` +
                        Object.entries(row).map(([key, value]) => {
                            let cellId = `cell-${key}-${rowIndex + 1}`;
                            let tdClass = totalColumns.includes(key) ? 'text-end' : '';
                            return `<td id="${cellId}" class="${tdClass}">${value}</td>`;
                        }).join('') +
                        `</tr>`;
                });

                tableHtml += `</tbody><tfoot style='position: sticky; bottom: 0; z-index: 10'><tr>` +
                Object.keys(response.data[0]).map((key, index) => {
                    if (index === 0) {
                        return `<th class="text-end">Total :</th>`;
                    } else {
                        return `<th class="text-end" id="footer-${key}"></th>`;
                    }
                }).join('') +
                `</tr></tfoot></table>`;

                $("#OcnDefectDetailsContent").html(tableHtml);
                $('#presentationchkdef').css({ 'font-size': '10px' });
                $('#presentationchkdef th').css({ 'padding': '4px 6px' });

                // Initialize DataTable
                let table = $('#presentationchkdef').DataTable({
                    paging: false,
                    searching: true,
                    ordering: false,
                    initComplete: function () {
                        let inputFieldMap = {
                            'Unit': '#unitInput',
                            'Buyer': '#buyerInput',
                            'Order_No': '#orderNoInput',
                            'Item': '#itemInput',
                            'Color': '#colorInput',
                            'Input': '#inputQty'
                        };

                        this.api().columns().every(function () {
                            let column = this;
                            let index = column.index();
                            let select = $(`#filter-${index}`);

                            let uniqueSet = new Set();
                            column.data().each(function (d) {
                                if (d) uniqueSet.add(d);
                            });

                            Array.from(uniqueSet).sort().forEach(val => {
                                select.append(`<option value="${val}">${val}</option>`);
                            });

                            select.on('change', function () {
                                let val = $.fn.dataTable.util.escapeRegex($(this).val());
                                column.search(val ? `^${val}$` : '', true, false).draw();

                                // Sync to inputs if mapped
                                let headerText = $(column.header()).clone().children('select').remove().end().text().trim();
                                let inputSelector = inputFieldMap[headerText];
                                if (inputSelector) $(inputSelector).val(val);

                                // Update all dropdowns based on visible column cells only
                                table.columns().every(function () {
                                    let col = this;
                                    let colIndex = col.index();
                                    let selectElem = $(`#filter-${colIndex}`);
                                    let currentValue = selectElem.val(); // store current selected value

                                    let visibleVals = new Set();

                                    // Loop through visible rows only
                                    col.nodes().to$().each(function () {
                                        let cell = $(this);
                                        if (cell.closest('tr').is(':visible')) {
                                            const cellText = cell.text().trim();
                                            if (cellText !== '') visibleVals.add(cellText);
                                        }
                                    });

                                    // Clear and repopulate dropdown
                                    selectElem.empty().append(`<option value="">All</option>`);
                                    Array.from(visibleVals).sort().forEach(v => {
                                        let selected = (v === currentValue) ? 'selected' : '';
                                        selectElem.append(`<option value="${v}" ${selected}>${v}</option>`);
                                    });
                                });
                            });

                        });
                    },

                    footerCallback: function (row, data, start, end, display) {
                        let api = this.api();
                        let totalColumns = ['Input', 'Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Ack_Pend', 'Stock', 'Wip'];

                        let columnIndicesToTotal = [];
                        
                        // Find indices based on header names
                        api.columns().every(function (index) {
                            let colTitle = $(this.header()).clone().children('select').remove().end().text().trim();
                            if (totalColumns.includes(colTitle)) {
                                columnIndicesToTotal.push(index);
                            }
                        });

                        // Recalculate totals for visible (filtered) data only
                        columnIndicesToTotal.forEach(function (colIdx) {
                            let total = api.column(colIdx, { search: 'applied' }).data().reduce((a, b) => {
                                const x = parseFloat(String(a).replace(/,/g, '')) || 0;
                                const y = parseFloat(String(b).replace(/,/g, '')) || 0;
                                return x + y;
                            }, 0);

                            $(api.column(colIdx).footer()).html(
                                total.toLocaleString(undefined, { maximumFractionDigits: 2 })
                            );
                        });
                    }

                });
            },
            error: function (xhr, status, error) {
                console.error("Drilldown Fetch Error:", error);
                $("#OcnDefectDetailsContent").html("<p class='text-danger'>Error loading data. Try again.</p>");
            }
        });
});
// monthly table - end pooja

