

(() => {
$(document).ready(function() {




    function fadeOutLoader() {
        return new Promise((resolve) => {
            $("#preloder").fadeOut(300, resolve);
        });
    }

    $(document).ready(function() {


        function fadeOutLoader() {
            return new Promise((resolve) => {
                $("#preloder").fadeOut(300, resolve);
            });
        }

        $.ajax({
            url: window.LaravelRoutes.operationDashboard,
            method: 'GET',
           
            success: function(response) {
                console.log("Fetching data from API...")
                fadeOutLoader().then(() => {
                    console.log("Full API Response:", response);
                    console.log("response.success:", response.success);

                    console.log("{{ $logMessage }}");

                    if (response.success) {
                        // Execute the functions after the fadeOut is complete
                        populateAppstrikeTable(response.data.listdata);
                        generateBarChart(response.data.listdata);
                        populateMonthData(response.data.monthdata, response.data.monthkey);
                        populatePortalTVL(response.data.portaltval, response.data.portalkey);
                        populatePortalQTY(response.data.portaltqty, response.data.portqtykey);
                    } else {
                        console.error("API returned success false.");
                    }
                });
            },
            error: function() {
                console.log("Error fetching data.");
                // Fade out the loader even in case of error
                fadeOutLoader();
            }
        });

    });

    

});




function populateAppstrikeTable(data) {
    const $tableBody = $('#tableAppstrike tbody');
    const $accessTypeDropdown = $('#accessTypeDropdown');
    const accessTypes = new Set();

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;
    let ack_ped = 0;
    let sm_stock = 0;

    $.each(data, function(index, item) {
        let appAmount = item.Input;
        let unappAmount = item.Output;
        let totalearn = item.Ern_Mins;
        let totalackped = item.Ack_Pend;
        let totalsmstock = item.SM_Stock;
        let totalwip = item.Wip;
        const row = `
        <tr>
            <td>${index + 1}</td>
            <td>${item.Unit}</td>
            <td >${formatIndianNumber12(item.Input)}</td>
            <td >${formatIndianNumber12(item.Output)}</td>
            <td >${formatIndianNumber12(item.Ern_Mins)}</td>
            <td >${formatIndianNumber12(item.Ack_Pend)}</td>
            <td >${formatIndianNumber12(item.SM_Stock)}</td>
            <td >${formatIndianNumber12(item.Wip)}</td>
         
        </tr>
    `;
        $tableBody.append(row);
         console.log('itemsgchgcgh',item.Input);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;
        ack_ped += parseFloat(totalackped) || 0;
        sm_stock += parseFloat(totalsmstock) || 0;

        accessTypes.add(item.Access_Type);
    });

    $('#totalAppQtyStrike').text(parseInt(totalAppAmount));
    $('#totalAppAmountStrike').text(totalUnAppAmount);
    $('#earnminis').text(earnminis);
    $('#wip').text(wip);
    $('#ack_ped').text(ack_ped);
    $('#sm_stock').text(sm_stock);

    $accessTypeDropdown.empty();
    $accessTypeDropdown.append('<option value="">All Access Types</option>');
    accessTypes.forEach(function(accessType) {
        $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
    });

    if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
        let appstrikeTable = $('#tableAppstrike').DataTable({
            paging: false,
            searching: false,
            ordering: false,
            info: false,
            drawCallback: function() {
                let totalFilteredAppQty = 0;
                let totalFilteredAppAmount = 0;

                $('#tableAppstrike tbody tr:visible').each(function() {
                    const appQty = parseFloat($(this).find('td:nth-child(3)').text()) || 0;
                    const appAmount = parseFloat($(this).find('td:nth-child(4)').text()) || 0;

                    totalFilteredAppQty += appQty;
                    totalFilteredAppAmount += appAmount;
                });

                $('#totalAppQtyStrike').text(parseInt(totalFilteredAppQty));
                $('#totalAppAmountStrike').text(parseInt(totalFilteredAppAmount));
            }
        });
    }
}

function getTableData1() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableAppMonth tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();
            //(total);

            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}


function populateMonthData(data, Key) {
    const $tableBody = $('#tableAppMonth tbody');
    const $accessTypeDropdown = $('#accessTypeDropdown');
    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableAppMonth').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
        <tr>
            
            <td>${item[unit]}</td>
            <td >${formatIndianNumber1(item[M1])}</td>
            <td >${formatIndianNumber1(item[M2])}</td>
            <td >${formatIndianNumber1(item[M3])}</td>
            <td >${formatIndianNumber1(item[M4])}</td>
            <td >${formatIndianNumber1(item[M5])}</td>
            <td >${formatIndianNumber1(item[M6])}</td>
           
            <td style="text-align:right;font-weight:bold">${formatIndianNumber1(item[M7])}</td>
         
        </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableData1(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}







function formatIndianNumber12(x) {
    var parts = x.toString().split(".");
    var lastThree = parts[0].slice(-3);
    var otherNumbers = parts[0].slice(0, -3);
    var formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
    if (otherNumbers !== '') {
        lastThree = ',' + lastThree;
    }
    return formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
    //return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
}


function populateAppstrikeTable(data) {
    const $tableBody = $('#tableAppstrike tbody');
    const $accessTypeDropdown = $('#accessTypeDropdown');
    const accessTypes = new Set();

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;
    let ackped = 0;
    let smstock = 0;

    $.each(data, function(index, item) {
        let appAmount = item.Input;
        let unappAmount = item.Output;
        let totalearn = item.Ern_Mins;
        let totalackped = item.Ack_Pend;
        let totalsmstock = item.SM_Stock;
        let totalwip = item.Wip;

        console.log('items',item.Input);
        //(item.Output);
        //(item.Ern_Mins);
        //(item.Ack_Pend);
        //(item.SM_Stock);
        //(item.Wip);

    //     const row = `
    //     <tr>
    //         <td>${index + 1}</td>
    //         <td>${item.Unit}</td>
    //         <td >${formatIndianNumber12(item.Input)}</td>
    //         <td >${formatIndianNumber12(item.Output)}</td>
    //         <td >${formatIndianNumber12(item.Ern_Mins)}</td>
    //         <td >${formatIndianNumber12(item.Ack_Pend)}</td>
    //         <td >${formatIndianNumber12(item.SM_Stock)}</td>
    //         <td >${formatIndianNumber12(item.Wip)}</td>
         
    //     </tr>
    // `;


    const row = `
    <tr>
        <td>${index + 1}</td>
        <td>${item.Unit}</td>
        <td >${formatIndianNumber12(item.Input)}</td>
        <td >${item.Output}</td>
        <td >${item.Ern_Mins}</td>
        <td >${item.Ack_Pend}</td>
        <td >${item.SM_Stock}</td>
        <td >${item.Wip}</td>
        
     
    </tr>
`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;
        ackped += parseFloat(totalackped) || 0;
        smstock += parseFloat(totalsmstock) || 0;

        accessTypes.add(item.Access_Type);
    });

    $('#inputqty').text(formatIndianNumber12(totalAppAmount));
    $('#outputqty').text(formatIndianNumber12(totalUnAppAmount));
    $('#earnminis').text(formatIndianNumber12(earnminis));
    $('#wip').text(formatIndianNumber12(wip));
    $('#ack_ped').text(formatIndianNumber12(ackped));
    $('#sm_stock').text(formatIndianNumber12(smstock));

    $accessTypeDropdown.empty();
    $accessTypeDropdown.append('<option value="">All Access Types</option>');
    accessTypes.forEach(function(accessType) {
        $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
    });

    if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
        let appstrikeTable = $('#tableAppstrike').DataTable({
            paging: false,
            searching: false,
            ordering: false,
            info: false,
            drawCallback: function() {
                let totalFilteredAppQty = 0;
                let totalFilteredAppAmount = 0;

                $('#tableAppstrike tbody tr:visible').each(function() {
                    const appQty = parseFloat($(this).find('td:nth-child(3)').text()) || 0;
                    const appAmount = parseFloat($(this).find('td:nth-child(4)').text()) || 0;

                    totalFilteredAppQty += appQty;
                    totalFilteredAppAmount += appAmount;
                });

                $('#totalAppQtyStrike').text(parseInt(totalFilteredAppQty));
                $('#totalAppAmountStrike').text(parseInt(totalFilteredAppAmount));
            }
        });
    }
}



// Function to generate the bar chart


$(document).ready(function () {
    // Function to extract data from the table
    function getTableData() {
        var labels = [];
        var inputData = [];
        var outputData = [];
        var earnMinisData = [];
        var wipData = [];
        var ackpedData = [];
        var smstockData = [];
    
        // Get table rows and extract data from each row
        
            $('#tableAppstrike tbody tr').each(function() {
                var machineName = $(this).find('td').eq(1).text();
                var input = $(this).find('td').eq(2).text();
                var output = $(this).find('td').eq(3).text();
                var earnMinis = $(this).find('td').eq(4).text();
                var ackped = $(this).find('td').eq(5).text();
                var smstock = $(this).find('td').eq(6).text();
                var wip = $(this).find('td').eq(7).text();
        
                labels.push(machineName);
                inputData.push(parseInt(input.replace(/,/g, ''), 10));
                outputData.push(parseInt(output.replace(/,/g, ''), 10));
                earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                ackpedData.push(parseInt(ackped.replace(/,/g, ''), 10));
                smstockData.push(parseInt(smstock.replace(/,/g, ''), 10));
            });
    
        
        return {
            labels: labels,
            inputData: inputData,
            outputData: outputData,
            earnMinisData: earnMinisData,
            ackpeddata: ackpedData,
            smstockdata: smstockData,
    
            wipData: wipData
        };
    }
    
    });

    $(document).ready(function () {
        function generateBarChart() {
            var data = getTableData();
           // //('Trying to get #barChart:', document.getElementById('barChart'));
            console.log('Bar chart data:', data);
            var canvas = document.getElementById('barChart');
            console.log('Canvas element:', canvas);
            if (canvas) {
                // ✅ Safely destroy the chart associated with the canvas if it exists
                var existingChart = Chart.getChart(canvas);
                if (existingChart) {
                    existingChart.destroy();
                }
    
                var ctx = canvas.getContext('2d');
                ////('Canvas context:', ctx);
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    
                    data: {
                        labels: data.labels,
                        datasets: [
                            {
                                label: 'Input Qty',
                                data: data.inputData,
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Output Qty',
                                data: data.outputData,
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Earned Mins',
                                data: data.earnMinisData,
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Ack Ped',
                                data: data.ackpedData,
                                backgroundColor: 'rgba(255, 99, 132, 0.6)',
                                borderColor: 'rgba(255, 99, 132, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Sm Stock',
                                data: data.smstockData,
                                backgroundColor: 'rgba(101, 203, 90, 0.6)',
                                borderColor: 'rgba(101, 203, 90, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'WIP Qty',
                                data: data.wipData,
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                        ]
                    },
    
                    
    
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Unit - Input Qty, Output Qty, Earned Mins, Ack Ped, Sm Stock, WIP Qty'
                        },
                        scales: {
                            x: {
                                stacked: false
                            },
                            y: {
                                beginAtZero: true
                            }
                        }
                    },
                    
                });
    
               
                
    
            } else {
                console.error("Element with ID 'barChart' not found in the DOM.");
            }
        }
    
        // Wait a little to ensure DOM is fully loaded
        // setInterval(generateBarChart, 40000);
        setTimeout(() => {
            generateBarChart();
          }, 50000);
    });


    





//TVL Start

function getTableDataTVL() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    console.log('getTableDataTVL called');

    // Get table rows and extract data from each row
    $('#tableportaltvl tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            console.log('m4.tvl', m4);

            var total = $(this).find('td').eq(7).text();
            //  log(total);

            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortalTVL(data, Key) {
    const $tableBody = $('#tableportaltvl tbody');

    const accessTypes = new Set();

    console.log('populatePortalTVL called');
    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportaltvl').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
        <td>${item[unit]}</td>
        <td >${formatIndianNumber1(item[M1])}</td>
        <td >${formatIndianNumber1(item[M2])}</td>
        <td >${formatIndianNumber1(item[M3])}</td>
        <td >${formatIndianNumber1(item[M4])}</td>
        <td >${formatIndianNumber1(item[M5])}</td>
        <td >${formatIndianNumber1(item[M6])}</td>
       
        <td style="text-align:right;font-weight:bold">${formatIndianNumber1(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDataTVL(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portaltvl').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}



//TVL END

//OWE start

function getTableDataowe() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportalowe tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();


            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortalOWE(data, Key) {
    const $tableBody = $('#tableportalowe tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportalowe').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
       <td>${item[unit]}</td>
        <td>${parseFloat(item[M1]).toFixed(2)}</td>
        <td>${parseFloat(item[M2]).toFixed(2)}</td>
        <td>${parseFloat(item[M3]).toFixed(2)}</td>
        <td>${parseFloat(item[M4]).toFixed(2)}</td>
        <td>${parseFloat(item[M5]).toFixed(2)}</td>
        <td>${parseFloat(item[M6]).toFixed(2)}</td>
        <td style="text-align:right;font-weight:bold">${parseFloat(item[M7]).toFixed(2)}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDataowe(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portalowe').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}
// //OWE End


//tailor start

function getTableDatatailor() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportaltailor tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();


            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortaltailor(data, Key) {
    const $tableBody = $('#tableportaltailor tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportaltailor').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
         <td>${item[unit]}</td>
        <td>${parseInt(item[M1])}</td>
        <td>${parseInt(item[M2])}</td>
        <td>${parseInt(item[M3])}</td>
        <td>${parseInt(item[M4])}</td>
        <td>${parseInt(item[M5])}</td>
        <td>${parseInt(item[M6])}</td>
        <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDatatailor(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portaltailor').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}
//tailor End



//cutting start

function getTableDatacutting() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportalcutting tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();


            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortalcutting(data, Key) {
    const $tableBody = $('#tableportalcutting tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;
    let counter = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        if (counter <= 7) {
            headerRow += `<th>${key}</th>`;
            counter++;
        }
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportalcutting').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
         <td>${item[unit]}</td>
        <td>${parseInt(item[M1])}</td>
        <td>${parseInt(item[M2])}</td>
        <td>${parseInt(item[M3])}</td>
        <td>${parseInt(item[M4])}</td>
        <td>${parseInt(item[M5])}</td>
        <td>${parseInt(item[M6])}</td>
        <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDatacutting(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portalcutting').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}
// //OWE Cutting


//Packing start

function getTableDatapacking() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportalpacking tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();


            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortalpacking(data, Key) {
    const $tableBody = $('#tableportalpacking tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;
    let counter = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        if (counter <= 7) {
            headerRow += `<th>${key}</th>`;
            counter++;
        }
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportalpacking').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
         <td>${item[unit]}</td>
        <td>${parseInt(item[M1])}</td>
        <td>${parseInt(item[M2])}</td>
        <td>${parseInt(item[M3])}</td>
        <td>${parseInt(item[M4])}</td>
        <td>${parseInt(item[M5])}</td>
        <td>${parseInt(item[M6])}</td>
        <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDatapacking(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portalpacking').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}
//Packing End


//QTY Start

function getTableDataQTY() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportalqty tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();
            //(total);

            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function populatePortalQTY(data, Key) {
    const $tableBody = $('#tableportalqty tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportalqty').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
        <td>${item[unit]}</td>
       <td>${parseInt(item[M1]) || 0}</td>
        <td>${parseInt(item[M2]) || 0}</td>
        <td>${parseInt(item[M3]) || 0}</td>
        <td>${parseInt(item[M4]) || 0}</td>
        <td>${parseInt(item[M5]) || 0}</td>
        <td>${parseInt(item[M6]) || 0}</td>

       
        <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDataQTY(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portalqty').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}



//TVL QTY
// Function to extract data from the table

$(document).ready(function() {


    function getTableData() {
        var labels = [];
        var inputData = [];
        var outputData = [];
        var earnMinisData = [];
        var wipData = [];
        var ackpedData = [];
        var smstockData = [];
    //('lkjhgfdxfcghjk');
        // Get table rows and extract data from each row
       
            $('#tableAppstrike tbody tr').each(function() {
                var machineName = $(this).find('td').eq(1).text();
                var input = $(this).find('td').eq(2).text();
                var output = $(this).find('td').eq(3).text();
                var earnMinis = $(this).find('td').eq(4).text();
                var ackped = $(this).find('td').eq(5).text();
                var smstock = $(this).find('td').eq(6).text();
                var wip = $(this).find('td').eq(7).text();
    
                //('machineName',machineName);
        
                labels.push(machineName);
                inputData.push(parseInt(input.replace(/,/g, ''), 10));
                outputData.push(parseInt(output.replace(/,/g, ''), 10));
                earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                ackpedData.push(parseInt(ackped.replace(/,/g, ''), 10));
                smstockData.push(parseInt(smstock.replace(/,/g, ''), 10));
            });
       
        
        
    
        //('label',labels);
        //('input',inputData);
        //('output',outputData);
        //('earnmini',earnMinisData);
        //('ackped',ackpedData);
        //('smstoc',smstockData);
        //('wipd',wipData);

        console.log('labels', labels);
        console.log('input', inputData);
        console.log('output', outputData);
        console.log('earnmini', earnMinisData);
    
        return {
            labels: labels,
            inputData: inputData,
            outputData: outputData,
            earnMinisData: earnMinisData,
            ackpedData: ackpedData,
            smstockData: smstockData,
            wipData: wipData
        };
    
    }

    
// Prepare the chart data
var data = getTableData();

// Create the bar chart
var ctx = document.getElementById('barChart');
if (ctx) {

    if (window.barChart && typeof window.barChart.destroy === 'function') {
        window.barChart.destroy();
    }
    

    ctx = ctx.getContext('2d');
    var chart = new Chart(ctx, {
        type: 'bar', // Bar chart type
        data: {
            labels: data.labels, // X-axis labels (machine names)
            datasets: [{
                    label: 'Input Qty',
                    data: data.inputData,
                    backgroundColor: 'rgba(75, 192, 192, 0.6)', // Teal
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Output Qty',
                    data: data.outputData,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)', // Blue
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Earned Mins',
                    data: data.earnMinisData,
                    backgroundColor: 'rgba(255, 206, 86, 0.6)', // Yellow
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Ack Ped',
                    data: data.ackpedData,
                    backgroundColor: 'rgba(255, 99, 132, 0.6)', // Red
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Sm Stock',
                    data: data.smstockData,
                    backgroundColor: 'rgba(75, 192, 75, 0.6)', // Green
                    borderColor: 'rgba(75, 192, 75, 1)',
                    borderWidth: 1
                },
                {
                    label: 'WIP Qty',
                    data: data.wipData,
                    backgroundColor: 'rgba(153, 102, 255, 0.6)', // Purple
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                }
            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Unit - Input Qty, Output Qty, Earned Mins,Ack Ped,Sm Stock,WIP Qty'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });
} else {
    console.error("Element with ID 'barchart' not found in the DOM.");
}

});









$(function() {
    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);



$(document).ready(function () {

    cb(start, end);
    fetchDashboardData(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));

    $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
        var startDate = picker.startDate.format('YYYY-MM-DD');
        var endDate = picker.endDate.format('YYYY-MM-DD');
        //("Selected date range: " + startDate + " - " + endDate);

        fetchDashboardData(startDate, endDate);
    });

  //  var myChart;

    
    function fetchDashboardData(startDate, endDate) {
        $('.loader').show();
        $.ajax({
            url: window.LaravelRoutes.dashboardAnaly,
            method: 'GET',
            data: {
                start_date: startDate,
                end_date: endDate
            },
            success: function (mddata) {
                // //(mddata);

                // Check if data is valid and extract merch_buyers
                var merchBuyers = mddata.success && mddata.data ? mddata.data.merch_buyers : [];

                if (merchBuyers.length === 0) {
                    //("No data found, showing default empty chart.");

                    merchBuyers = [{
                        merch: "No Data",
                        order_qty: 0,
                        shipped_qty: 0
                    }];
                }

                var labels = [];
                var totalorder_qty = [];
                var totalshipped_qty = [];

                // Use the correct merchBuyers variable
                merchBuyers.forEach(function (item) {
                    labels.push(item.merch);
                    totalorder_qty.push(item.order_qty);
                    totalshipped_qty.push(item.shipped_qty);
                });

                // if (myChart) {
                //     myChart.destroy();
                // }

                // updateChart(labels, totalorder_qty, totalshipped_qty);
                // $('.loader').hide();
            },
            error: function () {
                //("Error fetching data.");
            }
        });
    }

    function updateChart(labels, totalorder_qty, totalshipped_qty) {
        const canvas = document.getElementById('myChart');
        if (!canvas) {
            console.error("Element with ID 'myChart' not found in the DOM.");
            return;
        }

        const ctx = canvas.getContext('2d');
        if (window.myChart) {
            window.myChart.destroy(); // Destroy the existing chart instance if it exists
        }

        window.myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'Shipped Qty',
                        data: totalshipped_qty,
                        backgroundColor: 'rgba(153, 102, 255, 0.6)',
                        borderColor: 'rgba(153, 102, 255, 1)',
                        borderWidth: 1
                    },
                    {
                        label: 'Orders Qty',
                        data: totalorder_qty,
                        backgroundColor: 'rgba(75, 192, 192, 0.6)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    x: {
                        stacked: true
                    },
                    y: {
                        stacked: true,
                        beginAtZero: true,
                        ticks: {
                            stepSize: 5000
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top'
                    }
                }
            }
        });
    }

   // Example usage: Call fetchDashboardData after the DOM is ready
    fetchDashboardData('2025-04-01', '2025-04-12'); // Replace with your desired date range
});

    



});

function formatIndianNumber1(x) {
    return (x / 100000).toFixed(2)
    return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
}

function formatIndianNumber12(x) {
    var parts = x.toString().split(".");
    var lastThree = parts[0].slice(-3);
    var otherNumbers = parts[0].slice(0, -3);
    var formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
    if (otherNumbers !== '') {
        lastThree = ',' + lastThree;
    }
    return formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
    return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
}





$(document).ready(function() {
    var table = $('#userlogaudit').DataTable({
        paging: false,
        searching: false,
        ordering: true,
        order: [
            [0, 'asc']
        ],
        // dom: 'Bfrtip',

    });

    var emp_id = $('#emp_id').val();
    ////(emp_id);
    // var emp_id = '5545';
    const apiUrl = window.LaravelRoutes.userLogMerch_opt;

    $.ajax({
        url: apiUrl,
        method: 'GET',
        data: {
            emp_id: emp_id
        },
        success: function(response) {
            //(response);

            if (response.success && response.data) {
                // Clear any existing rows in the DataTable
                table.clear();

                response.data.forEach(function(item, index) {
                    table.row.add([
                        index + 1, // SNO
                        item.employee || '-', // Name
                        // item.EmpCode || '-',        // Emp Code (mapped as IP Address)
                        item.LastLoginDateTime || '-', // Date
                    ]);
                });

                // Redraw the table with the new data
                table.draw();
            } else {
                // If no data found
                $('#userlogaudit tbody').append('<tr><td colspan="5">No data found</td></tr>');
            }
        },
        error: function() {
            //("Error fetching data.");
            $('#userlogaudit tbody').append('<tr><td colspan="5">Error fetching data</td></tr>');
        }
    });
});








$(document).ready(function() {

    $('#select_option').change(function() {
        // Get the selected value
        $('.production').css('display', 'none');
        $('.production_6').css('display', 'none');
        $('.filter_row').css('display', 'block');

        var selectedoption = $(this).val();
        $('.' + selectedoption).show();
        $('html, body').animate({
            scrollTop: $("div." + selectedoption).offset().top
        }, 1000)


        var selectedValue = $('#monthYearPicker').val();
        var parts = selectedValue.split('/');
        var month = parts[0];
        var year = parts[1];

        if (selectedoption == 'Tvl') {
            $('.month_heder').text(month + ' Month (Sewing) Turnover Value Details');
            updateChart(month, year);

        } else if (selectedoption == 'Tminis') {
            $('.month_heder').text(month + ' Month (Sewing) Earned Mins Details');
            updateChartTminis(month, year);

        } else if (selectedoption == 'Tqty') {
            $('.month_heder').text(month + ' Months(Sewing) Production Qty Details');
            updateChartTqty(month, year);
        } else if (selectedoption == 'Total_OWE') {
            $('.month_heder').text(month + ' Month OWE Details');
            $('.filterheading').css('display', 'none');
            updateChartowe(month, year);
        } else if (selectedoption == 'Tailor') {
            $('.month_heder').text(month + ' Month  Tailors Details');
            $('.filterheading').css('display', 'none');
            updateChartTailor(month, year);
        } else if (selectedoption == 'cutting_status') {
            $('.month_heder').text(month + ' Month  Cutting Details');
            $('.filterheading').css('display', 'none');
            updateChartCutting(month, year);
        } else if (selectedoption == 'packing') {
            $('.month_heder').text(month + ' Month  Packing Details');
            $('.filterheading').css('display', 'none');
            updateChartPacking(month, year);
        }

        // Display the selected value in the result div
        $('#result').text("Selected Value: " + selectedoption);
    });
    var chartInstance = null;
    let abstractTable = null;

    function formatCompactNumber(value) {
        var selectedoption = $('#select_option').val();
        //(selectedoption);
        if (selectedoption == 'Tqty') {
            return (value);
        } else {
            return (value / 100000).toFixed(2);
        }

    }

    // Store the chart instance

    // Function to fetch data and update the chart
    function updateChart(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();
    
        $.ajax({
            url: window.LaravelRoutes.operationReport,
            data: {
                'year': year,
                'month': monthName
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {
                    var tableData = response.data;
    
                    // Ensure the canvas element exists
                    const ctx = document.getElementById('multipleLineChart');
                    if (!ctx) {
                        console.error("Element with ID 'multipleLineChart' not found in the DOM.");
                        return;
                    }
    
                    const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total");
    
                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Unit,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(),
                        backgroundColor: 'rgba(0, 0, 0, 0)',
                        fill: false,
                        lineTension: 0.1
                    }));
    
                    if (chartInstance) {
                        chartInstance.destroy();
                    }
    
                    const chartCtx = ctx.getContext('2d');
                    chartInstance = new Chart(chartCtx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Turn Over: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Turn Over'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });
                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }

    function updateChartTminis(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();

        $.ajax({
            url: window.LaravelRoutes.operationReportTmins,
            data: {
                'year': year,
                'month': monthName
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data;
                    populateAbstractTable(tableData, monthNumber);



                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                    // Prepare the chart data dynamically
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Unit,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }

                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Earned Mins: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Earned Mins'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }

    function updateChartTqty(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();

        $.ajax({
            url: window.LaravelRoutes.operationReportQty,
            data: {
                'year': year,
                'month': monthName
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data;
                    populateAbstractTable(tableData, monthNumber);



                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                    // Prepare the chart data dynamically
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Unit,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }

                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Production Qty: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Production Qty'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }

    function updateChartowe(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        var status = $('#tableportalowe').find('td').text().trim();
        $("#preloder").fadeIn();
        //(status);

        $.ajax({
            url: window.LaravelRoutes.operationReportOwe,
            data: {
                'year': year,
                'month': monthName,
                'type': 'Total_OWE'
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data.monthdata;

                    var tablesixData = response.data.sixdata;
                    var keydata = response.data.sixkey;
                    populateWorksTable(tableData, monthNumber);
                    if (status == '') {
                        populatePortalOWE(tablesixData, keydata);
                    } else {
                        // $('.Total_OWE').css('display', 'block');

                        // //('ALL ready load function');
                    }




                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                    // Prepare the chart data dynamically
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Unit,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }



                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Total_OWE: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Total_OWE'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }

    function updateChartTailor(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();
        var status = $('#tableportaltailor').find('td').text().trim();

        $.ajax({
            url: window.LaravelRoutes.operationReportOwe,
            data: {
                'year': year,
                'month': monthName,
                'type': 'Tailor'
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data.monthdata;
                    var tablesixData = response.data.sixdata;
                    var keydata = response.data.sixkey;
                    populateWorksTable(tableData, monthNumber);
                    if (status == '') {
                        populatePortaltailor(tablesixData, keydata);
                    } else {
                        //$('.Tailore').css('display', 'block');
                        // //('ALL ready load function');
                    }





                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                    // Prepare the chart data dynamically
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Unit,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }

                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Tailor: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Tailor'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }


    function updateChartCutting(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();
        var status = $('#tableportalcutting').find('td').text().trim();
        //Cutting RAJ

        $.ajax({
            url: window.LaravelRoutes.operationCutting,
            data: {
                'year': year,
                'month': monthName
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data.monthdata;
                    var tablesixData = response.data.sixdata;
                    var keydata = response.data.sixkey;
                    populateWorksTable(tableData, monthNumber);
                    if (status == '') {
                        populatePortalcutting(tablesixData, keydata);
                    } else {
                        //$('.Tailore').css('display', 'block');
                        // //('ALL ready load function');
                    }





                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Buyer !== "Total");



                    // Prepare the chart data dynamically RAJ
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Buyer" && key !== "Total" && key !== 'Slno'); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Buyer,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }

                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Cutting: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Cutting'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }

    function updateChartPacking(monthName, year) {
        // Convert month name (e.g., 'Jan') into month number (1-12)
        var monthNumber = getMonthNumber(monthName);
        $("#preloder").fadeIn();
        var status = $('#tableportalpacking').find('td').text().trim();
        //Cutting RAJ

        $.ajax({
            url: window.LaravelRoutes.operationPacking,
            data: {
                'year': year,
                'month': monthName
            },
            method: 'GET',
            success: function(response) {
                $("#preloder").fadeOut();
                if (response.success) {

                    var tableData = response.data.monthdata;
                    var tablesixData = response.data.sixdata;
                    var keydata = response.data.sixkey;
                    populateWorksTable(tableData, monthNumber);
                    if (status == '') {
                        populatePortalpacking(tablesixData, keydata);
                    } else {
                        //$('.Tailore').css('display', 'block');
                        // //('ALL ready load function');
                    }





                    // Filter data for chart (excluding 'Total' units)
                    const filteredData = tableData.filter(unitData => unitData.Buyer !== "Total");

                    // Prepare the chart data dynamically RAJ
                    const labels = Object.keys(filteredData[0]).filter(key => key !== "Buyer" && key !== "Total" && key !== 'Slno'); // Extract dates from the first unit's keys

                    const datasets = filteredData.map(unitData => ({
                        label: unitData.Buyer,
                        data: labels.map(date => parseInt(unitData[date], 10)),
                        borderColor: getRandomColor(), // You can customize the color for each line
                        backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                        fill: false,
                        lineTension: 0.1
                    }));

                    // Destroy the existing chart instance if it exists
                    if (chartInstance) {
                        chartInstance.destroy(); // Destroy the previous chart instance
                    }

                    // Create a new chart
                    const ctx = document.getElementById('multipleLineChart').getContext('2d');
                    chartInstance = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: datasets
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(tooltipItem) {
                                            return 'Packing: ' + tooltipItem.raw.toLocaleString();
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Date'
                                    }
                                },
                                y: {
                                    title: {
                                        display: true,
                                        text: 'Packing'
                                    },
                                    ticks: {
                                        callback: function(value) {
                                            return value.toLocaleString();
                                        }
                                    }
                                }
                            }
                        }
                    });

                } else {
                    console.error("API returned success false.");
                }
            },
            error: function() {
                //("Error fetching data.");
            }
        });
    }



    var selectedValue = $('#monthYearPicker').val();
    var parts = selectedValue.split('/');
    var month = parts[0];
    var year = parts[1];
    //updateChart(month, year); 


    $('#monthYearPicker').on('change', function() {
        var selectedValue = $(this).val();
        var parts = selectedValue.split('/');
        var month = parts[0];
        var year = parts[1];
        //(selectedValue);
        var selectedoption = $('#select_option').val();
        if (selectedoption == 'Tvl') {
            updateChart(month, year);
            $('.month_heder').text(month + ' Month (Sewing) Turnover Value Details');

        } else if (selectedoption == 'Tminis') {
            $('.month_heder').text(month + ' Month (Sewing) Earned Mins Details');
            updateChartTminis(month, year);

        } else if (selectedoption == 'Tqty') {
            $('.month_heder').text(month + ' Month (Sewing) Production Qty Details');
            updateChartTqty(month, year);
        } else if (selectedoption == 'Total_OWE') {
            $('.month_heder').text(month + ' Month OWE Details');
            $('.filterheading').css('display', 'none');
            updateChartowe(month, year);
        } else if (selectedoption == 'Tailor') {
            $('.month_heder').text(month + ' Month  Tailors Details');
            $('.filterheading').css('display', 'none');
            updateChartTailor(month, year);
        } else if (selectedoption == 'cutting_status') {
            $('.month_heder').text(month + ' Month  Cutting Details');
            $('.filterheading').css('display', 'none');
            updateChartCutting(month, year);
        } else if (selectedoption == 'packing') {
            $('.month_heder').text(month + ' Month  Packing Details');
            $('.filterheading').css('display', 'none');
            updateChartPacking(month, year);
        }


        //updateChart(monthName, year);
    });


    function getMonthNumber(monthName) {
        var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        return monthNames.indexOf(monthName) + 1;
    }


    function getRandomColor() {
        const colors = ['#FF5733', '#33FF57', '#3357FF', '#F9A825', '#FF33A1', '#8E24AA'];


        return colors;
    }

    // Function to populate Abstract Table
    function populateAbstractTable(data, orderNo) {
        const $tableBody = $('#abstractTable tbody');
        $tableBody.empty();

        if (!data || data.length === 0) {
            //("No data available to populate.");
            return;
        }

        var headers = Object.keys(data[0]);

        // Dynamically create table headers
        var thead = '<tr>';
        headers.forEach(function(header) {
            var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
            if (dateFormatRegex.test(header)) {
                var parts = header.split('_');
                var month = parts[0];
                var year = parts[1];
                var day = parts[2];
                var headercol = day;

            } else {
                var headercol = header;
            }

            thead += '<th>' + headercol + '</th>';
        });
        thead += '</tr>';
        $('#abstractTable thead').html(thead); // Insert headers into table

        // Dynamically create table rows
        var tbody = '';
        data.forEach(function(row) {
            tbody += '<tr>';
            headers.forEach(function(header) {
                if ($.isNumeric(row[header])) {

                    var tdata = formatCompactNumber(row[header]);
                } else {
                    var tdata = row[header];
                }
                if(header=='Unit' || row['Unit']=='Total'){
                    tbody += '<td data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
                }else{
                    tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
                }
            });
            tbody += '</tr>';
        });
        $('#abstractTable tbody').html(tbody); // Insert rows into abstract table


    }

    function populateWorksTable(data, orderNo) {
        const $tableBody = $('#abstractTable tbody');
        $tableBody.empty();

        if (!data || data.length === 0) {
            //("No data available to populate.");
            return;
        }

        var headers = Object.keys(data[0]);

        // Dynamically create table headers
        var thead = '<tr>';
        headers.forEach(function(header, index) {
            var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
            if (index !== headers.length - 1) {
                if (dateFormatRegex.test(header)) {
                    var parts = header.split('_');
                    var month = parts[0];
                    var year = parts[1];
                    var day = parts[2];
                    var headercol = day;

                } else {
                    var headercol = header;
                }
                tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + row[header] + '</td>';

            }
        });
        thead += '</tr>';
        $('#abstractTable thead').html(thead); // Insert headers into table

        // Dynamically create table rows
        var tbody = '';
        data.forEach(function(row) {
            tbody += '<tr>';
            headers.forEach(function(header, index) {
                // Check if it's the last column and skip adding it
                if (index !== headers.length - 1) {
                    tbody += '<td>' + row[header] + '</td>';
                }
            });
            tbody += '</tr>';
        });
        $('#abstractTable tbody').html(tbody); // Insert rows into abstract table


    }
});




    $(document).ready(function() {



        // Export chart as PNG
        $('#load-data').click(function() {
            $('.load_turnover').css('display', 'block');
        });


    });
})();




// Define generateBarChart globally
function generateBarChart(data) {
    //('Generating bar chart with data:', data);

    const canvas = document.getElementById('barChart');
    if (!canvas) {
        console.error("Element with ID 'barChart' not found in the DOM.");
        return;
    }

    const existingChart = Chart.getChart(canvas);
    if (existingChart) {
        existingChart.destroy();
    }

    const ctx = canvas.getContext('2d');

    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels,
            datasets: [
                {
                    label: 'Input Qty',
                    data: data.inputData,
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Output Qty',
                    data: data.outputData,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                x: {
                    stacked: false
                },
                y: {
                    beginAtZero: true
                }
            }
        }
    });
}


$(document).ready(function() {
    function fadeOutLoader() {
        return new Promise((resolve) => {
            $("#preloder").fadeOut(300, resolve);
        });
    }

    $.ajax({
        url: window.LaravelRoutes.operationDashboard,
        method: 'GET',
        success: function(response) {
            fadeOutLoader().then(() => {
                if (response.success) {
                    // Call generateBarChart with the appropriate data
                    generateBarChart(response.data.listdata);
                } else {
                    console.error("API returned success false.");
                }
            });
        },
        error: function() {
            //("Error fetching data.");
            fadeOutLoader();
        }
    });
});



function formatIndianNumber1(x) {
    return (x / 100000).toFixed(2)
    //return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
}


function populatePortalTVL(data, Key) {
    const $tableBody = $('#tableportaltvl tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportaltvl').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
        <td>${item[unit]}</td>
        <td >${formatIndianNumber1(item[M1])}</td>
        <td >${formatIndianNumber1(item[M2])}</td>
        <td >${formatIndianNumber1(item[M3])}</td>
        <td >${formatIndianNumber1(item[M4])}</td>
        <td >${formatIndianNumber1(item[M5])}</td>
        <td >${formatIndianNumber1(item[M6])}</td>
       
        <td style="text-align:right;font-weight:bold">${formatIndianNumber1(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDataTVL(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portaltvl').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }
    });





}

function getTableDataTVL() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportaltvl tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();
            //(total);

            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}


function populatePortalQTY(data, Key) {
    const $tableBody = $('#tableportalqty tbody');

    const accessTypes = new Set();

    const monthsDataKey = Key;

    $tableBody.empty();
    let totalAppAmount = 0;
    let totalUnAppAmount = 0;
    let earnminis = 0;
    let wip = 0;

    let headerRow = '<thead><tr>';

    // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
    $.each(monthsDataKey, function(index, key) {
        headerRow += `<th>${key}</th>`;
    });
    headerRow += '</tr></thead>';

    // Append the header row to the table
    $('#tableportalqty').append(headerRow);


    $.each(data, function(index, item) {
        var unit = monthsDataKey[0];
        var M1 = monthsDataKey[1];
        var M2 = monthsDataKey[2];
        var M3 = monthsDataKey[3];
        var M4 = monthsDataKey[4];
        var M5 = monthsDataKey[5];
        var M6 = monthsDataKey[6];
        var M7 = monthsDataKey[7];


        let appAmount = item[unit];
        let unappAmount = item[M1];
        let totalearn = item[M2];
        let totalwip = item[M3];
        const row = `
    <tr>
        
        <td>${item[unit]}</td>
       <td>${parseInt(item[M1]) || 0}</td>
        <td>${parseInt(item[M2]) || 0}</td>
        <td>${parseInt(item[M3]) || 0}</td>
        <td>${parseInt(item[M4]) || 0}</td>
        <td>${parseInt(item[M5]) || 0}</td>
        <td>${parseInt(item[M6]) || 0}</td>

       
        <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
     
    </tr>`;
        $tableBody.append(row);

        totalAppAmount += parseFloat(appAmount) || 0;
        totalUnAppAmount += parseFloat(unappAmount) || 0;
        earnminis += parseFloat(totalearn) || 0;
        wip += parseFloat(totalwip) || 0;

        accessTypes.add(item.Access_Type);
    });


    var data = getTableDataQTY(); // Get the extracted table data
    var ctx = document.getElementById('barChartMOnth_portalqty').getContext('2d');

    // Destroy the previous chart if it exists

    // Create a new bar chart
    window.barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: data.labels, // Using labels from the extracted data
            datasets: [{
                    label: 'Month-I',
                    data: data.inputData, // Using dynamic data
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-II',
                    data: data.outputData, // Using dynamic data
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-III',
                    data: data.earnMinisData, // Using dynamic data
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-IV',
                    data: data.wipData, // Using dynamic data
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-V',
                    data: data.month4, // Using dynamic data
                    backgroundColor: 'rgba(255, 159, 64, 0.6)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Month-VI',
                    data: data.month5, // Using dynamic data
                    backgroundColor: 'rgba(75, 163, 59, 0.6)',
                    borderColor: 'rgba(75, 163, 59, 1)',
                    borderWidth: 1
                },


            ]

        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Last 6 Month Data'
            },
            scales: {
                x: {
                    stacked: false // Bars will be side by side
                },
                y: {
                    beginAtZero: true // Start Y-axis at 0
                }
            }
        }

        
    });

    //('Bar chart data:', data);





}

function getTableDataQTY() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var TotalQty = [];
    var month4 = [];
    var month5 = [];
    var month6 = [];

    // Get table rows and extract data from each row
    $('#tableportalqty tbody tr').each(function(index, row) {
        if ($(row).is(':last-child')) {
            //$(row).remove();  // Remove the last row
        } else {
            var unit = $(this).find('td').eq(0).text();
            var input = $(this).find('td').eq(1).text();
            var output = $(this).find('td').eq(2).text();
            var earnMinis = $(this).find('td').eq(3).text();
            var wip = $(this).find('td').eq(4).text();
            var m4 = $(this).find('td').eq(5).text();
            var m5 = $(this).find('td').eq(6).text();

            var total = $(this).find('td').eq(7).text();
            //(total);

            labels.push(unit);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            month4.push(parseInt(m4.replace(/,/g, ''), 10));
            month5.push(parseInt(m5.replace(/,/g, ''), 10));


            TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
        }
    });

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        wipData: wipData,
        month4: month4,
        month5: month5,

        TotalQty: TotalQty,
    };
}

function getTableData() {
    var labels = [];
    var inputData = [];
    var outputData = [];
    var earnMinisData = [];
    var wipData = [];
    var ackpedData = [];
    var smstockData = [];
//('lkjhgfdxfcghjk');
    // Get table rows and extract data from each row
    $(document).ready(function () {
        $('#tableAppstrike tbody tr').each(function() {
            var machineName = $(this).find('td').eq(1).text();
            var input = $(this).find('td').eq(2).text();
            var output = $(this).find('td').eq(3).text();
            var earnMinis = $(this).find('td').eq(4).text();
            var ackped = $(this).find('td').eq(5).text();
            var smstock = $(this).find('td').eq(6).text();
            var wip = $(this).find('td').eq(7).text();

            console.log('machineName',machineName);
    
            labels.push(machineName);
            inputData.push(parseInt(input.replace(/,/g, ''), 10));
            outputData.push(parseInt(output.replace(/,/g, ''), 10));
            earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
            wipData.push(parseInt(wip.replace(/,/g, ''), 10));
            ackpedData.push(parseInt(ackped.replace(/,/g, ''), 10));
            smstockData.push(parseInt(smstock.replace(/,/g, ''), 10));
        });
    });
    
    

    //('label',labels);
    //('input',inputData);
    //('output',outputData);
    //('earnmini',earnMinisData);
    //('ackped',ackpedData);
    //('smstoc',smstockData);
    //('wipd',wipData);

    return {
        labels: labels,
        inputData: inputData,
        outputData: outputData,
        earnMinisData: earnMinisData,
        ackpedData: ackpedData,
        smstockData: smstockData,
        wipData: wipData
    };
}