const ColvaluesArray = {
    0: "CC",
    1: "Model + Color",
    2: "Season",
    3: "FRC/CK Date",
    4: "Shipped Date",
    5: "Sel Qty",
    6: "Proj Qty",
    7: "FRC Qty",
    8: "C/O Qty",
    9: "Line Iss Qty",
    10: "Prod Qty",
    11: "Buyer Po Qty",
    12: "Ship Qty",
    13: "Ship Diff",
    14: "Past EHD",
    15: "Short Ship",
    16: "Brand",
    17: "Merch",
    18: "Ins_Zone",
    19: "Pck WIP Qty",
    20: "FG(In Pcs)",
    21: "Unmap FG",
    22: "Fabric(In Mtr)",
    23: "Unmap Fabric",
    24: "Trim(In Val)",
    25: "Unmap Trim"
};


$('#openConfigurator').one('click', function() {
    var emp_id = $('#emp_id').val();
    $('#col_val').empty().append('');

    $.each(ColvaluesArray, function(key, value) {
        $('#col_val').append('<label class="list-group-item"><input class="form-check-input me-1" type="checkbox" checked="checked" name="colsdetails[]" value="' + key + '">' + value + '</label>');
    });
});

$("#cccheck").change(function() {
    let isChecked = $(this).is(':checked');

    $(".cccheck input:checkbox").prop("checked", isChecked)
    .each(function() {
        if (isChecked) {
            $(this).addClass("highlighted highlightedcc"); // Add classes when checked
        } else {
            $(this).removeClass("highlighted highlightedcc"); // Remove classes when unchecked
        }
    });
});
$("#seasoncheck").change(function() {
    let isChecked = $(this).is(':checked');
    $(".seasoncheck input:checkbox").prop("checked", isChecked)
        .each(function() {
            $(this).toggleClass("highlighted highlightedseason", isChecked);
        });
});
$("#colorcheck").change(function() {
    let isChecked = $(this).is(':checked');
    $(".colorcheck input:checkbox").prop("checked", isChecked)
        .each(function() {
            $(this).toggleClass("highlighted highlightedcolor", isChecked);
        });
});
$("#gridcheck").change(function() {
    let isChecked = $(this).is(':checked');
    $(".gridcheck input:checkbox").prop("checked", isChecked)
        .each(function() {
            $(this).toggleClass("highlighted highlightedcolor", isChecked);
        });
});

function updateDropdown(selector, dataArray, selectedValue) {
    $(selector).empty().append('<option value="">Select</option>');
    $.each([...new Set(dataArray)], function(index, value) {
        $(selector).append('<option value="' + value + '">' + value + '</option>');
    });

    if (selectedValue !== '') {
        $(selector + ' option[value="' + selectedValue.replace(/"/g, '\\"') + '"]').prop('selected', true);
    }
}

function formatDate(dateString) {
   
    if (!dateString) {
        return ''; // Return empty for invalid input
    }
 
    // Detect format and parse accordingly
    if (/^\d{2}-\d{2}-\d{2}$/.test(dateString)) {
        return moment(dateString, 'DD-MM-YY').format('DD-MM-YY'); // Keep same format
    } else if (/^\d{4}-\d{2}-\d{2}$/.test(dateString)) {
        return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY'); // Convert YYYY-MM-DD → DD-MM-YY
    }
 
    return ''; // Return empty for unknown formats
}
 

function formatDateTime(dateString) {
    if (!dateString) return '';

    // Try parsing datetime with time (e.g. 2023-11-08 00:00:00.000)
    if (moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS', true).isValid()) {
        return moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS').format('DD-MM-YY');
    }

    // Try parsing date only (e.g. 2023-11-08)
    if (moment(dateString, 'YYYY-MM-DD', true).isValid()) {
        return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY');
    }

    // Try parsing existing DD-MM-YY
    if (moment(dateString, 'DD-MM-YY', true).isValid()) {
        return moment(dateString, 'DD-MM-YY').format('DD-MM-YY');
    }

    return ''; // Invalid or unrecognized format
}




