// Main application entry point
document.addEventListener('DOMContentLoaded', function() {
    console.log('Purchase Dashboard initialized');
    
    // Initialize all managers
    // Note: Managers are already initialized as global instances in their respective files
    
    // Set up any additional event listeners or global functionality here
    
    // Example: Auto-refresh data every 5 minutes (300000 ms)
    // setInterval(() => {
    //     window.purchaseData.generateMockData();
    //     window.dashboardManager.updateContent();
    // }, 300000);
    
    // Example: Handle keyboard shortcuts
    document.addEventListener('keydown', function(e) {
        // Ctrl/Cmd + R to refresh data
        if ((e.ctrlKey || e.metaKey) && e.key === 'r') {
            e.preventDefault();
            window.purchaseData.generateMockData();
            window.dashboardManager.updateContent();
            console.log('Data refreshed');
        }
    });
    
    // Example: Handle window resize for chart responsiveness
    window.addEventListener('resize', function() {
        // Trigger chart resize
        Object.values(window.chartManager.charts).forEach(chart => {
            chart.resize();
        });
    });
});

// Global utility functions
window.utils = {
    formatCurrency: function(amount) {
        return '₹' + amount.toLocaleString('en-IN');
    },
    
    formatDate: function(dateString) {
        const date = new Date(dateString);
        return date.toLocaleDateString('en-GB');
    },
    
    formatPercentage: function(value) {
        return value.toFixed(1) + '%';
    },
    
    debounce: function(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
};