<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Historical Data</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
    tailwind.config = {
        theme: {
            extend: {
                colors: {
                    'background': 'rgb(245, 246, 247)',
                    'foreground': 'rgb(31, 41, 55)',
                    'card': 'rgb(255, 255, 255)',
                    'card-foreground': 'rgb(31, 41, 55)',
                    'primary': 'rgb(15, 61, 126)',
                    'primary-foreground': 'rgb(248, 250, 252)',
                    'primary-100': 'rgb(219, 234, 254)',
                    'primary-50': 'rgb(239, 246, 255)',
                    'primary-25': 'rgb(248, 250, 252)',
                    'secondary': 'rgb(241, 245, 249)',
                    'muted': 'rgb(241, 245, 249)',
                    'muted-foreground': 'rgb(100, 116, 139)',
                    'border': 'rgb(226, 232, 240)',
                    'input': 'rgb(226, 232, 240)',
                    'ring': 'rgb(15, 61, 126)',
                },
                fontFamily: {
                    'body': ['Inter', 'system-ui', 'sans-serif'],
                }
            }
        }
    }
</script>
<style>
    .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
    }
    .styled-select {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .styled-select option {
        color: #1f2937;
        background: white;
    }
    .metrics-dropdown .menu.level2{display:none}
    .metrics-dropdown .menu.level1 .has-sub:hover>.menu.level2{display:block}
    .metrics-trigger{display:flex;align-items:center;gap:.25rem}
    .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    submenu-item:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        pointer-events: none;
    }
    .highlight {
        background-color: rgb(219, 234, 254) !important;
        font-weight: 600;
    }
    .tablewise tbody td {
        text-align: right !important;
    }
    .tablewise tbody td:first-child {
        text-align: left !important;
    }
    .tablewise tfoot td {
        text-align: right !important;
    }
    .tablewise tfoot td:first-child {
        text-align: left !important;
    }
    .tablewise thead {
        text-align: left;
    }
    .buyer-table-container { max-height: 300px; overflow-y: auto; }
    .buyer-table thead th { position: sticky; top: 0; z-index: 2; background: #f3f4f6; }
    .buyer-table tfoot td, .buyer-table tfoot th { position: sticky; bottom: 0; z-index: 2; background: #e5e7eb; }
</style>
</head>
<body class="bg-gray-100 font-sans">
  <nav class="bg-gradient-to-r from-blue-900 via-blue-800 to-blue-900 text-white px-4 py-1.5 shadow-md flex items-center justify-between sticky top-0 z-50 backdrop-blur-md border-b border-blue-700/40">
    <div class="flex items-center space-x-2">
      <a href="/dashboard" 
         class="inline-flex items-center justify-center rounded-lg border border-white/20 px-2 py-1.5 bg-white/10 hover:bg-white/20 transition-all duration-200">
         <i class="fa-solid fa-house text-white text-base"></i>
      </a>
      <h1 class="text-base font-semibold leading-tight tracking-wide dashboard_title">Historical Data {{$portal_type}}</h1>
    </div>
    <div class="flex items-center space-x-2">
      <div id="loadSpinner" class="spinner hidden"></div>
      <div class="metrics-dropdown relative">
        <button id="metricsBtn" class="metrics-trigger px-3 py-1.5 rounded-md bg-white/10 text-sm border border-white/20 hover:bg-white/20 flex items-center transition-all duration-200" 
                data-val="Production:Quantity" data-type="1">Quantity <span class="ml-1 text-blue-200 text-xs">▾</span>
        </button>
        <div class="menu level1 hidden absolute mt-2 bg-white text-foreground rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[60]">
          <div class="menu-title px-3 py-2 border-b text-sm font-semibold">All Metrics</div>
          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Production">
            <span>Production</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-8 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Quantity" data-type="1">Quantity</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Minutes" data-type="2">Minutes</button>
              <button class="hidden submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Overall" data-type="1">Overall</button>
            </div>
          </div>
          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Line Stop">
            <span>Line Stop Mins</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-10 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 line_stop_item" data-val="Line Stop:Minutes" data-type="1">Minutes</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 line_stop_item" data-val="Line Stop:Loss Amount" data-type="2">Loss Amount</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 line_stop_item" data-val="Line Stop:MTBS" disabled>MTBS</button>
            </div>
          </div>
          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Cutting">
            <span>Cutting</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-12 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 cutting_item" data-val="Cutting:Total Cut" data-type="1">Total Cut</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 cutting_item" data-val="Cutting:Fabric Utilization" disabled>Fabric Utilization</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 cutting_item" data-val="Cutting:FTR %" disabled>FTR %</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 cutting_item" data-val="Cutting:Marker Efficiency" disabled>Marker Efficiency</button>
            </div>
          </div>
          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="WIP">
            <span>WIP</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-14 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 wip_item" data-val="WIP:WIP" disabled>WIP</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 wip_item" data-val="WIP:WIP Value" disabled>WIP Value</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 wip_item" data-val="WIP:Avg. WIP Age" disabled>Avg. WIP Age</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 wip_item" data-val="WIP:Critical WIP" disabled>Critical WIP</button>
            </div>
          </div>
          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Labour">
            <span>Labour</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-18 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 labour_item" data-val="Labour:Strength" disabled>Strength</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 labour_item" data-val="Labour:Absenteeism" disabled>Absenteeism</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 labour_item" data-val="Labour:Attrition" disabled>Attrition</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100 labour_item" data-val="Labour:Recruitment" disabled>Recruitment</button>
            </div>
          </div>
        </div>
      </div>
      <div class="date-picker">
        <input type="text" placeholder="Select date range" class="h-8 px-3 rounded-md bg-white/10 text-white border border-white/20 hover:bg-white/20 text-sm cursor-pointer transition-all duration-200 placeholder-blue-200/80 focus:outline-none focus:ring-1 focus:ring-amber-300/50" id="dateRangePicker">
      </div>
      <button class="inline-flex items-center justify-center rounded-md bg-white/10 text-white border border-white/20 hover:bg-white/20 hover:scale-105 h-8 w-8 transition-all duration-200" id="notificationsBtn">
        <i class="fa-solid fa-bell text-base text-amber-300"></i>
      </button>
    </div> 
  </nav>
  <div class="px-6 py-3 text-sm text-gray-600 main_breadcrumb">
    <a href="/production_gut_dashboard/{{$portal_type}}?fromdate={{ $fromdate }}&enddate={{ $enddate }}" class="text-blue-700 hover:underline">Production Dashboard</a>
    <span> &gt; </span>
    <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
    <span> &gt; </span>
    <span class="text-gray-800 font-medium">Historical Data</span>
  </div>
  <div class="px-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex flex-row items-center gap-2 ">        
            <h2 class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Unit-wise Performance</h2>
            <p class="text-sm text-gray-500 ">Month-on-month output by production unit.</p>
        </div>
      <table class="w-full border-collapse text-sm tablewise">
        <thead>
          <tr class="bg-gray-100">
            <th class="px-2 py-2 text-left">Unit</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Apr">Apr</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="May">May</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Jun">Jun</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Jul">Jul</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Aug">Aug</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Sep">Sep</th>
          </tr>
        </thead>
        <tbody>
          <tr><td colspan="7" class="px-4 py-2 text-center">No data available</td></tr>
        </tbody>
      </table>
    </div>
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex flex-row items-center gap-2 ">
            <h2 class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">CC-wise Performance</h2>
            <p class="text-sm text-gray-500 ">Month-on-month output by buyer.</p>
        </div>    
      <div class="buyer-table-container">
        <table class="w-full border-collapse text-sm tablewise buyer-table">
          <thead>
            <tr class="bg-gray-100">
              <th class="px-2 py-2 text-left">CC</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Apr">Apr</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="May">May</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jun">Jun</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jul">Jul</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Aug">Aug</th>
              <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Sep">Sep</th>
            </tr>
          </thead>
          <tbody>
            <tr><td colspan="7" class="px-4 py-2 text-center">No data available</td></tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="px-6 py-4">
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex flex-row items-center gap-2 ">
            <h2 id="drilldownTitle" class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Daily Performance table</h2>
            <p class="text-sm text-gray-500 ">Showing daily output values. Click a cell to navigate to that day's overview.</p>
        </div>    
      <div class="overflow-x-auto">
        <table id="drilldownTable" class="w-full border-collapse text-sm">
          <tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>
        </table>
      </div>
    </div>
  </div>
  <div class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden" id="notificationOverlay">
    <div class="fixed right-0 top-0 h-full w-80 bg-white shadow-lg transform translate-x-full transition-transform duration-300" id="notificationPanel">
      <div class="p-6 border-b border-border">
        <div class="flex items-center justify-between">
          <h2 class="text-lg font-semibold">Production Alerts</h2>
          <button class="text-muted-foreground hover:text-foreground" id="closeNotifications">
            <i class="fa-solid fa-xmark h-5 w-5"></i>
          </button>
        </div>
      </div>
      <div class="p-6">
        <p class="text-muted-foreground">No new alerts at this time.</p>
      </div>
    </div>
  </div>
<script>
    let apiData = {};
    let selectedMetric = "Production:Quantity";
    let selectedType = "1";
    const portal_type = "{{$type}}" || "Production";
	 const type = "{{$type}}" || "Production";
    const apiRoutes = {
      'Production:Quantity': '/gutproductionhistoricaldata/{{$portal_type}}',
      'Production:Minutes': '/gutproductionhistoricaldata/{{$portal_type}}',
      'Production:Overall': '/gutproductionhistoricaldata/{{$portal_type}}',
      'WIP:WIP': '/wip_historicaldata',
      'WIP:WIP Value': '/wip_value_historicaldata',
      'WIP:Avg. WIP Age': '/avg_wip_age_historicaldata',
      'WIP:Critical WIP': '/critical_wip_historicaldata',
      'Line Stop:Minutes': '/gutproduction_minis_historicaldata/{{$portal_type}}',
      'Line Stop:Loss Amount': '/gutproduction_minis_historicaldata/{{$portal_type}}',
      'Line Stop:MTBS': '/mtbs_historicaldata',
      'Cutting:Total Cut': '/gutproduction_cutting_historicaldata/{{$portal_type}}',
      'Cutting:Fabric Utilization': '/gutproduction_cutting_historicaldata/{{$portal_type}}',
      'Cutting:FTR %': '/gutproduction_cutting_historicaldata/{{$portal_type}}',
      'Cutting:Marker Efficiency': '/gutproduction_cutting_historicaldata/{{$portal_type}}',
      'Labour:Strength': '/strength_historicaldata',
      'Labour:Absenteeism': '/absenteeism_historicaldata',
      'Labour:Attrition': '/attrition_historicaldata',
      'Labour:Recruitment': '/recruitment_historicaldata'
    };

    function fetchData(type = "", fromDate = "", toDate = "", portal_type = "", metric = "Production:Quantity") {
        console.log('Fetching data for portal_type:', portal_type);
        const apiUrl = apiRoutes[metric];
        if (!apiUrl) {
            $("#loadSpinner").hide();
            console.warn(`No API route available for metric: ${metric}`);
            return;
        }
        const unitTable = $('table').eq(0);
        unitTable.find('thead').html('<tr class="bg-gray-100"><th class="px-2 py-2 text-left">Unit</th></tr>');
        unitTable.find('tbody').html('<tr><td colspan="1" class="px-4 py-2 text-center">No data available</td></tr>');
        unitTable.find('tfoot').remove();
        const buyerTable = $('table').eq(1);
        buyerTable.find('thead').html('<tr class="bg-gray-100"><th class="px-2 py-2 text-left">CC</th></tr>');
        buyerTable.find('tbody').html('<tr><td colspan="1" class="px-4 py-2 text-center">No data available</td></tr>');
        buyerTable.find('tfoot').remove();
        $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>');
        $("#drilldownTitle").text('Daily Performance table');
        $('.drilldown, .month-header').removeClass('highlight');
        $("#loadSpinner").show();
        $.ajax({
            url: apiUrl,
            method: 'GET',
            data: { type: type, fromdate: fromDate, enddate: toDate, portaltype: '{{$portal_type}}' },
            success: function(response) {
                $("#loadSpinner").hide();
                if (response && response.success && response.data) {
                    apiData = response.data;
                    console.log('Updated apiData:', JSON.stringify(apiData, null, 2));
                    updateTables(apiData, fromDate, toDate, metric);
                } else {
                    console.warn("Invalid API response, resetting data");
                    apiData = {};
                }
            },
            error: function() {
                $("#loadSpinner").hide();
                console.error("Error fetching data from", apiUrl);
                apiData = {};
            }
        });
    }

    function updateTables(data, fromDate, toDate, metric) {
        const start = fromDate ? moment(fromDate, 'YYYY-MM-DD') : moment().subtract(5, 'months').startOf('month');
        const end = toDate ? moment(toDate, 'YYYY-MM-DD') : moment();
        const months = [];
        for (let m = moment(start); m.isSameOrBefore(end); m.add(1, 'month')) {
            months.push(m.format('MMM'));
        }

        // Unit table
        let unitMonthlyTotals = {};
        let unitTotals = {};
        months.forEach(month => unitMonthlyTotals[month] = 0);
        const units = [...new Set(data.map(item => item.units.map(u => u.Unit)).flat())];
        units.forEach(unit => unitTotals[unit] = 0);

        data.forEach(monthData => {
            const month = monthData.Mon_Name.slice(0, 3);
            if (months.includes(month)) {
                monthData.units.forEach(unit => {
                    const total = unit.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0);
                    unitMonthlyTotals[month] += total;
                    unitTotals[unit.Unit] += total;
                });
            }
        });

        let unitTableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">Unit</th>`;
        months.forEach(month => {
            unitTableHTML += `<th class="px-2 py-2 month-header cursor-pointer text-left" data-type="unit" data-month="${month}">${month}</th>`;
        });
        unitTableHTML += `<th class="px-2 py-2 text-left">Total</th></tr></thead><tbody>`;
        if (units.length === 0) {
            unitTableHTML += `<tr><td colspan="${months.length + 2}" class="px-4 py-2 text-center">No data available</td></tr>`;
        } else {
            units.forEach(unit => {
                unitTableHTML += `<tr class="border-t"><td class="px-2 py-2">${unit}</td>`;
                months.forEach(month => {
                    const monthData = data.find(d => d.Mon_Name.startsWith(month));
                    const unitData = monthData?.units.find(u => u.Unit === unit);
                    const total = unitData ? unitData.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0) : 0;
                    const isInitial = unit === (units[0] || 'G-I') && month === (months[0] || 'Oct') ? ' highlight' : '';
                    unitTableHTML += `<td class="px-2 py-2 drilldown cursor-pointer text-left${isInitial}" data-type="unit" data-name="${unit}" data-month="${month}">${total.toLocaleString()}</td>`;
                });
                unitTableHTML += `<td class="px-2 py-2 text-left font-semibold">${unitTotals[unit].toLocaleString()}</td>`;
                unitTableHTML += `</tr>`;
            });
        }
        unitTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
        months.forEach(month => {
            unitTableHTML += `<td class="px-2 py-2 text-left">${unitMonthlyTotals[month].toLocaleString()}</td>`;
        });
        unitTableHTML += `<td class="px-2 py-2 text-left">${Object.values(unitMonthlyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
        unitTableHTML += `</tr></tfoot>`;
        $('table').eq(0).html(unitTableHTML);

        // Buyer table
        let buyerMonthlyTotals = {};
        let buyerTotals = {};
        months.forEach(month => buyerMonthlyTotals[month] = 0);
        const buyers = [...new Set(data.map(item => item.units.map(u => u.buyers.map(b => b.Buyer)).flat()).flat())];
        buyers.forEach(buyer => buyerTotals[buyer] = 0);

        data.forEach(monthData => {
            const month = monthData.Mon_Name.slice(0, 3);
            if (months.includes(month)) {
                monthData.units.forEach(unit => {
                    unit.buyers.forEach(buyer => {
                        buyerMonthlyTotals[month] += buyer.buyer_total_Audit_Qty;
                        buyerTotals[buyer.Buyer] += buyer.buyer_total_Audit_Qty;
                    });
                });
            }
        });

        let buyerTableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">CC</th>`;
        months.forEach(month => {
            buyerTableHTML += `<th class="px-2 py-2 month-header cursor-pointer text-left" data-type="buyer" data-month="${month}">${month}</th>`;
        });
        buyerTableHTML += `<th class="px-2 py-2 text-left">Total</th></tr></thead><tbody>`;
        if (buyers.length === 0) {
            buyerTableHTML += `<tr><td colspan="${months.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
        } else {
            buyers.forEach(buyer => {
                let buyername = buyer;
                if (buyername) {
                    buyername = `${buyername.slice(0, 6)}`;
                }
                buyerTableHTML += `<tr class="border-t"><td class="px-2 py-2" title="${buyer}">${buyername}</td>`;
                months.forEach(month => {
                    const monthData = data.find(d => d.Mon_Name.startsWith(month));
                    let total = 0;
                    if (monthData) {
                        monthData.units.forEach(unit => {
                            const buyerData = unit.buyers.find(b => b.Buyer === buyer);
                            if (buyerData) total += buyerData.buyer_total_Audit_Qty;
                        });
                    }
                    buyerTableHTML += `<td class="px-2 py-2 drilldown cursor-pointer text-left" data-type="buyer" data-name="${buyer}" data-month="${month}">${total.toLocaleString()}</td>`;
                });
                buyerTableHTML += `<td class="px-2 py-2 text-left font-semibold">${buyerTotals[buyer].toLocaleString()}</td>`;
                buyerTableHTML += `</tr>`;
            });
        }
        buyerTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
        months.forEach(month => {
            buyerTableHTML += `<td class="px-2 py-2 text-left">${buyerMonthlyTotals[month].toLocaleString()}</td>`;
        });
        buyerTableHTML += `<td class="px-2 py-2 text-left">${Object.values(buyerMonthlyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
        buyerTableHTML += `</tr></tfoot>`;
        $('table').eq(1).html(buyerTableHTML);

        // Initial drilldown table rendering
        updateDrilldownTable('unit', units[0] || 'G-I', months[0] || 'Oct');
    }

    function updateDrilldownTable(type, name, month, isMonthHeader = false) {
        // Normalize month for robust matching
        const normalizedMonth = month.startsWith('Oct') ? 'Oct-2025' : month;
        const monthData = apiData.find(d => d.Mon_Name.startsWith(month));
        if (!monthData) {
            console.warn(`No data found for month: ${normalizedMonth} (original: ${month})`);
            $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available for selected month</td></tr>');
            $("#drilldownTitle").text('Daily Performance table');
            return;
        }

        let daysSet = new Set();
        monthData.units.forEach(unit => {
            unit.buyers.forEach(buyer => {
                if (buyer.lines) {
                    buyer.lines.forEach(line => {
                        line.data.forEach(item => {
                            const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                            if (!isNaN(day)) {
                                daysSet.add(day);
                            } else {
                                console.warn(`Invalid User_Date: ${item.User_Date}`);
                            }
                        });
                    });
                } else if (buyer.data) {
                    buyer.data.forEach(item => {
                        const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                        if (!isNaN(day)) {
                            daysSet.add(day);
                        } else {
                            console.warn(`Invalid User_Date: ${item.User_Date}`);
                        }
                    });
                }
            });
        });
        let days = Array.from(daysSet).sort((a, b) => a - b);
        if (days.length === 0) {
            console.warn(`No valid days found for month: ${normalizedMonth}`);
        }

        if (isMonthHeader) {
            const entityType = type === 'unit' ? 'Unit' : 'CC';
            $("#drilldownTitle").text(`Daily Performance for All ${entityType} in ${month}`);
            let entities = type === 'unit' ? [...new Set(monthData.units.map(u => u.Unit))] : 
                          [...new Set(monthData.units.flatMap(u => u.buyers.map(b => b.Buyer)))];
            let tableData = {};
            let dailyTotals = {};
            let entityTotals = {};
            days.forEach(day => dailyTotals[day] = 0);
            entities.forEach(entity => {
                tableData[entity] = {};
                entityTotals[entity] = 0;
                days.forEach(day => tableData[entity][day] = 0);
            });

            monthData.units.forEach(unit => {
                unit.buyers.forEach(buyer => {
                    if (buyer.lines) {
                        buyer.lines.forEach(line => {
                            line.data.forEach(item => {
                                const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                const qty = parseInt(item.Qty) || 0;
                                const entity = type === 'unit' ? unit.Unit : buyer.Buyer;
                                tableData[entity][day] += qty;
                                dailyTotals[day] += qty;
                                entityTotals[entity] += qty;
                            });
                        });
                    } else if (buyer.data) {
                        buyer.data.forEach(item => {
                            const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                            const qty = parseInt(item.Qty) || 0;
                            const entity = type === 'unit' ? unit.Unit : buyer.Buyer;
                            tableData[entity][day] += qty;
                            dailyTotals[day] += qty;
                            entityTotals[entity] += qty;
                        });
                    }
                });
            });

            let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${entityType}</th>`;
            days.forEach(day => {
                tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
            });
            tableHTML += `<th class="px-2 py-2 text-left">Total</th></tr></thead><tbody>`;
            if (entities.length === 0) {
                tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
            } else {
                entities.forEach(entity => {
                    let entityname = entity;
                    if (entityname && type === 'buyer') {
                        entityname = `${entityname.slice(0, 6)}`;
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left" title="${entity}">${entityname}</td>`;
                    } else {
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entityname}</td>`;
                    }
                    days.forEach(day => {
                        const value = tableData[entity][day] || 0;
                        tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `<td class="px-2 py-2 text-left font-semibold">${entityTotals[entity].toLocaleString()}</td>`;
                    tableHTML += `</tr>`;
                });
            }
            tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
            days.forEach(day => {
                tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
            });
            tableHTML += `<td class="px-2 py-2 text-left">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
            tableHTML += `</tr></tfoot>`;
            $("#drilldownTable").html(tableHTML);
        } else {
            const entityType = type === 'unit' ? 'Unit' : 'CC';
            const isCuttingMetric = selectedMetric.startsWith('Cutting');
            const titlePrefix = type === 'unit' ? (isCuttingMetric ? 'CC-wise' : 'Line-wise') : (isCuttingMetric ? 'Order-wise' : 'OCN-wise');
            $("#drilldownTitle").text(`${titlePrefix} Daily Performance for ${entityType} ${name} in ${month}`);

            if (type === 'unit') {
                const isCuttingMetric = selectedMetric.startsWith('Cutting');
                let entitiesSet = new Set();
                let tableData = {};
                let dailyTotals = {};
                let entityTotals = {};
                days.forEach(day => dailyTotals[day] = 0);
                const unitData = monthData.units.find(u => u.Unit === name);
                
                if (unitData) {
                    unitData.buyers.forEach(buyer => {
                        if (isCuttingMetric && buyer.data) {
                            buyer.data.forEach(item => {
                                const materialType = item.Machine_type || 'Unknown';
                                entitiesSet.add(materialType);
                                const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                const qty = parseInt(item.Qty) || 0;
                                if (!tableData[materialType]) tableData[materialType] = {};
                                if (!tableData[materialType][day]) tableData[materialType][day] = 0;
                                if (!entityTotals[materialType]) entityTotals[materialType] = 0;
                                tableData[materialType][day] += qty;
                                dailyTotals[day] += qty;
                                entityTotals[materialType] += qty;
                            });
                        } else if (buyer.lines) {
                            buyer.lines.forEach(line => {
                                const lineNo = line.Line_No;
                                entitiesSet.add(lineNo);
                                line.data.forEach(item => {
                                    const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                    const qty = parseInt(item.Qty) || 0;
                                    if (!tableData[lineNo]) tableData[lineNo] = {};
                                    if (!tableData[lineNo][day]) tableData[lineNo][day] = 0;
                                    if (!entityTotals[lineNo]) entityTotals[lineNo] = 0;
                                    tableData[lineNo][day] += qty;
                                    dailyTotals[day] += qty;
                                    entityTotals[lineNo] += qty;
                                });
                            });
                        } else if (buyer.data) {
                            const buyerName = buyer.Buyer;
                            entitiesSet.add(buyerName);
                            buyer.data.forEach(item => {
                                const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                const qty = parseInt(item.Qty) || 0;
                                if (!tableData[buyerName]) tableData[buyerName] = {};
                                if (!tableData[buyerName][day]) tableData[buyerName][day] = 0;
                                if (!entityTotals[buyerName]) entityTotals[buyerName] = 0;
                                tableData[buyerName][day] += qty;
                                dailyTotals[day] += qty;
                                entityTotals[buyerName] += qty;
                            });
                        }
                    });
                }

                let entities = Array.from(entitiesSet).sort((a, b) => a.localeCompare(b, undefined, { numeric: true }));
                let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${isCuttingMetric ? 'Machine Type' : 'Line'}</th>`;
                days.forEach(day => {
                    tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
                });
                tableHTML += `<th class="px-2 py-2 text-left">Total</th></tr></thead><tbody>`;
                if (entities.length === 0) {
                    tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
                } else {
                    entities.forEach(entity => {
                        let entityName = entity;
                        if (isCuttingMetric) {
                            entityName = `${entityName.slice(0, 6)}`;
                            tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left" title="${entity}">${entityName}</td>`;
                        } else {
                            tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entityName}</td>`;
                        }
                        days.forEach(day => {
                            const value = tableData[entity]?.[day] || 0;
                            tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                        });
                        tableHTML += `<td class="px-2 py-2 text-left font-semibold">${entityTotals[entity].toLocaleString()}</td>`;
                        tableHTML += `</tr>`;
                    });
                }
                tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
                days.forEach(day => {
                    tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
                });
                tableHTML += `<td class="px-2 py-2 text-left">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
                tableHTML += `</tr></tfoot>`;
                $("#drilldownTable").html(tableHTML);
            } else {
                let ocnsSet = new Set();
                let tableData = {};
                let dailyTotals = {};
                let ocnTotals = {};
                days.forEach(day => dailyTotals[day] = 0);
                let buyerFound = false;

                // Normalize name to string and trim
                const normalizedName = name.toString().trim();
                console.log(`Searching for buyer: ${normalizedName} in month: ${normalizedMonth}`);

                monthData.units.forEach(unit => {
                    const buyerData = unit.buyers.find(b => b.Buyer.toString().trim() === normalizedName);
                    if (buyerData) {
                        buyerFound = true;
                        console.log(`Found buyer: ${normalizedName} in unit: ${unit.Unit}`);
                        if (buyerData.lines) {
                            buyerData.lines.forEach(line => {
                                line.data.forEach(item => {
                                    const ocn = item.Order_No || 'Unknown';
                                    ocnsSet.add(ocn);
                                    const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                    const qty = parseInt(item.Qty) || 0;
                                    if (!isNaN(day)) {
                                        if (!tableData[ocn]) tableData[ocn] = {};
                                        if (!tableData[ocn][day]) tableData[ocn][day] = 0;
                                        if (!ocnTotals[ocn]) ocnTotals[ocn] = 0;
                                        tableData[ocn][day] += qty;
                                        dailyTotals[day] += qty;
                                        ocnTotals[ocn] += qty;
                                    } else {
                                        console.warn(`Invalid User_Date for OCN ${ocn}: ${item.User_Date}`);
                                    }
                                });
                            });
                        } else if (buyerData.data) {
                            buyerData.data.forEach(item => {
                                const ocn = item.Order_No || 'Unknown';
                                ocnsSet.add(ocn);
                                const day = moment(item.User_Date, 'YYYY-MM-DD').date();
                                const qty = parseInt(item.Qty) || 0;
                                if (!isNaN(day)) {
                                    if (!tableData[ocn]) tableData[ocn] = {};
                                    if (!tableData[ocn][day]) tableData[ocn][day] = 0;
                                    if (!ocnTotals[ocn]) ocnTotals[ocn] = 0;
                                    tableData[ocn][day] += qty;
                                    dailyTotals[day] += qty;
                                    ocnTotals[ocn] += qty;
                                } else {
                                    console.warn(`Invalid User_Date for OCN ${ocn}: ${item.User_Date}`);
                                }
                            });
                        }
                    }
                });

                if (!buyerFound) {
                    console.warn(`No data found for buyer: ${normalizedName} in month: ${normalizedMonth}`);
                    $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available for selected buyer</td></tr>');
                    return;
                }

                let ocns = Array.from(ocnsSet).sort((a, b) => a.localeCompare(b, undefined, { numeric: true }));
                let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${isCuttingMetric ? 'Order' : 'CC'}</th>`;
                days.forEach(day => {
                    tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
                });
                tableHTML += `<th class="px-2 py-2 text-left">Total</th></tr></thead><tbody>`;
                if (ocns.length === 0) {
                    console.warn(`No OCNs found for buyer: ${normalizedName} in month: ${normalizedMonth}`);
                    tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No OCNs available</td></tr>`;
                } else {
                    ocns.forEach(ocn => {
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${ocn}</td>`;
                        days.forEach(day => {
                            const value = tableData[ocn]?.[day] || 0;
                            tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                        });
                        tableHTML += `<td class="px-2 py-2 text-left font-semibold">${ocnTotals[ocn].toLocaleString()}</td>`;
                        tableHTML += `</tr>`;
                    });
                }
                tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
                days.forEach(day => {
                    tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
                });
                tableHTML += `<td class="px-2 py-2 text-left">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
                tableHTML += `</tr></tfoot>`;
                $("#drilldownTable").html(tableHTML);
            }
        }
    }

    $(document).ready(function() {
        
        const $menuL1 = $(".metrics-dropdown .menu.level1");
        const $btn = $("#metricsBtn");
        $btn.on('click', function(e) {
            e.stopPropagation();
            $menuL1.toggleClass('hidden');
        });
        $(document).on('click', function() {
            $menuL1.addClass('hidden');
        });
        $menuL1.on('click', function(e) {
            e.stopPropagation();
        });
        $('.submenu-item').on('click', function(e) {
            e.stopPropagation();
            const val = $(this).data('val');
            const type = $(this).data('type') || '';
            $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(val.split(':')[1] + ' ');
            $btn.data('val', val).data('type', type);
            $menuL1.addClass('hidden');
            selectedMetric = val;
            selectedType = type;
            const metricCat = (selectedMetric || '').split(':')[0] || '';
            // Update main breadcrumb depending on selected metric category
            const urlParamsBC = new URLSearchParams(window.location.search);
            const fromdateBC = urlParamsBC.get('fromdate') || '';
            const enddateBC  = urlParamsBC.get('enddate') || '';
            if (metricCat === 'Production') {
                $('.main_breadcrumb').html(
                  `<a href="/production_gut_dashboard/{{$portal_type}}?fromdate=${fromdateBC}&enddate=${enddateBC}" class="text-blue-700 hover:underline">Production Dashboard</a>
                   <span> &gt; </span>
                   <span class="text-gray-800 font-medium">Historical Data</span>`
                );
            } else {
                $('.main_breadcrumb').html(
                  `<a href="/production_gut_dashboard/{{$portal_type}}?fromdate=${fromdateBC}&enddate=${enddateBC}" class="text-blue-700 hover:underline">Production Dashboard</a>
                   <span> &gt; </span>
                   <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
                   <span> &gt; </span>
                   <span class="text-gray-800 font-medium">Historical Data</span>`
                );
            }
            const [displayStart, displayEnd] = $('#dateRangePicker').val().split(' - ');
            const startFormatted = displayStart ? moment(displayStart, 'DD-MM-YY').format('YYYY-MM-DD') : '';
            const endFormatted = displayEnd ? moment(displayEnd, 'DD-MM-YY').format('YYYY-MM-DD') : '';
            const [metricCategory, metricName] = selectedMetric.split(':');
            const titleText = `
                History Analysis for - 
                <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                    {{$portal_type}}
                </span>
                <span class="ml-4" style="color: #fff; font-weight: 500;">
                    ${displayStart} - ${displayEnd}
                </span>
            `;
            $('.dashboard_title').html(titleText);
            $('.drilldown, .month-header').removeClass('highlight');
            fetchData(selectedType, startFormatted, endFormatted, portal_type, selectedMetric);
        });
        $(document).on('click', '.drilldown', function() {
            const type = $(this).data('type');
            const name = $(this).data('name');
            const month = $(this).data('month');
            console.log(`Drilldown clicked: type=${type}, name=${name}, month=${month}`);
            $('.drilldown, .month-header').removeClass('highlight');
            $(this).addClass('highlight');
            updateDrilldownTable(type, name, month, false);
        });
        $(document).on('click', '.month-header', function() {
            const type = $(this).data('type');
            const month = $(this).data('month');
            console.log(`Month header clicked: type=${type}, month=${month}`);
            $('.drilldown, .month-header').removeClass('highlight');
            $(this).addClass('highlight');
            updateDrilldownTable(type, null, month, true);
        });
        $('#dateRangePicker').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(5, 'months').startOf('month'),
            endDate: moment(),
            maxDate: moment(),
            ranges: {
                'Last 6 Months': [moment().subtract(5, 'months').startOf('month'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')]
            },
            locale: {
                format: 'DD-MM-YY',
                separator: ' - '
            },
            isInvalidDate: function(date) {
                return date.isAfter(moment(), 'day');
            }
        }, function(start, end, label) {
            const displayStartFormatted = start.format('DD-MM-YY');
            const displayEndFormatted = end.format('DD-MM-YY');
            const startFormatted = start.format('YYYY-MM-DD');
            const endFormatted = end.format('YYYY-MM-DD');
            const [metricCategory, metricName] = selectedMetric.split(':');
            const titleText = `
                History Analysis for - 
                <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                    {{$portal_type}}
                </span>
                <span class="ml-4" style="color: #fff; font-weight: 500;">
                    ${displayStartFormatted} - ${displayEndFormatted}
                </span>
            `;
            $('.dashboard_title').html(titleText);
            $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
            $('.drilldown, .month-header').removeClass('highlight');
            fetchData(selectedType, startFormatted, endFormatted, portalType, selectedMetric);
        });

        const portalMetricMap = {
            'Production': 'Production:Quantity',
            'Line Stop': 'Line Stop:Minutes',
            'Cutting': 'Cutting:Total Cut',
            'WIP': 'WIP:WIP',
            'Labour': 'Labour:Strength'
        };

        const portalType = "{{$type}}" || 'Production';
        selectedMetric = portalMetricMap[portalType] || 'Production:Quantity';
        selectedType = $(`.submenu-item[data-val="${selectedMetric}"]`).data('type') || '1';
        $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(selectedMetric.split(':')[1] + ' ');
        $btn.data('val', selectedMetric).data('type', selectedType);

        const initialStart = moment().subtract(5, 'months').startOf('month');
        const initialEnd = moment();
        const initialStartFormatted = initialStart.format('YYYY-MM-DD');
        const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
        const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
        const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
        $('.dashboard_title').html(`
            History Analysis for - 
            <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                {{$portal_type}}
            </span>
            <span class="ml-4" style="color: #fff; font-weight: 500;">
                ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}
            </span>
        `);
        $('#dateRangePicker').val(`${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}`);
        selectedMetric = $btn.data('val') || 'Production:Quantity';
        selectedType = $btn.data('type') || '1';
        // Set initial breadcrumb based on selected metric category
        (function(){
            const cat = (selectedMetric || '').split(':')[0] || '';
            const params = new URLSearchParams(window.location.search);
            const fd = params.get('fromdate') || '';
            const ed = params.get('enddate') || '';
            if (cat === 'Production') {
                $('.main_breadcrumb').html(
                  `<a href="/production_gut_dashboard/{{$portal_type}}?fromdate=${fd}&enddate=${ed}" class="text-blue-700 hover:underline">Production Dashboard</a>
                   <span> &gt; </span>
                   <span class="text-gray-800 font-medium">Historical Data</span>`
                );
            } else {
                $('.main_breadcrumb').html(
                  `<a href="/production_gut_dashboard/{{$portal_type}}?fromdate=${fd}&enddate=${ed}" class="text-blue-700 hover:underline">Production Dashboard</a>
                   <span> &gt; </span>
                   <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
                   <span> &gt; </span>
                   <span class="text-gray-800 font-medium">Historical Data</span>`
                );
            }
        })();
        fetchData(selectedType, initialStartFormatted, initialEndFormatted, portalType, selectedMetric);

        $('#notificationsBtn').click(function() {
            $('#notificationOverlay').removeClass('hidden');
            setTimeout(() => {
                $('#notificationPanel').removeClass('translate-x-full');
            }, 10);
        });
        $(document).on('click', '#notificationOverlay, #closeNotifications', function(e) {
            if ($(e.target).is('#notificationOverlay') || $(e.target).closest('#closeNotifications').length) {
                $('#notificationPanel').addClass('translate-x-full');
                setTimeout(() => {
                    $('#notificationOverlay').addClass('hidden');
                }, 300);
            }
        });

       // Get the query params from current URL
			const urlParams = new URLSearchParams(window.location.search);
			const fromdate = urlParams.get('fromdate') || '';
			const enddate  = urlParams.get('enddate') || '';

			// Line Stop Dashboard
			$('.line_stop_item').on('click', function() {
				$('.main_breadcrumb_text').html(
					`<a href="/gut_linestop_analysis/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
						Line Stop Dashboard
					</a>`
				);
			});

			// WIP Dashboard
			$('.wip_item').on('click', function() {
				$('.main_breadcrumb_text').html(
					`<a href="/gut_wip/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
						WIP Dashboard
					</a>`
				);
			});

			// Cutting Dashboard
			$('.cutting_item').on('click', function() {
				$('.main_breadcrumb_text').html(
					`<a href="/gut_cutting_output/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
						Cutting Dashboard
					</a>`
				);
			});

			// Labour Dashboard
			$('.labour_item').on('click', function() {
				$('.main_breadcrumb_text').html(
					`<a href="/gut_direct_labour/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
						Labour Dashboard
					</a>`
				);
			});


       

					if (portal_type === 'Line Stop') {
						$('.portal_type_link').html(
							`<a href="/gut_linestop_analysis/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
								Line Stop Dashboard
							</a>`
						);
					} else if (portal_type === 'WIP') {
						$('.portal_type_link').html(
							`<a href="/gut_wip/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
								WIP Dashboard
							</a>`
						);
					} else if (portal_type === 'Cutting') {
						$('.portal_type_link').html(
							`<a href="/gut_cutting_output/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
								Cutting Dashboard
							</a>`
						);
					} else if (portal_type === 'Labour') {
						$('.portal_type_link').html(
							`<a href="/gut_direct_labour/{{$portal_type}}?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
								Labour Dashboard
							</a>`
						);
					} else {
						
					}

    });
</script>
</body>
</html>