<header class="bg-blue-900 text-white flex justify-between items-center px-4 py-2 sticky top-0 z-50">
  <div class="flex items-center space-x-2">
    <a href="/dashboard" class="inline-flex items-center justify-center rounded-lg border border-white/30 p-2 hover:bg-blue-800 transition">
      <i class="fa-solid fa-house text-white text-[20px]"></i>
    </a>
    <h1 class="text-lg font-semibold tracking-tight truncate max-w-xl dashboard_title"> </h1>
  </div>
  <div class="flex items-center space-x-2">
    <div id="loadSpinner" class="spinner hidden"></div>
    <input type="text" placeholder="Select date range" id="dateRangePicker" class="h-8 px-2 rounded-md bg-white/10 text-white border border-white/30 text-sm cursor-pointer hover:bg-white/20 transition-colors">
      <div id="HistoricalButton" class="inline-flex items-center justify-center h-8 px-3 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition">
        <i class="fa-solid fa-clock-rotate-left mr-1 text-[16px]"></i>
        Historical
      </div>
      <button id="demovideoButton" type="button" class="inline-flex items-center justify-center h-8 px-3 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition">
        <i class="fa-solid fa-video mr-1 text-[16px]"></i>
        Demo Video
      </button>
  </div>
</header>
<!-- Tailwind Modal -->
<div id="videoModal" class="fixed inset-0 z-50 hidden" aria-labelledby="videoModalTitle" role="dialog" aria-modal="true">
  <div class="flex min-h-screen items-center justify-center px-4">
    <div id="videoModalOverlay" class="fixed inset-0 bg-black/50"></div>
    <div class="relative w-full max-w-3xl rounded-lg bg-white shadow-xl">
      <div class="flex items-center justify-between border-b px-4 py-3">
        <h5 id="videoModalTitle" class="text-base font-semibold text-gray-800">Demo Video for Production Garments</h5>
        <button type="button" class="rounded p-1 text-gray-500 hover:bg-gray-100 hover:text-gray-700" data-close-video-modal aria-label="Close">
          <span class="block text-xl leading-none">&times;</span>
        </button>
      </div>
      <div class="p-4">
        


        <video id="videoPlayer" class="w-full rounded" controls>
          <source src="https://life.gainup.in/videos/ProductionDBDemoGarments.mp4" type="video/mp4">
          Your browser does not support the video tag.
        </video>
      </div>
    </div>
  </div>
</div>

<script>
  (function() {
    const openBtn = document.getElementById('demovideoButton');
    const modal = document.getElementById('videoModal');
    const overlay = document.getElementById('videoModalOverlay');
    const video = document.getElementById('videoPlayer');
    const closeButtons = document.querySelectorAll('[data-close-video-modal]');

    function openModal() {
      modal.classList.remove('hidden');
      try { video.play(); } catch (e) { /* autoplay may be blocked */ }
    }

    function closeModal() {
      try { video.pause(); video.currentTime = 0; } catch (e) {}
      modal.classList.add('hidden');
    }

    openBtn?.addEventListener('click', function(e) { e.preventDefault(); openModal(); });
    overlay?.addEventListener('click', closeModal);
    closeButtons.forEach(btn => btn.addEventListener('click', closeModal));

    // Close on Escape key
    document.addEventListener('keydown', function(e) {
      if (!modal.classList.contains('hidden') && e.key === 'Escape') {
        closeModal();
      }
    });
  })();
</script>