<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Historical Data</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- jQuery CDN -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

  <!-- Lucide Icons CDN -->
  <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

  <!-- Date picker CDN -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<!-- Custom Tailwind Configuration -->
<script>
    tailwind.config = {
        theme: {
            extend: {
                colors: {
                    'background': 'rgb(245, 246, 247)',
                    'foreground': 'rgb(31, 41, 55)',
                    'card': 'rgb(255, 255, 255)',
                    'card-foreground': 'rgb(31, 41, 55)',
                    'primary': 'rgb(15, 61, 126)',
                    'primary-foreground': 'rgb(248, 250, 252)',
                    'primary-100': 'rgb(219, 234, 254)',
                    'primary-50': 'rgb(239, 246, 255)',
                    'primary-25': 'rgb(248, 250, 252)',
                    'secondary': 'rgb(241, 245, 249)',
                    'muted': 'rgb(241, 245, 249)',
                    'muted-foreground': 'rgb(100, 116, 139)',
                    'border': 'rgb(226, 232, 240)',
                    'input': 'rgb(226, 232, 240)',
                    'ring': 'rgb(15, 61, 126)',
                },
                fontFamily: {
                    'body': ['Inter', 'system-ui', 'sans-serif'],
                }
            }
        }
    }
</script>
<style>
    /* Date picker custom styles */
    .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        
        color: white;
    }
    
    .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
    }

    /* Force <select> to match input style */
    .styled-select {
        background: rgba(248, 250, 252, 0.1);
        
        color: white;
    }

    /* Options styling */
    .styled-select option {
        color: #1f2937; /* gray-800 */
        background: white;
    }
    /* Metrics dropdown */
    .metrics-dropdown .menu.level2{display:none}
    .metrics-dropdown .menu.level1 .has-sub:hover>.menu.level2{display:block}
    .metrics-trigger{display:flex;align-items:center;gap:.25rem}

    /* Tailwind-based spinner */
    .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }
</style>
</head>
<body class="bg-gray-100 font-sans">

  <!-- Navbar -->
  <nav class="bg-blue-900 text-white px-6 flex items-center justify-between">
    <div class="flex items-center space-x-3 my-2">
      <!-- Back button -->
      <a href="/dashboard" 
          class="inline-flex items-center justify-center rounded-xl border border-white-300 px-3 py-2 text-sm font-medium text-white-700 hover:bg-gray-25 transition">
          <i data-lucide="house" class="w-5 h-5 text-white"></i>
      </a>
      <h1 class="text-lg font-semibold">Historical Data</h1>
    </div>
    <div class="flex items-center space-x-3">
      <div id="loadSpinner" class="spinner" style="display: none;"></div>
      <!-- Metrics Dropdown (hoverable with submenus) -->
      <div class="metrics-dropdown relative">
        <button id="metricsBtn" class="metrics-trigger px-4 py-2 rounded-md bg-primary-foreground/10 text-white border border-primary-foreground/20 hover:bg-primary-foreground/20" 
        data-val="Production:Quantity" data-type="1">Quantity <span class="ml-2">▾</span>
        </button>
        <div class="menu level1 hidden absolute mt-2 bg-white text-foreground rounded-md shadow-xl border border-gray-200 min-w-[220px] z-20">
          <div class="menu-title px-3 py-2 border-b text-sm font-semibold">All Metrics</div>

          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Production">
            <span>Production</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-0 bg-white rounded-md shadow-xl border border-gray-200 min-w-[220px] z-30">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Quantity" data-type="1">Quantity</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Minutes" data-type="2">Minutes</button>
              <button class="hidden submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Production:Overall" data-type="1">Overall</button>
            </div>
          </div>

          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Line Stop">
            <span>Line Stop Mins</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-0 bg-white rounded-md shadow-xl border border-gray-200 min-w-[220px] z-30">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Line Stop:Minutes" data-type="1">Minutes</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Line Stop:Loss Amount" data-type="2">Loss Amount</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Line Stop:MTBS">MTBS</button>
            </div>
          </div>

          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="WIP">
            <span>WIP</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-0 bg-white rounded-md shadow-xl border border-gray-200 min-w-[220px] z-30">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="WIP:WIP">WIP</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="WIP:WIP Value">WIP Value</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="WIP:Avg. WIP Age">Avg. WIP Age</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="WIP:Critical WIP">Critical WIP</button>
            </div>
          </div>

          

          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Cutting">
            <span>Cutting</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-0 bg-white rounded-md shadow-xl border border-gray-200 min-w-[220px] z-30">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Cutting:Total Cut">Total Cut</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Cutting:Fabric Utilization">Fabric Utilization</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Cutting:FTR %">FTR %</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Cutting:Marker Efficiency">Marker Efficiency</button>
            </div>
          </div>

          <div class="menu-item has-sub flex items-center justify-between px-3 py-2 hover:bg-gray-100 cursor-default" data-key="Labour">
            <span>Labour</span><span class="text-gray-400">›</span>
            <div class="menu level2 hidden absolute left-full top-0 bg-white rounded-md shadow-xl border border-gray-200 min-w-[220px] z-30">
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Labour:Strength">Strength</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Labour:Absenteeism">Absenteeism</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Labour:Attrition">Attrition</button>
              <button class="submenu-item block w-full text-left px-3 py-2 hover:bg-gray-100" data-val="Labour:Recruitment">Recruitment</button>
            </div>
          </div>
        </div>
      </div>

      <!-- Date Range Picker -->
        <div class="date-picker">
            <input type="text" placeholder="Select date range" class="h-10 px-3 py-2 rounded-md bg-primary-foreground/10 text-white border border-primary-foreground/20 hover:bg-primary-foreground/20 hover:text-white text-sm cursor-pointer transition-colors" id="dateRangePicker">
        </div>

      <!-- Notifications Button -->
      <button class="inline-flex items-center justify-center rounded-md bg-primary-foreground/10 text-white border border-primary-foreground/20 hover:bg-primary-foreground/20 hover:text-white h-10 w-10 transition-colors" id="notificationsBtn">
          <i data-lucide="bell" class="h-5 w-5 text-white"></i>
      </button>
    
    </div>
  </nav>

  <!-- Breadcrumb -->
  <div class="px-6 py-3 text-sm text-gray-600">
    <a href="/production_gar_dashboard" class="text-blue-700 hover:underline">Production Dashboard</a> 
    <span> &gt; </span>
    <span class="text-gray-800 font-medium">Historical Data</span>
  </div>

  <!-- Main Content -->
  <div class="px-6  grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="bg-white p-6 rounded-lg shadow">
      <h2 class="text-lg font-semibold mb-4">Unit-wise Performance</h2>
      <p class="text-sm text-gray-500 mb-2">Month-on-month output by production unit.</p>
      <table class="w-full border-collapse text-sm">
        <thead>
          <tr class="bg-gray-100">
            <th class="px-4 py-2 text-left">Unit</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="Apr">Apr</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="May">May</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="Jun">Jun</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="Jul">Jul</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="Aug">Aug</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="unit" data-month="Sep">Sep</th>
          </tr>
        </thead>
        <tbody>
          
        </tbody>
      </table>
    </div>

    <div class="bg-white p-6 rounded-lg shadow">
      <h2 class="text-lg font-semibold mb-4">Buyer-wise Performance</h2>
      <p class="text-sm text-gray-500 mb-2">Month-on-month output by buyer.</p>
      <table class="w-full border-collapse text-sm">
        <thead>
          <tr class="bg-gray-100">
            <th class="px-4 py-2 text-left">Buyer</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="Apr">Apr</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="May">May</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jun">Jun</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jul">Jul</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="Aug">Aug</th>
            <th class="px-4 py-2 month-header cursor-pointer" data-type="buyer" data-month="Sep">Sep</th>
          </tr>
        </thead>
        <tbody>
          
        </tbody>
      </table>
    </div>
  </div>

  <!-- Drilldown Section -->
  <div class="px-6 py-4">
    <div class="bg-white p-6 rounded-lg shadow">
      <h2 id="drilldownTitle" class="text-lg font-semibold mb-4">Daily Performance table</h2>
      <p class="text-sm text-gray-500 mb-2">Showing daily output values. Click a cell to navigate to that day's overview.</p>
      <div class="overflow-x-auto">
        <table id="drilldownTable" class="w-full border-collapse text-sm">
          <!-- Dynamic Content Goes Here -->
        </table>
      </div>
    </div>
  </div>

  <!-- Notification Side Panel (hidden by default) -->
  <div class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden" id="notificationOverlay">
      <div class="fixed right-0 top-0 h-full w-80 bg-white shadow-lg transform translate-x-full transition-transform duration-300" id="notificationPanel">
          <div class="p-6 border-b border-border">
              <div class="flex items-center justify-between">
                  <h2 class="text-lg font-semibold">Production Alerts</h2>
                  <button class="text-muted-foreground hover:text-foreground" id="closeNotifications">
                      <i data-lucide="x" class="h-5 w-5"></i>
                  </button>
              </div>
          </div>
          <div class="p-6">
              <p class="text-muted-foreground">No new alerts at this time.</p>
          </div>
      </div>
  </div>

<script>
    // Global variables
    let apiData = {};
    let selectedMetric = "Production:Quantity";
    let selectedType = "1";

    // API route mapping based on selected metric
    const apiRoutes = {
        'Production:Quantity': '/productionhistoricaldata',
        'Production:Minutes': '/productionhistoricaldata',
        'Production:Overall': '/productionhistoricaldata',
        'WIP:WIP': '/wip_historicaldata',
        'WIP:WIP Value': '/wip_value_historicaldata',
        'WIP:Avg. WIP Age': '/avg_wip_age_historicaldata',
        'WIP:Critical WIP': '/critical_wip_historicaldata',
        'Line Stop:Minutes': '/production_minis_historicaldata',
        'Line Stop:Loss Amount': '/production_minis_historicaldata',
        'Line Stop:MTBS': '/mtbs_historicaldata',
        'Cutting:Total Cut': '/total_cut_historicaldata',
        'Cutting:Fabric Utilization': '/fabric_utilization_historicaldata',
        'Cutting:FTR %': '/ftr_percent_historicaldata',
        'Cutting:Marker Efficiency': '/marker_efficiency_historicaldata',
        'Labour:Strength': '/strength_historicaldata',
        'Labour:Absenteeism': '/absenteeism_historicaldata',
        'Labour:Attrition': '/attrition_historicaldata',
        'Labour:Recruitment': '/recruitment_historicaldata'
    };

    function fetchData(type = "", fromDate = "", toDate = "", portal_type = "", metric = "Production:Quantity") {
        const apiUrl = apiRoutes[metric];
        if (!apiUrl) {
            $("#loadSpinner").hide();
            console.warn(`No API route available for metric: ${metric}`);
            return;
        }

        $("#loadSpinner").show();
        $.ajax({
            url: apiUrl,
            method: 'GET',
            data: { type: type, fromdate: fromDate, enddate: toDate },
            success: function(response) {
                $("#loadSpinner").hide();
                if (response && response.success && response.data) {
                    apiData = response.data;
                    updateTables(apiData, fromDate, toDate, metric);
                } else {
                    console.warn("Invalid API response, resetting data");
                    apiData = {};
                }
            },
            error: function() {
                $("#loadSpinner").hide();
                console.error("Error fetching data from", apiUrl);
                apiData = {};
            }
        });
    }

    function updateTables(data, fromDate, toDate, metric) {
        const start = fromDate ? moment(fromDate, 'YYYY-MM-DD') : moment().subtract(6, 'months');
        const end = toDate ? moment(toDate, 'YYYY-MM-DD') : moment();
        const months = [];
        for (let m = moment(start); m.isSameOrBefore(end); m.add(1, 'month')) {
            months.push(m.format('MMM'));
        }

        // Calculate monthly totals for units
        let unitMonthlyTotals = {};
        months.forEach(month => unitMonthlyTotals[month] = 0);
        data.forEach(monthData => {
            const month = monthData.Mon_Name.slice(0, 3);
            if (months.includes(month)) {
                monthData.units.forEach(unit => {
                    const total = unit.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0);
                    unitMonthlyTotals[month] += total;
                });
            }
        });

        let unitTableHTML = `<thead><tr class="bg-gray-100"><th class="px-4 py-2 text-left">Unit</th>`;
        months.forEach(month => {
            unitTableHTML += `<th class="px-4 py-2 month-header cursor-pointer text-left" data-type="unit" data-month="${month}">${month}</th>`;
        });
        unitTableHTML += `</tr></thead><tbody>`;
        const units = [...new Set(data.map(item => item.units.map(u => u.Unit)).flat())];
        units.forEach(unit => {
            unitTableHTML += `<tr class="border-t"><td class="px-4 py-2">${unit}</td>`;
            months.forEach(month => {
                const monthData = data.find(d => d.Mon_Name.startsWith(month));
                const unitData = monthData?.units.find(u => u.Unit === unit);
                const total = unitData ? unitData.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0) : 0;
                unitTableHTML += `<td class="px-4 py-2 drilldown cursor-pointer text-left" data-type="unit" data-name="${unit}" data-month="${month}">${total.toLocaleString()}</td>`;
            });
            unitTableHTML += `</tr>`;
        });
        unitTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-4 py-2 text-left">Total</td>`;
        months.forEach(month => {
            unitTableHTML += `<td class="px-4 py-2 text-left">${unitMonthlyTotals[month].toLocaleString()}</td>`;
        });
        unitTableHTML += `</tr></tfoot>`;
        $('table').eq(0).html(unitTableHTML);

        // Calculate monthly totals for buyers
        let buyerMonthlyTotals = {};
        months.forEach(month => buyerMonthlyTotals[month] = 0);
        data.forEach(monthData => {
            const month = monthData.Mon_Name.slice(0, 3);
            if (months.includes(month)) {
                monthData.units.forEach(unit => {
                    unit.buyers.forEach(buyer => {
                        buyerMonthlyTotals[month] += buyer.buyer_total_Audit_Qty;
                    });
                });
            }
        });

        let buyerTableHTML = `<thead><tr class="bg-gray-100"><th class="px-4 py-2 text-left">Buyer</th>`;
        months.forEach(month => {
            buyerTableHTML += `<th class="px-4 py-2 month-header cursor-pointer text-left" data-type="buyer" data-month="${month}">${month}</th>`;
        });
        buyerTableHTML += `</tr></thead><tbody>`;
        const buyers = [...new Set(data.map(item => item.units.map(u => u.buyers.map(b => b.Buyer)).flat()).flat())];
        buyers.forEach(buyer => {
            buyerTableHTML += `<tr class="border-t"><td class="px-4 py-2">${buyer}</td>`;
            months.forEach(month => {
                const monthData = data.find(d => d.Mon_Name.startsWith(month));
                let total = 0;
                if (monthData) {
                    monthData.units.forEach(unit => {
                        const buyerData = unit.buyers.find(b => b.Buyer === buyer);
                        if (buyerData) total += buyerData.buyer_total_Audit_Qty;
                    });
                }
                buyerTableHTML += `<td class="px-4 py-2 drilldown cursor-pointer text-left" data-type="buyer" data-name="${buyer}" data-month="${month}">${total.toLocaleString()}</td>`;
            });
            buyerTableHTML += `</tr>`;
        });
        buyerTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-4 py-2 text-left">Total</td>`;
        months.forEach(month => {
            buyerTableHTML += `<td class="px-4 py-2 text-left">${buyerMonthlyTotals[month].toLocaleString()}</td>`;
        });
        buyerTableHTML += `</tr></tfoot>`;
        $('table').eq(1).html(buyerTableHTML);

        updateDrilldownTable('unit', units[0] || 'G-I', months[0] || 'Oct');
    }

    function updateDrilldownTable(type, name, month, isMonthHeader = false) {
        const monthData = apiData.find(d => d.Mon_Name.startsWith(month));
        if (!monthData) {
            $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>');
            return;
        }

        let daysSet = new Set();
        monthData.units.forEach(unit => {
            unit.buyers.forEach(buyer => {
                buyer.lines.forEach(line => {
                    line.data.forEach(item => {
                        const day = moment(item.User_Date).date();
                        daysSet.add(day);
                    });
                });
            });
        });
        let days = Array.from(daysSet).sort((a, b) => a - b);

        if (isMonthHeader) {
            const entityType = type === 'unit' ? 'Unit' : 'Buyer';
            $("#drilldownTitle").text(`Daily Performance for All ${entityType}s in ${month}`);

            let entities = type === 'unit' ? [...new Set(monthData.units.map(u => u.Unit))] : 
                           [...new Set(monthData.units.flatMap(u => u.buyers.map(b => b.Buyer)))];

            let tableData = {};
            let dailyTotals = {};
            days.forEach(day => dailyTotals[day] = 0);

            entities.forEach(entity => {
                tableData[entity] = {};
                days.forEach(day => tableData[entity][day] = 0);
            });
 
            monthData.units.forEach(unit => {
                unit.buyers.forEach(buyer => {
                    buyer.lines.forEach(line => {
                        line.data.forEach(item => {
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Audit_Qty) || 0;
                            const entity = type === 'unit' ? unit.Unit : buyer.Buyer;
                            tableData[entity][day] += qty;
                            dailyTotals[day] += qty;
                        });
                    });
                });
            });

            let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${entityType}</th>`;
            days.forEach(day => {
                tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
            });
            tableHTML += `</tr></thead><tbody>`;
            entities.forEach(entity => {
                tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entity}</td>`;
                days.forEach(day => {
                    const value = tableData[entity][day] || 0;
                    tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                });
                tableHTML += `</tr>`;
            });
            tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
            days.forEach(day => {
                tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
            });
            tableHTML += `</tr></tfoot>`;
            $("#drilldownTable").html(tableHTML);
        } else {
            const entityType = type === 'unit' ? 'Unit' : 'Buyer';
            const titlePrefix = type === 'unit' ? 'Line-wise' : 'OCN-wise';
            $("#drilldownTitle").text(`${titlePrefix} Daily Performance for ${entityType} ${name} in ${month}`);

            if (type === 'unit') {
                let linesSet = new Set();
                let tableData = {};
                let dailyTotals = {};
                days.forEach(day => dailyTotals[day] = 0);

                const unitData = monthData.units.find(u => u.Unit === name);
                if (unitData) {
                    unitData.buyers.forEach(buyer => {
                        buyer.lines.forEach(line => {
                            const lineNo = line.Line_No;
                            linesSet.add(lineNo);
                            line.data.forEach(item => {
                                const day = moment(item.User_Date).date();
                                const qty = parseInt(item.Audit_Qty) || 0;
                                if (!tableData[lineNo]) tableData[lineNo] = {};
                                if (!tableData[lineNo][day]) tableData[lineNo][day] = 0;
                                tableData[lineNo][day] += qty;
                                dailyTotals[day] += qty;
                            });
                        });
                    });
                }

                let lines = Array.from(linesSet).sort((a, b) => a.localeCompare(b, undefined, {numeric: true}));

                let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">Line</th>`;
                days.forEach(day => {
                    tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
                });
                tableHTML += `</tr></thead><tbody>`;
                lines.forEach(line => {
                    tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${line}</td>`;
                    days.forEach(day => {
                        const value = tableData[line]?.[day] || 0;
                        tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `</tr>`;
                });
                tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
                days.forEach(day => {
                    tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
                });
                tableHTML += `</tr></tfoot>`;
                $("#drilldownTable").html(tableHTML);
            } else {
                let ocnsSet = new Set();
                let tableData = {};
                let dailyTotals = {};
                days.forEach(day => dailyTotals[day] = 0);

                monthData.units.forEach(unit => {
                    const buyerData = unit.buyers.find(b => b.Buyer === name);
                    if (buyerData) {
                        buyerData.lines.forEach(line => {
                            line.data.forEach(item => {
                                const ocn = item.Order_No || 'Unknown';
                                ocnsSet.add(ocn);
                                const day = moment(item.User_Date).date();
                                const qty = parseInt(item.Audit_Qty) || 0;
                                if (!tableData[ocn]) tableData[ocn] = {};
                                if (!tableData[ocn][day]) tableData[ocn][day] = 0;
                                tableData[ocn][day] += qty;
                                dailyTotals[day] += qty;
                            });
                        });
                    }
                });

                let ocns = Array.from(ocnsSet).sort((a, b) => a.localeCompare(b, undefined, {numeric: true}));

                let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">OCN</th>`;
                days.forEach(day => {
                    tableHTML += `<th class="px-2 py-2 text-left">${day}</th>`;
                });
                tableHTML += `</tr></thead><tbody>`;
                ocns.forEach(ocn => {
                    tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${ocn.slice(-4)}</td>`;
                    days.forEach(day => {
                        const value = tableData[ocn]?.[day] || 0;
                        tableHTML += `<td class="px-2 py-2 text-left">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `</tr>`;
                });
                tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
                days.forEach(day => {
                    tableHTML += `<td class="px-2 py-2 text-left">${dailyTotals[day].toLocaleString()}</td>`;
                });
                tableHTML += `</tr></tfoot>`;
                $("#drilldownTable").html(tableHTML);
            }
        }
    }

    $(document).ready(function() {
        lucide.createIcons();

        const $menuL1 = $(".metrics-dropdown .menu.level1");
        const $btn = $("#metricsBtn");
        $btn.on('click', function(e) {
            e.stopPropagation();
            $menuL1.toggleClass('hidden');
        });
        $(document).on('click', function() {
            $menuL1.addClass('hidden');
        });
        $menuL1.on('click', function(e) {
            e.stopPropagation();
        });
        $('.submenu-item').on('click', function(e) {
            e.stopPropagation();
            const val = $(this).data('val');
            const type = $(this).data('type') || '';
            $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(val.split(':')[1] + ' ');
            $btn.data('val', val).data('type', type);
            $menuL1.addClass('hidden');
            selectedMetric = val;
            selectedType = type;
            const [displayStart, displayEnd] = $('#dateRangePicker').val().split(' - ');
            const startFormatted = displayStart ? moment(displayStart, 'DD-MM-YY').format('YYYY-MM-DD') : '';
            const endFormatted = displayEnd ? moment(displayEnd, 'DD-MM-YY').format('YYYY-MM-DD') : '';
            fetchData(selectedType, startFormatted, endFormatted, null, selectedMetric);
        });

        $(document).on('click', '.drilldown', function() {
            const type = $(this).data('type');
            const name = $(this).data('name');
            const month = $(this).data('month');
            updateDrilldownTable(type, name, month, false);
        });

        $(document).on('click', '.month-header', function() {
            const type = $(this).data('type');
            const month = $(this).data('month');
            updateDrilldownTable(type, null, month, true);
        });

        $('#dateRangePicker').daterangepicker({
            opens: 'left',
            startDate: moment().startOf('month'),
            endDate: moment().endOf('month'),
            maxDate: moment(),
            ranges: {
                'Today': [moment(), moment()],
                'Last 6 Months': [moment().subtract(6, 'months'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')]
            }
        }, function(start, end, label) {
            const displayStartFormatted = start.format('DD-MM-YY');
            const displayEndFormatted = end.format('DD-MM-YY');
            $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
            const startFormatted = label === 'Last 6 Months' ? '' : start.format('YYYY-MM-DD');
            const endFormatted = label === 'Last 6 Months' ? '' : end.format('YYYY-MM-DD');
            fetchData(selectedType, startFormatted, endFormatted, null, selectedMetric);
        });

        const initialStart = moment().startOf('month');
        const initialEnd = moment().endOf('month');
        const initialStartFormatted = initialStart.format('YYYY-MM-DD');
        const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
        const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
        const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
        $('#dateRangePicker').val(`${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}`);
        selectedMetric = $btn.data('val') || 'Production:Quantity';
        selectedType = $btn.data('type') || '1';
        fetchData(selectedType, initialStartFormatted, initialEndFormatted, null, selectedMetric);

        $('#notificationsBtn').click(function() {
            $('#notificationOverlay').removeClass('hidden');
            setTimeout(() => {
                $('#notificationPanel').removeClass('translate-x-full');
            }, 10);
        });

        $(document).on('click', '#notificationOverlay, #closeNotifications', function(e) {
            if ($(e.target).is('#notificationOverlay') || $(e.target).closest('#closeNotifications').length) {
                $('#notificationPanel').addClass('translate-x-full');
                setTimeout(() => {
                    $('#notificationOverlay').addClass('hidden');
                }, 300);
            }
        });
    });
</script>

</body>
</html>
