<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Supermarket Stock — Dashboard</title>

    <!-- Tailwind CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.3.0/dist/chart.umd.min.js"></script>

    <!-- DataTables (for table pagination/search) -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

      <script>
        tailwind.config = {
        theme: {
        extend: {
        colors: {
        'background': 'rgb(245, 246, 247)',
        'foreground': 'rgb(31, 41, 55)',
        'card': 'rgb(255, 255, 255)',
        'card-foreground': 'rgb(31, 41, 55)',
        'primary': 'rgb(15, 61, 126)',
        'primary-foreground': 'rgb(248, 250, 252)',
        'primary-100': 'rgb(219, 234, 254)',
        'primary-50': 'rgb(239, 246, 255)',
        'primary-25': 'rgb(248, 250, 252)',
        'secondary': 'rgb(241, 245, 249)',
        'muted': 'rgb(241, 245, 249)',
        'muted-foreground': 'rgb(100, 116, 139)',
        'border': 'rgb(226, 232, 240)',
        'input': 'rgb(226, 232, 240)',
        'ring': 'rgb(15, 61, 126)',
        },
        fontFamily: {
        'body': ['Inter', 'system-ui', 'sans-serif'],
        }
        }
        }
        }
      </script>

      <style>
        :root{
        --navy:#143f6b;
        --card-border: rgba(20,63,107,0.06);
        --muted: #6b7280;
        --accent: #0f62a8;
        --accent-dark: #08325b;
        }
        body { font-family: Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial; background:#f3f4f6; color:#0f172a; }
        .card { background: #fff; border-radius: 10px; border:1px solid var(--card-border); box-shadow: 0 2px 8px rgba(15,59,102,0.03); }
        .kpi-value { font-weight: 700; font-size: 1.4rem; color:#0b2540; }
        .small-p { font-size: .78rem; color:var(--muted); }
        canvas.spark { width: 120px; height: 36px; }
        canvas.hbar { height: 220px; }
        .tiny-spark { width: 110px; height: 30px; display:inline-block; }
        .dataTables_wrapper .dataTables_filter input { border:1px solid #e6e6e6; padding:.5rem .6rem; border-radius:6px; }
        /* Compact DataTables length control */
        .dataTables_wrapper .dataTables_length label { font-size: 12px; color:#6b7280; }
        .dataTables_wrapper .dataTables_length select { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:auto; min-width:56px; }
        /* Compact DataTables search control */
        .dataTables_wrapper .dataTables_filter input { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:120px; background-color: #D3D3D3; }
        /* Compact DataTables info and pagination */
        .dataTables_wrapper .dataTables_info { font-size: 12px; color:#6b7280; }
        .dataTables_wrapper .dataTables_paginate { font-size: 12px; }
        .dataTables_wrapper .dataTables_paginate .paginate_button { padding: 2px 6px; margin: 0 1px; font-size: 12px; }
        /* Compact vertical padding for stock table rows */
        #stockTable tbody tr > th,
        #stockTable tbody tr > td { padding-top: 4px; padding-bottom: 4px; }
        .progress-track { background: #eef2f7; height:8px; border-radius:999px; display:block; overflow:hidden; }
        .progress-fill { height:8px; border-radius:999px; }
        .trend-mini { width:80px; height:30px; display:inline-block; }
        .low-stock { background: rgba(254, 242, 242, 0.7); }
        .icon-btn { background: #f8fafc; border:1px solid #eef2f7; padding:6px; border-radius:6px; }
        .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
        }
        .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
        }
        .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
        to { transform: rotate(360deg); }
        }
      </style>
    </head>
  <body>

    <header class="bg-[var(--navy)] text-white py-2">
      <div class="mx-auto px-6 flex items-center justify-between">
        <div class="flex items-center space-x-2">
          <a href="/dashboard" class="inline-flex items-center justify-center rounded-lg border border-white/30 p-2 hover:bg-blue-800 transition">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 text-white">
              <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8"></path>
              <path d="M3 10a2 2 0 0 1 .709-1.528l7-6a2 2 0 0 1 2.582 0l7 6A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
            </svg>
          </a>
          <h1 class="text-lg font-semibold tracking-tight truncate max-w-xl dashboard_title">Supermarket Stock Analysis</h1>
        </div>
        <div class="flex items-center gap-3">
          <div id="loadSpinner" class="spinner hidden"></div>
          <input type="text" placeholder="Select date range" id="dateRangePicker" class="h-8 px-2 rounded-md bg-white/10 text-white border border-white/30 text-sm cursor-pointer hover:bg-white/20 transition-colors">
            <button class="icon-btn">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6 6 0 10-12 0v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
              </svg>
            </button>
          </div>
      </div>
    </header>

    <div class="px-6 py-3 text-sm text-gray-600">
      <a href="/production_gar_dashboard" class="text-blue-700 hover:underline">Production Dashboard</a>
      <span> &gt; </span>
      <span class="text-gray-800 font-medium">Supermarket Stock Analysis</span>
    </div>

    <main class="mx-auto px-6 pb-3 space-y-6">

      <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi1">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">SM Availability</div>
              <div class="kpi-value" id="sm-avail">94.7%</div>
              <div class="text-xs text-green-600 mt-1" id="sm-trend">▲ 5.3% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k1" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 95%</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi2">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Full Kit Availability</div>
              <div class="kpi-value" id="kit-avail">88.9%</div>
              <div class="text-xs text-red-600 mt-1" id="kit-trend">▼ 1.3% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k2" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 98%</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi3">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Total Stock Quantity</div>
              <div class="kpi-value" id="stock-qty">4,640</div>
              <div class="text-xs text-red-600 mt-1" id="stock-trend">▼ 8.2% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k3" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 2,500</div>
        </div>

        <div class="card px-3 py-2 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi4">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Stock Coverage Days</div>
              <div class="kpi-value" id="coverage-days">6 days</div>
              <div class="text-xs text-green-600 mt-1" id="coverage-trend">▲ 1.5% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k4" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 5 days</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi5">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Total Input Today</div>
              <div class="kpi-value" id="input-today">787</div>
              <div class="text-xs text-green-600 mt-1" id="input-trend">▲ 0.6% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k5" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 500</div>
        </div>
      </div>

      <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="card p-4 lg:col-span-2">
          <div class="flex items-start justify-between">
            <div>
              <div class="text-sm font-semibold">Trend for All CC</div>
              <div class="text-xs text-[var(--muted)]">Time-series trend for the selected KPI.</div>
            </div>
            <div class="small-p">All CC</div>
          </div>
          <div class="mt-4">
            <div class="h-56">
              <canvas id="overallTrend"></canvas>
            </div>
          </div>
        </div>

        <div class="card p-4">
          <div class="text-sm font-semibold">Right Summary</div>
          <div id="buyerCrumb" class="text-xs text-[var(--muted)] mt-2">ALL CC</div>
          <div class="mt-6">
            <div class="h-48">
              <canvas id="buyerBars" class="hbar cursor-pointer"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="card p-4">
        <div class="flex items-center justify-between">
          <div>
            <div class="text-lg font-semibold">Supermarket Stock Details</div>
            <div class="text-xs text-[var(--muted)]">Live inventory of components and materials ready for production.</div>
          </div>
          <div class="flex items-center gap-2">
            <button class="icon-btn" title="Alerts">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 9v2m0 4h.01M7 12a5 5 0 1110 0v6H7v-6z"/>
              </svg>
            </button>
            <button class="icon-btn" title="Export">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-600" viewBox="0 0 20 20" fill="currentColor">
                <path d="M3 3a1 1 0 000 2h14a1 1 0 100-2H3zM3 7a1 1 0 000 2h8a1 1 0 100-2H3zM3 11a1 1 0 000 2h6a1 1 0 100-2H3z"/>
              </svg>
            </button>
          </div>
        </div>

        <div class="mt-4 overflow-x-auto" id="stockTableContainer">
          <table id="stockTable" class="w-full text-sm" style="width: calc(100% - 10px);">
            <thead class="text-xs text-[var(--muted)] border-b">
              <tr class="text-left">
                <th class="py-3 px-3">OCN / Style / Color</th>
                <th class="py-3 px-3">Size</th>
                <th class="py-3 px-3">Stock (pcs)</th>
                <th class="py-3 px-3">Days of Stock</th>
                <th class="py-3 px-3">SM Received</th>

                <th class="py-3 px-3">SM Rcv % VS Order</th>
                <th class="py-3 px-3">Input Trend</th>
                <th class="py-3 px-3">Issued</th>
                <th class="py-3 px-3">Issued % VS Order</th>
                <th class="py-3 px-3">Issued Trend</th>
              </tr>
            </thead>
            <tbody id="stockBody" class="text-slate-800 text-xs"></tbody>
          </table>
        </div>
      </div>

    </main>

    <script>
      // Icons now use Font Awesome; no initialization required
      // Global variables
      let selectedRangeLabel = "Last Week";
      let apiData = [];
      let tableData = [];
      let buyerDrillPath = ['root'];
      let BUYER_DRILL = {};
      let currentKpi = null;
      let sparkCharts = {};
      let ocnMap = {};
      let stockTable = null;
      let selectedFilter = null; // { key, label } used to highlight/filter at terminal level

      // Chart defaults
      Chart.defaults.font.family = "'Inter', sans-serif";
      Chart.defaults.font.size = 11;
      Chart.defaults.color = "#4b5563";

      // KPI sparkline function
      function createSpark(id, data, color, fill=false) {
      const ctx = document.getElementById(id)?.getContext('2d');
      if (!ctx) return null;
      if (sparkCharts[id]) {
      sparkCharts[id].destroy();
      }
      const chart = new Chart(ctx, {
      type: 'line',
      data: {
      labels: data.map((_,i)=>i),
      datasets: [{
      data,
      borderColor: color,
      backgroundColor: fill ? color+'20' : 'transparent',
      fill: fill,
      tension: 0.4,
      borderWidth: 1.7,
      pointRadius:0
      }]
      },
      options: {
      responsive:true,
      maintainAspectRatio:false,
      plugins:{legend:{display:false}},
      scales:{x:{display:false}, y:{display:false}}
      }
      });
      sparkCharts[id] = chart;
      return chart;
      }

      // Build drill data from apiData
      function buildDrillData(filteredData) {
      let drill = {};
      let buyers = {};
      ocnMap = {};

      if (!filteredData || !Array.isArray(filteredData) || filteredData.length === 0) {
      drill['root'] = {
      title: 'ALL CC',
      labels: [],
      data: [],
      kpiData: { sm: 0, kit: 0, stock: 0, coverage: 0, input: 0 },
      overallTrend: [0, 0, 0, 0, 0, 0, 0],
      tableData: []
      };
      return drill;
      }

      filteredData.forEach(unit => {
      if (!unit.buyers || !Array.isArray(unit.buyers)) return;
      unit.buyers.forEach(buyer => {
      if (!buyer.Buyer || !buyer.data || !Array.isArray(buyer.data)) return;
      if (!buyers[buyer.Buyer]) {
      buyers[buyer.Buyer] = {
      ocns: {},
      items: [],
      totalStock: 0,
      totalInput: 0,
      totalIssued: 0,
      sumInputPct: 0,
      sumIssuedPct: 0,
      sumDays: 0,
      count: 0
      };
      }
      let b = buyers[buyer.Buyer];
      buyer.data.forEach(item => {
      const ocnLastFour = item.Order_No ? item.Order_No.slice(-4) : " ";
      const buyername = item.Buyer ? item.Buyer.replace(/[^a-zA-Z]/g, '').slice(0, 6) : " ";
      const itemname = item.Item ? item.Item.replace(/[^a-zA-Z]/g, '').slice(0, 5) : " ";
      const colorname = item.Color ? item.Color.replace(/[^a-zA-Z]/g, '').slice(0, 5) : " ";
      const stock = parseInt(item.Stock) || 0;
      const input = parseInt(item.SM_Rcvd) || 0;
      const issued = parseInt(item.Iss_Qty) || 0;
      const ackwait = parseInt(item.Ack_Waiting) || 0;
      const inputPct = parseFloat(item.Sm_Rcvd_Perc) || 0;
      const issuedPct = parseFloat(item.Iss_Perc) || 0;
      const days = input > 0 ? Math.round(stock / input) : 0;
      b.totalStock += stock;
      b.totalInput += input;
      b.totalIssued += issued;
      b.sumInputPct += inputPct;
      b.sumIssuedPct += issuedPct;
      b.sumDays += days;
      b.count++;
      const row = {
      ocn: `${buyername}${ocnLastFour}/${itemname}/${colorname}`,
      desc: `${item.Item || 'Unknown'} / ${item.Color || 'Unknown'}`,
      itemOnly: item.Item || 'Unknown',
      colorOnly: item.Color || 'Unknown',
      itemId: item.Itemid || item.ItemId || '',
      colorId: item.Colorid || item.ColorId || '',
      sizeId: item.SIzeid || item.SizeId || item.Sizeid || '',
      size: item.Size || 'N/A',
      stock,
      days,
      input,
      ackwait,
      inputPct,
      inputTrend: [inputPct-4, inputPct-2, inputPct, inputPct+2, inputPct-1],
      issued,
      issuedPct,
      issuedTrend: [issuedPct-3, issuedPct-1, issuedPct, issuedPct+1, issuedPct],
      lowStock: stock === 0,
      buyer: buyer.Buyer,
      fullOcn: item.Order_No
      };
      b.items.push(row);
      if (!b.ocns[item.Order_No]) {
      b.ocns[item.Order_No] = {
      items: [],
      totalStock: 0,
      totalInput: 0,
      totalIssued: 0,
      sumInputPct: 0,
      sumIssuedPct: 0,
      sumDays: 0,
      count: 0
      };
      }
      let o = b.ocns[item.Order_No];
      o.items.push(row);
      o.totalStock += stock;
      o.totalInput += input;
      o.totalIssued += issued;
      o.sumInputPct += inputPct;
      o.sumIssuedPct += issuedPct;
      o.sumDays += days;
      o.count++;
      });
      });
      });

      let root = {
      title: 'ALL CC',
      labels: [],
      data: [],
      kpiData: {},
      overallTrend: [],
      tableData: []
      };
      let allTotalStock = 0, allTotalInput = 0, allTotalIssued = 0, allSumInputPct = 0, allSumIssuedPct = 0, allSumDays = 0, allCount = 0;
      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      root.labels.push(bName);
      // Use total stock for buyer bar values
      root.data.push(b.totalStock);
      allTotalStock += b.totalStock;
      allTotalInput += b.totalInput;
      allTotalIssued += b.totalIssued;
      allSumInputPct += b.sumInputPct;
      allSumIssuedPct += b.sumIssuedPct;
      allSumDays += b.sumDays;
      allCount += b.count;
      root.tableData.push(...b.items);
      });
      root.kpiData = {
      sm: allCount ? (allSumInputPct / allCount).toFixed(1) : 0,
      kit: allCount ? (allSumIssuedPct / allCount).toFixed(1) : 0,
      stock: allTotalStock,
      coverage: allCount ? Math.round(allSumDays / allCount) : 0,
      input: allTotalInput
      };
      root.overallTrend = allCount ? [root.kpiData.sm - 5, root.kpiData.sm - 2, root.kpiData.sm, root.kpiData.sm + 2, root.kpiData.sm - 1, root.kpiData.sm + 1, root.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill['root'] = root;

      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      let node = {
      title: `ALL CC > ${bName}`,
      labels: [],
      data: [],
      kpiData: {
      sm: b.count ? (b.sumInputPct / b.count).toFixed(1) : 0,
      kit: b.count ? (b.sumIssuedPct / b.count).toFixed(1) : 0,
      stock: b.totalStock,
      coverage: b.count ? Math.round(b.sumDays / b.count) : 0,
      input: b.totalInput
      },
      overallTrend: [],
      tableData: b.items
      };
      Object.keys(b.ocns).forEach(ocnName => {
      let o = b.ocns[ocnName];
      const shortOcn = ocnName.slice(-4);
      node.labels.push(shortOcn);
      // Use OCN-level total stock for bar values
      node.data.push(o.totalStock);
      ocnMap[shortOcn] = ocnName;
      });
      node.overallTrend = b.count ? [node.kpiData.sm - 5, node.kpiData.sm - 2, node.kpiData.sm, node.kpiData.sm + 2, node.kpiData.sm - 1, node.kpiData.sm + 1, node.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill[bName] = node;
      });

      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      Object.keys(b.ocns).forEach(ocnName => {
      let o = b.ocns[ocnName];
      const shortOcn = ocnName.slice(-4);
      // Aggregate deepest level by Item only (exclude Color)
      const byItem = {};
      o.items.forEach(it => {
      const key = it.itemOnly || 'Unknown';
      if (!byItem[key]) byItem[key] = 0;
      byItem[key] += it.stock || 0;
      });

      let subnode = {
      title: `ALL CC > ${bName} > ${shortOcn}`,
      labels: Object.keys(byItem),
      // Use summed stock per Item
      data: Object.keys(byItem).map(k => byItem[k]),
      kpiData: {
      sm: o.count ? (o.sumInputPct / o.count).toFixed(1) : 0,
      kit: o.count ? (o.sumIssuedPct / o.count).toFixed(1) : 0,
      stock: o.totalStock,
      coverage: o.count ? Math.round(o.sumDays / o.count) : 0,
      input: o.totalInput
      },
      overallTrend: [],
      tableData: o.items
      };
      subnode.overallTrend = o.count ? [subnode.kpiData.sm - 5, subnode.kpiData.sm - 2, subnode.kpiData.sm, subnode.kpiData.sm + 2, subnode.kpiData.sm - 1, subnode.kpiData.sm + 1, subnode.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill[ocnName] = subnode;

      // Create item-level children nodes for color-wise drilldown
      Object.keys(byItem).forEach(itemName => {
      const byColor = {};
      o.items.filter(it => (it.itemOnly || 'Unknown') === itemName).forEach(it => {
      const c = it.colorOnly || 'Unknown';
      if (!byColor[c]) byColor[c] = 0;
      byColor[c] += it.stock || 0;
      });
      const itemKey = `${ocnName}||${itemName}`;
      let itemNode = {
      title: `ALL CC > ${bName} > ${shortOcn} > ${itemName}`,
      labels: Object.keys(byColor),
      data: Object.keys(byColor).map(k => byColor[k]),
      kpiData: {
      sm: subnode.kpiData.sm,
      kit: subnode.kpiData.kit,
      stock: Object.values(byColor).reduce((s,v)=>s+v,0),
      coverage: subnode.kpiData.coverage,
      input: subnode.kpiData.input
      },
      overallTrend: subnode.overallTrend,
      tableData: o.items.filter(it => (it.itemOnly || 'Unknown') === itemName)
      };
      drill[itemKey] = itemNode;
      });
      });
      });

      return drill;
      }

      // Fetch data from API
      function fetchData(type = "Last Week", fromDate = "", toDate = "") {
      $("#loadSpinner").show();
      $.ajax({
      url: '/smstockdetail',
      method: 'GET',
      data: {
      type: type,
      fromdate: fromDate,
      enddate: toDate
      },
      success: function(response) {
      $("#loadSpinner").hide();
      if (response && response.success && response.units && Array.isArray(response.units)) {
      apiData = response.units;
      } else {
      apiData = [];
      }
      BUYER_DRILL = buildDrillData(apiData);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      updateBuyerDrill('root');
      },
      error: function() {
      $("#loadSpinner").hide();
      apiData = [];
      BUYER_DRILL = buildDrillData([]);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      updateBuyerDrill('root');
      }
      });
      }

      // Overall trend chart
      const overallCtx = document.getElementById('overallTrend').getContext('2d');
      const grad = overallCtx.createLinearGradient(0,0,0,240);
      grad.addColorStop(0,'rgba(14,78,162,0.12)');
      grad.addColorStop(1,'rgba(14,78,162,0.02)');
      const overallChart = new Chart(overallCtx, {
      type:'line',
      data: {
      labels:['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
      datasets:[{
      data:[85,88,95,90,92,102,100],
      borderColor:'#0e4ea2',
      backgroundColor:grad,
      fill:true,
      tension:0.4,
      borderWidth:2,
      pointRadius:0,
      pointHoverRadius:8,
      pointBackgroundColor:'#0e4ea2',
      pointBorderColor:'#ffffff',
      pointBorderWidth:2,
      pointHoverBackgroundColor:'#0e4ea2',
      pointHoverBorderColor:'#ffffff',
      pointHoverBorderWidth:3
      }]
      },
      options:{
      responsive:true, maintainAspectRatio:false,
      plugins:{
      legend:{display:false},
      tooltip:{
      enabled:true,
      mode:'index',
      intersect:false,
      backgroundColor:'rgba(0,0,0,0.8)',
      titleColor:'#ffffff',
      bodyColor:'#ffffff',
      borderColor:'#0e4ea2',
      borderWidth:1,
      cornerRadius:6,
      displayColors:false,
      callbacks:{
      title:function(context){
      return '📊 ' + (context[0]?.label || '');
      },
      label:function(context){
      return 'Value: ' + (context.parsed.y || 0);
      }
      }
      }
      },
      interaction:{
      intersect:false,
      mode:'index'
      },
      hover:{
      mode:'index',
      intersect:false
      },
      scales:{
      x:{ grid:{ display:false }, ticks:{ color:'#6b7280' } },
      y:{ grid:{ color:'rgba(15,59,102,0.06)' }, ticks:{ color:'#6b7280' }, suggestedMin:0, suggestedMax:120 }
      }
      }
      });

      // Buyer bar chart
      const buyerCtx = document.getElementById('buyerBars').getContext('2d');
      const buyerChart = new Chart(buyerCtx, {
      type:'bar',
      data: {
      labels:[],
      datasets:[{ data:[], backgroundColor:'#08325b', borderRadius:4, barThickness:15 }]
      },
      options:{
      indexAxis:'y',
      responsive:true, maintainAspectRatio:false,
      plugins:{legend:{display:false}},
      scales:{
      x:{
      display: true,
      grid: { color: '#e5e7eb' },
      border: { color: '#e5e7eb' },
      ticks: {
      color: '#64748b',
      callback: function(value) {
      // Format numbers with commas; no percent since we now show Stock
      return value.toLocaleString();
      }
      }
      },
      y:{
      ticks:{ color:'#374151', font:{ weight:600 } },
      categoryPercentage: 0.6,
      barPercentage: 0.7
      }
      }
      }
      });

      // Update buyer drill
      function updateBuyerDrill(key) {
      const node = BUYER_DRILL[key];
      if (!node) {
      buyerChart.data.labels = [];
      buyerChart.data.datasets[0].data = [];
      buyerChart.update();
      tableData = [];
      if (stockTable) {
      stockTable.clear().rows.add([]).draw();
      }
      $('#sm-avail').text('0%');
      $('#kit-avail').text('0%');
      $('#stock-qty').text('0');
      $('#coverage-days').text('0 days');
      $('#input-today').text('0');
      $('#sm-trend').text('—').removeClass('text-green-600 text-red-600');
      $('#kit-trend').text('—').removeClass('text-green-600 text-red-600');
      $('#stock-trend').text('—').removeClass('text-green-600 text-red-600');
      $('#coverage-trend').text('—').removeClass('text-green-600 text-red-600');
      $('#input-trend').text('—').removeClass('text-green-600 text-red-600');
      overallChart.data.datasets[0].data = [0, 0, 0, 0, 0, 0, 0];
      overallChart.update();
      return;
      }

      // Sort bars by value descending so higher quantities appear on top
      const pairs = (node.labels || []).map((label, idx) => ({ label: label, value: (node.data || [])[idx] || 0 }));
      pairs.sort((a, b) => b.value - a.value);
      const sortedLabels = pairs.map(p => p.label);
      const sortedData = pairs.map(p => p.value);
      buyerChart.data.labels = sortedLabels;
      buyerChart.data.datasets[0].data = sortedData;

      // Highlight selected bar for this key (used at color/item terminal drill)
      const highlightLabel = (selectedFilter && selectedFilter.key === key) ? selectedFilter.label : null;
      const navy = '#08325b';
      const pale = '#cbd5e1';
      buyerChart.data.datasets[0].backgroundColor = sortedLabels.map(l => {
      if (!highlightLabel) return navy; // no selection => all navy
      return (l === highlightLabel) ? pale : navy; // selected pale, others navy
      });
      buyerChart.update();

      // Recalculate KPIs if a selection is active at this level
      let tableScope = node.tableData || [];
      if (highlightLabel) {
      if (key.includes('||')) {
      tableScope = tableScope.filter(r => (r.colorOnly || 'Unknown') === highlightLabel);
      } else if (key.includes('OCN')) {
      tableScope = tableScope.filter(r => (r.itemOnly || 'Unknown') === highlightLabel);
      } else if (ocnMap[highlightLabel]) {
      const full = ocnMap[highlightLabel];
      tableScope = tableScope.filter(r => (r.fullOcn || '') === full);
      }
      }

      const sum = (arr, f) => arr.reduce((s, x) => s + (f(x) || 0), 0);
      const count = tableScope.length || 0;
      const sm = count ? (sum(tableScope, x => parseFloat(x.inputPct)) / count).toFixed(1) : (parseFloat(node.kpiData.sm) || 0);
      const kit = count ? (sum(tableScope, x => parseFloat(x.issuedPct)) / count).toFixed(1) : (parseFloat(node.kpiData.kit) || 0);
      const stock = count ? sum(tableScope, x => parseInt(x.stock)) : (parseInt(node.kpiData.stock) || 0);
      const coverage = count ? Math.round(sum(tableScope, x => parseInt(x.days)) / count) : (parseInt(node.kpiData.coverage) || 0);
      const input = count ? sum(tableScope, x => parseInt(x.issued)) : (parseInt(node.kpiData.issued) || 0);

      $('#sm-avail').text(`${sm}%`);
      $('#kit-avail').text(`${kit}%`);
      $('#stock-qty').text(stock.toLocaleString());
      $('#coverage-days').text(`${coverage} days`);
      $('#input-today').text(input.toLocaleString());

      $('#sm-trend').text(sm >= 90 ? '▲ 5.3% vs yesterday' : sm > 0 ? '▼ 1.2% vs yesterday' : '—').toggleClass('text-green-600', sm >= 90).toggleClass('text-red-600', sm < 90 && sm > 0);
      $('#kit-trend').text(kit >= 85 ? '▲ 2.1% vs yesterday' : kit > 0 ? '▼ 1.3% vs yesterday' : '—').toggleClass('text-green-600', kit >= 85).toggleClass('text-red-600', kit < 85 && kit > 0);
      $('#stock-trend').text(stock >= 4500 ? '▲ 3.5% vs yesterday' : stock > 0 ? '▼ 8.2% vs yesterday' : '—').toggleClass('text-green-600', stock >= 4500).toggleClass('text-red-600', stock < 4500 && stock > 0);
      $('#coverage-trend').text(coverage >= 5 ? '▲ 1.5% vs yesterday' : coverage > 0 ? '▼ 0.5% vs yesterday' : '—').toggleClass('text-green-600', coverage >= 5).toggleClass('text-red-600', coverage < 5 && coverage > 0);
      $('#input-trend').text(input >= 700 ? '▲ 0.6% vs yesterday' : input > 0 ? '▼ 0.4% vs yesterday' : '—').toggleClass('text-green-600', input >= 700).toggleClass('text-red-600', input < 700 && input > 0);

      createSpark('k1', [sm-2, sm-1, sm, sm+1, sm], sm >= 90 ? '#10b981' : '#ef4444');
      createSpark('k2', [kit-2, kit-1, kit, kit+1, kit], kit >= 85 ? '#10b981' : '#ef4444');
      createSpark('k3', [stock-100, stock-50, stock, stock+50, stock], stock >= 4500 ? '#10b981' : '#ef4444');
      createSpark('k4', [coverage-1, coverage-0.5, coverage, coverage+0.5, coverage], coverage >= 5 ? '#10b981' : '#ef4444');
      createSpark('k5', [input-10, input-5, input, input+5, input], input >= 700 ? '#10b981' : '#ef4444');

      const trendBase = parseFloat(sm) || 0;
      const derivedTrend = [trendBase-5, trendBase-2, trendBase, trendBase+2, trendBase-1, trendBase+1, trendBase];
      overallChart.data.datasets[0].data = (count ? derivedTrend : (node.overallTrend || [0, 0, 0, 0, 0, 0, 0]));
      overallChart.update();

      tableData = tableScope;
      if (stockTable) {
      stockTable.clear().rows.add(tableData).draw();
      }
      }

      function drillToBuyer(name) {
      if (buyerDrillPath.length < 4 && BUYER_DRILL[name]) {
      buyerDrillPath.push(name);
      setBuyerCrumb();
      updateBuyerDrill(name);
      }
      }

      // Set breadcrumb
      function setBuyerCrumb() {
      const names = buyerDrillPath.map(k => {
      if (k === 'root') return 'All CC';
      if (ocnMap[k]) return k.slice(-4);
      if (k.includes('||')) return k.split('||')[1];
      return k;
      });
      // If a color is selected at the terminal level, append it to breadcrumb
      const currentKey = buyerDrillPath[buyerDrillPath.length - 1];
      if (selectedFilter && selectedFilter.key === currentKey && selectedFilter.label) {
      names.push(selectedFilter.label);
      }
      const html = names.map((n, idx) => `<span class="drill-link ${idx"
        < names.length - 1 ? 'text-blue-600 cursor-pointer' : ''}" data-idx="${idx}">${n}</span>`).join(' <span class="text-slate-400">›</span> ');
      $('#buyerCrumb').html(html);
      }

      // Update dashboard based on KPI selection
      function updateDashboard(kpiKey) {
      currentKpi = kpiKey;
      let filteredData = apiData.map(unit => ({
      Unit: unit.Unit || 'Unknown',
      buyers: unit.buyers?.map(buyer => ({
      Buyer: buyer.Buyer || 'Unknown',
      data: buyer.data?.filter(item => {
      const inputPct = parseFloat(item.Sm_Rcvd_Perc) || 0;
      const issuedPct = parseFloat(item.Iss_Perc) || 0;
      const stock = parseInt(item.Stock) || 0;
      const input = parseInt(item.SM_Rcvd) || 0;
      const issued = parseInt(item.Iss_Qty) || 0;
      const days = input > 0 ? stock / input : 0;
      if (kpiKey === 'sm') return inputPct > 0;
      if (kpiKey === 'kit') return issuedPct > 0;
      if (kpiKey === 'stock') return stock > 0;
      if (kpiKey === 'coverage') return days > 0;
      if (kpiKey === 'input') return input > 0;
      return true;
      }) || []
      })).filter(buyer => buyer.data.length > 0) || []
      })).filter(unit => unit.buyers.length > 0);
      BUYER_DRILL = buildDrillData(filteredData);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      updateBuyerDrill('root');
      }

      // Initialize
      $(document).ready(function(){
      // Initialize DataTable
      stockTable = $('#stockTable').DataTable({
      data: [],
      language: {
      lengthMenu: 'Show _MENU_ rows',
      search: ''
      },
      columns: [
      {
      data: 'ocn',
      render: function(data, type, row) {
      return `<div class="font-medium" title="${row.desc}">${data}</div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      { data: 'size', className: 'py-3 px-3 align-top' },
      { data: 'stock', className: 'py-3 px-3 align-top font-medium' },
      { data: 'days', className: 'py-3 px-3 align-top' },
      { data: 'input', className: 'py-3 px-3 align-top' },
      {
      data: 'inputPct',
      render: function(data) {
      const pct = Math.max(0, Math.min(parseFloat(data) || 0, 100));
      return `<div class="flex items-center gap-2">
        <div class="progress-track w-36 inline-block mr-1">
          <span class="progress-fill" style="width:${pct}%; background:#08325b; display:block;"></span>
        </div>
        <span class="text-xs text-slate-600 font-medium">${pct}%</span>
      </div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      {
      data: null,
      render: function(data, type, row, meta) {
      return `<canvas class="trend-mini" id="inputTrend_${meta.row}"></canvas>`;
      },
      className: 'py-3 px-3 align-top',
      orderable: false
      },
      { data: 'issued', className: 'py-3 px-3 align-top font-medium' },
      {
      data: 'issuedPct',
      render: function(data) {
      const pct = Math.max(0, Math.min(parseFloat(data) || 0, 100));
      return `<div class="flex items-center gap-2">
        <div class="progress-track w-36 inline-block mr-1">
          <span class="progress-fill" style="width:${pct}%; background:#08325b; display:block;"></span>
        </div>
        <span class="text-xs text-slate-600 font-medium">${pct}%</span>
      </div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      {
      data: null,
      render: function(data, type, row, meta) {
      const params = new URLSearchParams({
      order_no: row.fullOcn || '',
      itemid: row.itemId || '',
      colorid: row.colorId || '',
      sizeid: row.sizeId || '',
      buyer: row.buyer || '',
      item: row.itemOnly || '',
      color: row.colorOnly || ''
      }).toString();
      const href = `/issued?${params}`;
      return `<a href="${href}" title="View issued trend">
        <canvas class="trend-mini" id="issuedTrend_${meta.row}"></canvas>
      </a>`;
      },
      className: 'py-3 px-3 align-top',
      orderable: false
      }
      ],
      rowCallback: function(row, data) {
      if (data.lowStock) {
      $(row).addClass('low-stock');
      }
      },
      drawCallback: function() {
      const api = this.api();
      api.rows({page: 'current'}).every(function(rowIdx) {
      const rowData = this.data();
      setTimeout(() => {
      createSpark(`inputTrend_${rowIdx}`, rowData.inputTrend, '#ef4444');
      createSpark(`issuedTrend_${rowIdx}`, rowData.issuedTrend, '#10b981');
      }, 50);
      });
      },
      pageLength: 10,
      lengthMenu: [10, 25, 50, 100],
      searching: true,
      ordering: true,
      info: true,
      paging: true
      });

      // Make stock table header sticky when page length > 10
      stockTable.on('length.dt', function(e, settings, len) {
      const container = document.getElementById('stockTableContainer');
      const thead = document.querySelector('#stockTable thead');
      if (!container || !thead) return;
      if (len > 10) {
      container.style.maxHeight = '520px';
      container.style.overflowY = 'auto';
      thead.style.position = 'sticky';
      thead.style.top = '0';
      thead.style.zIndex = '10';
      thead.style.background = '#ffffff';
      } else {
      container.style.maxHeight = '';
      container.style.overflowY = '';
      thead.style.position = '';
      thead.style.top = '';
      thead.style.zIndex = '';
      thead.style.background = '';
      }
      });

      $('#kpi1').on('click', () => updateDashboard('sm'));
      $('#kpi2').on('click', () => updateDashboard('kit'));
      $('#kpi3').on('click', () => updateDashboard('stock'));
      $('#kpi4').on('click', () => updateDashboard('coverage'));
      $('#kpi5').on('click', () => updateDashboard('input'));

      $('#buyerBars').on('click', function(evt) {
      const points = buyerChart.getElementsAtEventForMode(evt, 'nearest', { intersect: true }, false);
      if (points.length > 0 && typeof points[0].index === 'number' && buyerChart.data.labels[points[0].index]) {
      const labelClicked = buyerChart.data.labels[points[0].index];
      let name = labelClicked;
      const currentKey = buyerDrillPath[buyerDrillPath.length - 1];

      if (currentKey.includes('||')) {
      // Terminal (color-wise) level: toggle selection and recalc
      if (selectedFilter && selectedFilter.key === currentKey && selectedFilter.label === labelClicked) {
      selectedFilter = null;
      } else {
      selectedFilter = { key: currentKey, label: labelClicked };
      }
      updateBuyerDrill(currentKey);
      setBuyerCrumb();
      return;
      }

      if (ocnMap[name]) name = ocnMap[name];
      if (BUYER_DRILL[currentKey] && currentKey.includes('OCN')) {
      const compositeKey = `${currentKey}||${name}`;
      if (BUYER_DRILL[compositeKey]) name = compositeKey;
      }
      selectedFilter = null; // clear when drilling deeper
      drillToBuyer(name);
      }
      });

      $('#buyerCrumb').on('click', '.drill-link', function(){
      const idx = parseInt($(this).data('idx'));
      if (idx === buyerDrillPath.length - 1) return;
      buyerDrillPath = buyerDrillPath.slice(0, idx + 1);
      setBuyerCrumb();
      const key = buyerDrillPath[buyerDrillPath.length - 1];
      updateBuyerDrill(key);
      });

      setBuyerCrumb();

      $('#dateRangePicker').daterangepicker({
      opens: 'left',
      startDate: moment().subtract(6, 'days'),
      endDate: moment(),
      maxDate: moment(), // Restrict dates beyond today
      ranges: {
      'Today': [moment(), moment()],
      'Last Week': [moment().subtract(6, 'days'), moment()], // Changed from This Week
      'This Month': [moment().startOf('month'), moment().endOf('month')]
      },
      locale: {
      format: 'DD-MM-YY'
      }
      }, function(start, end, label) {
      const startFormatted = start.format('YYYY-MM-DD');
      const endFormatted = end.format('YYYY-MM-DD');
      const displayStartFormatted = start.format('DD-MM-YY');
      const displayEndFormatted = end.format('DD-MM-YY');
      selectedRangeLabel = label;
      const isSameDay = start.isSame(end, 'day');

      const titleText = `
      Supermarket Stock Analysis for -
      <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
        SOCKS
      </span>
      <span class="ml-4" style="color: #fff; font-weight: 500;">
        ${startFormatted} - ${endFormatted}
      </span>
      `;

      $('.dashboard_title').html(titleText); // ✅ Use .html() instead of .text()

      $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
      buyerDrillPath = ['root'];
      currentKpi = null;
      fetchData(selectedRangeLabel, startFormatted, endFormatted);
      });

      const initialStart = moment();
      const initialEnd = moment();
      const initialStartFormatted = initialStart.format('YYYY-MM-DD');
      const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
      const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
      const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
      const isSameDay = initialStart.isSame(initialEnd, 'day');

      $('.dashboard_title').html(`
      Supermarket Stock Analysis for
      <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
        SOCKS
      </span>
      <span class="ml-4" style="color: #fff; font-weight: 500;">
        ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}
      </span>
        `);

        $('#dateRangePicker').val(initialStartFormatted);
        fetchData('Today', initialStartFormatted, initialEndFormatted);
        });

        $('#HistoricalButton').hide();

      </script>
  </body>
</html>