<?php





use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\MerchandiserController;
use App\Http\Controllers\MicroplanningController;
use App\Http\Controllers\OperationController;
use App\Http\Controllers\LifeAtGainup\Merchandiser\ChartController;
use App\Http\Controllers\LifeAtGainup\Merchandiser\ProductionController;
use App\Http\Controllers\LifeAtGainup\Merchandiser\GUTProductionController;
use App\Http\Controllers\LifeAtGainup\Merchandiser\SocksProductionController;
use App\Http\Controllers\LifeAtGainup\Merchandiser\RawMaterialController;

use Illuminate\Support\Facades\DB;

use App\Http\Controllers\LineplannerController;








Route::get('/', function () {
    return view('react');
});

// Logout route to support navbar link using route('logout')
Route::get('/logout', function () {
    try {
        Auth::logout();
    } catch (\Throwable $e) {
        // ignore
    }
    Session::flush();
    return redirect('/');
})->name('logout');
//MERCHANDISER PORTAL
Route::get('/merchandiserdashboard', [MerchandiserController::class, 'merchandiserdashboard'])
    ->name('merchandiserdashboard');

   

Route::post('/merchandiserdashboard', [MerchandiserController::class, 'ingest'])
    ->name('merchandiserdashboard.ingest');
// Route::get('/merchandiserorder', [MerchandiserController::class, 'merchandiserorder']);
Route::get('/merchandiserorder', [MerchandiserController::class, 'merchandiserorder'])->name('merchandiserorder');
Route::get('/merchandiserorderbeta', [MerchandiserController::class, 'merchandiserorderbeta'])->name('merchandiserorderbeta');
Route::get('/merchandiserorder_new', [MerchandiserController::class, 'merchandiserorder_new'])->name('merchandiserorder_new');
Route::get('/merchandiserorder_beta_new', [MerchandiserController::class, 'merchandiserorder_beta_new'])->name('merchandiserorder_beta_new');
Route::get('/merchandiserorder_portal', [MerchandiserController::class, 'merchandiserorder_portal'])->name('merchandiserorder_portal');
Route::get('/getOcnByBuyer', [MerchandiserController::class, 'getOcnByBuyer'])->name('getOcnByBuyer');
Route::get('/alertinfo', [MerchandiserController::class, 'alertinfo'])->name('alertinfo');
Route::get('/merchlayout', [MerchandiserController::class, 'merchlayout'])->name('merchlayout');
Route::get('/budgetstatus', [MerchandiserController::class, 'budgetstatus'])->name('budgetstatus');
Route::get('/sizebreakup', [MerchandiserController::class, 'sizebreakup'])->name('sizebreakup');
Route::get('/productstatus', [MerchandiserController::class, 'productstatus'])->name('productstatus');
Route::get('/rawmaterialstatus', [MerchandiserController::class, 'rawmaterialstatus'])->name('rawmaterialstatus');
Route::get('/timetoaction', [MerchandiserController::class, 'timetoaction'])->name('timetoaction');
Route::get('/userlogmerch', [MerchandiserController::class, 'userlogmerch_opt'])->name('userlogmerch');
Route::get('/mddashboard', [MerchandiserController::class, 'mddashboard'])->name('mddashboard');
Route::get('/Process_Po_Summary_Proc', [MerchandiserController::class, 'Process_Po_Summary_Proc'])->name('Process_Po_Summary_Proc');
Route::get('/Process_Po_Detail_Proc', [MerchandiserController::class, 'Process_Po_Detail_Proc'])->name('Process_Po_Detail_Proc');

Route::get('test_DB', [MerchandiserController::class, 'test_DB'])->name('test_DB'); 

Route::get('test_db_merch', [MerchandiserController::class, 'test_db_merch'])->name('test_db_merch');

Route::get('/buyerpostatussummary', [MerchandiserController::class, 'buyerpostatussummary'])->name('buyerpostatussummary');
Route::get('/cutpendingdetails', [MerchandiserController::class, 'cutpendingdetails'])->name('cutpendingdetails');
Route::get('/ocn_cutpendingdetails', [MerchandiserController::class, 'ocn_cutpendingdetails'])->name('ocn_cutpendingdetails');
Route::get('/rollcheckdetails', [MerchandiserController::class, 'rollcheckdetails'])->name('rollcheckdetails');
Route::get('/fabricrolldetails', [MerchandiserController::class, 'fabricrolldetails'])->name('fabricrolldetails');

Route::get('/Process_Po_Summary_Proc_new', [MerchandiserController::class, 'Process_Po_Summary_Proc_new'])->name('Process_Po_Summary_Proc_new');
Route::get('/Process_Po_Detail_Proc_new', [MerchandiserController::class, 'Process_Po_Detail_Proc_new'])->name('Process_Po_Detail_Proc_new');
Route::get('/buyerpostatus', [MerchandiserController::class, 'buyerpostatus'])->name('buyerpostatus');
Route::get('/buyerpostatussummary', [MerchandiserController::class, 'buyerpostatussummary'])->name('buyerpostatussummary');
Route::get('/sizewisepobreakup', [MerchandiserController::class, 'sizewisepobreakup'])->name('sizewisepobreakup');
Route::get('/ooptcommonsearch_portal', [MerchandiserController::class, 'ooptcommonsearch_portal'])->name('ooptcommonsearch_portal');
Route::get('/merchlistreport', [MerchandiserController::class, 'merchlistreport'])->name('merchlistreport');
Route::get('/viewreportitem', [MerchandiserController::class, 'viewreportitem'])->name('viewreportitem');
Route::post('/updatefilterdata', [MerchandiserController::class, 'updatefilterdata'])->name('updatefilterdata');
Route::post('/alertinfo_store', [MerchandiserController::class, 'alertinfo_store'])->name('alertinfo_store');
Route::get('/endlinepresentation', [MerchandiserController::class, 'endlinepresentation'])->name('endlinepresentation');

#region operation
Route::get('/operationlist', [OperationController::class, 'operationlist'])->name('operationlist');
Route::get('/operationdashboard', [OperationController::class, 'operationdashboard'])->name('operationdashboard');
Route::get('/operation_dashboard_beta', [OperationController::class, 'operation_dashboard_beta'])->name('operation_dashboard_beta');
Route::get('/TodayOperationDash', [OperationController::class, 'TodayOperationDash'])->name('TodayOperationDash');
Route::get('/datewiseproduction', [OperationController::class, 'datewiseproduction'])->name('datewiseproduction');
Route::get('/operationreport', [OperationController::class, 'operationreport'])->name('operationreport');
Route::get('/operationreporttmins', [OperationController::class, 'operationreporttmins'])->name('operationreporttmins');
Route::get('/operationreportqty', [OperationController::class, 'operationreportqty'])->name('operationreportqty');
Route::get('/operationreportowe', [OperationController::class, 'operationreportowe'])->name('operationreportowe');
Route::get('/operationcutting', [OperationController::class, 'operationcutting'])->name('operationcutting');
Route::get('/operationpacking', [OperationController::class, 'operationpacking'])->name('operationpacking');
Route::get('/buyerorderstatus', [OperationController::class, 'buyerorderstatus'])->name('buyerorderstatus');
Route::get('/wipdetails', [OperationController::class, 'wipdetails'])->name('wipdetails');

Route::get('/todayreport', [OperationController::class, 'todayreport'])->name('todayreport');
Route::get('/userlogmerch_opt', [OperationController::class, 'userlogmerch_opt'])->name('userlogmerch_opt');
Route::get('/productionfilter', [OperationController::class, 'productionfilter'])->name('productionfilter');

//Personalised filter Setting
Route::get('/operationlist1', [OperationController::class, 'operationlist1'])->name('operationlist1');
Route::post('/filtersetting', [OperationController::class, 'filtersetting'])->name('filtersetting');
Route::get('/followdetails', [OperationController::class, 'followdetails'])->name('followdetails');
Route::post('/operation-feedback', [OperationController::class, 'feedbackstore'])->name('operation-feedback');
Route::get('/operationlistreport', [OperationController::class, 'operationlistreport'])->name('operationlistreport');
Route::get('/deletereportitem', [OperationController::class, 'deletereportitem'])->name('deletereportitem');
Route::get('/optcommonsearch', [OperationController::class, 'optcommonsearch'])->name('optcommonsearch');
Route::get('/checkingdashboard', [CheckingController::class, 'dashboard'])->name('checking-dashboard');
Route::get('/Presentationquality', [CheckingController::class, 'Presentationquality'])->name('quality.Presentationquality');
Route::get('/Endlinequality', [CheckingController::class, 'Endlinequality'])->name('quality.Endlinequality');
Route::get('/rejectiondata', [CheckingController::class, 'rejectiondata'])->name('quality.RejectionData');

// FILE UPLOAD & VIEW - BY SURYA ON 26-12-2024
Route::post('/operationListFileAttach', [OperationController::class, 'submitFile'])->name('operationListFileAttach');
Route::post('/viewfile', [OperationController::class, 'viewFile'])->name('fileView');
Route::post('/clear-cache', [OperationController::class, 'clearCaches'])->name('clear.cache');



Route::get('microplan', [MicroplanningController::class, 'microplan'])->name('microplan');
Route::get('unitdata', [MicroplanningController::class, 'unitdata'])->name('unitdata');
Route::get('microplaningfilter', [MicroplanningController::class, 'microplaningfilter'])->name('microplaningfilter');
Route::post('insertOrUpdateMicroPlan', [MicroplanningController::class, 'insertOrUpdateMicroPlan']);
Route::post('deleteMicroPlanSingle', [MicroplanningController::class, 'deleteMicroPlanSingle']);
Route::post('updateTailorQuantity', [MicroplanningController::class, 'updateTailorQuantity'])->name('updateTailorQuantity');
Route::get('/ordersummary', [MicroplanningController::class, 'ordersummary'])->name('ordersummary');
Route::get('ocnlineplan', [MicroplanningController::class, 'ocnlineplan'])->name('ocnlineplan');
Route::get('/machinedetails', [MicroplanningController::class, 'machinedetails'])->name('machinedetails');
Route::get('ocnItemlineplan', [MicroplanningController::class, 'ocnItemlineplan'])->name('ocnItemlineplan');
Route::get('allocnsearch', [MicroplanningController::class, 'allocnsearch'])->name('allocnsearch');
Route::get('plannedvsactual', [MicroplanningController::class, 'plannedvsactual'])->name('plannedvsactual');
Route::get('plandelete', [MicroplanningController::class, 'plandelete'])->name('plandelete');
Route::post('planlogoutUpdate', [MicroplanningController::class, 'planlogoutUpdate']);
Route::get('/check-session', function () {
    return response()->json([
        'active' => Session::has('empl_id')
    ]);
});


#region Production
Route::get('/production_gar_dashboard', [ProductionController::class, 'production_gar_dashboard'])->name('production_gar_dashboard');
Route::get('/history_dashboard', [ProductionController::class, 'history_dashboard'])->name('history_dashboard');
Route::get('/history_dashboard/{portal}', [ProductionController::class, 'history_dashboard_portal'])->name('history_dashboard_portal');
Route::get('/production_gar_dashboard_beta', [ProductionController::class, 'production_gar_dashboard_beta'])->name('production_gar_dashboard_beta');
Route::get('/dailysnapshot', [ProductionController::class, 'dailysnapshot'])->name('dailysnapshot');
Route::get('/cutting_output', [ProductionController::class, 'cutting_output'])->name('cutting_output');
Route::get('/linestop_analysis', [ProductionController::class, 'linestop_analysis'])->name('linestop_analysis');
Route::get('/linestopminis', [ProductionController::class, 'linestopminis'])->name('linestopminis');
Route::get('/cuttingreport', [ProductionController::class, 'cuttingreport'])->name('cuttingreport');
Route::get('/sizr-breakup-cutting', [ProductionController::class, 'sizeBreakupCutting'])->name('sizeBreakupCutting');
Route::get('/wip', [ProductionController::class, 'wip'])->name('wip');
Route::get('/smstock', [ProductionController::class, 'smstock'])->name('smstock');
Route::get('/directlabour', [ProductionController::class, 'directlabour'])->name('directlabour');
Route::get('/wipdetail', [ProductionController::class, 'wipdetail'])->name('wipdetail');
Route::get('/smstockdetail', [ProductionController::class, 'smstockdetail'])->name('smstockdetail');
Route::get('/directlabour_details', [ProductionController::class, 'directlabour_details'])->name('directlabour_details');
Route::get('/get-ack-breakdown', [ProductionController::class, 'getAckBreakdown']);
Route::get('/issued', [ProductionController::class, 'issued'])->name('issued');
Route::get('/smstockissued', [ProductionController::class, 'smstockissued'])->name('smstockissued');
Route::get('/sizerollbreakup', [ProductionController::class, 'sizerollbreakup'])->name('sizerollbreakup');
Route::get('/production_minis_historicaldata', [ProductionController::class, 'production_minis_historicaldata'])->name('production_minis_historicaldata');
Route::get('/productionhistoricaldata', [ProductionController::class, 'productionhistoricaldata'])->name('productionhistoricaldata');
Route::get('/production_cutting_historicaldata', [ProductionController::class, 'production_cutting_historicaldata'])->name('production_cutting_historicaldata');


#region GUT Production
Route::get('/production_gut_dashboard/{portal}', [GUTProductionController::class, 'production_gut_dashboard'])->name('production_gut_dashboard');
Route::get('/gut_linestop_analysis/{portal}', [GUTProductionController::class, 'gut_linestop_analysis'])->name('gut_linestop_analysis');
Route::get('/gut_direct_labour/{portal}', [GUTProductionController::class, 'gut_direct_labour'])->name('gut_direct_labour');
Route::get('/gut_dailysnapshot', [GUTProductionController::class, 'gut_dailysnapshot'])->name('gut_dailysnapshot');
Route::get('/gut_linestopminis', [GUTProductionController::class, 'gut_linestopminis'])->name('gut_linestopminis');
Route::get('/gut_cutting_output/{portal}', [GUTProductionController::class, 'gut_cutting_output'])->name('gut_cutting_output');
Route::get('/gut_cuttingreport', [GUTProductionController::class, 'gut_cuttingreport'])->name('gut_cuttingreport');
Route::get('/gut-sizerollbreakup', [GUTProductionController::class, 'gut_sizerollbreakup'])->name('gut_sizerollbreakup');
Route::get('/gut-sizr-breakup-cutting', [GUTProductionController::class, 'gut_sizeBreakupCutting'])->name('gut_sizeBreakupCutting');
Route::get('/gut_directlabour_details', [GUTProductionController::class, 'gut_directlabour_details'])->name('gut_directlabour_details');
Route::get('/gut_getackbreakdown', [GUTProductionController::class, 'gut_getAckBreakdown']);
Route::get('/gut_sizerollbreakup', [GUTProductionController::class, 'gut_sizerollbreakup'])->name('gut_sizerollbreakup');
Route::get('/gut_sizrbreakupcutting', [GUTProductionController::class, 'gut_sizeBreakupCutting'])->name('gut_sizeBreakupCutting');
Route::get('/gut-get-ack-breakdown', [GUTProductionController::class, 'gut_getAckBreakdown']);
Route::get('/gut_smstock/{portal}', [GUTProductionController::class, 'gut_smstock'])->name('gut_smstock');
Route::get('/gut_smstockdetail', [GUTProductionController::class, 'gut_smstockdetail'])->name('gut_smstockdetail');
Route::get('/gut_wip/{portal}', [GUTProductionController::class, 'gut_wip'])->name('gut_wip');
Route::get('/gut_issued/{portal}', [GUTProductionController::class, 'gut_issued'])->name('gut_issued');
Route::get('/gutsmstockissued', [GUTProductionController::class, 'gutsmstockissued'])->name('gutsmstockissued');
Route::get('/gut_wipdetail', [GUTProductionController::class, 'gut_wipdetail'])->name('gut_wipdetail');
Route::get('/gut_history_dashboard/{portal}', [GUTProductionController::class, 'gut_history_dashboard'])->name('gut_history_dashboard');
Route::get('/gutproduction_minis_historicaldata/{portal}', [GUTProductionController::class, 'gutproduction_minis_historicaldata'])->name('gutproduction_minis_historicaldata');
Route::get('/gutproductionhistoricaldata/{portal}', [GUTProductionController::class, 'gutproductionhistoricaldata'])->name('gutproductionhistoricaldata');
Route::get('/gutproduction_cutting_historicaldata/{portal}', [GUTProductionController::class, 'gutproduction_cutting_historicaldata'])->name('gutproduction_cutting_historicaldata');

#region socks_production
Route::get('/production_socks_dashboard', [SocksProductionController::class, 'production_socks_dashboard'])->name('production_socks_dashboard');
Route::get('/socksdailysnapshot', [SocksProductionController::class, 'socksdailysnapshot'])->name('socksdailysnapshot');
Route::get('/sockslinestopminis', [SocksProductionController::class, 'sockslinestopminis'])->name('sockslinestopminis');
Route::get('/socks_linestop_analysis', [SocksProductionController::class, 'socks_linestop_analysis'])->name('socks_linestop_analysis');


Route::get('/lineplan', [LineplannerController::class, 'index'])->name('lineplan');
Route::get('/lineplanreport', [LineplannerController::class, 'getLinePlanData'])->name('lineplan.data');
Route::get('/lineplanpolist', [LineplannerController::class, 'getBuyerList']);



#region rawmaterial
Route::get('/raw_material_dashboard', [RawMaterialController::class, 'raw_material_dashboard'])->name('raw_material_dashboard');
Route::get('/buyer_ocn_details', [RawmaterialController::class, 'buyer_ocn_details'])->name('buyer_ocn_details');
Route::get('/rawmaterial', [RawmaterialController::class, 'index'])->name('lineplan');
Route::get('/materialpostatus', [RawMaterialController::class, 'materialpostatus'])->name('materialpostatus');
Route::get('/materialgrnstatus', [RawMaterialController::class, 'materialgrnstatus'])->name('materialgrnstatus');
Route::get('/fabric_process_details', [RawMaterialController::class, 'fabric_process_details'])->name('fabric_process_details');
Route::get('/fabric_sub_details', [RawMaterialController::class, 'fabric_sub_details'])->name('fabric_sub_details');
Route::get('/raw_material_commit_history', [RawMaterialController::class, 'raw_material_commit_history'])->name('raw_material_commit_history');
Route::post('/savecommitment', [RawMaterialController::class, 'savecommitment'])->name('savecommitment');

Route::get('/return-to-supply', [RawMaterialController::class, 'returnsupplierstatus'])->name('returnsupplierstatus');