<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lineplanner</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600&display=swap" rel="stylesheet">
    <style>
        .table-container {
            display: flex;
            max-width: 100%;
        }
        .fixed-columns {
            flex: 0 0 auto;
        }
        .scrollable-columns {
            flex: 1;
            overflow-x: auto;
        }
        table {
            background-color: #f8f9fa;
            border-collapse: separate;
            border-spacing: 0;
            margin-bottom: 0;
        }
        .fixed-columns table {
            width: 775px;
        }
        .scrollable-columns table {
            min-width: 850px;
        }
        th, td {
            border: 1px solid #dee2e6;
            padding: 8px;
            text-align: left;
            vertical-align: middle;
            font-size: 12px;
        }
        th {
            background-color: #e9ecef;
            font-weight: bold;
        }
        .date-cell {
            background-color: #fff3cd;
        }
        tr {
            height: 40px;
        }
        .fixed-columns {
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
        }
        #fixedTable, #scrollableTable {
            border-collapse: collapse;
        }
        #fixedTable th, #fixedTable td,
        #scrollableTable th, #scrollableTable td {
            border: 1px solid #000 !important;
            padding: 8px;
        }
        #scrollableTableHead th {
            min-width: 60px;
            height: 40px;
        }
        .search-container {
            display: flex;
            align-items: center;
            margin-left: 20px;
        }
        .search-input {
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            padding: 0.375rem 0.75rem;
            font-size: 1rem;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
        }
        .search-input:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        .me-3 {
            margin-right: 1rem !important;
        }
        .search-icon {
            cursor: pointer;
            font-size: 1.2rem;
            margin-left: 10px;
        }
        .search-input {
            display: none;
            width: 200px;
            margin-left: 10px;
        }
        .search-input.active {
            display: inline-block;
        }
        #searchIcon:hover {
            color: #007bff;
            transform: scale(1.1);
            transition: all 0.2s ease-in-out;
        }
        .fixed-columns {
            max-height: 600px;
            overflow-y: auto;
            position: relative;
        }
        .scrollable-columns {
            max-height: 600px;
            overflow-y: auto;
            position: relative;
        }
        #fixedTable thead th,
        #scrollableTable thead th {
            position: sticky;
            top: 0;
            background: #e9ecef;
            z-index: 2;
        }
        #fixedTable tfoot, #scrollableTable tfoot {
            position: sticky;
            bottom: 0;
            background: #e9ecef;
            z-index: 2;
        }
        #fixedTable tfoot td, #scrollableTable tfoot td {
            font-weight: bold;
            border: 1px solid #000 !important;
            padding: 8px;
        }
        .fixed-columns,
        .scrollable-columns {
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        .fixed-columns::-webkit-scrollbar,
        .scrollable-columns::-webkit-scrollbar {
            display: none;
        }
        .navbar .btn-sm {
            padding: 0.45rem 0.6rem;
            font-size: 1.25rem;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
        <div class="container-fluid">
            <a class="navbar-brand ms-1" href="#" style="font-family: 'Poppins', sans-serif; font-weight:600; font-size:1.5rem; color:#0d6efd;">
                Lineplanning
            </a>
            <div class="home-bar">
                <a href="/dashboard" class="btn btn-light btn-sm ms-1" title="Dashboard">
                    <i class="bi bi-house-fill"></i>
                </a>
            </div>
            <div class="mac-bar">
                <a href="/cap_plan" target="_blank" class="btn btn-light btn-sm ms-1" title="Macroplan">
                    <i class="bi bi-calendar-fill"></i>
                </a>
            </div>
            <div class="Micro-bar ms-1">
                <a href="/microplan" class="btn btn-light btn-sm" title="Microplan">
                    <i class="bi bi-calendar2-range-fill"></i>
                </a>
            </div>
            <form class="d-flex ms-auto" id="filterForm">
                <div class="d-flex justify-content-end align-items-center me-2 d-none" id="loadingIndicator">
                    <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
                </div>
                <select class="form-select me-2" id="unitFilter" style="width: 200px;">
                    <!-- Options will be populated dynamically -->
                </select>
                <input type="date" class="form-control me-2" id="startDate">
                <input type="date" class="form-control me-2" id="endDate">
            </form>
        </div>
    </nav>

    <div class="container-xxl mt-4" style="max-width: 95%;">
        <div class="card shadow">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <h5 class="mb-0 ms-0" style="font-family: 'Poppins', sans-serif;">Line Planning Details</h5>
                    <div id="selectedInfo" class="ms-1" style="font-family: 'Poppins', sans-serif; font-size: 1rem; font-weight: bold; color: #fff;">
                        On <span id="selectedUnit"></span> _ 
                        <span id="selectedStartDate"></span> - 
                        <span id="selectedEndDate"></span>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <div class="dropdown me-3">
                        <i class="fa-solid fa-download" id="downloadIcon" style="cursor:pointer; margin-left: 20px;" data-bs-toggle="dropdown" aria-expanded="false"></i>
                        <ul class="dropdown-menu" aria-labelledby="downloadIcon">
                            <li><a class="dropdown-item d-none" href="#" id="downloadPDF">.PDF</a></li>
                            <li><a class="dropdown-item" href="#" id="downloadXLSX">.XLSX</a></li>
                        </ul>
                    </div>
                    <div class="search-container d-flex align-items-center">
                        <i class="bi bi-box-seam me-2" style="font-size: 1.2rem;"></i>
                        <input type="text" class="form-control search-input me-3" id="ocnSearch" placeholder="Search OCN" style="width: 200px; display: inline;">
                        <i class="bi bi-people me-2" style="font-size: 1.2rem;"></i>
                        <select class="form-select" id="buyerFilter" style="width: 200px; display: inline;">
                            <option value="">Select Buyer</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-container">
                    <div class="fixed-columns">
                        <table class="table table-bordered mb-0" id="fixedTable" style="width: 810px !important;">
                            <thead class="thead-light">
                                <tr>
                                    <th>LINE_NO</th>
                                    <th class="unit-column">Unit</th>
                                    <th>BUYER</th>
                                    <th>OCN</th>
                                    <th>ITEM</th>
                                    <th>COLOR</th>
                                    <th>SAM</th>
                                    <th>Operators</th>
                                    <th>Target Eff %</th>
                                    <th>Target/Day</th>
                                    <th>Total Planned</th>
                                </tr>
                            </thead>
                            <tbody id="fixedTableBody">
                                <!-- Data will be populated here -->
                            </tbody>
                                <tfoot id="fixedTableFoot">
                                    <tr>
                                        <td class="text-end fw-bold fixedFooterColspan">Planned_qty_Total</td>
                                        <td id="fixedTotalPlanned"></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end fw-bold fixedFooterColspan">Planned_min_Total</td>
                                        <td id="fixedTotalmins"></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end fw-bold fixedFooterColspan">Planned_manpower_Total</td>
                                        <td id="fixedTotalmanpower"></td>
                                    </tr>
                                </tfoot>
                        </table>
                    </div>
                    <div class="scrollable-columns">
                        <table class="table table-bordered mb-0" id="scrollableTable">
                            <thead class="thead-light" id="scrollableTableHead">
                                <tr>
                                    <!-- Date columns will be populated here -->
                                </tr>
                            </thead>
                            <tbody id="scrollableTableBody">
                                <!-- Data will be populated here -->
                            </tbody>
                            <tfoot id="scrollableTableFoot">
                                <tr id="scrollableTotalPlannedRow">
                                    <!-- Totals for planned quantities will be populated here -->
                                </tr>
                                <tr id="scrollableTotalMinsRow">
                                    <!-- Totals for planned minutes will be populated here -->
                                </tr>
                                <tr id="scrollableTotalManpowerRow">
                                    <!-- Totals for planned manpower will be populated here -->
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/xlsx-js-style@1.2.0/dist/xlsx.min.js"></script>
    <script>
      // Store original data and options for filtering
        let originalData = [];
        let originalDates = [];
        let buyerOptions = [];

        // Controller function to fetch and render data
        function loadLinePlanData(unitCode, fromDate, toDate) {
            const apiUrl = "/lineplanreport";
            $('#loadingIndicator').removeClass('d-none');
            $.ajax({
                url: apiUrl,
                method: 'GET',
                data: {
                    unit_code: unitCode,
                    from_date: fromDate,
                    to_date: toDate
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.data) {
                        originalData = response.data;
                        originalDates = response.dates;
                        renderTables(originalData, originalDates);
                        loadBuyerOptions(); // Populate buyer dropdown after fetching data
                    } else {
                        console.error('No data found or API error');
                        $('#fixedTableBody').html('<tr><td colspan="10">No data available</td></tr>');
                        $('#scrollableTableBody').html('<tr><td>No data available</td></tr>');
                    }
                    $('#loadingIndicator').addClass('d-none');

                    if (unitCode === 'null') {
                        $('#fixedTable .unit-column').removeClass('d-none');
                        $('.fixedFooterColspan').attr('colspan', 10);
                    } else {
                        $('#fixedTable .unit-column').addClass('d-none');
                        $('.fixedFooterColspan').attr('colspan', 9);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('API request failed:', error);
                    $('#fixedTableBody').html('<tr><td colspan="10">Error fetching data</td></tr>');
                    $('#scrollableTableBody').html('<tr><td>Error fetching data</td></tr>');
                    $('#loadingIndicator').addClass('d-none');
                    $('#fixedTotalPlanned').text('0');
                    $('#scrollableTableFoot').empty();
                }
            });
        }

        const newLineNoMap = {
             "31": "A1",
            "32": "A2",
            "33": "A3",
            "34": "A4",
            "35": "A5",
            "36": "A6",
            "37": "C4",
            "38": "C5",
            "39": "C6",
            "40": "C1",
            "41": "C2",
            "42": "C3",
            "43": "B1",
            "44": "B2",
            "45": "B3",
            "46": "B4",
            "47": "B5",
            "48": "B6",
            "51": "D1",
            "52": "D2",
            "53": "D3",
            "54": "D4",
            "55": "D5",
            "56": "D6"
        };

        function populateFactoryDropdown() {
            $.ajax({
                url: '/unitdata',
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    if (response.success && Array.isArray(response.data)) {
                        const $unitFilter = $('#unitFilter');
                        $unitFilter.empty();
                        $unitFilter.append('<option value="null">All Unit</option>');
                        response.data.forEach(unit => {
                            $unitFilter.append(
                                `<option value="${unit.Unit_Code}">${unit.Unit}</option>`
                            );
                        });
                        // Optionally, set default selected (e.g., G-II)
                        $unitFilter.val('3').trigger('change');
                    } else {
                        console.error('No unit data found');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Failed to load unit data:', error);
                }
            });
        }

        // Function to populate buyer dropdown with unique buyers from originalData
        function loadBuyerOptions() {
            const buyerFilter = $('#buyerFilter');
            buyerFilter.empty();
            buyerFilter.append('<option value="">Select Buyer</option>');

            if (originalData && originalData.length > 0) {
                const uniqueBuyers = [...new Set(originalData.map(item => item.Buyer).filter(buyer => buyer && buyer !== 'null'))];
                buyerOptions = uniqueBuyers;
                buyerOptions.forEach(buyer => {
                    buyerFilter.append(`<option value="${buyer}">${buyer}</option>`);
                });
            } else {
                console.error('No buyer data available');
                buyerFilter.append('<option value="">No buyers available</option>');
            }
        }

        // Function to render data into tables
function renderTables(data, dates) {
    const fixedTableBody = $('#fixedTableBody');
    const scrollableTableHead = $('#scrollableTableHead tr');
    const scrollableTableBody = $('#scrollableTableBody');
    const fixedTotalPlanned = $('#fixedTotalPlanned');
    const fixedTotalMins = $('#fixedTotalmins');
    const fixedTotalManpower = $('#fixedTotalmanpower');
    const scrollableTotalPlannedRow = $('#scrollableTotalPlannedRow');
    const scrollableTotalMinsRow = $('#scrollableTotalMinsRow');
    const scrollableTotalManpowerRow = $('#scrollableTotalManpowerRow');

    // Clear existing content
    fixedTableBody.empty();
    scrollableTableHead.empty();
    scrollableTableBody.empty();
    fixedTotalPlanned.empty();
    fixedTotalMins.empty();
    fixedTotalManpower.empty();
    scrollableTotalPlannedRow.empty();
    scrollableTotalMinsRow.empty();
    scrollableTotalManpowerRow.empty();

    // Ensure dates is an array
    const safeDates = Array.isArray(dates) ? dates : [];
    if (safeDates.length === 0) {
        scrollableTableHead.append('<th>No dates available</th>');
    } else {
        safeDates.forEach(date => {
            scrollableTableHead.append(`<th>${date}</th>`);
        });
    }

    // Map date display values to their corresponding keys
    const dateKeys = data.length > 0 ? Object.keys(data[0]).filter(key => key.match(/^\d{4}-\d{2}-\d{2}$/)) : [];

    // Filter out dummy/empty records
    const effectiveData = data.filter(record => record && record.Line_No && record.Line_No !== '');

    // Calculate totals using effective data
    let totalPlanned = 0;
    let totalMins = 0;
    let totalManpower = 0;
    const dateTotals = {};
    const dateMinsTotals = {};
    const dateManpowerTotals = {};
    dateKeys.forEach(key => {
        dateTotals[key] = 0;
        dateMinsTotals[key] = 0;
        dateManpowerTotals[key] = 0;
    });

    for (let i = 0; i < effectiveData.length; i++) {
        const record = effectiveData[i];
        const planned = parseFloat(record.Total_Planned) || 0;
        const sam = parseFloat(record.Sam) || 0;
        const manpower = parseFloat(record.No_Of_Opr) || 0;
        totalPlanned += planned;
        totalMins += planned * sam;
        totalManpower += manpower;
        dateKeys.forEach(key => {
            const qty = parseFloat(record[key]) || 0;
            dateTotals[key] += qty;
            dateMinsTotals[key] += qty * sam;
            if (qty !== 0 && manpower > 0) {
                dateManpowerTotals[key] += manpower;
            }
        });
    }

    // Populate fixed table footers
    fixedTotalPlanned.text(Math.floor(totalPlanned).toLocaleString("en-IN"));
    fixedTotalMins.text(Math.floor(totalMins).toLocaleString("en-IN"));
    fixedTotalManpower.text(Math.floor(totalManpower).toLocaleString("en-IN"));

    // Populate scrollable table footers
    // scrollableTotalPlannedRow.append('<td class="fw-bold text-end">Total plan qty</td>');
    // scrollableTotalMinsRow.append('<td class="fw-bold text-end">Planned Mins</td>');
    // scrollableTotalManpowerRow.append('<td class="fw-bold text-end">Planned Manpower</td>');
    dateKeys.forEach(key => {
        scrollableTotalPlannedRow.append(`<td class="date-cell">${Math.floor(dateTotals[key])}</td>`);
        scrollableTotalMinsRow.append(`<td class="date-cell">${Math.floor(dateMinsTotals[key])}</td>`);
        scrollableTotalManpowerRow.append(`<td class="date-cell">${Math.floor(dateManpowerTotals[key])}</td>`);
    });

    // Merge consecutive Line_No cells
    let i = 0;
    while (i < effectiveData.length) {
        const currentLineNo = effectiveData[i].Line_No;
        let rowspanCount = 1;

        for (let j = i + 1; j < effectiveData.length; j++) {
            if (effectiveData[j].Line_No === currentLineNo) {
                rowspanCount++;
            } else break;
        }

        // Calculate group totals
        let groupTotalPlanned = 0;
        const groupDateTotals = {};
        dateKeys.forEach(key => groupDateTotals[key] = 0);

        for (let m = 0; m < rowspanCount; m++) {
            const rec = effectiveData[i + m];
            groupTotalPlanned += parseFloat(rec.Total_Planned) || 0;
            dateKeys.forEach(key => {
                groupDateTotals[key] += parseFloat(rec[key]) || 0;
            });
        }

        for (let k = 0; k < rowspanCount; k++) {
            const record = effectiveData[i + k];

            let fixedRow = `<tr>`;
            if (k === 0) {
                fixedRow += `<td rowspan="${rowspanCount + 3}">${record.Line_Name || record.Line_No || ''}</td>`;
            }
            fixedRow += `
                <td class="unit-column${$('#unitFilter').val() === 'null' ? '' : ' d-none'}">${record.Unit || ''}</td>
                <td>${record.Buyer || 'null'}</td> 
                <td>${record.Ocn_No ? record.Ocn_No.slice(-5) : ''}</td>
                <td title="${record.Item}">
                ${record.Item && record.Item.length > 6 
                    ? record.Item.substring(0, 6) + '..' 
                    : record.Item || ''}
                </td>
                <td>${record.Color || ''}</td>
                <td>${record.Sam || ''}</td>
                <td>${record.No_Of_Opr || ''}</td>
                <td>${record.Targ_Eff || ''}</td>
                <td>${record.Targ_Qty || ''}</td>
                <td style="width:100px">${record.Total_Planned || ''}</td>
            </tr>`;
            fixedTableBody.append(fixedRow);

            // Build scrollable row (dates)
            const scrollableRow = $(`<tr></tr>`);
            dateKeys.forEach(key => {
                scrollableRow.append(`<td class="date-cell">${record[key] || ''}</td>`);
            });
            scrollableTableBody.append(scrollableRow);
        }

        // Total Plan Qty row for group
        let totalPlanQty = 0;
        for (let m = 0; m < rowspanCount; m++) {
            totalPlanQty += parseFloat(effectiveData[i + m].Total_Planned) || 0;
        }
        const colspanValue = $('#unitFilter').val() === 'null' ? 9 : 8;
        fixedTableBody.append(`<tr class="table-info"><td colspan="${colspanValue}" class="fw-bold text-end">Total plan qty</td><td>${Math.floor(totalPlanQty)}</td></tr>`);
        const totalPlanRow = $(`<tr class="table-info"></tr>`);
        dateKeys.forEach(key => {
            let dateTotal = 0;
            for (let m = 0; m < rowspanCount; m++) {
                dateTotal += parseFloat(effectiveData[i + m][key]) || 0;
            }
            totalPlanRow.append(`<td class="date-cell">${Math.floor(dateTotal)}</td>`);
        });
        scrollableTableBody.append(totalPlanRow);

        // Planned Mins row for group
        let totalSam = 0;
        let totalPlannedGroup = 0;
        for (let m = 0; m < rowspanCount; m++) {
            totalSam += parseFloat(effectiveData[i + m].Sam) || 0;
            totalPlannedGroup += parseFloat(effectiveData[i + m].Total_Planned) || 0;
        }
        const plannedMins = Math.floor(totalSam * totalPlannedGroup);
        fixedTableBody.append(`<tr class="table-info"><td colspan="${colspanValue}" class="fw-bold text-end">Planned Mins</td><td>${plannedMins}</td></tr>`);
        const plannedMinsRow = $(`<tr class="table-info"></tr>`);
        dateKeys.forEach(key => {
            let effectiveSam = 0;
            let dateTotal = 0;
            for (let m = 0; m < rowspanCount; m++) {
                let rowDateTotal = parseFloat(effectiveData[i + m][key]) || 0;
                let rowSam = parseFloat(effectiveData[i + m].Sam) || 0;
                if (rowDateTotal !== 0) effectiveSam += rowSam;
                dateTotal += rowDateTotal;
            }
            plannedMinsRow.append(`<td class="date-cell">${Math.floor(effectiveSam * dateTotal)}</td>`);
        });
        scrollableTableBody.append(plannedMinsRow);

        // Planned Manpower row for group
        let totalNoOfOpr = 0;
        const manpowerDateTotals = {};
        dateKeys.forEach(key => manpowerDateTotals[key] = 0);

        for (let m = 0; m < rowspanCount; m++) {
            const rec = effectiveData[i + m];
            const noOfOpr = parseFloat(rec.No_Of_Opr) || 0;
            totalNoOfOpr += noOfOpr;
            dateKeys.forEach(key => {
                const dateValue = parseFloat(rec[key]) || 0;
                if (dateValue !== 0 && noOfOpr > 0) {
                    manpowerDateTotals[key] += noOfOpr;
                }
            });
        }

        fixedTableBody.append(`<tr class="table-info"><td colspan="${colspanValue}" class="fw-bold text-end">Planned Manpower</td><td>${Math.floor(totalNoOfOpr)}</td></tr>`);
        const plannedManpowerRow = $(`<tr class="table-info"></tr>`);
        dateKeys.forEach(key => {
            plannedManpowerRow.append(`<td class="date-cell">${Math.floor(manpowerDateTotals[key])}</td>`);
        });
        scrollableTableBody.append(plannedManpowerRow);

        i += rowspanCount;
    }

    if (effectiveData.length === 0) {
        const colspanValue = $('#unitFilter').val() === 'null' ? 10 : 9;
        fixedTableBody.append(`<tr><td colspan="${colspanValue}">No data available</td></tr>`);
        scrollableTableBody.append('<tr><td>No data available</td></tr>');
        scrollableTotalPlannedRow.append('<td colspan="' + (dateKeys.length + 1) + '">No data available</td>');
        scrollableTotalMinsRow.append('<td colspan="' + (dateKeys.length + 1) + '"></td>');
        scrollableTotalManpowerRow.append('<td colspan="' + (dateKeys.length + 1) + '"></td>');
    }
}

        function toggleUnitColumn(show) {
            $('.unit-column').toggleClass('d-none', !show);
            $('.unitcol').removeClass('d-none');
            const footerColspanValue = show ? 10 : 9;
            const tableInfoColspanValue = show ? 9 : 8;
            $('.fixedFooterColspan').attr('colspan', footerColspanValue);
            $('.table-info td:contains("Total plan qty")').attr('colspan', tableInfoColspanValue);
            $('.table-info td:contains("Planned Mins")').attr('colspan', tableInfoColspanValue);
            $('.table-info td:contains("Planned Manpower")').attr('colspan', tableInfoColspanValue);
            $('#ocnSearch').val(''); // Clear OCN search
            $('#buyerFilter').val(''); // Reset
        }

            $('#buyerFilter').on('change', function() {
                $('#ocnSearch').val(''); // Clear OCN search
            });

         

        function formatDate(dateStr) {
            const parts = dateStr.split("-");
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        }

        // Function to update the selected info text
        function updateSelectedInfo() {
            const unitFilter = $('#unitFilter');
            const startDate = $('#startDate');
            const endDate = $('#endDate');
            const selectedUnit = unitFilter.find('option:selected').text() || 'N/A';
            const selectedStart = startDate.val() || 'N/A';
            const selectedEnd = endDate.val() || 'N/A';

            $('#selectedUnit').text(selectedUnit);
            $('#selectedStartDate').text(formatDate(selectedStart));
            $('#selectedEndDate').text(formatDate(selectedEnd));
        }

        // Update info on page load and handle unit column visibility
        $(document).ready(function() {
            // Set default values for startDate and endDate
            const today = new Date().toISOString().split('T')[0];
            const endDate = new Date();
            endDate.setMonth(endDate.getMonth() + 1);
            const endDateFormatted = endDate.toISOString().split('T')[0];

            $('#startDate').val(today);
            $('#endDate').val(endDateFormatted);

            updateSelectedInfo();
            toggleUnitColumn($('#unitFilter').val() === 'null');

            // Update info, load data, and toggle unit column when filter form changes
            $('#filterForm').on('change', 'select, input', function() {
                updateSelectedInfo();
                const unitCode = $('#unitFilter').val() || '3';
                const fromDate = $('#startDate').val() || today;
                const toDate = $('#endDate').val() || '2025-09-29';
                toggleUnitColumn(unitCode === 'null');
                loadLinePlanData(unitCode, fromDate, toDate);
            });

            // Initial load with default values
            loadLinePlanData('3', today, endDateFormatted);
            populateFactoryDropdown();
        });

        // Function to filter data by OCN
        function filterByOCN(ocn) {
            if (!ocn) {
                filterByBuyer($('#buyerFilter').val());
                return;
            }
            const filteredData = originalData.filter(record => 
                record.Ocn_No && record.Ocn_No.slice(-5).toLowerCase().includes(ocn.toLowerCase())
            );
            filterByBuyer($('#buyerFilter').val(), filteredData);
        }

        // Function to filter data by Buyer
        function filterByBuyer(buyer, data = originalData) {
            if (!buyer) {
                renderTables(data, originalDates);
                return;
            }
            const filteredData = data.filter(record => 
                record.Buyer && record.Buyer.toLowerCase() === buyer.toLowerCase()
            );
            renderTables(filteredData, originalDates);
        }

        // Handle OCN search input
        $('#ocnSearch').on('input', function() {
            const ocn = $(this).val().trim();
            filterByOCN(ocn);
        });

        // Handle Buyer dropdown change
        $('#buyerFilter').on('change', function() {
            const buyer = $(this).val();
            filterByBuyer(buyer);
        });

        // Sync vertical scrolling between fixed and scrollable tables
        $(document).ready(function() {
            const fixedColumns = $('.fixed-columns');
            const scrollableColumns = $('.scrollable-columns');

            fixedColumns.on('scroll', function() {
                scrollableColumns.scrollTop(fixedColumns.scrollTop());
            });

            scrollableColumns.on('scroll', function() {
                fixedColumns.scrollTop(scrollableColumns.scrollTop());
            });
        });

        $(document).ready(function() {
            $('#downloadPDF').on('click', function(e) {
                e.preventDefault();
                downloadPDF();
            });

            $('#downloadXLSX').on('click', function(e) {
                e.preventDefault();
                downloadXLSX();
            });

            function generateUnifiedTable() {
                const fixedHeadTr = $('#fixedTable thead tr').clone();
                const scrollableHeadTr = $('#scrollableTableHead tr').clone();
                const scrollableThs = scrollableHeadTr.find('th').toArray().reverse();
                const scrollableColCount = scrollableHeadTr.find('th').length;
                const lastFixedTh = fixedHeadTr.find('th:last');
                scrollableThs.forEach(function(th) {
                    lastFixedTh.after($(th).clone());
                });
                // If a specific unit is selected, drop 'Unit' header from the fixed header clone
                const isAllUnit = ($('#unitFilter').val() === 'null');
                if (!isAllUnit) {
                    fixedHeadTr.find('th.unit-column, th:contains("Unit")').first().remove();
                }

                const unifiedTable = $('<table class="table table-bordered mb-0" id="unifiedTable"></table>');
                unifiedTable.append($('<thead></thead>').append(fixedHeadTr));

                const fixedBodyRows = $('#fixedTable tbody tr').toArray();
                const fixedFootRows = $('#fixedTable tfoot tr').toArray();
                const scrollBodyInfoRows = $('#scrollableTableBody tr.table-info').toArray();
                const scrollBodyNormalRows = $('#scrollableTableBody tr:not(.table-info)').toArray();
                const scrollFootRows = $('#scrollableTableFoot tr').toArray();

                let normalIdx = 0;
                let infoIdx = 0;

                // Pair tbody rows by type to ensure summary rows align correctly
                fixedBodyRows.forEach(function(row){
                    const $fixedRow = $(row).clone();
                    if (!isAllUnit) {
                        $fixedRow.find('td.unit-column').first().remove();
                    }
                    const isInfo = $fixedRow.hasClass('table-info');
                    const $scrollableRow = isInfo
                        ? $(scrollBodyInfoRows[infoIdx++] || '<tr></tr>').clone()
                        : $(scrollBodyNormalRows[normalIdx++] || '<tr></tr>').clone();

                    const scrollableCells = $scrollableRow
                        .find('td')
                        .toArray()
                        .slice(-scrollableColCount);
                    const lastFixedCell = $fixedRow.find('td:last, th:last');
                    scrollableCells.slice().reverse().forEach(function(td) {
                        lastFixedCell.after($(td).clone());
                    });

                    $fixedRow.addClass($scrollableRow.attr('class') || '');
                    unifiedTable.append($fixedRow);
                });

                // Pair footer rows by index
                fixedFootRows.forEach(function(row, idx){
                    const $fixedRow = $(row).clone();
                    if (!isAllUnit) {
                        $fixedRow.find('td.unit-column').first().remove();
                    }
                    const $scrollableRow = $(scrollFootRows[idx] || '<tr></tr>').clone();
                    const scrollableCells = $scrollableRow
                        .find('td')
                        .toArray()
                        .slice(-scrollableColCount);
                    const lastFixedCell = $fixedRow.find('td:last, th:last');
                    scrollableCells.slice().reverse().forEach(function(td) {
                        lastFixedCell.after($(td).clone());
                    });
                    $fixedRow.addClass($scrollableRow.attr('class') || '');
                    unifiedTable.append($fixedRow);
                });

                const tempDiv = $('<div style="display: none;"></div>').appendTo('body');
                tempDiv.append(unifiedTable);

                // Normalize: ensure each row has the same number of cells as header (handles LINE_NO rowspan and colspans)
                const headerLen = unifiedTable.find('thead tr th').length;
                unifiedTable.find('tbody tr, tfoot tr').each(function(){
                    const $row = $(this);
                    let cellCount = $row.children('td,th').length;
                    if (cellCount < headerLen) {
                        const missing = headerLen - cellCount;
                        for (let i = 0; i < missing; i++) {
                            $row.prepend($('<td></td>'));
                        }
                    }
                });

                return '#unifiedTable';
            }

            function downloadPDF() {
                const unifiedSelector = generateUnifiedTable();
                const { jsPDF } = window.jspdf;
                const doc = new jsPDF('l', 'mm', 'a4');
                doc.text("Line Planner Details", 14, 10);
                doc.autoTable({
                    html: unifiedSelector,
                    startY: 15,
                    theme: 'grid',
                    styles: {
                        overflow: 'linebreak',
                        cellWidth: 'wrap',
                        fontSize: 7,
                        halign: 'center',
                        valign: 'middle'
                    },
                    headStyles: { fillColor: [73, 109, 232] },
                    columnStyles: {
                        0: { cellWidth: 15 },
                        1: { cellWidth: 20 },
                        2: { cellWidth: 30 },
                        3: { cellWidth: 20 },
                        4: { cellWidth: 15 },
                        5: { cellWidth: 15 },
                        6: { cellWidth: 20 },
                        7: { cellWidth: 15 },
                        8: { cellWidth: 20 }
                    },
                    margin: { top: 15, left: 5, right: 5, bottom: 5 },
                    didDrawPage: function(data) {
                        const pageCount = doc.internal.getNumberOfPages();
                        doc.text(`Page ${data.pageNumber} of ${pageCount}`, 14, doc.internal.pageSize.height - 10);
                    }
                });
                const selectedUnit = $('#unitFilter').find('option:selected').text() || 'Lineplanning';
                doc.save(`${selectedUnit} Lineplanning.pdf`);
                $(unifiedSelector).closest('div').remove();
            }

            function downloadXLSX() {
                const unifiedSelector = generateUnifiedTable();
                const table = document.getElementById('unifiedTable');
                const ws = XLSX.utils.table_to_sheet(table);
                let data = XLSX.utils.sheet_to_json(ws, { header: 1 });

                // If a specific unit is selected (not 'All Unit'), drop the 'Unit' column from export
                const isAllUnit = ($('#unitFilter').val() === 'null');
                if (!isAllUnit && data && data.length > 0) {
                    const header = data[0] || [];
                    const unitColIdx = header.indexOf('Unit');
                    if (unitColIdx !== -1) {
                        data = data.map(row => row.filter((_, idx) => idx !== unitColIdx));
                    }
                }

                const styledData = data.map(row =>
                    row.map(cell => ({
                        v: cell,
                        s: {
                            border: {
                                top: { style: "thin", color: { rgb: "000000" } },
                                bottom: { style: "thin", color: { rgb: "000000" } },
                                left: { style: "thin", color: { rgb: "000000" } },
                                right: { style: "thin", color: { rgb: "000000" } }
                            },
                            alignment: { horizontal: "center", vertical: "center" }
                        }
                    }))
                );

                const newWs = XLSX.utils.aoa_to_sheet(styledData);
                newWs['!cols'] = Array.from({ length: 20 }, () => ({ wch: 12 }));

                const wb = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(wb, newWs, "Line Planner");
                const selectedUnit = $('#unitFilter').find('option:selected').text() || 'Lineplanning';
                XLSX.writeFile(wb, `${selectedUnit} Lineplanning.xlsx`);
                $(unifiedSelector).closest('div').remove();
            }

            $.getScript('https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js', function() {
                $.getScript('https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.23/jspdf.plugin.autotable.min.js', function() {
                    $.getScript('https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js', function() {
                        console.log('Libraries loaded');
                    });
                });
            });
        });
    </script>
</body>
</html><?php /**PATH C:\Apache24\htdocs\erpportal\resources\views/lineplanner.blade.php ENDPATH**/ ?>