<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Raw Material Management Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
   
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }
        .card-header {
            background-color: #4052B6;
            height: 60px;
            padding: 20px;
        }
        .notification-icon {
            position: relative;
        }
        .notification-icon::after {
            content: '5';
            position: absolute;
            top: 0;
            right: 0;
            width: 16px;
            height: 16px;
            background-color: #dc3545;
            border-radius: 50%;
            border: 1px solid red;
            transform: translate(50%, -50%);
            color: white;
            font-size: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        .notification-dropdown {
            display: none;
            position: absolute;
            top: 60px;
            right: 0;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            min-width: 250px;
            z-index: 1000;
        }
        .notification-dropdown.show {
            display: block;
        }
        .notification-dropdown::before {
            content: '';
            position: absolute;
            top: -10px;
            right: 15px;
            border-left: 10px solid transparent;
            border-right: 10px solid transparent;
            border-bottom: 10px solid white;
        }
        .notification-item:last-child {
            border-bottom: none;
        }
        .notification-item:first-child {
            border-top: #333;
        }
        .notification-item i {
            font-size: 16px;
            margin-right: 10px;
            color: #6c757d;
        }
        .notification-item .message {
            flex-grow: 1;
            font-size: 14px;
            color: #495057;
            font-weight: bold;
        }
        .notification-item .ocn {
            font-size: 12px;
            color: #4052B6;
        }
        .kpi-card, .data-table-card {
            background-color: #FFFFFF;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .metric-card {
            background-color: white;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-align: left;
            transition: background-color 0.3s;
        }
        .metric-card.active {
            background-color: #4052B6;
            color: white;
        }
        .metric-card.active .card-title,
        .metric-card.active .value,
        .metric-card.active .context,
        .metric-card.active .icon-text {
            color: white;
        }
        .card-title {
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px;
            color: black;
        }
        .value {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
            color: #4052B6;
        }
        .context {
            font-size: 12px;
            color: orangered;
            margin-bottom: 5px;
        }
        .icon-text {
            font-size: 12px;
            color: #6c757d;
            display: flex;
            align-items: center;
        }
        .icon-text i {
            margin-right: 15px;
            color: #6c757d;
        }
        .metric-card.active .icon-text,
        .metric-card.active .icon-text i {
            color: white;
        }
        .icon-text .chart-toggle {
            cursor: pointer;
        }
        .icon-text .chart-toggle.active {
            color: #4052B6;
        }
        .metric-card.active .icon-text .chart-toggle.active {
            color: white;
        }
        .chart-container {
            height: 350px;
        }
        .nav-tabs .nav-link {
            color: #333;
            border: none;
            border-bottom: 2px solid transparent;
            transition: all 0.3s;
        }
        .nav-tabs .nav-link:hover {
            border-bottom: 2px solid #4052B6;
        }
        .nav-tabs .nav-link.active {
            color: white;
            border-bottom: 2px solid white;
            background-color: #4052B6;
        }
        .table th {
            font-size: 12px;
            background-color: white;
            color: #333;
            font-weight: 600;
        }
        .table tbody tr:nth-child(odd) {
            background-color: #f8f9fa;
        }
        .table tbody tr:hover {
            color: white;
            background-color: #4052B6;
            cursor: pointer;
        }
        .btn-group .btn {
            background-color: #e9ecef;
            color: #495057;
            border: none;
            transition: background-color 0.3s, color 0.3s;
        }
        .btn-group .btn.active {
            background-color: #4052B6;
            color: white;
        }
        .status-bar {
            height: 4px;
            border-radius: 2px;
        }
        .status-bar.green {
            background-color: #28a745;
        }
        .status-bar.blue {
            background-color: #007bff;
        }
        .status-dot {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
       .status-dot.orange {
        background-color: #fd7e14; /* Orange */
        }
        .status-dot.red {
            background-color: #dc3545; /* Red */
        }
        .status-dot.green {
            background-color: #28a745; /* Green */
        }

        /* New */
        .status-dot.light-greenyellow {
            background-color: #adff2f; /* GreenYellow */
        }
        .status-dot.purple {
            background-color: #6f42c1; /* Bootstrap Purple */
        }
        .status-dot.lightgreen {
            background-color: #90ee90; /* LightGreen */
        }


        .status-dot.yellow {
            background-color: #ffc107; /* Bootstrap Yellow */
        }

      .status-legend {
            display: flex;
            gap: 5px;       /* spacing between items */
            align-items: center;
            font-size: 10px; /* adjust text size */
font-weight: bold;
        }
        .status-legend .status-dot {
            margin-right: 5px; /* space between dot and label */
        }
        .modal-content, #commitmentOffcanvas {
            background-color: #F2F8FD;
        }
        .dropdown-filter {
            margin-right: 15px;
        }
        #ocnFilter {
            display: none;
        }
        .spinner-border {
            width: 2rem;
            height: 2rem;
            border-width: 0.25em;
        }
        /* Filter button */
        .filter-toggle {
            background: none;
            border: none;
            cursor: pointer;
            padding: 2px;
            font-size: 14px;
            color: #444;
            transition: color 0.2s;
            position: relative;  /* 👈 makes z-index work */
            z-index: 100;
        }
        .filter-toggle:hover,
        .filter-toggle:focus {
            color: #007bff;
            outline: none;
        }
        /* Dropdown styling */
        .checkbox-dropdown-content {
            display: none;
            position: absolute;
            left: 5;
            z-index: 100;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 6px;
            box-shadow: 0 8px 12px rgba(0, 0, 0, 0.08);
            padding: 10px;
            min-width: 180px;
            max-height: 240px;
            overflow-y: auto;
        }
        .dropdown-filter.show .checkbox-dropdown-content {
            display: block;
        }
        .checkbox-dropdown-actions {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        .checkbox-dropdown-actions button {
            font-size: 12px;
            padding: 3px 8px;
            background-color: #f4f4f4;
            border: 1px solid #ccc;
            border-radius: 4px;
            cursor: pointer;
        }
        .checkbox-dropdown-actions button:hover {
            background-color: #e9e9e9;
        }
        .checkbox-options label {
            display: flex;
            align-items: center;
            margin-bottom: 6px;
            font-size: 13px;
            gap: 6px;
            cursor: pointer;
        }
        .checkbox-options input[type="checkbox"] {
            margin: 0;
            transform: scale(1.1);
        }
    </style>
</head>
<body style="background-color: #F2F8FD">
    <div class="container-fluid my-2">
        <div class="card col-12">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center text-white">
                    <i class="fa-regular fa-newspaper" style="font-size: 24px;"></i>
                    <h4 class="text-white mt-2" id="dashboard_title" style="margin-left: 15px;">Raw Material View for Garments</h4>
                </div>
                <div class="d-flex align-items-center text-white">
                    <div id="loadSpinner" class="spinner-border text-white me-3" style="display: none;" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>

                    <div class="home-bar">
                        <a href="/dashboard" class="btn btn-light ms-2" title="Dashboard">
                            <i class="fa-solid fa-house"></i>
                        </a>
                    </div>
                    <div class="mac-bar">
                        <a href="/clone_microplan" target="_blank" class="btn btn-light mx-2" title="Microplan">
                            <i class="fa-solid fa-chart-gantt"></i>
                        </a>
                    </div>

                    <select class="form-select dropdown-filter" id="buyerFilter" style="width: 200px; font-size: 12px">
                        <option value="">Select Buyer</option>
                    </select>
<div class="dropdown d-none" id="ocnDropdown" style="display: inline-block; width: 180px;">
                        <button class="form-select" type="button" id="ocnDropdownBtn" data-bs-toggle="dropdown" aria-expanded="false" style="width: 100%; font-size: 12px; text-align: left;">
                            <span id="ocnDropdownSelected">Select OCN</span>
                        </button>
                        <ul class="dropdown-menu p-2" aria-labelledby="ocnDropdownBtn" style="width: 100%; max-height: 250px; overflow-y: auto;">
                            <li>
                                <input type="text" class="form-control mb-2" id="ocnSearchInput" placeholder="Search OCN..." autocomplete="off" style="font-size: 12px;">
                            </li>
                            <div id="ocnDropdownList"></div>
                        </ul>
                    </div>
                    <i class="fa-regular fa-bell notification-icon ms-2" style="font-size: 24px; cursor: pointer" id="notificationBell"></i>
                    <div class="notification-dropdown" id="notificationDropdown">
                        <div class="card">
                            <h6 class="mt-3 ms-3 text-dark fw-bold bottom-bordered">Focus items (This week)</h6><hr>
                            <div class="card-body ms-3">
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">Yarn for string</span>
                                    <p class="ocn">OCN: 4233 (Yarn)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color: red"></i>
                                    <span class="message">Yarn for canvas</span>
                                    <p class="ocn">OCN: 5890 (Yarn)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">String fabric</span>
                                    <p class="ocn">OCN: 4233 (Fabric)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color: red"></i>
                                    <span class="message">Canvas fabric</span>
                                    <p class="ocn">OCN: 4334 (Fabric)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">Trim for string</span>
                                    <p class="ocn">OCN: 4233 (Sewing trims)</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body" style="background-color: #F2F8FD">
                <div class="container-fluid mt-0">
                    <div class="kpi-card">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card" style="cursor: pointer;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold PO-delay">PO-delay</h5>
                                                    <div class="context">Since last week</div>
                                                </div>
                                                <div class="value">80 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-clock"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Exceeding Target
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card" style="cursor: pointer;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">RM delay</h5>
                                                    <div class="context">Current Month</div>
                                                </div>
                                                <div class="value">15 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-truck me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Per of Delays
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card" style="cursor: pointer;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Est.CK Date</h5>
                                                    <div class="context">YTD Change</div>
                                                </div>
                                                <div class="value">6 days</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-dollar-sign me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Financial Impact
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card bg-secondary" style="pointer-events: none;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Lead Time Dev-NTD</h5>
                                                    <div class="context ">Current Avg</div>
                                                </div>
                                                <div class="value">3 days</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-wave-square me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                vs Planned
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card bg-secondary" style="pointer-events: none;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Commit. Slips-NTD</h5>
                                                    <div class="context ">Past Quarter</div>
                                                </div>
                                                <div class="value">12 slips</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-file-arrow-up me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Delivery Impact
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card" id="ret-supply" style="cursor: pointer;">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Ret. to Supplier</h5>
                                                    <div class="context">Last 30 Days</div>
                                                </div>
                                                <div class="value">2.5 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">
                                                <i class="fa-solid fa-reply me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Quality Issues
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 d-none kpi-trends-chart">
                            <div class="chart-container">
                                <canvas id="kpiChart"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="data-table-card">
<div class="status-legend my-1 bg-light border-rounded">
<span class="fw-bold">STATUS LEGEND : </span>
                            <span class="status-dot green"></span> <span>DONE</span> |
                            <span class="status-dot lightgreen"></span> <span>ON-TRACK</span> |
                            <span class="status-dot light-greenyellow"></span><span class="text-success" > PO </span>+ </span><span class="text-success" >CRITICAL PATH </span> |
                            <span class="status-dot yellow"></span><span class="text-success" > PO </span>+ </span><span class="text-danger" >CRITICAL PATH </span> |
                            <span class="status-dot orange"></span><span class="text-danger" > PO </span>+ </span><span class="text-danger" >CRITICAL PATH </span> |
                            <span class="status-dot red"></span> <span>RETURN TO SUPPLIER</span> |
                            <span class="status-dot purple"></span><span>DELAYED</span>
                        </div>
                        <div class="btn-group d-flex" role="group" aria-label="Material Tabs" id="materialTabs">
                            <button type="button" class="btn flex-fill active" id="yarn-tab" data-bs-toggle="tab" data-bs-target="#yarn" role="tab" data-tab="FABRIC" aria-controls="YARN" aria-selected="true">Yarn / Fabric</button>
                            <button type="button" class="btn flex-fill" id="fabric-tab" data-bs-toggle="tab" data-bs-target="#fabric" role="tab" data-tab="FABRIC" aria-controls="FABRIC" aria-selected="false">Fabric Process</button>
                            <button type="button" class="btn flex-fill" id="sewing-trims-tab" data-bs-toggle="tab" data-bs-target="#sewing-trims" role="tab" data-tab="Sewing Trims" aria-controls="Sewing Trims" aria-selected="false">Sewing Trims</button>
                            <button type="button" class="btn flex-fill" id="packing-trims-tab" data-bs-toggle="tab" data-bs-target="#packing-trims" role="tab" data-tab="Packing Trims" aria-controls="Packing Trims" aria-selected="false">Packing Trims</button>
                        </div>
                        <div class="tab-content" id="materialTabContent" style="font-size: 12px;">
                            <div class="tab-pane fade show active" id="yarn" role="tabpanel" aria-labelledby="yarn-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="yarnTable">
                                        <thead>
                                            <tr>
                                                <th>Item
                                                    <span class="dropdown-filter" data-table="yarnTable" data-column="0">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Color
                                                    <span class="dropdown-filter" data-table="yarnTable" data-column="1">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Size
                                                    <span class="dropdown-filter" data-table="yarnTable" data-column="2">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Uom</th>
<th>Req Qty</th>
                                                <th>PO Issued</th>
                                                <th>L. Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Com. Dt</th>                                          
                                                <th>Quality
                                                    <span class="d-none dropdown-filter" data-table="yarnTable" data-column="8">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Process Owner
                                                    <span class="d-none dropdown-filter" data-table="yarnTable" data-column="9">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Supplier
                                                    <span class="d-none dropdown-filter" data-table="yarnTable" data-column="10">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Status
                                                    <span class="d-none dropdown-filter" data-table="yarnTable" data-column="11">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="yarn-tbody"></tbody>
                                    </table>
<p class="text-danger">Note: Item in red font indicates "Spl Req"</p>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="fabric" role="tabpanel" aria-labelledby="fabric-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="fabricTable">
                                        <thead>
                                            <tr>
                                                <th>Item
                                                    <span class="dropdown-filter" data-table="fabricTable" data-column="0">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Color
                                                    <span class="dropdown-filter" data-table="fabricTable" data-column="1">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>BOM Qty</th>
                                                <th>Ontable Qty</th>
                                                <th>REC Qty</th>
                                                <th>REC %</th>
                                                <th>Comments</th>
                                                <th>Com. Dt</th>
                                            </tr>
                                        </thead>
                                        <tbody id="fabric-tbody"></tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="sewing-trims" role="tabpanel" aria-labelledby="sewing-trims-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="sewingTable">
                                        <thead>
                                            <tr>
                                                <th>Item
                                                    <span class="dropdown-filter" data-table="sewingTable" data-column="0">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Color
                                                    <span class="dropdown-filter" data-table="sewingTable" data-column="1">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Size
                                                    <span class="dropdown-filter" data-table="sewingTable" data-column="2">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Uom</th>
<th>Req Qty</th>
                                                <th>PO Issued</th>
                                                <th>L. Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Com. Dt</th>
                                                <th>Quality
                                                    <span class="d-none dropdown-filter" data-table="sewingTable" data-column="8">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Process Owner
                                                    <span class="d-none dropdown-filter" data-table="sewingTable" data-column="9">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Supplier
                                                    <span class="d-none dropdown-filter" data-table="sewingTable" data-column="10">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Status
                                                    <span class="d-none dropdown-filter" data-table="sewingTable" data-column="11">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="sewing-trims-tbody"></tbody>
                                    </table>
<p class="text-danger">Note: Item in red font indicates "Spl Req"</p>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="packing-trims" role="tabpanel" aria-labelledby="packing-trims-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="packingTable">
                                        <thead>
                                            <tr>
                                                <th>Item
                                                    <span class="dropdown-filter" data-table="packingTable" data-column="0">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Color
                                                    <span class="dropdown-filter" data-table="packingTable" data-column="1">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Size
                                                    <span class="dropdown-filter" data-table="packingTable" data-column="2">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Uom</th>
<th>Req Qty</th>
                                                <th>PO Issued</th>
                                                <th>L. Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Com. Dt</th>
                                                <th>Quality
                                                    <span class="d-none dropdown-filter" data-table="packingTable" data-column="8">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Process Owner
                                                    <span class="d-none dropdown-filter" data-table="packingTable" data-column="9">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Supplier
                                                    <span class="d-none dropdown-filter" data-table="packingTable" data-column="10">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                                <th>Status
                                                    <span class="d-none dropdown-filter" data-table="packingTable" data-column="11">
                                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                                        <div class="checkbox-dropdown-content">
                                                            <div class="checkbox-dropdown-actions">
                                                                <button class="select-all">Select All</button>
                                                                <button class="clear-all">Clear</button>
                                                            </div>
                                                            <div class="checkbox-options"></div>
                                                        </div>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="packing-trims-tbody"></tbody>
                                    </table>
<p class="text-danger">Note: Item in red font indicates "Spl Req"</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="grnModal" tabindex="-1" aria-labelledby="grnModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content shadow-sm rounded-3">
                    <div class="modal-header">
                        <div>
                            <h5 class="modal-title fw-bold fs-6">Goods Received Note (GRN) Details</h5>
                            <p class="text-muted mb-0 small modal-sub-title">For: Packaging for String (OCN: 4233)</p>
                        </div>
                        <span class="ms-auto small text-muted est-date-text">Est. In-Date: <strong>15-08-24</strong></span>
                        <button type="button" class="btn-close ms-3" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 pt-3 pb-2">
                        <div class="table-responsive">
                            <table class="table table-sm align-middle table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>PO No</th>
                                        <th>PO Date</th>
                                        <th>PO Qty</th>
                                        <th>GRN No</th>
                                        <th>DC No</th>
                                        <th>GRN Date</th>
                                        <th>GRN Qty</th>
                                        <th>Inspection</th>
                                        <th>Supplier</th>
                                    </tr>
                                </thead>
                                <tbody style="font-size: 12px">
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <div class="text-success small">
                            <i class="bi bi-check-circle-fill"></i> All items received for associated POs (100)
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="poModal" tabindex="-1" aria-labelledby="poModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content shadow-lg rounded-3">
                    <div class="modal-header">
                        <div>
                            <h5 class="modal-title fw-bold fs-6">Purchase Order Details</h5>
                            <p class="mb-0 text-muted small modal-sub-title">For: Yarn for String (OCN: 4233)</p>
                        </div>
                        <span class="text-muted small ms-auto due-date-text">Due: <strong>10-07-24</strong></span>
                        <button type="button" class="btn-close ms-3" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 pt-3 pb-2">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>PO Number</th>
                                        <th>Placed Date</th>
                                        <th>Quantity</th>
                                        <th>Supplier</th>
                                    </tr>
                                </thead>
                                <tbody style="font-size: 12px">
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex">
                        <div class="text-success small">
                            <i class="bi bi-check-circle-fill"></i> All POs issued for required quantity (100)
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="fabricModal" tabindex="-1" aria-labelledby="fabricModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content shadow-sm rounded-3">
                    <div class="modal-header">
                        <div>
                            <h5 class="modal-title fw-bold fs-6">Fabric Process Flow</h5>
                            <p class="text-muted mb-0 small fabric-sub-title"></p>
                        </div>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <div class="accordion" id="fabricProcessAccordion">
                            <div class="accordion-item border-0 mb-2">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#cardingCollapse">
                                        <div class="d-flex flex-column w-100">
                                            <div class="d-flex justify-content-between">
                                                <strong>Carding</strong>
                                                <span class="text-muted small">04-06-24 to 05-06-24</span>
                                            </div>
                                            <div class="text-success small">Completed 1 day early</div>
                                            <div class="progress mt-2" style="height: 6px;">
                                                <div class="progress-bar bg-success" style="width: 100%;"></div>
                                            </div>
                                            <div class="small text-muted mt-1">GRN: 480 / PO Issued: 490 / Target: 490 kg</div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="cardingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                                    <div class="accordion-body">
                                        <div class="table-responsive">
                                            <table class="table table-sm table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>PO #</th>
                                                        <th>GRN #</th>
                                                        <th>PO Date</th>
                                                        <th>GRN Date</th>
                                                        <th>PO Qty</th>
                                                        <th>GRN Qty</th>
                                                        <th>Supplier</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>PO-CARD-001</td>
                                                        <td>GRN-CARD-001</td>
                                                        <td>03-06-24</td>
                                                        <td>05-06-24</td>
                                                        <td>490</td>
                                                        <td>480</td>
                                                        <td>Carding Services</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="text-muted small mt-1">PO Qty Left for this Step: 0 kg (Target: 490 kg)</div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item border-0 mb-2">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#knittingCollapse">
                                        <div class="d-flex flex-column w-100">
                                            <div class="d-flex justify-content-between">
                                                <strong>Knitting</strong>
                                                <span class="text-muted small">06-06-24 to Est. Ongoing</span>
                                            </div>
                                            <div class="text-primary small">Est. to complete on time</div>
                                            <div class="progress mt-2" style="height: 6px;">
                                                <div class="progress-bar bg-info" style="width: 10%;"></div>
                                            </div>
                                            <div class="small text-muted mt-1">GRN: 0 / PO Issued: 480 / Target: 480 kg</div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="knittingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                                    <div class="accordion-body">
                                        <div class="table-responsive">
                                            <table class="table table-sm table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>PO #</th>
                                                        <th>GRN #</th>
                                                        <th>PO Date</th>
                                                        <th>GRN Date</th>
                                                        <th>PO Qty</th>
                                                        <th>GRN Qty</th>
                                                        <th>Supplier</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>PO-KNIT-001</td>
                                                        <td>-</td>
                                                        <td>05-06-24</td>
                                                        <td>-</td>
                                                        <td>480</td>
                                                        <td>0</td>
                                                        <td>KnitWorld</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="text-muted small mt-1">PO Qty Left for this Step: 480 kg (Target: 480 kg)</div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item border-0">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#washingCollapse">
                                        <div class="d-flex flex-column w-100">
                                            <div class="d-flex justify-content-between">
                                                <strong>Washing</strong>
                                            </div>
                                            <div class="progress mt-2" style="height: 6px;">
                                                <div class="progress-bar bg-secondary" style="width: 0%;"></div>
                                            </div>
                                            <div class="small text-muted mt-1">GRN: 0 / PO Issued: 0 / Target: 450 kg</div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="washingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                                    <div class="accordion-body text-muted small">
                                        No PO or GRN issued yet for this step.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Return to Supplier Modal -->
        <div class="modal fade" id="returnSupplierModal" tabindex="-1" aria-labelledby="returnSupplierModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content shadow-lg rounded-3">
                    <div class="modal-header">
                        <div>
                            <h5 class="modal-title fw-bold fs-6" id="returnSupplierModalLabel">Ret. to Supplier</h5>
                            <p class="mb-0 text-muted small modal-sub-title">For: <span id="returnSupplierModalSubTitle"></span></p>
                        </div>
                        <button type="button" class="btn-close ms-3" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 pt-3 pb-2">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Ret_No</th>
                                        <th>Ret_Date</th>
                                        <th>Supplier</th>
                                        <th>Item</th>
                                        <th>Color</th>
                                        <th>Size</th>
                                        <th>Ret_Qty</th>
                                    </tr>
                                </thead>
                                <tbody id="returnSupplierTbody" style="font-size: 12px">
                                    <!-- Data will be injected here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex">
                        <div class="text-danger small">
                            <!-- <i class="bi bi-exclamation-circle-fill"></i> All returns to supplier are listed above. -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="offcanvas offcanvas-end" tabindex="-1" id="commitmentOffcanvas" aria-labelledby="commitmentOffcanvasLabel">
            <div class="offcanvas-header border-bottom">
                <div>
                    <h5 class="offcanvas-title fw-bold">Update Commitment</h5>
                    <p class="text-muted small mb-0 commitment-sub-title">For: Yarn for Canvas (OCN: 5890)</p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <div class="mb-4">
                    <h6 class="text-muted small mb-2 commit_title"></h6>
                    <div class="border rounded p-2 bg-light small">
                        <strong>Committed Date:</strong> 10-09-24<br>
                        <strong>Reason:</strong> Original plan.<br>
                        <span class="text-muted">Recorded: 16-06-25, 11:26</span>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="newCommitDate" class="form-label fw-semibold">New Committed Date</label>
                    <input type="text" id="newCommitDate" class="form-control" placeholder="Select date">
                </div>
                <div class="mb-4">
                    <label for="reasonText" class="form-label fw-semibold">Reason for Change</label>
                    <textarea id="reasonText" class="form-control" rows="3" placeholder="E.g., Supplier delay, production rescheduled..."></textarea>
                </div>
                <div class="d-grid">
                    <button class="btn btn-primary">💾 Save Commitment</button>
                </div>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script> -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/plug-ins/1.13.6/sorting/datetime-moment.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script src = "<?php echo e(asset('custom/seeting.js')); ?>"></script>
        <script>
                //Global variables
                let buyerOcnData = {};
                let activeMetricType = null;
                let activeMaterialTab = 'YARN';
                let commitmentSaved = false;
                let allData = { 'YARN': [], 'Sewing Trims': [], 'Packing Trims': [], 'Fabric': [], 'Dashboard':[] };

                flatpickr("#newCommitDate", {
                    dateFormat: "d-m-y",
                    defaultDate: "today"
                });

                // Format OCN function
                function formatOcn(ocn) {
                    // Assuming ocn is a number like "4577", convert to "GIL\\OCN04577"
                    return `GIL\\OCN0${ocn}`;
                }

                function formatQty(value) {
                    let num = parseFloat(value);

                    if (isNaN(num) || num === 0) {
                        return "0"; // .000 or 0 → show as 0
                    }

                    // Add commas + keep 2 decimals only if needed
                    return num % 1 === 0
                        ? num.toLocaleString()
                        : num.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                }

                // Filter initialization
                function initializeFilters() {
                    const tables = [
                        { tableId: 'yarnTable', columns: [0, 1, 2, 8, 9, 10, 11] },
                        { tableId: 'sewingTable', columns: [0, 1, 2, 8, 9, 10, 11] },
                        { tableId: 'packingTable', columns: [0, 1, 2, 8, 9, 10, 11] },
                        { tableId: 'fabricTable', columns: [0, 1] }
                    ];

                    tables.forEach(({ tableId, columns }) => {
                        // Check if table exists
                        const table = document.querySelector(`#${tableId}`);
                        if (!table) {
                            console.warn(`Table ${tableId} not found in DOM`);
                            return;
                        }
                        columns.forEach(colIdx => {
                            updateFilterOptions(tableId, colIdx);
                        });
                    });
                }

                function updateFilterOptions(tableId, colIdx) {
                    const tableData = allData[tableId === 'yarnTable' ? 'YARN' : tableId === 'sewingTable' ? 'Sewing Trims' : tableId === 'packingTable' ? 'Packing Trims' : 'Fabric'];
                    const dropdown = document.querySelector(`.dropdown-filter[data-table="${tableId}"][data-column="${colIdx}"] .checkbox-options`);
                    if (!dropdown) {
                        console.warn(`Dropdown not found for table ${tableId}, column ${colIdx}`);
                        return;
                    }
                    const uniqueValues = [...new Set(tableData.map(item => {
                        switch (colIdx) {
                            case 0: return item.Item || item.Fabric;
                            case 1: return item.Color;
                            case 2: return item.SIze;
                            case 8: return item.Grn_Perc == 100 ? 'Passed' : 'Pending';
                            case 9: return item.Task_Owner;
                            case 10: return item.Supplier;
                            case 11: return item.Po_Iss_Time === 'OnTime' ? 'On Time' : 'Delayed';
                            default: return '';
                        }
                    }))].sort().filter(val => val);

                    dropdown.innerHTML = uniqueValues.map(val => `
                        <label><input type="checkbox" class="col-filter" data-column="${colIdx}" data-table="${tableId}" value="${val}"> ${val}</label>
                    `).join('');
                }

                function applyFilters(tableId) {
                    const tableData = allData[tableId === 'yarnTable' ? 'YARN' : tableId === 'sewingTable' ? 'Sewing Trims' : tableId === 'packingTable' ? 'Packing Trims' : 'Fabric'];
                    const tbody = document.querySelector(`#${tableId} tbody`);
                    if (!tbody) {
                        console.warn(`Table body for ${tableId} not found`);
                        return;
                    }
                    const filters = {};
                    document.querySelectorAll(`.dropdown-filter[data-table="${tableId}"] .col-filter:checked`).forEach(checkbox => {
                        const colIdx = checkbox.dataset.column;
                        if (!filters[colIdx]) filters[colIdx] = [];
                        filters[colIdx].push(checkbox.value);
                    });

                    const filteredData = tableData.filter(item => {
                        return Object.keys(filters).every(colIdx => {
                            const value = colIdx == 0 ? item.Item || item.Fabric:
                                        colIdx == 1 ? item.Color :
                                        colIdx == 2 ? item.SIze :
                                        colIdx == 8 ? (item.Grn_Perc == 100 ? 'Passed' : 'Pending') :
                                        colIdx == 9 ? item.Task_Owner :
                                        colIdx == 10 ? item.Supplier :
                                        colIdx == 11 ? (item.Po_Iss_Time === 'OnTime' ? 'On Time' : 'Delayed') : '';
                            return filters[colIdx].length === 0 || filters[colIdx].includes(value);
                        });
                    });

                    tbody.innerHTML = filteredData.length > 0
                        ? (tableId === 'fabricTable' ? filteredData.map(createFabricTableRow) : filteredData.map(item => {
                            return tableId === 'yarnTable' ? createYarnTableRow(item) :
                                tableId === 'sewingTable' ? createSewingTableRow(item) :
                                createPackingTableRow(item);
                        })).join('')
                        : `<tr><td colspan="${tableId === 'fabricTable' ? 9 : 12}" class="text-center">No data available</td></tr>`;

                    // Reinitialize tooltips
                    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                    tooltipTriggerList.forEach(function(tooltipTriggerEl) {
                        new bootstrap.Tooltip(tooltipTriggerEl);
                    });
                }

                $(document).on('click', '.checkbox-dropdown-content', function(e) {
                    e.stopPropagation();
                });

                // Parse URL parameters and load data
                function getQueryParams() {
                    const params = new URLSearchParams(window.location.search);
                    return {
                        buyer: params.get('buyer') || '',
                        orderno: params.get('orderno') || '' // Keep full OCN format
                    };
                }

                const { buyer, orderno } = getQueryParams();

                function selectBuyerFirstWord($select, query) {
                    if (!query) return;
                    const qFirst = query.trim().split(/\s+/)[0].toLowerCase();
                    $select.find('option').each(function() {
                        const optVal = ($(this).attr('value') || '').trim().split(/\s+/)[0].toLowerCase();
                        const optTxt = ($(this).text() || '').trim().split(/\s+/)[0].toLowerCase();

                        if (optVal === qFirst || optTxt === qFirst) {
                            $(this).prop('selected', true);
                            $select.trigger('change');
                            return false; // stop loop once found
                        }
                    });
                }

                function selectByFirstWord($select, query) {
                    if (!query) return;
                    const qFirst = query.trim().split(/\s+/)[0].toLowerCase();
                    console.log('Searching for OCN:', qFirst); // Debug
                    $select.find('.ocn-option').each(function() {
                        const optVal = ($(this).data('ocn') || '').trim().toLowerCase();
                        const optTxt = ($(this).text() || '').trim().toLowerCase();
                        // Match either the full data-ocn (e.g., "GIL\OCN04577") or the displayed text (e.g., "4577")
                        if (optVal.includes(qFirst) || optTxt.includes(qFirst)) {
                            $(this).trigger('click'); // Trigger click to select OCN and call fetchMaterialData
                            return false; // Stop loop
                        }
                    });
                }

                if (buyer && orderno) {
                    console.log('Params:', buyer, orderno);

                    fetchBuyers().done(function() {
                        // match buyer by first word
                        selectBuyerFirstWord($('#buyerFilter'), buyer);

                        // after buyer change populates OCNs, match orderno
                        setTimeout(function() {
                            selectByFirstWord($('#ocnDropdownList'), orderno);
                            //fetchMaterialData(orderno, buyer, activeMetricType );
                        }, 100);
                    });
                } else {
                    fetchBuyers();
                }

                // Initialize filters after DOM is fully loaded
                initializeFilters();

                // Filter toggle
                $('.filter-toggle').on('click', function (e) {
                    e.stopPropagation();
                    $('.dropdown-filter').not($(this).parent()).removeClass('show');
                    $(this).parent().toggleClass('show');
                });

                $(document).on('click', function () {
                    $('.dropdown-filter').removeClass('show');
                });

                // Select All
                $('.select-all').on('click', function (e) {
                    e.stopPropagation();
                    const dropdown = $(this).closest('.dropdown-filter');
                    dropdown.find('input[type="checkbox"]').prop('checked', true);
                    applyFilters(dropdown.data('table'));
                });

                // Clear All
                $('.clear-all').on('click', function (e) {
                    e.stopPropagation();
                    const dropdown = $(this).closest('.dropdown-filter');
                    dropdown.find('input[type="checkbox"]').prop('checked', false);
                    applyFilters(dropdown.data('table'));
                });

                // Filter change
                $(document).on('change', '.col-filter', function () {
                    applyFilters($(this).data('table'));
                });

                $('#notificationBell').click(function(e) {
                    e.preventDefault();
                    $('#notificationDropdown').toggleClass('show');
                });

                $(document).click(function(e) {
                    if (!$(e.target).closest('#notificationBell, #notificationDropdown').length) {
                        $('#notificationDropdown').removeClass('show');
                    }
                });

                let chartToggles = document.querySelectorAll('.chart-toggle');
                let kpiChartContainer = document.querySelector('.kpi-trends-chart');
                chartToggles.forEach(toggle => {
                    toggle.addEventListener('click', function () {
                        kpiChartContainer.classList.toggle('d-none');
                        this.classList.toggle('active');
                    });
                });

                const tabs = document.querySelectorAll('#materialTabs .btn');
                tabs.forEach(tab => {
                    tab.addEventListener('click', function () {
                        tabs.forEach(t => t.classList.remove('active'));
                        document.querySelectorAll('.tab-pane').forEach(pane => {
                            pane.classList.remove('show', 'active');
                        });
                        this.classList.add('active');
                        activeMaterialTab = $(this).data('tab');
                        const targetPane = document.querySelector(this.getAttribute('data-bs-target'));
                        targetPane.classList.add('show', 'active');
                        updateMetricCards(allData['Dashboard']);
                    });
                });

                // Fabric modal trigger
                $(document).on('click', '.fabric-trigger', function () {
                    let ocn = $(this).data('ocn');
                    let item = $(this).data('item');
                    let modal = $('#fabricModal');
                    modal.find('.fabric-sub-title').text(`For OCN : ${ocn.replace('GIL\\OCN0', '')}`);
                    $('.modal-title').text(`Fabric Process Flow - ${item}`);
                    let accordion = $('#fabricProcessAccordion');
                    accordion.html(`<div class="text-muted small p-2">Loading process flow...</div>`);

                    // Open modal immediately
                    let modalEl = document.getElementById('fabricModal');
                    let fabricModal = new bootstrap.Modal(modalEl);
                    fabricModal.show();

                    // First call → fetch process flow
                    $.ajax({
                        url: '/fabric_process_details',
                        method: 'GET',
                        data: { orderno: ocn },
                        success: function (response) {
                            accordion.empty();

                            if (response.success && response.data.length > 0) {
                                response.data.forEach(proc => {
                                    let collapseId = `process-${proc.ProcessId}-${ocn.replace(/[^a-zA-Z0-9]/g, '')}`;

                                    accordion.append(`
                                        <div class="accordion-item border-0 mb-2">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed bg-white fabric-process-trigger"
                                                        type="button"
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#${collapseId}"
                                                        data-processid="${proc.ProcessId}"
                                                        data-ocn="${ocn}">
                                                    <div class="d-flex flex-column w-100">
                                                        <div class="d-flex justify-content-between">
                                                            <strong>${proc.Process}</strong>
                                                            <span class="text-muted small">
                                                                ${formatDateTime(proc.SDate)} → ${formatDateTime(proc.FDate)}

                                                               
                                                            </span>
                                                        </div>
                                                        <div class="small text-muted">
                                                            Target: ${formatQty(proc.Plan_Qty)} / PO: ${formatQty(proc.Po_Qty)} / GRN: ${formatQty(proc.Grn_Qty)} / Bal: ${formatQty(proc.Bal_Qty)}
                                                        </div>

                                                        <!-- Progress bar -->
                                                        <div class="position-relative" style="height: 25px; font-size: 13px; font-weight: 600;">

                                                            <!-- Base track -->
                                                            <div class="progress" style="height: 100%;">
                                                                <div class="progress-bar bg-light" style="width: 100%;"></div>
                                                            </div>

                                                            <!-- PO Issued -->
                                                            <div class="progress-bar rounded position-absolute bg-primary" data-bs-toggle="tooltip" title="PO Issued: ${proc.PO_Issd_Perc}%, Grn Qty: ${proc.Rec_Perc}%"
                                                                style="width: ${proc.PO_Issd_Perc}%; top: 0; left: 0; height: 100%; z-index: 1;">
                                                                PO ${proc.PO_Issd_Perc}%
                                                            </div>

                                                            <!-- Received -->
                                                            <div class="progress-bar rounded position-absolute bg-info" data-bs-toggle="tooltip" title="PO Issued: ${proc.PO_Issd_Perc}%, Grn Qty: ${proc.Rec_Perc}%"
                                                                style="width: ${proc.Rec_Perc}%; top: 0; left: 0; height: 100%; z-index: 2;">
                                                                Grn ${proc.Rec_Perc}%
                                                            </div>

                                                        </div>

                                                    </div>
                                                </button>
                                            </h2>
                                            <div id="${collapseId}" class="accordion-collapse collapse"
                                                data-bs-parent="#fabricProcessAccordion">
                                                <div class="accordion-body">
                                                    <div class="text-muted small">Loading details...</div>
                                                </div>
                                            </div>
                                        </div>
                                    `);
                                });
                            } else {
                                accordion.html(`<div class="text-muted small p-2">No process data found.</div>`);
                            }
                        },
                        error: function (err) {
                            console.error('Error fetching process details:', err);
                            accordion.html(`<div class="text-danger small p-2">Failed to load process details.</div>`);
                        }
                    });
                });


                // Second call → when accordion expands, fetch sub details
                $(document).on('show.bs.collapse', '.accordion-collapse', function () {
                    let collapse = $(this);
                    let processId = collapse.prev().find('.fabric-process-trigger').data('processid');
                    let ocn = collapse.prev().find('.fabric-process-trigger').data('ocn');

                    // Target body
                    let body = collapse.find('.accordion-body');
                    body.html(`<div class="text-muted small">Fetching details...</div>`);

                    $.ajax({
                        url: '/fabric_sub_details',
                        method: 'GET',
                        data: { orderno: ocn, process_id: processId },
                        success: function (response) {
                            if (response.success && response.data.length > 0) {
                                let rows = response.data.map(item => `
                                    <tr>
                                    <td>${item.Po_No.slice(7)}</td>
                                    <td>${formatDateTime(item.Po_Date)}</td>
                                    <td>${item.Grn_No ? item.Grn_No.slice(3) : '-'}</td>
                                    <td>${formatDateTime(item.Grn_Date) || '-'}</td>
                                    <td title="${item.Supplier}">${item.Supplier.length > 7 ? item.Supplier.slice(0, 7) + '...' : item.Supplier}</td>
                                    <td title="${item.Item}">${item.Item.length > 7 ? item.Item.slice(0, 7) + '...' : item.Item}</td>
                                    <td title="${item.Color}">${item.Color.length > 7 ? item.Color.slice(0, 7) + '...' : item.Color}</td>
                                    <td>${formatQty(item.Po_Qty)}</td>
                                    <td>${formatQty(item.Grn_Qty)}</td>
                                    <td class="${parseFloat(item.Bal_Qty) < 0 ? 'text-danger' : 'text-success'}">
                                    ${formatQty(item.Bal_Qty)}
                                    </td>
                                    </tr>
                                `).join('');

                                body.html(`
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered align-middle" style="font-size: 10px">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>PO #</th>
                                                    <th>PO Date</th>
                                                    <th>GRN #</th>
                                                    <th>GRN Date</th>
                                                    <th>Supplier</th>
                                                    <th>Item</th>
                                                    <th>Color</th>
                                                    <th>PO Qty</th>
                                                    <th>GRN Qty</th>
                                                    <th>Balance</th>
                                                </tr>
                                            </thead>
                                            <tbody>${rows}</tbody>
                                        </table>
                                    </div>
                                `);
                            } else {
                                body.html(`<div class="text-muted small">No details available.</div>`);
                            }
                        },
                        error: function (err) {
                            console.error('Error fetching sub details:', err);
                            body.html(`<div class="text-danger small">Failed to load details.</div>`);
                        }
                    });
                });

                // Update commit-trigger to pass additional data
                $(document).on('click', '.commit-trigger', function() {
                    console.log('Commit modal triggered', $(this).data()); // Debug with data attributes
                    let ocn = $(this).data('ocn');
                    let item = $(this).data('item');
                    let itemid = $(this).data('itemid');
                    let colorid = $(this).data('colorid');
                    let sizeid = $(this).data('sizeid');
                    let type = $(this).data('type');
                    let offcanvas = $('#commitmentOffcanvas');
                    offcanvas.find('.commitment-sub-title').text(`For: ${type} - OCN (${ocn})`);
                    // Store data in offcanvas for use in save
                    offcanvas[0].dataset.ocn = ocn;
                    offcanvas[0].dataset.itemid = itemid;
                    offcanvas[0].dataset.colorid = colorid;
                    offcanvas[0].dataset.sizeid = sizeid;
                    offcanvas[0].dataset.type = type;

                    $.ajax({
                        url: '/raw_material_commit_history',
                        method: 'GET',
                        data: {
                            orderno: formatOcn(ocn),
                            itemid: itemid,
                            colorid: colorid,
                            sizeid: sizeid,
                            type: type
                        },
                        success: function(response) {
                            console.log('Commitment history response:', response);
                            let historyContainer = $('#commitmentOffcanvas .border.rounded.bg-light');
                            historyContainer.empty().hide(); // Hide by default

                            if (response.success && response.latest_history && response.latest_history.length > 0) {
                                // Sort by added_date (descending) and take first 3
                                let history = response.latest_history
                                    .sort((a, b) => new Date(b.added_date) - new Date(a.added_date))
                                    .slice(0, 3);

                                // Append each history entry
                                history.forEach(entry => {
                                    let commitDate = new Date(entry.commit_date).toLocaleDateString('en-GB', {
                                        day: '2-digit',
                                        month: '2-digit',
                                        year: 'numeric'
                                    }).replace(/\//g, '-');
                                    let recordedAt = new Date(entry.added_date).toLocaleString('en-GB', {
                                        day: '2-digit',
                                        month: '2-digit',
                                        year: '2-digit',
                                        hour: '2-digit',
                                        minute: '2-digit'
                                    }).replace(/\//g, '-');

                                    historyContainer.append(`
                                        <div>
                                            <strong>Committed Date:</strong> ${commitDate}<br>
                                            <strong>Reason:</strong> ${entry.review_comments}<br>
                                            <span class="text-muted">Recorded: ${recordedAt}</span>
                                        </div>
                                        <hr>
                                    `);
                                });
                                $('.commit_title').text("Commitment History");
                                historyContainer.show(); // Show if there are entries
                            }
                        },
                        error: function(error) {
                            console.error('Error fetching commitment:', error);
                            //toastr.warning('⚠️ Error saving commitment. Please try again.');
                        }
                    });
                });

                // PO Modal AJAX with event delegation
                $(document).on('click', '.po-trigger', function() {
                    console.log('PO trigger clicked'); // Debug
                    let orderno = $(this).data('ocn'); // Format OCN
                    let item = $(this).data('item');
                    let color = $(this).data('color');
                    let size = $(this).data('size');
                    let itemid = $(this).data('itemid');
                    let colorid = $(this).data('colorid');
                    let sizeid = $(this).data('sizeid');
                    let estdate = $(this).data('estdate');
                    let itemtype = $(this).data('type');
                    let type = $(this).data('req-type');
                    let modal = $('#poModal');
                    $('.modal-title').text(`PO Details - ${item} | ${color} | ${size} `);
                    let modalTitle = modal.find('.modal-sub-title');
                    let modalBody = modal.find('.modal-body tbody');

                    $.ajax({
                        url: '/materialpostatus',
                        method: 'GET',
                        data: {
                            orderno: formatOcn(orderno),
                            itemid: itemid,
                            colorid: colorid,
                            sizeid: sizeid,
                            type: type
                        },
                        success: function(response) {
                            if (!response || !response.data || response.data.length === 0) {
                            toastr.info("No PO records found for this selection.");
                            return;
                            }
                            //console.log('PO AJAX response:', response); // Debug
                            modalTitle.text(`For: ${itemtype} - OCN (${orderno})`);
                            modalBody.html(response.data.map(po => `
                                <tr class="${po.status === 'Delayed' ? 'table-danger' : ''}">
                                    <td>${po.PO_No.replace('GIL\\', '')}</td>
                                    <td>${formatDateTime(po.Po_Date)} ${po.status === 'Delayed' ? '<span class="text-danger ms-1" title="Delayed">⚠️</span>' : ''}</td>
                                    <td>${po.Po_Qty}</td>
                                    <td>${po.Supplier}</td>
                                </tr>
                            `).join(''));
                            let totalQuantity = response.data.reduce((sum, po) => sum + Number(po.Po_Qty), 0);
                            modal.find('.modal-footer .text-success').text(`All POs issued for required quantity (${totalQuantity.toFixed(2)})`);
                            modal.find('.modal-header .text-muted .due-date-text').text(`Due: ${estdate}`);
                            modal.modal('show'); // Manually show modal
                        },
                        error: function(error) {
                            toastr.error("Failed to fetch PO data. Please try again.");
                            console.error('Error fetching PO data:', error);
                        }
                    });
                });

                // GRN Modal AJAX with event delegation
                $(document).on('click', '.grn-trigger', function() {
                    console.log('GRN trigger clicked'); // Debug
                    let orderno = $(this).data('ocn');
                    let item = $(this).data('item');
                    let color = $(this).data('color');
                    let size = $(this).data('size');
                    let itemid = $(this).data('itemid');
                    let colorid = $(this).data('colorid');
                    let sizeid = $(this).data('sizeid');
                    let estdate = $(this).data('estdate');
                    let itemtype = $(this).data('type');
                    let type = $(this).data('req-type');
                    let modal = $('#grnModal');
                    $('.modal-title').text(`GRN Details - ${item} | ${color} | ${size} `);
                    let modalTitle = modal.find('.modal-sub-title');
                    let modalBody = modal.find('.modal-body tbody');

                    $.ajax({
                        url: '/materialgrnstatus',
                        method: 'GET',
                        data: {
                            orderno: formatOcn(orderno),
                            itemid: itemid,
                            colorid: colorid,
                            sizeid: sizeid,
                            type: type
                        },
                        success: function(response) {
                            if (!response || !response.data || response.data.length === 0) {
                            toastr.info("No GRN records found for this selection.");
                            return;
                            }
                            //console.log('GRN AJAX response:', response); // Debug
                            modalTitle.text(`For: ${itemtype} - OCN (${orderno})`);
                            modalBody.html(response.data.map(grn => `
                                <tr>
                                    <td>${grn.Po_No.replace('GIL\\', '')}</td>
                                    <td>${formatDateTime(grn.Po_Date)}</td>
                                    <td>${grn.Po_Qty}</td>
                                    <td>${grn.Grn_No.replace('GIL\\', '')}</td>
                                    <td>${grn.Dc_no}</td>
                                    <td>${formatDateTime(grn.Grn_Date)}</td>
                                    <td>${grn.Grn_Qty}</td>
                                    <td><span class="badge bg-${grn.inspection === 'Passed' ? 'success' : 'warning'}">${grn.inspection || " Completed "}</span></td>
                                    <td>${grn.Supplier}</td>
                                </tr>
                            `).join(''));
                            let totalQuantity = response.data.reduce((sum, grn) => sum + Number(grn.Po_Qty), 0);
                            modal.find('.modal-footer .text-success').text(`All items received for associated POs (${totalQuantity.toFixed(2)})`);
                            modal.find('.modal-header .text-muted .est-date-text').text(`Est. In-Date: ${estdate}`);
                            modal.modal('show');
                        },
                        error: function(error) {
                            toastr.error("Failed to fetch GRN data. Please try again.");
                            console.error('Error fetching GRN data:', error);
                        }
                    });
                });

                // Handle Save Commitment button click
                $('#commitmentOffcanvas .btn-primary').on('click', function() {
                    let offcanvas = $('#commitmentOffcanvas');
                    let ocn = offcanvas[0].dataset.ocn;
                    let itemid = offcanvas[0].dataset.itemid;
                    let colorid = offcanvas[0].dataset.colorid;
                    let sizeid = offcanvas[0].dataset.sizeid;
                    let type = offcanvas[0].dataset.type;
                    let newCommitDate = $('#newCommitDate').val();
                    let reasonText = $('#reasonText').val();

                    if (!newCommitDate || !reasonText) {
                        alert('Please fill in both the Committed Date and Reason fields.');
                        return;
                    }

                    console.log('Sending commitment data:', { orderno: formatOcn(ocn), itemid, colorid, sizeid, type, commit_date: newCommitDate, reason: reasonText }); // Debug

                    $.ajax({
                        url: '/savecommitment',
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            orderno: formatOcn(ocn),
                            itemid: itemid,
                            colorid: colorid,
                            sizeid: sizeid,
                            type: type,
                            commit_date: newCommitDate,
                            reason: reasonText,
                            emp_id: window.emp_id
                        },
                        success: function(response) {
                            console.log('Commitment save response:', response);
                            if (response.success) {
                                commitmentSaved = true;
                                // Update commitment history
                                let historyContainer = $('#commitmentOffcanvas .border.rounded.bg-light');
                                let now = new Date().toLocaleString('en-GB', {
                                    day: '2-digit',
                                    month: '2-digit',
                                    year: '2-digit',
                                    hour: '2-digit',
                                    minute: '2-digit'
                                }).replace(/\//g, '-');
                                historyContainer.prepend(`
                                    <div>
                                        <strong>Committed Date:</strong> ${newCommitDate}<br>
                                        <strong>Reason:</strong> ${reasonText}<br>
                                        <span class="text-muted">Recorded: ${now}</span>
                                    </div>
                                    <hr>
                                `);
                                // Clear input fields
                                $('#newCommitDate').val('');
                                $('#reasonText').val('');
                                // Optionally close offcanvas
                                bootstrap.Offcanvas.getInstance(offcanvas[0]).hide();
                                toastr.success(' Saved successfully!', 'Success', {
                                    timeOut: 3000,
                                    positionClass: 'toast-top-right'
                                });
                            } else {
                                console.error('Failed to save commitment:', response.message);
                                toastr.warning('Failed to save commitment: ' + (response.message || 'Unknown error'));
                            }
                        },
                        error: function(error) {
                            console.error('Error saving commitment:', error);
                            toastr.warning(' Error saving commitment. Please try again.');
                        }
                    });
                });

                $('#commitmentOffcanvas').on('hide.bs.offcanvas', function() {
                    if (commitmentSaved) {
                        let buyer = $('#buyerFilter').val();
                        let ocn = $('#ocnDropdownSelected').data('ocn');
                        if (buyer && ocn) {
                            console.log('Refreshing data after commitment save:', { buyer, ocn, activeMetricType });
                            fetchMaterialData(ocn, buyer, activeMetricType);
                        } else {
                            console.warn('Cannot refresh data: Buyer or OCN not selected', { buyer, ocn });
                            toastr.warning('Cannot refresh data: Please select a Buyer and OCN.');
                        }
                    }
                });

                function fetchBuyers() {
                    return $.ajax({ // Make it return the promise
                        url: '/buyer_ocn_details',
                        method: 'GET',
                        success: function(response) {
                            if (response.success && response.data) {
                                let buyerOcnMap = {};
                                response.data.forEach(function(item) {
                                    let buyer = item.Buyer;
                                    let ocn = item.Ocn_No;
                                    if (!buyerOcnMap[buyer]) {
                                        buyerOcnMap[buyer] = [];
                                    }
                                    buyerOcnMap[buyer].push(ocn);
                                });
                               
                                buyerOcnData = buyerOcnMap; // Now safe to assign
                               
                                $('#buyerFilter').empty().append('<option value="">Select Buyer</option>');
                                Object.keys(buyerOcnMap).forEach(function(buyer) {
                                    $('#buyerFilter').append(`<option value="${buyer}">${buyer}</option>`);
                                });
                            } else {
                                console.error('No buyers found in response');
                            }
                        },
                        error: function(xhr) {
                            console.error('Error fetching buyers:', xhr.responseText);
                        }
                    });
                }

                // Function to update metric card values based on active tab
                function updateMetricCards(dashboardData) {
                    const tabData = dashboardData.find(item => item.Item_Type === activeMaterialTab || item.Item_Type =="YARN") || {};
                    $('.metric-card').each(function() {
                        const title = $(this).find('.card-title').text();
                        let value;
                        switch (title) {
                            case 'PO-delay':
                                value = tabData.Po_Del_Perc ? `${tabData.Po_Del_Perc} %` : '0 %';
                                break;
                            case 'RM delay':
                                value = tabData.Rm_Del_Perc ? `${tabData.Rm_Del_Perc} %` : '0 %';
                                break;
                            case 'Est.CK Date':
                                value = tabData.Ck_Date ? `${formatDateTime(tabData.Ck_Date)}` : 'N/A';
                                break;
                            case 'Lead Time Dev':
                                value = tabData.Lead_Time ? `${tabData.Lead_Time} days` : '0 days';
                                break;
                            case 'Commit. Slips':
                                value = tabData.Cnt ? `${tabData.Cnt} slips` : '0 slips';
                                break;
                            case 'Ret. to Supplier':
                                value = tabData.Rm_Del_Perc ? `${tabData.Rm_Del_Perc} %` : '0 %';
                                break;
                            default:
                                value = '0 %';
                        }
                        $(this).find('.value').text(value);
                    });
                }

                function fetchMaterialData(orderno, buyer, type) {
                    $("#loadSpinner").show();

                    $.ajax({
                        url: '/rawmaterial/',

                        method: 'GET',
                        data: { orderno: orderno, buyer: buyer, type: type },
                        success: function(response) {
                            if (response.success && response.data) {
                                $("#loadSpinner").hide();
                               // Clear existing table content
                                $('#yarn-tbody, #sewing-trims-tbody, #packing-trims-tbody, #fabric-tbody').empty();
                                allData = { 'YARN': [], 'Sewing Trims': [], 'Packing Trims': [], 'Fabric': [], 'Dashboard': [] };

                                // Populate yarn table with both YARN and FABRIC data
                                if (response.data.data['YARN'] || response.data.data['FABRIC']) {
                                    allData['YARN'] = [
                                        ...(response.data.data['YARN'] || []),
                                        ...(response.data.data['FABRIC'] || [])
                                    ];
                                    $('#yarn-tbody').html(allData['YARN'].map(createYarnTableRow).join(''));
                                } else {
                                    $('#yarn-tbody').append('<tr><td colspan="12" class="text-center">No data available for this OCN</td></tr>');
                                }

                                // Populate fabric table
                                if (response.data.fabricprocess) {
                                    allData['Fabric'] = response.data.fabricprocess;
                                    $('#fabric-tbody').html(response.data.fabricprocess.map(createFabricTableRow).join(''));
                                } else {
                                    $('#fabric-tbody').append('<tr><td colspan="9" class="text-center">No data available for this OCN</td></tr>');
                                }

                                if (response.data.data['Sewing Trims']) {
                                    allData['Sewing Trims'] = response.data.data['Sewing Trims'];
                                    $('#sewing-trims-tbody').html(response.data.data['Sewing Trims'].map(createSewingTableRow).join(''));
                                } else {
                                    $('#sewing-tbody').append('<tr><td colspan="12" class="text-center">No data available for this OCN</td></tr>');
                                }

                                if (response.data.data['Packing Trims']) {
                                    allData['Packing Trims'] = response.data.data['Packing Trims'];
                                    $('#packing-trims-tbody').html(response.data.data['Packing Trims'].map(createPackingTableRow).join(''));
                                } else {
                                    $('#packing-tbody').append('<tr><td colspan="12" class="text-center">No data available for this OCN</td></tr>');
                                }

                                // if (response.data.data['Fabric']) {
                                //     allData['Fabric'] = response.data.data['Fabric'];
                                //     $('#fabric-tbody').html(response.data.data['Fabric'].map(createFabricTableRow).join(''));
                                // } else {
                                //     $('#fabric-tbody').append('<tr><td colspan="9" class="text-center">No data available for this OCN</td></tr>');
                                // }

                                // Update metric card values with dashboard data
                                if (response.data.dashboard) {
                                    allData['Dashboard'] = response.data.dashboard;
                                    updateMetricCards(response.data.dashboard);
                                }

                                // Update filter options
                                initializeFilters();

                                // Update dashboard title
                                if (orderno) {
                                    let ocnNum = orderno.split("\\").pop().replace("OCN", "");
                                    document.getElementById('dashboard_title').textContent = `Raw Material View for Garments - OCN ${ocnNum}`;
                                } else {
                                    for (let cat in response.data.data) {
                                        if (Array.isArray(response.data.data[cat]) && response.data.data[cat].length > 0) {
                                            let ocn = response.data.data[cat][0].OCN;
                                            let ocnNum = ocn.split("\\").pop().replace("OCN", "");
                                            document.getElementById('dashboard_title').textContent = `Raw Material View for Garments - OCN ${ocnNum}`;
                                            break;
                                        }
                                    }
                                }

                                // Initialize tooltips
                                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                                tooltipTriggerList.forEach(function(tooltipTriggerEl) {
                                    new bootstrap.Tooltip(tooltipTriggerEl);
                                });

                            } else {
                                $("#loadSpinner").hide();
                                $('#yarn-tbody, #sewing-trims-tbody, #packing-trims-tbody, #fabric-tbody')
                                    .empty()
                                    .append('<tr><td colspan="100" class="text-center">No data available for this OCN</td></tr>');
                                console.error('No data found in response');
                            }
                        },
                        error: function(xhr) {
                            console.error('Error fetching data:', xhr.responseText);
                        }
                    });
                }

                function displayValue(value) {
                    return (value === null || value === undefined || value === '' || (typeof value === 'string' && value.trim() === '')) ? '-' : value;
                }

                function createYarnTableRow(item) {
                    var statusClass = displayValue(item.Po_Iss_Time) === 'OnTime' ? 'green' : 'orange';
                    let status = displayValue(item.Clr_Status);
                    var clrstatusClass = status == 1 ? 'green' :
                        status == 2 ? 'lightgreen' :
                        status == 3 ? 'yellow' :
                        status == 4 ? 'orange' :
                        status == 5 ? 'red' :
                        status == 6 ? 'purple' : 'need';
                    var statusTitle = status == 1 ? 'DONE' :
                        status == 2 ? 'ON-TRACK' :
                        (status == 3 || status == 4 || status == 5) ? 'PO + CRITICAL PATH' :
                        status == 6 ? 'RETURN TO SUPPLIER' : 'Delayed';
                    var inspection = displayValue(item.Grn_Perc) == 100 ? 'Passed' : 'Pending';
                    var leadTime = item.Lead_Time ? item.Lead_Time + ' D' : '-';
                    var truncatedItem = displayValue(item.Item);
                    var truncatedColor = displayValue(item.Color);
                    var truncatedTaskOwner = displayValue(item.Task_Owner);
                    var truncatedSupplier = displayValue(item.Supplier);
                    var planStart = displayValue(item.Plan_Start) && !isNaN(new Date(item.Plan_Start).getTime())
                        ? new Date(item.Plan_Start).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var committedDate = displayValue(item.Commited_Date) && !isNaN(new Date(item.Commited_Date).getTime())
                        ? new Date(item.Commited_Date).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var itemStyle = displayValue(item.Req_Type) !== 'Normal' ? 'color: red;' : '';
                    return `
                        <tr>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" style="${itemStyle}">${truncatedItem}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top">${truncatedColor}</td>
                            <td>${displayValue(item.SIze)}</td>
                            <td>${displayValue(item.Uom)}</td>
                            <td>${displayValue(item.Req_Qty)}</td>
                            <td>
                                <div class="d-flex">
                                    <div class="progress po-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar" role="progressbar" style="width: ${displayValue(item.Po_Issd)}%; background-color: ${statusClass}" aria-valuenow="${displayValue(item.Po_Issd)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Po_Issd)}%</div>
                                </div>
                            </td>
                            <td>${leadTime}</td>
                            <td>
                                <div class="d-flex">
                                    <div class="progress grn-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: ${displayValue(item.Grn_Perc)}%;" aria-valuenow="${displayValue(item.Grn_Perc)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Grn_Perc)}%</div>
                                </div>
                            </td>
                            <td>${planStart}</td>
                            <td role="button" tabindex="0" class="text-primary commit-trigger" data-bs-toggle="offcanvas" data-bs-target="#commitmentOffcanvas" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}">${committedDate}</td>
                            <td>${inspection}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top">${truncatedTaskOwner}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top">${truncatedSupplier}</td>
                            <td>
                                <span class="status-dot ${clrstatusClass}" data-bs-toggle="tooltip" data-bs-placement="top" title="${statusTitle}"></span>
                            </td>
                        </tr>
                    `;
                }

                function createFabricTableRow(item) {
                    var Item = displayValue(item.Fabric);
                    var Order_no = item.Order_No;
                    var Color = displayValue(item.Color);
                    var Bom_Qty = displayValue(item.Bom_Qty);
                    var Ontable_Qty = displayValue(item.Ontable_Qty);
                    var Rec_Qty = displayValue(item.Rec_Qty);
                    var Bal_Qty = displayValue(item.Bal_Qty);
                    var Rec_Perc = displayValue(item.Rec_Perc);
                    var Comments = displayValue(item.Comments);
                    var committedDate = item.commit_date && !isNaN(new Date(item.commit_date).getTime())
                        ? new Date(item.commit_date).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : 'View';
                   
                    return `
                        <tr>
                            <td data-bs-toggle="tooltip" data-bs-placement="top">${Item}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top">${Color}</td>
                            <td>${Bom_Qty}</td>
                            <td>${Ontable_Qty}</td>
                            <td>${Rec_Qty}</td>
                            <td>
                                <div class="d-flex">
                                    <div class="progress fabric-trigger" style="height: 10px; width: 100px;" data-ocn="${item.Order_No}" data-itemid="${item.itemid}" data-colorid="${item.ColorID}" data-item="${Item}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}">
                                        <div class="progress-bar" role="progressbar" style="width: ${displayValue(item.Rec_Perc)}%; background-color: blue" aria-valuenow="${displayValue(item.Rec_Perc)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${Rec_Perc}%</div>
                                </div>
                            </td>
                            <td>${Comments}</td>
                            <td role="button" tabindex="0" class="text-primary commit-trigger" data-bs-toggle="offcanvas" data-bs-target="#commitmentOffcanvas" data-item="${Item}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-ocn="${Order_no.replace('GIL\\OCN0', '')}" data-itemid="${item.itemid}" data-colorid="${item.ColorID}" data-sizeid="" data-estdate="${item.Plan_Start}" data-type="fabricprocess">${committedDate}</td>
                        </tr>
                    `;
                }

                function createSewingTableRow(item) {
                    var statusClass = displayValue(item.Po_Iss_Time) === 'OnTime' ? 'green' : 'orange';
                    let status = displayValue(item.Clr_Status);
                    var clrstatusClass = status == 1 ? 'green' :
                        status == 2 ? 'lightgreen' :
                        status == 3 ? 'yellow' :
                        status == 4 ? 'orange' :
                        status == 5 ? 'red' :
                        status == 6 ? 'purple' : 'need';
                    var statusTitle = status == 1 ? 'DONE' :
                        status == 2 ? 'ON-TRACK' :
                        (status == 3 || status == 4 || status == 5) ? 'PO + CRITICAL PATH' :
                        status == 6 ? 'RETURN TO SUPPLIER' : 'Delayed';
                    var inspection = displayValue(item.Grn_Perc) == 100 ? 'Passed' : 'Pending';
                    var leadTime = item.Lead_Time ? item.Lead_Time + ' D' : '-';
                    var truncatedItem = displayValue(item.Item);
                    var truncatedColor = displayValue(item.Color);
                    var truncatedTaskOwner = displayValue(item.Task_Owner);
                    var truncatedSupplier = displayValue(item.Supplier);
                    var planStart = displayValue(item.Plan_Start) && !isNaN(new Date(item.Plan_Start).getTime())
                        ? new Date(item.Plan_Start).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var committedDate = displayValue(item.Commited_Date) && !isNaN(new Date(item.Commited_Date).getTime())
                        ? new Date(item.Commited_Date).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var itemStyle = displayValue(item.Req_Type) !== 'Normal' ? 'color: red;' : '';
                    return `
                        <tr>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedItem}" style="${itemStyle}">${truncatedItem}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedColor}">${truncatedColor}</td>
                            <td>${displayValue(item.SIze)}</td>
                            <td>${displayValue(item.Uom)}</td>
                            <td>${displayValue(item.Req_Qty)}</td>
                            ${displayValue(item.Item_Type) === 'Fabric' ? `<td><div class="status-dot ${statusClass} fabric-trigger" data-bs-toggle="modal" data-bs-target="#fabricModal" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-ocn="${displayValue(item.OCN)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-type="${displayValue(item.Item_Type)}"></div></td>` : ''}
                            <td>
                                <div class="d-flex">
                                    <div class="progress po-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar" role="progressbar" style="width: ${displayValue(item.Po_Issd)}%; background-color: ${statusClass}" aria-valuenow="${displayValue(item.Po_Issd)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Po_Issd)}%</div>
                                </div>
                            </td>
                            <td>${leadTime}</td>
                            <td>
                                <div class="d-flex">
                                    <div class="progress grn-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: ${displayValue(item.Grn_Perc)}%;" aria-valuenow="${displayValue(item.Grn_Perc)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Grn_Perc)}%</div>
                                </div>
                            </td>
                            <td>${planStart}</td>
                            <td role="button" tabindex="0" class="text-primary commit-trigger" data-bs-toggle="offcanvas" data-bs-target="#commitmentOffcanvas" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}">${committedDate}</td>
                            <td>${inspection}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedTaskOwner}">${truncatedTaskOwner}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedSupplier}">${truncatedSupplier}</td>
                            <td>
                                <span class="status-dot ${clrstatusClass}" data-bs-toggle="tooltip" data-bs-placement="top" title="${statusTitle}"></span>
                            </td>
                        </tr>
                    `;
                }

                function createPackingTableRow(item) {
                    var statusClass = displayValue(item.Po_Iss_Time) === 'OnTime' ? 'green' : 'orange';
                    let status = displayValue(item.Clr_Status);
                    var clrstatusClass = status == 1 ? 'green' :
                        status == 2 ? 'lightgreen' :
                        status == 3 ? 'yellow' :
                        status == 4 ? 'orange' :
                        status == 5 ? 'red' :
                        status == 6 ? 'purple' : 'need';
                    var statusTitle = status == 1 ? 'DONE' :
                        status == 2 ? 'ON-TRACK' :
                        (status == 3 || status == 4 || status == 5) ? 'PO + CRITICAL PATH' :
                        status == 6 ? 'RETURN TO SUPPLIER' : 'Delayed';
                    var inspection = displayValue(item.Grn_Perc) == 100 ? 'Passed' : 'Pending';
                    var leadTime = item.Lead_Time ? item.Lead_Time + ' D' : '-';
                    var truncatedItem = displayValue(item.Item);
                    var truncatedColor = displayValue(item.Color);
                    var truncatedTaskOwner = displayValue(item.Task_Owner);
                    var truncatedSupplier = displayValue(item.Supplier);
                    var planStart = displayValue(item.Plan_Start) && !isNaN(new Date(item.Plan_Start).getTime())
                        ? new Date(item.Plan_Start).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var committedDate = displayValue(item.Commited_Date) && !isNaN(new Date(item.Commited_Date).getTime())
                        ? new Date(item.Commited_Date).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '-')
                        : '-';
                    var itemStyle = displayValue(item.Req_Type) !== 'Normal' ? 'color: red;' : '';
                    return `
                        <tr>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedItem}" style="${itemStyle}">${truncatedItem}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedColor}">${truncatedColor}</td>
                            <td>${displayValue(item.SIze)}</td>
                            <td>${displayValue(item.Uom)}</td>
                            <td>${displayValue(item.Req_Qty)}</td>
                            ${displayValue(item.Item_Type) === 'Fabric' ? `<td><div class="status-dot ${statusClass} fabric-trigger" data-bs-toggle="modal" data-bs-target="#fabricModal" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-type="${displayValue(item.Item_Type)}"></div></td>` : ''}
                            <td>
                                <div class="d-flex">
                                    <div class="progress po-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar" role="progressbar" style="width: ${displayValue(item.Po_Issd)}%; background-color: ${statusClass}" aria-valuenow="${displayValue(item.Po_Issd)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Po_Issd)}%</div>
                                </div>
                            </td>
                            <td>${leadTime}</td>
                            <td>
                                <div class="d-flex">
                                    <div class="progress grn-trigger" style="height: 10px; width: 100px;" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}" data-req-type="${item.Req_Type == 'Spl Req' ? '1' : '0'}">
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: ${displayValue(item.Grn_Perc)}%;" aria-valuenow="${displayValue(item.Grn_Perc)}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="ms-2">${displayValue(item.Grn_Perc)}%</div>
                                </div>
                            </td>
                            <td>${planStart}</td>
                            <td role="button" tabindex="0" class="text-primary commit-trigger" data-bs-toggle="offcanvas" data-bs-target="#commitmentOffcanvas" data-ocn="${displayValue(item.OCN)}" data-item="${displayValue(item.Item)}" data-color="${displayValue(item.Color)}" data-size="${displayValue(item.SIze)}" data-itemid="${displayValue(item.Itemid)}" data-colorid="${displayValue(item.Colorid)}" data-sizeid="${displayValue(item.Sizeid)}" data-estdate="${displayValue(item.Plan_Start)}" data-type="${displayValue(item.Item_Type)}">${committedDate}</td>                        
                            <td>${inspection}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedTaskOwner}">${truncatedTaskOwner}</td>
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="${truncatedSupplier}">${truncatedSupplier}</td>
                            <td>
                                <span class="status-dot ${clrstatusClass}" data-bs-toggle="tooltip" data-bs-placement="top" title="${statusTitle}"></span>
                            </td>
                        </tr>
                    `;
                }

                $('#buyerFilter').on('change', function() {
                    var buyer = $(this).val();
                    let ocnList = $('#ocnDropdown .ocn-list');
                    ocnList.empty();
                    $('#ocnSearch').val('').data('selected', '');
                    $('#ocnMenu').hide();
                    if (buyer && buyerOcnData[buyer]) {
                        let sortedOcns = buyerOcnData[buyer].sort((a, b) => {
                            let numA = parseInt(a.split('OCN0')[1]);
                            let numB = parseInt(b.split('OCN0')[1]);
                            return numA - numB;
                        });
                        sortedOcns.forEach(function(ocn) {
                            let display = ocn.split("\\").pop().replace("OCN0", "");
                            ocnList.append(`<div class="dropdown-item ocn-option" data-value="${ocn}">${display}</div>`);
                        });
                    }
                    $('#ocnDropdown').removeClass('d-none');
                });

                $('#ocnSearch').on('focus', function() {
                    $('#ocnMenu').show();
                });

                $('#ocnSearch').on('input', function() {
                    let search = $(this).val().toLowerCase();
                    $('#ocnDropdown .ocn-option').each(function() {
                        let text = $(this).text().toLowerCase();
                        $(this).toggle(text.includes(search));
                    });
                });

                $('#ocnSearch').on('blur', function() {
                    setTimeout(() => {
                        $('#ocnMenu').hide();
                    }, 100);
                });

                $(document).on('click', '.ocn-option', function() {
                    let display = $(this).text();
                    let value = $(this).data('value');
                    $('#ocnSearch').val(display).data('selected', value);
                    $('#ocnMenu').hide();
                    var buyer = $('#buyerFilter').val();
                    var orderno = value;
                    if (orderno) {
                        fetchMaterialData(formatOcn(orderno), buyer, activeMetricType );
                    }
                });

                $(document).on('click', function(e) {
                    if (!$(e.target).closest('#ocnDropdown').length) {
                        $('#ocnMenu').hide();
                    }
                });

                //fetchBuyers();

                // Initialize Chart.js for KPI trends
                const ctx = document.getElementById('kpiChart').getContext('2d');
                const kpiChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                        datasets: [{
                            label: 'PO Delay (%)',
                            data: [70, 75, 80, 78, 82, 80],
                            borderColor: '#4052B6',
                            fill: false,
                            tension: 0.1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                max: 100,
                                title: {
                                    display: true,
                                    text: 'Percentage'
                                }
                            },
                            x: {
                                title: {
                                    display: true,
                                    text: 'Month'
                                }
                            }
                        }
                    }
                });

                $('.metric-card').on('click', function() {
                    if ($(this).hasClass('active')) {
                        $(this).removeClass('active');
                        activeMetricType = null;
                    } else {
                        $('.metric-card').removeClass('active');
                        $(this).addClass('active');
                        const title = $(this).find('.card-title').text();
                        let data, label;
                        switch (title) {
                            case 'PO-delay':
                                label = 'PO Delay (%)';
                                data = [70, 75, 80, 78, 82, 80];
                                activeMetricType = 'po_delay';
                                break;
                            case 'RM delay':
                                label = 'RM Delay (%)';
                                data = [10, 12, 15, 14, 16, 15];
                                activeMetricType = 'rm_delay';
                                break;
                            case 'Lead Time Dev':
                                label = 'Lead Time Deviation (Days)';
                                data = [2, 3, 3, 4, 2, 3];
                                activeMetricType = 'lead_time_dev';
                                break;
                            case 'Commit. Slips':
                                label = 'Commitment Slips';
                                data = [10, 11, 12, 13, 12, 12];
                                activeMetricType = 'commit_slips';
                                break;
                            case 'Est.CK Date':
                                label = 'Est. CK Date Change (Days)';
                                data = [5, 6, 6, 7, 5, 6];
                                activeMetricType = 'est_ck_date';
                                break;
                            case 'Ret. to Supplier':
                                label = 'Return to Supplier (%)';
                                data = [2, 2.5, 2.5, 3, 2.8, 2.5];
                                activeMetricType = 'ret_to_supplier';
                                break;
                            default:
                                label = 'PO Delay (%)';
                                data = [70, 75, 80, 78, 82, 80];
                                activeMetricType = 'po_delay';
                        }
                        kpiChart.data.datasets[0].label = label;
                        kpiChart.data.datasets[0].data = data;
                        kpiChart.update();
                    }
                    const orderno = $('#ocnDropdownSelected').text();
                    const buyer = $('#buyerFilter').val();
                    if (orderno) {
                        fetchMaterialData(formatOcn(orderno), buyer, activeMetricType);
                    }
                });
           


            function renderOcnDropdown(ocns) {
                const $list = $('#ocnDropdownList');
                $list.empty();
                if (!ocns.length) {
                    $list.append('<li class="dropdown-item text-muted">No OCN found</li>');
                    return;
                }
                ocns.forEach(ocn => {
                    $list.append(`<li><a href="#" class="dropdown-item ocn-option" data-ocn="${ocn}">${ocn.split("\\").pop().replace("OCN0", "")}</a></li>`);
                });
            }

            // When buyer changes, update OCN dropdown
            $('#buyerFilter').on('change', function() {
                var buyer = $(this).val();
                if (buyer && buyerOcnData[buyer]) {
                    $('#ocnDropdown').show();
                    renderOcnDropdown(buyerOcnData[buyer]);
                    $('#ocnDropdownSelected').text('Select OCN');
                } else {
                    $('#ocnDropdown').hide();
                }
            });

            // OCN search filter
            $(document).on('input', '#ocnSearchInput', function() {
                var search = $(this).val().toLowerCase();
                var buyer = $('#buyerFilter').val();
                var ocns = buyerOcnData[buyer] || [];
                var filtered = ocns.filter(ocn => ocn.toLowerCase().includes(search));
                renderOcnDropdown(filtered);
            });

            // OCN select
            $(document).on('click', '.ocn-option', function(e) {
                e.preventDefault();
                var ocn = $(this).data('ocn');
                $('#ocnDropdownSelected').text($(this).text()).data('ocn', ocn); // <-- Store OCN here
                $('#ocnDropdown').dropdown('hide');
                // Trigger your data fetch
                var buyer = $('#buyerFilter').val();
               
                //$('.ocn-option').removeClass('active');
                $('.metric-card').removeClass('active');
                activeMetricType = null;
                fetchMaterialData(ocn, buyer, activeMetricType);
            });

            // Hide default select
            $('#ocnFilter').hide();
            $('#ocnDropdown').show();


            $('#ret-supply').on('click', function() {
                // Get OCN number from the selected OCN in the dropdown
                var ocn = $('#ocnDropdownSelected').data('ocn');
                // var ocn = "GIL\\OCN04458"; // Example static OCN for testing
                // Fallback: If not set, try to get from the last clicked .ocn-option
                if (!ocn) {
                    ocn = $('.ocn-option.active').data('ocn');
                }
                // If still not found, show warning and return
                if (!ocn) {
                    toastr.warning('Please select an OCN before viewing Return to Supplier.');
                    return;
                }
                // Optional: Show loading indicator in modal
                $('#returnSupplierTbody').html('<tr><td colspan="7" class="text-center">Loading...</td></tr>');
                // Show modal
                $('#returnSupplierModal').modal('show');
                // AJAX call to fetch return to supplier data

                console.log('Fetching Return to Supplier data for OCN:', ocn); // Debug log
                $.ajax({
                    url: '/return-to-supply',
                    method: 'GET',
                    data: { orderno: ocn },
                    success: function(response) {
                        if (response.success && response.data && response.data.length > 0) {
                            var rows = response.data.map(function(item) {
                                return `
                                    <tr>
                                        <td>${item.Ret_No}</td>
                                        <td>${item.Ret_Date}</td>
                                        <td>${item.Supplier}</td>
                                        <td>${item.Item}</td>
                                        <td>${item.Color}</td>
                                        <td>${item.Size}</td>
                                        <td>${item.Ret_Qty}</td>
                                    </tr>
                                `;
                            }).join('');
                            $('#returnSupplierTbody').html(rows);
                        } else {
                            $('#returnSupplierTbody').html('<tr><td colspan="7" class="text-center">No data available</td></tr>');
                        }
                    },
                    error: function() {
                        $('#returnSupplierTbody').html('<tr><td colspan="7" class="text-center text-danger">Failed to load data</td></tr>');
                    }
                });
            });
           
        </script>
    </body>
</html><?php /**PATH C:\Apache24\htdocs\erpportal\resources\views/LifeAtGainup/Chart/raw_material_dashboard.blade.php ENDPATH**/ ?>