import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import react from '@vitejs/plugin-react';

export default defineConfig({
	server: {
		host: '127.0.0.1',
		port: 5175,
		strictPort: true,
		hmr: {
			host: '127.0.0.1',
			port: 5175,
			protocol: 'ws',
		},
	},
	plugins: [
		laravel({
			input: ['resources/ts/main.tsx'],
			refresh: true,
		}),
		tailwindcss(),
		react(),
	],
});
