<!doctype html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>APPLICANT REQUISITIES</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css -->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css -->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        @extends('Applicant.navbar')
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <form action="requiresEntrySave" class="was-validated" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-xxl-3">
                                                <h5 class="">Requires Entry</h5>
                                            </div>
                                        </div>

                                    </div>
                                    @if ($message = Session::get('savedMsg'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Requires</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif

                                    @if ($errors->any())
                                    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>

                                    <script>
                                        // Automatically close the alert after 3 seconds
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('ErrorAlert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 10000);
                                    </script>
                                    @endif

                                    @if ($message = Session::get('errorMsg'))

                                    <!-- Danger Alert -->

                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Requires</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    <?php
                                    $ATSApplicantRequiresEntry = Session('ATSApplicantRequiresEntry');

                                    ?>
                                    @if ($ATSApplicantRequiresEntry === "Y")
                                    <div class="card-body">
                                        <div class="row ">
                                            <div class="col-lg-4">
                                                <label for="" class="form-label">Candidate Name <span class="text-danger">*</span></label>
                                                <select class="form-control" id="canSelect" name="canID" required data-choices="" onchange="candiddetails()">
                                                    <option value="">Select Candidate</option>
                                                    @foreach($RequireCandidate as $candidate)
                                                    <option value="{{ $candidate['CanId'] }} | {{ $candidate['jobCompName'] }} | {{ $candidate['DeptName'] }} | {{ $candidate['jobCompCode'] }} | {{ $candidate['AppDeptCode'] }}">
                                                        {{ $candidate['ApplicantName'] }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">
                                                    Please select a Candidate.
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label for="job-title-Input" class="form-label">Company Name <span class="text-danger">*</span></label>
                                                    <input type="text" name="CompName" class="form-control" id="compName" value="" readonly required />
                                                    <input type="hidden" name="compId" class="form-control" id="compId" value="" readonly required />
                                                    <div class="invalid-feedback">
                                                        Please enter a Company.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label for="job-title-Input" class="form-label">Department Name <span class="text-danger">*</span></label>
                                                    <input type="text" name="deptName" class="form-control" id="deptName" value="" readonly required />
                                                    <input type="hidden" name="deptId" class="form-control" id="deptId" value="" readonly required />
                                                    <div class="invalid-feedback">
                                                        Please enter a Department.
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4 mb-2">
                                                    <input type="checkbox" id="replaceCheckbox" name="replaceCheckbox"> Replace
                                                </div>
                                            </div>

                                            <div class="row mt-2 replace-section" style="display: none;">
                                                <div class="col-lg-4 mb-2">
                                                    Replace Name
                                                </div>
                                                <div class="col-lg-4 mb-2">
                                                    <select name="replace" id="replace" class="form-control select2">
                                                        <option value="">--select name--</option>
                                                        @foreach ($ReplaceName as $Name)
                                                        <option value="{{$Name['Emplno']}}">{{$Name['Name']}}/{{$Name['tno']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <!-- HTML Structure -->
                                            <div class="row mt-2 requires-section">
                                                <div class="col-lg-4 mb-2">
                                                    Requires
                                                </div>
                                                <div class="col-lg-4 mb-2">
                                                    Available
                                                </div>
                                                <div class="col-lg-4 mb-2">
                                                    No of Items
                                                </div>
                                            </div>

                                            <div class="row" id="newRow">

                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="col-lg-12">
                                                <div class="hstack justify-content-end gap-2">
                                                    <button onclick="addRow()" type="button" id="addrow" class="btn btn-ghost-danger material-shadow-none"><i class="ri-add-box-line"></i> Add</button>
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                            </div>

                            </form>
                        </div>
                    </div>

                </div>
                <!-- minimum one row limit -->
                <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                                <button type="button" class="btn-close btn-close-dark" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                At least one row is required. You cannot delete the last row.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container-fluid -->
        </div>

        <!-- End Page-content -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-6">
                        <script>
                            document.write(new Date().getFullYear())
                        </script> © Gainup Industries .
                    </div>

                </div>
            </div>
        </footer>
    </div>
    <!-- end main content-->
    </div>

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->
    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- form wizard init -->
    <script src="Applicant/assets/js/pages/form-wizard.init.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/jquery-3.6.0.min.js"></script>

    <script src="Applicant/assets/js/app.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>


    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- REPLACED  -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add event listener to the replace checkbox
            var replaceCheckbox = document.getElementById('replaceCheckbox');
            if (replaceCheckbox) {
                replaceCheckbox.addEventListener('change', function() {
                    var requiresSection = document.querySelector('.requires-section');
                    var replaceSection = document.querySelector('.replace-section');
                    var newrow = document.querySelector('#newRow');
                    var addrow = document.querySelector('#addrow');

                    if (requiresSection && replaceSection) {
                        if (this.checked) {
                            requiresSection.style.display = 'none';
                            replaceSection.style.display = 'block';
                            newrow.style.display = 'none';
                            addrow.style.display = 'none';
                        } else {
                            requiresSection.style.display = 'flex';
                            replaceSection.style.display = 'none';
                            newrow.style.display = 'block';
                            addrow.style.display = 'block';

                        }
                    } else {
                        console.error('One or both of the sections not found.');
                    }
                });
            } else {
                console.error('Replace checkbox not found.');
            }
        });
    </script>


    <script>
        $(document).ready(function() {
            $('select.form-control').on('show.bs.select', function() {
                var windowHeight = $(window).height();
                var selectBottom = $(this).offset().top + $(this).outerHeight();
                var dropdownMenuHeight = $('.dropdown-menu').outerHeight();

                if (selectBottom + dropdownMenuHeight > windowHeight) {
                    $(this).closest('.col-xxl-6').addClass('dropup');
                }
            });
        });
    </script>
    <script>
        // Initialize row count
        var rowCount = 1;
        var selectedOptions = []; // Array to store selected options

        function addRow() {
            var container = document.getElementById('newRow');
            var newRow = document.createElement('div');
            newRow.classList.add('row', 'mt-3');
            newRow.innerHTML = `
        <div class="col-lg-4 mb-3">
            <div class="form-group">
                <select name="requiresId[]" class="form-control" data-choices="" onchange="removeSelectedOption(this)">
                    <option value="">--select--</option>
                    @foreach ($Requires as $Require)
                        <option value="{{ $Require['rowid'] }} " ${selectedOptions.includes('{{ $Require['rowid'] }}') ? 'disabled' : ''}>{{ $Require['reqName'] }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-lg-3 mb-3">
            <div class="form-group">
            <select name="available[]" class="form-select" data-choices="" >
                    <option value="No" selected>No</option>
                    <option value="Yes">Yes</option>
                    
                </select>
            </div>
        </div>
        <div class="col-lg-3 mb-3">
            <div class="form-group">
            <input type="number" name="noOfItem[]" class="form-control" id="compName" value="0"  required />
                
            </div>
        </div>
        <div class="col-lg-2 mb-3">
            <div class="form-group d-flex ">
            
                <button onclick="deleteRow(event, this)" class="delete-btn btn btn-danger ms-4"><i class="ri-delete-bin-line"></i></button>
            </div>
        </div>
    `;
            container.appendChild(newRow);
            initializeChoices(newRow.querySelector('[data-choices]'));

            // Add event listener to select element
            var selectElement = newRow.querySelector('select[name="requiresId[]"]');
            selectElement.addEventListener('change', function() {
                updateDescription(this);
            });

            rowCount++;
        }

        function updateDescription(selectElement) {
            var selectedOption = selectElement.options[selectElement.selectedIndex];
            // Check if the selectedOption exists and has the data-description attribute
            if (selectedOption && selectedOption.value) {
                var compName = selectedOption.value.split(' | ')[1]; // Extract the remarks
                var deptName = selectedOption.value.split(' | ')[2]; // Extract the remarks
                var textarea = selectElement.closest('.row').querySelector('textarea');

                textarea.value = compName;
                removeSelectedOption(selectElement); // Disable the option
            } else {
                // If the selected option does not have data-description, clear the textarea
                var textarea = selectElement.closest('.row').querySelector('textarea');
                textarea.value = 'no data';
            }
        }

        function deleteRow(event, button) {
            var row = button.closest('.row');
            var parentContainer = row.parentNode;
            // Check if there's only one row left
            if (parentContainer.children.length > 1) {
                // Remove the row
                parentContainer.removeChild(row);
                // Decrement row count
                rowCount--;
            } else {
                event.preventDefault();
                $('#minimumRowModal').modal('show');
            }
        }

        function initializeChoices(element) {
            var choices = new Choices(element, {
                removeItemButton: true,
            });
        }

        function removeSelectedOption(selectElement) {
            var selectedValue = selectElement.value.split(' | ')[0]; // Extract the rowid
            selectedOptions.push(selectedValue);
            var allSelects = document.querySelectorAll('select[name="evalPoints[]"]');
            allSelects.forEach(function(select) {
                var options = select.options;
                for (var i = 0; i < options.length; i++) {
                    if (options[i].value.split(' | ')[0] === selectedValue) {
                        options[i].style.display = 'none'; // Hide the option
                    }
                }
            });
        }

        function enableOption(textarea) {
            var row = textarea.closest('.row');
            var select = row.querySelector('select[name="evalPoints[]"]');
            var selectedValue = select.value.split(' | ')[0]; // Extract the rowid
            var allSelects = document.querySelectorAll('select[name="evalPoints[]"]');
            allSelects.forEach(function(select) {
                var options = select.options;
                for (var i = 0; i < options.length; i++) {
                    if (options[i].value.split(' | ')[0] === selectedValue) {
                        options[i].disabled = false; // Enable the option
                    }
                }
            });
        }

        initializeChoices(document.querySelector('[data-choices]'));
        addRow();
    </script>

    <script>
        $(document).ready(function() {
            $('#canSelect').on('change', function() {
                let canValue = $("#canSelect").val();
                let compName = canValue.split(' | ')[1];
                let deptName = canValue.split(' | ')[2];
                let compId = canValue.split(' | ')[3];
                let deptId = canValue.split(' | ')[4];

                $("#compName").val(compName);
                $("#deptName").val(deptName);
                $("#compId").val(compId);
                $("#deptId").val(deptId);
            });
        });
    </script>
    @endsection
</body>



</html>