<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">


<!-- Mirrored from themesbrand.com/velzon/html/master/apps-job-details.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:47:53 GMT -->

<head>

    <meta charset="utf-8" />
    <title>Apply Job</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <meta name="robots" content="noindex, nofollow">
    
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />

    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <style>
        .PContactNo {
            width: 150px !important;
        }

        .preCompAttach {
            width: 150px !important;

        }

        .page-content {
            padding: 30px;
        }

        .footer {
            position: static;
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="page-content">
            <div class="container-fluid">
                <div class="row ">
                    <div class="card p-2">
                        <div class="d-md-flex justify-content-between">
                            <div class="col-xxl-8 col-md-6">
                                <div class="search-box">
                                    <input type="text" class="form-control search bg-light border-light" id="searchJob" autocomplete="off" oninput="convertToUppercase(this)" placeholder="Search for jobs or companies..." />
                                    <i class="ri-search-line search-icon"></i>
                                </div>

                            </div>
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            @if(\Route::currentRouteName() == 'Applyjob')
                            <div>
                                <button type="button" class="btn btn-light" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="d-flex align-items-center">
                                        USERNAME :
                                        <span class="text-start ms-xl-2">
                                            <span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text">
                                                <?php $userName = Session::get('userName');
                                                echo $userName; ?>
                                            </span>
                                        </span>
                                    </span>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <a class="dropdown-item" href="SignInApply">
                                        <i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i>
                                        <span class="align-middle" data-key="t-logout">Logout</span>
                                    </a>
                                </div>
                            </div>
                            @endif

                            <div>
                                @if(\Route::currentRouteName() == 'SignApply')
                                <a href="SignIn" class="btn btn-primary">Applied Status</a>
                                @endif
                                @if(\Route::currentRouteName() == 'Applyjob')
                                <a href="candidateSts" class="btn btn-primary">Applied Status</a>
                                @endif
                            </div>
                            <div class="col-xxl-10 col-md-5 d-none " id="found-job-alert">
                                <div class="alert alert-success mb-0 text-center" role="alert">
                                    <strong id="total-result">0</strong>
                                    jobs found
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 mt-5">
                        <!-- end card -->
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->

                <div class="row mt-n5">
                    <div class="col-xxl-9">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-grow-1">
                                        <h5 class="mb-0"> Jobs</h5>
                                    </div>

                                </div>
                            </div>
                            @if ($message = Session::get('Success'))
                            <div id="alert" class="alert alert-info alert-dismissible fade show material-shadow" style="z-index: 1; margin-left:auto;" role="alert">
                                Welcome <b> Back😊.</b>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>

                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('alert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 10000);
                            </script>
                            @endif
                            @if ($message = Session::get('applySuccess'))
                            <div id="alert" class="alert alert-info alert-dismissible fade show material-shadow" style="z-index: 1; margin-left:auto;" role="alert">
                                Applied <b> Successfully.</b>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>

                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('alert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 10000);
                            </script>
                            @endif

                            @if ($errors->any())
                            <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show material-shadow" style="z-index: 1; margin-left:auto;" role="alert">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>

                            <script>
                                // Automatically close the alert after 3 seconds
                                setTimeout(function() {
                                    var successAlert = document.getElementById('ErrorAlert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 20000);
                            </script>
                            @endif

                            @if ($message = Session::get('applyerrorMsg'))
                            <div id="alert" class="alert alert-danger alert-dismissible fade show material-shadow" style="z-index: 1; margin-left:auto;" role="alert">
                                Did not <b> Applied.</b>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>

                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('alert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 10000);
                            </script>
                            @endif

                            @foreach ($joblist as $joblists)
                            <div class="col-xl-4">
                                <div class="card">
                                    <div class="card-body">
                                        <button type="button" class="btn btn-icon btn-soft-primary float-end" data-bs-toggle="button" aria-pressed="true"><i class="mdi mdi-cards-heart fs-16"></i></button>
                                        <div class="avatar-sm mb-4">
                                            <div class="avatar-title bg-secondary-subtle rounded">
                                                <img src="{{$joblists['img2']}}" alt="" class="avatar-xxs" />
                                            </div>
                                        </div>
                                        <a href="#!">
                                            <h5>{{$joblists['jobTitle']}} </h5>
                                        </a>
                                        <p class="text-muted">{{$joblists['mainCompName']}}</p>

                                        <div class="d-flex gap-4 mb-3">
                                            <div>
                                                <i class="ri-map-pin-2-line text-primary me-1 align-bottom"></i> {{$joblists['location']}}
                                            </div>

                                            <div>
                                                <i class="ri-time-line text-primary me-1 align-bottom"></i>
                                                {{ \Carbon\Carbon::parse($joblists['Edate'])->format('d-M-Y') }}
                                            </div>
                                        </div>

                                        <p class="text-muted">{{$joblists['remarks']}}</p>

                                        <div class="hstack gap-2">
                                            <span class="badge bg-success-subtle text-success">{{$joblists['DeptName']}}</span>

                                        </div>

                                        <div class="mt-4 hstack gap-2">
                                            @if(\Route::currentRouteName() == 'Applyjob')
                                            <!-- <a href="#!" class="btn btn-soft-primary w-100 applyjob-list" data-bs-toggle="modal" data-bs-target="#ApplyJob" data-job-details="{{$joblists['jobTitle']}}|{{$joblists['DeptName']}}|{{$joblists['img1']}}|{{$joblists['img2']}}|{{$joblists['Rowid']}}|{{$joblists['departmentid']}}">Apply Job</a> -->

                                            <a href="#!" class="btn btn-soft-primary w-100 applyjob-list" onclick="detailsfetch('{{ $joblists['Rowid'] }}')" data-job-details="{{$joblists['jobTitle']}}|{{$joblists['DeptName']}}|{{$joblists['img1']}}|{{$joblists['img2']}}|{{$joblists['Rowid']}}|{{$joblists['departmentid']}}">Apply Job</a>
                                            @endif
                                            @if(\Route::currentRouteName() == 'SignApply')
                                            <a href="SignIn" class="btn btn-soft-primary w-100">Apply Job</a>
                                            @endif
                                            <a href="#!" class="btn btn-soft-success w-100 viewjob-list" data-bs-toggle="modal" data-bs-target="#OverView" data-job-details="{{$joblists['jobTitle']}}|{{$joblists['DeptName']}}|{{$joblists['experience']}}|{{$joblists['no_of_vac']}}|{{$joblists['location']}}|{{$joblists['salary']}}|{{$joblists['skills']}}|{{$joblists['img1']}}|{{$joblists['img2']}}|{{$joblists['remarks']}}|{{$joblists['grpDis']}}|{{$joblists['aptitude']}}|{{$joblists['techical']}}|{{$joblists['persInter']}}|{{$joblists['hrName']}}|{{$joblists['techIntName']}}|{{$joblists['techfinalName']}}|{{$joblists['finalIntName']}}|{{$joblists['CompName']}}|{{$joblists['intCompName']}}|{{$joblists['intDeptName']}}|{{$joblists['mainCompName']}}|{{$joblists['Edate']}}|{{$joblists['hrRound']}}|{{$joblists['tech1Final']}}">
                                                Overview

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-xxl-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="avatar-sm mx-auto">
                                    <div class="avatar-title bg-warning-subtle rounded">
                                        <img src="Applicant/assets/images/companies/img-3.png" alt="" class="avatar-xxs">
                                    </div>
                                </div>
                                <div class="text-center">
                                    <a href="#!">
                                        <h5 class="mt-3">gainup Industries</h5>
                                    </a>
                                    <p class="text-muted">Sustained Quality</p>
                                </div>

                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <tbody>
                                            <tr>
                                                <td class="fw-medium">Company Size</td>
                                                <td>5+</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-medium">Industry Type</td>
                                                <td>Textile</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-medium">Founded in</td>
                                                <td>2003</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-medium">Phone</td>
                                                <td>+91-4543-269000</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-medium">Email</td>
                                                <td>info@gainup.in</td>
                                            </tr>
                                            <!-- <tr>
                                                    <td class="fw-medium">Social media</td>
                                                    <td>
                                                        <ul class="list-inline mb-0">
                                                            <li class="list-inline-item">
                                                                <a href="#!"><i class="ri-whatsapp-line"></i></a>
                                                            </li>
                                                            <li class="list-inline-item">
                                                                <a href="#!"><i class="ri-facebook-line"></i></a>
                                                            </li>
                                                            <li class="list-inline-item">
                                                                <a href="#!"><i class="ri-twitter-line"></i></a>
                                                            </li>
                                                            <li class="list-inline-item">
                                                                <a href="#!"><i class="ri-youtube-line"></i></a>
                                                            </li>
                                                        </ul>
                                                    </td>
                                                </tr> -->
                                        </tbody>
                                    </table>
                                    <!--end table-->
                                </div>
                            </div>
                        </div>
                        <!--end card-->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Job Location</h5>
                            </div>
                            <div class="card-body">
                                <div class="ratio ratio-4x3">
                                    <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d3926.628746331818!2d77.80322817325523!3d10.2107734693761!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sin!4v1704518022575!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            </div>
                        </div>
                        <!--end card-->
                        <!-- <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Contact Us</h5>
                                </div>
                                <div class="card-body">
                                    <form>
                                        <div class="mb-3">
                                            <label for="nameInput" class="form-label">Name</label>
                                            <input type="text" class="form-control" id="nameInput" oninput="convertToUppercase(this)"  placeholder="Enter your name">
                                        </div>
                                        <div class="mb-3">
                                            <label for="emailInput" class="form-label">Email</label>
                                            <input type="text" class="form-control" id="emailInput" oninput="convertToUppercase(this)"  placeholder="Enter your email">
                                        </div>
                                        <div class="mb-3">
                                            <label for="messageInput" class="form-label">Message</label>
                                            <textarea class="form-control" id="messageInput" rows="3" oninput="convertToUppercase(this)"  placeholder="Message"></textarea>
                                        </div>
                                        <div class="text-end">
                                            <button type="submit" class="btn btn-primary">Send Message</button>
                                        </div>
                                    </form>
                                </div>
                            </div> -->
                        <!--end card-->
                    </div>
                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-6">
                        <script>
                            document.write(new Date().getFullYear())
                        </script> © Gainup Industries.
                    </div>
                    <!-- <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">
                                Design & Develop by Sakthi
                            </div>
                        </div> -->
                </div>
            </div>
        </footer>
    </div>
    <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <div class="modal fade" id="ApplyJob" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content border-0">
                <form id="applicantSave" method="post" autocomplete="off" class="was-validated" novalidate enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="Applicant/assets/images/small/img-9.jpg" alt="" id="modal-cover-imgA" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white" id="exampleModalLabel">
                                                    Apply Job
                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">
                                                    <div>
                                                        <!-- <label for="cover-image-input" class="mb-0" data-bs-toggle="tooltip" data-bs-placement="top" title="Select Cover Image">
                                                            <div class="avatar-xs">
                                                                <div class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                                    <i class="ri-image-fill"></i>
                                                                </div>
                                                            </div>
                                                        </label> -->
                                                        <!-- <input class="form-control d-none" value="" id="cover-image-input" type="file" name="backImg" accept="image/png, image/gif, image/jpeg" required /> -->
                                                        <input id="backImage-inputH" type="hidden" name="backImgH" />
                                                        <input id="profileImage-inputH" type="hidden" name="ProfileImgH" />
                                                    </div>
                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">
                                        <div class="position-absolute bottom-0 end-0">
                                            <label for="companylogo-image-input" class="mb-0" data-bs-toggle="tooltip" data-bs-placement="right" title="Select Image">
                                                <div class="avatar-xs cursor-pointer">
                                                    <div class="avatar-title bg-light border rounded-circle text-muted">
                                                        <i class="ri-image-fill"></i>
                                                    </div>
                                                </div>
                                            </label>
                                            <input class="form-control d-none" value="" id="companylogo-image-input" type="file" name="ProfileImg" accept="image/png, image/gif, image/jpeg" required />
                                        </div>
                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="Applicant/assets/images/users/multi-user.jpg" id="companylogo-imgA" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3">
                                        upload Your Image<span class="text-danger">*</span>
                                    </h5>
                                    <?php if (old('applicantName')) : ?>
                                        <div id="altermessage" class="alert alert-danger position-relative" style="color: red;">
                                            <span class="d-block text-center">ALL FILES HAVE BEEN REMOVED. IF NECESSARY, ADD THOSE FILES.</span>
                                            <button type="button" class="btn-close position-absolute top-0 end-0 m-2" aria-label="Close" onclick="document.getElementById('altermessage').remove()"></button>
                                        </div>
                                        <script>
                                            // Automatically close the alert after 3 seconds
                                            setTimeout(function() {
                                                var successAlert = document.getElementById('altermessage');
                                                if (successAlert) {
                                                    successAlert.remove();
                                                }
                                            }, 40000);
                                        </script>
                                    <?php endif; ?>
                                </div>

                            </div>

                            <div class="form-steps">
                                <div class="step-arrow-nav mb-4">
                                    <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="steparrow-gen-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-gen-info" type="button" role="tab" aria-controls="steparrow-gen-info" aria-selected="true">
                                                General
                                            </button>
                                        </li>

                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="steparrow-famEdu-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-famEdu-info" type="button" role="tab" aria-controls="steparrow-famEdu-info" aria-selected="false">
                                                Experience Education & Family
                                            </button>
                                        </li>
                                    </ul>
                                </div>

                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="steparrow-gen-info" role="tabpanel" aria-labelledby="steparrow-gen-info-tab">
                                        <div>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="jobPosition">Position<span class="text-danger">*</span></label>
                                                        <input type="text" name="jobName" class="form-control " id="jobPosition" required readonly />
                                                        <input type="hidden" name="Jposition" class="form-control " id="jobPositionH" required />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter an
                                                            position
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="JobDept">
                                                            Department<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="JobDept" oninput="convertToUppercase(this)" placeholder="Enter user name" required readonly name="jobDepartment" />
                                                        <input type="hidden" class="form-control" id="JobDeptH" required readonly name="Jdepartment" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Department
                                                            name
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Applicant Name<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter user name" oninput="convertToUppercase(this)" required name="applicantName" value="{{ old('applicantName') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            user
                                                            name
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Aadhar No<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter Aadhar No" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="12" name="aadharNo" value="{{ old('aadharNo') }}" />

                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            aadhar no
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Date of birth<span class="text-danger">*</span></label>
                                                        <input type="date" class="form-control" id="steparrow-gen-info-username-input" name="DOB" required value="{{ old('DOB') }}" max="<?= date('Y-m-d'); ?>" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            select a
                                                            DOB
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Gender<span class="text-danger">*</span></label>
                                                        <select name="gender" id="" class="form-control">
                                                            <option value="M" {{ old('gender') == 'M' ? 'selected' : '' }}>Male</option>
                                                            <option value="F" {{ old('gender') == 'F' ? 'selected' : '' }}>Female</option>
                                                        </select>
                                                        <div class="invalid-feedback">
                                                            Please
                                                            select a
                                                            gender
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Marriage Details<span class="text-danger">*</span></label>
                                                        <select class="form-control mb-3" aria-label="Default select example" required name="MarriageDetails">
                                                            <option value="Single" {{ old('MarriageDetails') == 'Single' ? 'selected' : '' }} selected>Single</option>
                                                            <option value="Married" {{ old('MarriageDetails') == 'Married' ? 'selected' : '' }}>Married</option>

                                                        </select>
                                                        <div class="invalid-feedback">
                                                            Please
                                                            select a
                                                            detail
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Blood Group<span class="text-danger">*</span></label>
                                                        <select class="form-control mb-3" aria-label="Default select " required name="bloodGroup">
                                                            <option>--select--</option>
                                                            <option value="A+" {{ old('bloodGroup') == 'A+' ? 'selected' : '' }}>A+</option>
                                                            <option value="A-" {{ old('bloodGroup') == 'A-' ? 'selected' : '' }}>A-</option>
                                                            <option value="B+" selected {{ old('bloodGroup') == 'B+' ? 'selected' : '' }}>B+</option>
                                                            <option value="B-" {{ old('bloodGroup') == 'B-' ? 'selected' : '' }}>B-</option>
                                                            <option value="O+" {{ old('bloodGroup') == 'O+' ? 'selected' : '' }}>O+</option>
                                                            <option value="O-" {{ old('bloodGroup') == 'O-' ? 'selected' : '' }}>O-</option>
                                                            <option value="AB+" {{ old('bloodGroup') == 'AB+' ? 'selected' : '' }}>AB+</option>
                                                            <option value="AB-" {{ old('bloodGroup') == 'AB-' ? 'selected' : '' }}>AB-</option>
                                                        </select>
                                                        <div class="invalid-feedback">
                                                            Please
                                                            select a
                                                            blood group
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Contact No<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter contact No" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="AContactNo" value="{{old('AContactNo') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            contact No
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Email Id<span class="text-danger">*</span></label>
                                                        <input type="email" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter Email Id" required name="AemailId" value="{{old('AemailId') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Email Id
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Father/Husband Name<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="steparrow-gen-info-username-input" oninput="convertToUppercase(this)" placeholder="Enter Father/Husband Name" required name="Father_HusName" value="{{old('Father_HusName') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Father/Husband Name
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Family Contact No<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter Contact No" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="father_husContactNo" value="{{old('father_husContactNo') }}" />

                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Father/Husband Contact No
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="resumeAttach">
                                                            Resume Attachment<span class="text-danger">*</span>
                                                        </label>
                                                        <input type="file" class="form-control" id="resumeAttach" name="resumeAttach" {{ old('resumeAttach') ? '' : 'required' }} />
                                                        <div class="invalid-feedback">
                                                            Please attach a resume
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div>
                                                        <label for="website-field" class="form-label">Skills<span class="text-danger">*</span></label>
                                                        <input class="form-control" name="skills" id="choices-text-unique-values" oninput="convertToUppercase(this)" data-choices data-choices-text-unique-true type="text" value="{{old('skills') }}" required />
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="steparrow-gen-info-username-input">
                                                            Expected Salary<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="steparrow-gen-info-username-input" placeholder="Enter expected salary" required name="ExpSalary" value="{{old('ExpSalary') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Expected Salary
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-center mb-2  gap-3 mt-4">
                                            <button type="button" class="btn btn-success btn-label  right  ">
                                                <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Address
                                            </button>
                                        </div>
                                        <div>
                                            <div class="row mb-3">
                                                <div class="col-lg-6">
                                                    <h5>Permanant Address</h5>
                                                </div>
                                                <div class="col-lg-6"></div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="street">Street<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="street" oninput="convertToUppercase(this)" placeholder="Enter Street Name" required name="Pstreet" value="{{old('Pstreet') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter an
                                                            Street
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="location">
                                                            Location<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="location" oninput="convertToUppercase(this)" placeholder="Enter Location
                                                        " required name="Plocation" value="{{old('Plocation') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Location
                                                            name
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="taluk">
                                                            Taluk<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="taluk" oninput="convertToUppercase(this)" placeholder="Enter Taluk" required name="Ptaluk" value="{{old('Ptaluk') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Taluk
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="district">
                                                            District<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="district" oninput="convertToUppercase(this)" placeholder="Enter District" required name="Pdistrict" value="{{old('Pdistrict') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            District
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="state">
                                                            State<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="state" oninput="convertToUppercase(this)" placeholder="Enter State" required name="Pstate" value="{{old('Pstate') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            State
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="country">
                                                            Country<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="country" placeholder="Enter Country" required value="INDIA" readonly name="Pcountry" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Country
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="pincode">
                                                            Pincode<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="pincode" placeholder="Enter Pincode" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="6" name="Ppincode" value="{{old('Ppincode') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Pincode
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6"></div>

                                                <div class="col-lg-6 mb-3">
                                                    <h5>Current Address</h5>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="copyAddressCheckbox" onclick="copyAddress()">

                                                        <label class="form-check-label" for="formCheck2">
                                                            Same as Permanant Address
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cStreet">Street<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cStreet" oninput="convertToUppercase(this)" placeholder="Enter Street Name" required name="Cstreet" value="{{old('Cstreet') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter an
                                                            Street
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cLocation">
                                                            Location<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cLocation" oninput="convertToUppercase(this)" placeholder="Enter Location
                                                        " required name="Clocation" value="{{old('Clocation') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Location
                                                            name
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cTaluk">
                                                            Taluk<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cTaluk" oninput="convertToUppercase(this)" placeholder="Enter Taluk" required name="Ctaluk" value="{{old('Ctaluk') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Taluk
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cDistrict">
                                                            District<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cDistrict" oninput="convertToUppercase(this)" placeholder="Enter District" required name="Cdistrict" value="{{old('Cdistrict') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            District
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cState">
                                                            State<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cState" oninput="convertToUppercase(this)" placeholder="Enter State" required name="Cstate" value="{{old('Cstate') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            State
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cCountry">
                                                            Country<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="cCountry" oninput="convertToUppercase(this)" placeholder="Enter Country" required name="Ccountry" value="{{old('Ccountry') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Country
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cPincode">
                                                            Pincode<span class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="cPincode" oninput="convertToUppercase(this)" placeholder="Enter Pincode" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="6" name="Cpincode" value="{{old('Cpincode') }}" />
                                                        <div class="invalid-feedback">
                                                            Please
                                                            enter a
                                                            Pincode
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="d-flex align-items-start gap-3 mt-4">


                                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="steparrow-famEdu-info-tab">
                                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Go to Education & Family Details
                                                </button>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="steparrow-famEdu-info" role="tabpanel" aria-labelledby="steparrow-famEdu-info-tab">
                                        <div>
                                            <div class="row mb-3">
                                                <div class="col-lg-6">
                                                    <h5>Education Details </h5>
                                                </div>
                                                <div class="col-lg-6"></div>
                                                <div class="col-lg-12">
                                                    <div class="table-responsive">
                                                        <table class="table caption-top table-nowrap">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th scope="col">Education (Any one Details is must)<span class="text-danger">*</span></th>
                                                                    <th scope="col">Branch/STD<span class="text-danger">*</span></th>
                                                                    <th scope="col">College/School<span class="text-danger">*</span></th>
                                                                    <th scope="col">University/State Board<span class="text-danger">*</span></th>
                                                                    <th scope="col">Percentage(%)<span class="text-danger">*</span></th>
                                                                    <th scope="col">YearOfCompletion<span class="text-danger">*</span></th>
                                                                    <th scope="col">Attachment</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="eduTBody">
                                                                <tr>
                                                                    <th scope="row">
                                                                        <select class="form-control mb-6" required name="education[]">
                                                                            <option value="">--Select Education--</option>
                                                                            <option value="SSLC" {{ old('education.0') == 'SSLC' ? 'selected' : '' }}>SSLC</option>
                                                                            <option value="HSC" {{ old('education.0') == 'HSC' ? 'selected' : '' }}>HSC</option>
                                                                            <option value="COLLEGE" {{ old('education.0') == 'COLLEGE' ? 'selected' : '' }}>COLLEGE</option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select an education
                                                                        </div>
                                                                    </th>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter Branch" required name="branch[]" value="{{ old('branch.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a branch
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter College/School" required name="S_C[]" value="{{ old('S_C.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter College/School
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter University/State Board" required name="U_S[]" value="{{ old('U_S.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter University/State
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter percentage" required maxlength="3" name="percentage[]" value="{{ old('percentage.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a percentage
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter year of completion" required name="yearOfComplition[]" value="{{ old('yearOfComplition.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a year of completion
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="file" class="form-control" name="eduAttach[]" />
                                                                    </td>

                                                                </tr>
                                                                @foreach (array_slice(old('education', []), 1) as $index => $education)
                                                                <tr>
                                                                    <th scope="row">
                                                                        <select class="form-control mb-6" required name="education[]">
                                                                            <option value="">--Select Education--</option>
                                                                            <option value="SSLC" {{ old('education.' . ($index + 1)) == 'SSLC' ? 'selected' : '' }}>SSLC</option>
                                                                            <option value="HSC" {{ old('education.' . ($index + 1)) == 'HSC' ? 'selected' : '' }}>HSC</option>
                                                                            <option value="COLLEGE" {{ old('education.' . ($index + 1)) == 'COLLEGE' ? 'selected' : '' }}>COLLEGE</option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select an education
                                                                        </div>
                                                                    </th>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter Branch" required name="branch[]" value="{{ old('branch.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a branch
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter College/School" required name="S_C[]" value="{{ old('S_C.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter College/School
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter University/State Board" required name="U_S[]" value="{{ old('U_S.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter University/State
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter percentage" required maxlength="3" name="percentage[]" value="{{ old('percentage.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a percentage
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" oninput="convertToUppercase(this)" placeholder="Enter year of completion" required name="yearOfComplition[]" value="{{ old('yearOfComplition.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter a year of completion
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="file" class="form-control" name="eduAttach[]" />
                                                                    </td>
                                                                    <td>
                                                                        <button class="btn btn-danger delete-row">-</button>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            <tfoot class="table-light">
                                                                <tr>
                                                                    <td colspan="5">Add Row</td>
                                                                    <td><button class="btn btn-primary add-row">+</button></td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>


                                                <div class="col-lg-6 mb-3">
                                                    <h5>Family Details</h5>
                                                </div>
                                                <div class="col-lg-6">

                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="table-responsive">
                                                        <table class="table caption-top table-nowrap">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th scope="col">Name<span class="text-danger">*</span></th>
                                                                    <th scope="col">Type<span class="text-danger">*</span></th>
                                                                    <th scope="col">Occupation<span class="text-danger">*</span></th>
                                                                    <th scope="col">Age<span class="text-danger">*</span></th>
                                                                    <th scope="col">Contact No</th>
                                                                </tr>
                                                            </thead>

                                                            <tbody id="FamTBody">
                                                                <tr>
                                                                    <th scope="row">
                                                                        <input type="text" class="form-select" id="" oninput="convertToUppercase(this)" placeholder="Enter Relation name" required name="relName[]" value="{{ old('relName.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please select
                                                                        </div>
                                                                    </th>
                                                                    <td>

                                                                        <select class="form-select mb-3" name="relType[]">
                                                                            <!-- <option value=""> --Select relation type -- </option> -->
                                                                            <option value="Brother" {{ old('relType.0') == 'Brother' ? 'selected' : '' }}> Brother </option>
                                                                            <option value="Brother In Law" {{ old('relType.0') == 'Brother In Law' ? 'selected' : '' }}> Brother In Law </option>
                                                                            <option value="Daughter" {{ old('relType.0') == 'Daughter' ? 'selected' : '' }}> Daughter </option>
                                                                            <option value="Daughter In Law" {{ old('relType.0') == 'Daughter In Law' ? 'selected' : '' }}> Daughter In Law </option>
                                                                            <option value="Father" {{ old('relType.0') == 'Father' ? 'selected' : '' }} selected> Father </option>
                                                                            <option value="Father In Law" {{ old('relType.0') == 'Father In Law' ? 'selected' : '' }}> Father In Law </option>
                                                                            <option value="Grandfather" {{ old('relType.0') == 'Grandfather' ? 'selected' : '' }}> Grandfather </option>
                                                                            <option value="Grandmother" {{ old('relType.0') == 'Grandmother' ? 'selected' : '' }}> Grandmother </option>
                                                                            <option value="Husband" {{ old('relType.0') == 'Husband' ? 'selected' : '' }}> Husband </option>
                                                                            <option value="Mother" {{ old('relType.0') == 'Mother' ? 'selected' : '' }}> Mother </option>
                                                                            <option value="Mother In Law" {{ old('relType.0') == 'Mother In Law' ? 'selected' : '' }}> Mother In Law</option>
                                                                            <option value="Sister" {{ old('relType.0') == 'Sister' ? 'selected' : '' }}> Sister </option>
                                                                            <option value="Sister In Law" {{ old('relType.0') == 'Sister In Law' ? 'selected' : '' }}> Sister In Law</option>
                                                                            <option value="Son" {{ old('relType.0') == 'Son' ? 'selected' : '' }}> Son </option>
                                                                            <option value="Uncle" {{ old('relType.0') == 'Uncle' ? 'selected' : '' }}> Uncle </option>
                                                                            <option value="Wife" {{ old('relType.0') == 'Wife' ? 'selected' : '' }}> Wife </option>
                                                                        </select>

                                                                        <div class="invalid-feedback">
                                                                            Please select a type
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter occupation" required name="relOccupation[]" value="{{ old('relOccupation.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter occupation
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter Age" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relAge[]" value="{{ old('relAge.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter Age
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter contactno" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relContactNo[]" value="{{ old('relContactNo.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter contactNo
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                @foreach (array_slice(old('relType', []), 1) as $index => $relType)
                                                                <tr>
                                                                    <th scope="row">
                                                                        <input type="text" class="form-select" id="" oninput="convertToUppercase(this)" placeholder="Enter Relation name" required name="relName[]" value="{{ old('relName.0') }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please select
                                                                        </div>
                                                                    </th>
                                                                    <td>

                                                                        <select class="form-select mb-3" name="relType[]">
                                                                            <!-- <option value=""> --Select relation type -- </option> -->
                                                                            <option value="Brother" {{ old('relType.' . ($index + 1)) == 'Brother' ? 'selected' : '' }}> Brother </option>
                                                                            <option value="Brother In Law" {{ old('relType.' . ($index + 1)) == 'Brother In Law' ? 'selected' : '' }}> Brother In Law </option>
                                                                            <option value="Daughter" {{ old('relType.' . ($index + 1)) == 'Daughter' ? 'selected' : '' }}> Daughter </option>
                                                                            <option value="Daughter In Law" {{ old('relType.' . ($index + 1)) == 'Daughter In Law' ? 'selected' : '' }}> Daughter In Law </option>
                                                                            <option value="Father" {{ old('relType.' . ($index + 1)) == 'Father' ? 'selected' : '' }} selected> Father </option>
                                                                            <option value="Father In Law" {{ old('relType.' . ($index + 1)) == 'Father In Law' ? 'selected' : '' }}> Father In Law </option>
                                                                            <option value="Grandfather" {{ old('relType.' . ($index + 1)) == 'Grandfather' ? 'selected' : '' }}> Grandfather </option>
                                                                            <option value="Grandmother" {{ old('relType.' . ($index + 1)) == 'Grandmother' ? 'selected' : '' }}> Grandmother </option>
                                                                            <option value="Husband" {{ old('relType.' . ($index + 1)) == 'Husband' ? 'selected' : '' }}> Husband </option>
                                                                            <option value="Mother" {{ old('relType.' . ($index + 1)) == 'Mother' ? 'selected' : '' }}> Mother </option>
                                                                            <option value="Mother In Law" {{ old('relType.' . ($index + 1)) == 'Mother In Law' ? 'selected' : '' }}> Mother In Law</option>
                                                                            <option value="Sister" {{ old('relType.' . ($index + 1)) == 'Sister' ? 'selected' : '' }}> Sister </option>
                                                                            <option value="Sister In Law" {{ old('relType.' . ($index + 1)) == 'Sister In Law' ? 'selected' : '' }}> Sister In Law</option>
                                                                            <option value="Son" {{ old('relType.' . ($index + 1)) == 'Son' ? 'selected' : '' }}> Son </option>
                                                                            <option value="Uncle" {{ old('relType.' . ($index + 1)) == 'Uncle' ? 'selected' : '' }}> Uncle </option>
                                                                            <option value="Wife" {{ old('relType.' . ($index + 1)) == 'Wife' ? 'selected' : '' }}> Wife </option>
                                                                        </select>

                                                                        <div class="invalid-feedback">
                                                                            Please select a type
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter occupation" required name="relOccupation[]" value="{{ old('relOccupation.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter occupation
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter Age" required oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relAge[]" value="{{ old('relAge.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter Age
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" id="" oninput="convertToUppercase(this)" placeholder="Enter contactno" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relContactNo[]" value="{{ old('relContactNo.' . ($index + 1)) }}" />
                                                                        <div class="invalid-feedback">
                                                                            Please enter contactNo
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            <tfoot class="table-light">
                                                                <tr>
                                                                    <td colspan="5">Add Row</td>
                                                                    <td><button class="btn btn-primary add-row1">+</button></td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="row">
                                                <div class="col-lg-6 mb-3">
                                                    <h5>Known Languages</h5>
                                                </div>
                                                <div class="col-lg-6"></div>
                                                <div class="col-lg-12">
                                                    <div class="table-responsive">
                                                        <table class="table caption-top table-nowrap">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th scope="col">Language<span class="text-danger">*</span></th>
                                                                    <th scope="col">Level<span class="text-danger">*</span></th>
                                                                    <th scope="col">Read<span class="text-danger">*</span></th>
                                                                    <th scope="col">Write<span class="text-danger">*</span></th>
                                                                    <th scope="col">Speak<span class="text-danger">*</span></th>

                                                                </tr>
                                                            </thead>
                                                            <tbody id="langBody">
                                                                <tr>
                                                                    <th scope="row">
                                                                        <select class="form-select mb-3" aria-label="Default select example" required name="language[]">
                                                                            <option>--Select Language--</option>
                                                                            <option value="Tamil" selected>Tamil</option>
                                                                            <option value="English">English</option>
                                                                            <option value="Hindi">Hindi</option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select an education
                                                                        </div>
                                                                    </th>
                                                                    <td>
                                                                        <select class="form-select mb-3" required name="langLevel[]">
                                                                            <option> --Select Level -- </option>
                                                                            <option value="Beginner" selected> Beginner </option>
                                                                            <option value="intermediate"> intermediate </option>
                                                                            <option value="High"> High </option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select Level
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-check mb-2">
                                                                            <!-- <input class="form-check-input" type="checkbox" id="formCheck1" value="N" name="[]" onchange="updateCheckboxValue(this)">
                                                                            <label class="form-check-label" for="formCheck1">
                                                                                Read
                                                                            </label> -->

                                                                            <select class="form-select mb-3" required name="langRead[]">
                                                                                <option value="Yes" selected> Yes </option>
                                                                                <option value="No"> No </option>

                                                                            </select>
                                                                            <div class="invalid-feedback">
                                                                                Please select option
                                                                            </div>
                                                                        </div>

                                                                    </td>
                                                                    <td>

                                                                        <select class="form-select mb-3" required name="langWrite[]">
                                                                            <option value="Yes" selected> Yes </option>
                                                                            <option value="No"> No </option>

                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select option
                                                                        </div>
                                                                    </td>
                                                                    <td>

                                                                        <select class="form-select mb-3" required name="langSpeak[]">
                                                                            <option value="Yes" selected> Yes </option>
                                                                            <option value="No"> No </option>

                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select option
                                                                        </div>
                                                                    </td>

                                                                </tr>
                                                                @foreach (array_slice(old('language', []), 1) as $index => $language)
                                                                <tr>
                                                                    <th scope="row">
                                                                        <select class="form-select mb-3" aria-label="Default select example" required name="language[]">
                                                                            <option>--Select Language--</option>
                                                                            <option value="Tamil" {{ old('language.' . ($index + 1)) == 'Tamil' ? 'selected' : '' }} selected>Tamil</option>
                                                                            <option value="English" {{ old('language.' . ($index + 1)) == 'English' ? 'selected' : '' }}>English</option>
                                                                            <option value="Hindi" {{ old('language.' . ($index + 1)) == 'Hindi' ? 'selected' : '' }}>Hindi</option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select an education
                                                                        </div>
                                                                    </th>
                                                                    <td>
                                                                        <select class="form-select mb-3" required name="langLevel[]">
                                                                            <option> --Select Level -- </option>
                                                                            <option value="Beginner" {{ old('langLevel.' . ($index + 1)) == 'Beginner' ? 'selected' : '' }} selected> Beginner </option>
                                                                            <option value="intermediate" {{ old('langLevel.' . ($index + 1)) == 'intermediate' ? 'selected' : '' }}> intermediate </option>
                                                                            <option value="High" {{ old('langLevel.' . ($index + 1)) == 'High' ? 'selected' : '' }}> High </option>
                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select Level
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-check mb-2">
                                                                            <!-- <input class="form-check-input" type="checkbox" id="formCheck1" value="N" name="[]" onchange="updateCheckboxValue(this)">
                                                                            <label class="form-check-label" for="formCheck1">
                                                                                Read
                                                                            </label> -->

                                                                            <select class="form-select mb-3" required name="langRead[]">
                                                                                <option value="Yes" {{ old('langRead.' . ($index + 1)) == 'Yes' ? 'selected' : '' }} selected> Yes </option>
                                                                                <option value="No" {{ old('langRead.' . ($index + 1)) == 'No' ? 'selected' : '' }}> No </option>

                                                                            </select>
                                                                            <div class="invalid-feedback">
                                                                                Please select option
                                                                            </div>
                                                                        </div>

                                                                    </td>
                                                                    <td>

                                                                        <select class="form-select mb-3" required name="langWrite[]">
                                                                            <option value="Yes" {{ old('langWrite.' . ($index + 1)) == 'Yes' ? 'selected' : '' }} selected> Yes </option>
                                                                            <option value="No" {{ old('langWrite.' . ($index + 1)) == 'No' ? 'selected' : '' }}> No </option>

                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select option
                                                                        </div>
                                                                    </td>
                                                                    <td>

                                                                        <select class="form-select mb-3" required name="langSpeak[]">
                                                                            <option value="Yes" {{ old('langSpeak.' . ($index + 1)) == 'Yes' ? 'selected' : '' }}selected> Yes </option>
                                                                            <option value="No" {{ old('langSpeak.' . ($index + 1)) == 'No' ? 'selected' : '' }}> No </option>

                                                                        </select>
                                                                        <div class="invalid-feedback">
                                                                            Please select option
                                                                        </div>
                                                                    </td>

                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            <tfoot class="table-light">
                                                                <tr>
                                                                    <td colspan="4">Add Row</td>
                                                                    <td><button class="btn btn-primary add-row2">+</button></td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="row mb-3">
                                                <div class="col-lg-6 mb-3">
                                                    <h5>Experience Details</h5>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-check mt-2 me-3">
                                                        <input type="checkbox" name="fresher" id="freasher" {{ old('fresher') ? 'checked' : '' }}>
                                                        <label class="form-check-label" for="freasher">
                                                            Fresher
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table caption-top table-nowrap">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th scope="col">Pervious Company Name</th>
                                                                <th scope="col">Date From</th>
                                                                <th scope="col">Date To</th>
                                                                <!-- <th scope="col">Exp Year</th> -->

                                                                <th scope="col">Designation</th>
                                                                <th scope="col">Last Salary</th>

                                                                <th scope="col">Reason For Leaving</th>
                                                                <th scope="col" class="preCompAttach">PaySlip</th>
                                                                <th scope="col" class="PContactNo">HR ContactNo</th>


                                                            </tr>
                                                        </thead>
                                                        <tbody id="expTBody">
                                                            <tr>
                                                                <th scope="row">
                                                                    <input type="text" class="form-control" id="pcompName" oninput="convertToUppercase(this)" placeholder="Enter previous company Name" required name="perviousComp[]" value="{{old ('perviousComp.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        Previous Company
                                                                    </div>
                                                                </th>
                                                                <td>
                                                                    <input type="date" class="form-control" id="fDate" required name="preComp_fDate[]" value="{{old ('preComp_fDate.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        date
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="date" class="form-control" id="tDate" required name="preComp_tDate[]" value="{{old ('preComp_tDate.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        date
                                                                    </div>
                                                                </td>
                                                                <td style="display: none;">
                                                                    <input type="hidden" class="form-control" id="expYear" required name="expYear[]" value="{{old ('expYear.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        experience Year
                                                                    </div>
                                                                </td>

                                                                <td>

                                                                    <input type="text" class="form-control" id="preComp_design" oninput="convertToUppercase(this)" placeholder="Enter designation Name" required name="preComp_design[]" value="{{old ('preComp_design.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        Previous designation
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control" id="previousSalary" oninput="convertToUppercase(this)" placeholder="Enter previous salary" required name="preComp_salary[]" value="{{old ('preComp_salary.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        previous salary
                                                                    </div>
                                                                </td>

                                                                <td>
                                                                    <input type="text" class="form-control" id="resForLeave" oninput="convertToUppercase(this)" placeholder="Enter Reason for leave" name="ReasonForleave[]" value="{{old ('ReasonForleave.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter a
                                                                        reason
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="file" class="form-control preCompAttach" id="preCompAttach" name="preCompAttach[]" value="{{old ('preCompAttach.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        insert an attachment

                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control PContactNo" id="PContactNo" oninput="convertToUppercase(this)" placeholder="Enter contact no" name="PContactNo[]" value="{{old ('PContactNo.0')}}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter a
                                                                        ContactNo
                                                                    </div>
                                                                </td>

                                                            </tr>
                                                            @foreach (array_slice(old('perviousComp', []), 1) as $index => $perviousComp)
                                                            <tr>
                                                                <th scope="row">
                                                                    <input type="text" class="form-control" id="pcompName" oninput="convertToUppercase(this)" placeholder="Enter previous company Name" required name="perviousComp[]" value="{{ old('perviousComp.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        Previous Company
                                                                    </div>
                                                                </th>
                                                                <td>
                                                                    <input type="date" class="form-control" id="fDate" required name="preComp_fDate[]" value="{{ old('preComp_fDate.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        date
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="date" class="form-control" id="tDate" required name="preComp_tDate[]" value="{{ old('preComp_tDate.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        date
                                                                    </div>
                                                                </td>
                                                                <td style="display: none;">
                                                                    <input type="hidden" class="form-control" id="expYear" required name="expYear[]" value="{{ old('expYear.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        experience Year
                                                                    </div>
                                                                </td>

                                                                <td>

                                                                    <input type="text" class="form-control" id="preComp_design" oninput="convertToUppercase(this)" placeholder="Enter designation Name" required name="preComp_design[]" value="{{ old('preComp_design.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        Previous designation
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control" id="previousSalary" oninput="convertToUppercase(this)" placeholder="Enter previous salary" required name="preComp_salary[]" value="{{ old('preComp_salary.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter an
                                                                        previous salary
                                                                    </div>
                                                                </td>

                                                                <td>
                                                                    <input type="text" class="form-control" id="resForLeave" oninput="convertToUppercase(this)" placeholder="Enter Reason for leave" name="ReasonForleave[]" value="{{ old('ReasonForleave.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter a
                                                                        reason
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="file" class="form-control preCompAttach" id="preCompAttach" name="preCompAttach[]" value="{{ old('preCompAttach.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        insert an attachment

                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control PContactNo" id="PContactNo" oninput="convertToUppercase(this)" placeholder="Enter contact no" name="PContactNo[]" value="{{ old('PContactNo.' . ($index + 1)) }}" />
                                                                    <div class="invalid-feedback">
                                                                        Please
                                                                        enter a
                                                                        ContactNo
                                                                    </div>
                                                                </td>

                                                            </tr>
                                                            @endforeach
                                                        </tbody>
                                                        <tfoot class="table-light">
                                                            <tr>
                                                                <td colspan="4">Add Row</td>
                                                                <td><button class="btn btn-primary add-row3">+</button></td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>




                                            </div>

                                            <div class="row">
                                                <div class="col-lg-6 mb-3">
                                                    <h5 style="display: none;">Reference</h5>
                                                </div>
                                                <div class="col-lg-6"></div>
                                                <div class="col-lg-6">
                                                    <!-- <div class="mb-3">
                                                        <label class="form-label" for="street">Employee No</label>
                                                        <input type="text" class="form-control" id="street" oninput="convertToUppercase(this)"  placeholder="Enter  Name" name="" />
                                                        <div class="invalid-feedback">
                                                           
                                                        </div>
                                                    </div> -->
                                                    <label for="job-category-Input" class="form-label" style="display: none;">Employee TNo </label>
                                                    <select class="form-control " data-choices name="refEmplno" required style="display: none;">
                                                        <option value="">Select company</option>
                                                        @foreach ($emplTno as $emplTnos)
                                                        <option value="{{$emplTnos['Emplno']}}">{{$emplTnos['tno']}}/{{$emplTnos['Name']}}</option>
                                                        @endforeach
                                                    </select>

                                                </div>
                                            </div>

                                        </div>
                                        <div class="d-flex align-items-start gap-3 mt-4">
                                            <button type="button" class="btn btn-light btn-label previestab" data-previous="steparrow-gen-info-tab">
                                                <i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i>
                                                Back to General
                                            </button>
                                            <button type="submit" class="btn btn-success btn-label right ms-auto  ">
                                                Submit
                                            </button>
                                        </div>

                                    </div>


                </form>

                <!-- end tab pane -->


                <!-- end tab pane -->
            </div>

        </div>
        <!-- end tab content -->

    </div>
    </div>



    <div class="modal-footer">
        <div class="hstack gap-2 justify-content-end">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                Close
            </button>
            <!-- <button type="submit" class="btn btn-success" id="add-btn"> -->
            <!-- Add Job -->
            <!-- </button> -->
        </div>
    </div>
    </div>
    </div>
    </div>




    <!-- overview Modal -->
    <div class="modal fade" id="OverView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">
                <form id="createjob-form" autocomplete="off" class="needs-validation" novalidate>
                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="" alt="" id="modal-cover-img" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="" id="companylogo-img" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Job Description</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-remarks"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-company"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Department">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Experience</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Experience">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">No of vacancy</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Vacancy">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Location</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Location">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Salary</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Salary">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="divider"></div>

                                    <h5 class="mt-3 text-center ">Interviewer Details</h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-int-company">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-int-Department">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">HR Round</p>
                                                </td>
                                                <td>:</td>
                                                <td>
                                                    <span class="text-body-secondary " id="job-hrRound">-</span> /
                                                    <span class="text-body-secondary " id="job-hrName">-</span>

                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Round</p>
                                                </td>
                                                <td>:</td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div>
                                                            <span class="text-body-secondary " id="job-techIntName">- </span>

                                                        </div> /
                                                        <div class="form-check mt-2 me-3">
                                                            <input type="checkbox" name="" disabled id="grpDis" readonly>
                                                            <label class="form-check-label" for="HRRound1">
                                                                Group Discussion
                                                            </label>
                                                        </div>
                                                        <div class="form-check mt-2 me-3">
                                                            <input type="checkbox" name="" disabled id="aptitude" readonly>
                                                            <label class="form-check-label" for="HRRound1">
                                                                Aptitude
                                                            </label>
                                                        </div>
                                                        <div class="form-check mt-2 me-3">
                                                            <input type="checkbox" name="" disabled id="technical" readonly>
                                                            <label class="form-check-label" for="HRRound1">
                                                                Technical
                                                            </label>
                                                        </div>
                                                        <div class="form-check mt-2 me-3">
                                                            <input type="checkbox" name="" disabled id="perInterview" readonly>
                                                            <label class="form-check-label" for="HRRound1">
                                                                Personal Interview
                                                            </label>
                                                        </div>


                                                    </div>


                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Final Round</p>
                                                </td>
                                                <td>:</td>
                                                <td>
                                                    <span class="text-body-secondary " id="job-techFinalRound">-</span> /
                                                    <span class="text-body-secondary " id="job-techIntFinalName">-</span>

                                                </td>
                                            </tr>
                                            <!-- <tr>
                                                <td>
                                                    <p class="mt-3">Final Interviewer</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-finalIntName">-</span></td>
                                            </tr> -->
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>




                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                Close
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>

    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>
    <style>
        .applicant-info table {
            width: 100%;
            /* Ensure table takes full width */
        }

        .applicant-info .label {
            width: 120px;
            /* Adjust as needed for the width of your labels */
            padding-right: 10px;
            /* Adjust as needed for spacing between label and colon */
            text-align: right;
            /* Align labels to the right */
        }
    </style>
    <!-- ----------------------------------------------------- -->
    <!-- overview -->
    <div class="modal fade" id="OverView11" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">

                <div class="modal-body">
                    <input type="hidden" id="id-field" />
                    <div class="row g-3">
                        <div class="col-lg-12">
                            <div class="px-1 pt-1">
                                <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                    <img src="Applicant/assets/Img/Jobimg/background-1.jpg" alt="" id="modal-cover-img" class="img-fluid" />

                                    <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                        <div class="flex-grow-1">
                                            <h5 class="modal-title text-white">

                                            </h5>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex gap-3 align-items-center">

                                                <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="text-center mb-4 mt-n5 pt-2">
                                <div class="position-relative d-inline-block">

                                    <div class="avatar-lg p-1">
                                        <div class="avatar-title bg-light rounded-circle">
                                            <img src="Applicant/assets/Img/ApplicantProfile/logo-1.jpg" id="profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                        </div>
                                    </div>
                                </div>
                                <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                </h5>
                            </div>

                        </div>

                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="table-split">
                                <div class="applicant-info">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Applicant Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-Name"></span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Position </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-position">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Department Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dept">-</span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Aadhar No </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-aadharNo"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">DOB</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dob"></span></td>
                                                <td>
                                                    <p class="mt-3">Contact No</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-contNo">-</span></td>

                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Marriage Details</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-marriageSts">-</span></td>

                                                <td>
                                                    <p class="mt-3">Blood Group</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-bloodGrp">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-skill">-</span></td>

                                                <td>
                                                    <p class="mt-3">EmailId</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-mailid">-</span></td>
                                            </tr>

                                            <!-- <tr>
                                                    <td>
                                                        <p class="mt-3">Father/HusBand Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                                </tr> -->
                                        </tbody>
                                    </table>
                                </div>
                                <div class="divider"></div>
                            </div>
                            <div class="table-split">
                                <h5 class="mt-3 text-center ">Address </h5>
                                <div class="applicant-info">
                                    <h5 class="mt-3  ">Permanent Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-plocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ptaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pcountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ppincode">-</span></td>

                                            </tr>

                                        </tbody>
                                    </table>
                                </div>

                                <div class="applicant-info">
                                    <h5 class="mt-3  ">Current Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-clocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ctaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ccountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cpincode">-</span></td>


                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <h5 class="m-3 text-center"> Education Details</h5>
                                <div class="table-con">
                                    <table class="table table-bordered">
                                        <thead>
                                            <th style="border: 1px solid black;">Education</th>
                                            <th style="border: 1px solid black;">Branch</th>
                                            <th style="border: 1px solid black;">Collage/School</th>
                                            <th style="border: 1px solid black;">University/State</th>
                                            <th style="border: 1px solid black;">Percentage(%)</th>
                                            <th style="border: 1px solid black;">Completed Year</th>
                                            <th style="border: 1px solid black;">Attachment</th>
                                        </thead>
                                        <tbody id="eduTableBody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <h5 class="m-3 text-center"> Family Details</h5>
                            <div class="table-con">
                                <table class="table table-bordered">
                                    <thead>
                                        <th style="border: 1px solid black;">Name</th>
                                        <th style="border: 1px solid black;">Type</th>
                                        <th style="border: 1px solid black;">Occupation</th>
                                        <th style="border: 1px solid black;">Contact No</th>
                                        <th style="border: 1px solid black;">Age</th>

                                    </thead>
                                    <tbody id="famTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="m-3 text-center"> Known Language </h5>
                            <div class="table-con">
                                <table class="table table-bordered">
                                    <thead>
                                        <th style="border: 1px solid black;">Language</th>
                                        <th style="border: 1px solid black;">Level</th>
                                        <th style="border: 1px solid black;">Read</th>
                                        <th style="border: 1px solid black;">Write</th>
                                        <th style="border: 1px solid black;">Speak</th>

                                    </thead>
                                    <tbody id="langTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="mt-3 text-center ">Experience Details</h5>
                            <div class="table-con">
                                <table class="table table-bordered">
                                    <thead>
                                        <th style="border: 1px solid black;">Previous company name</th>
                                        <th style="border: 1px solid black;">Date from</th>
                                        <th style="border: 1px solid black;">Date to</th>
                                        <th style="border: 1px solid black;">Exp year</th>

                                        <th style="border: 1px solid black;">Designation</th>
                                        <th style="border: 1px solid black;">Last salary</th>

                                        <th style="border: 1px solid black;">Reason for leaving</th>
                                        <th style="border: 1px solid black;">Contact No</th>
                                        <th style="border: 1px solid black;">Attachment</th>

                                    </thead>
                                    <tbody id="expTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <!-- <h5 class="mt-3 text-center ">Reference</h5>
                            <div class="table-split">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>

                                                <p class="mt-3">Employee TNO</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-refEmplno"></span>
                                            </td>

                                        </tr>
                                    </tbody>
                                </table>

                            </div> -->

                        </div>
                    </div>
                </div>




                <div class="modal-footer">
                    <div class=" gap-2 ">



                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- ----------------------------------------------------- -->


    <!-- JAVASCRIPT -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- form wizard init -->
    <script src="Applicant/assets/js/pages/form-wizard.init.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/js/app.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>


    <script>
        document.getElementById('steparrow-gen-info-contact-input').addEventListener('input', function() {
            if (this.value.length > 10) {
                this.value = this.value.slice(0, 10);
            }
        });

        document.querySelector('form').addEventListener('submit', function(e) {
            const contactInput = document.getElementById('steparrow-gen-info-contact-input');
            if (contactInput.value.length !== 10) {
                e.preventDefault(); // Prevent the form from submitting
                alert('Contact number must be exactly 10 digits.');
            }
        });
    </script>

    <!-- FOR FETCHING THE DATA -->
    <script>
        function detailsfetch(posid) {

            // $('#ApplyJob').modal('hide');

            var selected_posid = posid

            $.ajax({
                url: "Applyjob1",
                type: "GET",
                data: {
                    posId: selected_posid
                },
                success: function(response) {
                    console.log(response);
                    if (response.length > 0) {

                        $('#OverView11').modal('show');

                        let selectSts = response[0];
                        $('#userImage').attr('src', selectSts.ProfileImg);

                        $('#uName').text(selectSts.ApplicantName);
                        // $('.appl_name').val(selectSts.ApplicantName);

                        $('#uJob').text(selectSts.jobTitle);
                        $('#uMail').text(selectSts.emailId);
                        // $('.appl_email').text(selectSts.emailId);

                        //  ================= process bar ===============
                        let processVal = 0;

                        if (selectSts.hrSts === 'Selected') {
                            processVal = 25;
                        }
                        if (selectSts.techIntSts === 'Selected') {
                            processVal = 50;
                        }
                        if (selectSts.tech1Sts === 'Selected') {
                            processVal = 75;
                        }
                        if (selectSts.finalIntSts === 'Selected') {
                            processVal = 100;
                        }

                        $('.progress-bar').attr('aria-valuenow', processVal);
                        $('.progress-bar').css('width', processVal + '%');
                        $('.progress-bar .label').text(processVal + '%');

                        //  ================= process bar end  ===============

                        // =========================== image end ==============================

                        //  hr Image


                        if (selectSts.hrIntEmplno === "0" || selectSts.hrIntEmplno === "") {
                            $('#hrIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#hrIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.hrIntEmplno + ".jpeg");
                        }

                        //  technical interviewer Image


                        if (selectSts.techIntEmplno === "0" || selectSts.techIntEmplno === "") {
                            $('#techIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#techIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.techIntEmplno + ".jpeg");
                        }

                        //  technical 1 interviewer Image

                        if (selectSts.tech1IntEmplno === "0" || selectSts.tech1IntEmplno === "") {
                            $('#tech1IntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#tech1IntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.tech1IntEmplno + ".jpeg");
                        }

                        //  final interviewer Image

                        if (selectSts.finalIntEmplno === "0" || selectSts.finalIntEmplno === "") {
                            $('#finalIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#finalIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.finalIntEmplno + ".jpeg");
                        }


                        // =========================== image end ==============================

                        // ========================== remarks start =============================
                        //  HR Status 

                        (selectSts.hrRemarks === "") ? $("#hrIntRemarks").text("Not updated"): $("#hrIntRemarks").text(selectSts.hrRemarks);

                        //  HR Status 

                        (selectSts.techIntRemarks === "") ? $("#techIntRemarks").text("Not updated"): $("#techIntRemarks").text(selectSts.techIntRemarks);
                        //  HR Status 

                        (selectSts.tech1Remarks === "") ? $("#tech1IntRemarks").text("Not updated"): $("#tech1IntRemarks").text(selectSts.tech1Remarks);
                        //  HR Status 

                        (selectSts.finalIntRemarks === "") ? $("#finalIntRemarks").text("Not updated"): $("#finalIntRemarks").text(selectSts.finalIntRemarks);

                        // ========================== remarks start =============================

                        // ========================== Status start =============================
                        //  HR Status 

                        (selectSts.hrSts === "") ? $("#hrIntStatus").text("Not updated"): $("#hrIntStatus").text(selectSts.hrSts);

                        //  HR Status 

                        (selectSts.techIntSts === "") ? $("#techIntStatus").text("Not updated"): $("#techIntStatus").text(selectSts.techIntSts);
                        //  HR Status 

                        (selectSts.tech1Sts === "") ? $("#tech1IntStatus").text("Not updated"): $("#tech1IntStatus").text(selectSts.tech1Sts);
                        //  HR Status 

                        (selectSts.finalIntSts === "") ? $("#finalIntStatus").text("Not updated"): $("#finalIntStatus").text(selectSts.finalIntSts);

                        // ========================== remarks start =============================


                        //  applicant details show

                        var applicantBasicDtls = response[1];
                        var applicantEduDtls = response[2];
                        var applicantFamDtls = response[3];
                        var applicantLangDtls = response[4];
                        var applicantExpDtls = response[5];


                        let candidateRowid = applicantBasicDtls[0]['Rowid'];
                        let candidateMailId = applicantBasicDtls[0]['EmailId'];
                        let candidatePosition = applicantBasicDtls[0]['position'];
                        let candidateDept = applicantBasicDtls[0]['ADept'];
                        let candidateName = applicantBasicDtls[0]['ApplicantName'];
                        let candidateProfile = applicantBasicDtls[0]['profileImg'];

                        $('#eduTableBody').empty();
                        $('#famTableBody').empty();
                        $('#langTableBody').empty();
                        $('#expTableBody').empty();

                        //  ====================== education =========================

                        for (let i = 0; i < applicantEduDtls.length; i++) {
                            const eduMasID = applicantEduDtls[i]["masterId"];
                            if (applicantBasicDtls[0]['Rowid'] == eduMasID) {
                                const eduType = applicantEduDtls[i]["Education"];
                                const eduBranch = applicantEduDtls[i]["Branch"];
                                const eduScl_clg = applicantEduDtls[i]["Collage_School"];
                                const eduUni_state = applicantEduDtls[i]["University_Board"];
                                const eduPercentage = applicantEduDtls[i]["Percentage"];
                                const eduYearOfComp = applicantEduDtls[i]["YearofComplition"];
                                let eduAttach = applicantEduDtls[i]["eduAttach"];
                                const newRow = $('<tr>');
                                newRow.append('<td style="border: 1px solid black;">' + eduType + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + eduBranch + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + eduScl_clg + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + eduUni_state + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + eduPercentage + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + eduYearOfComp + '</td>');
                                if (eduAttach == "") {
                                    eduAttach = "no Attachment";
                                    newRow.append('<td style="border: 1px solid black;">' + eduAttach + '</td>');
                                } else {

                                    newRow.append('<td style="border: 1px solid black;">' + '<a href="' + eduAttach + '" download ="education">Download</a>' + '</td>');

                                }
                                $('#eduTableBody').append(newRow);

                            } else {

                            }
                        }



                        // end education  ===============  

                        //   ========================= family =====================================

                        for (let i = 0; i < applicantFamDtls.length; i++) {

                            const famMasID = applicantFamDtls[i]["MasterId"];
                            if (applicantBasicDtls[0]['Rowid'] == famMasID) {

                                const famName = applicantFamDtls[i]["Name"];
                                const famType = applicantFamDtls[i]["Type"];
                                const famOccupation = applicantFamDtls[i]["Occupation"];
                                const famContNo = applicantFamDtls[i]["ContactNo"];
                                const Age = applicantFamDtls[i]["Age"];

                                const newRow = $('<tr>');
                                newRow.append('<td style="border: 1px solid black;">' + famName + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + famType + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + famOccupation + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + famContNo + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + Age + '</td>');
                                $('#famTableBody').append(newRow);
                            } else {

                            }

                        }

                        //  end family =================================

                        //   ========================= landuage =====================================

                        for (let i = 0; i < applicantLangDtls.length; i++) {

                            const langMasID = applicantLangDtls[i]["MasterId"];

                            if (applicantBasicDtls[0]['Rowid'] == langMasID) {

                                const langType = applicantLangDtls[i]["Lang"];
                                const langLevel = applicantLangDtls[i]["Level"];
                                const langReading = applicantLangDtls[i]["Reading"];
                                const langSpeak = applicantLangDtls[i]["Speak"];
                                const langWrite = applicantLangDtls[i]["Write"];


                                const newRow = $('<tr>');
                                newRow.append('<td style="border: 1px solid black;">' + langType + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + langLevel + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + langReading + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + langSpeak + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + langWrite + '</td>');
                                $('#langTableBody').append(newRow);
                            } else {

                            }

                        }

                        //  end language =================================

                        // experience start =======================
                        console.log(applicantExpDtls);
                        for (let i = 0; i < applicantExpDtls.length; i++) {

                            const expMasID = applicantExpDtls[i]["MasterId"];

                            if (applicantBasicDtls[0]['Rowid'] == expMasID) {

                                var PCompany = applicantExpDtls[i]["PCompany"];
                                var FDate = applicantExpDtls[i]["FDate"];
                                var FdateOnly = FDate.split(' ')[0];
                                var TDate = applicantExpDtls[i]["TDate"];
                                var TdateOnly = TDate.split(' ')[0];

                                var ExpYear = applicantExpDtls[i]["ExpYear"];
                                // var Pdept = applicantExpDtls[i]["Department"];
                                var Pdesign = applicantExpDtls[i]["Designation"];
                                var LastSalary = applicantExpDtls[i]["LastSalary"];
                                // var ExpectSalary = applicantExpDtls[i]["ExpectSalary"];
                                var ResForLeave = applicantExpDtls[i]["ResForLeave"];
                                var pContactNo = applicantExpDtls[i]["pContactNo"];
                                var RefEmplno = applicantExpDtls[i]["RefEmplno"];
                                var ExpAttatchment = applicantExpDtls[i]["ExpAttatchment"];
                                const newRow = $('<tr>');
                                newRow.append('<td style="border: 1px solid black;">' + PCompany + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + FdateOnly + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + TdateOnly + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + ExpYear + '</td>');
                                // newRow.append('<td style="border: 1px solid black;">' + Pdept + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + Pdesign + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + LastSalary + '</td>');
                                // newRow.append('<td style="border: 1px solid black;">' + ExpectSalary + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + ResForLeave + '</td>');
                                newRow.append('<td style="border: 1px solid black;">' + pContactNo + '</td>');
                                if (ExpAttatchment == "") {
                                    ExpAttatchment = "No Attachment";
                                    newRow.append('<td style="border: 1px solid black;">' + ExpAttatchment + '</td>');
                                } else {
                                    newRow.append('<td style="border: 1px solid black;">' + '<a href="' + ExpAttatchment + '" download="experience">Download</a>' + '</td>');
                                }

                                $('#expTableBody').append(newRow);
                            } else {

                            }

                        }

                        // end experience ====================

                        var BackImg = applicantBasicDtls[0]["BackImg"];
                        var profileImg = applicantBasicDtls[0]["profileImg"];
                        var resumeAttach = applicantBasicDtls[0]["resumeAttach"];
                        var ExpAttatchment = applicantBasicDtls[0]["ExpAttatchment"];

                        var ApplicantName = applicantBasicDtls[0]["ApplicantName"];
                        var ADept = applicantBasicDtls[0]["ADept"];
                        var position = applicantBasicDtls[0]["position"];
                        var AadharNo = applicantBasicDtls[0]["AadharNo"];
                        var dateParts = applicantBasicDtls[0]["DOB"];
                        var DOB = dateParts.split(' ')[0];
                        var ContactNo = applicantBasicDtls[0]["ContactNo"];
                        var BloodGroup = applicantBasicDtls[0]["BloodGroup"];
                        var MarrigeSts = applicantBasicDtls[0]["MarrigeSts"];
                        var skill = applicantBasicDtls[0]["skill"];
                        var EmailId = applicantBasicDtls[0]["EmailId"];


                        $('#candidate-rowid').val(candidateRowid);
                        $('#candidate-mailid').val(candidateMailId);
                        $('#candidate-position').val(candidatePosition);
                        $('#candidate-dept').val(candidateDept);
                        $('#candidate-name').val(candidateName);
                        $('#profile-img-can').attr('src', candidateProfile);
                        $('#modal-cover-img-can').attr('src', BackImg);

                        $('#applicant-Name').text(ApplicantName);
                        $('#applicant-dept').text(ADept);
                        $('#applicant-position').text(position);
                        $('#applicant-aadharNo').text(AadharNo);
                        $('#applicant-dob').text(DOB);
                        $('#applicant-contNo').text(ContactNo);
                        $('#applicant-marriageSts').text(MarrigeSts);
                        $('#applicant-bloodGrp').text(BloodGroup);
                        $('#applicant-skill').text(skill);
                        $('#applicant-mailid').text(EmailId);

                        // permanent Address 
                        var PStreet = applicantBasicDtls[0]["PStreet"];
                        var Plocation = applicantBasicDtls[0]["Plocation"];
                        var PTaluk = applicantBasicDtls[0]["PTaluk"];
                        var PDistrict = applicantBasicDtls[0]["PDistrict"];
                        var Pstate = applicantBasicDtls[0]["Pstate"];
                        var PCountry = applicantBasicDtls[0]["PCountry"];
                        var ppincode = applicantBasicDtls[0]["ppincode"];

                        $('#applicant-pstreet').text(PStreet);
                        $('#applicant-plocation').text(Plocation);
                        $('#applicant-ptaluk').text(PTaluk);
                        $('#applicant-pdistrict').text(PDistrict);
                        $('#applicant-pstate').text(Pstate);
                        $('#applicant-pcountry').text(PCountry);
                        $('#applicant-ppincode').text(ppincode);


                        // current address 
                        var CStreet = applicantBasicDtls[0]["CStreet"];
                        var Clocation = applicantBasicDtls[0]["Clocation"];
                        var CTaluk = applicantBasicDtls[0]["CTaluk"];
                        var CDistrict = applicantBasicDtls[0]["CDistrict"];
                        var Cstate = applicantBasicDtls[0]["Cstate"];
                        var CCountry = applicantBasicDtls[0]["CCountry"];
                        var Cpincode = applicantBasicDtls[0]["Cpincode"];

                        $('#applicant-cstreet').text(CStreet);
                        $('#applicant-clocation').text(Clocation);
                        $('#applicant-ctaluk').text(CTaluk);
                        $('#applicant-cdistrict').text(CDistrict);
                        $('#applicant-cstate').text(Cstate);
                        $('#applicant-ccountry').text(CCountry);
                        $('#applicant-cpincode').text(Cpincode);
                        // experience details


                        var RefEmplno = applicantBasicDtls[0]["RefEmplno"];
                        if (RefEmplno == 0) {
                            RefEmplno = "No Reference";
                        }
                        $('#applicant-refEmplno').text(RefEmplno);


                    } else {


                        $('#ApplyJob').modal('show');
                    }

                },
                error: function(xhr, status, error) {
                    console.error(xhr, status, error);

                    $('#ApplyJob').modal('show');
                }
            });
        }
    </script>

    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>
    <!-- CONVERT TO UPPERCASE LETTERS -->
    <script>
        function convertToUppercase(input) {
            input.value = input.value.toUpperCase();
        }
    </script>

    <!-- permanent adddress  -->
    <script>
        function copyAddress() {
            // Get the values from permanent address fields
            var street = document.getElementById('street').value;
            var location = document.getElementById('location').value;
            var taluk = document.getElementById('taluk').value;
            var district = document.getElementById('district').value;
            var state = document.getElementById('state').value;
            var country = document.getElementById('country').value;
            var pincode = document.getElementById('pincode').value;

            // If the checkbox is checked, copy the values to the current address fields
            if (document.getElementById('copyAddressCheckbox').checked) {
                document.getElementById('cStreet').value = street;
                document.getElementById('cLocation').value = location;
                document.getElementById('cTaluk').value = taluk;
                document.getElementById('cDistrict').value = district;
                document.getElementById('cState').value = state;
                document.getElementById('cCountry').value = country;
                document.getElementById('cPincode').value = pincode;
            } else {
                // If the checkbox is unchecked, you can clear the c address fields or handle it based on your requirement
                document.getElementById('cStreet').value = '';
                document.getElementById('cLocation').value = '';
                document.getElementById('cTaluk').value = '';
                document.getElementById('cDistrict').value = '';
                document.getElementById('cState').value = '';
                document.getElementById('cCountry').value = '';
                document.getElementById('cPincode').value = '';
            }
        }
    </script>

    <!-- image update  -->
    <script>
        document.querySelector("#companylogo-image-input").addEventListener("change", function() {
            var e = document.querySelector("#companylogo-imgA"),
                t = document.querySelector("#companylogo-image-input").files[0],
                n = new FileReader();
            n.addEventListener("load", function() {
                        console.log(n);
                        e.src = n.result;
                    },
                    !1
                ),
                t && n.readAsDataURL(t);
        });
    </script>

    <!-- view Modal Details Show   -->

    <script>
        $(document).ready(function() {
            $('.applyjob-list').on('click', function() {
                var jobDetails = $(this).data('job-details');
                // console.log(jobDetails);
                var dataArray = jobDetails.split("|");

                var jobTitle = dataArray[0];
                var deptName = dataArray[1];
                var img1 = dataArray[2];
                var img2 = dataArray[3];
                var jobtitleId = dataArray[4];
                var deptId = dataArray[5];

                $('#jobPosition').val(jobTitle);
                $('#jobPositionH').val(jobtitleId);
                $('#JobDept').val(deptName);
                $('#JobDeptH').val(deptId);
                $('#modal-cover-imgA').attr('src', img1);
                $('#backImage-inputH').val(img1);
                $('#profileImage-inputH').val(img2);

            })
        });


        $(document).ready(function() {
            $('.viewjob-list').on('click', function() {
                var jobDetails = $(this).data('job-details');
                // console.log(jobDetails);
                var dataArray = jobDetails.split("|");
                var jobTitle = dataArray[0];
                var deptName = dataArray[1];
                var experience = dataArray[2];
                var no_of_vac = dataArray[3];
                var location = dataArray[4];
                var salary = dataArray[5];
                var skills = dataArray[6];
                var img1 = dataArray[7];
                var img2 = dataArray[8];
                var remarks = dataArray[9];
                var grpDis = dataArray[10];
                var aptitude = dataArray[11];
                var technical = dataArray[12];
                var persInter = dataArray[13];
                var hrName = dataArray[14];
                var techIntName = dataArray[15];
                var techfinalName = dataArray[16];
                var finalIntName = dataArray[17];
                var compName = dataArray[18];
                var intCompName = dataArray[19];
                var intDeptName = dataArray[20];
                var mainCompName = dataArray[21];
                var EDate = dataArray[22];
                var hrRound = dataArray[23];
                var FinalTechRound = dataArray[24];
                // var location = dataArray[2];

                if (hrRound == 1) {
                    hrRound = "YES";
                } else {
                    hrRound = "NO";

                }
                if (FinalTechRound == 1) {
                    FinalTechRound = "YES";
                } else {
                    FinalTechRound = "NO";

                }

                $('#exampleModalLabel').text(jobTitle);
                $('#job-Department').text(deptName);
                $('#job-Experience').text(experience);
                $('#job-Vacancy').text(no_of_vac);
                $('#job-Location').text(location);
                $('#job-Salary').text(salary);
                $('#job-Skills').text(skills);
                $('#modal-cover-img').attr('src', img1);
                $('#companylogo-img').attr('src', img2);
                $('#job-remarks').text(remarks);

                function updateCheckbox(checkboxId, value) {
                    $('#' + checkboxId).prop('checked', value == 1);
                }

                // Update checkboxes based on values
                updateCheckbox('grpDis', grpDis);
                updateCheckbox('aptitude', aptitude);
                updateCheckbox('technical', technical);
                updateCheckbox('perInterview', persInter);

                $('#job-hrName').text(hrName);
                $('#job-techIntName').text(techIntName);
                $('#job-techIntFinalName').text(techfinalName);
                // $('#job-finalIntName').text(finalIntName);
                $('#job-hrRound').text(hrRound);
                $('#job-techFinalRound').text(FinalTechRound);
                $('#job-int-company').text(intCompName);
                $('#job-int-Department').text(intDeptName);
                $('#job-company').text(compName);
            });
        });
    </script>


    <!-- Add a script section to handle the search functionality -->

    <script>
        // Assuming you are using jQuery
        $(document).ready(function() {
            // Initialize the total job count
            var totalJobsCount = $('.col-xl-4').length;

            $('#searchJob').on('input', function() {
                var searchQuery = $(this).val().toLowerCase();

                // Hide all jobs initially
                $('.col-xl-4').hide();

                // Initialize the count of visible jobs
                var visibleJobsCount = 0;

                // Loop through each job and check if it matches the search query
                $('.col-xl-4').each(function() {
                    var jobTitle = $(this).find('h5').text().toLowerCase();
                    var companyName = $(this).find('p.text-muted').text().toLowerCase();
                    var skills = $(this).find('p.text-muted').text().toLowerCase();

                    if (jobTitle.includes(searchQuery) || companyName.includes(searchQuery) || skills.includes(searchQuery)) {
                        $(this).show();
                        visibleJobsCount++;
                    }
                });

                // Show the alert with the correct total number of results
                $('#total-result').text(visibleJobsCount);
                $('#found-job-alert').removeClass('d-none');
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            // Add Row
            $('.add-row').on('click', function(e) {
                e.preventDefault();
                var newRow = '<tr>' +
                    '<td> <select class="form-select mb-3" name="education[]"><option  > --Select Education -- </option> <option value = "SSLC"> SSLC </option> <option value = "HSC" selected> HSC </option> <option value = "COLLEGE"> COLLEGE </option> </select></td > ' +
                    '<td><input type="text" class="form-control"  oninput="convertToUppercase(this)"  placeholder="Enter Branch" name="branch[]  "/></td>' +
                    '<td><input type="text" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter College/School" name="S_C[]"/></td>' +
                    '<td><input type="text" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter University/State Board" name="U_S[]" /></td>' +
                    '<td><input type="number" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter Percentage" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="3" name="percentage[]" /></td>' +
                    '<td><input type="number" class="form-control" id="" oninput="convertToUppercase(this)"  placeholder="Enter percentage" required name="yearOfComplition[]" /> <div class="invalid-feedback">  Please enter a year of completion </div></td>' +
                    '<td><input type="File" class="form-control" name="eduAttach[]" /></td>' +
                    '<td><button class="btn btn-danger delete-row">-</button></td>' +
                    '</tr>';

                $('#eduTBody').append(newRow);
                // Add the first row on page load
                addRow();

                // Add Row Button click event
                $('.add-row').on('click', function(e) {
                    e.preventDefault();
                    addRow(); // Call the function to add a new row
                });

                // Delete Row Button click event
                $('#eduTBody').on('click', '.delete-row', function(e) {
                    e.preventDefault();
                    $(this).closest('tr').remove();
                });
            });

            // Delete Row
            $('#eduTBody').on('click', '.delete-row', function(e) {
                e.preventDefault();
                $(this).closest('tr').remove();
            });

            $('.add-row1').on('click', function(e) {
                e.preventDefault();
                var newRow1 = '<tr>' +
                    '<td><input type="text" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter relation name" name="relName[]" /></td > ' +
                    '<td> <select class="form-select mb-3" name="relType[]"><option  > --Select relation type -- </option>' +
                    '<option value="Brother"> Brother </option>' +
                    '<option value="Brother In Law"> Brother In Law </option>' +
                    '<option value="Daughter"> Daughter </option>' +
                    '<option value="Daughter In Law"> Daughter In Law </option>' +
                    '<option value="Father" selected> Father </option>' +
                    '<option value="Father In Law"> Father In Law </option>' +
                    '<option value="Grandfather"> Grandfather </option>' +
                    '<option value="Grandmother"> Grandmother </option>' +
                    ' <option value="Husband"> Husband </option>' +
                    '<option value="Mother"> Mother </option>' +
                    ' <option value="Mother In Law"> Mother In Law</option>' +
                    '<option value="Sister"> Sister </option>' +
                    '<option value="Sister In Law"> Sister In Law</option>' +
                    ' <option value="Son"> Son </option>' +
                    '<option value="Uncle"> Uncle </option>' +
                    '<option value="Wife"> Wife </option> </select></td>' +
                    '<td><input type="text" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter occupation" name="relOccupation[]"  /></td>' +
                    '<td><input type="number" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter Age" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relAge[]"   /></td>' +
                    '<td><input type="number" class="form-control" oninput="convertToUppercase(this)"  placeholder="Enter contactno" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" maxlength="10" name="relContactNo[]"   /></td>' +
                    '<td><button class="btn btn-danger delete-row1">-</button></td>' +
                    '</tr>';
                $('#FamTBody').append(newRow1);
            });

            // Delete Row
            $('#FamTBody').on('click', '.delete-row1', function(e) {
                e.preventDefault();
                $(this).closest('tr').remove();
            });

            $('.add-row2').on('click', function(e) {
                e.preventDefault();
                var newRow1 = '<tr>' +
                    '<td> <select class="form-select mb-3" name="language[]" required><option>--Select Language--</option><option value="Tamil" >Tamil</option><option value="English" selected>English</option><option value="Hindi">Hindi</option> </select> <div Please select an education </div></td >' +
                    '<td><select class="form-select mb-3" name="langLevel[]"><option selected > --Select Level -- </option> <option value = "Beginner" selected > Beginner </option> <option value = "intermediate" > intermediate </option> <option value = "High" > High </option> </select><div class="invalid-feedback">Please select Level</div>' +
                    '<td>  <select class="form-select mb-3" required name="langRead[]"><option value="Yes" selected> Yes </option><option value="No"> No </option> </select><div class="invalid-feedback">Please select option</div></td>' +
                    '<td> <select class="form-select mb-3" required name="langWrite[]"><option value="Yes" selected> Yes </option><option value="No"> No </option> </select><div class="invalid-feedback">Please select option</div></td>' +
                    '<td>  <select class="form-select mb-3" required name="langSpeak[]"><option value="Yes" selected> Yes </option><option value="No"> No </option> </select><div class="invalid-feedback">Please select option</div></td>' +
                    '<td><button class="btn btn-danger delete-row2">-</button></td>' +
                    '</tr>';

                $('#langBody').append(newRow1);
            });

            // Delete Row
            $('#langBody').on('click', '.delete-row2', function(e) {
                e.preventDefault();
                $(this).closest('tr').remove();
            });


            $('.add-row3').on('click', function(e) {
                e.preventDefault();
                var newRow = '<tr>' +
                    '<td> <input type="text" class="form-control" id="pcompName" oninput="convertToUppercase(this)"  placeholder="Enter previous company Name" required name="perviousComp[]" /><div class="invalid-feedback"> Please enter an Previous Company </div></td > ' +
                    '<td> <input type="date" class="form-control" id="fDate" required name="preComp_fDate[]" /><div class="invalid-feedback">Please enter an date</div></td>' +
                    '<td><input type="date" class="form-control" id="tDate" required name="preComp_tDate[]" /> <div class="invalid-feedback"> Please enter an  date </div></td>' +
                    '<td style="display: none;"><input type="hidden" class="form-control" id="expYear"  required name="expYear[]" /><div class="invalid-feedback"> Please enter an experience Year </div></td>' +

                    '<td><input type="text" class="form-control" id="preComp_design" oninput="convertToUppercase(this)"  placeholder="Enter designation Name" required name="preComp_design[]" /></td>' +
                    '<td>  <input type="text" class="form-control" id="previousSalary" oninput="convertToUppercase(this)"  placeholder="Enter previous salary" required name="preComp_salary[]" /><div class="invalid-feedback">Please enter an previous salary</div></td>' +

                    '<td>  <input type="text" class="form-control" id="resForLeave" oninput="convertToUppercase(this)"  placeholder="Enter Reason for leave" name="ReasonForleave[]" /><div class="invalid-feedback">Please enter a reason</div></td>' +

                    '<td><input type="file" class="form-control preCompAttach" id="preCompAttach" name="preCompAttach[]" /><div class="invalid-feedback">Please insert an attachment</div></td>' +

                    '<td><input type="number" class="form-control PContactNo" id="PContactNo" placrholder="Enter contactNo" name="PContactNo[]" /><div class="invalid-feedback">Please enter contact number</div></td>' +
                    '<td><button class="btn btn-danger delete-row3">-</button></td>' +
                    '</tr>';

                $('#expTBody').append(newRow);
            });
            $('#expTBody').on('click', '.delete-row3', function(e) {
                e.preventDefault();
                $(this).closest('tr').remove();
            });

        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get the checkbox and input fields
            var fresherCheckbox = document.getElementById('freasher');
            var tableBody = document.getElementById('expTBody');

            // Initialize the input fields based on the checkbox state
            toggleInputsState(fresherCheckbox.checked);

            // Add event listener to the checkbox
            fresherCheckbox.addEventListener('change', function() {
                // Disable or enable input fields based on the checkbox state
                var isFresher = fresherCheckbox.checked;
                toggleInputsState(isFresher);
            });

            // Add event listener to the table body for dynamic rows
            tableBody.addEventListener('change', function(event) {
                var target = event.target;

                if (target.tagName === 'INPUT') {
                    // Check if the changed input is the "From Date" or "To Date"
                    if (target.id === 'fDate' || target.id === 'tDate') {
                        updateExpYear(target);
                    }
                }
            });

            // Function to toggle input fields state
            function toggleInputsState(isFresher) {
                var tableInputs = tableBody.querySelectorAll('input');

                tableInputs.forEach(function(input) {
                    input.disabled = isFresher;
                });
            }

            // Function to calculate and update "Exp Year"
            function updateExpYear(input) {
                var row = input.closest('tr');
                var fDateInput = row.querySelector('#fDate');
                var tDateInput = row.querySelector('#tDate');
                var expYearInput = row.querySelector('#expYear');

                var fromDate = new Date(fDateInput.value);
                var toDate = new Date(tDateInput.value);

                if (!isNaN(fromDate) && !isNaN(toDate) && fromDate <= toDate) {
                    var diffInMonths = (toDate.getFullYear() - fromDate.getFullYear()) * 12;
                    diffInMonths -= fromDate.getMonth() + 1;
                    diffInMonths += toDate.getMonth() + 1;

                    var years = Math.floor(diffInMonths / 12);
                    var months = diffInMonths % 12;

                    expYearInput.value = years + " Y - " + months + " M";
                } else {
                    expYearInput.value = '';
                }
            }
        });
    </script>


</body>

</html>