<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">


<!-- Mirrored from themesbrand.com/velzon/html/master/pages-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:46:10 GMT -->

<head>

    <meta charset="utf-8" />
    <title>Profile</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp">

    <!-- swiper css -->
    <link rel="stylesheet" href="Applicant/assets/libs/swiper/swiper-bundle.min.css">

    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />


    <!-- ==================== for table ==================== -->

    <style>
        .table-split table tbody tr td {
            width: 0px !important;
            border: none;
            padding: 0px 15PX 0px 15px !important;
        }

        .table-con table tbody td,
        .table-con table thead th {

            padding: 5px;
            border: 1px solid gray;
        }

        .table-con table {
            width: 100%;

        }

        .table-con {
            overflow-x: auto;
        }

        @media (max-width: 426px) {
            .table-split table tbody tr td {
                width: 0px;

            }

            .table-split table tbody td:nth-child(2),
            .table-split table tbody td:nth-child(5) {
                display: none;
                /* flex-wrap: wrap; */
            }

            .table-split table tbody td {

                display: flex;

                flex-wrap: wrap;
            }

        }

        .footer {
            position: static;
        }
    </style>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div>

            <div class="page-content">
                <div class="container-fluid">
                    <div class="profile-foreground position-relative mx-n4 mt-n4">
                        <div class="profile-wid-bg">
                            <img src="/Applicant/assets/images/small/img-1.jpg" alt="" class="profile-wid-img" />
                        </div>
                    </div>
                    <div class="pt-4 mb-4 mb-lg-3 pb-lg-4 profile-wrapper">
                        <div class="row g-4">
                            <div class="mt-3 mt-2 icon">

                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-arrow-left-circle-fill text-white" viewBox="0 0 16 16">
                                    <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0zm3.5 7.5a.5.5 0 0 1 0 1H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5z" />
                                </svg>
                                <a href="Applyjob" class="text-white btn btn-outline-secondary btn-lg"> BACK

                                </a>
                            </div>
                            <div class="col-auto">
                                <div class="avatar-lg">

                                    <img src="/Applicant/assets/images/users/user-dummy-img.jpg" id="userImage" alt="user-img" class="img-thumbnail rounded-circle" />
                                </div>
                            </div>

                            <!--end col-->
                            <div class="col">
                                <div class="pt-4">
                                    <!-- <h3 class="text-white mb-1">
                                        <?php $uName = Session::get('userName');
                                        echo $uName; ?>
                                    </h3> -->


                                </div>
                            </div>


                        </div>
                        <!--end row-->
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div>
                                <!-- Tab panes -->
                                <div class="tab-content pt-4 text-muted">
                                    <div class="tab-pane active" id="overview-tab" role="tabpanel">
                                        <div class="row">
                                            <div class="col-xxl-3">


                                                <div class="card">
                                                    <div class="card-body">
                                                        <h5 class="card-title mb-3">Info</h5>
                                                        <div class="table-responsive">
                                                            <table class="table table-borderless mb-0">
                                                                <tbody>
                                                                    <tr>
                                                                        <th class="ps-0" scope="row">Full Name :</th>
                                                                        <td class="text-muted" id="uName"> no data</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th class="ps-0" scope="row">Job Name :</th>
                                                                        <td class="text-muted" id="uJob"> no data</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th class="ps-0" scope="row">E-mail ID :</th>
                                                                        <td class="text-muted" id="uMail">no data</td>
                                                                        <td class="text-muted" id=""><a href="" data-bs-toggle="modal" data-bs-target="#OverView" class="btn btn-secondary btn-sm">More</a></td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <!-- end card body -->
                                                </div>
                                                <div class="card">
                                                    <div class="card-body">
                                                        <!-- <h5 class="card-title mb-5">Job Name</h5> -->
                                                        <div class="col-lg-4 col-sm-12 col-xxl-12">
                                                            <div class="form-group">
                                                                <label for="">Job Name</label>
                                                                <select name="" id="jobName" class="form-select">

                                                                    @foreach (collect($joblist)->unique('position') as $joblists)
                                                                    <option value="{{ $joblists['position'] }}"> {{ $joblists['jobTitle'] }} </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-body">
                                                        <h5 class="card-title mb-5">Process</h5>
                                                        <div class="progress animated-progress custom-progress progress-label">

                                                            <div class="progress-bar bg-danger" role="progressbar" style="width: 80%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                                                                <div class="label">0%</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-9">
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="card">
                                                            <div class="card-header align-items-center d-flex">
                                                                <h4 class="card-title mb-0  me-2">Interviewer Status</h4>
                                                                <div class="flex-shrink-0 ms-auto">

                                                                </div>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="tab-content text-muted">
                                                                    <div class="tab-pane active" id="today" role="tabpanel">
                                                                        <div class="profile-timeline">
                                                                            <div class="accordion accordion-flush" id="todayExample">
                                                                                <div class="accordion-item border-0">
                                                                                    <div class="accordion-header" id="headingOne">
                                                                                        <a class="accordion-button p-2 shadow-none" data-bs-toggle="collapse" href="#collapseOne" aria-expanded="true">
                                                                                            <div class="d-flex">
                                                                                                <div class="flex-shrink-0">
                                                                                                    <img src="/Applicant/assets/images/users/user-dummy-img.jpg" id="hrIntImg" alt="" class="avatar-xs rounded-circle material-shadow" />
                                                                                                </div>
                                                                                                <div class="flex-grow-1 ms-3">
                                                                                                    <h6 class="fs-14 mb-1">
                                                                                                        HR Status
                                                                                                    </h6>
                                                                                                    <small class="text-muted" id="hrIntStatus">

                                                                                                    </small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                    <br>
                                                                                    <!-- <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                                                        <div class="accordion-body ms-2 ps-5" id="hrIntRemarks">

                                                                                        </div>
                                                                                    </div> -->
                                                                                </div>
                                                                                <div class="accordion-item border-0">
                                                                                    <div class="accordion-header" id="headingTwo">
                                                                                        <a class="accordion-button p-2 shadow-none" data-bs-toggle="collapse" href="#collapseTwo" aria-expanded="false">
                                                                                            <div class="d-flex">
                                                                                                <div class="flex-shrink-0">
                                                                                                    <img src="/Applicant/assets/images/users/user-dummy-img.jpg" id="techIntImg" alt="" class="avatar-xs rounded-circle material-shadow" />
                                                                                                </div>
                                                                                                <div class="flex-grow-1 ms-3">
                                                                                                    <h6 class="fs-14 mb-1">
                                                                                                        Technical Interviewer Status
                                                                                                    </h6>
                                                                                                    <small class="text-muted" id="techIntStatus">

                                                                                                    </small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                    <br>
                                                                                    <!-- <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                                                                        <div class="accordion-body ms-2 ps-5" id="techIntRemarks">

                                                                                        </div>
                                                                                    </div> -->
                                                                                </div>
                                                                                <div class="accordion-item border-0">
                                                                                    <div class="accordion-header" id="headingTwo">
                                                                                        <a class="accordion-button p-2 shadow-none" data-bs-toggle="collapse" href="#collapseThree" aria-expanded="false">
                                                                                            <div class="d-flex">
                                                                                                <div class="flex-shrink-0">
                                                                                                    <img src="/Applicant/assets/images/users/user-dummy-img.jpg" id="tech1IntImg" alt="" class="avatar-xs rounded-circle material-shadow" />
                                                                                                </div>
                                                                                                <div class="flex-grow-1 ms-3">
                                                                                                    <h6 class="fs-14 mb-1">
                                                                                                        Technical Final Interviewer Status
                                                                                                    </h6>
                                                                                                    <small class="text-muted" id="tech1IntStatus">

                                                                                                    </small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                    <br>

                                                                                    <!-- <div id="collapseThree" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                                                                        <div class="accordion-body ms-2 ps-5" id="tech1IntRemarks">
                                                                                        </div>
                                                                                    </div> -->
                                                                                </div>
                                                                                <div class="accordion-item border-0">
                                                                                    <div class="accordion-header" id="headingFive">
                                                                                        <a class="accordion-button p-2 shadow-none" data-bs-toggle="collapse" href="#collapseFive" aria-expanded="true">
                                                                                            <div class="d-flex">
                                                                                                <div class="flex-shrink-0">
                                                                                                    <img src="/Applicant/assets/images/users/user-dummy-img.jpg" id="finalIntImg" alt="" class="avatar-xs rounded-circle material-shadow" />
                                                                                                </div>
                                                                                                <div class="flex-grow-1 ms-3">
                                                                                                    <h6 class="fs-14 mb-1">
                                                                                                        Final Interviewer Status
                                                                                                    </h6>
                                                                                                    <small class="text-muted" id="finalIntStatus">

                                                                                                    </small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                    <!-- <div id="collapseFive" class="accordion-collapse collapse show" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                                                                                        <div class="accordion-body ms-2 ps-5" id="finalIntRemarks">

                                                                                        </div>
                                                                                    </div> -->
                                                                                </div>
                                                                            </div>
                                                                            <!--end accordion-->
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div><!-- end card body -->
                                                        </div><!-- end card -->
                                                    </div><!-- end col -->
                                                </div><!-- end row -->


                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>

                                    <!--end tab-pane-->

                                </div>
                                <!--end tab-content-->
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->

                </div><!-- container-fluid -->
            </div><!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © Gainup Industries.
                        </div>
                        <div class="col-sm-6">

                        </div>
                    </div>
                </div>
            </footer>
        </div><!-- end main content-->

    </div>
    <!-- END layout-wrapper -->
    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- overview -->
    <div class="modal fade" id="OverView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">

                <div class="modal-body">
                    <input type="hidden" id="id-field" />
                    <div class="row g-3">
                        <div class="col-lg-12">
                            <div class="px-1 pt-1">
                                <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                    <img src="Applicant/assets/Img/Jobimg/background-1.jpg" alt="" id="modal-cover-img" class="img-fluid" />

                                    <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                        <div class="flex-grow-1">
                                            <h5 class="modal-title text-white">

                                            </h5>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex gap-3 align-items-center">

                                                <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="text-center mb-4 mt-n5 pt-2">
                                <div class="position-relative d-inline-block">

                                    <div class="avatar-lg p-1">
                                        <div class="avatar-title bg-light rounded-circle">
                                            <img src="Applicant/assets/Img/ApplicantProfile/logo-1.jpg" id="profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                        </div>
                                    </div>
                                </div>
                                <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                </h5>
                            </div>

                        </div>

                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="table-split">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>

                                                <p class="mt-3">Applicant Name</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-Name"></span>
                                            </td>
                                            <td>

                                                <p class="mt-3">Position </p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-position">-</span></td>
                                        </tr>
                                        <tr>
                                            <td>

                                                <p class="mt-3">Department Name</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-dept">-</span>
                                            </td>
                                            <td>

                                                <p class="mt-3">Aadhar No </p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-aadharNo"></span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <p class="mt-3">DOB</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-dob"></span></td>
                                            <td>
                                                <p class="mt-3">Contact No</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-contNo">-</span></td>

                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Marriage Details</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-marriageSts">-</span></td>

                                            <td>
                                                <p class="mt-3">Blood Group</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-bloodGrp">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Skills</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-skill">-</span></td>

                                            <td>
                                                <p class="mt-3">EmailId</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-mailid">-</span></td>
                                        </tr>

                                        <!-- <tr>
                                                    <td>
                                                        <p class="mt-3">Father/HusBand Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                                </tr> -->
                                    </tbody>
                                </table>

                                <div class="divider"></div>
                            </div>
                            <div class="table-split">
                                <h5 class="mt-3 text-center ">Address </h5>
                                <h5 class="mt-3  ">Permanent Address </h5>
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p class="mt-3">Street </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pstreet">-</span></td>

                                            <td>
                                                <p class="mt-3">Location </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-plocation">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Taluk </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ptaluk">-</span></td>

                                            <td>
                                                <p class="mt-3">District</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pdistrict">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">State </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pstate">-</span></td>

                                            <td>
                                                <p class="mt-3">Country </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pcountry">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">PinCode </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ppincode">-</span></td>

                                        </tr>

                                    </tbody>
                                </table>
                                <h5 class="mt-3  ">Current Address </h5>
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p class="mt-3">Street </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cstreet">-</span></td>

                                            <td>
                                                <p class="mt-3">Location </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-clocation">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Taluk </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ctaluk">-</span></td>

                                            <td>
                                                <p class="mt-3">District</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cdistrict">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">State </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cstate">-</span></td>

                                            <td>
                                                <p class="mt-3">Country </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ccountry">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">PinCode </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cpincode">-</span></td>


                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="m-3 text-center"> Education Details</h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Education</th>
                                        <th>Branch</th>
                                        <th>Collage/School</th>
                                        <th>University/State</th>
                                        <th>Percentage(%)</th>
                                        <th>Completed Year</th>
                                        <th>Attachment</th>
                                    </thead>
                                    <tbody id="eduTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="m-3 text-center"> Family Details</h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Occupation</th>
                                        <th>Contact No</th>
                                        <th>Age</th>

                                    </thead>
                                    <tbody id="famTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="m-3 text-center"> Known Language </h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Language</th>
                                        <th>Level</th>
                                        <th>Read</th>
                                        <th>Write</th>
                                        <th>Speak</th>

                                    </thead>
                                    <tbody id="langTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="mt-3 text-center ">Experience Details</h5>
                            <div class="table-con">
                                <table>
                                    <thead>
                                        <th>Previous company name</th>
                                        <th>Date from</th>
                                        <th>Date to</th>
                                        <th>Exp year</th>

                                        <th>Designation</th>
                                        <th>Last salary</th>

                                        <th>Reason for leaving</th>
                                        <th>Contact No</th>
                                        <th>Attachment</th>

                                    </thead>
                                    <tbody id="expTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="mt-3 text-center ">Reference</h5>
                            <div class="table-split">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>

                                                <p class="mt-3">Employee TNO</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-refEmplno"></span>
                                            </td>

                                        </tr>
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>
                </div>




                <div class="modal-footer">
                    <div class=" gap-2 ">



                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- swiper js -->
    <script src="Applicant/assets/libs/swiper/swiper-bundle.min.js"></script>

    <!-- profile init js -->
    <script src="Applicant/assets/js/pages/profile.init.js"></script>

    <!-- App js -->
    <script src="Applicant/assets/js/app.js"></script>

    <script>
        $(document).ready(function() {

            // Define a function to handle the AJAX call
            function sendSelectedValue(selectedValues) {
                $.ajax({
                    url: "candidateSts1",
                    type: "GET",
                    data: {
                        posId: selectedValues
                    },
                    success: function(response) {
                        console.log(response);
                        let selectSts = response[0];
                        $('#userImage').attr('src', selectSts.ProfileImg);

                        $('#uName').text(selectSts.ApplicantName);
                        $('#uJob').text(selectSts.jobTitle);
                        $('#uMail').text(selectSts.emailId);

                        //  ================= process bar ===============
                        let processVal = 0;

                        if (selectSts.hrSts === 'Selected') {
                            processVal = 25;
                        }
                        if (selectSts.techIntSts === 'Selected') {
                            processVal = 50;
                        }
                        if (selectSts.tech1Sts === 'Selected') {
                            processVal = 75;
                        }
                        if (selectSts.finalIntSts === 'Selected') {
                            processVal = 100;
                        }

                        $('.progress-bar').attr('aria-valuenow', processVal);
                        $('.progress-bar').css('width', processVal + '%');
                        $('.progress-bar .label').text(processVal + '%');

                        //  ================= process bar end  ===============

                        // =========================== image end ==============================

                        //  hr Image


                        if (selectSts.hrIntEmplno === "0" || selectSts.hrIntEmplno === "") {
                            $('#hrIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#hrIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.hrIntEmplno + ".jpeg");
                        }

                        //  technical interviewer Image


                        if (selectSts.techIntEmplno === "0" || selectSts.techIntEmplno === "") {
                            $('#techIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#techIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.techIntEmplno + ".jpeg");
                        }

                        //  technical 1 interviewer Image

                        if (selectSts.tech1IntEmplno === "0" || selectSts.tech1IntEmplno === "") {
                            $('#tech1IntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#tech1IntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.tech1IntEmplno + ".jpeg");
                        }

                        //  final interviewer Image

                        if (selectSts.finalIntEmplno === "0" || selectSts.finalIntEmplno === "") {
                            $('#finalIntImg').attr('src', "/Applicant/assets/images/users/user-dummy-img.jpg");
                        } else {
                            var baseUrl = window.location.origin;
                            $('#finalIntImg').attr('src', baseUrl + "/frontend/emplphotos/" + selectSts.finalIntEmplno + ".jpeg");
                        }


                        // =========================== image end ==============================

                        // ========================== remarks start =============================
                        //  HR Status 

                        (selectSts.hrRemarks === "") ? $("#hrIntRemarks").text("Not updated"): $("#hrIntRemarks").text(selectSts.hrRemarks);

                        //  HR Status 

                        (selectSts.techIntRemarks === "") ? $("#techIntRemarks").text("Not updated"): $("#techIntRemarks").text(selectSts.techIntRemarks);
                        //  HR Status 

                        (selectSts.tech1Remarks === "") ? $("#tech1IntRemarks").text("Not updated"): $("#tech1IntRemarks").text(selectSts.tech1Remarks);
                        //  HR Status 

                        (selectSts.finalIntRemarks === "") ? $("#finalIntRemarks").text("Not updated"): $("#finalIntRemarks").text(selectSts.finalIntRemarks);

                        // ========================== remarks start =============================

                        // ========================== Status start =============================
                        //  HR Status 

                        (selectSts.hrSts === "") ? $("#hrIntStatus").text("Not updated"): $("#hrIntStatus").text(selectSts.hrSts);

                        //  HR Status 

                        (selectSts.techIntSts === "") ? $("#techIntStatus").text("Not updated"): $("#techIntStatus").text(selectSts.techIntSts);
                        //  HR Status 

                        (selectSts.tech1Sts === "") ? $("#tech1IntStatus").text("Not updated"): $("#tech1IntStatus").text(selectSts.tech1Sts);
                        //  HR Status 

                        (selectSts.finalIntSts === "") ? $("#finalIntStatus").text("Not updated"): $("#finalIntStatus").text(selectSts.finalIntSts);

                        // ========================== remarks start =============================


                        //  applicant details show

                        var applicantBasicDtls = response[1];
                        var applicantEduDtls = response[2];
                        var applicantFamDtls = response[3];
                        var applicantLangDtls = response[4];
                        var applicantExpDtls = response[5];


                        let candidateRowid = applicantBasicDtls[0]['Rowid'];
                        let candidateMailId = applicantBasicDtls[0]['EmailId'];
                        let candidatePosition = applicantBasicDtls[0]['position'];
                        let candidateDept = applicantBasicDtls[0]['ADept'];
                        let candidateName = applicantBasicDtls[0]['ApplicantName'];
                        let candidateProfile = applicantBasicDtls[0]['profileImg'];

                        $('#eduTableBody').empty();
                        $('#famTableBody').empty();
                        $('#langTableBody').empty();
                        $('#expTableBody').empty();

                        //  ====================== education =========================

                        for (let i = 0; i < applicantEduDtls.length; i++) {
                            const eduMasID = applicantEduDtls[i]["masterId"];
                            if (applicantBasicDtls[0]['Rowid'] == eduMasID) {
                                const eduType = applicantEduDtls[i]["Education"];
                                const eduBranch = applicantEduDtls[i]["Branch"];
                                const eduScl_clg = applicantEduDtls[i]["Collage_School"];
                                const eduUni_state = applicantEduDtls[i]["University_Board"];
                                const eduPercentage = applicantEduDtls[i]["Percentage"];
                                const eduYearOfComp = applicantEduDtls[i]["YearofComplition"];
                                let eduAttach = applicantEduDtls[i]["eduAttach"];
                                const newRow = $('<tr>');
                                newRow.append('<td >' + eduType + '</td>');
                                newRow.append('<td >' + eduBranch + '</td>');
                                newRow.append('<td >' + eduScl_clg + '</td>');
                                newRow.append('<td >' + eduUni_state + '</td>');
                                newRow.append('<td >' + eduPercentage + '</td>');
                                newRow.append('<td >' + eduYearOfComp + '</td>');
                                if (eduAttach == "") {
                                    eduAttach = "no Attachment";
                                    newRow.append('<td >' + eduAttach + '</td>');
                                } else {

                                    newRow.append('<td>' + '<a href="' + eduAttach + '" download ="education">Download</a>' + '</td>');

                                }
                                $('#eduTableBody').append(newRow);
                            } else {

                            }
                        }



                        // end education  ===============  

                        //   ========================= family =====================================

                        for (let i = 0; i < applicantFamDtls.length; i++) {

                            const famMasID = applicantFamDtls[i]["MasterId"];
                            if (applicantBasicDtls[0]['Rowid'] == famMasID) {

                                const famName = applicantFamDtls[i]["Name"];
                                const famType = applicantFamDtls[i]["Type"];
                                const famOccupation = applicantFamDtls[i]["Occupation"];
                                const famContNo = applicantFamDtls[i]["ContactNo"];
                                const famAge = applicantFamDtls[i]["Age"];

                                const newRow = $('<tr>');
                                newRow.append('<td >' + famName + '</td>');
                                newRow.append('<td >' + famType + '</td>');
                                newRow.append('<td >' + famOccupation + '</td>');
                                newRow.append('<td >' + famContNo + '</td>');
                                newRow.append('<td >' + famAge + '</td>');
                                $('#famTableBody').append(newRow);
                            } else {

                            }

                        }

                        //  end family =================================

                        //   ========================= landuage =====================================

                        for (let i = 0; i < applicantLangDtls.length; i++) {

                            const langMasID = applicantLangDtls[i]["MasterId"];

                            if (applicantBasicDtls[0]['Rowid'] == langMasID) {

                                const langType = applicantLangDtls[i]["Lang"];
                                const langLevel = applicantLangDtls[i]["Level"];
                                const langReading = applicantLangDtls[i]["Reading"];
                                const langSpeak = applicantLangDtls[i]["Speak"];
                                const langWrite = applicantLangDtls[i]["Write"];


                                const newRow = $('<tr>');
                                newRow.append('<td >' + langType + '</td>');
                                newRow.append('<td >' + langLevel + '</td>');
                                newRow.append('<td >' + langReading + '</td>');
                                newRow.append('<td >' + langSpeak + '</td>');
                                newRow.append('<td >' + langWrite + '</td>');
                                $('#langTableBody').append(newRow);
                            } else {

                            }

                        }

                        //  end language =================================

                        // experience start =======================
                        console.log(applicantExpDtls);
                        for (let i = 0; i < applicantExpDtls.length; i++) {

                            const expMasID = applicantExpDtls[i]["MasterId"];

                            if (applicantBasicDtls[0]['Rowid'] == expMasID) {

                                var PCompany = applicantExpDtls[i]["PCompany"];
                                var FDate = applicantExpDtls[i]["FDate"];
                                var FdateOnly = FDate.split(' ')[0];
                                var TDate = applicantExpDtls[i]["TDate"];
                                var TdateOnly = TDate.split(' ')[0];

                                var ExpYear = applicantExpDtls[i]["ExpYear"];
                                // var Pdept = applicantExpDtls[i]["Department"];
                                var Pdesign = applicantExpDtls[i]["Designation"];
                                var LastSalary = applicantExpDtls[i]["LastSalary"];
                                // var ExpectSalary = applicantExpDtls[i]["ExpectSalary"];
                                var ResForLeave = applicantExpDtls[i]["ResForLeave"];
                                var pContactNo = applicantExpDtls[i]["pContactNo"];
                                var RefEmplno = applicantExpDtls[i]["RefEmplno"];
                                var ExpAttatchment = applicantExpDtls[i]["ExpAttatchment"];
                                const newRow = $('<tr>');
                                newRow.append('<td >' + PCompany + '</td>');
                                newRow.append('<td >' + FdateOnly + '</td>');
                                newRow.append('<td >' + TdateOnly + '</td>');
                                newRow.append('<td >' + ExpYear + '</td>');
                                // newRow.append('<td >' + Pdept + '</td>');
                                newRow.append('<td >' + Pdesign + '</td>');
                                newRow.append('<td >' + LastSalary + '</td>');
                                // newRow.append('<td >' + ExpectSalary + '</td>');
                                newRow.append('<td >' + ResForLeave + '</td>');
                                newRow.append('<td >' + pContactNo + '</td>');
                                if (ExpAttatchment == "") {
                                    ExpAttatchment = "No Attachment";
                                    newRow.append('<td>' + ExpAttatchment + '</td>');
                                } else {
                                    newRow.append('<td>' + '<a href="' + ExpAttatchment + '" download="experience">Download</a>' + '</td>');
                                }

                                $('#expTableBody').append(newRow);
                            } else {

                            }

                        }

                        // end experience ====================

                        var BackImg = applicantBasicDtls[0]["BackImg"];
                        var profileImg = applicantBasicDtls[0]["profileImg"];
                        var resumeAttach = applicantBasicDtls[0]["resumeAttach"];
                        var ExpAttatchment = applicantBasicDtls[0]["ExpAttatchment"];

                        var ApplicantName = applicantBasicDtls[0]["ApplicantName"];
                        var ADept = applicantBasicDtls[0]["ADept"];
                        var position = applicantBasicDtls[0]["position"];
                        var AadharNo = applicantBasicDtls[0]["AadharNo"];
                        var DOB = applicantBasicDtls[0]["DOB"];
                        var ContactNo = applicantBasicDtls[0]["ContactNo"];
                        var BloodGroup = applicantBasicDtls[0]["BloodGroup"];
                        var MarrigeSts = applicantBasicDtls[0]["MarrigeSts"];
                        var skill = applicantBasicDtls[0]["skill"];
                        var EmailId = applicantBasicDtls[0]["EmailId"];


                        $('#candidate-rowid').val(candidateRowid);
                        $('#candidate-mailid').val(candidateMailId);
                        $('#candidate-position').val(candidatePosition);
                        $('#candidate-dept').val(candidateDept);
                        $('#candidate-name').val(candidateName);
                        $('#profile-img-can').attr('src', candidateProfile);
                        $('#modal-cover-img-can').attr('src', BackImg);

                        $('#applicant-Name').text(ApplicantName);
                        $('#applicant-dept').text(ADept);
                        $('#applicant-position').text(position);
                        $('#applicant-aadharNo').text(AadharNo);
                        $('#applicant-dob').text(DOB);
                        $('#applicant-contNo').text(ContactNo);
                        $('#applicant-marriageSts').text(MarrigeSts);
                        $('#applicant-bloodGrp').text(BloodGroup);
                        $('#applicant-skill').text(skill);
                        $('#applicant-mailid').text(EmailId);

                        // permanent Address 
                        var PStreet = applicantBasicDtls[0]["PStreet"];
                        var Plocation = applicantBasicDtls[0]["Plocation"];
                        var PTaluk = applicantBasicDtls[0]["PTaluk"];
                        var PDistrict = applicantBasicDtls[0]["PDistrict"];
                        var Pstate = applicantBasicDtls[0]["Pstate"];
                        var PCountry = applicantBasicDtls[0]["PCountry"];
                        var ppincode = applicantBasicDtls[0]["ppincode"];

                        $('#applicant-pstreet').text(PStreet);
                        $('#applicant-plocation').text(Plocation);
                        $('#applicant-ptaluk').text(PTaluk);
                        $('#applicant-pdistrict').text(PDistrict);
                        $('#applicant-pstate').text(Pstate);
                        $('#applicant-pcountry').text(PCountry);
                        $('#applicant-ppincode').text(ppincode);


                        // current address 
                        var CStreet = applicantBasicDtls[0]["CStreet"];
                        var Clocation = applicantBasicDtls[0]["Clocation"];
                        var CTaluk = applicantBasicDtls[0]["CTaluk"];
                        var CDistrict = applicantBasicDtls[0]["CDistrict"];
                        var Cstate = applicantBasicDtls[0]["Cstate"];
                        var CCountry = applicantBasicDtls[0]["CCountry"];
                        var Cpincode = applicantBasicDtls[0]["Cpincode"];

                        $('#applicant-cstreet').text(CStreet);
                        $('#applicant-clocation').text(Clocation);
                        $('#applicant-ctaluk').text(CTaluk);
                        $('#applicant-cdistrict').text(CDistrict);
                        $('#applicant-cstate').text(Cstate);
                        $('#applicant-ccountry').text(CCountry);
                        $('#applicant-cpincode').text(Cpincode);
                        // experience details


                        var RefEmplno = applicantBasicDtls[0]["RefEmplno"];
                        if (RefEmplno == 0) {
                            RefEmplno = "No Reference";
                        }
                        $('#applicant-refEmplno').text(RefEmplno);



                    }
                });
            }

            let initialSelectedValue = $("#jobName").val();
            sendSelectedValue(initialSelectedValue);
            $("#jobName").on('change', function() {
                let selectedValues = $(this).val();
                sendSelectedValue(selectedValues);
            });
        });
    </script>

    <script>

    </script>

</body>


<!-- Mirrored from themesbrand.com/velzon/html/master/pages-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:46:12 GMT -->

</html>