<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">
<!-- Mirrored from themesbrand.com/velzon/html/master/apps-job-candidate-lists.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:47:54 GMT -->

<head>
    <meta charset="utf-8" />
    <title>
        APPLICANT STATUS
    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />


    <!-- gridjs css -->
    <link rel="stylesheet" href="Applicant/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!--  ================== star Start ====== -->

    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">


    <style>
        @import url(https://fonts.googleapis.com/css?family=Roboto:500,100,300,700,400);

        body {
            background-color: #eee;

        }

        div.stars {

            display: inline-block;
        }

        input.star {

            display: none;
        }

        label.star {

            float: right;

            padding-left: 5px;

            font-size: 25px;

            color: #4A148C;

            transition: all .2s;

        }

        input.star:checked~label.star:before {

            content: '\f005';

            color: #FD4;

            transition: all .25s;

        }

        input.star-5:checked~label.star:before {

            color: #FE7;

            text-shadow: 0 0 20px #952;

        }

        input.star-1:checked~label.star:before {
            color: #F62;
        }

        label.star:hover {
            transform: rotate(-15deg) scale(1.3);
        }

        label.star:before {

            content: '\f006';

            font-family: FontAwesome;

        }
    </style>

    <!--  ================== star end ====== -->

    <!-- ==================== for table ==================== -->

    <style>
        .table-split table tbody tr td {
            width: 0px !important;
            border: none;
        }

        table tbody td,
        table thead th {

            padding: 5px;
            border: 1px solid gray;
        }

        table {
            width: 100%;

        }

        .table-con {
            overflow-x: auto;
        }

        @media (max-width: 426px) {
            .table-split table tbody tr td {
                width: 0px;

            }

            .table-split table tbody td:nth-child(2),
            .table-split table tbody td:nth-child(5) {
                display: none;
                /* flex-wrap: wrap; */
            }

            .table-split table tbody td {

                display: flex;

                flex-wrap: wrap;
            }

        }
    </style>

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        @extends('Applicant.navbar')
        @section('content')
        <?php $userEmplNo = Session::get('empl_id');
        echo $userEmplNo; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <!-- <h4 class="mb-sm-0">List View</h4> -->

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item">
                                            <a href="javascript: void(0);">Applicant Status</a>
                                        </li>

                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <!-- <h6 class="card-title mb-0 flex-grow-1">
                                            Search Candidates
                                        </h6> -->

                                    </div>
                                    @if ($message = Session::get('selected'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}}.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('Rejected'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}}.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('Error'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Something </strong>Wrong does not submitted.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif


                                    @if ($message = Session::get('selected-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} for next round.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif

                                    @if ($message = Session::get('Rejected-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} .
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('waiting-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-warning text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} .
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif


                                    <div class="row gy-3">
                                        <div class="col-xxl-2">
                                            <label>Month</label>
                                            <select class="form-control select2" name="Month" id="Month" onchange="ChangeMonth(this.value)">
                                                <option value="ALL">ALL DATA</option>
                                                @foreach ($Monthlist as $key => $Mon)
                                                <option value="{{$Mon['Entrytime']}}" {{ $key == 0 ? 'selected' : '' }}>{{$Mon['Entrytime']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-xxl-3">
                                            <label>Applicant Name</label>
                                            <select class="form-control select2" name="ApplicantName" id="ApplicantName" onchange="ChangeApplicant(this.value)">
                                                <option value="">--Select Applicant Name--</option>
                                            </select>
                                        </div>
                                        <div class="col-xxl-5 col-md-6 mt-4">
                                            <div class="search-box">
                                                <input type="text" class="form-control search bg-light border-light" id="searchJob" autocomplete="off" placeholder="Search for Candidates..." />
                                                <i class="ri-search-line search-icon"></i>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 d-flex justify-content-end">
                                            <button class="btn btn-danger" onclick="toggleRejected()">Rejected Candidates</button>
                                        </div>

                                        <div class="col-xl-12 d-none" id="found-job-alert">
                                            <div class="alert alert-success mb-0 text-center" role="alert">
                                                <strong id="total-result">0</strong>
                                                Candidates found
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <h5 id="Count_candidates">0 Candidates found</h5>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $ATSApplicantStsEntry = Session::get('ATSApplicantStsEntry');

                    ?>
                    <div class="row gy-2 mb-2" id="candidate-list">

                        @if ($ATSApplicantStsEntry === "Y")

                        <div class=" d-flex justify-content-center align-items-center">

                            <!-- Spinner -->
                            <div id="spinner" class="col-md-1 mb-4" style="display: none;">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row" id="candidate_Rejected" style="display: none;">
                        @foreach($applicantRejSts as $applicantReject)
                        <div class="col-xxl-6 joblist-card ">
                            <div id="job-list">
                                <div class="card joblist-card">
                                    <div class="card-body">
                                        <div class="d-flex mb-4">
                                            <div class="avatar-sm">
                                                <div class="avatar-title bg-light rounded">
                                                    <img src="
                                                            @if ($applicantReject['profileImg'] == '')
                                                                {{ asset('Applicant/assets/Img/Jobimg/logo.jpg') }}
                                                            @else
                                                                {{ $applicantReject['profileImg'] }}
                                                            @endif
                                                        " alt="" class="avatar-xxs companyLogo-img" />

                                                </div>
                                            </div>
                                            <div class="ms-3 flex-grow-1">
                                                <img src="" alt="" class="d-none cover-img" />

                                                <a href="#!" class="viewcan-list" data-bs-toggle="modal" data-bs-target="#canDetails" data-can-details="{{ json_encode($applicantReject) }}" data-can-edu="{{ json_encode($canEdu) }}" data-can-fam="{{ json_encode($canFam) }}" data-can-lang="{{ json_encode($canLang) }}" data-can-exp="{{ json_encode($canExp) }}" data-job-lists="{{ json_encode($joblist) }}">
                                                    <h5 class="job-title"> {{$applicantReject['ApplicantName']}} - {{$applicantReject['canNo']}} </h5>
                                                    <!-- <i class="ri-arrow-right-line align-bottom ms-1"></i> -->
                                                </a>
                                                <p class="company-name text-muted mb-0">
                                                    {{$applicantReject['position']}} - {{$applicantReject['ADept']}}

                                                    <span class="badge bg-danger ms-5" id="select-status">
                                                        @if($applicantReject['status'] == "Rejected")
                                                        Rejected
                                                        @endif

                                                    </span>
                                                </p>

                                            </div>
                                            <div>
                                                <!-- <button type="button" class="btn btn-ghost-primary btn-icon custom-toggle viewjob-list" data-job-details="{{ json_encode($applicantReject) }}" data-job-lists="{{ json_encode($joblist) }}" data-bs-toggle="modal" data-bs-target="#selectShow"> -->
                                                <span class="icon-on"><i class="ri-user-add-line" class=""></i></span>

                                                </button>
                                            </div>

                                        </div>
                                        <!-- <p class="text-muted job-description">
                                                test
                                            </p> -->
                                        <div>Skill : {{$applicantReject['skill']}}</div>
                                    </div>
                                    <div class="card-footer border-top-dashed">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                            <!-- <div>
                                                    <i class="ri-briefcase-2-line align-bottom me-1"></i>
                                                    <span class="job-type">Applied On : {{ \Carbon\Carbon::parse($applicantReject['Entrytime'])->format('d-M-Y') }} </span>
                                                </div> -->

                                            <div>
                                                @if($applicantReject['resumeAttach'] != "")
                                                <a href="{{$applicantReject['resumeAttach']}}" download="Resume">Resume <i class="ri-arrow-down-line align-bottom ms-1"></i></a>
                                                @else
                                                --
                                                @endif
                                            </div>

                                            <div>
                                                <a href="#!" class="btn btn-primary viewjob-list" data-bs-toggle="modal" data-bs-target="#OverView" data-job-details="{{ json_encode($applicantReject) }}" data-job-lists="{{ json_encode($joblist) }}" data-interviewer-status="{{ json_encode($interviewerSts) }}">
                                                    Interviewer Details
                                                    <!-- <i class="ri-arrow-right-line align-bottom ms-1"></i> -->
                                                </a>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif


                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear());
                            </script>
                            © Gainup Industries.
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>

        <!-- INTERVIEW DETAILS -->
        <div class="modal fade" id="OverView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl">
                <div class="modal-content border-0">
                    <form id="createjob-form" autocomplete="off" class="needs-validation" novalidate>
                        <div class="modal-body">
                            <input type="hidden" id="id-field" />
                            <div class="row g-3">
                                <div class="col-lg-12">
                                    <div class="px-1 pt-1">
                                        <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                            <img src="" alt="" id="modal-cover-img" class="img-fluid" />

                                            <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                                <div class="flex-grow-1">
                                                    <h5 class="modal-title text-white">

                                                    </h5>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <div class="d-flex gap-3 align-items-center">

                                                        <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="text-center mb-4 mt-n5 pt-2">
                                        <div class="position-relative d-inline-block">

                                            <div class="avatar-lg p-1">
                                                <div class="avatar-title bg-light rounded-circle">
                                                    <img src="" id="profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                                </div>
                                            </div>
                                        </div>
                                        <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                        </h5>
                                    </div>

                                </div>

                            </div>

                            <div class="card">
                                <div class="card-body">
                                    <div>

                                        <h5 class="mt-3 text-center ">Interviewer Details</h5>
                                        <div class="table-split">
                                            <table>
                                                <tbody id="interviewerDtlsTBody">
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">Company</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-int-company">-</span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">Department</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-int-Department">-</span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">HR Name</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-hrName">-</span></td>
                                                        <td><span class="badge bg-success " id="hr-status">not updated</span></td>
                                                        <td><span class="text-body-secondary " id="hr-remarks">no remarks </span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">Technical Interviewer</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-techIntName">-</span></td>
                                                        <td><span class="badge bg-success " id="tech-status">not updated</span></td>
                                                        <td><span class="text-body-secondary " id="tech-remarks">no remarks </span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">Technical Final</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-techIntFinalName">-</span></td>
                                                        <td><span class="badge bg-success " id="tech1-status">not updated</span></td>
                                                        <td><span class="text-body-secondary " id="tech1-remarks">no remarks </span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <p class="mt-3">Final Interviewer</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><span class="text-body-secondary " id="job-finalIntName">-</span></td>
                                                        <td><span class="badge bg-success " id="final-int-status">not updated</span></td>
                                                        <td><span class="text-body-secondary " id="final-int-remarks">no remarks </span></td>
                                                    </tr>
                                                    <!-- <tr>
                                                        <td>
                                                            <p class="mt-3">Share this job</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><a href="#!" class="btn btn-icon btn-soft-info"><i class="ri-facebook-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-success"><i class="ri-whatsapp-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-secondary"><i class="ri-twitter-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-danger"><i class="ri-mail-line"></i></a></td>
                                                    </tr> -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="hstack gap-2 justify-content-end">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                    Close
                                </button>

                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- CANDIDATE FULL DETAILS -->
        <div class="modal fade" id="canDetails" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0">

                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="Applicant/assets/Img/Jobimg/background-1.jpg" alt="" id="modal-cover-img-can" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="Applicant/assets/Img/ApplicantProfile/logo-1.jpg" id="profile-img-can" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>

                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div class="table-split">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Applicant Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-Name"></span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Position </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-position">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Department Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dept">-</span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Aadhar No </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-aadharNo"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">DOB</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dob"></span></td>
                                                <td>
                                                    <p class="mt-3">Contact No</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-contNo">-</span></td>

                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Marriage Details</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-marriageSts">-</span></td>

                                                <td>
                                                    <p class="mt-3">Blood Group</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-bloodGrp">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-skill">-</span></td>

                                                <td>
                                                    <p class="mt-3">EmailId</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-mailid">-</span></td>
                                            </tr>

                                            <!-- <tr>
                                                    <td>
                                                        <p class="mt-3">Father/HusBand Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                                </tr> -->
                                        </tbody>
                                    </table>

                                    <div class="divider"></div>
                                </div>
                                <div class="table-split">
                                    <h5 class="mt-3 text-center ">Address </h5>
                                    <h5 class="mt-3  ">Permanent Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-plocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ptaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pcountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ppincode">-</span></td>

                                            </tr>

                                        </tbody>
                                    </table>
                                    <h5 class="mt-3  ">Current Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-clocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ctaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ccountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cpincode">-</span></td>


                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <h5 class="m-3 text-center"> Education Details</h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Education</th>
                                            <th>Branch</th>
                                            <th>Collage/School</th>
                                            <th>University/State</th>
                                            <th>Percentage(%)</th>
                                            <th>Completed Year</th>
                                            <th>Attachment</th>
                                        </thead>
                                        <tbody id="eduTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="m-3 text-center"> Family Details</h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Occupation</th>
                                            <th>Contact No</th>
                                            <th>Age</th>

                                        </thead>
                                        <tbody id="famTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="m-3 text-center"> Known Language </h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Language</th>
                                            <th>Level</th>
                                            <th>Read</th>
                                            <th>Write</th>
                                            <th>Speak</th>

                                        </thead>
                                        <tbody id="langTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="mt-3 text-center ">Experience Details</h5>
                                <div class="table-con">
                                    <table>
                                        <thead>
                                            <th>Previous company name</th>
                                            <th>Date from</th>
                                            <th>Date to</th>
                                            <th>Exp year</th>

                                            <th>Designation</th>
                                            <th>Last salary</th>

                                            <th>Reason for leaving</th>
                                            <th>Contact No</th>
                                            <th>Attachment</th>

                                        </thead>
                                        <tbody id="expTableBody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class=" gap-2 ">

                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                Close
                            </button>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- EVALUATION FORM -->
        <div class="modal fade modalSelect" id="EvalShow" tabindex="-1" aria-labelledby="exampleModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0">
                    <div class="modal-body">
                        <form action="candidateStsUpdate" method="post" id="candidateForm">
                            @csrf
                            <input type="hidden" id="id-field" />
                            <div class="row g-3">
                                <div class="col-lg-12">
                                    <div class="px-1 pt-1">
                                        <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                            <img src="" alt="" id="select-modal-cover-img" class="img-fluid" />
                                        </div>
                                    </div>
                                    <div class="text-center mb-4 mt-n5 pt-2">
                                        <div class="position-relative d-inline-block">
                                            <div class="avatar-lg p-1">
                                                <div class="avatar-title bg-light rounded-circle">
                                                    <img src="" id="select-profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table ">
                                            <thead>
                                                <tr>
                                                    <th>Evaluation Points</th>
                                                    <th>Remarks</th>
                                                    <th>Marks</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($evalReport as $index => $evalReports)
                                                <tr>
                                                    <td>
                                                        <p>{{$evalReports['EvalName']}}</p>

                                                        <input type="hidden" name="evalId[]" value=" {{$evalReports['EvalId']}}">
                                                        <input type="hidden" name="deptId" value=" {{$evalReports['DeptCode']}}">
                                                    </td>
                                                    <td>
                                                        <p>{{$evalReports['Remarks']}}</p>
                                                    </td>
                                                    <td>
                                                        <div class="stars">
                                                            @php
                                                            $starArrayName = "stars[$index]"; // Array name for stars
                                                            @endphp
                                                            <input class="star star-5" id="star-{{$index}}-5" type="radio" value="5" name="{{$starArrayName}}" required />
                                                            <label class="star star-5" for="star-{{$index}}-5"></label>
                                                            <input class="star star-4" id="star-{{$index}}-4" type="radio" value="4" name="{{$starArrayName}}" required />
                                                            <label class="star star-4" for="star-{{$index}}-4"></label>
                                                            <input class="star star-3" id="star-{{$index}}-3" type="radio" value="3" name="{{$starArrayName}}" required />
                                                            <label class="star star-3" for="star-{{$index}}-3"></label>
                                                            <input class="star star-2" id="star-{{$index}}-2" type="radio" value="2" name="{{$starArrayName}}" required />
                                                            <label class="star star-2" for="star-{{$index}}-2"></label>
                                                            <input class="star star-1" id="star-{{$index}}-1" type="radio" value="1" name="{{$starArrayName}}" required />
                                                            <label class="star star-1" for="star-{{$index}}-1"></label>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xxl-12 d-flex justify-content-between mt-4">
                                    <!-- Without labels Radios -->
                                    <div class="form-check form-check-inline me-4">
                                        <input class="form-check-input" type="radio" name="selectCan" id="WithoutinlineRadio1" value="Selected">
                                        <label for="WithoutinlineRadio1">Selected</label>
                                    </div>
                                    <div class="form-check form-check-inline me-4">
                                        <input class="form-check-input" type="radio" name="selectCan" id="WithoutinlineRadio2" value="Waiting">
                                        <label for="WithoutinlineRadio2">Waiting</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="selectCan" id="WithoutinlineRadio4" value="Rejected">
                                        <label for="WithoutinlineRadio4">Rejected</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-xxl-12">
                                    <textarea name="Remarks" id="intRemarks" cols="30" rows="3" class="form-control" required></textarea>

                                    <input type="hidden" name="canId" id="canId">
                                    <input type="hidden" name="posId" id="posId">
                                    <input type="hidden" name="posName" id="posName">
                                    <input type="hidden" name="DeptA" id="DeptA">
                                    <input type="hidden" name="canName" id="canName">
                                    <input type="hidden" name="canMail" id="canMail">

                                    <input type="hidden" name="hrEmplno" id="hrEmplno">
                                    <input type="hidden" name="techEmplno" id="techEmplno">
                                    <input type="hidden" name="tech1Emplno" id="tech1Emplno">
                                    <input type="hidden" name="FinalEmplno" id="FinalEmplno">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary" id="mark-update">Submit</button>
                                </div>
                        </form>
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" id="select-close" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    </div>

    <!-- END layout-wrapper -->

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->

    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>
    <script src="Applicant/assets/libs/fullcalendar/index.global.min.js"></script>
    <script src="Applicant/assets/js/pages/job-candidate-lists.init.js"></script>
    <script src="Applicant/assets/js/pages/choice.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.min.js"></script>
    <script src="Applicant/assets/js/pages/calendar.init.js"></script>
    <script src="Applicant/assets/libs/gridjs/gridjs.umd.js"></script>
    <script src="Applicant/assets/js/app.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Flatpickr for time input
            const timepickerOptions = {
                enableTime: true,
                noCalendar: true,
                dateFormat: 'h:i K', // 12-hour format with AM/PM indicator
                time_24hr: false, // Set to false for 12-hour time
                disableMobile: true,
                allowInput: true // Allow manual typing
            };

            // Initialize time pickers with individual default times
            flatpickr('#timepicker1', {
                ...timepickerOptions,
                defaultDate: "9:00 AM"
            });
            flatpickr('#timepicker2', {
                ...timepickerOptions,
                defaultDate: "10:00 AM"
            });
        });
    </script>

    <script>
        function toggleRejected() {
            // Hide the regular candidate list
            $('#candidate-list').hide();

            // Show the rejected candidate list
            $('#candidate_Rejected').show();
        }
    </script>


    <!-- MONTH WISE APPLICANT DETAILS -->
    <script>
        $(document).ready(function() {
            let firstMonth = $("#Month option:selected").val();
            CanDet_monthwise(firstMonth);
        });

        function ChangeMonth() {
            let selectedMonth = $("#Month").val();
            CanDet_monthwise(selectedMonth);
        }

        function CanDet_monthwise(Month) {
            try {

                Month = Month || $("#Month").val();
                console.log('Month', Month);
                $('#spinner').show();

                $.ajax({
                    url: "{{ route('ApplicantSts_monthly') }}",
                    type: "GET",
                    data: {
                        Month: Month
                    },
                    dataType: 'json',
                    success: function(Month_ApplicantNam) {
                        console.log('Candidate Monthly ', Month_ApplicantNam);

                        // Get total count
                        var totalCandidates = Month_ApplicantNam.Appli_Name ? Month_ApplicantNam.Appli_Name.length : 0;

                        $("#Count_candidates").text(totalCandidates + " Candidates found");

                        if (Month_ApplicantNam.Appli_Name && Month_ApplicantNam.Appli_Name.length > 0) {
                            var applicantDropdown = $("#ApplicantName"); // Make sure the ID matches your second select
                            applicantDropdown.empty(); // Clear previous options
                            applicantDropdown.append('<option value="">--Select Applicant Name--</option>'); // Add default option

                            // Populate dropdown with data
                            Month_ApplicantNam.Appli_Name.forEach(function(applicant) {
                                if (applicant.ApplicantName) {
                                    applicantDropdown.append(`<option value="${applicant.Rowid}">${applicant.ApplicantName}/${applicant.canNo}/${applicant.position}</option>`);
                                }
                            });
                        }

                        // Clear previous data
                        $('#candidate-list').empty();

                        // Iterate over the data and populate elements dynamically
                        Month_ApplicantNam.Monwise_det.forEach(function(candidate) {
                            // Manually parse DD/MM/YYYY HH:MM:SS format
                            var entryTimeParts = candidate.Entrytime.split(" ")[0].split("/");
                            var formattedDate = entryTimeParts[2] + "-" + entryTimeParts[1] + "-" + entryTimeParts[0]; // Convert to YYYY-MM-DD

                            var entryTime = new Date(formattedDate).toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });

                            var candidateHTML = `
                                <div class="col-xxl-6 joblist-card">
                                    <div id="job-list">
                                        <div class="card joblist-card">
                                            <div class="card-body">
                                                <div class="d-flex mb-4">
                                                    <div class="avatar-sm">
                                                        <div class="avatar-title bg-light rounded">
                                                            <img src="${candidate.profileImg ? candidate.profileImg : "{{ asset('Applicant/assets/Img/Jobimg/logo.jpg') }}"}" alt="" class="avatar-xxs companyLogo-img" />
                                                            <input type="hidden" class="canRowid" value="${candidate.Rowid}">
                                                        </div>
                                                    </div>
                                                    <div class="ms-3 flex-grow-1">
                                                        <img src="" alt="" class="d-none cover-img" />

                                                        <a href="#!" class="viewcan-list"  onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            <h5 class="job-title">${candidate.ApplicantName} - ${candidate.canNo}</h5>
                                                        </a>
                                                        <p class="company-name text-muted mb-0">
                                                            ${candidate.position} - ${candidate.ADept ? candidate.ADept : ""}
                                                            <span></span>
                                                            <span class="badge bg-success ms-5 select-status" id="select-status">
                                                                ${candidate.status === "Selected-1" ? "Selected" : ""}
                                                            </span>
                                                        </p>
                                                    </div>

                                                    <div id="evaluation-btn">
                                                        <button type="button" class="btn btn-ghost-primary custom-toggle viewMark"onclick="EvaluationClick('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            <span class="icon-on"><i class="ri-user-add-line"></i></span>
                                                            Evaluation
                                                        </button>
                                                    </div>
                                                </div>

                                                <div>Skill: ${candidate.skill}</div>
                                            </div>
                                            <div class="card-footer border-top-dashed">
                                                <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                                    <div>
                                                        <a href="${candidate.resumeAttach}" download="Resume">Resume 
                                                            <i class="ri-arrow-down-line align-bottom ms-1"></i>
                                                        </a>
                                                    </div>
                                                    <div>
                                                        <a href="#!" class="btn btn-primary viewjob-list" onclick="InterviewSts('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            Interviewer Details
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;


                            // Append the candidate's HTML to the container
                            $('#candidate-list').append(candidateHTML);

                            let selectStatus = $('.select-status').last();
                            let hrSts = candidate.hrSts || "";
                            let techIntSts = candidate.techIntSts || "";
                            let tech1Sts = candidate.tech1Sts || "";
                            let finalIntSts = candidate.finalIntSts || "";

                            if (hrSts && !techIntSts && !tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(hrSts === "Waiting" ? "badge bg-warning" : hrSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(hrSts || "not updated");
                            } else if (hrSts && techIntSts && !tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(techIntSts === "Waiting" ? "badge bg-warning" : techIntSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(techIntSts || "not updated");
                            } else if (techIntSts && tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(tech1Sts === "Waiting" ? "badge bg-warning" : tech1Sts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(tech1Sts || "updated");
                            } else if (finalIntSts) {
                                selectStatus.removeClass().addClass(finalIntSts === "Waiting" ? "badge bg-warning" : finalIntSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(finalIntSts || "not updated");
                            }
                        });
                        $('#candidate_Rejected').hide();
                        $('#candidate-list').show();
                        $('#spinner').hide();
                    },
                    error: function(status, error) {
                        console.error('Ajax Error', status, error);
                        $('#spinner').hide();
                        // Show an alert with error details
                        alert('Error occurred while fetching data in CanDet_monthwise Function : ' + error);
                    }
                });
            } catch (error) {
                alert('Error Message in CanDet_monthwise Function: ' + error.message);
                console.error('Catch Error:', error);
                $('#spinner').hide();
            }
        }

        function ChangeApplicant(ApplicantID) {
            try {
                console.log('Applicant ID', ApplicantID);
                $('#spinner').show();
                $.ajax({
                    url: "{{ route('ApplicantSts_change') }}",
                    type: "GET",
                    data: {
                        Applicant_ID: ApplicantID,
                    },
                    dataType: 'json',
                    success: function(Applicant_det) {
                        console.log('APPLICANT Monthly ', Applicant_det);

                        // Get total count
                        var totalCandidates = Applicant_det ? Applicant_det.length : 0;

                        // Update the candidate count display
                        $("#Count_candidates").text(totalCandidates + " Candidates found");

                        // Clear previous data
                        $('#candidate-list').empty();

                        // Iterate over the data and populate elements dynamically
                        Applicant_det.forEach(function(candidate) {
                            // Manually parse DD/MM/YYYY HH:MM:SS format
                            var entryTimeParts = candidate.Entrytime.split(" ")[0].split("/");
                            var formattedDate = entryTimeParts[2] + "-" + entryTimeParts[1] + "-" + entryTimeParts[0]; // Convert to YYYY-MM-DD

                            var entryTime = new Date(formattedDate).toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });

                            var candidateHTML = `
                                <div class="col-xxl-6 joblist-card">
                                    <div id="job-list">
                                        <div class="card joblist-card">
                                            <div class="card-body">
                                                <div class="d-flex mb-4">
                                                    <div class="avatar-sm">
                                                        <div class="avatar-title bg-light rounded">
                                                            <img src="${candidate.profileImg ? candidate.profileImg : "{{ asset('Applicant/assets/Img/Jobimg/logo.jpg') }}"}" alt="" class="avatar-xxs companyLogo-img" />
                                                            <input type="hidden" class="canRowid" value="${candidate.Rowid}">
                                                        </div>
                                                    </div>
                                                    <div class="ms-3 flex-grow-1">
                                                        <img src="" alt="" class="d-none cover-img" />

                                                        <a href="#!" class="viewcan-list"  onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            <h5 class="job-title">${candidate.ApplicantName} - ${candidate.canNo}</h5>
                                                        </a>
                                                        <p class="company-name text-muted mb-0">
                                                            ${candidate.position} - ${candidate.ADept ? candidate.ADept : ""}
                                                            <span></span>
                                                            <span class="badge bg-success ms-5 select-status" id="select-status">
                                                                ${candidate.status === "Selected-1" ? "Selected" : ""}
                                                            </span>
                                                        </p>
                                                    </div>

                                                    <div id="evaluation-btn">
                                                        <button type="button" class="btn btn-ghost-primary custom-toggle viewMark"onclick="EvaluationClick('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            <span class="icon-on"><i class="ri-user-add-line"></i></span>
                                                            Evaluation
                                                        </button>
                                                    </div>
                                                </div>

                                                <div>Skill: ${candidate.skill}</div>
                                            </div>
                                            <div class="card-footer border-top-dashed">
                                                <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                                    <div>
                                                        <a href="${candidate.resumeAttach}" download="Resume">Resume 
                                                            <i class="ri-arrow-down-line align-bottom ms-1"></i>
                                                        </a>
                                                    </div>
                                                    <div>
                                                        <a href="#!" class="btn btn-primary viewjob-list" onclick="InterviewSts('` + candidate.Rowid + `', '` + candidate.jobId + `')"'>
                                                            Interviewer Details
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;

                            // Append the candidate's HTML to the container
                            $('#candidate-list').append(candidateHTML);

                            let selectStatus = $('.select-status').last();
                            let hrSts = candidate.hrSts || "";
                            let techIntSts = candidate.techIntSts || "";
                            let tech1Sts = candidate.tech1Sts || "";
                            let finalIntSts = candidate.finalIntSts || "";

                            if (hrSts && !techIntSts && !tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(hrSts === "Waiting" ? "badge bg-warning" : hrSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(hrSts || "not updated");
                            } else if (hrSts && techIntSts && !tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(techIntSts === "Waiting" ? "badge bg-warning" : techIntSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(techIntSts || "not updated");
                            } else if (techIntSts && tech1Sts && !finalIntSts) {
                                selectStatus.removeClass().addClass(tech1Sts === "Waiting" ? "badge bg-warning" : tech1Sts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(tech1Sts || "updated");
                            } else if (finalIntSts) {
                                selectStatus.removeClass().addClass(finalIntSts === "Waiting" ? "badge bg-warning" : finalIntSts === "Rejected" ? "badge bg-danger" : "badge bg-success").text(finalIntSts || "not updated");
                            }

                        });
                        $('#candidate_Rejected').hide();
                        $('#candidate-list').show();
                        $('#spinner').hide();
                    },
                    error: function(status, error) {
                        console.error('Ajax Error', status, error);
                        $('#spinner').hide();
                        alert('Error occurred while fetching data in ChangeApplicant Function : ' + error);
                    }
                });
            } catch (error) {
                alert('Error Message in ChangeApplicant Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE FULL DETAILS -->
    <script>
        function FullDetails(Rowid, jobId) {
            console.log('Rowid:', Rowid);
            console.log('jobId:', jobId);
            try {
                $.ajax({
                    url: "{{ route('ApplicantSts_FullDetailss') }}",
                    type: "GET",
                    data: {
                        Rowid: Rowid,
                        jobId: jobId
                    },
                    dataType: 'json',
                    success: function(fullDetails) {
                        console.log('Details:', fullDetails);

                        if (!fullDetails.Report || fullDetails.Report.length === 0) {
                            alert("No details found.");
                            return;
                        }

                        let report = fullDetails.Report[0];
                        let joblist = fullDetails.joblist[0] || {};

                        // Show Modal
                        $("#canDetails").modal("show");

                        // Profile Images
                        $('#modal-cover-img').attr('src', report.BackImg || 'default-cover.jpg');
                        $('#profile-img-can').attr('src', report.profileImg || 'default-profile.jpg');

                        // Basic Details
                        $('#applicant-Name').text(report.ApplicantName || '-');
                        $('#applicant-position').text(report.position || '-');
                        $('#applicant-dept').text(report.ADept || '-');
                        $('#applicant-aadharNo').text(report.AadharNo || '-');
                        $('#applicant-dob').text(report.DOB ? report.DOB.split(" ")[0] : '-');
                        $('#applicant-contNo').text(report.ContactNo || '-');
                        $('#applicant-marriageSts').text(report.MarrigeSts || '-');
                        $('#applicant-bloodGrp').text(report.BloodGroup || '-');
                        $('#applicant-skill').text(report.skill || '-');
                        $('#applicant-mailid').text(report.EmailId || '-');

                        // Permanent Address
                        $('#applicant-pstreet').text(report.PStreet || '-');
                        $('#applicant-plocation').text(report.Plocation || '-');
                        $('#applicant-ptaluk').text(report.PTaluk || '-');
                        $('#applicant-pdistrict').text(report.PDistrict || '-');
                        $('#applicant-pstate').text(report.Pstate || '-');
                        $('#applicant-pcountry').text(report.PCountry || '-');
                        $('#applicant-ppincode').text(report.ppincode || '-');

                        // Current Address
                        $('#applicant-cstreet').text(report.CStreet || '-');
                        $('#applicant-clocation').text(report.Clocation || '-');
                        $('#applicant-ctaluk').text(report.CTaluk || '-');
                        $('#applicant-cdistrict').text(report.CDistrict || '-');
                        $('#applicant-cstate').text(report.Cstate || '-');
                        $('#applicant-ccountry').text(report.CCountry || '-');
                        $('#applicant-cpincode').text(report.Cpincode || '-');

                        // Education Details
                        let eduHTML = "";
                        fullDetails.Education.forEach(edu => {
                            eduHTML += `<tr>
                    <td>${edu.Education || '-'}</td>
                    <td>${edu.Branch || '-'}</td>
                    <td>${edu.Collage_School || '-'}</td>
                    <td>${edu.University_Board || '-'}</td>
                    <td>${edu.Percentage || '-'}</td>
                    <td>${edu.YearofComplition || '-'}</td>
                    <td>${edu.ExpAttatchment ? `<a href="${edu.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                    </tr>`;
                        });
                        $("#eduTableBody").html(eduHTML || "<tr><td colspan='7'>No data available</td></tr>");

                        // Family Details
                        let famHTML = "";
                        fullDetails.Family.forEach(fam => {
                            famHTML += `<tr>
                    <td>${fam.Name || '-'}</td>
                    <td>${fam.Type || '-'}</td>
                    <td>${fam.Occupation || '-'}</td>
                    <td>${fam.ContactNo || '-'}</td>
                    <td>${fam.Age || '-'}</td>
                </tr>`;
                        });
                        $("#famTableBody").html(famHTML || "<tr><td colspan='5'>No data available</td></tr>");

                        // Language Details
                        let langHTML = "";
                        fullDetails.Language.forEach(lang => {
                            langHTML += `<tr>
                    <td>${lang.Lang || '-'}</td>
                    <td>${lang.Level || '-'}</td>
                    <td>${lang.Reading || 'No'}</td>
                    <td>${lang.Write || 'No'}</td>
                    <td>${lang.Speak || 'No'}</td>
                </tr>`;
                        });
                        $("#langTableBody").html(langHTML || "<tr><td colspan='5'>No data available</td></tr>");

                        // Experience Details
                        let expHTML = "";
                        fullDetails.Experience.forEach(exp => {
                            expHTML += `<tr>
                    <td>${exp.PCompany || '-'}</td>
                    <td>${exp.FDate ? exp.FDate.split(' ')[0] : '-'}</td>
                    <td>${exp.TDate ? exp.TDate.split(' ')[0] : '-'}</td>
                    <td>${exp.ExpYear || '-'}</td>
                    <td>${exp.Designation || '-'}</td>
                    <td>${exp.LastSalary || '-'}</td>
                    <td>${exp.ResForLeave || '-'}</td>
                    <td>${exp.pContactNo || '-'}</td>
                    <td>${exp.ExpAttatchment ? `<a href="${exp.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                </tr>`;
                        });
                        $("#expTableBody").html(expHTML || "<tr><td colspan='9'>No data available</td></tr>");

                        console.log('Modal Triggered');
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('Error occurred while fetching data in FullDetails Function: ' + error);

                    }
                });
            } catch (error) {
                alert('Error Message in FullDetails Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE INTERVIEW STS DETAILS -->
    <script>
        function InterviewSts(Rowid, jobId) {
            console.log('Rowid:', Rowid);
            console.log('jobId:', jobId);
            try {
                $.ajax({
                    url: "{{ route('ApplicantSts_InterviewSTSDet') }}",
                    type: "GET",
                    data: {
                        Rowid: Rowid,
                        jobId: jobId
                    },
                    dataType: 'json',
                    success: function(InterviewDetails) {
                        console.log('InterView Details:', InterviewDetails);

                        if (!InterviewDetails.Interviewsts || InterviewDetails.Interviewsts.length === 0) {
                            alert("No Interview details found.");
                            return;
                        }

                        if (!InterviewDetails.joblist || InterviewDetails.joblist.length === 0) {
                            alert("No joblist details found.");
                            return;
                        }

                        let interviewData = InterviewDetails.Interviewsts[0]; // First object in Interviewsts array
                        let joblistData = InterviewDetails.joblist[0] || {}; // First object in joblist array

                        $("#Applicant_Name").text(joblistData.CompName || "-");

                        // Populate modal fields
                        $("#job-int-company").text(joblistData.CompName || "-");
                        $("#job-int-Department").text(joblistData.DeptName || "-");

                        // HR Details
                        let hrSts = interviewData.hrSts || "not updated";
                        $("#job-hrName").text(joblistData.hrName || "-");
                        $("#hr-status").removeClass().addClass(hrSts === "Waiting" ? 'badge bg-warning' : hrSts === "Rejected" ? 'badge bg-danger' : hrSts === "not updated" ? 'badge bg-secondary' : 'badge bg-success').text(hrSts);
                        $("#hr-remarks").text(interviewData.hrRemarks ? interviewData.hrRemarks : "no remarks");

                        // Technical Interviewer
                        let techIntSts = interviewData.techIntSts || "not updated";
                        $("#job-techIntName").text(joblistData.techIntName || "-");
                        $("#tech-status").removeClass().addClass(techIntSts === "Waiting" ? 'badge bg-warning' : techIntSts === "Rejected" ? 'badge bg-danger' : techIntSts === "not updated" ? 'badge bg-secondary' : 'badge bg-success').text(techIntSts);
                        $("#tech-remarks").text(interviewData.techIntRemarks ? interviewData.techIntRemarks : "no remarks");

                        // Technical Final Interviewer
                        let tech1Sts = interviewData.tech1Sts || "not updated";
                        $("#job-techIntFinalName").text(joblistData.techfinalName || "-");
                        $("#tech1-status").removeClass().addClass(tech1Sts === "Waiting" ? 'badge bg-warning' : tech1Sts === "Rejected" ? 'badge bg-danger' : tech1Sts === "not updated" ? 'badge bg-secondary' : 'badge bg-success').text(tech1Sts);
                        $("#tech1-remarks").text(interviewData.tech1Remarks ? interviewData.tech1Remarks : "no remarks");

                        // Final Interviewer
                        let finalIntSts = interviewData.finalIntSts || "not updated";
                        $("#job-finalIntName").text(joblistData.finalIntName || "-");
                        $("#final-int-status").removeClass().addClass(finalIntSts === "Waiting" ? 'badge bg-warning' : finalIntSts === "Rejected" ? 'badge bg-danger' : finalIntSts === "not updated" ? 'badge bg-secondary' : 'badge bg-success').text(finalIntSts);
                        $("#final-int-remarks").text(interviewData.finalIntRemarks ? interviewData.finalIntRemarks : "no remarks");

                        // Update Images (if available)
                        if (joblistData.img1) {
                            $("#modal-cover-img").attr("src", joblistData.img1);
                        }
                        if (joblistData.img2) {
                            $("#profile-img").attr("src", joblistData.img2);
                        }

                        // Show Modal
                        $("#OverView").modal("show");

                        console.log('Modal Triggered');
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('Error occurred while fetching data in InterviewSts Function: ' + error);

                    }
                });
            } catch (error) {
                alert('Error Message in InterviewSts Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE EVALUATION DETAILS -->
    <script>
        function EvaluationClick(Rowid, jobId) {
            console.log('Rowid:', Rowid);
            console.log('jobId:', jobId);

            try {
                $.ajax({
                    url: "{{ route('ApplicantSts_EvalDet') }}",
                    type: "GET",
                    data: {
                        Rowid: Rowid,
                        jobId: jobId
                    },
                    dataType: 'json',
                    success: function(EvaluationDetails) {
                        console.log('Evaluation Details:', EvaluationDetails);

                        // Reset form fields
                        $('.stars input[type="radio"]').prop('checked', false);
                        $('input[type="radio"]').prop('checked', false);
                        $("#intRemarks").text("");
                        $("#mark-update").text("Submit");
                        $("#candidateForm").attr("action", "candidateStsUpdate");

                        let applicantDetails = EvaluationDetails.applicantReport[0];
                        let interviewerDetails = EvaluationDetails.IntStsdet[0];
                        let evaluationMarks = EvaluationDetails.evalMarkShow;
                        let evalPoints = EvaluationDetails.evalPoints;

                        // Set profile image and background
                        $('#select-profile-img').attr('src', applicantDetails.profileImg || '');
                        $('#select-modal-cover-img').attr('src', applicantDetails.BackImg || '');

                        // Set candidate information
                        $('#canId').val(applicantDetails.Rowid);
                        $('#posId').val(applicantDetails.jobId);
                        $('#posName').val(applicantDetails.position);
                        $('#DeptA').val(applicantDetails.ADept);
                        $('#canName').val(applicantDetails.userName);
                        $('#canMail').val(applicantDetails.EmailId);

                        // Set interviewer details
                        $('#hrEmplno').val(interviewerDetails.hrIntEmplno);
                        $('#techEmplno').val(interviewerDetails.techIntEmplno);
                        $('#tech1Emplno').val(interviewerDetails.tech1IntEmplno);
                        $('#FinalEmplno').val(interviewerDetails.finalIntEmplno);

                        // Fetch current user's employee number
                        var userEmplno = <?php echo json_encode(Session::get('empl_id')); ?>;
                        // var userEmplno = "5545";

                        // Set selection status and remarks based on the current user role
                        if (interviewerDetails.hrIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + interviewerDetails.hrSts + '"]').prop('checked', true);
                            $("#intRemarks").text(interviewerDetails.hrRemarks);
                        } else if (interviewerDetails.techIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + interviewerDetails.techIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(interviewerDetails.techIntRemarks);
                        } else if (interviewerDetails.tech1IntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + interviewerDetails.tech1Sts + '"]').prop('checked', true);
                            $("#intRemarks").text(interviewerDetails.tech1Remarks);
                        } else if (interviewerDetails.finalIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + interviewerDetails.finalIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(interviewerDetails.finalIntRemarks);
                        }

                        // Set evaluation marks
                        for (let i = 0; i < evaluationMarks.length; i++) {
                            if (evaluationMarks[i]['canId'] == Rowid && evaluationMarks[i]['posId'] == jobId) {
                                for (let j = 0; j < evalPoints.length; j++) {
                                    if (evalPoints[j]['rowid'] === evaluationMarks[i]['evalId'] && evaluationMarks[i]['userEmplno'] === userEmplno) {
                                        let marks = evaluationMarks[i]["mark"];
                                        $("#mark-update").text("Update");
                                        $("#candidateForm").attr("action", "EvalUpdate");
                                        $('input[name="stars[' + j + ']"][value="' + marks + '"]').prop('checked', true);
                                    }
                                }
                            }
                        }

                        // Show the modal
                        $("#EvalShow").modal("show");
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('Error occurred while fetching data in EvaluationClick Function: ' + error);

                    }
                });
            } catch (error) {
                alert('Error Message in EvaluationClick Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <script>
        document.getElementById('select-close').addEventListener('click', function() {

            $('#selectShow').modal('hide');
        });

        // ======================== interviewer Status =========================================
        $(document).ready(function() {
            let intSts = @json($interviewerSts);

            if (!Array.isArray(intSts) || intSts.length === 0) {
                console.error("Invalid or empty interviewer statuses array.");
                return;
            }

            $(".joblist-card").each(function() {
                let rowidElement = $(this).find(".canRowid");
                if (rowidElement.length === 0) {
                    // console.error("Rowid element not found.");
                    return; // Skip this card
                }

                let rowid = rowidElement.val();
                // Check if rowid    is not empty
                if (!rowid) {
                    console.error("Empty rowid.");
                    return; // Skip this card
                }
                for (let j = 0; j < intSts.length; j++) {

                    const masterId = intSts[j]["MasterId"];

                    if (rowid == masterId) {
                        let hrSts = intSts[j]["hrSts"];
                        let techIntSts = intSts[j]["techIntSts"];
                        let tech1Sts = intSts[j]["tech1Sts"];
                        let finalIntSts = intSts[j]["finalIntSts"];

                        let hrIntEmplno = intSts[j]["hrIntEmplno"];
                        let techIntEmplno = intSts[j]["techIntEmplno"];
                        let tech1IntEmplno = intSts[j]["tech1IntEmplno"];
                        let finalIntEmplno = intSts[j]["finalIntEmplno"];

                        let selectStatus = $(this).find(".select-status");

                        let evlbtn = $(this).find("#evaluation-btn");

                        if ((hrSts != "") && ((techIntSts && tech1Sts && finalIntSts) == "")) {
                            (!hrSts) ? selectStatus.removeClass().addClass('badge bg-secondary').text("not updated"):
                                (hrSts == "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(hrSts) : (hrSts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger") : selectStatus.removeClass().addClass("badge bg-success").text(hrSts);
                        }

                        if (((hrSts != "") && (techIntSts != "")) && ((tech1Sts && finalIntSts) == "")) {
                            (!techIntSts) ? selectStatus.removeClass().addClass("badge bg-secondary").text("not updated"):
                                (techIntSts === "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(techIntSts) : (techIntSts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(techIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(techIntSts);

                        }
                        if (((techIntSts != "") && (tech1Sts != "")) && (finalIntSts == "")) {

                            (!tech1Sts) ? selectStatus.text("updated"):
                                (tech1Sts == "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(tech1Sts) : (tech1Sts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(techIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(techIntSts);

                        }
                        if ((finalIntSts == "") && (techIntSts && tech1Sts && finalIntSts) != "") {

                            (!finalIntSts) ? selectStatus.removeClass().addClass("badge bg-secondary").text("not updated"):

                                (finalIntSts === "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(finalIntSts) : (finalIntSts === "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(finalIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(finalIntSts);


                        }


                        return;
                    }
                }

                // console.log("No matching MasterId found for rowid:", rowid);
            });
        });


        //  ===================================== mark show ======================================

        $(document).ready(function() {
            $('.viewMark').on('click', function() {

                var applicantBasicDtls = $(this).data('job-details');
                var evalPoints = $(this).data('eval-points');
                var evlMarkDtls = $(this).data('evl-mark');

                // var applicantBasicDtls = $(this).data('can-details');
                let canID = applicantBasicDtls['Rowid'];
                let jobID = applicantBasicDtls['jobId'];
                $('.stars input[type="radio"]').prop('checked', false);
                $(' input[type="radio"]').prop('checked', false);
                $("#intRemarks").text("");
                $("#mark-update").text("Submit");

                $("#candidateForm").attr("action", "candidateStsUpdate");

                var interviewerDtls = $(this).data('interviewer-status');
                console.log(interviewerDtls);
                let candidateMailId = applicantBasicDtls['EmailId'];
                let candidatePosition = applicantBasicDtls['position'];
                let candidateDept = applicantBasicDtls['ADept'];
                let candidateName = applicantBasicDtls['ApplicantName'];
                let candidateProfile = applicantBasicDtls['profileImg'];
                let candidateJobID = applicantBasicDtls['jobId'];

                var resumeAttach = applicantBasicDtls["resumeAttach"];
                var ExpAttatchment = applicantBasicDtls["ExpAttatchment"];
                var ApplicantName = applicantBasicDtls["ApplicantName"];
                var BackImg = applicantBasicDtls["BackImg"];


                $('#select-profile-img').attr('src', candidateProfile);
                // $('#modal-cover-img').attr('src', BackImg);
                $('#select-modal-cover-img').attr('src', BackImg);

                var userEmplno = <?php echo json_encode(Session::get('empl_id')); ?>;

                for (let i = 0; i < interviewerDtls.length; i++) {


                    if ((interviewerDtls[i]["MasterId"] == applicantBasicDtls["Rowid"]) && (applicantBasicDtls["jobId"] === interviewerDtls[i]["positionID"])) {
                        let hrIntEmplno = interviewerDtls[i]["hrIntEmplno"];
                        let techIntEmplno = interviewerDtls[i]["techIntEmplno"];
                        let tech1IntEmplno = interviewerDtls[i]["tech1IntEmplno"];
                        let finalIntEmplno = interviewerDtls[i]["finalIntEmplno"];


                        let hrSts = interviewerDtls[i]["hrSts"];
                        let techIntSts = interviewerDtls[i]["techIntSts"];
                        let tech1Sts = interviewerDtls[i]["tech1Sts"];
                        let finalIntSts = interviewerDtls[i]["finalIntSts"];

                        let hrRemarks = interviewerDtls[i]["hrRemarks"];
                        let techIntRemarks = interviewerDtls[i]["techIntRemarks"];
                        let tech1Remarks = interviewerDtls[i]["tech1Remarks"];
                        let finalIntRemarks = interviewerDtls[i]["finalIntRemarks"];

                        $('#canId').val(canID);
                        $('#posId').val(jobID);
                        // for mail ===============
                        $('#posName').val(candidatePosition);
                        $('#DeptA').val(candidateDept);
                        $('#canName').val(candidateName);
                        $('#hrEmplno').val(hrIntEmplno);
                        $('#techEmplno').val(techIntEmplno);
                        $('#tech1Emplno').val(tech1IntEmplno);
                        $('#FinalEmplno').val(finalIntEmplno);
                        $('#canMail').val(candidateMailId);

                        //  mail end ===============

                        if (hrIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + hrSts + '"]').prop('checked', true);
                            $("#intRemarks").text(hrRemarks);

                        } else if (techIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + techIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(techIntRemarks);

                        } else if (tech1IntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + tech1Sts + '"]').prop('checked', true);
                            $("#intRemarks").text(tech1Remarks);

                        } else if (finalIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + finalIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(finalIntRemarks);

                        }


                    }
                }


                // console.log(evlMarkDtls);
                for (let i = 0; i < evlMarkDtls.length; i++) {

                    if ((evlMarkDtls[i]['canId'] == canID) && (evlMarkDtls[i]['posId'] == jobID)) {

                        for (let j = 0; j < evalPoints.length; j++) {
                            const element = evalPoints[j];

                            if ((evalPoints[j]['rowid'] === evlMarkDtls[i]['evalId']) && (evlMarkDtls[i]['userEmplno'] === userEmplno)) {

                                let marks = evlMarkDtls[i]["mark"];

                                $("#mark-update").text("Update");

                                $("#candidateForm").attr("action", "EvalUpdate");

                                $('input[name="stars[' + j + ']"][value="' + marks + '"]').prop('checked', true);

                            }

                        }

                    }

                }
            })
        });
    </script>

    <script>
        $(document).ready(function() {

            var totalJobsCount = $('.joblist-card').length;

            $('#searchJob').on('input', function() {
                var searchQuery = $(this).val().toLowerCase();


                $('.joblist-card').hide();

                var visibleJobsCount = 0;

                $('.joblist-card').each(function() {

                    var jobTitle = $(this).find('.job-title').text().toLowerCase();
                    var companyName = $(this).find('.company-name').text().toLowerCase();
                    var skills = $(this).find('.job-description').text().toLowerCase();

                    if (jobTitle.includes(searchQuery) || companyName.includes(searchQuery) || skills.includes(searchQuery)) {

                        $(this).show();

                        visibleJobsCount++;

                    }



                });
                visibleJobsCount = visibleJobsCount / 2;
                $('#total-result').text(visibleJobsCount);
                $('#found-job-alert').removeClass('d-none');
            });
        });
    </script>

    <!-- FOR REJECTED DETAILS S -->
    <script>
        // ========================== task assign =======================================
        $(document).ready(function() {
            $('.assign-task').on('click', function() {
                // Get the company name from the data attribute
                var applicantBasicDtls = $(this).data('job-details');
                var jobDetails = $(this).data('job-lists');

                for (let i = 0; i < jobDetails.length; i++) {

                    if (jobDetails[i]["Rowid"] == applicantBasicDtls["jobId"]) {

                        var ApplicantName = applicantBasicDtls["ApplicantName"];
                        var Rowid = applicantBasicDtls["Rowid"];

                        var CompName = jobDetails[i]["CompName"];
                        var DeptName = jobDetails[i]["DeptName"];
                        var hrName = jobDetails[i]["hrName"];
                        var techIntName = jobDetails[i]["techIntName"];
                        var techfinalName = jobDetails[i]["techfinalName"];
                        var finalIntName = jobDetails[i]["finalIntName"];
                        let hrIntEmplno = jobDetails[i]["hrEmplno"];
                        let techIntEmplno = jobDetails[i]["techIntEmplno"];
                        let tech1IntEmplno = jobDetails[i]["tech1IntEmplno"];
                        let finalIntEmplno = jobDetails[i]["finalIntEmplno"];

                        var interviewDate = applicantBasicDtls["interviewDate"];
                        var dateOnly = interviewDate.split(' ')[0]; // Extracting date part only

                        document.getElementById("event-start-date").value = dateOnly;

                        // Create a new option element
                        var select = document.getElementById("int-name");
                        select.innerHTML = "";
                        var options = [hrName, techIntName, techfinalName, finalIntName];
                        var options1 = [hrIntEmplno, techIntEmplno, tech1IntEmplno, finalIntEmplno];

                        for (var j = 0; j < options.length; j++) {
                            var option = document.createElement("option");
                            option.text = options[j];
                            option.value = options1[j];

                            select.appendChild(option);
                        }

                        $('#candidateId').val(Rowid);
                    }
                }

            })
        });

        $(document).ready(function() {
            $('.viewjob-list').on('click', function() {

                var applicantBasicDtls = $(this).data('job-details');
                var jobDetails = $(this).data('job-lists');
                var interviewerDtls = $(this).data('interviewer-status');
                let candidateRowid = applicantBasicDtls['Rowid'];
                let candidateMailId = applicantBasicDtls['EmailId'];
                let candidatePosition = applicantBasicDtls['position'];
                let candidateDept = applicantBasicDtls['ADept'];
                let candidateName = applicantBasicDtls['ApplicantName'];
                let candidateProfile = applicantBasicDtls['profileImg'];
                let candidateJobID = applicantBasicDtls['jobId'];

                var resumeAttach = applicantBasicDtls["resumeAttach"];
                var ExpAttatchment = applicantBasicDtls["ExpAttatchment"];
                var ApplicantName = applicantBasicDtls["ApplicantName"];
                var BackImg = applicantBasicDtls["BackImg"];

                for (let i = 0; i < jobDetails.length; i++) {

                    if (jobDetails[i]["Rowid"] == applicantBasicDtls["jobId"]) {
                        var CompName = jobDetails[i]["CompName"];
                        var DeptName = jobDetails[i]["DeptName"];
                        var hrName = jobDetails[i]["hrName"];
                        var techIntName = jobDetails[i]["techIntName"];
                        var techfinalName = jobDetails[i]["techfinalName"];
                        var finalIntName = jobDetails[i]["finalIntName"];


                        let hrIntEmplno = jobDetails[i]["hrIntEmplno"];
                        let techIntEmplno = jobDetails[i]["techIntEmplno"];
                        let tech1IntEmplno = jobDetails[i]["tech1IntEmplno"];
                        let finalIntEmplno = jobDetails[i]["finalIntEmplno"];

                        $('#job-int-company').text(CompName);
                        $('#job-int-Department').text(DeptName);
                        $('#job-hrName').text(hrName);
                        $('#job-techIntName').text(techIntName);
                        $('#job-techIntFinalName').text(techfinalName);
                        $('#job-finalIntName').text(finalIntName);
                        $('#profile-img').attr('src', candidateProfile);
                        $('#select-profile-img').attr('src', candidateProfile);
                        $('#modal-cover-img').attr('src', BackImg);
                        $('#select-modal-cover-img').attr('src', BackImg);


                    }
                }


                for (let i = 0; i < interviewerDtls.length; i++) {

                    if (interviewerDtls[i]["MasterId"] == applicantBasicDtls["Rowid"]) {

                        var hrSts = (interviewerDtls[i]["hrSts"] === '') ? 'not updated' : interviewerDtls[i]["hrSts"];

                        let hrRemarks = (interviewerDtls[i]["hrRemarks"] === "") ? 'not updated' : interviewerDtls[i]["hrRemarks"];
                        let techIntSts = (interviewerDtls[i]["techIntSts"] === "") ? 'not updated' : interviewerDtls[i]["techIntSts"];
                        let techIntRemarks = (interviewerDtls[i]["techIntRemarks"] === "") ? '-' : interviewerDtls[i]["techIntRemarks"];
                        let tech1Sts = (interviewerDtls[i]["tech1Sts"] === "") ? 'not updated' : interviewerDtls[i]["tech1Sts"];

                        let tech1Remarks = (interviewerDtls[i]["tech1Remarks"] === "") ? '-' : interviewerDtls[i]["tech1Remarks"];
                        let finalIntSts = (interviewerDtls[i]["finalIntSts"] === "") ? 'not updated' : interviewerDtls[i]["finalIntSts"];
                        let finalIntRemarks = (interviewerDtls[i]["finalIntRemarks"] === "") ? '-' : interviewerDtls[i]["finalIntRemarks"];


                        // for mail =========

                        let hrIntEmplno = interviewerDtls[i]["hrIntEmplno"];
                        let techIntEmplno = interviewerDtls[i]["techIntEmplno"];
                        let tech1IntEmplno = interviewerDtls[i]["tech1IntEmplno"];
                        let finalIntEmplno = interviewerDtls[i]["finalIntEmplno"];

                        //  mail end =========
                        // console.log(hrSts);

                        (hrSts === "Waiting") ? $('#hr-status').removeClass().addClass('badge bg-warning').text(hrSts): (hrSts === "Rejected") ? $('#hr-status').removeClass().addClass('badge bg-danger').text(hrSts) : (hrSts === "not updated") ? $('#hr-status').removeClass().addClass('badge bg-secondary').text(hrSts) : $('#hr-status').addClass('badge bg-success').text(hrSts);

                        (techIntSts === "Waiting") ? $('#tech-status').removeClass().addClass('badge bg-warning').text(techIntSts): (techIntSts === "Rejected") ? $('#tech-status').removeClass().addClass('badge bg-danger').text(techIntSts) : (techIntSts === "not updated") ? $('#tech-status').removeClass().addClass('badge bg-secondary').text(techIntSts) : $('#tech-status').addClass('badge bg-success').text(techIntSts);

                        (tech1Sts === "Waiting") ? $('#tech1-status').removeClass().addClass('badge bg-warning').text(tech1Sts): (tech1Sts === "Rejected") ? $('#tech1-status').removeClass().addClass(' badgebg-danger').text(tech1Sts) : (tech1Sts === "not updated") ? $('#tech1-status').removeClass().addClass('badge bg-secondary').text(tech1Sts) : $('#tech1-status').addClass('badge bg-success').text(tech1Sts);
                        (finalIntSts === "Waiting") ? $('#final-int-status').removeClass().addClass(' badge bg-warning').text(finalIntSts): (finalIntSts === "Rejected") ? $('#final-int-status').removeClass().addClass('badge bg-danger').text(finalIntSts) : (finalIntSts === "not updated") ? $('#final-int-status').removeClass().addClass('badge bg-secondary').text(finalIntSts) : $('#final-int-status').addClass('badge bg-success').text(finalIntSts);


                        $('#hr-remarks').text(hrRemarks);
                        $('#tech-remarks').text(techIntRemarks);
                        $('#tech1-remarks').text(tech1Remarks);
                        $('#final-int-remarks').text(finalIntRemarks);
                        $('#canId').val(candidateRowid);
                        $('#posId').val(candidateJobID);


                        // for mail ===============
                        $('#posName').val(candidatePosition);
                        $('#DeptA').val(candidateDept);
                        $('#canName').val(candidateName);
                        $('#hrEmplno').val(hrIntEmplno);
                        $('#techEmplno').val(techIntEmplno);
                        $('#tech1Emplno').val(tech1IntEmplno);
                        $('#FinalEmplno').val(finalIntEmplno);
                        $('#canMail').val(candidateMailId);

                        //  mail end ===============


                    }
                }

            })
        });
    </script>

    <script>
        document.getElementById('select-close').addEventListener('click', function() {

            $('#selectShow').modal('hide');
        });

        // ======================== interviewer Status =========================================
        $(document).ready(function() {
            let intSts = @json($interviewerSts);

            if (!Array.isArray(intSts) || intSts.length === 0) {
                console.error("Invalid or empty interviewer statuses array.");
                return;
            }

            $(".joblist-card").each(function() {
                let rowidElement = $(this).find(".canRowid");
                if (rowidElement.length === 0) {
                    // console.error("Rowid element not found.");
                    return; // Skip this card
                }

                let rowid = rowidElement.val();
                // Check if rowid    is not empty
                if (!rowid) {
                    console.error("Empty rowid.");
                    return; // Skip this card
                }
                for (let j = 0; j < intSts.length; j++) {

                    const masterId = intSts[j]["MasterId"];

                    if (rowid == masterId) {
                        let hrSts = intSts[j]["hrSts"];
                        let techIntSts = intSts[j]["techIntSts"];
                        let tech1Sts = intSts[j]["tech1Sts"];
                        let finalIntSts = intSts[j]["finalIntSts"];

                        let hrIntEmplno = intSts[j]["hrIntEmplno"];
                        let techIntEmplno = intSts[j]["techIntEmplno"];
                        let tech1IntEmplno = intSts[j]["tech1IntEmplno"];
                        let finalIntEmplno = intSts[j]["finalIntEmplno"];
                        let evlbtn = $(this).find("#evaluation-btn");

                        let selectStatus = $(this).find(".select-status");


                        if ((hrSts != "") && ((techIntSts && tech1Sts && finalIntSts) == "")) {
                            (!hrSts) ? selectStatus.removeClass().addClass('badge bg-secondary').text("not updated"):
                                (hrSts == "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(hrSts) : (hrSts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger") : selectStatus.removeClass().addClass("badge bg-success").text(hrSts);
                        }

                        if (((hrSts != "") && (techIntSts != "")) && ((tech1Sts && finalIntSts) == "")) {
                            (!techIntSts) ? selectStatus.removeClass().addClass("badge bg-secondary").text("not updated"):
                                (techIntSts === "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(techIntSts) : (techIntSts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(techIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(techIntSts);

                        }
                        if (((techIntSts != "") && (tech1Sts != "")) && (finalIntSts == "")) {

                            (!tech1Sts) ? selectStatus.text("updated"):
                                (tech1Sts == "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(tech1Sts) : (tech1Sts == "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(techIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(techIntSts);

                        }
                        if ((finalIntSts == "") && (techIntSts && tech1Sts && finalIntSts) != "") {

                            (!finalIntSts) ? selectStatus.removeClass().addClass("badge bg-secondary").text("not updated"):

                                (finalIntSts === "Waiting") ? selectStatus.removeClass().addClass("badge bg-warning").text(finalIntSts) : (finalIntSts === "Rejected") ? selectStatus.removeClass().addClass("badge bg-danger").text(finalIntSts) : selectStatus.removeClass().addClass("badge bg-success").text(finalIntSts);


                        }


                        return;
                    }
                }

                // console.log("No matching MasterId found for rowid:", rowid);
            });
        });


        //  ===================================== mark show ======================================

        $(document).ready(function() {
            $('.viewMark').on('click', function() {

                var applicantBasicDtls = $(this).data('job-details');
                var evalPoints = $(this).data('eval-points');
                var evlMarkDtls = $(this).data('evl-mark');
                // var applicantBasicDtls = $(this).data('can-details');
                let canID = applicantBasicDtls['Rowid'];
                let jobID = applicantBasicDtls['jobId'];
                $('.stars input[type="radio"]').prop('checked', false);
                $(' input[type="radio"]').prop('checked', false);
                $("#intRemarks").text("");
                $("#mark-update").text("Submit");

                $("#candidateForm").attr("action", "candidateStsUpdate");

                var interviewerDtls = $(this).data('interviewer-status');
                console.log(interviewerDtls);

                let candidateMailId = applicantBasicDtls['EmailId'];
                let candidatePosition = applicantBasicDtls['position'];
                let candidateDept = applicantBasicDtls['ADept'];
                let candidateName = applicantBasicDtls['ApplicantName'];
                let candidateProfile = applicantBasicDtls['profileImg'];
                let candidateJobID = applicantBasicDtls['jobId'];

                var resumeAttach = applicantBasicDtls["resumeAttach"];
                var ExpAttatchment = applicantBasicDtls["ExpAttatchment"];
                var ApplicantName = applicantBasicDtls["ApplicantName"];
                var BackImg = applicantBasicDtls["BackImg"];


                $('#select-profile-img').attr('src', candidateProfile);
                // $('#modal-cover-img').attr('src', BackImg);
                $('#select-modal-cover-img').attr('src', BackImg);

                var userEmplno = <?php echo json_encode(Session::get('empl_id')); ?>;

                for (let i = 0; i < interviewerDtls.length; i++) {


                    if ((interviewerDtls[i]["MasterId"] == applicantBasicDtls["Rowid"]) && (applicantBasicDtls["jobId"] === interviewerDtls[i]["positionID"])) {
                        let hrIntEmplno = interviewerDtls[i]["hrIntEmplno"];
                        let techIntEmplno = interviewerDtls[i]["techIntEmplno"];
                        let tech1IntEmplno = interviewerDtls[i]["tech1IntEmplno"];
                        let finalIntEmplno = interviewerDtls[i]["finalIntEmplno"];


                        let hrSts = interviewerDtls[i]["hrSts"];
                        let techIntSts = interviewerDtls[i]["techIntSts"];
                        let tech1Sts = interviewerDtls[i]["tech1Sts"];
                        let finalIntSts = interviewerDtls[i]["finalIntSts"];

                        let hrRemarks = interviewerDtls[i]["hrRemarks"];
                        let techIntRemarks = interviewerDtls[i]["techIntRemarks"];
                        let tech1Remarks = interviewerDtls[i]["tech1Remarks"];
                        let finalIntRemarks = interviewerDtls[i]["finalIntRemarks"];

                        $('#canId').val(canID);
                        $('#posId').val(jobID);
                        // for mail ===============
                        $('#posName').val(candidatePosition);
                        $('#DeptA').val(candidateDept);
                        $('#canName').val(candidateName);
                        $('#hrEmplno').val(hrIntEmplno);
                        $('#techEmplno').val(techIntEmplno);
                        $('#tech1Emplno').val(tech1IntEmplno);
                        $('#FinalEmplno').val(finalIntEmplno);
                        $('#canMail').val(candidateMailId);

                        //  mail end ===============

                        if (hrIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + hrSts + '"]').prop('checked', true);
                            $("#intRemarks").text(hrRemarks);

                        } else if (techIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + techIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(techIntRemarks);

                        } else if (tech1IntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + tech1Sts + '"]').prop('checked', true);
                            $("#intRemarks").text(tech1Remarks);

                        } else if (finalIntEmplno == userEmplno) {
                            $('input[name="selectCan"][value="' + finalIntSts + '"]').prop('checked', true);
                            $("#intRemarks").text(finalIntRemarks);

                        }


                    }
                }


                // console.log(evlMarkDtls);
                for (let i = 0; i < evlMarkDtls.length; i++) {

                    if ((evlMarkDtls[i]['canId'] == canID) && (evlMarkDtls[i]['posId'] == jobID)) {

                        for (let j = 0; j < evalPoints.length; j++) {
                            const element = evalPoints[j];

                            if ((evalPoints[j]['rowid'] === evlMarkDtls[i]['evalId']) && (evlMarkDtls[i]['userEmplno'] === userEmplno)) {

                                let marks = evlMarkDtls[i]["mark"];

                                $("#mark-update").text("Update");

                                $("#candidateForm").attr("action", "EvalUpdate");

                                $('input[name="stars[' + j + ']"][value="' + marks + '"]').prop('checked', true);

                            }

                        }

                    }

                }
            })
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.viewcan-list').on('click', function() {
                // Get the company name from the data attribute
                var applicantBasicDtls = $(this).data('can-details');
                var applicantEduDtls = $(this).data('can-edu');
                var applicantFamDtls = $(this).data('can-fam');
                var applicantLangDtls = $(this).data('can-lang');
                var applicantExpDtls = $(this).data('can-exp');
                var jobDtls = $(this).data('job-lists');

                // console.log(jobDtls);

                let candidateRowid = applicantBasicDtls['Rowid'];
                let candidateMailId = applicantBasicDtls['EmailId'];
                let candidatePosition = applicantBasicDtls['position'];
                let candidateDept = applicantBasicDtls['ADept'];
                let candidateName = applicantBasicDtls['ApplicantName'];
                let candidateProfile = applicantBasicDtls['profileImg'];

                $('#eduTableBody').empty();
                $('#famTableBody').empty();
                $('#langTableBody').empty();
                $('#expTableBody').empty();

                //  ====================== education =========================

                // console.log(eduMasID);
                for (let i = 0; i < applicantEduDtls.length; i++) {
                    const eduMasID = applicantEduDtls[i]["masterId"];
                    if (applicantBasicDtls['Rowid'] == eduMasID) {
                        const eduType = applicantEduDtls[i]["Education"];
                        const eduBranch = applicantEduDtls[i]["Branch"];
                        const eduScl_clg = applicantEduDtls[i]["Collage_School"];
                        const eduUni_state = applicantEduDtls[i]["University_Board"];
                        const eduPercentage = applicantEduDtls[i]["Percentage"];
                        const eduYearOfComp = applicantEduDtls[i]["YearofComplition"];
                        let eduAttach = applicantEduDtls[i]["eduAttach"];
                        const newRow = $('<tr>');
                        newRow.append('<td >' + eduType + '</td>');
                        newRow.append('<td >' + eduBranch + '</td>');
                        newRow.append('<td >' + eduScl_clg + '</td>');
                        newRow.append('<td >' + eduUni_state + '</td>');
                        newRow.append('<td >' + eduPercentage + '</td>');
                        newRow.append('<td >' + eduYearOfComp + '</td>');
                        if (eduAttach == "") {
                            eduAttach = "no Attachment";
                            newRow.append('<td >' + eduAttach + '</td>');
                        } else {

                            newRow.append('<td>' + '<a href="' + eduAttach + '" download ="education">Download</a>' + '</td>');

                        }
                        $('#eduTableBody').append(newRow);
                    } else {

                    }
                }



                // end  =============== education 

                //   ========================= family =====================================
                for (let i = 0; i < applicantFamDtls.length; i++) {

                    const famMasID = applicantFamDtls[i]["MasterId"];


                    if (applicantBasicDtls['Rowid'] == famMasID) {

                        const famName = applicantFamDtls[i]["Name"];
                        const famType = applicantFamDtls[i]["Type"];
                        const famOccupation = applicantFamDtls[i]["Occupation"];
                        const famContNo = applicantFamDtls[i]["ContactNo"];
                        const Age = applicantFamDtls[i]["Age"];

                        const newRow = $('<tr>');
                        newRow.append('<td >' + famName + '</td>');
                        newRow.append('<td >' + famType + '</td>');
                        newRow.append('<td >' + famOccupation + '</td>');
                        newRow.append('<td >' + famContNo + '</td>');
                        newRow.append('<td >' + Age + '</td>');
                        $('#famTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (applicantBasicDtls['Rowid'] == EduMasID) {

                    // } else {

                    // }
                }

                //  end family =================================

                //   ========================= landuage =====================================

                for (let i = 0; i < applicantLangDtls.length; i++) {

                    const langMasID = applicantLangDtls[i]["MasterId"];
                    // console.log(langMasID);
                    if (applicantBasicDtls['Rowid'] == langMasID) {

                        const langType = applicantLangDtls[i]["Lang"];
                        const langLevel = applicantLangDtls[i]["Level"];
                        const langReading = applicantLangDtls[i]["Reading"];
                        const langSpeak = applicantLangDtls[i]["Speak"];
                        const langWrite = applicantLangDtls[i]["Write"];


                        const newRow = $('<tr>');
                        newRow.append('<td >' + langType + '</td>');
                        newRow.append('<td >' + langLevel + '</td>');
                        newRow.append('<td >' + langReading + '</td>');
                        newRow.append('<td >' + langSpeak + '</td>');
                        newRow.append('<td >' + langWrite + '</td>');
                        $('#langTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (applicantBasicDtls['Rowid'] == EduMasID) {

                    // } else {

                    // }
                }
                for (let i = 0; i < applicantExpDtls.length; i++) {

                    const expMasID = applicantExpDtls[i]["MasterId"];

                    // console.log(langMasID);
                    if (applicantBasicDtls['Rowid'] == expMasID) {

                        var PCompany = applicantExpDtls[i]["PCompany"];
                        var FDate = applicantExpDtls[i]["FDate"];
                        var FdateOnly = FDate.split(' ')[0];
                        var TDate = applicantExpDtls[i]["TDate"];
                        var TdateOnly = TDate.split(' ')[0];

                        var ExpYear = applicantExpDtls[i]["ExpYear"];
                        // var Pdept = applicantExpDtls[i]["Department"];
                        var Pdesign = applicantExpDtls[i]["Designation"];
                        var LastSalary = applicantExpDtls[i]["LastSalary"];
                        // var ExpectSalary = applicantExpDtls[i]["ExpectSalary"];
                        var ResForLeave = applicantExpDtls[i]["ResForLeave"];
                        var RefEmplno = applicantExpDtls[i]["RefEmplno"];
                        var ExpAttatchment = applicantExpDtls[i]["ExpAttatchment"];
                        const newRow = $('<tr>');
                        newRow.append('<td >' + PCompany + '</td>');
                        newRow.append('<td >' + FdateOnly + '</td>');
                        newRow.append('<td >' + TdateOnly + '</td>');
                        newRow.append('<td >' + ExpYear + '</td>');
                        // newRow.append('<td >' + Pdept + '</td>');
                        newRow.append('<td >' + Pdesign + '</td>');
                        newRow.append('<td >' + LastSalary + '</td>');
                        // newRow.append('<td >' + ExpectSalary + '</td>');
                        newRow.append('<td >' + ResForLeave + '</td>');
                        if (ExpAttatchment == "") {
                            ExpAttatchment = "No Attachment";
                            newRow.append('<td>' + ExpAttatchment + '</td>');
                        } else {
                            newRow.append('<td>' + '<a href="' + ExpAttatchment + '" download="experience">Download</a>' + '</td>');
                        }

                        $('#expTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (applicantBasicDtls['Rowid'] == EduMasID) {

                    // } else {

                    // }
                }

                //  end language =================================

                var BackImg = applicantBasicDtls["BackImg"];
                var profileImg = applicantBasicDtls["profileImg"];
                var resumeAttach = applicantBasicDtls["resumeAttach"];
                var ExpAttatchment = applicantBasicDtls["ExpAttatchment"];

                var ApplicantName = applicantBasicDtls["ApplicantName"];
                var ADept = applicantBasicDtls["ADept"];
                var position = applicantBasicDtls["position"];
                var AadharNo = applicantBasicDtls["AadharNo"];
                var dateParts = applicantBasicDtls["DOB"];
                var DOB = dateParts.split(' ')[0];
                var ContactNo = applicantBasicDtls["ContactNo"];
                var BloodGroup = applicantBasicDtls["BloodGroup"];
                var MarrigeSts = applicantBasicDtls["MarrigeSts"];
                var skill = applicantBasicDtls["skill"];
                var EmailId = applicantBasicDtls["EmailId"];


                $('#candidate-rowid').val(candidateRowid);
                $('#candidate-mailid').val(candidateMailId);
                $('#candidate-position').val(candidatePosition);
                $('#candidate-dept').val(candidateDept);
                $('#candidate-name').val(candidateName);
                $('#profile-img-can').attr('src', candidateProfile);
                $('#modal-cover-img-can').attr('src', BackImg);

                $('#applicant-Name').text(ApplicantName);
                $('#applicant-dept').text(ADept);
                $('#applicant-position').text(position);
                $('#applicant-aadharNo').text(AadharNo);
                $('#applicant-dob').text(DOB);
                $('#applicant-contNo').text(ContactNo);
                $('#applicant-marriageSts').text(MarrigeSts);
                $('#applicant-bloodGrp').text(BloodGroup);
                $('#applicant-skill').text(skill);
                $('#applicant-mailid').text(EmailId);

                // permanent Address 
                var PStreet = applicantBasicDtls["PStreet"];
                var Plocation = applicantBasicDtls["Plocation"];
                var PTaluk = applicantBasicDtls["PTaluk"];
                var PDistrict = applicantBasicDtls["PDistrict"];
                var Pstate = applicantBasicDtls["Pstate"];
                var PCountry = applicantBasicDtls["PCountry"];
                var ppincode = applicantBasicDtls["ppincode"];

                $('#applicant-pstreet').text(PStreet);
                $('#applicant-plocation').text(Plocation);
                $('#applicant-ptaluk').text(PTaluk);
                $('#applicant-pdistrict').text(PDistrict);
                $('#applicant-pstate').text(Pstate);
                $('#applicant-pcountry').text(PCountry);
                $('#applicant-ppincode').text(ppincode);


                // current address 
                var CStreet = applicantBasicDtls["CStreet"];
                var Clocation = applicantBasicDtls["Clocation"];
                var CTaluk = applicantBasicDtls["CTaluk"];
                var CDistrict = applicantBasicDtls["CDistrict"];
                var Cstate = applicantBasicDtls["Cstate"];
                var CCountry = applicantBasicDtls["CCountry"];
                var Cpincode = applicantBasicDtls["Cpincode"];

                $('#applicant-cstreet').text(CStreet);
                $('#applicant-clocation').text(Clocation);
                $('#applicant-ctaluk').text(CTaluk);
                $('#applicant-cdistrict').text(CDistrict);
                $('#applicant-cstate').text(Cstate);
                $('#applicant-ccountry').text(CCountry);
                $('#applicant-cpincode').text(Cpincode);
                // experience details

                // ========================  job details =============================

                for (let i = 0; i < jobDtls.length; i++) {

                    if (applicantBasicDtls["jobId"] == jobDtls[i]["Rowid"]) {

                        let hrEmplno = jobDtls[i]["hrEmplno"];
                        let techIntEmplno = jobDtls[i]["techIntEmplno"];
                        let tech1IntEmplno = jobDtls[i]["tech1IntEmplno"];
                        let finalIntEmplno = jobDtls[i]["finalIntEmplno"];
                        let postionId = jobDtls[i]["Rowid"];

                        $('#hr-emplno').val(hrEmplno);
                        $('#tech-emplno ').val(techIntEmplno);
                        $('#tech1-emplno').val(tech1IntEmplno);
                        $('#final-emplno').val(finalIntEmplno);
                        $('#position-id').val(postionId);

                    }

                }

                //  end job details ==============================


                var RefEmplno = applicantBasicDtls["RefEmplno"];
                if (RefEmplno == 0) {
                    RefEmplno = "No Reference";
                }
                $('#applicant-refEmplno').text(RefEmplno);


            })
        });
    </script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>
    @endsection
</body>

</html>