<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">
<!-- Mirrored from themesbrand.com/velzon/html/master/apps-job-candidate-lists.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:47:54 GMT -->

<head>
    <meta charset="utf-8" />
    <title>
        CANDIDATES
    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />


    <!-- gridjs css -->
    <link rel="stylesheet" href="Applicant/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!--  ================== star Start ====== -->

    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">


    <style>
        @import url(https://fonts.googleapis.com/css?family=Roboto:500,100,300,700,400);

        body {
            background-color: #eee;

        }

        div.stars {

            display: inline-block;
        }

        input.star {

            display: none;
        }

        label.star {

            float: right;

            padding-left: 5px;

            font-size: 25px;

            color: #4A148C;

            transition: all .2s;

        }

        input.star:checked~label.star:before {

            content: '\f005';

            color: #FD4;

            transition: all .25s;

        }

        input.star-5:checked~label.star:before {

            color: #FE7;

            text-shadow: 0 0 20px #952;

        }

        input.star-1:checked~label.star:before {
            color: #F62;
        }

        label.star:hover {
            transform: rotate(-15deg) scale(1.3);
        }

        label.star:before {

            content: '\f006';

            font-family: FontAwesome;

        }
    </style>

    <!--  ================== star end ====== -->

    <!-- ==================== for table ==================== -->

    <style>
        .table-split table tbody tr td {
            width: 0px !important;
            border: none;
        }

        table tbody td,
        table thead th {

            padding: 5px;
            border: 1px solid gray;
        }

        table {
            width: 100%;

        }

        .table-con {
            overflow-x: auto;
        }

        @media (max-width: 426px) {
            .table-split table tbody tr td {
                width: 0px;

            }

            .table-split table tbody td:nth-child(2),
            .table-split table tbody td:nth-child(5) {
                display: none;
                /* flex-wrap: wrap; */
            }

            .table-split table tbody td {

                display: flex;

                flex-wrap: wrap;
            }

        }
    </style>

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        @extends('Applicant.navbar')
        @section('content')
        <?php $userEmplNo = Session::get('empl_id');
        echo $userEmplNo; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <!-- <h4 class="mb-sm-0">List View</h4> -->

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item">
                                            <a href="javascript: void(0);">Applied Candidate</a>
                                        </li>

                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <!-- <h6 class="card-title mb-0 flex-grow-1">
                                            Search Candidates
                                        </h6> -->

                                    </div>
                                    @if ($message = Session::get('selected'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}}.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('Rejected'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}}.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('Error'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Something </strong>Wrong does not submitted.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif


                                    @if ($message = Session::get('selected-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} for next round.
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif

                                    @if ($message = Session::get('Rejected-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} .
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif
                                    @if ($message = Session::get('waiting-1'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-warning text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Candidate </strong>{{$message}} .
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif


                                    <div class="row gy-3">
                                        <div class="col-xxl-2">
                                            <label>Month</label>
                                            <select class="form-control select2" name="Month" id="Month" onchange="ChangeMonth(this.value)">
                                                <option value="ALL">ALL DATA</option>
                                                @foreach ($Monthlist as $key => $Mon)
                                                <option value="{{$Mon['Entrytime']}}" {{ $key == 0 ? 'selected' : '' }}>{{$Mon['Entrytime']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-xxl-3">
                                            <label>Applicant Name</label>
                                            <select class="form-control select2" name="ApplicantName" id="ApplicantName" onchange="ChangeApplicant(this.value)">
                                                <option value="">--Select Applicant Name--</option>
                                            </select>
                                        </div>
                                        <div class="col-xxl-7 col-md-6 mt-4">
                                            <div class="search-box">
                                                <input type="text" class="form-control search bg-light border-light" id="searchJob" autocomplete="off" placeholder="Search for candidates..." />
                                                <i class="ri-search-line search-icon"></i>
                                            </div>
                                        </div>

                                        <div class="col-xl-12 d-none" id="found-job-alert">
                                            <div class="alert alert-success mb-0 text-center" role="alert">
                                                <strong id="total-result">0</strong>
                                                candidates found
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $ATSCandidateEntry = Session('ATSCandidateEntry');
                    $ATSCandidateReport = Session::get('ATSCandidateReport');
                    $ATSApplicantStsEntry = Session::get('ATSApplicantStsEntry');
                    ?>
                    @if ($ATSCandidateEntry === "Y")
                    <div class="row gy-2 mb-2" id="candidate-list">
                        <div class=" d-flex justify-content-center align-items-center">

                            <!-- Spinner -->
                            <div id="spinner" class="col-md-1 mb-4" style="display: none;">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                        </div>

                    </div>
                    @endif
                    <!-- end row -->
                    <!-- end row -->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear());
                            </script>
                            © Gainup Industries.
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>

        <!-- overview -->
        <div class="modal fade" id="canDetails" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0">

                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="Applicant/assets/Img/Jobimg/background-1.jpg" alt="" id="modal-cover-img" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="Applicant/assets/Img/ApplicantProfile/logo-1.jpg" id="profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>

                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div class="table-split">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Applicant Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-Name"></span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Position </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-position">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Department Name</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dept">-</span>
                                                </td>
                                                <td>

                                                    <p class="mt-3">Aadhar No </p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-aadharNo"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">DOB</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-dob"></span></td>
                                                <td>
                                                    <p class="mt-3">Contact No</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-contNo">-</span></td>

                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Marriage Details</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-marriageSts">-</span></td>

                                                <td>
                                                    <p class="mt-3">Blood Group</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-bloodGrp">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-skill">-</span></td>

                                                <td>
                                                    <p class="mt-3">EmailId</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-mailid">-</span></td>
                                            </tr>

                                            <!-- <tr>
                                                    <td>
                                                        <p class="mt-3">Father/HusBand Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                                </tr> -->
                                        </tbody>
                                    </table>

                                    <div class="divider"></div>
                                </div>
                                <div class="table-split">
                                    <h5 class="mt-3 text-center ">Address </h5>
                                    <h5 class="mt-3  ">Permanent Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-plocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ptaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-pcountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ppincode">-</span></td>

                                            </tr>

                                        </tbody>
                                    </table>
                                    <h5 class="mt-3  ">Current Address </h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Street </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstreet">-</span></td>

                                                <td>
                                                    <p class="mt-3">Location </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-clocation">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">Taluk </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ctaluk">-</span></td>

                                                <td>
                                                    <p class="mt-3">District</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cdistrict">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">State </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cstate">-</span></td>

                                                <td>
                                                    <p class="mt-3">Country </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-ccountry">-</span></td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="mt-3">PinCode </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="applicant-cpincode">-</span></td>


                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <h5 class="m-3 text-center"> Education Details</h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Education</th>
                                            <th>Branch</th>
                                            <th>Collage/School</th>
                                            <th>University/State</th>
                                            <th>Percentage(%)</th>
                                            <th>Completed Year</th>
                                            <th>Attachment</th>
                                        </thead>
                                        <tbody id="eduTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="m-3 text-center"> Family Details</h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Occupation</th>
                                            <th>Contact No</th>
                                            <th>Age</th>

                                        </thead>
                                        <tbody id="famTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="m-3 text-center"> Known Language </h5>
                                <div class="table-con">
                                    <table class="">
                                        <thead>
                                            <th>Language</th>
                                            <th>Level</th>
                                            <th>Read</th>
                                            <th>Write</th>
                                            <th>Speak</th>

                                        </thead>
                                        <tbody id="langTableBody">

                                        </tbody>
                                    </table>
                                </div>
                                <h5 class="mt-3 text-center ">Experience Details</h5>
                                <div class="table-con">
                                    <table>
                                        <thead>
                                            <th>Previous company name</th>
                                            <th>Date from</th>
                                            <th>Date to</th>
                                            <th>Exp year</th>

                                            <th>Designation</th>
                                            <th>Last salary</th>

                                            <th>Reason for leaving</th>
                                            <th>Contact No</th>
                                            <th>Attachment</th>

                                        </thead>
                                        <tbody id="expTableBody">




                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>




                    <div class="modal-footer">
                        <div class=" gap-2 ">
                            <form action="{{route('candidateSelectPros')}}" method="post" id="validate">

                                @csrf
                                <input type="hidden" name="Rowid" id="candidate-rowid">
                                <input type="hidden" name="mailid" id="candidate-mailid">
                                <input type="hidden" name="position" id="candidate-position">
                                <input type="hidden" name="dept" id="candidate-dept">
                                <input type="hidden" name="name" id="candidate-name">

                                <input type="hidden" name="hrEmplno" id="hr-emplno">
                                <input type="hidden" name="techEmplno" id="tech-emplno">
                                <input type="hidden" name="tech1Emplno" id="tech1-emplno">
                                <input type="hidden" name="finalEmplno" id="final-emplno">
                                <input type="hidden" name="posId" id="position-id">

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">Interview Date</label>
                                            <input type="date" name="InterviewDate" id="" class="form-control mb-3" value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}">
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary" name="Selected" value="Selected-1">Select For Interview</button>
                                <button type="submit" class="btn btn-danger" name="Rejected" value="Rejected">Rejected</button>

                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                    Close
                                </button>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>



        <!-- end main content-->

    </div>

    <!-- END layout-wrapper -->

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->

    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>
    <script src="Applicant/assets/libs/fullcalendar/index.global.min.js"></script>
    <script src="Applicant/assets/js/pages/job-candidate-lists.init.js"></script>
    <script src="Applicant/assets/js/pages/choice.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.min.js"></script>
    <script src="Applicant/assets/js/pages/calendar.init.js"></script>
    <script src="Applicant/assets/libs/gridjs/gridjs.umd.js"></script>
    <script src="Applicant/assets/js/app.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Flatpickr for time input
            const timepickerOptions = {
                enableTime: true,
                noCalendar: true,
                dateFormat: 'h:i K', // 12-hour format with AM/PM indicator
                time_24hr: false, // Set to false for 12-hour time
                disableMobile: true,
                allowInput: true // Allow manual typing
            };

            // Initialize time pickers with individual default times
            flatpickr('#timepicker1', {
                ...timepickerOptions,
                defaultDate: "9:00 AM"
            });
            flatpickr('#timepicker2', {
                ...timepickerOptions,
                defaultDate: "10:00 AM"
            });
        });
    </script>

    <!-- MONTH WISE APPLICANT DETAILS -->
    <script>
        $(document).ready(function() {
            let firstMonth = $("#Month option:selected").val();
            CanDet_monthwise(firstMonth);
        });

        function ChangeMonth() {
            let selectedMonth = $("#Month").val();
            CanDet_monthwise(selectedMonth);
        }

        function CanDet_monthwise(Month) {
            try {

                Month = Month || $("#Month").val();
                console.log('Month', Month);
                $('#spinner').show();

                $.ajax({
                    url: "{{ route('AppliedCan_monthly') }}",
                    type: "GET",
                    data: {
                        Month: Month
                    },
                    dataType: 'json',
                    success: function(Month_ApplicantNam) {
                        console.log('Candidate Monthly ', Month_ApplicantNam);

                        if (Month_ApplicantNam.Appli_Name && Month_ApplicantNam.Appli_Name.length > 0) {
                            var applicantDropdown = $("#ApplicantName"); // Make sure the ID matches your second select
                            applicantDropdown.empty(); // Clear previous options
                            applicantDropdown.append('<option value="">--Select Applicant Name--</option>'); // Add default option

                            // Populate dropdown with data
                            Month_ApplicantNam.Appli_Name.forEach(function(applicant) {
                                if (applicant.ApplicantName) {
                                    applicantDropdown.append(`<option value="${applicant.Rowid}">${applicant.ApplicantName}/${applicant.canNo}/${applicant.position}</option>`);
                                }
                            });
                        }

                        // Clear previous data
                        $('#candidate-list').empty();

                        // Iterate over the data and populate elements dynamically
                        Month_ApplicantNam.Monthlist.forEach(function(candidate) {

                            let formattedDate = "--"; // Default value

                            if (candidate.Entrytime) {
                                let parts = candidate.Entrytime.split(" ")[0].split("-"); // Extract DD-MM-YYYY
                                let day = parts[0];
                                let month = parts[1];
                                let year = parts[2];

                                // Convert month number to short month name
                                let monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                                formattedDate = `${day}-${monthNames[parseInt(month) - 1]}-${year}`;
                            }

                            var resumeLink = candidate.resumeAttach ?
                                `<a href="` + candidate.resumeAttach + `" download="Resume">Resume <i class="ri-arrow-down-line align-bottom ms-1"></i></a>` :
                                "--";


                            var candidateHTML = `
                            <div class="col-xxl-6 joblist-card">
                                <div class="card joblist-card">
                                    <div class="card-body">
                                        <div class="d-flex mb-4">
                                            <div class="avatar-sm">
                                                <div class="avatar-title bg-light rounded">
                                                    <img src="` + (candidate.profileImg ? candidate.profileImg : "{{ asset('Applicant/assets/Img/Jobimg/profile-1.png') }}") + `" alt="" class="avatar-xxs companyLogo-img" />
                                                </div>
                                            </div>
                                            <div class="ms-3 flex-grow-1">
                                                <a href="#!" class="viewjob-list" onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"  data-bs-toggle="modal" data-bs-target="#OverView"'>
                                                    <h5 class="job-title">` + candidate.ApplicantName + ` - ` + candidate.canNo + `</h5>
                                                </a>
                                                <p class="company-name text-muted mb-0">` + candidate.position + `</p>
                                            </div>
                                        </div>
                                        <div>Skill: ` + candidate.skill + `</div>
                                    </div>
                                    <div class="card-footer border-top-dashed">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                            <div>
                                                <i class="ri-briefcase-2-line align-bottom me-1"></i>
                                                <span class="job-type">Applied On: ` + formattedDate + `</span>
                                            </div>
                                            <div>` + resumeLink + `</div>
                                            <div>
                                               <button type="button" class="btn btn-primary viewjob-list"  onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"  data-bs-toggle="modal" data-bs-target="#OverView">
                                                    View More
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            `;

                            // Append the candidate's HTML to the container
                            $('#candidate-list').append(candidateHTML);
                        });
                        $('#spinner').hide();
                    },
                    error: function(status, error) {
                        console.error('Ajax Error', status, error);
                        $('#spinner').hide();
                    }
                });
            } catch (error) {
                alert('Error Message in CanDet_monthwise Function: ' + error.message);
                console.error('Catch Error:', error);
                $('#spinner').hide();
            }
        }

        function ChangeApplicant(ApplicantID) {
            try {
                console.log('Applicant ID', ApplicantID);
                $('#spinner').show();
                $.ajax({
                    url: "{{ route('AppliedCan_change') }}",
                    type: "GET",
                    data: {
                        Applicant_ID: ApplicantID,
                    },
                    dataType: 'json',
                    success: function(Applicant_det) {
                        console.log('APPLICANT Monthly ', Applicant_det);


                        // Clear previous data
                        $('#candidate-list').empty();

                        // Iterate over the data and populate elements dynamically
                        Applicant_det.forEach(function(candidate) {

                            let formattedDate = "--"; // Default value

                            if (candidate.Entrytime) {
                                let parts = candidate.Entrytime.split(" ")[0].split("-"); // Extract DD-MM-YYYY
                                let day = parts[0];
                                let month = parts[1];
                                let year = parts[2];

                                // Convert month number to short month name
                                let monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                                formattedDate = `${day}-${monthNames[parseInt(month) - 1]}-${year}`;
                            }

                            var resumeLink = candidate.resumeAttach ?
                                `<a href="` + candidate.resumeAttach + `" download="Resume">Resume <i class="ri-arrow-down-line align-bottom ms-1"></i></a>` :
                                "--";

                            var candidateHTML = `
                            <div class="col-xxl-6 joblist-card">
                                <div class="card joblist-card">
                                    <div class="card-body">
                                        <div class="d-flex mb-4">
                                            <div class="avatar-sm">
                                                <div class="avatar-title bg-light rounded">
                                                    <img src="` + (candidate.profileImg ? candidate.profileImg : "{{ asset('Applicant/assets/Img/Jobimg/profile-1.png') }}") + `" alt="" class="avatar-xxs companyLogo-img" />
                                                </div>
                                            </div>
                                            <div class="ms-3 flex-grow-1">
                                                <a href="#!" class="viewjob-list"onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"  data-bs-toggle="modal" data-bs-target="#OverView"'>
                                                    <h5 class="job-title">` + candidate.ApplicantName + ` - ` + candidate.canNo + `</h5>
                                                </a>
                                                <p class="company-name text-muted mb-0">` + candidate.position + `</p>
                                            </div>
                                        </div>
                                        <div>Skill: ` + candidate.skill + `</div>
                                    </div>
                                    <div class="card-footer border-top-dashed">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                            <div>
                                                <i class="ri-briefcase-2-line align-bottom me-1"></i>
                                                <span class="job-type">Applied On: ` + formattedDate + `</span>
                                            </div>
                                            <div>` + resumeLink + `</div>
                                            <div>
                                               <button type="button" class="btn btn-primary viewjob-list"  onclick="FullDetails('` + candidate.Rowid + `', '` + candidate.jobId + `')"  data-bs-toggle="modal" data-bs-target="#OverView">
                                                    View More
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            `;

                            // Append the candidate's HTML to the container
                            $('#candidate-list').append(candidateHTML);
                        });
                        $('#spinner').hide();
                    },
                    error: function(status, error) {
                        console.error('Ajax Error', status, error);
                        $('#spinner').hide();
                    }
                });
            } catch (error) {
                alert('Error Message in ChangeApplicant Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE FULL DETAILS -->
    <script>
        function FullDetails(Rowid, jobId) {
            console.log('Rowid:', Rowid);
            console.log('jobId:', jobId);
            try {
                $.ajax({
                    url: "{{ route('Applicant_FullDetailss') }}",
                    type: "GET",
                    data: {
                        Rowid: Rowid,
                        jobId: jobId
                    },
                    dataType: 'json',
                    success: function(fullDetails) {
                        console.log('Details:', fullDetails);

                        if (!fullDetails.Report || fullDetails.Report.length === 0) {
                            alert("No details found.");
                            return;
                        }

                        let report = fullDetails.Report[0];
                        let joblist = fullDetails.joblist[0] || {};

                        // Show Modal
                        $("#canDetails").modal("show");


                        // TO SAVE THE FORM MODAL
                        $('#candidate-rowid').val(report.Rowid || '-');
                        $('#candidate-mailid').val(report.EmailId || '-');
                        $('#candidate-position').val(report.position || '-');
                        $('#candidate-dept').val(report.ADept || '-');
                        $('#candidate-name').val(report.ApplicantName || '-');


                        $('#hr-emplno').val(joblist.hrEmplno || '-');
                        $('#tech-emplno').val(joblist.techIntEmplno || '-');
                        $('#tech1-emplno').val(joblist.tech1IntEmplno || '-');
                        $('#final-emplno').val(joblist.finalIntEmplno || '-');
                        $('#position-id').val(joblist.Rowid || '-');



                        // Profile Images
                        $('#modal-cover-img').attr('src', report.BackImg || 'default-cover.jpg');
                        $('#profile-img').attr('src', report.profileImg || 'default-profile.jpg');

                        // Basic Details
                        $('#applicant-Name').text(report.ApplicantName || '-');
                        $('#applicant-position').text(report.position || '-');
                        $('#applicant-dept').text(report.ADept || '-');
                        $('#applicant-aadharNo').text(report.AadharNo || '-');
                        $('#applicant-dob').text(report.DOB ? report.DOB.split(" ")[0] : '-');
                        $('#applicant-contNo').text(report.ContactNo || '-');
                        $('#applicant-marriageSts').text(report.MarrigeSts || '-');
                        $('#applicant-bloodGrp').text(report.BloodGroup || '-');
                        $('#applicant-skill').text(report.skill || '-');
                        $('#applicant-mailid').text(report.EmailId || '-');

                        // Permanent Address
                        $('#applicant-pstreet').text(report.PStreet || '-');
                        $('#applicant-plocation').text(report.Plocation || '-');
                        $('#applicant-ptaluk').text(report.PTaluk || '-');
                        $('#applicant-pdistrict').text(report.PDistrict || '-');
                        $('#applicant-pstate').text(report.Pstate || '-');
                        $('#applicant-pcountry').text(report.PCountry || '-');
                        $('#applicant-ppincode').text(report.ppincode || '-');

                        // Current Address
                        $('#applicant-cstreet').text(report.CStreet || '-');
                        $('#applicant-clocation').text(report.Clocation || '-');
                        $('#applicant-ctaluk').text(report.CTaluk || '-');
                        $('#applicant-cdistrict').text(report.CDistrict || '-');
                        $('#applicant-cstate').text(report.Cstate || '-');
                        $('#applicant-ccountry').text(report.CCountry || '-');
                        $('#applicant-cpincode').text(report.Cpincode || '-');

                        // Education Details
                        let eduHTML = "";
                        fullDetails.Education.forEach(edu => {
                            eduHTML += `<tr>
                    <td>${edu.Education || '-'}</td>
                    <td>${edu.Branch || '-'}</td>
                    <td>${edu.Collage_School || '-'}</td>
                    <td>${edu.University_Board || '-'}</td>
                    <td>${edu.Percentage || '-'}</td>
                    <td>${edu.YearofComplition || '-'}</td>
                    <td>${edu.ExpAttatchment ? `<a href="${edu.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                    </tr>`;
                        });
                        $("#eduTableBody").html(eduHTML || "<tr><td colspan='7'>No data available</td></tr>");

                        // Family Details
                        let famHTML = "";
                        fullDetails.Family.forEach(fam => {
                            famHTML += `<tr>
                    <td>${fam.Name || '-'}</td>
                    <td>${fam.Type || '-'}</td>
                    <td>${fam.Occupation || '-'}</td>
                    <td>${fam.ContactNo || '-'}</td>
                    <td>${fam.Age || '-'}</td>
                </tr>`;
                        });
                        $("#famTableBody").html(famHTML || "<tr><td colspan='5'>No data available</td></tr>");

                        // Language Details
                        let langHTML = "";
                        fullDetails.Language.forEach(lang => {
                            langHTML += `<tr>
                    <td>${lang.Lang || '-'}</td>
                    <td>${lang.Level || '-'}</td>
                    <td>${lang.Reading || 'No'}</td>
                    <td>${lang.Write || 'No'}</td>
                    <td>${lang.Speak || 'No'}</td>
                </tr>`;
                        });
                        $("#langTableBody").html(langHTML || "<tr><td colspan='5'>No data available</td></tr>");

                        // Experience Details
                        let expHTML = "";
                        fullDetails.Experience.forEach(exp => {
                            expHTML += `<tr>
                    <td>${exp.PCompany || '-'}</td>
                    <td>${exp.FDate ? exp.FDate.split(' ')[0] : '-'}</td>
                    <td>${exp.TDate ? exp.TDate.split(' ')[0] : '-'}</td>
                    <td>${exp.ExpYear || '-'}</td>
                    <td>${exp.Designation || '-'}</td>
                    <td>${exp.LastSalary || '-'}</td>
                    <td>${exp.ResForLeave || '-'}</td>
                    <td>${exp.pContactNo || '-'}</td>
                    <td>${exp.ExpAttatchment ? `<a href="${exp.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                </tr>`;
                        });
                        $("#expTableBody").html(expHTML || "<tr><td colspan='9'>No data available</td></tr>");

                        console.log('Modal Triggered');
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('Failed to retrieve data.');
                    }
                });
            } catch (error) {
                alert('Error Message in FullDetails Function: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>


    <!-- <script>
        // ======================== applicant details ================================
        $(document).on('click', '.viewjob-list', function() {

            var applicantBasicDtls = $(this).data('can-details');
            var applicantEduDtls = $(this).data('can-edu');
            var applicantFamDtls = $(this).data('can-fam');
            var applicantLangDtls = $(this).data('can-lang');
            // var applicantExpDtls = $(this).data('can-exp');
            var jobDtls = $(this).data('job-lists');

            debugger;
            // console.log(applicantBasicDtls);
            console.log('CAN LANG 2', typeof(applicantLangDtls));
            // console.log('CAN EXP 2', typeof(applicantExpDtls));


            // let rawData = $(this).data('can-exp');

            // try {
            //     // Step 1: Decode URL-encoded data
            //     let decodedData = decodeURIComponent(rawData);
            //     console.log("Decoded Data:", decodedData);

            //     // Step 2: Fix missing closing brackets (if truncated)
            //     let jsonFixed = decodedData.trim();
            //     if (!jsonFixed.endsWith("]") && jsonFixed.startsWith("[")) {
            //         jsonFixed += "]"; // Attempt to fix incomplete arrays
            //     }

            //     // Step 3: Ensure valid JSON structure
            //     if (!jsonFixed.startsWith("[") || !jsonFixed.endsWith("]")) {
            //         throw new Error("Invalid JSON structure. Data might be truncated.");
            //     }

            //     // Step 4: Parse JSON safely
            //     let parsedData = JSON.parse(jsonFixed);
            //     console.log("Parsed JSON:", parsedData);

            // } catch (error) {
            //     console.error("JSON Parse Error:", error.message);
            //     console.error("Faulty Data:", rawData);
            // }





            console.log('CAN EXP 3', typeof(applicantExpDtls));


            let candidateRowid = applicantBasicDtls['Rowid'];
            let candidateMailId = applicantBasicDtls['EmailId'];
            let candidatePosition = applicantBasicDtls['position'];
            let candidateDept = applicantBasicDtls['ADept'];
            let candidateName = applicantBasicDtls['ApplicantName'];
            let candidateProfile = applicantBasicDtls['profileImg'];

            console.log('rowwid', candidateRowid);

            $('#eduTableBody').empty();
            $('#famTableBody').empty();
            $('#langTableBody').empty();
            $('#expTableBody').empty();

            //  ====================== education =========================

            // console.log(eduMasID);

            for (let i = 0; i < applicantEduDtls.length; i++) {
                const eduMasID = applicantEduDtls[i]["masterId"];
                if (applicantBasicDtls['Rowid'] == eduMasID) {
                    const eduType = applicantEduDtls[i]["Education"];
                    const eduBranch = applicantEduDtls[i]["Branch"];
                    const eduScl_clg = applicantEduDtls[i]["Collage_School"];
                    const eduUni_state = applicantEduDtls[i]["University_Board"];
                    const eduPercentage = applicantEduDtls[i]["Percentage"];
                    const eduYearOfComp = applicantEduDtls[i]["YearofComplition"];
                    let eduAttach = applicantEduDtls[i]["eduAttach"];
                    const newRow = $('<tr>');
                    newRow.append('<td >' + eduType + '</td>');
                    newRow.append('<td >' + eduBranch + '</td>');
                    newRow.append('<td >' + eduScl_clg + '</td>');
                    newRow.append('<td >' + eduUni_state + '</td>');
                    newRow.append('<td >' + eduPercentage + '</td>');
                    newRow.append('<td >' + eduYearOfComp + '</td>');
                    if (eduAttach == "") {
                        eduAttach = "no Attachment";
                        newRow.append('<td >' + eduAttach + '</td>');
                    } else {

                        newRow.append('<td>' + '<a href="' + eduAttach + '" download ="education">Download</a>' + '</td>');

                    }
                    $('#eduTableBody').append(newRow);
                } else {

                }
            }

            //   ========================= family =====================================
            for (let i = 0; i < applicantFamDtls.length; i++) {

                const famMasID = applicantFamDtls[i]["MasterId"];

                if (applicantBasicDtls['Rowid'] == famMasID) {

                    const famName = applicantFamDtls[i]["Name"];
                    const famType = applicantFamDtls[i]["Type"];
                    const famOccupation = applicantFamDtls[i]["Occupation"];
                    const famContNo = applicantFamDtls[i]["ContactNo"];
                    const Age = applicantFamDtls[i]["Age"];

                    const newRow = $('<tr>');
                    newRow.append('<td >' + famName + '</td>');
                    newRow.append('<td >' + famType + '</td>');
                    newRow.append('<td >' + famOccupation + '</td>');
                    newRow.append('<td >' + famContNo + '</td>');
                    newRow.append('<td >' + Age + '</td>');
                    $('#famTableBody').append(newRow);
                } else {

                }

            }

            //  ========== end family =================================

            //   ========================= landuage =====================================
            for (let i = 0; i < applicantLangDtls.length; i++) {

                const langMasID = applicantLangDtls[i]["MasterId"];
                // console.log(langMasID);
                if (applicantBasicDtls['Rowid'] == langMasID) {

                    const langType = applicantLangDtls[i]["Lang"];
                    const langLevel = applicantLangDtls[i]["Level"];
                    const langReading = applicantLangDtls[i]["Reading"];
                    const langSpeak = applicantLangDtls[i]["Speak"];
                    const langWrite = applicantLangDtls[i]["Write"];


                    const newRow = $('<tr>');
                    newRow.append('<td >' + langType + '</td>');
                    newRow.append('<td >' + langLevel + '</td>');
                    newRow.append('<td >' + langReading + '</td>');
                    newRow.append('<td >' + langSpeak + '</td>');
                    newRow.append('<td >' + langWrite + '</td>');
                    $('#langTableBody').append(newRow);
                } else {

                }
                // console.log(eduMasID);
                // if (applicantBasicDtls['Rowid'] == EduMasID) {

                // } else {

                // }
            }

            console.log('Type of applicantBasicDtls:', typeof applicantBasicDtls, applicantBasicDtls);
            console.log('Type of applicantExpDtls:', typeof applicantExpDtls, applicantExpDtls);

            for (let i = 0; i < applicantExpDtls.length; i++) {

                const expMasID = applicantExpDtls[i]["MasterId"];
                console.log('Master id', expMasID);
                console.log('rowid id', applicantBasicDtls['Rowid']);


                if (applicantBasicDtls['Rowid'] == expMasID) {

                    var PCompany = applicantExpDtls[i]["PCompany"];
                    var FDate = applicantExpDtls[i]["FDate"];
                    var FdateOnly = FDate.split(' ')[0];
                    var TDate = applicantExpDtls[i]["TDate"];
                    var TdateOnly = TDate.split(' ')[0];

                    var ExpYear = applicantExpDtls[i]["ExpYear"];
                    // var Pdept = applicantExpDtls[i]["Department"];
                    var Pdesign = applicantExpDtls[i]["Designation"];
                    var LastSalary = applicantExpDtls[i]["LastSalary"];
                    // var ExpectSalary = applicantExpDtls[i]["ExpectSalary"];
                    var ResForLeave = applicantExpDtls[i]["ResForLeave"];
                    var pContactNo = applicantExpDtls[i]["pContactNo"];
                    var RefEmplno = applicantExpDtls[i]["RefEmplno"];
                    var ExpAttatchment = applicantExpDtls[i]["ExpAttatchment"];
                    console.log(ExpAttatchment);
                    const newRow = $('<tr>');
                    newRow.append('<td >' + PCompany + '</td>');
                    newRow.append('<td >' + FdateOnly + '</td>');
                    newRow.append('<td >' + TdateOnly + '</td>');
                    newRow.append('<td >' + ExpYear + '</td>');
                    // newRow.append('<td >' + Pdept + '</td>');
                    newRow.append('<td >' + Pdesign + '</td>');
                    newRow.append('<td >' + LastSalary + '</td>');
                    // newRow.append('<td >' + ExpectSalary + '</td>');
                    newRow.append('<td >' + ResForLeave + '</td>');
                    newRow.append('<td >' + pContactNo + '</td>');
                    if (ExpAttatchment == "") {
                        ExpAttatchment = "No Attachment";
                        newRow.append('<td>' + ExpAttatchment + '</td>');
                    } else {
                        newRow.append('<td>' + '<a href="' + ExpAttatchment + '" download="experience">Download</a>' + '</td>');
                    }

                    $('#expTableBody').append(newRow);
                } else {

                }
                // console.log(eduMasID);
                // if (applicantBasicDtls['Rowid'] == EduMasID) {

                // } else {

                // }

            }

            // ==============  end language =================================

            var BackImg = applicantBasicDtls["BackImg"];
            var profileImg = applicantBasicDtls["profileImg"];
            var resumeAttach = applicantBasicDtls["resumeAttach"];
            var ExpAttatchment = applicantBasicDtls["ExpAttatchment"];

            var ApplicantName = applicantBasicDtls["ApplicantName"];
            var ADept = applicantBasicDtls["ADept"];
            var position = applicantBasicDtls["position"];
            var AadharNo = applicantBasicDtls["AadharNo"];
            var dateParts = applicantBasicDtls["DOB"];
            var DOB = dateParts.split(' ')[0];
            var ContactNo = applicantBasicDtls["ContactNo"];
            var BloodGroup = applicantBasicDtls["BloodGroup"];
            var MarrigeSts = applicantBasicDtls["MarrigeSts"];
            var skill = applicantBasicDtls["skill"];
            var EmailId = applicantBasicDtls["EmailId"];


            $('#candidate-rowid').val(candidateRowid);
            $('#candidate-mailid').val(candidateMailId);
            $('#candidate-position').val(candidatePosition);
            $('#candidate-dept').val(candidateDept);
            $('#candidate-name').val(candidateName);
            $('#profile-img').attr('src', candidateProfile);
            // $('#modal-cover-img').attr('src', candidateProfile);

            $('#applicant-Name').text(ApplicantName);
            $('#applicant-dept').text(ADept);
            $('#applicant-position').text(position);
            $('#applicant-aadharNo').text(AadharNo);
            $('#applicant-dob').text(DOB);
            $('#applicant-contNo').text(ContactNo);
            $('#applicant-marriageSts').text(MarrigeSts);
            $('#applicant-bloodGrp').text(BloodGroup);
            $('#applicant-skill').text(skill);
            $('#applicant-mailid').text(EmailId);

            // permanent Address 
            var PStreet = applicantBasicDtls["PStreet"];
            var Plocation = applicantBasicDtls["Plocation"];
            var PTaluk = applicantBasicDtls["PTaluk"];
            var PDistrict = applicantBasicDtls["PDistrict"];
            var Pstate = applicantBasicDtls["Pstate"];
            var PCountry = applicantBasicDtls["PCountry"];
            var ppincode = applicantBasicDtls["ppincode"];

            $('#applicant-pstreet').text(PStreet);
            $('#applicant-plocation').text(Plocation);
            $('#applicant-ptaluk').text(PTaluk);
            $('#applicant-pdistrict').text(PDistrict);
            $('#applicant-pstate').text(Pstate);
            $('#applicant-pcountry').text(PCountry);
            $('#applicant-ppincode').text(ppincode);


            // current address 
            var CStreet = applicantBasicDtls["CStreet"];
            var Clocation = applicantBasicDtls["Clocation"];
            var CTaluk = applicantBasicDtls["CTaluk"];
            var CDistrict = applicantBasicDtls["CDistrict"];
            var Cstate = applicantBasicDtls["Cstate"];
            var CCountry = applicantBasicDtls["CCountry"];
            var Cpincode = applicantBasicDtls["Cpincode"];

            $('#applicant-cstreet').text(CStreet);
            $('#applicant-clocation').text(Clocation);
            $('#applicant-ctaluk').text(CTaluk);
            $('#applicant-cdistrict').text(CDistrict);
            $('#applicant-cstate').text(Cstate);
            $('#applicant-ccountry').text(CCountry);
            $('#applicant-cpincode').text(Cpincode);

            //  experience details

            // ========================  job details =============================

            for (let i = 0; i < jobDtls.length; i++) {

                if (applicantBasicDtls["jobId"] == jobDtls[i]["Rowid"]) {


                    let hrEmplno = jobDtls[i]["hrEmplno"];
                    let techIntEmplno = jobDtls[i]["techIntEmplno"];
                    let tech1IntEmplno = jobDtls[i]["tech1IntEmplno"];
                    let finalIntEmplno = jobDtls[i]["finalIntEmplno"];
                    let postionId = jobDtls[i]["Rowid"];

                    $('#hr-emplno').val(hrEmplno);
                    $('#tech-emplno ').val(techIntEmplno);
                    $('#tech1-emplno').val(tech1IntEmplno);
                    $('#final-emplno').val(finalIntEmplno);
                    $('#position-id').val(postionId);

                }

            }

            //  end job details ==============================


            var RefEmplno = applicantBasicDtls["RefEmplno"];
            if (RefEmplno == 0) {
                RefEmplno = "No Reference";
            }
            $('#applicant-refEmplno').text(RefEmplno);

        });
    </script> -->


    <script>
        $(document).ready(function() {

            var totalJobsCount = $('.joblist-card').length;

            $('#searchJob').on('input', function() {
                var searchQuery = $(this).val().toLowerCase();


                $('.joblist-card').hide();

                var visibleJobsCount = 0;

                $('.joblist-card').each(function() {

                    var jobTitle = $(this).find('.job-title').text().toLowerCase();
                    var companyName = $(this).find('.company-name').text().toLowerCase();
                    var skills = $(this).find('.job-description').text().toLowerCase();

                    if (jobTitle.includes(searchQuery) || companyName.includes(searchQuery) || skills.includes(searchQuery)) {

                        $(this).show();

                        visibleJobsCount++;

                    }



                });
                visibleJobsCount = visibleJobsCount / 2;
                $('#total-result').text(visibleJobsCount);
                $('#found-job-alert').removeClass('d-none');
            });
        });
    </script>

    <script>
        $(document).ready(function() {

            $(".assign-task").click(function() {

                let events = $("#event-category");
                let eventLength = events[0].length;

                let randomIndex = Math.floor(Math.random() * eventLength);
                events[0].selectedIndex = randomIndex;
            });
        })
    </script>


    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    @endsection
</body>

</html>