<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">
<!-- Mirrored from themesbrand.com/velzon/html/master/apps-job-candidate-lists.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:47:54 GMT -->

<head>
    <meta charset="utf-8" />
    <title>
        CANDIDATES REPORT
    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />


    <!-- gridjs css -->
    <link rel="stylesheet" href="Applicant/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!--  ================== star Start ====== -->

    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">


    <style>
        @import url(https://fonts.googleapis.com/css?family=Roboto:500,100,300,700,400);

        body {
            background-color: #eee;

        }

        div.stars {

            display: inline-block;
        }

        input.star {

            display: none;
        }

        label.star {

            float: right;

            padding-left: 5px;

            font-size: 25px;

            color: #4A148C;

            transition: all .2s;

        }

        input.star:checked~label.star:before {

            content: '\f005';

            color: #FD4;

            transition: all .25s;

        }

        input.star-5:checked~label.star:before {

            color: #FE7;

            text-shadow: 0 0 20px #952;

        }

        input.star-1:checked~label.star:before {
            color: #F62;
        }

        label.star:hover {
            transform: rotate(-15deg) scale(1.3);
        }

        label.star:before {

            content: '\f006';

            font-family: FontAwesome;

        }
    </style>

    <!--  ================== star end ====== -->

    <!-- ==================== for table ==================== -->
    <!-- TABLE -->
    <style>
        .table-split table tbody tr td {
            width: 0px !important;
            border: none;
        }

        table tbody td,
        table thead th {

            padding: 5px;
            border: 1px solid gray;
        }

        table {
            width: 100%;

        }

        .table-con {
            overflow-x: auto;
        }

        @media (max-width: 426px) {
            .table-split table tbody tr td {
                width: 0px;

            }

            .table-split table tbody td:nth-child(2),
            .table-split table tbody td:nth-child(5) {
                display: none;
                /* flex-wrap: wrap; */
            }

            .table-split table tbody td {

                display: flex;

                flex-wrap: wrap;
            }

        }
    </style>

    <!-- JOB TABLE -->
    <style>
        #JobView table {
            width: 100%;
        }

        #JobView table td:first-child {
            width: 30%;
        }

        #JobView table td:nth-child(2) {
            width: 5%;
        }

        #JobView table td:last-child {
            width: 65%;
        }

        #JobView table tbody td {
            border: none;
        }
    </style>

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        @extends('Applicant.navbar')
        @section('content')
        <?php $userEmplNo = Session::get('empl_id');
        echo $userEmplNo; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content"style="margin-top:  0px !important;">
                <div class="container-fluid">

                    <?php
                    $ATSCandidateEntry = Session::get('ATSCandidateEntry');
                    $ATSCandidateReport = Session::get('ATSCandidateReport');
                    $ATSApplicantStsEntry = Session::get('ATSApplicantStsEntry');
                    ?>

                    @if ($ATSCandidateReport === "Y")
                    <div class="row gy-2">
                        <div class="card" style="margin-top:  0px !important;">
                            <div class="card-body" style="margin-top:  0px !important;">
                                <h5>Candidate Report</h5>
                                <div id="table-gridjs"></div>
                                <!-- <input type="text" class="SElectedRowid" name="SElectedRowid" id="SElectedRowid"> -->
                            </div>
                        </div>
                    </div>
                    @endif
                    <!-- end row -->
                    <!-- end row -->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear());
                            </script>
                            © Gainup Industries.
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- APPLICANT DETAILS MODAL -->
    <div class="modal fade" id="canDetails" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">

                <div class="modal-body">
                    <input type="hidden" id="id-field" />
                    <div class="row g-3">
                        <div class="col-lg-12">
                            <div class="px-1 pt-1">
                                <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                    <img src="Applicant/assets/Img/Jobimg/background-1.jpg" alt="" id="modal-cover-img-can" class="img-fluid" />

                                    <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                        <div class="flex-grow-1">
                                            <h5 class="modal-title text-white">

                                            </h5>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex gap-3 align-items-center">

                                                <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="text-center mb-4 mt-n5 pt-2">
                                <div class="position-relative d-inline-block">

                                    <div class="avatar-lg p-1">
                                        <div class="avatar-title bg-light rounded-circle">
                                            <img src="Applicant/assets/Img/ApplicantProfile/logo-1.jpg" id="profile-img-can" class="avatar-md rounded-circle object-fit-cover" />
                                        </div>
                                    </div>
                                </div>
                                <h5 class="fs-13 mt-3" id="exampleModal">

                                </h5>
                            </div>

                        </div>

                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="table-split">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p class="mt-3">Applicant Name</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-Name"></span>
                                            </td>
                                            <td>

                                                <p class="mt-3">Position </p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-position">-</span></td>
                                        </tr>
                                        <tr>
                                            <td>

                                                <p class="mt-3">Department Name</p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-dept">-</span>
                                            </td>
                                            <td>

                                                <p class="mt-3">Aadhar No </p>
                                                </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-aadharNo"></span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <p class="mt-3">DOB</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-dob"></span></td>
                                            <td>
                                                <p class="mt-3">Contact No</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-contNo">-</span></td>

                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Marriage Details</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-marriageSts">-</span></td>

                                            <td>
                                                <p class="mt-3">Blood Group</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-bloodGrp">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Skills</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-skill">-</span></td>

                                            <td>
                                                <p class="mt-3">EmailId</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-mailid">-</span></td>
                                        </tr>

                                        <!-- <tr>
                                                    <td>
                                                        <p class="mt-3">Father/HusBand Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                                </tr> -->
                                    </tbody>
                                </table>

                                <div class="divider"></div>
                            </div>
                            <div class="table-split">
                                <h5 class="mt-3 text-center ">Address </h5>
                                <h5 class="mt-3  ">Permanent Address </h5>
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p class="mt-3">Street </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pstreet">-</span></td>

                                            <td>
                                                <p class="mt-3">Location </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-plocation">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Taluk </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ptaluk">-</span></td>

                                            <td>
                                                <p class="mt-3">District</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pdistrict">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">State </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pstate">-</span></td>

                                            <td>
                                                <p class="mt-3">Country </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-pcountry">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">PinCode </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ppincode">-</span></td>

                                        </tr>

                                    </tbody>
                                </table>
                                <h5 class="mt-3  ">Current Address </h5>
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p class="mt-3">Street </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cstreet">-</span></td>

                                            <td>
                                                <p class="mt-3">Location </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-clocation">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">Taluk </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ctaluk">-</span></td>

                                            <td>
                                                <p class="mt-3">District</p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cdistrict">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">State </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cstate">-</span></td>

                                            <td>
                                                <p class="mt-3">Country </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-ccountry">-</span></td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <p class="mt-3">PinCode </p>
                                            </td>
                                            <td>:</td>
                                            <td><span class="text-body-secondary " id="applicant-cpincode">-</span></td>


                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="m-3 text-center"> Education Details</h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Education</th>
                                        <th>Branch</th>
                                        <th>Collage/School</th>
                                        <th>University/State</th>
                                        <th>Percentage(%)</th>
                                        <th>Completed Year</th>
                                        <th>Attachment</th>
                                    </thead>
                                    <tbody id="eduTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="m-3 text-center"> Family Details</h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Occupation</th>
                                        <th>Contact No</th>
                                        <th>Age</th>

                                    </thead>
                                    <tbody id="famTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="m-3 text-center"> Known Language </h5>
                            <div class="table-con">
                                <table class="">
                                    <thead>
                                        <th>Language</th>
                                        <th>Level</th>
                                        <th>Read</th>
                                        <th>Write</th>
                                        <th>Speak</th>

                                    </thead>
                                    <tbody id="langTableBody">

                                    </tbody>
                                </table>
                            </div>
                            <h5 class="mt-3 text-center ">Experience Details</h5>
                            <div class="table-con">
                                <table>
                                    <thead>
                                        <th>Previous company name</th>
                                        <th>Date from</th>
                                        <th>Date to</th>
                                        <th>Exp year</th>

                                        <th>Designation</th>
                                        <th>Last salary</th>

                                        <th>Reason for leaving</th>
                                        <th>Contact No</th>
                                        <th>Attachment</th>

                                    </thead>
                                    <tbody id="expTableBody">

                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class=" gap-2 ">

                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- INTERVIEW STATUS MODAL -->
    <div class="modal fade" id="OverView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content border-0">
                <form id="createjob-form" autocomplete="off" class="needs-validation" novalidate>
                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="" alt="" id="modal-cover-img" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="" id="profile-img" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>

                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div>

                                    <h5 class="mt-3 text-center ">Interviewer Details</h5>
                                    <div class="table-split">
                                        <table>
                                            <tbody id="interviewerDtlsTBody">
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Applicant Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary" id="job-applicant-name">-</span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Company</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-int-company">-</span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Department</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-int-Department">-</span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">HR Name</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-hrName">-</span></td>
                                                    <td><span class="badge bg-success " id="hr-status">not updated</span></td>
                                                    <td><span class="text-body-secondary " id="hr-remarks">- </span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Technical Interviewer</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-techIntName">-</span></td>
                                                    <td><span class="badge bg-success " id="tech-status">not updated</span></td>
                                                    <td><span class="text-body-secondary " id="tech-remarks">- </span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Technical Final</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-techIntFinalName">-</span></td>
                                                    <td><span class="badge bg-success " id="tech1-status">not updated</span></td>
                                                    <td><span class="text-body-secondary " id="tech1-remarks">- </span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p class="mt-3">Final Interviewer</p>
                                                    </td>
                                                    <td>:</td>
                                                    <td><span class="text-body-secondary " id="job-finalIntName">-</span></td>
                                                    <td><span class="badge bg-success " id="final-int-status">not updated</span></td>
                                                    <td><span class="text-body-secondary " id="final-int-remarks">- </span></td>
                                                </tr>
                                                <!-- <tr>
                                                        <td>
                                                            <p class="mt-3">Share this job</p>
                                                        </td>
                                                        <td>:</td>
                                                        <td><a href="#!" class="btn btn-icon btn-soft-info"><i class="ri-facebook-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-success"><i class="ri-whatsapp-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-secondary"><i class="ri-twitter-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-danger"><i class="ri-mail-line"></i></a></td>
                                                    </tr> -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                Close
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- JOB DETAILS MODAL -->
    <div class="modal fade" id="JobView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">
                <form id="createjob-form" autocomplete="off" class="needs-validation" novalidate>
                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="" alt="" id="modalcoverimg" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="" id="companylogoimg" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>

                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Job Description</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-remarks">Lorem ipsum dolor sit amet consectetur adipisicing elit. Obcaecati error nam ipsa beatae. Tenetur voluptas labore perspiciatis dolorem! Sed repellat et quia fugiat perferendis quisquam quod veniam porro tempora adipisci?</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-company"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Department">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Experience</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Experience">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">No of vacancy</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Vacancy">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Location</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Location">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Salary</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Salary">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="divider"></div>

                                    <h5 class="mt-3 text-center ">Interviewer Details</h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_company">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_intDepartment">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">HR Name</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_hrName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Interviewer</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_techIntName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Final</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_techIntFinalName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Final Interviewer</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job_finalIntName">-</span></td>
                                            </tr>
                                            <!-- <tr>
                                                <td>
                                                    <p class="mt-3">Share this job</p>
                                                </td>
                                                <td>:</td>
                                                <td><a href="#!" class="btn btn-icon btn-soft-info"><i class="ri-facebook-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-success"><i class="ri-whatsapp-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-secondary"><i class="ri-twitter-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-danger"><i class="ri-mail-line"></i></a></td>
                                            </tr> -->
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>




                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                Close
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- end main content-->

    </div>

    <!-- END layout-wrapper -->

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->

    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>
    <!-- <script src="Applicant/assets/libs/fullcalendar/index.global.min.js"></script> -->
    <script src="Applicant/assets/js/pages/job-candidate-lists.init.js"></script>
    <script src="Applicant/assets/js/pages/choice.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.min.js"></script>
    <script src="Applicant/assets/js/pages/calendar.init.js"></script>
    <script src="Applicant/assets/libs/gridjs/gridjs.umd.js"></script>
    <script src="Applicant/assets/js/app.js"></script>

    <!-- apexcharts -->
    <script src="Applicant/assets/libs/apexcharts/apexcharts.min.js"></script>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Flatpickr for time input
            const timepickerOptions = {
                enableTime: true,
                noCalendar: true,
                dateFormat: 'h:i K', // 12-hour format with AM/PM indicator
                time_24hr: false, // Set to false for 12-hour time
                disableMobile: true,
                allowInput: true // Allow manual typing
            };

            // Initialize time pickers with individual default times
            flatpickr('#timepicker1', {
                ...timepickerOptions,
                defaultDate: "9:00 AM"
            });
            flatpickr('#timepicker2', {
                ...timepickerOptions,
                defaultDate: "10:00 AM"
            });
        });
    </script>

    <!-- OLD TABLE -->
    <!-- <script>
        $(document).ready(function() {

            let applicantReport = @json($applicantReport);
            // console.log(applicantReport);

            const gridData = [];
            applicantReport.forEach((item, index) => {

                gridData.push([
                    index + 1 || "",
                    item.canNo || "",
                    item.ApplicantName ? `<a href="#" onclick="FullDetails(${item.Rowid})">${item.ApplicantName}</a>` : "",
                    item.position ? `<a href="#" onclick="JobDetails(${item.jobId})">${item.position}</a>` : "",
                    item.status ? `<a href="#" onclick="InterviewDetails(${item.Rowid})">${item.status}</a>` : "",
                    // item.status || "",
                    item.ADept || "",
                    item.JcomName || "",
                    item.resumeAttach ? `<a href="${item.resumeAttach}" download="Resume">Resume </a>` : "No Resume"
                ]);
            });

            // Remove the existing table
            let existingTable = document.getElementById("table-gridjs");
            if (existingTable.firstChild) {
                existingTable.removeChild(existingTable.firstChild);
            }

            // Create a new table element
            let newTable = document.createElement('div');
            newTable.id = 'gridjs-table';

            existingTable.appendChild(newTable);

            new gridjs.Grid({
                columns: [{
                        name: "ID",
                        width: "50px",
                        formatter: function(e) {
                            return gridjs.html('<span class="fw-semibold">' + e + "</span>");
                        },
                    },
                    {
                        name: "CanNo",
                        width: "100px"
                    },
                    {
                        name: "Name",
                        width: "180px",
                        formatter: function(e) {
                            return gridjs.html('<a href="#">' + e + "</a>");
                        },
                    },
                    {
                        name: "Position",
                        width: "160px",
                        formatter: function(e) {
                            return gridjs.html('<a href="#">' + e + "</a>");
                        },
                    },
                    {
                        name: "Status",
                        width: "150px",
                        formatter: function(e) {
                            if (e === "Rejected") {

                                return gridjs.html('<span class="badge bg-danger">' + e + "</span>");
                            }
                            if (e === "Pending") {

                                return gridjs.html('<span class="badge bg-warning">' + 'Pending' + "</span>");
                            }
                            if (e === "Selected-1") {

                                return gridjs.html('<span class="badge bg-info">' + 'Selected for next round' + "</span>");
                            }
                            if (e === "Fselected") {

                                return gridjs.html('<span class="badge bg-success">' + 'Final interview selected' + "</span>");
                            }

                            return gridjs.html('<span class="badge bg-primary">' + e + "</span>");

                        },
                    },
                    {
                        name: "Dept",
                        width: "150px"
                    },
                    {
                        name: "CompName",
                        width: "180px"
                    },
                    {
                        name: "Resume",
                        width: "120px",
                        formatter: e => gridjs.html(e)
                    },
                ],
                pagination: {
                    limit: 5
                },
                sort: true,
                search: true,
                data: gridData,
            }).render(document.getElementById("gridjs-table"));
        })
    </script> -->

    <!-- TABLE DETAILS -->
    <script>
        $(document).ready(function() {
            let applicantReport = @json($applicantReport);

            const gridData = [];
            applicantReport.forEach((item, index) => {
                let statusBadge = "";
                if (item.status === "Rejected") {
                    statusBadge = `<span class="badge bg-danger">${item.status}</span>`;
                } else if (item.status === "Pending") {
                    statusBadge = `<span class="badge bg-warning">Pending</span>`;
                } else if (item.status === "Selected-1") {
                    statusBadge = `<span class="badge bg-info">Selected for next round</span>`;
                } else if (item.status === "Fselected") {
                    statusBadge = `<span class="badge bg-success">Final interview selected</span>`;
                } else {
                    statusBadge = `<span class="badge bg-primary">${item.status}</span>`;
                }

                gridData.push([
                    index + 1 || "",
                    item.canNo || "",
                    item.ApplicantName ? `<a href="#" onclick="FullDetails(${item.Rowid})">${item.ApplicantName}</a>` : "",
                    item.position ? `<a href="#" onclick="JobDetails(${item.jobId})">${item.position}</a>` : "",
                    item.status ? `<a href="#" onclick="InterviewDetails(${item.Rowid})">${statusBadge}</a>` : "",
                    item.ADept || "",
                    item.JcomName || "",
                    item.resumeAttach ? `<a href="${item.resumeAttach}" download="Resume">Resume</a>` : "No Resume"
                ]);
            });

            // Remove the existing table
            let existingTable = document.getElementById("table-gridjs");
            if (existingTable.firstChild) {
                existingTable.removeChild(existingTable.firstChild);
            }

            // Create a new table element
            let newTable = document.createElement('div');
            newTable.id = 'gridjs-table';
            existingTable.appendChild(newTable);

            new gridjs.Grid({
                columns: [{
                        name: "ID",
                        width: "50px",
                        formatter: e => gridjs.html('<span class="fw-semibold">' + e + "</span>")
                    },
                    {
                        name: "CanNo",
                        width: "100px"
                    },
                    {
                        name: "Name",
                        width: "180px",
                        formatter: e => gridjs.html('<a href="#">' + e + "</a>")
                    },
                    {
                        name: "Position",
                        width: "160px",
                        formatter: e => gridjs.html('<a href="#">' + e + "</a>")
                    },
                    {
                        name: "Status",
                        width: "200px",
                        formatter: e => gridjs.html(e)
                    },
                    {
                        name: "Dept",
                        width: "150px"
                    },
                    {
                        name: "CompName",
                        width: "180px"
                    },
                    {
                        name: "Resume",
                        width: "120px",
                        formatter: e => gridjs.html(e)
                    },
                ],
                pagination: {
                    limit: 10
                },
                sort: true,
                search: true,
                data: gridData,
            }).render(document.getElementById("gridjs-table"));

        });
    </script>



    <!-- AJAX METHOD FOR SHOWING THE INTERVIEW DETAILS -->
    <script>
        function InterviewDetails(Rowid) {
            console.log('Rowiddd', Rowid);

            $.ajax({
                url: "{{ route('Interview_Dtls') }}",
                type: "GET",
                data: {
                    Rowid: Rowid,
                },
                dataType: 'json',
                success: function(Interv_Dtls) {
                    console.log('Interview Detls:', Interv_Dtls);


                    if (Interv_Dtls.length > 0) {
                        let data = Interv_Dtls[0]; // Extract first item from response

                        // Update modal fields
                        // $("#exampleModalLabel").text(data.ApplicantName || "-");
                        $("#modal-cover-img").attr("src", data.BackImg || "default-cover.jpg");
                        $("#profile-img").attr("src", data.profileImg || "default-profile.jpg");

                        // Populate interviewer details
                        $("#job-applicant-name").text(data.ApplicantName || "-");
                        $("#job-int-company").text(data.JcomName || "-");
                        $("#job-int-Department").text(data.ADept || "-");

                        $("#job-hrName").text(data.Hr_Name || "-");
                        $("#hr-status").text(data.hrSts || "not updated").removeClass().addClass(getBadgeClass(data.hrSts));
                        $("#hr-remarks").text(data.hrRemarks || "no remarks");

                        $("#job-techIntName").text(data.Techint_Name || "-");
                        $("#tech-status").text(data.techIntSts || "not updated").removeClass().addClass(getBadgeClass(data.techIntSts));
                        $("#tech-remarks").text(data.techIntRemarks || "no remarks");

                        $("#job-techIntFinalName").text(data.TechintFinal_Name || "-");
                        $("#tech1-status").text(data.tech1Sts || "not updated").removeClass().addClass(getBadgeClass(data.tech1Sts));
                        $("#tech1-remarks").text(data.tech1Remarks || "no remarks");

                        $("#job-finalIntName").text(data.Final_Name || "-");
                        $("#final-int-status").text(data.finalIntSts || "not updated").removeClass().addClass(getBadgeClass(data.finalIntSts));
                        $("#final-int-remarks").text(data.finalIntRemarks || "no remarks");

                        // Show the modal
                        $("#OverView").modal("show");
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('AJAX Error:', status, error);
                }
            });

        }

        // Helper function to return badge class based on status
        function getBadgeClass(status) {
            switch (status) {
                case "Selected":
                    return "badge bg-success";
                case "Rejected":
                    return "badge bg-danger";
                case "Waiting":
                    return "badge bg-warning";
                case "not updated":
                    return "badge bg-secondary";
                default:
                    return "badge bg-secondary";
            }
        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE JOB DETAILS -->
    <script>
        function JobDetails(jobId) {
            console.log('jobId', jobId);

            $.ajax({
                url: "{{ route('Job_Dtls') }}",
                type: "GET",
                data: {
                    jobId: jobId,
                },
                dataType: 'json',
                success: function(Job_Dtls) {
                    console.log('Job Detls:', Job_Dtls);
                    if (Job_Dtls.length > 0) {
                        let job = Job_Dtls[0]; // Assuming the response is an array with one object

                        console.log('Job Details:', job);

                        // Set job details in the modal
                        $('.modal-title').text(job.jobTitle);
                        $('#job-remarks').text(job.remarks);
                        $('#job-company').text(job.mainCompName);
                        $('#job-Department').text(job.DeptName);
                        $('#job-Experience').text(job.experience);
                        $('#job-Vacancy').text(job.no_of_vac);
                        $('#job-Location').text(job.location);
                        $('#job-Salary').text(job.salary);
                        $('#job-Skills').html(job.skills.replace(/&amp;/g, '&')); // Handling '&amp;'

                        $('#modalcoverimg').attr('src', job.img1);
                        $('#companylogoimg').attr('src', job.img2);

                        // Interviewer details
                        $('#job_company').text(job.CompName);
                        $('#job_intDepartment').text(job.DeptName);
                        $('#job_hrName').text(job.hrName || '-');
                        $('#job_techIntName').text(job.techIntName || '-');
                        $('#job_techIntFinalName').text(job.techfinalName || '-');
                        $('#job_finalIntName').text(job.finalIntName || '-');

                        // Show the modal
                        $('#JobView').modal('show');
                    } else {
                        alert("No job details found.");
                    }
                },

                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('AJAX Error:', status, error);
                }
            });

        }
    </script>

    <!-- AJAX METHOD FOR SHOWING THE FULL DETAILS -->
    <script>
        function FullDetails(Rowid) {
            console.log('Rowiddd', Rowid);

            $.ajax({
                url: "{{ route('Applicant_FullDetailss') }}",
                type: "GET",
                data: {
                    Rowid: Rowid,
                },
                dataType: 'json',
                success: function(fullDetails) {
                    console.log('Detls:', fullDetails);

                    // Show Modal
                    $("#canDetails").modal("show");

                    // Update basic information
                    $('#modal-cover-img-can').attr('src', fullDetails.Report[0].BackImg);
                    $('#profile-img-can').attr('src', fullDetails.Report[0].profileImg);
                    $('#applicant-Name').text(fullDetails.Report[0].ApplicantName);
                    $('#applicant-position').text(fullDetails.Report[0].position);
                    $('#applicant-dept').text(fullDetails.Report[0].ADept);
                    $('#applicant-aadharNo').text(fullDetails.Report[0].AadharNo);
                    let dob = fullDetails.Report[0].DOB; // "18/06/1979 00:00:00"
                    let dateOnly = dob.split(" ")[0]; // Extracts "18/06/1979"

                    $('#applicant-dob').text(dateOnly);

                    $('#applicant-contNo').text(fullDetails.Report[0].ContactNo);
                    $('#applicant-marriageSts').text(fullDetails.Report[0].MarrigeSts);
                    $('#applicant-bloodGrp').text(fullDetails.Report[0].BloodGroup);
                    $('#applicant-skill').text(fullDetails.Report[0].skill);
                    $('#applicant-mailid').text(fullDetails.Report[0].EmailId);

                    // Update Permanent Address
                    $('#applicant-pstreet').text(fullDetails.Report[0].PStreet);
                    $('#applicant-plocation').text(fullDetails.Report[0].Plocation);
                    $('#applicant-ptaluk').text(fullDetails.Report[0].PTaluk);
                    $('#applicant-pdistrict').text(fullDetails.Report[0].PDistrict);
                    $('#applicant-pstate').text(fullDetails.Report[0].Pstate);
                    $('#applicant-pcountry').text(fullDetails.Report[0].PCountry || "-");
                    $('#applicant-ppincode').text(fullDetails.Report[0].ppincode);

                    // Update Current Address
                    $('#applicant-cstreet').text(fullDetails.Report[0].CStreet);
                    $('#applicant-clocation').text(fullDetails.Report[0].Clocation);
                    $('#applicant-ctaluk').text(fullDetails.Report[0].CTaluk);
                    $('#applicant-cdistrict').text(fullDetails.Report[0].CDistrict);
                    $('#applicant-cstate').text(fullDetails.Report[0].Cstate);
                    $('#applicant-ccountry').text(fullDetails.Report[0].CCountry);
                    $('#applicant-cpincode').text(fullDetails.Report[0].Cpincode);

                    // Education Details
                    let eduHTML = "";
                    fullDetails.Education.forEach(edu => {
                        eduHTML += `<tr>
                    <td>${edu.Education || '-'}</td>
                    <td>${edu.Branch || '-'}</td>
                    <td>${edu.Collage_School || '-'}</td>
                    <td>${edu.University_Board || '-'}</td>
                    <td>${edu.Percentage || '-'}</td>
                    <td>${edu.YearofComplition || '-'}</td>
                    <td>${edu.ExpAttatchment ? `<a href="${edu.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                </tr>`;
                    });
                    $("#eduTableBody").html(eduHTML);

                    // Family Details
                    let famHTML = "";
                    fullDetails.Family.forEach(fam => {
                        famHTML += `<tr>
                    <td>${fam.Name || '-'}</td>
                    <td>${fam.Type || '-'}</td>
                    <td>${fam.Occupation || '-'}</td>
                    <td>${fam.ContactNo || '-'}</td>
                    <td>${fam.Age || '-'}</td>
                </tr>`;
                    });
                    $("#famTableBody").html(famHTML);

                    // Language Details
                    let langHTML = "";
                    fullDetails.Language.forEach(lang => {
                        langHTML += `<tr>
                    <td>${lang.Lang || '-'}</td>
                    <td>${lang.Level || '-'}</td>
                    <td>${lang.Reading || 'No'}</td>
                    <td>${lang.Write || 'No'}</td>
                    <td>${lang.Speak || 'No'}</td>
                </tr>`;
                    });
                    $("#langTableBody").html(langHTML);

                    // Experience Details
                    let expHTML = "";
                    fullDetails.Experience.forEach(exp => {
                        expHTML += `<tr>
                    <td>${exp.PCompany || '-'}</td>
                   <td>${exp.FDate ? exp.FDate.split(' ')[0] : '-'}</td>
                   <td>${exp.TDate ? exp.FDate.split(' ')[0] : '-'}</td>
                   <td>${exp.ExpYear || '-'}</td>
                    <td>${exp.Designation || '-'}</td>
                    <td>${exp.LastSalary || '-'}</td>
                    <td>${exp.ResForLeave || '-'}</td>
                    <td>${exp.pContactNo || '-'}</td>
                    <td>${exp.ExpAttatchment ? `<a href="${exp.ExpAttatchment}" target="_blank">View</a>` : '-'}</td>
                </tr>`;
                    });
                    $("#expTableBody").html(expHTML);

                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('AJAX Error:', status, error);
                }
            });

        }
    </script>

    <!-- DETAILS -->
    <script>
        $(document).ready(function() {
            // $('.viewcan-view').on('click', function() {
            $(document).on('click', '.viewcan-view', function() {


                // Get the company name from the data attribute
                var applicantBasicDtls = $(this).data('can-details');
                var applicantEduDtls = $(this).data('can-edu');
                var applicantFamDtls = $(this).data('can-fam');
                var applicantLangDtls = $(this).data('can-lang');
                var applicantExpDtls = $(this).data('can-exp');
                var jobDtls = $(this).data('job-lists');
                var rowid = $('#SElectedRowid').val();

                console.log('rowid rowid:', rowid);

                console.log('Basic Details:', applicantBasicDtls);
                console.log('Education Details:', applicantEduDtls);
                console.log('Family Details:', applicantFamDtls);
                console.log('Language Details:', applicantLangDtls);
                console.log('Experience Details:', applicantExpDtls);
                console.log('Job Details:', jobDtls);

                let candidateRowid = applicantBasicDtls['Rowid'];
                let candidateMailId = applicantBasicDtls['EmailId'];
                let candidatePosition = applicantBasicDtls['position'];
                let candidateDept = applicantBasicDtls['ADept'];
                let candidateName = applicantBasicDtls['ApplicantName'];
                let candidateProfile = applicantBasicDtls['profileImg'];

                $('#eduTableBody').empty();
                $('#famTableBody').empty();
                $('#langTableBody').empty();
                $('#expTableBody').empty();
                // debugger;

                for (let i = 0; i < applicantBasicDtls.length; i++) {
                    const BasicRowid = applicantBasicDtls[i]["Rowid"];

                    if (rowid === BasicRowid) {
                        console.log('rowid', applicantBasicDtls[i]["Rowid"]);

                        var BackImg = applicantBasicDtls[i]["BackImg"];
                        var profileImg = applicantBasicDtls[i]["profileImg"];
                        var resumeAttach = applicantBasicDtls[i]["resumeAttach"];
                        var ExpAttatchment = applicantBasicDtls[i]["ExpAttatchment"];

                        var ApplicantName = applicantBasicDtls[i]["ApplicantName"];
                        var ADept = applicantBasicDtls[i]["ADept"];
                        var position = applicantBasicDtls[i]["position"];
                        var AadharNo = applicantBasicDtls[i]["AadharNo"];
                        var dateParts = applicantBasicDtls[i]["DOB"];
                        var DOB = dateParts.split(' ')[0];
                        var ContactNo = applicantBasicDtls[i]["ContactNo"];
                        var BloodGroup = applicantBasicDtls[i]["BloodGroup"];
                        var MarrigeSts = applicantBasicDtls[i]["MarrigeSts"];
                        var skill = applicantBasicDtls[i]["skill"];
                        var EmailId = applicantBasicDtls[i]["EmailId"];


                        $('#candidate-rowid').val(candidateRowid);
                        $('#candidate-mailid').val(candidateMailId);
                        $('#candidate-position').val(candidatePosition);
                        $('#candidate-dept').val(candidateDept);
                        $('#candidate-name').val(candidateName);
                        $('#profile-img-can').attr('src', candidateProfile);
                        $('#modal-cover-img-can').attr('src', BackImg);

                        $('#applicant-Name').text(ApplicantName);
                        $('#applicant-dept').text(ADept);
                        $('#applicant-position').text(position);
                        $('#applicant-aadharNo').text(AadharNo);
                        $('#applicant-dob').text(DOB);
                        $('#applicant-contNo').text(ContactNo);
                        $('#applicant-marriageSts').text(MarrigeSts);
                        $('#applicant-bloodGrp').text(BloodGroup);
                        $('#applicant-skill').text(skill);
                        $('#applicant-mailid').text(EmailId);

                        // permanent Address 
                        var PStreet = applicantBasicDtls[i]["PStreet"];
                        var Plocation = applicantBasicDtls[i]["Plocation"];
                        var PTaluk = applicantBasicDtls[i]["PTaluk"];
                        var PDistrict = applicantBasicDtls[i]["PDistrict"];
                        var Pstate = applicantBasicDtls[i]["Pstate"];
                        var PCountry = applicantBasicDtls[i]["PCountry"];
                        var ppincode = applicantBasicDtls[i]["ppincode"];

                        $('#applicant-pstreet').text(PStreet);
                        $('#applicant-plocation').text(Plocation);
                        $('#applicant-ptaluk').text(PTaluk);
                        $('#applicant-pdistrict').text(PDistrict);
                        $('#applicant-pstate').text(Pstate);
                        $('#applicant-pcountry').text(PCountry);
                        $('#applicant-ppincode').text(ppincode);


                        // current address 
                        var CStreet = applicantBasicDtls[i]["CStreet"];
                        var Clocation = applicantBasicDtls[i]["Clocation"];
                        var CTaluk = applicantBasicDtls[i]["CTaluk"];
                        var CDistrict = applicantBasicDtls[i]["CDistrict"];
                        var Cstate = applicantBasicDtls[i]["Cstate"];
                        var CCountry = applicantBasicDtls[i]["CCountry"];
                        var Cpincode = applicantBasicDtls[i]["Cpincode"];

                        $('#applicant-cstreet').text(CStreet);
                        $('#applicant-clocation').text(Clocation);
                        $('#applicant-ctaluk').text(CTaluk);
                        $('#applicant-cdistrict').text(CDistrict);
                        $('#applicant-cstate').text(Cstate);
                        $('#applicant-ccountry').text(CCountry);
                        $('#applicant-cpincode').text(Cpincode);


                    }

                }
                //  ====================== education =========================

                // console.log(eduMasID);
                for (let i = 0; i < applicantEduDtls.length; i++) {
                    const eduMasID = applicantEduDtls[i]["masterId"];
                    // console.log('Edumaster', eduMasID);
                    // console.log('rowid', applicantBasicDtls['Rowid']);


                    if (rowid == eduMasID) {

                        const eduType = applicantEduDtls[i]["Education"];
                        const eduBranch = applicantEduDtls[i]["Branch"];
                        const eduScl_clg = applicantEduDtls[i]["Collage_School"];
                        const eduUni_state = applicantEduDtls[i]["University_Board"];
                        const eduPercentage = applicantEduDtls[i]["Percentage"];
                        const eduYearOfComp = applicantEduDtls[i]["YearofComplition"];
                        let eduAttach = applicantEduDtls[i]["eduAttach"];
                        const newRow = $('<tr>');
                        newRow.append('<td >' + eduType + '</td>');
                        newRow.append('<td >' + eduBranch + '</td>');
                        newRow.append('<td >' + eduScl_clg + '</td>');
                        newRow.append('<td >' + eduUni_state + '</td>');
                        newRow.append('<td >' + eduPercentage + '</td>');
                        newRow.append('<td >' + eduYearOfComp + '</td>');
                        if (eduAttach == "") {
                            eduAttach = "no Attachment";
                            newRow.append('<td >' + eduAttach + '</td>');
                        } else {

                            newRow.append('<td>' + '<a href="' + eduAttach + '" download ="education">Download</a>' + '</td>');

                        }
                        $('#eduTableBody').append(newRow);
                    } else {

                    }
                }



                // end  =============== education 

                //   ========================= family =====================================
                for (let i = 0; i < applicantFamDtls.length; i++) {

                    const famMasID = applicantFamDtls[i]["MasterId"];


                    if (rowid == famMasID) {

                        const famName = applicantFamDtls[i]["Name"];
                        const famType = applicantFamDtls[i]["Type"];
                        const famOccupation = applicantFamDtls[i]["Occupation"];
                        const famContNo = applicantFamDtls[i]["ContactNo"];
                        const Age = applicantFamDtls[i]["Age"];

                        const newRow = $('<tr>');
                        newRow.append('<td >' + famName + '</td>');
                        newRow.append('<td >' + famType + '</td>');
                        newRow.append('<td >' + famOccupation + '</td>');
                        newRow.append('<td >' + famContNo + '</td>');
                        newRow.append('<td >' + Age + '</td>');
                        $('#famTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (rowid== EduMasID) {

                    // } else {

                    // }
                }

                //  end family =================================

                //   ========================= language =====================================

                for (let i = 0; i < applicantLangDtls.length; i++) {

                    const langMasID = applicantLangDtls[i]["MasterId"];
                    // console.log(langMasID);
                    if (rowid == langMasID) {

                        const langType = applicantLangDtls[i]["Lang"];
                        const langLevel = applicantLangDtls[i]["Level"];
                        const langReading = applicantLangDtls[i]["Reading"];
                        const langSpeak = applicantLangDtls[i]["Speak"];
                        const langWrite = applicantLangDtls[i]["Write"];


                        const newRow = $('<tr>');
                        newRow.append('<td >' + langType + '</td>');
                        newRow.append('<td >' + langLevel + '</td>');
                        newRow.append('<td >' + langReading + '</td>');
                        newRow.append('<td >' + langSpeak + '</td>');
                        newRow.append('<td >' + langWrite + '</td>');
                        $('#langTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (rowid== EduMasID) {

                    // } else {

                    // }
                }
                for (let i = 0; i < applicantExpDtls.length; i++) {

                    const expMasID = applicantExpDtls[i]["MasterId"];

                    // console.log(langMasID);
                    if (rowid == expMasID) {

                        var PCompany = applicantExpDtls[i]["PCompany"];
                        var FDate = applicantExpDtls[i]["FDate"];
                        var FdateOnly = FDate.split(' ')[0];
                        var TDate = applicantExpDtls[i]["TDate"];
                        var TdateOnly = TDate.split(' ')[0];

                        var ExpYear = applicantExpDtls[i]["ExpYear"];
                        // var Pdept = applicantExpDtls[i]["Department"];
                        var Pdesign = applicantExpDtls[i]["Designation"];
                        var LastSalary = applicantExpDtls[i]["LastSalary"];
                        // var ExpectSalary = applicantExpDtls[i]["ExpectSalary"];
                        var ResForLeave = applicantExpDtls[i]["ResForLeave"];
                        var RefEmplno = applicantExpDtls[i]["RefEmplno"];
                        var ExpAttatchment = applicantExpDtls[i]["ExpAttatchment"];
                        const newRow = $('<tr>');
                        newRow.append('<td >' + PCompany + '</td>');
                        newRow.append('<td >' + FdateOnly + '</td>');
                        newRow.append('<td >' + TdateOnly + '</td>');
                        newRow.append('<td >' + ExpYear + '</td>');
                        // newRow.append('<td >' + Pdept + '</td>');
                        newRow.append('<td >' + Pdesign + '</td>');
                        newRow.append('<td >' + LastSalary + '</td>');
                        // newRow.append('<td >' + ExpectSalary + '</td>');
                        newRow.append('<td >' + ResForLeave + '</td>');
                        if (ExpAttatchment == "") {
                            ExpAttatchment = "No Attachment";
                            newRow.append('<td>' + ExpAttatchment + '</td>');
                        } else {
                            newRow.append('<td>' + '<a href="' + ExpAttatchment + '" download="experience">Download</a>' + '</td>');
                        }

                        $('#expTableBody').append(newRow);
                    } else {

                    }
                    // console.log(eduMasID);
                    // if (rowid== EduMasID) {

                    // } else {

                    // }
                }

                //  end language =================================

                // experience details

                // ========================  job details =============================

                for (let i = 0; i < jobDtls.length; i++) {

                    if (applicantBasicDtls["jobId"] == jobDtls[i]["Rowid"]) {

                        let hrEmplno = jobDtls[i]["hrEmplno"];
                        let techIntEmplno = jobDtls[i]["techIntEmplno"];
                        let tech1IntEmplno = jobDtls[i]["tech1IntEmplno"];
                        let finalIntEmplno = jobDtls[i]["finalIntEmplno"];
                        let postionId = jobDtls[i]["Rowid"];

                        $('#hr-emplno').val(hrEmplno);
                        $('#tech-emplno ').val(techIntEmplno);
                        $('#tech1-emplno').val(tech1IntEmplno);
                        $('#final-emplno').val(finalIntEmplno);
                        $('#position-id').val(postionId);

                    }

                }

                //  end job details ==============================


                var RefEmplno = applicantBasicDtls["RefEmplno"];
                if (RefEmplno == 0) {
                    RefEmplno = "No Reference";
                }
                $('#applicant-refEmplno').text(RefEmplno);


            })

        });
        $(document).on('change', '.SElectedRowid', function() {
            $('.viewcan-view').click();
        });
    </script>


    <!-- <script>
        $(document).ready(function() {

            var totalJobsCount = $('.joblist-card').length;

            $('#searchJob').on('input', function() {
                var searchQuery = $(this).val().toLowerCase();


                $('.joblist-card').hide();

                var visibleJobsCount = 0;

                $('.joblist-card').each(function() {

                    var jobTitle = $(this).find('.job-title').text().toLowerCase();
                    var companyName = $(this).find('.company-name').text().toLowerCase();
                    var skills = $(this).find('.job-description').text().toLowerCase();

                    if (jobTitle.includes(searchQuery) || companyName.includes(searchQuery) || skills.includes(searchQuery)) {

                        $(this).show();

                        visibleJobsCount++;

                    }



                });
                visibleJobsCount = visibleJobsCount / 2;
                $('#total-result').text(visibleJobsCount);
                $('#found-job-alert').removeClass('d-none');
            });
        });
    </script> -->

    <script>
        $(document).ready(function() {

            $(".assign-task").click(function() {

                let events = $("#event-category");
                let eventLength = events[0].length;

                let randomIndex = Math.floor(Math.random() * eventLength);
                events[0].selectedIndex = randomIndex;
            });
        })
    </script>
    @endsection
</body>

</html>