<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta charset="utf-8" />
    <title>JOB </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />

    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
       <!-- for star rating -->
   <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <style>
        table {
            width: 100%;
        }

        table td:first-child {
            width: 30%;
            /* Set the width you desire */
        }

        table td:nth-child(2) {
            width: 5%;
            /* Set the width you desire */
        }

        table td:last-child {
            width: 65%;
            /* Set the width you desire */
        }
    </style>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        @extends('Applicant.navbar')
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->

                    <!-- ============================= respose message ======================= -->
                    @if ($message = Session::get('errorMsg'))
                    <!-- Danger Alert -->
                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                        <i class="ri-user-smile-line label-icon"></i><strong>Job Close</strong> {{$message}}
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                    <script>
                        setTimeout(function() {
                            var successAlert = document.getElementById('alert');
                            if (successAlert) {
                                successAlert.remove();
                            }
                        }, 5000);
                    </script>
                    @endif

                    @if ($message = Session::get('SuccessMsg'))
                    <!-- Danger Alert -->
                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                        <i class="ri-user-smile-line label-icon"></i><strong>Job Close</strong> {{$message}}
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                    <script>
                        setTimeout(function() {
                            var successAlert = document.getElementById('alert');
                            if (successAlert) {
                                successAlert.remove();
                            }
                        }, 5000);
                    </script>
                    @endif

                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                @if(\Route::currentRouteName() == 'JobList')
                                <h4 class="mb-sm-0">Job Lists</h4>
                                @endif

                                @if(\Route::currentRouteName() == 'JobClose')
                                <h4 class="mb-sm-0">Job Close</h4>

                                @endif

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item">
                                            <a href="javascript: void(0);">Jobs</a>
                                        </li>
                                        @if(\Route::currentRouteName() == 'JobList')
                                        <li class="breadcrumb-item active">
                                            Job Lists
                                        </li>
                                        @endif
                                        @if(\Route::currentRouteName() == 'JobClose')
                                        <li class="breadcrumb-item active">
                                            Job Close
                                        </li>
                                        @endif
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <h6 class="card-title mb-0 flex-grow-1">
                                            Search Jobs
                                        </h6>
                                        <?php
                                        $ATSJobEntry = Session::get('ATSJobEntry');

                                        ?>
                                        @if ($ATSJobEntry === "Y")
                                        <div class="flex-shrink-0">
                                            <a class="btn btn-primary" href="NewJob">
                                                <i class="ri-add-line align-bottom me-1"></i>
                                                Create New Job
                                            </a>
                                        </div>
                                        @endif

                                    </div>
                                    <div class="row mt-3 gy-3">
                                        <div class="col-xxl-10 col-md-6">
                                            <div class="search-box">
                                                <input type="text" class="form-control search bg-light border-light" id="searchJob" autocomplete="off" placeholder="Search for jobs or companies..." />
                                                <i class="ri-search-line search-icon"></i>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 d-none" id="found-job-alert">
                                            <div class="alert alert-success mb-0 text-center" role="alert">
                                                <strong id="total-result">0</strong>
                                                jobs found
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row ">
                        <!-- ==========================  job list ============================= -->
                        @if(\Route::currentRouteName() == 'JobList')
                        @foreach ($joblist as $joblists)
                        <div class="col-xxl-6 joblist-card ">
                            <div id="job-list">
                                <div class="card joblist-card">
                                    <div class="card-body">
                                        <div class="d-flex mb-4">
                                            <div class="avatar-sm">
                                                <div class="avatar-title bg-light rounded">
                                                    <img src="{{$joblists['img2']}}" alt="" class="avatar-xxs companyLogo-img" />
                                                </div>
                                            </div>
                                            <div class="ms-3 flex-grow-1">
                                                <img src="" alt="" class="d-none cover-img" />
                                                <a href="#!">
                                                    <h5 class="job-title">{{$joblists['jobTitle']}} </h5>
                                                </a>
                                                <p class="company-name text-muted mb-0">
                                                    {{$joblists['mainCompName']}}
                                                </p>
                                            </div>
                                            <div>
                                                <button type="button" class="btn btn-ghost-primary btn-icon custom-toggle" data-bs-toggle="button">
                                                    <span class="icon-on"><i class="ri-bookmark-line"></i></span>
                                                    <span class="icon-off"><i class="ri-bookmark-fill"></i></span>
                                                </button>
                                            </div>
                                        </div>
                                        <p class="text-muted job-description">
                                            {{$joblists['remarks']}}
                                        </p>
                                        <div>Skill : {{$joblists['skills']}}</div>
                                    </div>
                                    <div class="card-footer border-top-dashed">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                            <div>
                                                <i class="ri-briefcase-2-line align-bottom me-1"></i>
                                                <span class="job-type"> {{$joblists['DeptName']}}</span>
                                            </div>
                                            <div class="d-none">
                                                <span class="job-experience">2</span>
                                            </div>
                                            <div>
                                                <i class="ri-map-pin-2-line align-bottom me-1"></i>
                                                <span class="job-location">{{$joblists['location']}}</span>
                                            </div>
                                            <div>
                                                <i class="ri-user-3-line align-bottom me-1"></i> {{$joblists['no_of_vac']}}

                                            </div>
                                            <div>
                                                <i class="ri-time-line align-bottom me-1"></i>
                                                <span class="job-postdate">{{ \Carbon\Carbon::parse($joblists['Edate'])->format('d-M-Y') }}</span>
                                            </div>
                                            <div>
                                                <a href="#!" class="btn btn-primary viewjob-list" data-bs-toggle="modal" data-bs-target="#OverView" data-job-details="{{$joblists['jobTitle']}}|{{$joblists['DeptName']}}|{{$joblists['experience']}}|{{$joblists['no_of_vac']}}|{{$joblists['location']}}|{{$joblists['salary']}}|{{$joblists['skills']}}|{{$joblists['img1']}}|{{$joblists['img2']}}|{{$joblists['remarks']}}|{{$joblists['grpDis']}}|{{$joblists['aptitude']}}|{{$joblists['techical']}}|{{$joblists['persInter']}}|{{$joblists['hrName']}}|{{$joblists['techIntName']}}|{{$joblists['techfinalName']}}|{{$joblists['finalIntName']}}|{{$joblists['CompName']}}|{{$joblists['intCompName']}}|{{$joblists['intDeptName']}}|{{$joblists['mainCompName']}}|{{$joblists['Edate']}}">
                                                    View More
                                                    <i class="ri-arrow-right-line align-bottom ms-1"></i>
                                                </a>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->
                        </div>
                        @endforeach
                        @endif
                        <!-- ========================== job list end ===================== -->
                        <!-- =========================  job Close ========================= -->
                        @if(\Route::currentRouteName() == 'JobClose')
                        @foreach ($jobClose as $joblists)
                        <div class="col-xxl-6 joblist-card ">
                            <div id="job-list">
                                <div class="card joblist-card">
                                    <div class="card-body">
                                        <div class="d-flex mb-4">
                                            <div class="avatar-sm">
                                                <div class="avatar-title bg-light rounded">
                                                    <img src="{{$joblists['img2']}}" alt="" class="avatar-xxs companyLogo-img" />
                                                </div>
                                            </div>
                                            <div class="ms-3 flex-grow-1">
                                                <img src="" alt="" class="d-none cover-img" />
                                                <a href="#!" class="viewjob-list" data-bs-toggle="modal" data-bs-target="#OverView" data-job-details="{{$joblists['jobTitle']}}|{{$joblists['DeptName']}}|{{$joblists['experience']}}|{{$joblists['no_of_vac']}}|{{$joblists['location']}}|{{$joblists['salary']}}|{{$joblists['skills']}}|{{$joblists['img1']}}|{{$joblists['img2']}}|{{$joblists['remarks']}}|{{$joblists['grpDis']}}|{{$joblists['aptitude']}}|{{$joblists['techical']}}|{{$joblists['persInter']}}|{{$joblists['hrName']}}|{{$joblists['techIntName']}}|{{$joblists['techfinalName']}}|{{$joblists['finalIntName']}}|{{$joblists['CompName']}}|{{$joblists['intCompName']}}|{{$joblists['intDeptName']}}|{{$joblists['mainCompName']}}|{{$joblists['Edate']}}">
                                                    <h5 class="job-title">{{$joblists['jobTitle']}} </h5>
                                                </a>
                                                <p class="company-name text-muted mb-0">
                                                    {{$joblists['mainCompName']}}
                                                </p>
                                            </div>
                                            <div>
                                                <button type="button" class="btn btn-ghost-primary btn-icon custom-toggle" data-bs-toggle="button">
                                                    <span class="icon-on"><i class="ri-bookmark-line"></i></span>
                                                    <span class="icon-off"><i class="ri-bookmark-fill"></i></span>
                                                </button>
                                            </div>
                                        </div>
                                        <p class="text-muted job-description">
                                            {{$joblists['remarks']}}
                                        </p>
                                        <div>Skill : {{$joblists['skills']}}</div>
                                    </div>
                                    <div class="card-footer border-top-dashed">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                            <div>
                                                <i class="ri-briefcase-2-line align-bottom me-1"></i>
                                                <span class="job-type"> {{$joblists['DeptName']}}</span>
                                            </div>
                                            <div class="d-none">
                                                <span class="job-experience">2</span>
                                            </div>
                                            <div>
                                                <i class="ri-map-pin-2-line align-bottom me-1"></i>
                                                <span class="job-location">{{$joblists['location']}}</span>
                                            </div>
                                            <div>
                                                <i class="ri-user-3-line align-bottom me-1"></i> {{$joblists['no_of_vac']}}

                                            </div>
                                            <div>
                                                <i class="ri-time-line align-bottom me-1"></i>
                                                <span class="job-postdate">{{ \Carbon\Carbon::parse($joblists['Edate'])->format('d-M-Y') }}</span>
                                            </div>
                                            <div>

                                                <button type="button" class="btn btn-danger closeBtn" data-bs-toggle="modal" data-bs-target="#ConformModal" data-job-details="{{$joblists['Rowid']}}">
                                                    Close
                                                    <i class="ri-close-circle-line"></i>
                                                </button>


                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->
                        </div>
                        @endforeach
                        @endif
                        <!--  ========================== job close end ====================== -->

                        <div class="row g-0 justify-content-end mb-4" id="pagination-element">
                            <!-- end col -->
                            <div class="col-sm-6">
                                <div class="pagination-block pagination pagination-separated justify-content-center justify-content-sm-end mb-sm-0">
                                    <div class="page-item">
                                        <a href="javascript:void(0);" class="page-link" id="page-prev">Previous</a>
                                    </div>
                                    <span id="page-num" class="pagination"></span>
                                    <div class="page-item">
                                        <a href="javascript:void(0);" class="page-link" id="page-next">Next</a>
                                    </div>
                                </div>
                            </div>
                            <!-- end col -->
                        </div>
                        <!--end col-->

                    </div>
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->


            <!--end add modal-->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear());
                            </script>
                            © Gainup Industries.
                        </div>
                        <!-- <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">
                                Design & Develop by Themesbrand
                            </div>
                        </div> -->
                    </div>
                </div>
            </footer>

        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- =================================== modal ================================ -->

    <!-- ================= overview Modal ================== -->
    <div class="modal fade" id="OverView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0">
                <form id="createjob-form" autocomplete="off" class="needs-validation" novalidate>
                    <div class="modal-body">
                        <input type="hidden" id="id-field" />
                        <div class="row g-3">
                            <div class="col-lg-12">
                                <div class="px-1 pt-1">
                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                        <img src="" alt="" id="modal-cover-img" class="img-fluid" />

                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                            <div class="flex-grow-1">
                                                <h5 class="modal-title text-white">

                                                </h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-3 align-items-center">

                                                    <button type="button" class="btn-close btn-close-white" id="close-jobListModal" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="text-center mb-4 mt-n5 pt-2">
                                    <div class="position-relative d-inline-block">

                                        <div class="avatar-lg p-1">
                                            <div class="avatar-title bg-light rounded-circle">
                                                <img src="" id="companylogo-img" class="avatar-md rounded-circle object-fit-cover" />
                                            </div>
                                        </div>
                                    </div>
                                    <h5 class="fs-13 mt-3" id="exampleModalLabel">

                                    </h5>
                                </div>

                            </div>

                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>

                                                    <p class="mt-3">Job Description</p>
                                                    </p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-remarks">Lorem ipsum dolor sit amet consectetur adipisicing elit. Obcaecati error nam ipsa beatae. Tenetur voluptas labore perspiciatis dolorem! Sed repellat et quia fugiat perferendis quisquam quod veniam porro tempora adipisci?</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-company"></span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Department">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Experience</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Experience">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">No of vacancy</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Vacancy">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Location</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Location">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Salary</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Salary">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Skills</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-Skills">-</span></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="divider"></div>

                                    <h5 class="mt-3 text-center ">Interviewer Details</h5>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Company</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-int-company">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Department</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-int-Department">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">HR Name</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-hrName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Interviewer</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-techIntName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Technical Final</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-techIntFinalName">-</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="mt-3">Final Interviewer</p>
                                                </td>
                                                <td>:</td>
                                                <td><span class="text-body-secondary " id="job-finalIntName">-</span></td>
                                            </tr>
                                            <!-- <tr>
                                                <td>
                                                    <p class="mt-3">Share this job</p>
                                                </td>
                                                <td>:</td>
                                                <td><a href="#!" class="btn btn-icon btn-soft-info"><i class="ri-facebook-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-success"><i class="ri-whatsapp-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-secondary"><i class="ri-twitter-line"></i></a> <a href="#!" class="btn btn-icon btn-soft-danger"><i class="ri-mail-line"></i></a></td>
                                            </tr> -->
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>




                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                Close
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal HTML -->
    <div id="ConformModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="ConformModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ConformModalLabel">Confirm Close</h5>
                    <button type="button" class="close btnClose bg-light btn" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to Close this job?
                </div>
                <div class="modal-footer">
                    <form action="JobCloseSave" method="post">
                        @csrf
                        <input type="hidden" name="rowid" id="Closerowid">
                        <button type="button" class="btn btn-secondary btnClose" data-bs-dismiss="modal">Cancel</button>

                        <button type="submit" class="btn btn-success" id="confirmDeleteBtn">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- apexcharts -->
    <script src="Applicant/assets/libs/apexcharts/apexcharts.min.js"></script>

    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/job-list.init.js"></script>

    <!-- App js -->
    <script src="Applicant/assets/js/app.js"></script>

    <script>
        $(document).ready(function() {
            $('.viewjob-list').on('click', function() {
                // Get the company name from the data attribute
                var jobDetails = $(this).data('job-details');
                console.log(jobDetails);
                var dataArray = jobDetails.split("|");

                // Access individual values
                var jobTitle = dataArray[0];
                var deptName = dataArray[1];
                var experience = dataArray[2];
                var no_of_vac = dataArray[3];
                var location = dataArray[4];
                var salary = dataArray[5];
                var skills = dataArray[6];
                var img1 = dataArray[7];
                var img2 = dataArray[8];
                var remarks = dataArray[9];
                var grpDis = dataArray[10];
                var aptitude = dataArray[11];
                var techical = dataArray[12];
                var persInter = dataArray[13];
                var hrName = dataArray[14];
                var techIntName = dataArray[15];
                var techfinalName = dataArray[16];
                var finalIntName = dataArray[17];
                var compName = dataArray[18];
                var intCompName = dataArray[19];
                var intDeptName = dataArray[20];
                // var mainCompName = dataArray[20];
                // var location = dataArray[2];
                $('#exampleModalLabel').text(jobTitle);
                $('#job-Department').text(deptName);
                $('#job-Experience').text(experience);
                $('#job-Vacancy').text(no_of_vac);
                $('#job-Location').text(location);
                $('#job-Salary').text(salary);
                $('#job-Skills').text(skills);
                $('#modal-cover-img').attr('src', img1);
                $('#companylogo-img').attr('src', img2);
                $('#job-remarks').text(remarks);
                // $('#exampleModalLabel').text(grpDis);
                // $('#exampleModalLabel').text(aptitude);
                // $('#exampleModalLabel').text(persInter);
                $('#job-hrName').text(hrName);
                $('#job-techIntName').text(techIntName);
                $('#job-techIntFinalName').text(techfinalName);
                $('#job-finalIntName').text(finalIntName);
                $('#job-int-company').text(intCompName);
                $('#job-int-Department').text(intDeptName);
                $('#job-company').text(compName);
            });
        });
    </script>

    <script>
        $(document).ready(function() {

            $('.closeBtn').on('click', function() {
                var jobCloseId = $(this).data('job-details');
                $("#Closerowid").val(jobCloseId);
            });
        });
    </script>

    <!-- Add a script section to handle the search functionality -->

    <script>

        // Assuming you are using jQuery
        $(document).ready(function() {
            // Initialize the total job count
            var totalJobsCount = $('.joblist-card').length;

            $('#searchJob').on('input', function() {
                var searchQuery = $(this).val().toLowerCase();

                // Hide all jobs initially
                $('.joblist-card').hide();

                // Initialize the count of visible jobs
                var visibleJobsCount = 0;

                // Loop through each job and check if it matches the search query
                $('.joblist-card').each(function() {
                    var jobTitle = $(this).find('.job-title').text().toLowerCase();
                    var companyName = $(this).find('.company-name').text().toLowerCase();
                    var skills = $(this).find('.job-description').text().toLowerCase();

                    if (jobTitle.includes(searchQuery) || companyName.includes(searchQuery) || skills.includes(searchQuery)) {
                        $(this).show();
                        visibleJobsCount++;
                    }
                });
                visibleJobsCount = visibleJobsCount / 2;

                // Show the alert with the correct total number of results
                $('#total-result').text(visibleJobsCount);
                $('#found-job-alert').removeClass('d-none');
            });
        });
    </script>

    <!-- End script section -->

    @endsection
</body>

</html>