<!doctype html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>JOB</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css -->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css -->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        @extends('Applicant.navbar')
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <!-- <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">New Job</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Jobs</a></li>
                                        <li class="breadcrumb-item active">New Job</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div> -->
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <form action="jobSave" class="needs-validation" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="px-1 pt-1">
                                                    <div class="modal-team-cover position-relative mb-0 mt-n4 mx-n4 rounded-top overflow-hidden">
                                                        <img src="Applicant/assets/images/small/img-9.jpg" alt="" id="modal-cover-img" class="img-fluid" />

                                                        <div class="d-flex position-absolute start-0 end-0 top-0 p-3">
                                                            <div class="flex-grow-1">
                                                                <h5 class="modal-title text-white" id="exampleModalLabel">
                                                                    Create New Job
                                                                </h5>
                                                            </div>
                                                            <div class="flex-shrink-0">
                                                                <div class="d-flex gap-3 align-items-center">
                                                                    <div>
                                                                        <label for="cover-image-input" class="mb-0" data-bs-toggle="tooltip" data-bs-placement="top" title="Select Cover Image">
                                                                            <div class="avatar-xs">
                                                                                <div class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                                                    <i class="ri-image-fill"></i>
                                                                                </div>
                                                                            </div>
                                                                        </label>
                                                                        <input class="form-control d-none" name="img1" id="cover-image-input" type="file" accept="image/png, image/gif, image/jpeg" />
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="text-center mb-4 mt-n5 pt-2">
                                                    <div class="position-relative d-inline-block">
                                                        <div class="position-absolute bottom-0 end-0">
                                                            <label for="companylogo-image-input" class="mb-0" data-bs-toggle="tooltip" data-bs-placement="right" title="Select Image">
                                                                <div class="avatar-xs cursor-pointer">
                                                                    <div class="avatar-title bg-light border rounded-circle text-muted">
                                                                        <i class="ri-image-fill"></i>
                                                                    </div>
                                                                </div>
                                                            </label>
                                                            <input class="form-control d-none" name="img2" id="companylogo-image-input" type="file" accept="image/png, image/gif, image/jpeg" />
                                                        </div>
                                                        <div class="avatar-lg p-1">
                                                            <div class="avatar-title bg-light rounded-circle">
                                                                <img src="Applicant/assets/images/users/multi-user.jpg" id="companylogo-img" class="avatar-md rounded-circle object-fit-cover" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h5 class="fs-13 mt-3">
                                                        Logo
                                                    </h5>
                                                </div>

                                            </div>
                                        </div>

                                    </div>


                                    @if ($message = Session::get('SuccessMsg'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Job</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif

                                    @if ($message = Session::get('errorMsg'))
                                    <!-- Danger Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Job</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif



                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="job-title-Input" class="form-label">Job Title <span class="text-danger">*</span></label>
                                                    <input type="text" name="jobTitle" class="form-control" id="job-title-Input" placeholder="Enter job title" required />
                                                    <div class="invalid-feedback">
                                                        Please enter a job title.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <div>
                                                    <label for="job-category-Input" class="form-label">Company<span class="text-danger">*</span></label>
                                                    <select class="form-control " data-choices name="company" required id="JobCompName">
                                                        <option value="">Select company</option>
                                                        @foreach ($compName as $company)
                                                        <option value="{{$company['Compcode']}}">{{$company['CompName']}}</option>
                                                        @endforeach
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please enter a job title.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <div>
                                                    <label for="job-type-Input" class="form-label">Department <span class="text-danger">*</span></label>
                                                    <select class="form-control" data-choices name="department" id="jobDeptName" required>
                                                        <option value="">Select Department</option>
                                                        @foreach ($deptName as $department)
                                                        <option value="{{$department['code']}}">{{$department['name']}}</option>
                                                        @endforeach
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please enter a job title.
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- <div class="col-md-6">
                                                <div>
                                                    <label for="city-Input" class="form-label">Experience <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="city-Input" placeholder="Enter city" required />
                                                </div>
                                            </div> -->
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="experience-Input" class="form-label">Experience <span class="text-danger">*</span></label>
                                                    <input type="text" name="experience" class="form-control" id="" placeholder="Enter Experience" oninput="validateExperienceInput(this)" required />


                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div>
                                                    <label for="vancancy-Input" class="form-label">No. of Vacancy <span class="text-danger">*</span></label>
                                                    <input type="number" name="vacancy" class="form-control" id="vancancy-Input" value="{{$vacancy}}" placeholder="No. of vacancy" required />
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div>
                                                    <label for="vancancy-Input" class="form-label">Location <span class="text-danger">*</span></label>
                                                    <input type="text" name="location" class="form-control" id="vancancy-Input" placeholder=" Enter Locattion" required />
                                                </div>
                                            </div>

                                            <!-- <div class="col-lg-6">
                                                <div>
                                                    <label for="last-apply-date-Input" class="form-label"> <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="last-apply-date-Input" data-provider="flatpickr" data-date-format="d M, Y" placeholder="Select date" required />
                                                </div>
                                            </div> -->

                                            <!-- <div class="col-lg-6">
                                                <div>
                                                    <label for="close-date-Input" class="form-label">Close Date <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="close-date-Input" data-provider="flatpickr" data-date-format="d M, Y" placeholder="Select date" required />
                                                </div>
                                            </div> -->

                                            <div class="col-md-6">
                                                <div>
                                                    <label for="start-salary-Input" class="form-label">Salary</label>
                                                    <input type="number" name="salary" class="form-control" id="start-salary-Input" placeholder="Enter start salary" />
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div>
                                                    <label for="website-field" class="form-label">Skills <span class="text-danger">*</span></label>
                                                    <input class="form-control" name="skills" id="choices-text-unique-values" data-choices data-choices-text-unique-true type="text" value="" required />
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div>
                                                    <label for="start-date-Input" class="form-label">Start Date</label>
                                                    <input type="date" name="startDate" class="form-control" id="start-date-Input" placeholder="" required value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}" />
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="end-date-Input" class="form-label">Final Date</label>
                                                    <input type="date" name="finalDate" class="form-control" id="end-date-Input" placeholder="" required value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}" />
                                                </div>
                                            </div>
                                            <!-- 
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="last-salary-Input" class="form-label">Last Salary</label>
                                                    <input type="number" class="form-control" id="last-salary-Input" placeholder="Enter end salary" required />
                                                </div>
                                            </div> -->

                                            <!-- <div class="col-md-6">
                                                <div>
                                                    <label for="country-Input" class="form-label">Company <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="country-Input" placeholder="Enter country" required />
                                                </div>
                                            </div> -->

                                            <div class="col-lg-12">
                                                <div>
                                                    <label for="description-field" class="form-label">Description<span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="remarks" id="description-field" rows="3" placeholder="Enter description" required></textarea>
                                                </div>
                                            </div>

                                            <!-- ^^^^^^^^^^^^^^^^^^^^^^^^  interviewer Details ^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->

                                            <div class="row mt-3">
                                                <div class="col-lg-12">
                                                    <h3>Interviewer Details</h3>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="company-Input" class="form-label">Company <span class="text-danger">*</span></label>
                                                    <!-- <select class="form-control" data-choices name="intCompany">
                                                        <option value="">Select Company</option>
                                                        @foreach ($compName as $company)
                                                        <option value="{{$company['Compcode']}}">{{$company['CompName']}}</option>
                                                        @endforeach

                                                    </select> -->

                                                    <input type="text" name="" id="IntCompName" readonly class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="department-Input" class="form-label">Deaprtment <span class="text-danger">*</span></label>

                                                    <input type="text" name="" id="intDeptName" class="form-control" readonly>
                                                </div>
                                            </div>

                                            <!-- <div class="col-md-6">
                                                <div>
                                                    <label for="country-Input" class="form-label">Designation <span class="text-danger">*</span></label>
                                                    <input type="text" name="intDesignation" class="form-control" id="country-Input" placeholder="Enter Designation" required />
                                                </div>
                                            </div> -->

                                            <div class="col-md-6">
                                                <div>
                                                    <label for="country-Input" class="form-label">HR Round <span class="text-danger">*</span></label>
                                                    <div class="d-flex ">
                                                        <div class="d-flex col-lg-3 me-2">
                                                            <div class="form-check mt-2 me-3">
                                                                <input class="form-check-input" type="radio" name="HRRound" id="HRRound1" checked value="1">
                                                                <label class="form-check-label" for="HRRound1">
                                                                    Yes
                                                                </label>
                                                            </div>

                                                            <div class="form-check mt-2">
                                                                <input class="form-check-input" type="radio" name="HRRound" id="HRRound2" value="0">
                                                                <label class="form-check-label" for="HRRound2">
                                                                    No
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <div class="ms-4 col-lg-8" id="hrDiv">
                                                            <select class="form-control" data-choices name="HrEmplno">
                                                                <option value="">Select HR</option>
                                                                @foreach ($hrName as $hrNames)
                                                                <option value="{{$hrNames['Emplno']}}">{{$hrNames['Name']}}/{{$hrNames['tno']}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div>
                                                    <label for="country-Input" class="form-label">Technical <span class="text-danger">*</span></label>
                                                    <div class="d-md-flex">

                                                        <div class="d-md-flex col-lg-8">
                                                            <!-- Custom Outline Checkboxes -->
                                                            <div class="form-check form-check-outline form-check-primary me-2 mt-2">
                                                                <input class="form-check-input" type="checkbox" id="formCheck13" name="groupDis" value="1">
                                                                <label class="form-check-label" for="formCheck13">
                                                                    Group Discussion
                                                                </label>
                                                            </div>
                                                            <div class="form-check form-check-outline form-check-secondary me-2 mt-2">
                                                                <input class="form-check-input" type="checkbox" id="formCheck14" name="aptitude" value="1">
                                                                <label class="form-check-label" for="formCheck14">
                                                                    Aptitude
                                                                </label>
                                                            </div>
                                                            <div class="form-check form-check-outline form-check-success me-2 mt-2">
                                                                <input class="form-check-input" type="checkbox" id="formCheck15" name="technical" value="1">
                                                                <label class="form-check-label" for="formCheck15">
                                                                    Technical
                                                                </label>
                                                            </div>
                                                            <div class="form-check form-check-outline form-check-warning me-2 mt-2">
                                                                <input class="form-check-input" type="checkbox" id="formCheck16" name="personalInt" value="1">
                                                                <label class="form-check-label" for="formCheck16">
                                                                    Personal Interview
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <select class="form-control" data-choices name="techintName">
                                                                <option value="">Select Interviewer</option>
                                                                @foreach ($intName as $intNames)
                                                                <option value="{{$intNames['Emplno']}}">{{$intNames['Name']}}/{{$intNames['tno']}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="country-Input" class="form-label">Technical Final <span class="text-danger">*</span></label>
                                                    <div class="d-flex ">
                                                        <div class="d-flex col-lg-3 me-2">
                                                            <div class="form-check mt-2 me-3">
                                                                <input class="form-check-input" type="radio" name="technicalFinal" value="1" id="technicalFinal1" checked>
                                                                <label class="form-check-label" for="technicalFinal1">
                                                                    Yes
                                                                </label>
                                                            </div>

                                                            <div class="form-check mt-2">
                                                                <input class="form-check-input" type="radio" name="technicalFinal" value="0" id="technicalFinal2">
                                                                <label class="form-check-label" for="technicalFinal2">
                                                                    No
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <div class="ms-4 col-lg-8">
                                                            <select class="form-control" data-choices name="TechfinalIntName" id="TechfinalIntName">
                                                                <option value="">Select Interviewer</option>
                                                                @foreach ($intName as $intNames)
                                                                <option value="{{$intNames['Emplno']}}">{{$intNames['Name']}}/{{$intNames['tno']}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="country-Input" class="form-label">Final Interviewer Name <span class="text-danger">*</span></label>
                                                    <div class="d-flex ">
                                                        <!-- <div class="d-flex col-lg-3 me-2">
                                                            <div class="form-check mt-2 me-3">
                                                                <input class="form-check-input" value="1" type="radio" name="final" id="final1" checked>
                                                                <label class="form-check-label" for="final1">
                                                                    Yes
                                                                </label>
                                                            </div>

                                                            <div class="form-check mt-2">
                                                                <input class="form-check-input" value="0" type="radio" name="final" id="final2">
                                                                <label class="form-check-label" for="final2">
                                                                    No
                                                                </label>
                                                            </div>
                                                        </div> -->
                                                        <div class="ms-4 col-lg-8">
                                                            <input type="text" class="form-control" id="country-Input" value="DWARAKANATHAN S" name="" required readonly />
                                                            <input type="hidden" class="form-control" id="country-Input" value="5545" name="finalIntName" required />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="hstack justify-content-end gap-2">

                                                    <button type="submit" class="btn btn-primary">Add Job</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © Gainup Industries .
                        </div>

                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->
    </div>

    <!-- END layout-wrapper -->

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- form wizard init -->
    <script src="Applicant/assets/js/pages/form-wizard.init.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/js/app.js"></script>


    <!-- FOR EXPERIENCE CONDITION -->
    <script>
        // function validateExperienceInput(input) {
        //     input.value = input.value.replace(/[^0-30-]/g, '');
        // }
        function validateExperienceInput(input) {
            const value = input.value;
            const valid = value.match(/^(\d{0,2})(-)?(\d{0,2})$/);
            if (!valid) {
                input.value = value.slice(0, -1); // remove last character if invalid
            }
        }
    </script>

    <!--  hide the hr and techIntName name  -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Function to toggle the display of the Technical Final interviewer select box
            function toggleTechFinalSelect(display) {
                const techFinalSelectBox = document.querySelector('#TechfinalIntName').closest('.col-lg-8');
                techFinalSelectBox.style.display = display ? 'block' : 'none';
            }

            // Listen to changes on Technical Final radio buttons
            const techFinalRadios = document.querySelectorAll('input[name="technicalFinal"]');
            techFinalRadios.forEach(radio => {
                radio.addEventListener('change', function() {
                    toggleTechFinalSelect(this.value !== '0');
                });
            });

            // Function to toggle the display of the HR Round select box
            function toggleHrRoundSelect(display) {
                const hrRoundSelectBox = document.querySelector('#hrDiv');
                hrRoundSelectBox.style.display = display ? 'block' : 'none';
            }

            // Listen to changes on HR Round radio buttons
            const hrRoundRadios = document.querySelectorAll('input[name="HRRound"]');
            hrRoundRadios.forEach(radio => {
                radio.addEventListener('change', function() {
                    toggleHrRoundSelect(this.value !== '0');
                });
            });

            // Initial checks in case the page is reloaded with a selection made
            const selectedTechFinalRadio = document.querySelector('input[name="technicalFinal"]:checked');
            toggleTechFinalSelect(selectedTechFinalRadio.value !== '0');

            const selectedHrRoundRadio = document.querySelector('input[name="HRRound"]:checked');
            toggleHrRoundSelect(selectedHrRoundRadio.value !== '0');
        });
    </script>

    <!-- ============================= int Comp Name  ========================= -->
    <script>
        // ========== int Company  name 
        document.querySelector("#JobCompName").addEventListener("change", function() {

            let textContent = this.innerText;

            document.querySelector("#IntCompName").value = textContent;

        });
        // ============= int deptName
        document.querySelector("#jobDeptName").addEventListener("change", function() {

            let textContent = this.innerText;

            document.querySelector("#intDeptName").value = textContent;

        });
    </script>


    <!-- image -->
    <script>
        document.querySelector("#cover-image-input").addEventListener("change", function() {
            var e = document.querySelector("#modal-cover-img"),
                t = document.querySelector("#cover-image-input").files[0],
                n = new FileReader();
            n.addEventListener("load", function() {
                        e.src = n.result;
                    },
                    !1
                ),
                t && n.readAsDataURL(t);
        });

        document.querySelector("#companylogo-image-input").addEventListener("change", function() {
            var e = document.querySelector("#companylogo-img"),
                t = document.querySelector("#companylogo-image-input").files[0],
                n = new FileReader();
            n.addEventListener("load", function() {
                        console.log(n);
                        e.src = n.result;
                    },
                    !1
                ),
                t && n.readAsDataURL(t);
        });
    </script>





    @endsection
</body>



</html>