<!doctype html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>EVALUATION</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css -->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css -->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        @extends('Applicant.navbar')
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <form action="EvalSave" class="was-validated" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-xxl-3">
                                                <h5 class="">Evaluation Entry</h5>
                                            </div>
                                        </div>

                                    </div>
                                    @if ($message = Session::get('savedMsg'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Evaluation</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif

                                    @if ($message = Session::get('errorMsg'))

                                    <!-- Danger Alert -->

                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Evaluation</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>

                                    @endif
                                    <div class="card-body">
                                        <div class="row ">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="job-title-Input" class="form-label">Eno <span class="text-danger">*</span></label>
                                                    <input type="text" name="ENO" class="form-control" id="job-title-Input" value="{{$eNO}}" readonly placeholder="Enter Evaluation points" required />
                                                    <div class="invalid-feedback">
                                                        Please enter a Eno.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="job-type-Input" class="form-label">Department <span class="text-danger">*</span></label>
                                                <select class="form-select deptSelect" name="department" required data-choices="">
                                                    <option value="">Select Department</option>
                                                    @foreach ($deptName as $department)
                                                    <option value="{{$department['code']}}">{{$department['name']}}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">
                                                    Please select a department.
                                                </div>
                                            </div>

                                            <div class=" row mt-2 ">
                                                <div class="col-lg-4 mb-2">
                                                    Evaluation Points
                                                </div>
                                                <div class="col-lg-4 mb-2">
                                                    Remarks
                                                </div>
                                            </div>

                                            <div class="row" id="newRow">

                                            </div>

                                        </div>

                                        <div class="col-lg-12">
                                            <div class="hstack justify-content-between gap-2">
                                                <button onclick="addRow()" type="button" class="btn btn-ghost-danger material-shadow-none"><i class="ri-add-box-line"></i> Add</button>

                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                            </div>

                            </form>
                        </div>
                    </div>

                </div>
                <!-- minimum one row limit -->
                <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                                <button type="button" class="btn-close btn-close-dark" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                At least one row is required. You cannot delete the last row.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container-fluid -->
        </div>

        <!-- End Page-content -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-6">
                        <script>
                            document.write(new Date().getFullYear())
                        </script> © Gainup Industries .
                    </div>

                </div>
            </div>
        </footer>
    </div>
    <!-- end main content-->
    </div>

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->
    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- form wizard init -->
    <script src="Applicant/assets/js/pages/form-wizard.init.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            $('select.form-control').on('show.bs.select', function() {
                var windowHeight = $(window).height();
                var selectBottom = $(this).offset().top + $(this).outerHeight();
                var dropdownMenuHeight = $('.dropdown-menu').outerHeight();

                if (selectBottom + dropdownMenuHeight > windowHeight) {
                    $(this).closest('.col-xxl-6').addClass('dropup');
                }
            });
        });
    </script>
    <script>
        // Initialize row count
        var rowCount = 1;
        var selectedOptions = []; // Array to store selected options

        function addRow() {
            var container = document.getElementById('newRow');
            var newRow = document.createElement('div');
            newRow.classList.add('row', 'mt-3');
            newRow.innerHTML = `
        <div class="col-lg-4 mb-3">
            <div class="form-group">
                <select name="evalPoints[]" class="form-control" data-choices="" onchange="removeSelectedOption(this)">
                    <option value="">--select--</option>
                    @foreach ($evalPoints as $evalPoint)
                        <option value="{{ $evalPoint['rowid'] }} | {{ $evalPoint['remarks'] }}" ${selectedOptions.includes('{{ $evalPoint['rowid'] }}') ? 'disabled' : ''}>{{ $evalPoint['evalName'] }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-lg-6 mb-3">
            <div class="form-group">
                <textarea name="remarks[]" cols="20" rows="2" class="form-control" onchange="enableOption(this)"></textarea>
            </div>
        </div>
        <div class="col-lg-2 mb-3">
            <div class="form-group">
                <button onclick="deleteRow(event, this)" class="delete-btn btn btn-danger ms-4"><i class="ri-delete-bin-line"></i></button>
            </div>
        </div>
    `;
            container.appendChild(newRow);
            initializeChoices(newRow.querySelector('[data-choices]'));

            // Add event listener to select element
            var selectElement = newRow.querySelector('select[name="evalPoints[]"]');
            selectElement.addEventListener('change', function() {
                updateDescription(this);
            });

            rowCount++;
        }

        function updateDescription(selectElement) {
            var selectedOption = selectElement.options[selectElement.selectedIndex];
            // Check if the selectedOption exists and has the data-description attribute
            if (selectedOption && selectedOption.value) {
                var description = selectedOption.value.split(' | ')[1]; // Extract the remarks
                var textarea = selectElement.closest('.row').querySelector('textarea');
                textarea.value = description;
                removeSelectedOption(selectElement); // Disable the option
            } else {
                // If the selected option does not have data-description, clear the textarea
                var textarea = selectElement.closest('.row').querySelector('textarea');
                textarea.value = 'no data';
            }
        }

        function deleteRow(event, button) {
            var row = button.closest('.row');
            var parentContainer = row.parentNode;
            // Check if there's only one row left
            if (parentContainer.children.length > 1) {
                // Remove the row
                parentContainer.removeChild(row);
                // Decrement row count
                rowCount--;
            } else {
                event.preventDefault();
                $('#minimumRowModal').modal('show');
            }
        }

        function initializeChoices(element) {
            var choices = new Choices(element, {
                removeItemButton: true,
            });
        }

        function removeSelectedOption(selectElement) {
            var selectedValue = selectElement.value.split(' | ')[0]; // Extract the rowid
            selectedOptions.push(selectedValue);
            var allSelects = document.querySelectorAll('select[name="evalPoints[]"]');
            allSelects.forEach(function(select) {
                var options = select.options;
                for (var i = 0; i < options.length; i++) {
                    if (options[i].value.split(' | ')[0] === selectedValue) {
                        options[i].style.display = 'none'; // Hide the option
                    }
                }
            });
        }

        function enableOption(textarea) {
            var row = textarea.closest('.row');
            var select = row.querySelector('select[name="evalPoints[]"]');
            var selectedValue = select.value.split(' | ')[0]; // Extract the rowid
            var allSelects = document.querySelectorAll('select[name="evalPoints[]"]');
            allSelects.forEach(function(select) {
                var options = select.options;
                for (var i = 0; i < options.length; i++) {
                    if (options[i].value.split(' | ')[0] === selectedValue) {
                        options[i].disabled = false; // Enable the option
                    }
                }
            });
        }

        initializeChoices(document.querySelector('[data-choices]'));
        addRow();
    </script>




    @endsection
</body>



</html>