<!doctype html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>EVALUATION</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />
    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css -->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css -->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
   <!-- for star rating -->
   <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        @extends('Applicant.navbar')
        @section('content')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">



                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <form action="evalMasSave" class="was-validated" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-xxl-3">
                                                <h5 class="">Evaluation Master</h5>
                                            </div>
                                        </div>

                                    </div>


                                    @if ($message = Session::get('savedMsg'))
                                    <!-- Primary Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Evaluation</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif

                                    @if ($message = Session::get('errorMsg'))
                                    <!-- Danger Alert -->
                                    <div class="alert alert-primary alert-dismissible w-50 bg-danger text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                                        <i class="ri-user-smile-line label-icon"></i><strong>Evaluation</strong> {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif



                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="job-title-Input" class="form-label">Evaluation Points <span class="text-danger">*</span></label>
                                                    <input type="text" name="evalPoints" class="form-control" id="job-title-Input" placeholder="Enter Evaluation points" required />
                                                    <div class="invalid-feedback">
                                                        Please enter a Evaluation Points.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <!-- <div>
                                                    <label for="job-category-Input" class="form-label">Company<span class="text-danger">*</span></label>
                                                    <select class="form-control " data-choices name="company" required>
                                                        <option value="">Select company</option>

                                                        <option value=""></option>

                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please enter a job title.
                                                    </div>
                                                </div> -->
                                            </div>

                                            <div class="col-lg-12">
                                                <div>
                                                    <label for="job-category-Input" class="form-label">Remarks<span class="text-danger">*</span></label>
                                                    <textarea name="remarks" id="" cols="30" rows="5" class="form-control"></textarea>
                                                    <div class="invalid-feedback">
                                                        Please enter a Remarks.
                                                    </div>
                                                </div>
                                            </div>




                                            <div class="col-lg-12">
                                                <div class="hstack justify-content-end gap-2">

                                                    <button type="submit" class="btn btn-primary">Add Points</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © Gainup Industries .
                        </div>

                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->
    </div>

    <!-- END layout-wrapper -->

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- form wizard init -->
    <script src="Applicant/assets/js/pages/form-wizard.init.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <!-- App js -->
    <script src="Applicant/assets/js/jquery-3.6.0.min.js"></script>
    <script src="Applicant/assets/js/app.js"></script>

    <script>
        document.querySelector("#cover-image-input").addEventListener("change", function() {
            var e = document.querySelector("#modal-cover-img"),
                t = document.querySelector("#cover-image-input").files[0],
                n = new FileReader();
            n.addEventListener("load", function() {
                        e.src = n.result;
                    },
                    !1
                ),
                t && n.readAsDataURL(t);
        });

        document.querySelector("#companylogo-image-input").addEventListener("change", function() {
            var e = document.querySelector("#companylogo-img"),
                t = document.querySelector("#companylogo-image-input").files[0],
                n = new FileReader();
            n.addEventListener("load", function() {
                        console.log(n);
                        e.src = n.result;
                    },
                    !1
                ),
                t && n.readAsDataURL(t);
        });
    </script>



    <!-- <script>
        // Example script for initializing form validation
        (function() {
            'use strict';

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation');

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function(form) {
                    form.addEventListener('submit', function(event) {
                        var isValid = true;

                        // Validate text input fields
                        form.querySelectorAll('input[required]').forEach(function(input) {
                            if (!input.checkValidity()) {
                                isValid = false;
                                input.classList.add('is-invalid');
                            } else {
                                input.classList.remove('is-invalid');
                            }
                        });

                        // Validate select elements
                        form.querySelectorAll('select[required]').forEach(function(select) {
                            if (!select.checkValidity()) {
                                isValid = false;
                                select.classList.add('is-invalid');
                                console.log(select);
                            } else {
                                select.classList.remove('is-invalid');
                            }
                        });

                        if (!isValid) {
                            event.preventDefault();
                            event.stopPropagation();
                        }

                        form.classList.add('was-validated');
                    }, false);
                });
        })();
    </script> -->


    @endsection
</body>



</html>