<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">


<!-- Mirrored from themesbrand.com/velzon/html/master/tables-gridjs.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 02 Jan 2024 09:49:16 GMT -->

<head>

    <meta charset="utf-8" />
    <title>EVALUATION</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="Applicant/assets/images/logo.webp" />

    <!-- gridjs css -->
    <link rel="stylesheet" href="Applicant/assets/libs/gridjs/theme/mermaid.min.css">

    <!-- Layout config Js -->
    <script src="Applicant/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
   <!-- for star rating -->
   <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">
        @extends('Applicant.navbar')
        @section('content')

        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Evaluation Report</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Evaluation Report</a></li>

                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!-- <div class="card-header">
                                    <h4 class="card-title mb-0 flex-grow-1">Evaluation Report</h4>
                                </div> -->

                                <!-- end card header -->

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-8"></div>
                                        <div class="col-lg-4">
                                            <select name="" id="deptName" class="form-control" data-choices="">
                                                <option value="">--select--</option>
                                                @foreach ($deptName as $department)
                                                <option value="{{$department['DeptCode']}}" @if($department['DeptName']=='HR' ) selected @endif>{{$department['DeptName']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div id="table-gridjs"></div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>

            </div>
            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © Gainup Industries.
                        </div>

                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->


    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>



    <!-- JAVASCRIPT -->
    <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
    <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
    <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="Applicant/assets/js/plugins.js"></script>

    <!-- prismjs plugin -->
    <script src="Applicant/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="Applicant/assets/js/pages/flatpickr.js"></script>
    <script src="Applicant/assets/js/pages/choice.min.js"></script>
    <script src="Applicant/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <!-- App js -->
    <script src="Applicant/assets/js/app.js"></script>
    <script src="Applicant/assets/js/jquery-3.6.0.min.js"></script>
</body>

<script>
    $(document).ready(function() {
        // Function to load data based on department selection
        function loadData(deptId) {
            $.ajax({
                url: '{{ route("EvalReportTable") }}',
                type: 'GET',
                data: {
                    deptId: deptId
                },
                success: function(response) {
                    console.log(response);

                    const gridData = [];
                    response.forEach((item, index) => {
                        gridData.push([
                            index + 1 || "",
                            item.Eno || "",
                            item.EvalName || "",
                            item.DeptName || "",
                            item.Remarks || "",
                        ]);
                    });

                    // Remove the existing table
                    let existingTable = document.getElementById("table-gridjs");
                    if (existingTable.firstChild) {
                        existingTable.removeChild(existingTable.firstChild);
                    }

                    // Create a new table element
                    let newTable = document.createElement('div');
                    newTable.id = 'gridjs-table';

                    existingTable.appendChild(newTable);

                    new gridjs.Grid({
                        columns: [{
                                name: "ID",
                                width: "80px",
                                formatter: function(e) {
                                    return gridjs.html('<span class="fw-semibold">' + e + "</span>");
                                },
                            },
                            {
                                name: "Eno",
                                width: "150px"
                            },
                            {
                                name: "Evaluation Points",
                                width: "220px",
                                formatter: function(e) {
                                    return gridjs.html('<a href="">' + e + "</a>");
                                },
                            },
                            {
                                name: "Department",
                                width: "250px"
                            },
                            {
                                name: "Remarks",
                                width: "180px"
                            },
                        ],
                        pagination: {
                            limit: 10
                        },
                        sort: true,
                        search: true,
                        data: gridData,
                    }).render(document.getElementById("gridjs-table"));
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }

        // Load data when the document is ready
        loadData($("#deptName").val());

        // Change event handler for deptName select element
        $("#deptName").on('change', function() {
            let deptId = $(this).val();
            // Load data based on the selected department
            loadData(deptId);
        });
    });
</script>


@endsection

</html>