<!DOCTYPE html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
  <meta charset="utf-8" />
  <title>CALENDAR </title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <!-- App favicon -->
  <link rel="shortcut icon" href="Applicant/assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="Applicant/assets/js/layout.js"></script>
  <!-- Bootstrap Css -->
  <link href="Applicant/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="Applicant/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="Applicant/assets/css/app.min.css" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="Applicant/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
   <!-- for star rating -->
   <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

  <style>
    .fc-event {
      cursor: pointer !important;
    }
  </style>
</head>

<body>
  <!-- Begin page -->
  <div id="layout-wrapper">

    @extends('Applicant.navbar')
    @section('content')

    <div class="sidebar-background"></div>
  </div>
  <!-- Left Sidebar End -->
  <!-- Vertical Overlay-->
  <div class="vertical-overlay"></div>

  <!-- ============================================================== -->
  <!-- Start right Content here -->
  <!-- ============================================================== -->
  <?php
  $ATSCalendarViews = Session::get('ATSCalendarViews');
  ?>
  @if ($ATSCalendarViews === "Y")
  <div class="main-content">
    <div class="page-content">
      <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
          <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
              <h4 class="mb-sm-0">Calendar</h4>

              <div class="page-title-right">
                <ol class="breadcrumb m-0">
                  <li class="breadcrumb-item">
                    <a href="javascript: void(0);">Apps</a>
                  </li>
                  <li class="breadcrumb-item active">Calendar</li>
                </ol>
              </div>
            </div>
          </div>
        </div>
        <!-- end page title -->

        <div class="row">
          <div class="col-12">
            <div class="row">
              <div class="col-xl-3 col-sm-12">

                <div id="external-events">

                </div>
              </div>
              <div class="col-xl-9 col-sm-12 d-none">

                <div class="alert   alert-primary alert-dismissible w-50 bg-primary text-white alert-label-icon fade show material-shadow" role="alert" id="alert" style="z-index: 1; margin-left:auto;">
                  <i class="ri-user-smile-line label-icon"></i><strong></strong>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-xl-12">
                <div class="card card-h-100">
                  <div class="card-body">
                    <div id="calendar"></div>
                  </div>
                </div>
              </div>
              <!-- end col -->
            </div>
            <!--end row-->

            <div style="clear: both"></div>

            <!-- Add New Event MODAL -->
            <div class="modal fade" id="event-modal" tabindex="-1">

              <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0">
                  <div class="modal-header p-3 bg-info-subtle">
                    <h5 class="modal-title" id="modal-title">Event</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                  </div>
                  <div class="modal-body p-4">
                    <form class="needs-validation" action="eventSave" method="post" name="event-form" id="form-event" novalidate>
                      @csrf
                      <div class="text-end">
                        <a href="#" class="btn btn-sm btn-soft-primary d-none" id="edit-event-btn" data-id="edit-event" onclick="editEvent(this)" role="button"></a>
                      </div>

                      <div class="event-details">
                        <div class="flex-grow-1" id="intCol">
                          <h6 class="d-block fw-semibold mb-0">
                            <span>Interview Person</span> -
                            <span id="appliName">Sakthi</span>
                          </h6>
                        </div>
                        <br>
                        <div class="d-flex mb-2">
                          <div class="flex-grow-1 d-flex align-items-center">
                            <div class="flex-shrink-0 me-3">
                              <i class="ri-calendar-event-line text-muted fs-16"></i>
                            </div>
                            <div class="flex-grow-1">
                              <h6 class="d-block fw-semibold mb-0" id="event-start-date-tag"></h6>
                            </div>
                          </div>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                          <div class="flex-shrink-0 me-3">
                            <i class="ri-time-line text-muted fs-16"></i>
                          </div>
                          <div class="flex-grow-1">
                            <h6 class="d-block fw-semibold mb-0">
                              <span id="event-timepicker1-tag"></span> -
                              <span id="event-timepicker2-tag"></span>
                            </h6>
                          </div>

                        </div>
                        <div class="d-flex align-items-center mb-2">
                          <div class="flex-shrink-0 me-3">
                            <i class="ri-map-pin-line text-muted fs-16"></i>
                          </div>
                          <div class="flex-grow-1">
                            <h6 class="d-block fw-semibold mb-0">
                              <span id="event-location-tag"></span>
                            </h6>
                          </div>
                        </div>
                        <div class="d-flex mb-3">
                          <div class="flex-shrink-0 me-3">
                            <i class="ri-discuss-line text-muted fs-16"></i>
                          </div>
                          <div class="flex-grow-1">
                            <p class="d-block text-muted mb-0" id="event-description-tag"></p>
                          </div>
                        </div>
                      </div>

                      <div class="row event-form">
                        <div class="col-12">
                          <div class="mb-3">
                            <label class="form-label">Type</label>
                            <select class="form-select d-none" name="category" id="event-category" required>
                              <option value="bg-danger-subtle">
                                Danger
                              </option>
                              <option value="bg-success-subtle">
                                Success
                              </option>
                              <option value="bg-primary-subtle">
                                Primary
                              </option>
                              <option value="bg-info-subtle">Info</option>
                              <option value="bg-dark-subtle">Dark</option>
                              <option value="bg-warning-subtle">
                                Warning
                              </option>
                            </select>
                            <div class="invalid-feedback">
                              Please select a valid event category
                            </div>
                          </div>
                        </div>
                        <!--end col-->
                        <div class="col-12">
                          <div class="mb-3">
                            <label class="form-label">Event Name</label>
                            <input class="form-control d-none" placeholder="Enter event name" type="text" name="title" id="event-title" required value="" />
                            <div class="invalid-feedback">
                              Please provide a valid event name
                            </div>
                          </div>
                        </div>


                        <!--end col-->
                        <div class="col-12">
                          <div class="mb-3">
                            <label>Event Date</label>
                            <div class="input-group d-none">
                              <input type="text" id="event-start-date" name="eventDate" class="form-control flatpickr flatpickr-input" placeholder="Select date" readonly required />
                              <span class="input-group-text"><i class="ri-calendar-event-line"></i></span>
                            </div>
                          </div>
                        </div>
                        <!--end col-->
                        <div class="col-12" id="event-time">
                          <div class="row">
                            <div class="col-6">
                              <div class="mb-3">
                                <label class="form-label">Start Time</label>
                                <div class="input-group d-none">
                                  <input id="timepicker1" type="text" name="eventStartTime" class="form-control flatpickr flatpickr-input" placeholder="Select start time" readonly />
                                  <span class="input-group-text"><i class="ri-time-line"></i></span>
                                </div>
                              </div>
                            </div>
                            <div class="col-6">
                              <div class="mb-3">
                                <label class="form-label">End Time</label>
                                <div class="input-group d-none">
                                  <input id="timepicker2" type="text" class="form-control flatpickr flatpickr-input" placeholder="Select end time" readonly name="eventEndTime" />
                                  <span class="input-group-text"><i class="ri-time-line"></i></span>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <!--end col-->
                        <div class="col-12">
                          <div class="mb-3">
                            <label for="event-location">Location</label>
                            <div>
                              <input type="text" class="form-control d-none" name="event-location" id="event-location" placeholder="Event location" />
                            </div>
                          </div>
                        </div>
                        <!--end col-->
                        <input type="hidden" id="eventid" name="eventid" value="" />
                        <div class="col-12">
                          <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control d-none" name="describ" id="event-description" placeholder="Enter a description" rows="3" spellcheck="false"></textarea>
                          </div>
                        </div>
                        <!--end col-->
                      </div>
                      <!--end row-->
                      <div class="hstack gap-2 justify-content-end">
                        <button type="submit" class="btn btn-soft-danger" id="btn-delete-event">
                          <i class="ri-close-line align-bottom"></i> Delete
                        </button>

                        <button type="button" class="btn btn-soft-info" data-bs-dismiss="modal" aria-hidden="true">
                          <i class="ri-close-line align-bottom"></i> Close
                        </button>
                        <button type="submit" class="btn btn-success" id="btn-save-event">
                          Add Event
                        </button>
                      </div>
                    </form>
                  </div>
                </div>
                <!-- end modal-content-->
              </div>
              <!-- end modal dialog-->
            </div>
            <!-- end modal-->
            <!-- end modal-->
          </div>
        </div>
        <!-- end row-->
      </div>
      <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <footer class="footer">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <script>
              document.write(new Date().getFullYear());
            </script>
            © Gainup Industries.
          </div>
          <div class="col-sm-6">
            <div class="text-sm-end d-none d-sm-block">

            </div>
          </div>
        </div>
      </div>
    </footer>
  </div>
  @endif
  <!-- end main content-->
  </div>
  <!-- END layout-wrapper -->

  <!--start back-to-top-->
  <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
    <i class="ri-arrow-up-line"></i>
  </button>
  <!--end back-to-top-->

  <!--preloader-->
  <div id="preloader">
    <div id="status">
      <div class="spinner-border text-primary avatar-sm" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>
  </div>




  <!-- JAVASCRIPT -->

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="Applicant/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="Applicant/assets/libs/simplebar/simplebar.min.js"></script>
  <script src="Applicant/assets/libs/node-waves/waves.min.js"></script>
  <script src="Applicant/assets/libs/feather-icons/feather.min.js"></script>
  <script src="Applicant/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
  <script src="Applicant/assets/js/plugins.js"></script>

  <!-- calendar min js -->
  <script src="Applicant/assets/libs/fullcalendar/index.global.min.js"></script>

  <!-- Calendar init -->
  <script src="Applicant/assets/js/pages/flatpickr.js"></script>
  <script src="Applicant/assets/js/pages/choice.min.js"></script>
  <script src="Applicant/assets/js/pages/flatpickr.min.js"></script>

  <!-- <script src="Applicant/assets/js/pages/calendar.init.js"></script> -->
  <!-- App js -->

  <script src="Applicant/assets/js/app.js"></script>

  <script>
    let saveBtn = document.getElementById("btn-save-event");

    saveBtn.addEventListener('click', function() {
      $('#form-event').submit(function(event) {
        event.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
          url: '{{ route("newEvent") }}',
          type: 'POST',
          data: formData,
          success: function(response) {

            console.log(response);
            if (response == 1) {

              const divElement = document.querySelector('.col-xl-9');
              divElement.classList.remove('d-none');
              divElement.querySelector('strong').textContent = 'Event Added.';

              setTimeout(function() {
                location.reload();
              }, 3000);
            } else {
              const divElement = document.querySelector('.col-xl-9');
              divElement.classList.remove('d-none');
              divElement.querySelector('strong').textContent = 'Event not Added.';
            }
          },
          error: function(xhr, status, error) {

            console.error(xhr.responseText);
          }
        });
      });
    });


    let delBtn = document.getElementById("btn-delete-event");
    delBtn.addEventListener('click', () => {

      $('#form-event').submit(function(event) {
        event.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
          url: '{{ route("eventDel") }}',
          type: 'POST',
          data: formData,
          success: function(response) {

            console.log(response);

            if (response == 1) {

              const divElement = document.querySelector('.col-xl-9');
              divElement.classList.remove('d-none');
              divElement.querySelector('strong').textContent = 'Event Deleted.';

              setTimeout(function() {
                location.reload();
              }, 3000);

            } else {
              const divElement = document.querySelector('.col-xl-9');
              divElement.classList.remove('d-none');
              divElement.querySelector('strong').textContent = 'Event Not Deleted.';
            }


          },
          error: function(xhr, status, error) {

            console.error(xhr.responseText);
          }
        });
      });
    });
  </script>


  <script>
    var start_date = document.getElementById("event-start-date"),
      timepicker1 = document.getElementById("timepicker1"),
      timepicker2 = document.getElementById("timepicker2"),
      date_range = null,
      T_check = null;

    function flatPickrInit() {
      var e = {
        enableTime: !0,
        noCalendar: !0
      };
      flatpickr(start_date, {
        enableTime: !1,
        mode: "single",
        minDate: "today",
        onChange: function(e, t, n) {
          1 < t.split("to").length ?
            document
            .getElementById("event-time")
            .setAttribute("hidden", !0) :
            (document
              .getElementById("timepicker1")
              .parentNode.classList.remove("d-none"),
              document
              .getElementById("timepicker1")
              .classList.replace("d-none", "d-block"),
              document
              .getElementById("timepicker2")
              .parentNode.classList.remove("d-none"),
              document
              .getElementById("timepicker2")
              .classList.replace("d-none", "d-block"),
              document
              .getElementById("event-time")
              .removeAttribute("hidden"));
        },
      });
      flatpickr(timepicker1, e), flatpickr(timepicker2, e);
    }

    function flatpicekrValueClear() {
      start_date.flatpickr().clear(),
        timepicker1.flatpickr().clear(),
        timepicker2.flatpickr().clear();
    }

    function eventClicked() {
      document.getElementById("form-event").classList.add("view-event"),
        document
        .getElementById("event-title")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-category")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-start-date")
        .parentNode.classList.add("d-none"),
        document
        .getElementById("event-start-date")
        .classList.replace("d-block", "d-none"),
        document.getElementById("event-time").setAttribute("hidden", !0),
        document
        .getElementById("timepicker1")
        .parentNode.classList.add("d-none"),
        document
        .getElementById("timepicker1")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("timepicker2")
        .parentNode.classList.add("d-none"),
        document
        .getElementById("timepicker2")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-location")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-description")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-start-date-tag")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-timepicker1-tag")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-timepicker2-tag")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-location-tag")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-description-tag")
        .classList.replace("d-none", "d-block"),
        document.getElementById("btn-save-event").setAttribute("hidden", !0);
    }

    function editEvent(e) {
      var t = e.getAttribute("data-id");
      ("new-event" == t ?
        ((document.getElementById("modal-title").innerHTML = ""),
          (document.getElementById("modal-title").innerHTML = "Add Event"),
          (document.getElementById("btn-save-event").innerHTML = "Add Event"),
          eventTyped) :
        "edit-event" == t ?
        ((e.innerHTML = "Cancel"),
          e.setAttribute("data-id", "cancel-event"),
          (document.getElementById("btn-save-event").innerHTML =
            "Update Event"),
          e.removeAttribute("hidden"),
          eventTyped) :
        ((e.innerHTML = "Edit"),
          e.setAttribute("data-id", "edit-event"),
          eventClicked))();
    }

    function eventTyped() {
      document.getElementById("form-event").classList.remove("view-event"),
        document
        .getElementById("event-title")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-category")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-start-date")
        .parentNode.classList.remove("d-none"),
        document
        .getElementById("event-start-date")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("timepicker1")
        .parentNode.classList.remove("d-none"),
        document
        .getElementById("timepicker1")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("timepicker2")
        .parentNode.classList.remove("d-none"),
        document
        .getElementById("timepicker2")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-location")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-description")
        .classList.replace("d-none", "d-block"),
        document
        .getElementById("event-start-date-tag")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-timepicker1-tag")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-timepicker2-tag")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-location-tag")
        .classList.replace("d-block", "d-none"),
        document
        .getElementById("event-description-tag")
        .classList.replace("d-block", "d-none"),
        document.getElementById("btn-save-event").removeAttribute("hidden");
    }
    document.addEventListener("DOMContentLoaded", function() {
      flatPickrInit();

      let calendarDtl = @json($calendarDtls);
      // console.log(calendarDtl);
      let array = [];


      for (let j = 0; j < calendarDtl.length; j++) {

        const Emplno = calendarDtl[j]["Emplno"];
        const rowid = calendarDtl[j]["rowid"] || "";
        const Name = calendarDtl[j]["Name"] || "";
        const description = calendarDtl[j]["description"] || "";
        const ApplicantName = calendarDtl[j]["ApplicantName"] || "";

        const eventDateTime = calendarDtl[j]["eventDate"];
        var eventDate1 = eventDateTime.split(' ')[0];
        // console.log(array);


        const dateParts = eventDate1.split('-');
        const eventDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);

        const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
          "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
        ];

        const formattedDate = months[eventDate.getMonth()] + " " +
          eventDate.getDate() + " " +
          eventDate.getFullYear();
        // console.log(formattedDate);
        const eventFTime = calendarDtl[j]["eventFTime"] || new Date();
        const eventTTime = calendarDtl[j]["eventTTime"] || new Date();

        // Splitting the time strings into hours, minutes, and seconds
        const [startHour, startMinute] = eventFTime.split(":").map(Number);
        const [endHour, endMinute] = eventTTime.split(":").map(Number);

        function formatTime(hour, minute) {
          let period = "AM";
          let formattedHour = hour;

          if (hour >= 12) {
            period = "PM";
            formattedHour = hour === 12 ? 12 : hour - 12;
          }

          // Add leading zero if minute is less than 10
          const formattedMinute = minute < 10 ? "0" + minute : minute;

          return formattedHour + ":" + formattedMinute + " " + period;
        }

        // Convert start time and end time to 12-hour format
        const formattedStartTime = formatTime(startHour, startMinute);
        const formattedEndTime = formatTime(endHour, endMinute);

        const eventName = calendarDtl[j]["eventName"] || "";
        const location = calendarDtl[j]["location"] || "";
        const tno = calendarDtl[j]["tno"] || "";
        const type = calendarDtl[j]["type"] || "";

        // console.log(dateParts);
        array.push({
          id: rowid,
          title: eventName,
          start: eventDate,
          allDay: !0,
          className: type,
          location: location,

          extendedProps: {
            department: eventName
          },
          description: description,
          sTime: formattedStartTime,
          eTime: formattedEndTime,
          ApplicantName: ApplicantName,
        });

        var g = new bootstrap.Modal(document.getElementById("event-modal"), {
            keyboard: !1,
          }),


          i =
          (document.getElementById("event-modal"),
            document.getElementById("modal-title")),
          l = document.getElementById("form-event"),
          v = null,
          p = document.getElementsByClassName("needs-validation"),
          e = new Date(),
          t = e.getDate(),
          n = e.getMonth(),
          e = e.getFullYear(),
          a = FullCalendar.Draggable,
          d = document.getElementById("external-events"),

          y = array;


        e =
          (new a(d, {
              itemSelector: ".external-event",
              eventData: function(e) {
                return {
                  id: Math.floor(11e3 * Math.random()),
                  title: e.innerText,
                  allDay: !0,
                  start: new Date(),
                  className: e.getAttribute("data-class"),
                };
              },
            }),
            document.getElementById("calendar"));

        // console.log(y);

      }


      if (calendarDtl.length == 0) {

        var g = new bootstrap.Modal(document.getElementById("event-modal"), {
            keyboard: !1,
          }),


          i =
          (document.getElementById("event-modal"),
            document.getElementById("modal-title")),
          l = document.getElementById("form-event"),
          v = null,
          p = document.getElementsByClassName("needs-validation"),
          e = new Date(),
          t = e.getDate(),
          n = e.getMonth(),
          e = e.getFullYear(),
          a = FullCalendar.Draggable,
          d = document.getElementById("external-events"),

          y = [{
            id: "",
            title: "",
            start: "",
            className: "",
            location: "",
            allDay: !0,
            extendedProps: {
              department: ""
            },
            description: "",
            sTime: "",
            eTime: "",
            ApplicantName: "",
          }, ];

        e =
          (new a(d, {
              itemSelector: ".external-event",
              eventData: function(e) {
                return {
                  id: Math.floor(11e3 * Math.random()),
                  title: e.innerText,
                  allDay: !0,
                  start: new Date(),
                  className: e.getAttribute("data-class"),
                };
              },
            }),
            document.getElementById("calendar"));

      }

      function o(e) {
        document.getElementById("form-event").reset(),
          document
          .getElementById("btn-delete-event")
          .setAttribute("hidden", !0),
          g.show(),
          l.classList.remove("was-validated"),
          l.reset(),
          (v = null),
          (i.innerText = "Add Event"),
          (newEventData = e),
          document
          .getElementById("edit-event-btn")
          .setAttribute("data-id", "new-event"),
          document.getElementById("edit-event-btn").click(),
          document.getElementById("edit-event-btn").setAttribute("hidden", !0);
      }

      function r() {
        return 768 <= window.innerWidth && window.innerWidth < 1200 ?
          "timeGridWeek" :
          window.innerWidth <= 768 ?
          "listMonth" :
          "dayGridMonth";
      }
      $("#intCol").show();

      var c = new Choices("#event-category", {
          searchEnabled: !1
        }),
        b = new FullCalendar.Calendar(e, {
          timeZone: "local",
          editable: false,
          droppable: !0,
          selectable: !0,
          navLinks: !0,
          initialView: r(),
          themeSystem: "bootstrap",
          headerToolbar: {
            left: "prev,next today",
            center: "title",
            right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth",
          },
          windowResize: function(e) {
            var t = r();
            b.changeView(t);
          },
          eventResize: function(t) {
            var e = y.findIndex(function(e) {
              return e.id == t.event.id;
            });
            y[e] &&
              ((y[e].title = t.event.title),
                (y[e].start = t.event.start),

                (y[e].end = t.event.end || null),
                (y[e].allDay = t.event.allDay),
                (y[e].className = t.event.classNames[0]),
                (y[e].description =
                  t.event._def.extendedProps.description || ""),
                (y[e].location =
                  t.event._def.extendedProps.location || ""),
                (y[e].eTime =
                  t.event._def.extendedProps.eTime || ""),
                (y[e].ApplicantName =
                  t.event._def.extendedProps.ApplicantName || ""),
                (y[e].sTime =
                  t.event._def.extendedProps.sTime || ""));
            // upcomingEvent(y);

          },
          eventClick: function(e) {
            document
              .getElementById("edit-event-btn")
              .removeAttribute("hidden"),
              document
              .getElementById("btn-save-event")
              .setAttribute("hidden", !0),
              document
              .getElementById("edit-event-btn")
              .setAttribute("data-id", "edit-event"),
              (document.getElementById("edit-event-btn").innerHTML =
                "Edit"),
              eventClicked(),
              flatPickrInit(),
              flatpicekrValueClear(),
              g.show(),
              l.reset(),
              (v = e.event),
              (document.getElementById("modal-title").innerHTML = ""),
              (document.getElementById("event-location-tag").innerHTML =
                void 0 === v.extendedProps.location ?
                "No Location" :
                v.extendedProps.location),
              (document.getElementById(
                  "event-description-tag"
                ).innerHTML =
                void 0 === v.extendedProps.description ?
                "No Description" :
                v.extendedProps.description),

              (document.getElementById("event-timepicker1-tag").innerHTML = void 0 === v.extendedProps.sTime ?
                "00 : 00" : v.extendedProps.sTime),

              (document.getElementById("event-timepicker2-tag").innerHTML = void 0 === v.extendedProps.eTime ?
                "00 : 00" : v.extendedProps.eTime),

              (document.getElementById("appliName").innerHTML = void 0 === v.extendedProps.ApplicantName ?
                "" : v.extendedProps.ApplicantName),

              (document.getElementById("event-title").value = v.title),
              (document.getElementById("event-location").value =
                void 0 === v.extendedProps.location ?
                "No Location" :
                v.extendedProps.location),
              (document.getElementById("event-description").value =
                void 0 === v.extendedProps.description ?
                "No Description" :
                v.extendedProps.description),
              (document.getElementById("eventid").value = v.id),
              v.classNames[0] &&
              (c.destroy(),
                (c = new Choices("#event-category", {
                  searchEnabled: !1,
                })).setChoiceByValue(v.classNames[0]));


            function t(e) {
              var t = "" + ((e = new Date(e)).getMonth() + 1),
                n = "" + e.getDate();
              return [
                e.getFullYear(),
                (t = t.length < 2 ? "0" + t : t),
                (n = n.length < 2 ? "0" + n : n),
              ].join("-");
            }
            var e = v.start,
              n = v.end,
              a = null,
              d =
              (null != n &&
                (a = (d = new Date(n)).setDate(d.getDate() - 1)),
                null == n ? str_dt(e) : str_dt(e) + " to " + str_dt(a)),
              n = null == n ? t(e) : t(e) + " to " + t(a),
              e =
              (flatpickr(start_date, {
                  defaultDate: n,
                  altInput: !0,
                  altFormat: "j F Y",
                  dateFormat: "Y-m-d",
                  mode: "single",
                  onChange: function(e, t, n) {
                    1 < t.split("to").length ?
                      document
                      .getElementById("event-time")
                      .setAttribute("hidden", !0) :
                      (document
                        .getElementById("timepicker1")
                        .parentNode.classList.remove(
                          "d-none"
                        ),
                        document
                        .getElementById("timepicker1")
                        .classList.replace(
                          "d-none",
                          "d-block"
                        ),
                        document
                        .getElementById("timepicker2")
                        .parentNode.classList.remove(
                          "d-none"
                        ),
                        document
                        .getElementById("timepicker2")
                        .classList.replace(
                          "d-none",
                          "d-block"
                        ),
                        document
                        .getElementById("event-time")
                        .removeAttribute("hidden"));
                  },
                }),
                (document.getElementById("event-start-date-tag").innerHTML = d));
            e == a ?
              (document.getElementById("event-time")
                .setAttribute("hidden", !0),
                flatpickr(document.getElementById("timepicker1"), {
                  enableTime: !0,
                  noCalendar: !0,
                  dateFormat: "H:i",
                }),
                flatpickr(document.getElementById("timepicker2"), {
                  enableTime: !0,
                  noCalendar: !0,
                  dateFormat: "H:i",
                })) :
              (document.getElementById("event-time")
                .removeAttribute("hidden"),
                flatpickr(document.getElementById("timepicker1"), {
                  enableTime: !0,
                  noCalendar: !0,
                  dateFormat: "H:i",
                  defaultDate: e,
                }),
                flatpickr(document.getElementById("timepicker2"), {
                  enableTime: !0,
                  noCalendar: !0,
                  dateFormat: "H:i",
                  defaultDate: a,
                })

              ),
              (newEventData = null),
              (i.innerText = v.title),
              document
              .getElementById("btn-delete-event")
              .removeAttribute("hidden");
          },
          // dateClick: function(e) {
          //   o(e);
          // },
          events: y,
          eventReceive: function(e) {
            e = {
              id: parseInt(e.event.id),
              title: e.event.title,
              start: e.event.start,
              allDay: e.event.allDay,
              className: e.event.classNames[0],
            };
            y.push(e);
            // upcomingEvent(y);
          },
          eventDrop: function(t) {
            var e = y.findIndex(function(e) {
              return e.id == t.event.id;
            });
            y[e] &&
              ((y[e].title = t.event.title),
                (y[e].start = t.event.start),
                (y[e].end = t.event.end || null),
                (y[e].allDay = t.event.allDay),
                (y[e].className = t.event.classNames[0]),
                (y[e].description =
                  t.event._def.extendedProps.description || ""),
                (y[e].location =
                  t.event._def.extendedProps.location || ""));
            // upcomingEvent(y);
          },
        });
      b.render(),
        // upcomingEvent(y),
        l.addEventListener("submit", function(e) {
          e.preventDefault();
          var t,
            n,
            e = document.getElementById("event-title").value,
            a = document.getElementById("event-category").value,
            d = document.getElementById("event-start-date").value.split("to"),
            i = new Date(d[0].trim()),
            l = new Date(d[1]),
            l = (l.setDate(l.getDate() + 1), d[1] ? l : ""),
            o = null,
            r = document.getElementById("event-location").value,
            c = document.getElementById("event-description").value,
            s = document.getElementById("eventid").value,
            m = !1,
            u =
            (1 < d.length ?
              ((o = new Date(d[1])).setDate(o.getDate() + 1),
                (d = new Date(d[0])),
                (m = !0)) :
              ((t = d),
                (u = document
                  .getElementById("timepicker1")
                  .value.trim()),
                (n = document
                  .getElementById("timepicker2")
                  .value.trim()),
                (d = new Date(d + "T" + u)),
                (o = new Date(t + "T" + n))),
              y.length + 1);
          !1 === p[0].checkValidity() ?
            p[0].classList.add("was-validated") :
            (v ?
              (v.setProp("id", s),
                v.setProp("title", e),
                v.setProp("classNames", [a]),
                v.setStart(i),
                v.setEnd(l),
                v.setAllDay(m),
                v.setExtendedProp("description", c),
                v.setExtendedProp("location", r),
                (t = y.findIndex(function(e) {
                  return e.id == v.id;
                })),
                y[t] &&
                ((y[t].title = e),
                  (y[t].start = i),
                  (y[t].end = l),
                  (y[t].allDay = m),
                  (y[t].className = a),
                  (y[t].description = c),
                  (y[t].location = r)),
                b.render()) :
              (b.addEvent(
                  (n = {
                    id: u,
                    title: e,
                    start: d,
                    end: o,
                    allDay: m,
                    className: a,
                    description: c,
                    location: r,
                  })
                ),
                y.push(n)),
              g.hide()
              // upcomingEvent(y)
            );
        }),
        document.getElementById("btn-delete-event").addEventListener("click", function(e) {
          if (v) {
            for (var t = 0; t < y.length; t++)
              y[t].id == v.id && (y.splice(t, 1), t--);
            // upcomingEvent(y),
            v.remove(), (v = null), g.hide();
          }
        }),
        document.getElementById("btn-new-event").addEventListener("click", function(e) {
          flatpicekrValueClear(),
            flatPickrInit(),
            o(),
            document.getElementById("edit-event-btn").setAttribute("data-id", "new-event"),
            document.getElementById("edit-event-btn").click(),
            document.getElementById("edit-event-btn").setAttribute("hidden", !0);

        });
    });
    var str_dt = function(e) {
      var e = new Date(e),
        t =
        "" + [
          "January",
          "February",
          "March",
          "April",
          "May",
          "June",
          "July",
          "August",
          "September",
          "October",
          "November",
          "December",
        ][e.getMonth()],
        n = "" + e.getDate(),
        e = e.getFullYear();
      return (
        t.length < 2 && (t = "0" + t),
        [(n = n.length < 2 ? "0" + n : n) + " " + t, e].join(",")
      );
    };
  </script>


  @endsection
</body>

</html>