<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

  <meta charset="utf-8" />
  <title>APPROVAL PERMISSION</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
  <meta content="Themesbrand" name="author" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
  <!-- gridjs css -->
  <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
  <!-- Layout config Js -->
  <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
  <!-- Bootstrap Css -->
  <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <!-- for star rating -->
  <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

  <link rel="stylesheet" href="Applicant/assets/css/style.css" />
  <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css" />
  <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css" />
  <link rel="stylesheet" href="Applicant/assets/css/selectize.css">
</head>

<body>

  <div id="layout-wrapper">
    @extends('Approvals.Approval_nav')
    @section('content')
    <div class="main-content">
      <div class="page-content">
        <div class="container-fluid">
          <!-- start page title -->
          <div class="row">
            <div class="col-12">
              <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                <h4 class="mb-sm-0">Permission</h4>
              </div>
            </div>
          </div>


          <form action="App_Permissionsave" method="post" id="permissionForm">
            @csrf
            <div class="card">
              <!-- ALERT MESSAGE -->
              @if ($message = Session::get('success'))
              <div id="successAlert" class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                {{$message}}
              </div>
              <script>
                // Automatically close the alert after 3 seconds
                setTimeout(function() {
                  var successAlert = document.getElementById('successAlert');
                  if (successAlert) {
                    successAlert.remove();
                  }
                }, 15000);
              </script>
              @endif
              @if ($errors->any())
              <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
                <ul>
                  @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                  @endforeach
                </ul>
              </div>
              @endif


              @php
              $user_emplno = Session::get('empl_id');
              @endphp
              @if( $user_emplno == "5461"|| $user_emplno == "46973" || $user_emplno == "33058" || $user_emplno == "5108" || $user_emplno == "9549")

              <div class="card-body">
                <div class="row">

                  <div class="col-lg-6 col-sm-12">
                    <div class="form-group">
                      <label>Employee Name</label>

                      <select class=" deptSelect" id="select" name="emplno" required>
                        <option value="">Select Employee</option>
                        @foreach ($emplName as $emplNames)
                        <option value="{{$emplNames['Can_person']}}">{{$emplNames['canName']}}/{{$emplNames['canTno']}}/{{$emplNames['Can_designation']}} </option>
                        @endforeach
                      </select>
                      <div class="invalid-feedback">
                        Please select a Employee.
                      </div>
                    </div>
                  </div>
                  <div class="col-12 mb-3">
                    <div class="input-checkset">
                      <!-- <ul>
                        <li>
                          <label class="inputcheck">Select All
                            <input type="checkbox" id="select-all" name="select_all" />
                            <span class="checkmark"></span>
                          </label>
                        </li>
                      </ul> -->
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-12">
                    <div class="productdetails product-respon">
                      <ul>
                        @foreach ($App_list as $App_lists)
                        <li>
                          <h4>{{$App_lists ['Approval_name']}}</h4>
                          <input type="hidden" name="ApprovalList_id[]" value="{{$App_lists ['Rowid']}}">
                          <div class="input-checkset">
                            <ul>
                              <li>
                                <label class="inputcheck">YES
                                  <input type="radio" name="Status{{$loop->iteration}}" value="YES" />
                                  <span class="checkmark"></span>
                                </label>
                              </li>
                              <li>
                                <label class="inputcheck">NO
                                  <input type="radio" name="Status{{$loop->iteration}}" value="NO" />
                                  <span class="checkmark"></span>
                                </label>
                              </li>
                            </ul>
                          </div>
                        </li>
                        @endforeach
                      </ul>

                      <div class="row">
                        <div class="col-lg-12">
                          <div class="d-md-flex justify-content-center mt-3">
                            <button type="submit" class="btn btn-primary">Submit</button>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
              @else
              Permission is Denied

              @endif
            </div>
          </form>

        </div>
      </div>

    </div>
  </div>

  <!-- JAVASCRIPT -->
  <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
  <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
  <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
  <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
  <!-- prismjs plugin -->
  <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
  <!-- gridjs js -->
  <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
  <!-- gridjs init -->
  <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
  <!-- App js -->
  <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Bootstrap JavaScript -->
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


  <script src="assets/plugins/select2/js/select2.min.js"></script>
  <script src="assets/js/selectize.js"></script>
  <script src="assets/js/script.js"></script>


  <script>
    $(document).ready(function() {
      $('#select').on('change', function() {
        var emplno = $(this).val();

        $.ajax({
          url: "{{ route('PermissionApproval_list') }}",
          type: "GET",
          data: {
            emplno: emplno
          },
          dataType: 'json',
          success: function(Empl_list) {
            console.log(Empl_list);

            // Reset all checkboxes before updating
            $('input[type="radio"]').prop('checked', false);

            // Loop through the data returned from the server
            Empl_list.forEach(function(item) {
              const approvalId = item["Approval_id"];
              const status = item["Status"];

              // Find the corresponding input box with ApprovalList_id and compare with Approval_id
              $('input[name="ApprovalList_id[]"]').each(function() {
                if ($(this).val() == approvalId) {
                  // Check the corresponding status checkbox if the IDs match
                  if (status === "YES") {
                    $(this).closest('li').find('input[type="radio"][value="YES"]').prop('checked', true);
                  } else if (status === "NO") {
                    $(this).closest('li').find('input[type="radio"][value="NO"]').prop('checked', true);
                  }
                }
              });
            });
          }

        });
      });

      $('#select').selectize({
        create: false,
        sortField: 'text'
      });
    });
  </script>

  <!-- ALERT MESSAGE IF CHECKBOX IS NOT SELECTED -->
  <script>
    $(document).ready(function() {
      $('#permissionForm').on('submit', function(event) {
        let isValid = true;

        // Loop through each list item to check if either YES or NO is selected
        $('input[name^="Status"]').each(function(index) {
          const radioGroupName = $(this).attr('name');

          // Check if any radio button in the current group is checked
          if (!$('input[name="' + radioGroupName + '"]:checked').length) {
            isValid = false;
            return false; // Exit the loop if any group is not checked
          }
        });

        // If not valid, show an alert and prevent form submission
        if (!isValid) {
          event.preventDefault(); // Prevent the form from submitting
          alert("Please ensure all Approval items have a selected status.");
        }
      });
    });
  </script>




  @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>