<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>Split PO Approvals</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>

    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>


    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>
    <style>
        .row-item {
            display: flex;
            align-items: center;
        }

        .row-item span {
            margin-right: 8px;
            /* Add some space between the number and the checkbox */
        }

        .checkbox {
            display: inline-block;
            /* Ensure the checkbox is inline */
        }
    </style>

</head>

<body>

    <div id="layout-wrapper">
        @extends('Approvals.Approval_nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ EMPLOYEE SELECT & EXPORT @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->

                                <div class="card-header d-flex justify-content-between align-items-center">

                                    <h4 class="card-title">
                                        @if(\Route::currentRouteName() == 'splitPOApprovals_Woven')
                                        Split PO Approval-Woven
                                        @endif

                                        @if(\Route::currentRouteName() == 'splitPOApprovals_Gloves')
                                        Split PO Approval-Gloves
                                        @endif

                                        @if(\Route::currentRouteName() == 'splitPOApprovals_Headwear')
                                        Split PO Approval-Headwear
                                        @endif
                                    </h4>
                                    @if ($message = Session::get('success'))
                                    <div class="alert alert-success mt-3 alert-dismissible fade show" role="alert" id="alert">
                                        {{$message}}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <script>
                                        setTimeout(function() {
                                            var successAlert = document.getElementById('alert');
                                            if (successAlert) {
                                                successAlert.remove();
                                            }
                                        }, 5000);
                                    </script>
                                    @endif

                                    @if ($errors->any())
                                    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    @endif

                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SEARCH AND SHOW ENTRIES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>
                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @if(\Route::currentRouteName() == 'splitPOApprovals_Woven')
                                <form id="validate" method="POST" action="splitPOApprovalsave_woven">
                                    @csrf
                                    <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th data-sort="sno">
                                                            <div class="checkbox">
                                                                <input type="checkbox" class="check" id="checkboxElement">
                                                            </div>
                                                            SNO <span class="sort-icon">
                                                        </th>
                                                        <th data-sort="View"> View <span class="sort-icon"></th>
                                                        <th data-sort="ORDER"> Order No <span class="sort-icon"></th>
                                                        <th data-sort="split"> Split PONO <span class="sort-icon"></th>
                                                        <th data-sort="qty">Qty <span class="sort-icon"></th>
                                                        <th data-sort="ccno">CCNO<span class="sort-icon"></th>
                                                        <th data-sort="Season">Season <span class="sort-icon"></th>
                                                        <th data-sort="Color">Color <span class="sort-icon"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($splitpowoven_list as $index => $splitpowoven_lists)
                                                    <tr>
                                                        <td>
                                                            <div class="row-item">
                                                                <div class="checkbox">
                                                                    <input class="check" type="checkbox" id="" onchange="createSaveButton(this.parentNode.parentNode)" name="order_po[]" value="{{ $splitpowoven_lists['Order_NO'] }} / {{ $splitpowoven_lists['Split_PONO'] }}" />
                                                                </div>
                                                                &nbsp;&nbsp;&nbsp;{{ $index + 1 }}
                                                            </div>
                                                        </td>
                                                        <td>

                                                            <button type="button" class="btn btn-outline-warning Woven_viewSizeButton"
                                                                data-order-no="{{ $splitpowoven_lists['Order_NO'] }}"
                                                                data-split-pono="{{ $splitpowoven_lists['Split_PONO'] }}">
                                                                View size
                                                            </button>

                                                            <!-- <a href="#" data-toggle="modal" data-target="#SizeModal" data-order-no="{{ $splitpowoven_lists['Order_NO'] }}" data-split-pono="{{ $splitpowoven_lists['Split_PONO'] }}"> View size</a> -->

                                                        </td>
                                                        <td>{{ $splitpowoven_lists['Order_NO'] }}</td>
                                                        <td>{{ $splitpowoven_lists['Split_PONO'] }}</td>
                                                        <td>{{ $splitpowoven_lists['Qty'] }}</td>
                                                        <td>{{ $splitpowoven_lists['CCNO'] }}</td>
                                                        <td>{{ $splitpowoven_lists['SEason'] }}</td>
                                                        <td>{{ $splitpowoven_lists['Glo_Color'] }}</td>
                                                        <!-- <td>{{ $splitpowoven_lists['Order_ID'] }}</td> -->
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>


                                    <div class=" d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVE" id="approve" class="btn btn-primary">
                                    </div>
                                </form>
                                @endif

                                @if(\Route::currentRouteName() == 'splitPOApprovals_Gloves')
                                <form id="validate" method="POST" action="splitPOApprovalsave_gloves">
                                    @csrf
                                    <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th data-sort="sno">
                                                            <div class="checkbox">
                                                                <input type="checkbox" class="check" id="checkboxElement">
                                                            </div>
                                                            SNO <span class="sort-icon">
                                                        </th>
                                                        <th data-sort="View"> View <span class="sort-icon"></th>
                                                        <th data-sort="ORDER"> Order No <span class="sort-icon"></th>
                                                        <th data-sort="split"> Split PONO <span class="sort-icon"></th>
                                                        <th data-sort="qty">Qty <span class="sort-icon"></th>
                                                        <th data-sort="ccno">CCNO<span class="sort-icon"></th>
                                                        <th data-sort="Season">Season <span class="sort-icon"></th>
                                                        <th data-sort="Color">Color <span class="sort-icon"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($splitpoGloves_list as $index => $splitpoGloves_lists)
                                                    <tr>
                                                        <td>
                                                            <div class="row-item">
                                                                <div class="checkbox">
                                                                    <input class="check" type="checkbox" id="" onchange="createSaveButton(this.parentNode.parentNode)" name="glovesorder_po[]" value="{{ $splitpoGloves_lists['Order_NO'] }} / {{ $splitpoGloves_lists['Split_PONO'] }}" />
                                                                </div>
                                                                &nbsp;&nbsp;&nbsp;{{ $index + 1 }}
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-outline-warning Gloves_viewSizeButton"
                                                                data-order-no="{{ $splitpoGloves_lists['Order_NO'] }}"
                                                                data-split-pono="{{ $splitpoGloves_lists['Split_PONO'] }}">
                                                                View size
                                                            </button>

                                                            <!-- <a href="#" data-toggle="modal" data-target="#SizeModal" data-order-no="{{ $splitpoGloves_lists['Order_NO'] }}" data-split-pono="{{ $splitpoGloves_lists['Split_PONO'] }}"> View size</a> -->

                                                        </td>
                                                        <td>{{ $splitpoGloves_lists['Order_NO'] }}</td>
                                                        <td>{{ $splitpoGloves_lists['Split_PONO'] }}</td>
                                                        <td>{{ $splitpoGloves_lists['Qty'] }}</td>
                                                        <td>{{ $splitpoGloves_lists['CCNO'] }}</td>
                                                        <td>{{ $splitpoGloves_lists['SEason'] }}</td>
                                                        <td>{{ $splitpoGloves_lists['Glo_Color'] }}</td>
                                                        <!-- <td>{{ $splitpoGloves_lists['Order_ID'] }}</td> -->
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>


                                    <div class=" d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVE" id="approve" class="btn btn-primary">
                                    </div>
                                </form>
                                @endif

                                @if(\Route::currentRouteName() == 'splitPOApprovals_Headwear')
                                <form id="validate" method="POST" action="splitPOApprovalsave_Headwear">
                                    @csrf
                                    <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th data-sort="sno">
                                                            <div class="checkbox">
                                                                <input type="checkbox" class="check" id="checkboxElement">
                                                            </div>
                                                            SNO <span class="sort-icon">
                                                        </th>
                                                        <th data-sort="View"> View <span class="sort-icon"></th>
                                                        <th data-sort="ORDER"> Order No <span class="sort-icon"></th>
                                                        <th data-sort="split"> Split PONO <span class="sort-icon"></th>
                                                        <th data-sort="qty">Qty <span class="sort-icon"></th>
                                                        <th data-sort="ccno">CCNO<span class="sort-icon"></th>
                                                        <th data-sort="Season">Season <span class="sort-icon"></th>
                                                        <th data-sort="Color">Color <span class="sort-icon"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($splitpoHeadwear_list as $index => $splitpoHeadwear_lists)
                                                    <tr>
                                                        <td>
                                                            <div class="row-item">
                                                                <div class="checkbox">
                                                                    <input class="check" type="checkbox" id="" onchange="createSaveButton(this.parentNode.parentNode)" name="Headwearorder_po[]" value="{{ $splitpoHeadwear_lists['Order_NO'] }} / {{ $splitpoHeadwear_lists['Split_PONO'] }}" />
                                                                </div>
                                                                &nbsp;&nbsp;&nbsp;{{ $index + 1 }}
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-outline-warning Headwear_viewSizeButton"
                                                                data-order-no="{{ $splitpoHeadwear_lists['Order_NO'] }}"
                                                                data-split-pono="{{ $splitpoHeadwear_lists['Split_PONO'] }}">
                                                                View size
                                                            </button>

                                                            <!-- <a href="#" data-toggle="modal" data-target="#SizeModal" data-order-no="{{ $splitpoHeadwear_lists['Order_NO'] }}" data-split-pono="{{ $splitpoHeadwear_lists['Split_PONO'] }}"> View size</a> -->

                                                        </td>
                                                        <td>{{ $splitpoHeadwear_lists['Order_NO'] }}</td>
                                                        <td>{{ $splitpoHeadwear_lists['Split_PONO'] }}</td>
                                                        <td>{{ $splitpoHeadwear_lists['Qty'] }}</td>
                                                        <td>{{ $splitpoHeadwear_lists['CCNO'] }}</td>
                                                        <td>{{ $splitpoHeadwear_lists['SEason'] }}</td>
                                                        <td>{{ $splitpoHeadwear_lists['Glo_Color'] }}</td>
                                                        <!-- <td>{{ $splitpoHeadwear_lists['Order_ID'] }}</td> -->
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>


                                    <div class=" d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVE" id="approve" class="btn btn-primary">
                                    </div>
                                </form>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal FOR WOVEN -->
    <div id="WovenSizeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="sizeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="sizeModalLabel">Size Details</h5>
                    <button type="button" class="close btnClose bg-light btn" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead class="text-muted table-light">
                            <tr>
                                <th>SNO</th>
                                <th>Order No</th>
                                <th>Split PONO</th>
                                <th>Size</th>
                                <th>Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Size details will be populated here -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btnClose" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal FOR GLOVES -->
    <div id="GlovesSizeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="sizeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="sizeModalLabel">Size Details</h5>
                    <button type="button" class="close btnClose bg-light btn" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead class="text-muted table-light">
                            <tr>
                                <th>SNO</th>
                                <th>Order No</th>
                                <th>Split PONO</th>
                                <th>Size</th>
                                <th>Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Size details will be populated here -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btnClose" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal FOR HEADWEAR -->
    <div id="HeadwearSizeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="sizeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="sizeModalLabel">Size Details</h5>
                    <button type="button" class="close btnClose bg-light btn" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead class="text-muted table-light">
                            <tr>
                                <th>SNO</th>
                                <th>Order No</th>
                                <th>Split PONO</th>
                                <th>Size</th>
                                <th>Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Size details will be populated here -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btnClose" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>




    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap JavaScript -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- FOR WOVEN -->
    <script>
        $(document).ready(function() {
            // Use class selector to target all buttons with the class "viewSizeButton"
            $(document).on('click', '.Woven_viewSizeButton', function() {
                // Retrieve the order number and split PONO from the button's data attributes
                let orderNo = $(this).data('order-no');
                let splitPono = $(this).data('split-pono');

                // Clear any previous data in the table
                let tableBody = $('#WovenSizeModal').find('.modal-body tbody');
                tableBody.empty();

                let modal = $(this);
                modal.find('.modal-title').text(`Size Details for Order No: ${orderNo} / Split PONO :  ${splitPono}`);

                // Make the AJAX request
                $.ajax({
                    url: 'splitPOsize_woven', // Your API endpoint or route
                    method: 'GET',
                    data: {
                        order_no: orderNo,
                        split_pono: splitPono
                    },
                    success: function(splitpowoven_size) {
                        // Populate the modal's table with the fetched data
                        $.each(splitpowoven_size, function(index, sizeDetail) {
                            let row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${sizeDetail.Order_NO}</td>
                        <td>${sizeDetail.Split_PONO}</td>
                        <td>${sizeDetail.Size}</td>
                        <td>${sizeDetail.Qty}</td>
                    </tr>`;
                            tableBody.append(row);
                        });

                        // Manually trigger the modal to show after data is populated
                        $('#WovenSizeModal').modal('show');


                    },
                    error: function() {
                        // Handle errors, e.g., display a notification to the user
                        alert('Failed to retrieve size details. Please try again.');
                    }

                });

                $('.btnClose').on('click', function() {
                    $('#WovenSizeModal').modal('hide');
                });

            });
        });
    </script>

    <!-- FOR GLOVES -->
    <script>
        $(document).ready(function() {
            // Use class selector to target all buttons with the class "viewSizeButton"
            $(document).on('click', '.Gloves_viewSizeButton', function() {
                // Retrieve the order number and split PONO from the button's data attributes
                let orderNo = $(this).data('order-no');
                let splitPono = $(this).data('split-pono');

                // Clear any previous data in the table
                let tableBody = $('#GlovesSizeModal').find('.modal-body tbody');
                tableBody.empty();

                let modal = $(this);
                modal.find('.modal-title').text(`Size Details for Order No: ${orderNo} / Split PONO :  ${splitPono}`);

                // Make the AJAX request
                $.ajax({
                    url: 'splitPOsize_Gloves', // Your API endpoint or route
                    method: 'GET',
                    data: {
                        order_no: orderNo,
                        split_pono: splitPono
                    },
                    success: function(splitpogloves_size) {
                        // Populate the modal's table with the fetched data
                        $.each(splitpogloves_size, function(index, sizeDetail) {
                            let row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${sizeDetail.Order_NO}</td>
                        <td>${sizeDetail.Split_PONO}</td>
                        <td>${sizeDetail.Size}</td>
                        <td>${sizeDetail.Qty}</td>
                    </tr>`;
                            tableBody.append(row);
                        });

                        // Manually trigger the modal to show after data is populated
                        $('#GlovesSizeModal').modal('show');


                    },
                    error: function() {
                        // Handle errors, e.g., display a notification to the user
                        alert('Failed to retrieve size details. Please try again.');
                    }

                });

                $('.btnClose').on('click', function() {
                    $('#GlovesSizeModal').modal('hide');
                });

            });
        });
    </script>

    <!-- FOR HEADWEAR -->
    <script>
        $(document).ready(function() {
            // Use class selector to target all buttons with the class "viewSizeButton"
            $(document).on('click', '.Headwear_viewSizeButton', function() {
                // Retrieve the order number and split PONO from the button's data attributes
                let orderNo = $(this).data('order-no');
                let splitPono = $(this).data('split-pono');

                // Clear any previous data in the table
                let tableBody = $('#HeadwearSizeModal').find('.modal-body tbody');
                tableBody.empty();

                let modal = $(this);
                modal.find('.modal-title').text(`Size Details for Order No: ${orderNo} / Split PONO :  ${splitPono}`);

                // Make the AJAX request
                $.ajax({
                    url: 'splitPOsize_Headwear', // Your API endpoint or route
                    method: 'GET',
                    data: {
                        order_no: orderNo,
                        split_pono: splitPono
                    },
                    success: function(splitpoHeadwear_size) {
                        // Populate the modal's table with the fetched data
                        $.each(splitpoHeadwear_size, function(index, sizeDetail) {
                            let row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${sizeDetail.Order_NO}</td>
                        <td>${sizeDetail.Split_PONO}</td>
                        <td>${sizeDetail.Size}</td>
                        <td>${sizeDetail.Qty}</td>
                    </tr>`;
                            tableBody.append(row);
                        });

                        // Manually trigger the modal to show after data is populated
                        $('#HeadwearSizeModal').modal('show');


                    },
                    error: function() {
                        // Handle errors, e.g., display a notification to the user
                        alert('Failed to retrieve size details. Please try again.');
                    }

                });

                $('.btnClose').on('click', function() {
                    $('#HeadwearSizeModal').modal('hide');
                });

            });
        });
    </script>


    <!-- SELECT ALL -->
    <script>
        $("#checkboxElement").click(function() {
            $(".check").prop('checked', $(this).prop('checked'));
        });
    </script>

    <!-- POPUP FOR APPROVE -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get a reference to the "REJECT" button by its ID
            var approveButton = document.getElementById("approve");

            // Add a click event listener to the button
            approveButton.addEventListener("click", function(event) {
                // Display a confirmation dialog with "OK" and "Cancel" options
                var confirmation = confirm("Are you sure you want to approve?");

                // Check the user's choice in the confirmation dialog
                if (!confirmation) {
                    // If the user clicked "Cancel," prevent the default action of the button
                    event.preventDefault();
                }
            });

            // Prevent Enter key from submitting the form (assuming the button is inside a form)
            document.addEventListener("keydown", function(event) {
                if (event.key === "Enter" && event.target === approveButton) {
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Define a variable to store the search value
            var searchValue = "";

            // Search function
            function performSearch() {
                var matches = $("#dataTable tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchValue) > -1;
                });

                if (searchValue === "") {
                    // If the search bar is empty, clear the search results and count
                    $("#searchCount").text("");
                    $("#entryCount").show(); // Show the entry count
                    $("#dataTable tbody tr").toggle(true);
                    updateRowsPerPage(); // Call the function to reset displayed rows
                } else {
                    $("#entryCount").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    $("#searchCount").text(matches.length + " result(s) found");

                    // Get the selected rows per page value
                    var maxRows = parseInt($("#maxRows").val());

                    // Limit the matches to the selected rows per page
                    matches.slice(maxRows).toggle(false);
                    matches.slice(0, maxRows).toggle(true);
                    $("#dataTable tbody tr").not(matches).toggle(false);
                }
            }

            // Search input keyup event
            $("#search-input").on("keyup", function() {
                searchValue = $(this).val().toLowerCase();
                performSearch();
            });

            // maxRows dropdown change event
            $("#maxRows").on("change", function() {
                // Update rows per page and reapply search
                updateRowsPerPage();
                performSearch();
            });

            // Initialize search and rows per page
            performSearch();
            updateRowsPerPage();
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>