<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Audit Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- jQuery (Make sure it's included before Bootstrap JS) -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #fff;
            /* or another background color */
            z-index: 1;
        }
    </style>

    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')
    @endsection

    <div class="main-wrapper">
        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="page-header">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                            <h5 class="text-uppercase mb-0 mt-0 page-title">Audit Report</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">

                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <input type="text" id="searchInput" class="form-control" placeholder="Search...">
                                    </div>
                                    <div class="text-center mb-3">
                                        <button type="button" class="btn btn-success" onclick="exportTableToExcel('trainTable', 'Audit_Report')">Download Excel</button>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table custom-table datatable" id="trainTable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SNO</th>
                                                <th>View</th>
                                                <th>ENO </th>
                                                <th>EDate </th>
                                                <th>Division</th>
                                                <th>Team</th>
                                                <th>Zone</th>
                                                <th>Type of S</th>
                                                <th>Type of Audit</th>
                                                <th>Next Verification Date</th>
                                                <th>Attach-1</th>
                                                <th>Attach-2</th>
                                                <th>Attach-3</th>
                                                <th>Attach-4</th>
                                                <th>Attach-5</th>
                                                <th>Audit By</th>
                                                <th>Entry By</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($Aud_Report as $index => $Aud_Reports)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <button type="button" class="btn btn-warning ViewDetails" onclick="ViewDetails('{{ $Aud_Reports['Rowid'] }}')">
                                                        View
                                                    </button>

                                                </td>
                                                <td>{{ $Aud_Reports['E_NO'] }}</td>
                                                <td>{{ date('Y-m-d', strtotime($Aud_Reports['E_date'])) }}</td>
                                                <td>{{ $Aud_Reports['Division'] }}</td>
                                                <td>{{ $Aud_Reports['Team'] }}</td>
                                                <td>{{ $Aud_Reports['Zone'] }}</td>
                                                <td>{{ $Aud_Reports['type_s'] }}</td>
                                                <td>{{ $Aud_Reports['Type_audit'] }}</td>
                                                <td>{{ date('Y-m-d', strtotime($Aud_Reports['verf_date'])) }}</td>
                                                <td>
                                                    @if($Aud_Reports['Attach_1'] !== "No-Attach")
                                                    <a href="{{ asset('AuditEntry/' . $Aud_Reports['Attach_1']) }}"
                                                        class="mr-5 file-link"
                                                        id="link2"
                                                        name="filepath"
                                                        target="_blank"
                                                        title="{{ $Aud_Reports['Attach_1'] }}">
                                                        Attach-1
                                                    </a>
                                                    @else
                                                    --
                                                    @endif
                                                </td>

                                                <td>
                                                    @if($Aud_Reports['Attach_2'] !== "No-Attach")
                                                    <a href="{{ $Aud_Reports['Attach_2']  }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $Aud_Reports['Attach_2']  }}">Attach-2</a>
                                                    @else
                                                    --
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($Aud_Reports['Attach_3'] !== "No-Attach")
                                                    <a href="{{ $Aud_Reports['Attach_3']  }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $Aud_Reports['Attach_3']  }}">Attach-3</a>
                                                    @else
                                                    --
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($Aud_Reports['Attach_4'] !== "No-Attach")
                                                    <a href="{{ $Aud_Reports['Attach_4']  }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $Aud_Reports['Attach_4']  }}">Attach-4</a>
                                                    @else
                                                    --
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($Aud_Reports['Attach_5'] !== "No-Attach")
                                                    <a href="{{ $Aud_Reports['Attach_5']  }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $Aud_Reports['Attach_5']  }}">Attach-5</a>
                                                    @else
                                                    --
                                                    @endif
                                                </td>
                                                <td>{{ $Aud_Reports['AuditorName'] }} / {{ $Aud_Reports['AuditorTNO'] }}</td>
                                                <td>{{ $Aud_Reports['EntryBYName'] }} / {{ $Aud_Reports['EntryBYTNO'] }}</td>


                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <br>
                                <div class="col-md-12 col-lg-12 save">
                                    <div class="text-center">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/audit_entry'">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="AuditDetailsModal" tabindex="-1" role="dialog" aria-labelledby="employeeDetailsLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="employeeDetailsLabel">Audit Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>SNO</th>
                                <th>Check Point</th>
                                <th>Tamil</th>
                                <th>Alloted</th>
                                <th>Audited</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody id="AuditDetailsBody">
                            <!-- Data will be appended here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- // FOR SELECTED DIVISION & TEAM   -->
    <script>
        function ViewDetails(Rowid) {
            console.log('Rowid', Rowid);

            $.ajax({
                url: "{{ route('Audit_DetReport') }}",
                type: "GET",
                data: {
                    Rowid: Rowid
                },
                dataType: 'json',
                success: function(DEtReport) {
                    console.log('Audit Details', DEtReport);
                    // Clear existing content
                    $('#AuditDetailsBody').empty();

                    let totalAlloted = 0;
                    let totalAudited = 0;

                    // Loop through details and append table rows
                    DEtReport.forEach(function(item, index) {
                        let allotedValue = parseFloat(item.Alloted) || 0;
                        let auditedValue = parseFloat(item.Audited) || 0;

                        totalAlloted += allotedValue;
                        totalAudited += auditedValue;

                        let row = `<tr>
                    <td>${index + 1}</td>
                    <td>${item.Check_point}</td>
                    <td>${item.Tamil}</td>
                    <td>${allotedValue}</td>
                    <td>${auditedValue}</td>
                    <td>${item.Remarks === "No_Remarks" ? '--' : item.Remarks}</td>
                </tr>`;
                        $('#AuditDetailsBody').append(row);
                    });

                    // Append total row
                    let totalRow = `<tr style="font-weight:bold; background:#f8f9fa;">
                <td colspan="3" class="text-right">Total:</td>
                <td>${totalAlloted}</td>
                <td>${totalAudited}</td>
                <td></td>
            </tr>`;
                    $('#AuditDetailsBody').append(totalRow);

                    // Show the modal (using Bootstrap's modal method)
                    $('#AuditDetailsModal').modal('show');

                    document.querySelector('.close').addEventListener('click', function() {
                        $('#AuditDetailsModal').modal('hide'); // Bootstrap 4
                    });
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", xhr.responseText);
                    alert("AJAX Error:", xhr.responseText);
                }
            });
        }
    </script>


    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            $('#searchInput').on('keyup', function() {
                let filter = $(this).val().toLowerCase();
                $('#trainTable tbody tr').each(function() {
                    $(this).toggle($(this).text().toLowerCase().includes(filter));
                });
            });
        });
    </script>

    <!-- EXCEL -->
    <script>
        function exportTableToExcel(tableID, filename = '') {
            let table = document.getElementById(tableID);
            let workbook = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });
            return XLSX.writeFile(workbook, filename ? filename + ".xlsx" : "excel_data.xlsx");
        }
    </script>

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="assets/js/5s/popper.min.js"></script>
    <script src="assets/js/5s/jquery-3.6.0.min.js"></script>
    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>
    <script src="assets/js/5s/jquery.slimscroll.js"></script>
    <script src="assets/js/5s/jquery.dataTables.min.js"></script>
    <script src="assets/js/5s/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/5s/app.js"></script>


</body>

</html>