<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Audit Entry</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include jQuery and Select2 libraries -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/js/select2.min.js"></script>



    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>

</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('audit_save') }}" enctype="multipart/form-data">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">audit entry </h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>ENO</label>
                                                <input type="text" class="form-control" name="eno" id="eno" value="<?php echo $eno; ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" name="edate" id="edate" required>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Division</label>
                                                <select class="form-control " name="div" id="div" onchange="teamvalue(this.value)" required>
                                                    <option value=""> --Select Division --</option>
                                                    @foreach ($division as $div)
                                                    <option value="{{$div['Division_id']}}">{{$div['Division']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Team </label>
                                                <select class="form-control team_select" name="team_nam" id="team_nam" onchange="zonevalue(this.value)" required>
                                                    <option value="">-- Select Team --</option>
                                                </select>
                                                <!-- <input type="text" class="form-control team_nam" readonly> -->
                                                <!-- <input type="hidden" class="form-control team_id" name="team_id" id="team_id"> -->
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Zone </label>
                                                <select class="form-control zone_nam" name="zone_nam" id="zone_nam" onchange="tablevalue(this.value)" required>
                                                    <option value="">-- Select Zone --</option>
                                                </select>
                                                <!-- <input type="text" class="form-control zone_nam" readonly> -->
                                                <!-- <input type="hidden" class="form-control zone_id" name="zone_id" id="zone_id"> -->
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of S</label>
                                                <select class="form-control" name="type_s" id="type_s" onchange="changeS(this.value)" required>
                                                    <option>--Select S--</option>
                                                    @foreach ($ty_s as $typ)
                                                    <option value="{{$typ['Rowid']}}">{{$typ['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Audit</label>
                                                <select class="form-control" name="type_audit" id="type_audit" required>
                                                    <option>--Select Audit--</option>
                                                    @foreach ($ty_audit as $typ1)
                                                    <option value="{{$typ1['Rowid']}}">{{$typ1['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label></label>
                                                <button type="button" class=" form-control btn btn-info" onclick="toggleTableVisibility()"> See the Employee Allocation </button>
                                            </div>
                                        </div>
                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>
                                    <div class="row">
                                    <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Audit By</label>
                                                <select class="form-control Auditor_select" name="Auditor" id="Auditor" required>
                                                    <option>--Select Audit Name--</option>
                                                  
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- <div class="row">
                                        <div class="col-md-6 col-lg-6 ml-6">
                                            <div class="form-group">
                                            </div>
                                        </div>
                                    </div> -->

                                    <!-- // EMPLOYEE ALLOCATION TABLE   -->
                                    <div class="table-container">
                                        <table id="empl_table" class="table" style="display: none; max-height: 20px !important; height: 20px !important; overflow-y: auto; line-height: 3px;">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>5S Designation</th>
                                                    <th>Employee Name</th>
                                                    <th>Department</th>
                                                    <th>Designation</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Your table content goes here -->
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- <br>
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            <label>Add Check Point</label>
                                            <div class="add-icon">
                                                <a href="javascript:void(0);" id="addRowBtn" onclick="addRow()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                            </div>
                                        </div>
                                    </div> -->
                                    <br>
                                    <!-- // TABLE FOR AUDITED  -->
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Check Point </th>
                                                    <th style="display: none;">Check Point ID </th>
                                                    <th>Alloted</th>
                                                    <th>Audited</th>
                                                    <th>Remarks</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tableBody">
                                               
                                            </tbody>

                                        </table>
                                    </div>

                                    <!-- <br>
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            <label>Add Check Point</label>
                                            <div class="add-icon">
                                                <a href="javascript:void(0);" id="addRowBtn" onclick="addRow1()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                            </div>
                                        </div>
                                    </div> -->
                                    <!-- <br> -->
                                    <!-- // TABLE FOR REMARKS  -->
                                    <!-- <div class="table-container">
                                        <table id="app_table1" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Check Point </th>
                                                    <th>Remarks</th>
                                                    <th>Edit</th>

                                                </tr>
                                            </thead>
                                            <tbody id="tableBody1">
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control" name="check1[]" id="check1" required>
                                                            <option value="">--Select Check point--</option>
                                                            @foreach ($Check_point as $check)
                                                            <option value="{{$check['check_id']}}">{{$check['Check_point']}}</option>
                                                            @endforeach
                                                        </select>

                                                    </td>
                                                    <td>
                                                        <input type="text" name="remark[]" id="remark" class="form-control">
                                                    </td>
                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>
                                            </tbody>

                                        </table>
                                    </div> -->

                                    <br>
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="form-group">
                                                <label>Remarks</label>
                                                <textarea class="form-control" rows="4" name="Remarks" id="Remarks" required></textarea>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                            <div class="row">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="form-group row">
                                                        <label for="ver_date" class="col-sm-4 col-form-label"> Next Verification Date </label>
                                                        <div class="col-sm-6">
                                                            <input type="date" class="form-control" name="nxt_date" id="nxt_date" required>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_2" class="col-sm-4 col-form-label"> Attachement -2</label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file2" id="file2">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_4" class="col-sm-4 col-form-label"> Attachement -4 </label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file4" id="file4">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="form-group row">
                                                        <label for="attach_1" class="col-sm-4 col-form-label"> Attachement -1</label>
                                                        <div class="col-sm-6">
                                                            <!-- <input class="form-control" type="file" id="formFile1" name="formFile1"> -->
                                                            <input type="file" class="form-control" name="file1" id="file1">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_3" class="col-sm-4 col-form-label"> Attachement -3</label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file3" id="file3">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_5" class="col-sm-4 col-form-label"> Attachement -5 </label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file5" id="file5">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12 col-md-12">
                                <div class="d-flex justify-content-around pb-2">
                                    <button type="button" id="clearButton" class="btn btn-primary ml-5" onclick="clearPage()">CLEAR</button>
                                    <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-success">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/AuditReport'">Report</button>

                                        <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                        <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <!-- // FOR AUDIT MARKS NOT GREATER THAN ALLOTED  -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get reference to the input fields
            var allotedInput = document.getElementById('alloted');
            var auditedInput = document.getElementById('audit');

            // Add event listener to the audited input field
            auditedInput.addEventListener('input', function() {
                var allotedValue = parseFloat(allotedInput.value);
                var auditedValue = parseFloat(auditedInput.value);

                // Check if the input is not a number or if audited marks exceed allotted marks
                if (isNaN(auditedValue) || auditedValue > allotedValue) {
                    // Reset audited input value to the previous value (allotted value)
                    alert("Audited marks cannot exceed allotted marks!");
                    auditedInput.value = '';
                }
            });

            // Add event listener to allow only numbers in audited input
            auditedInput.addEventListener('keypress', function(event) {
                // Get the character code of the key pressed
                var charCode = event.which ? event.which : event.keyCode;

                // Allow only numbers (48-57) and backspace/delete (8 and 46)
                if (charCode < 48 || charCode > 57) {
                    // Prevent default action if not a number or backspace/delete
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- // FOR SELECTED DIVISION  -->
    <script>
        function teamvalue(div_id) {
            var selected_div = div_id;

            $.ajax({
                url: "{{ route('audit_entry1') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                },
                dataType: 'json',
                success: function(team) {
                    if (team.length > 0) {
                        console.log(team);

                        // Clear existing options
                        $('.team_select').empty();

                        // Append the "--Select Team--" option first
                        $('.team_select').append('<option value=""> --Select Team -- </option>');

                        // Populate dropdown with new options
                        $.each(team, function(index, option) {
                            var teamOption = $('<option>', {
                                value: option.team_id,
                                text: option.Team
                            });

                            $('.team_select').append(teamOption);
                        });

                        // Trigger change event to update hidden input
                        $('.team_select').trigger('change');

                    }
                }
            });
        }

        function tablevalue(div_id) {
            var selected_div = div_id;
            var teamId = $('[name="team_nam"]').val();
            var zoneId = $('[name="zone_nam"]').val();

            // Your tablevalue logic here using teamId and zoneId
            console.log('team_id:', teamId);
            console.log('zone_id:', zoneId);
            console.log(selected_div);

            $.ajax({
                url: "{{ route('audit_entry3') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                    teamId: teamId,
                    zoneId: zoneId,
                },
                dataType: 'json',
                success: function(emp_table) {
                    if (emp_table.length > 0) {
                        console.log(emp_table);

                        // Clear existing tbody content
                        $('#empl_table tbody').empty();

        
                        // Populate tbody with new data
                        for (var i = 0; i < emp_table.length; i++) {
                            var row = emp_table[i];
                            $('#empl_table tbody').append(
                                '<tr>' +
                                '<td>' + (i + 1) + '</td>' +
                                '<td>' + row['designation'] + '</td>' +
                                '<td>' + row['Name'] + '</td>' +
                                '<td>' + row['DeptName'] + '</td>' +
                                '<td>' + row['Actual_DesignationName'] + '</td>' +
                                '</tr>'
                            );
                        }
                         
                                                    
                    }
                }
            });
        }
    </script>

    <!-- // FOR EMPLOYEE ALLOCATION TABLE  -->
    <script>
        function tablevalue(zone_id) {
            var zoneId = zone_id;
            var teamId = $('[name="team_nam"]').val();
            var selected_div = $('[name="div"]').val();

            console.log(selected_div, teamId, zoneId);

            $.ajax({
                url: "{{ route('audit_entry3') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                    teamId: teamId,
                    zoneId: zoneId,
                },
                dataType: 'json',
                success: function(emp_table) {
                    if (emp_table.length > 0) {
                        console.log('Emplyee Table',emp_table);

                        // Clear existing tbody content
                        $('#empl_table tbody').empty();

                        // Populate tbody with new data
                        for (var i = 0; i < emp_table.length; i++) {
                            var row = emp_table[i];
                            $('#empl_table tbody').append(
                                '<tr>' +
                                '<td>' + (i + 1) + '</td>' +
                                '<td>' + row['designation'] + '</td>' +
                                '<td>' + row['Name']  + ' / ' + row['tno'] + '</td>' +
                                '<td>' + row['DeptName'] + '</td>' +
                                '<td>' + row['Actual_DesignationName'] + '</td>' +
                                '</tr>'
                            );
                        }
                          // Clear existing options
                          $('.Auditor_select').empty();

                            // Append the "--Select Team--" option first
                            $('.Auditor_select').append('<option value=""> --Select Auditor Name -- </option>');

                            // Populate dropdown with new options
                            $.each(emp_table, function(index, option) {
                                var AuditorOption = $('<option>', {
                                    value: option.Alloc_emplno,
                                    text: option.Name + ' / ' + option.tno
                                });

                                $('.Auditor_select').append(AuditorOption);
                            });
                            $('.Auditor_select').trigger('change');

                    }
                }
            });
        }
    </script>

    <!-- // FOR SELECTED DIVISION & TEAM   -->
    <script>
        function zonevalue(team_id) {

            var selected_team = team_id;
            // var selected_div = $('[name="div"]').val();
            console.log(selected_team);

            $.ajax({
                url: "{{ route('audit_entry4') }}",
                type: "GET",
                data: {
                    selected_team: selected_team,
                    // selected_div: selected_div,
                },
                dataType: 'json',
                success: function(zone) {
                    if (zone.length > 0) {
                        console.log(zone);

                        // Clear existing options
                        $('.zone_nam').empty();

                        // Append the "--Select Team--" option first
                        $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                        // Populate dropdown with new options
                        $.each(zone, function(index, option) {
                            var zoneOption = $('<option>', {
                                value: option.zone_id,
                                text: option.Zone
                            });

                            $('.zone_nam').append(zoneOption);
                        });

                        // Trigger change event to update hidden input
                        $('.zone_nam').trigger('change');
                    }
                }
            });
        }
    </script>


    <!-- <script>
        function zonevalue(div_id) {
            var selected_div = div_id;

            $.ajax({
                url: "{{ route('audit_entry1') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                },
                dataType: 'json',
                success: function(option) {
                    if (option.length > 0) {
                        console.log(option);

                        var Team = option[0].Team;
                        var Team_id = option[0].Team_id;
                        var Zone = option[0].Zone;
                        var Rowid = option[0].Rowid;

                        $('.team_nam').val(Team);
                        $('.team_id').val(Team_id);
                        $('.zone_nam').val(Zone);
                        $('.zone_id').val(Rowid);


                    }
                }
            });
        }
    </script> -->



<script>
    function changeS(checkpnt_id) {
     
            var divID = $('[name="div"]').val();
            var teamId = $('[name="team_nam"]').val();
            var ZoneID = $('[name="zone_nam"]').val();
            var Edate = $('[name="edate"]').val();
            var Types = $('[name="type_s"]').val();
            console.log(divID, teamId, ZoneID, Edate, checkpnt_id, 'IDs');

      if (divID == "" || teamId == "" || ZoneID == "" || Edate == "") {
                // $('[name="type_s"]').val('');
                // $('[name="type_s"]').val('');
                // $('#type_s').val('');

                alert("Choose All Options Division, Team, Zone, Edate is Empty to Check Already Entered. ");
            } else {
                // TO VIEW CHECK POINTS
        $.ajax({
            url: "{{ route('audit_chklst') }}",
            type: "GET",
            data: { checkpnt_id: checkpnt_id },
            dataType: 'json',
            success: function(Checkpnt) {
                console.log('Audit check point', Checkpnt);
                // if (Checkpnt.length >0) {
                    
                    // Get the table body
                    const tableBody = document.getElementById('tableBody');
                    
                    // Clear any existing rows
                    tableBody.innerHTML = '';

                    // Iterate over the Checkpnt array and build new rows
                    Checkpnt.forEach((item, index) => {
                        // Create a new table row
                        const tr = document.createElement('tr');
                        
                        //-------- SNO ------------//
                        const snoCell = document.createElement('td');
                        snoCell.textContent = index + 1; // assuming index starts at 0
                        tr.appendChild(snoCell);

                        //-------- CHECK POINT ------------//
                        // Create cell for Check Point (you can customize what to show)
                        const checkpointCell = document.createElement('td');
                        checkpointCell.textContent = item.Check_point + " / " + item.Tamil;
                        tr.appendChild(checkpointCell);

                          
                        //-------- CHECK POINT ID ------------//
                        const ChkIDCell = document.createElement('td');
                        ChkIDCell.style.display = 'none'; // hide the cell
                        const ChkIDinput = document.createElement('input');

                        ChkIDinput.type = 'hidden'; 
                        ChkIDinput.name = 'check[]';
                        ChkIDinput.classList.add('form-control');
                        ChkIDinput.value = item.CheckPoint_ID || '';
                        ChkIDinput.setAttribute('readonly', true); 

                        ChkIDCell.appendChild(ChkIDinput); 
                        tr.appendChild(ChkIDCell); 

                       // Alloted cell
                        // const allotedCell = document.createElement('td');
                        // // Assuming the response contains an "Alloted" field. If not, set a default value.
                        // allotedCell.textContent = item.Marks || '';
                        // tr.appendChild(allotedCell);
                        
                        //-------- ALLOTED ------------//
                        const allotedCell = document.createElement('td');
                        const allocteinput = document.createElement('input');

                        allocteinput.type = 'text'; 
                        allocteinput.name = 'alloted[]';
                        allocteinput.classList.add('form-control');
                        allocteinput.value = item.Marks || '';
                        allocteinput.setAttribute('readonly', true); 

                        allotedCell.appendChild(allocteinput); 
                        tr.appendChild(allotedCell); 

                        //-------- AUDITED ------------//
                        const auditedCell = document.createElement('td');
                        const input = document.createElement('input');
                        input.type = 'text';
                        input.name = 'audit[]';
                        input.classList.add('form-control');
                        input.required = true; 
                        auditedCell.appendChild(input);
                        tr.appendChild(auditedCell);


                        //-------- REMARKS ------------//
                        const RemarksCell = document.createElement('td');
                        const Reminput = document.createElement('input');
                        Reminput.type = 'text';
                        Reminput.name = 'Auditremark[]';
                        Reminput.classList.add('form-control');
                        RemarksCell.appendChild(Reminput);
                        tr.appendChild(RemarksCell);

                        // Append the row to the table body
                        tableBody.appendChild(tr);

                       // Retrieve the allotted value for validation (convert to float)
                        let allotedValue = parseFloat(item.Marks) || 0;

                        // Add validation: Audited value should not exceed Alloted
                        input.addEventListener('input', function() {
                            var auditedValue = parseFloat(input.value);
                            if (isNaN(auditedValue) || auditedValue > allotedValue) {
                                alert("Audited marks cannot exceed allotted marks!");
                                input.value = ''; // Reset input if condition fails
                            }
                        });

                        // Allow only numeric input in the Audited field
                        input.addEventListener('keypress', function(event) {
                            var charCode = event.which ? event.which : event.keyCode;
                            // Allow numbers (48-57), backspace (8), delete (46)
                            if (charCode !== 8 && charCode !== 46 && (charCode < 48 || charCode > 57)) {
                                event.preventDefault();
                            }
                        });
                    });
                // }
               

            },
            error: function(error) {
                console.log('Error fetching data:', error);
            }
        });

         // TO CHECK ALREDY ENTERED
                $.ajax({
                    url: "{{ route('Audit_Check') }}",
                    type: "GET",
                    data: {
                        divID: divID,
                        teamId: teamId,
                        ZoneID: ZoneID,
                        Edate: Edate,
                        checkpnt_id: checkpnt_id,
                    },
                    dataType: 'json',
                    success: function(Aud_Chk) {
                        console.log('Audit Check Already Entered', Aud_Chk);

                        if (Aud_Chk.length > 0) {
                            $('#modalConfirm').modal('show');

                            $('.YES').off('click').on('click', function() {
                                $('#modalConfirm').modal('hide');
                            });

                            $('.NO').off('click').on('click', function() {
                                location.reload();
                            });
                        }
                    },
                    error: function(error) {
                        console.log('Error fetching data:', error);
                    }
                });
         }
    }
</script>


    <!-- // FOR SELECTED CHECK POINT ALLOTED MARKS  -->
    <script>
        function checkvalue(check_id, selectElement) {
            var selected_check = check_id;

            $.ajax({
                url: "{{ route('audit_entry2') }}",
                type: "GET",
                data: {
                    selected_check: selected_check,
                },
                dataType: 'json',
                success: function(check_id) {
                    console.log(check_id);
                    if (check_id.length > 0) {
                        // console.log(select);

                        var Marks = check_id[0].Marks;


                        $(selectElement).closest('tr').find('.alloted').val(Marks);


                    }
                }
            });
        }
    </script>


    <!-- // FOR AUDITED  -->
    <script>
        function addRow() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody");

            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            var cell5 = newRow.insertCell(4);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check[]" id="check' + (table.rows.length - 1) + '" onchange="checkvalue(this.value , this)" required>' +
                '<option value="">--Select Check point--</option>' +
                '@foreach ($Check_point as $check)' +
                '<option value="{{$check['check_id']}}">{{$check['Check_point']}}</option>' +
                '@endforeach' +
                '</select>';
            cell3.innerHTML = '<input type="text" name="alloted[]" id="alloted' + (table.rows.length - 1) + '" class="form-control alloted" readonly required>'; // Alloted
            cell4.innerHTML = '<input type="text" name="audit[]" id="audit' + (table.rows.length - 1) + '" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57" oninput="validateMarks(this)" required>'; // Audited
            cell5.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            updateTotal();
        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        function updateTotal() {
            var table = document.getElementById("app_table");
            var totalInput = document.getElementById("total");
            var total = 0;

            for (var i = 1; i < table.rows.length; i++) {
                var marksInput = table.rows[i].cells[3].querySelector('input');
                if (marksInput && !isNaN(parseFloat(marksInput.value))) {
                    total += parseFloat(marksInput.value);
                }
            }

            totalInput.value = total;
        }

        function validateMarks(input) {
            var row = input.parentNode.parentNode;
            var allotedInput = row.cells[2].querySelector('input');
            var auditInput = input.value;

            if (parseFloat(auditInput) > parseFloat(allotedInput.value)) {
                alert("Audited marks cannot exceed allotted marks!");
                input.value = ''; // Clear the input field
            }
        }
    </script>


    <!-- // FOR AUDITED  -->
    <!-- <script>
        function addRow() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody");


            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            var cell5 = newRow.insertCell(4);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check[]" id="check" onchange="checkvalue(this.value , this)"' + (table.rows.length - 1) + ' required>' +
            '<option value="">--Select Check point--</option>'+
            '@foreach ($Check_point as $check)'+
            '<option value="{{$check['check_id']}}">{{$check['Check_point']}}</option>'+
            '@endforeach'+
            '</select>';
            cell3.innerHTML = '<input type="text" name="alloted[]" id="alloted" class="form-control alloted" readonly  required>'; // Alloted
            cell4.innerHTML = '<input type="text" name="audit[]" id="audit' + (table.rows.length - 1) + '" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57" required>'; // Audited
            cell5.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Initialize Select2 using ID
            // $(document).ready(function() {
            //     $('#check' + (table.rows.length - 1)).select2();
            // });

            updateTotal();
        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        function updateTotal() {
            var table = document.getElementById("app_table");
            var totalInput = document.getElementById("total");
            var total = 0;

            for (var i = 1; i < table.rows.length; i++) {
                var marksInput = table.rows[i].cells[3].querySelector('input');
                if (marksInput && !isNaN(parseFloat(marksInput.value))) {
                    total += parseFloat(marksInput.value);
                }
            }

            totalInput.value = total;
        }

       
    </script> -->


    <!-- // FOR REMARKS  -->
    <script>
        function addRow1() {
            var table = document.getElementById("app_table1");
            var tbody = document.getElementById("tableBody1");

            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            // var cell5 = newRow.insertCell(4);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name = "check1[]" id="check1' + (table.rows.length - 1) + '" ><option value="">--Select Check point--</option>@foreach($Check_point as $check)<option value="{{$check['check_id']}}">{{$check['Check_point']}}</option>@endforeach</select>'; // Checklist
            // cell3.innerHTML = '<input type="text" name="audited1[]" id="audited1" class="form-control"  >'; // Alloted
            cell3.innerHTML = '<input type="text" name="remark[]" id="remark" class="form-control" >'; // Audited
            cell4.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Initialize Select2 using ID
            // $(document).ready(function() {
            //     $('#check1' + (table.rows.length - 1)).select2();
            // });

            updateTotal();
        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        function updateTotal() {
            var table = document.getElementById("app_table1");
            var totalInput = document.getElementById("total");
            var total = 0;

            for (var i = 1; i < table.rows.length; i++) {
                var marksInput = table.rows[i].cells[3].querySelector('input');
                if (marksInput && !isNaN(parseFloat(marksInput.value))) {
                    total += parseFloat(marksInput.value);
                }
            }

            totalInput.value = total;
        }
    </script>


    <!-- // FOR EMPLOYEE ALLOCATION TABLE -->
    <script>
        function toggleTableVisibility() {
            var table = document.getElementById("empl_table");

            // Check if there are no rows in the table
            if (table.rows.length === 1) { // Assuming the first row is the header
                alert("Select The Division .");
                return;
            }

            if (table.style.display === "none") {
                table.style.display = "table";
            } else {
                table.style.display = "none";
            }
        }
    </script>



    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('edate').value = getCurrentDate();
    </script>

    <!-- // FOR SHOWING LAST 7 DAYS  -->
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const edate = document.getElementById("edate");
        const today = new Date();

        // Format date function YYYY-MM-DD
        function formatDate(date) {
            let d = date.getDate();
            let m = date.getMonth() + 1;
            let y = date.getFullYear();
            if (d < 10) d = "0" + d;
            if (m < 10) m = "0" + m;
            return y + "-" + m + "-" + d;
        }

        // Today
        const maxDate = formatDate(today);

        // 7 days back
        const pastDate = new Date();
        pastDate.setDate(today.getDate() - 7);
        const minDate = formatDate(pastDate);

        // Apply restrictions
        edate.setAttribute("min", minDate);
        edate.setAttribute("max", maxDate);
    });
</script>

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 15000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 20000);
    </script>


    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#div, #type_s, #type_audit').select2();
        });
    </script>


    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>