<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<title>Calendar </title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

	<link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

	<link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

	<link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

	<link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
	<link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

	<link rel="stylesheet" href="assets/css/5s/select2.min.css">

	<!-- <link rel="stylesheet" href="assets/plugins/5s/fullcalendar/fullcalendar.min.css"> -->

	<link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

	<link rel="stylesheet" href="assets/css/5s/style.css">

	<!-- Include Bootstrap CSS if not already included -->
	<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
	<!-- Include FullCalendar CSS -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" rel="stylesheet">

	<!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

	<!-- ---------- FOR TIME PICKER ----------- -->
	<!-- Include flatpickr CSS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

	<!-- Include flatpickr JS -->
	<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>


	<style>
		.table-container {
			overflow-x: auto;
			max-height: 400px;
			/* Set a maximum height for the scrollable table */
		}
	</style>

</head>

<body>

	@extends('FiveS.5s_nav')
	@section('content')


	<div class="page-wrapper">
		<div class="content container-fluid">
			<div class="page-header">
				<!-- ... (unchanged) ... -->
				<div class="col-lg-6 col-md-6 col-sm-6 col-12">
					<h5 class="text-uppercase mb-0 mt-0 page-title">Calendar </h5>
				</div>
			</div>

			<!-- -----// ADD EVENT //---- -->
			<div class="row">
				<div class="col-sm-8 col-4">
				</div>
				<div class="col-sm-4 col-8 text-right add-btn-col">
					<a href="#" class="btn btn-primary btn-rounded" data-toggle="modal" data-target="#add_event"><i class="fas fa-plus"></i> Add Event</a>
				</div>
			</div>

			<div class="row">
				<!-- -----// CALENDAR //---- -->
				<div class="col-md-12 col-lg-12 col-xl-12">
					<div class="card">
						<div class="card-body">
							<div id="calendar"></div>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
	<!-- -----// EVENTS LIST //---- -->
	<div id="add_event" class="modal custom-modal fade" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Add Event</h4>

					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">

					<form id="validate" method="POST" action="{{ route('calendar_save') }}">
						@csrf
						<div class="form-group">
							<label>Event Name <span class="text-danger">*</span></label>
							<input class="form-control" type="text" placeholder="Enter Event Name" name="event_nam">
						</div>
						<div class="form-group">
							<label>Event Date <span class="text-danger">*</span></label>
							<input class="form-control" type="date" name="edate" id="edate">
						</div>
						<div class="form-group">
							<label>Type </label>
							<select class="form-control form-white" name="type">
								<option value="">-- Select Type --</option>
								<option value="Success">Success</option>
								<option value="Danger">Danger</option>
								<option value="Primary">Primary</option>
								<option value="Warning">Warning</option>
							</select>
						</div>

						<div class="row">
							<div class="col-lg-6 col-md-6">
								<div class="form-group">
									<label>Start Time <span class="text-danger">*</span></label>
									<input class="form-control timepicker" type="text" name="start_time">
								</div>
							</div>
							<div class="col-lg-6 col-md-6">
								<div class="form-group">
									<label>End Time <span class="text-danger">*</span></label>
									<input class="form-control timepicker" type="text" name="end_time">
								</div>
							</div>
						</div>

						<div class="form-group">
							<label>Location <span class="text-danger">*</span></label>
							<input class="form-control" type="text" placeholder="Enter Location" name="location">
						</div>
						<div class="form-group">
							<label>Description <span class="text-danger">*</span></label>
							<textarea class="form-control" rows="4" name="descrip" id="descrip" placeholder="Enter Description"></textarea>
						</div>
						<div class="submit-section">
							<input type="submit" name="submit" value="Submit" id="save" class="btn btn-primary">

							<!-- <button class="btn btn-primary submit-btn">Submit</button> -->
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>

	<!-- -----// MY EVENTS  //---- -->
	<div class="modal custom-modal fade none-border" id="my_event">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"> Event Details </h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				</div>
				<div class="modal-body">
					<div class="card">
						<div class="card-body">
							<div class="row">
								<div class="col-lg-6">
									<h5 class="card-title">Event Name</h5>
									<p class="card-text"><span id="event_name">Meeting</span></p>
								</div>
								<div class="col-lg-6">
									<h5 class="card-title">Event Date</h5>
									<p class="card-text"><span id="event_date">23/02/2024</span></p>
								</div>
							</div>
							<hr>
							<div class="row">
								<div class="col-lg-6">
									<h5 class="card-title">Event Type</h5>
									<p class="card-text"><span id="event_type">Your Event Type</span></p>
								</div>
								<div class="col-lg-6">
									<h5 class="card-title">Start Time - End Time</h5>
									<p class="card-text"><span id="start_time">Start Time</span> - <span id="end_time">End Time</span></p>
								</div>
							</div>
							<hr>
							<div class="row">
								<div class="col-lg-6">
									<h5 class="card-title">Location</h5>
									<p class="card-text"><span id="event_location">Your Location</span></p>
								</div>
								<div class="col-lg-6">
									<h5 class="card-title">Description</h5>
									<p id="event_description">Your Event Description</p>
								</div>

							</div>

							<hr>
							<button class="btn btn-primary" id="edit_event_button">Edit Event</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>



	<!-- ----------------------------- SCRIPTS ------------------------ -->

	<!-- ---------- CALENDAR SCRIPT ----------- -->
	<script>
		$(document).ready(function() {
			var calendar = $('#calendar').fullCalendar({
				header: {
					left: 'prev,next today',
					center: 'title',
					right: 'month,agendaWeek,agendaDay'
				},
				events: <?php echo $events; ?>,
				dayClick: function(date, jsEvent, view) {
					// Check if the clicked date is before the current date
					if (date.isBefore(moment(), 'day')) {
						// If it's before the current date, do not open the modal
						return;
					}

					// Open the modal when a day is clicked
					$('#add_event').modal('show');

					// Set the selected date in the modal input
					$('#edate').val(date.format('YYYY-MM-DD'));

					// Set the selected date in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', date.format('YYYY-MM-DD'));

					// Set the default time in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', moment().startOf('day').add(10, 'hours').format('HH:mm:ss'));
				},
				eventRender: function(event, element) {
					// Append the creator's name to the event title
					var eventTitle = event.title + ' - ' + event.creator + '';

					// Create a new element with the updated title
					var updatedElement = $('<div class="fc-content">').html(eventTitle);

					// Replace the original element's content
					element.find('.fc-content').replaceWith(updatedElement);
				},
				eventClick: function(calEvent, jsEvent, view) {
					// Open the modal when an event is clicked
					$('#my_event').modal('show');

					// Populate the modal with event details (modify as per your data structure)
					$('#event_name').text(calEvent.title);
					$('#event_date').text(calEvent.start.format('YYYY-MM-DD'));
					$('#event_type').text(calEvent.color);
					$('#start_time').text(calEvent.start.format('HH:mm'));
					$('#end_time').text(calEvent.end.format('HH:mm'));
					$('#event_location').text(calEvent.location);
					$('#event_description').text(calEvent.description);
				}
			});

			// Initialize date-time picker in the modal
			$('#add_event .datetimepicker').datetimepicker({
				format: 'YYYY-MM-DD HH:mm:ss',
				icons: {
					time: 'far fa-clock',
					date: 'far fa-calendar',
					up: 'fas fa-chevron-up',
					down: 'fas fa-chevron-down',
					previous: 'fas fa-chevron-left',
					next: 'fas fa-chevron-right',
					today: 'fas fa-calendar-check-o',
					clear: 'fas fa-trash-o',
					close: 'fas fa-times'
				}
			});
		});
	</script>


	<!-- <script>
		$(document).ready(function() {
			var calendar = $('#calendar').fullCalendar({
				header: {
					left: 'prev,next today',
					center: 'title',
					right: 'month,agendaWeek,agendaDay'
				},
				events: <?php echo $events; ?>,
				dayClick: function(date, jsEvent, view) {
					// Open the modal when a day is clicked
					$('#add_event').modal('show');
					// Set the selected date in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', date.format('YYYY-MM-DD'));
					// Set the default time in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', moment().startOf('day').add(10, 'hours').format('HH:mm:ss'));
				},
				eventClick: function(calEvent, jsEvent, view) {
					// Open the modal when an event is clicked
					$('#my_event').modal('show');

					// Populate the modal with event details (modify as per your data structure)
					$('#my_event input[name="event_nam1"]').val(calEvent.title);
					$('#my_event input[name="edate1"]').val(calEvent.start.format('YYYY-MM-DD'));
					$('#my_event input[name="type1"]').val(calEvent.color);
					$('#my_event input[name="start_time1"]').val(calEvent.start.format('HH:mm'));
					$('#my_event input[name="end_time1"]').val(calEvent.end.format('HH:mm'));
					$('#my_event input[name="location1"]').val(calEvent.location);
					$('#my_event textarea[name="descrip1"]').val(calEvent.description);
				}
			});

			// Initialize date-time picker in the modal
			$('#add_event .datetimepicker').datetimepicker({
				format: 'YYYY-MM-DD HH:mm:ss',
				icons: {
					time: 'far fa-clock',
					date: 'far fa-calendar',
					up: 'fas fa-chevron-up',
					down: 'fas fa-chevron-down',
					previous: 'fas fa-chevron-left',
					next: 'fas fa-chevron-right',
					today: 'fas fa-calendar-check-o',
					clear: 'fas fa-trash-o',
					close: 'fas fa-times'
				}
			});
		});
	</script> -->


	<!-- -----// CALENDAR SCRIPT //----
	<script>
		$(document).ready(function() {
			var calendar = $('#calendar').fullCalendar({
				header: {
					left: 'prev,next today',
					center: 'title',
					right: 'month,agendaWeek,agendaDay'
				},
				events: [{
						title: 'Meeting with Client',
						start: '2024-02-21T10:00:00',
						end: '2024-02-21T12:00:00',
						date: '2024-02-22',
						color: 'red'
					},
					// Add more events as needed
				],
				dayClick: function(date, jsEvent, view) {
					// Open the modal when a day is clicked
					$('#add_event').modal('show');

					// Set the selected date in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', date.format('YYYY-MM-DD'));

					// Set the default time in the modal input
					$('#add_event .datetimepicker').datetimepicker('date', moment().startOf('day').add(10, 'hours').format('HH:mm:ss'));
				}
			});

			// Initialize date-time picker in the modal
			$('#add_event .datetimepicker').datetimepicker({
				format: 'YYYY-MM-DD HH:mm:ss',
				icons: {
					time: 'far fa-clock',
					date: 'far fa-calendar',
					up: 'fas fa-chevron-up',
					down: 'fas fa-chevron-down',
					previous: 'fas fa-chevron-left',
					next: 'fas fa-chevron-right',
					today: 'fas fa-calendar-check-o',
					clear: 'fas fa-trash-o',
					close: 'fas fa-times'
				}
			});
		});
	</script> -->



	<!-- ---------- FOR TIME PICKER ----------- -->
	<script>
		document.addEventListener('DOMContentLoaded', function() {
			// Initialize flatpickr for time only in 12-hour format
			flatpickr('.timepicker', {
				enableTime: true,
				noCalendar: true,
				dateFormat: 'h:i K', // Updated format for 12-hour time
				time_24hr: false // Set to false for 12-hour time
			});
		});
	</script>


	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


	<script src="assets/js/5s/popper.min.js"></script>

	<script src="assets/js/5s/bootstrap.bundle.min.js"></script>

	<script src="assets/js/5s/jquery.slimscroll.js"></script>

	<script src="assets/js/5s/select2.min.js"></script>

	<script src="assets/js/5s/moment.min.js"></script>
	<script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

	<script src="assets/js/5s/app.js"></script>

	<!-- Include jQuery -->
	<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
	<!-- Include Bootstrap JS if not already included -->
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
	<!-- Include FullCalendar JS -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.js"></script>

	@endsection

</body>

</html>