<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>CHECK LIST ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
    <style>
        .total {
            margin-left: 475px;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>

</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('check_save') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">checklist</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Effect From </label>
                                                <input type="date" class="form-control" id="eff" name="eff" required min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" id="date" name="date" value="" required min="<?php echo date('Y-m-d'); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of S</label>
                                                <select class="form-control " name="type_s" id="Select" required>
                                                    <option>--Select--</option>
                                                    @foreach($type_s as $type)
                                                    <option value="{{$type['Rowid']}}">{{$type['type_s']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Add Checklist</label>
                                                <div class="add-icon">
                                                    <a href="javascript:void(0);" id="addRowBtn" onclick="addRow()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>
                                    <!-- <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            
                                        </div>
                                    </div> -->
                                    <br>
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Checklist</th>
                                                    <th>Tamil </th>
                                                    <th>Marks</th>
                                                    <th>Edit</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tableBody">
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control" name="check[]" id="check" onchange="updateTamil(this)" required>
                                                            <option value="">--Select--</option>
                                                            @foreach ($checklist as $check)
                                                                <option value="{{$check['Rowid']}}" data-tamil="{{$check['Tamil']}}">{{$check['Check_point']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="tamil[]" id="tamil" class="form-control" readonly required>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="marks[]" id="marks" class="form-control" oninput="updateTotal()" pattern="[0-9]*" required>
                                                    </td>
                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>
                                            </tbody>

                                        </table>
                                    </div>
                                    <br>
                                    <div class="form-group row">
                                        <label for="check" class="col-sm-3 col-form-label total">Total </label>
                                        <div class="col-sm-2">
                                            <input type="text" class="form-control" id="total" name="total" readonly required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="d-flex justify-content-around pb-2">
                                        <button type="button" id="clearButton" class="btn btn-primary ml-5" onclick="clearPage()">CLEAR</button>
                                        <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-success">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/checkentry_Report'">Report</button>


                                        <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                        <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <script>
    function updateTamil(selectedOption) {
        var tamilInput = selectedOption.parentNode.parentNode.cells[2].getElementsByTagName('input')[0];
        var selectedTamil = selectedOption.options[selectedOption.selectedIndex].getAttribute('data-tamil');

        // Check if selectedTamil is null or undefined
        if (selectedTamil === null || selectedTamil === undefined || selectedTamil === "No Tamil Value") {
            tamilInput.value = '--';
        } else {
            tamilInput.value = selectedTamil;
        }
    }

    function confirmDelete(element) {
        // Add your delete confirmation logic here
        console.log("Delete confirmed");
    }
</script>




    <!-- // ADD ROWS   -->
    <script>
        function addRow() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody");


            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            var cell5 = newRow.insertCell(4);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check[]" id="check' + (table.rows.length - 1) + '" onchange="updateTamil(this)" required> ' +
                '<option value="">--Select--</option>' +
                '@foreach ($checklist as $check)' +
                '<option value="{{$check['Rowid']}}" data-tamil="{{$check['Tamil']}}">{{$check['Check_point']}}</option>' +
                '@endforeach' +
                '</select>';
            cell3.innerHTML = '<input type="text" name="tamil[]" id="tamil" class="form-control" readonly required>'; // Tamil
            cell4.innerHTML = '<input type="text" name="marks[]" id="marks" class="form-control" oninput="updateTotal()" required>'; // Marks
            cell5.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Initialize Select2 using ID
            $(document).ready(function() {
                // Update the ID to match the dynamically added row
                $('select[id^="Select"]').select2();
            });

            updateTotal();
        }


        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        // function updateTotal() {
        //     var table = document.getElementById("app_table");
        //     var totalInput = document.getElementById("total");
        //     var total = 0;

        //     for (var i = 1; i < table.rows.length; i++) {
        //         var marksInput = table.rows[i].cells[3].querySelector('input');
        //         if (marksInput && !isNaN(parseFloat(marksInput.value))) {
        //             total += parseFloat(marksInput.value);
        //         }
        //     }

        //     totalInput.value = total;
        // }

        function updateTotal() {
    var table = document.getElementById("app_table");
    var totalInput = document.getElementById("total");
    var total = 0;

    for (var i = 1; i < table.rows.length; i++) {
        var marksInput = table.rows[i].cells[3].querySelector('input');
        if (marksInput && !isNaN(parseFloat(marksInput.value))&& /^[0-9]*$/.test(marksInput.value)) {
            total += parseFloat(marksInput.value);
        } else {
            // Clear the input field if it contains invalid characters
            marksInput.value = '';
        }
    }

    totalInput.value = total;
}

    </script>


    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('date').value = getCurrentDate();
        document.getElementById('eff').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            // Update the ID to match the dynamically added row
            $('select[id^="Select"]').select2();
        });
    </script>

    <!-- <script>
    // Initialize Select2 using ID
    $(document).ready(function() {
        // Update the ID to match the dynamically added row
        $('.empSelect').select2();
    });
</script> -->


    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection
</body>

</html>