<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Employee Allocation Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- jQuery (Make sure it's included before Bootstrap JS) -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #fff;
            /* or another background color */
            z-index: 1;
        }
    </style>

    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')
    @endsection

    <div class="main-wrapper">
        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="page-header">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                            <h5 class="text-uppercase mb-0 mt-0 page-title">Employee Allocation Report</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">

                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <input type="text" id="searchInput" class="form-control" placeholder="Search...">
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table custom-table datatable" id="trainTable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SNO</th>
                                                <th>View</th>
                                                <th>ENO </th>
                                                <th>EDate </th>
                                                <th>Division</th>
                                                <th>Team</th>
                                                <th>Zone</th>
                                                <th>Entry By</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($EmplAlloc_Rep as $index => $EmplAlloc_Reps)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <button type="button" class="btn btn-warning ViewDetails" onclick="ViewDetails('{{ $EmplAlloc_Reps['Rowid'] }}')">
                                                        View
                                                    </button>

                                                </td>
                                                <td>{{ $EmplAlloc_Reps['ENO'] }}</td>
                                                <td>{{ date('Y-m-d', strtotime($EmplAlloc_Reps['EDate'])) }}</td>
                                                <td>{{ $EmplAlloc_Reps['Division'] }}</td>
                                                <td>{{ $EmplAlloc_Reps['Team'] }}</td>
                                                <td>{{ $EmplAlloc_Reps['Zone'] }}</td>
                                                <td>{{ $EmplAlloc_Reps['Name'] }} / {{ $EmplAlloc_Reps['tno'] }}</td>

                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <br>
                                <div class="col-md-12 col-lg-12 save">
                                    <div class="text-center">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/empl_alloc'">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="employeeDetailsModal" tabindex="-1" role="dialog" aria-labelledby="employeeDetailsLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="employeeDetailsLabel">Employee Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>SNO</th>
                                <th>Designation</th>
                                <th>Name</th>
                            </tr>
                        </thead>
                        <tbody id="employeeDetailsBody">
                            <!-- Data will be appended here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>



    <!-- // TO VIEW THE EMPLOYEE DETAILS   -->
    <script>
        function ViewDetails(Rowid) {
            console.log('Rowid', Rowid);

            $.ajax({
                url: "{{ route('EmplAlloc_Details') }}",
                type: "GET",
                data: {
                    Rowid: Rowid
                },
                dataType: 'json',
                success: function(employeeDetails) {
                    console.log('Employee Details', employeeDetails);
                    // Clear existing content
                    $('#employeeDetailsBody').empty();

                    // Loop through details and append table rows
                    employeeDetails.forEach(function(item, index) {
                        // Assuming designation and name are returned as shown in your data example
                        let row = `<tr>
                            <td>${index + 1}</td>
                            <td>${item.designation}</td>
                            <td>${item.Name}/${item.tno} </td>
                          </tr>`;
                        $('#employeeDetailsBody').append(row);
                    });

                    // Show the modal (using Bootstrap's modal method)
                    $('#employeeDetailsModal').modal('show');

                    document.querySelector('.close').addEventListener('click', function() {
                        $('#employeeDetailsModal').modal('hide'); // Bootstrap 4
                    });
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", xhr.responseText);
                }
            });
        }
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            $('#searchInput').on('keyup', function() {
                let filter = $(this).val().toLowerCase();
                $('#trainTable tbody tr').each(function() {
                    $(this).toggle($(this).text().toLowerCase().includes(filter));
                });
            });
        });
    </script>

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="assets/js/5s/popper.min.js"></script>
    <script src="assets/js/5s/jquery-3.6.0.min.js"></script>
    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>
    <script src="assets/js/5s/jquery.slimscroll.js"></script>
    <script src="assets/js/5s/jquery.dataTables.min.js"></script>
    <script src="assets/js/5s/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/5s/app.js"></script>


</body>

</html>