<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Employee Allocation</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('empl_alloc_save') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">employee allocation</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>ENO</label>
                                                <input type="text" class="form-control" name="Eno" value="<?php echo $eno; ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" id="date" name="date" required min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                        <!-- <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Area</label>
                                                <select class="form-control" name="AREA" id="AREA" required>
                                                    <option>--Select Area--</option>
                                                    @foreach ($area as $area1)
                                                    <option value="{{$area1['Rowid']}}">{{$area1['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div> -->
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Division </label>
                                                <select class="form-control " name="div" id="div" onchange="teamNamevalue(this.value)" required>
                                                    <option value=""> --Select Division --</option>
                                                    @foreach ($division as $div)
                                                    <option value="{{$div['Division_id']}}/{{$div['Comp_DivCode']}}">{{$div['Name']}}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Team </label>
                                                <select class="form-control team_select" name="team_nam" id="team_nam" onchange="zonevalue(this.value)" required>
                                                    <option value="">-- Select Team --</option>
                                                </select>
                                                <!-- <input type="text" class="form-control team_nam" readonly required> -->
                                                <!-- <input type="hidden" class="form-control team_id" name="team_id" id="team_id"> -->
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Zone </label>
                                                <select class="form-control zone_nam" name="zone_nam" id="zone_nam" onchange="CheckSameEntry(this.value)">
                                                    <option value="">-- Select Zone --</option>
                                                </select>
                                                <!-- <input type="text" class="form-control zone_nam" readonly required> -->
                                                <!-- <input type="hidden" class="form-control zone_id" name="zone_id" id="zone_id"> -->
                                            </div>
                                        </div>
                                        <div class="col-md-5 col-lg-5">
                                            <div class="form-group">
                                                <label>Empl Name Type </label>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <input type="radio" name="Names" value="1" checked class="form-group mt-3"> Staffs Name
                                                    </div>
                                                    <div class="col-lg-5">
                                                        <input type="radio" name="Names" value="0" class="form-group mt-3"> Local Workers Name
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>5S Designation</th>
                                                    <th>Employee Name</th>
                                                    <th>Department</th>
                                                    <th>Designation</th>
                                                    <th>Delete</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($design as $index => $des)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        <input type="hidden" class="form-control" name="designation[]" id="designation" value="{{ $des['Rowid'] }}">
                                                        {{ $des['Name'] }}
                                                    </td>
                                                    <td>
                                                        <select class="form-control empl-dropdown" name="Empl_nam[]" required>
                                                            <option value="">-- Select Empl Name --</option>

                                                        </select>
                                                    </td>
                                                    <td><input type="text" class="form-control dept-field" name="dept" readonly></td>
                                                    <td><input type="text" class="form-control design-field" name="design" readonly></td>
                                                    <td>
                                                        @if($des['Rowid'] == 28 || $des['Rowid'] == 29)
                                                        <button type="button" class="btn btn-danger btn-sm delete-row" title="Delete">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                </div>

                                <div class="col-lg-12 col-md-12">
                                    <div class="d-flex justify-content-around pb-2">
                                        <button type="button" id="clearButton" class="btn btn-primary ml-5" onclick="clearPage()">CLEAR</button>
                                        <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-success">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/Emplalloc_Report'">Report</button>

                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteConfirmModal" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteConfirmModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this row?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">NO</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">YES</button>
                </div>
            </div>
        </div>
    </div>





    <!-- // FOR CHECKING ALREADY &TO VIEW //& // FOR STAFF AND LOCAL WORKS OPTIONS CHANGE  -->
    <script>
        // Make updateEmployeeDropdown a global function.
        function updateEmployeeDropdown() {
            try {
                var selectedValue = $("input[name='Names']:checked").val();
                console.log('Selected Name Type:', selectedValue);

                // var Divid = $('[name="div"]').val();
                // var Divid = "3";
                var selected_div = $('[name="div"]').val();
                var div = selected_div.split('/');
                var DivID = div[1];


                $(".empl-dropdown").each(function() {
                    // $(document).on('change', '.empl-dropdown', function() {
                    var dropdown = $(this);
                    // dropdown.empty().append('<option value="">-- Select Empl Name --</option>');

                    // // Clear the corresponding department and designation fields
                    // var $row = dropdown.closest('tr');
                    // $row.find('.dept-field').val('');
                    // $row.find('.design-field').val('');

                    if (selectedValue == "1") {
                        var Type = "1";
                    } else {
                        var Type = "2";
                    }
                    console.log('Staff or Local Type ', Type);

                    // NAME CHANGE
                    $.ajax({
                        url: "{{ route('emplalloc_NameChange') }}",
                        type: "GET",
                        data: {
                            selected_div: DivID,
                            Type: Type,
                        },
                        dataType: 'json',
                        success: function(Divwise_Name) {

                            if (Divwise_Name.length > 0) {
                                // console.log('Division Wise Name Change RAdio', Divwise_Name);

                                // Loop through the response and append options
                                $.each(Divwise_Name, function(index, item) {
                                    dropdown.append(`
                            <option 
                                value="${item.Emplno}" 
                                data-dept="${item.DeptName}" 
                                data-design="${item.DesignationName}">
                                ${item.Name} / ${item.tno}
                            </option>
                           `);
                                });
                                // $(document).ready(function() {
                                //     $('.empl-dropdown').select2();
                                // });
                            } else {
                                alert('Division Wise Name did not Pass.');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('AJAX Error:', status, error);
                        }
                    });
                });
            } catch (error) {
                alert('Error Message: ' + error.message);
                console.error('Catch Error:', error);
            }
        }

        // Handle dropdown change event to update department and designation
        $(document).on('change', '.empl-dropdown', function() {
            var selectedOption = $(this).find('option:selected');
            var dept = selectedOption.data('dept');
            var design = selectedOption.data('design');

            var $row = $(this).closest('tr');
            $row.find('.dept-field').val(dept);
            $row.find('.design-field').val(design);
        });

        // Run this when the document is ready
        $(document).ready(function() {
            // Initial population of the dropdown options
            // updateEmployeeDropdown();

            // Update on radio button change
            $("input[name='Names']").change(function() {
                var selected_div = $('[name="div"]').val();
                if (selected_div == "") {
                    alert('Please Choose the Division Name');
                } else {
                    updateEmployeeDropdown();
                }
            });
        });
    </script>

    <!-- // FOR CHECKING ALREADY &TO VIEW -->
    <script>
        function CheckSameEntry(Zoneid) {
            try {
                var Divid = $('[name="div"]').val();
                var div = Divid.split('/');
                var DivID = div[0];

                var Teamid = $('[name="team_nam"]').val();
                console.log(Divid, Teamid, Zoneid);

                $.ajax({
                    url: "{{ route('emplalloc_SameEntry') }}",
                    type: "GET",
                    data: {
                        Divid: DivID,
                        Teamid: Teamid,
                        Zoneid: Zoneid
                    },
                    dataType: 'json',
                    success: function(Same_Entry) {
                        console.log('Same entry:', Same_Entry);
                        if (Same_Entry.length > 0) {

                            let entryMap = {};
                            $.each(Same_Entry, function(_, entry) {
                                entryMap[entry.DesignationID] = entry;
                            });

                            $('#app_table tbody tr').each(function() {
                                var $row = $(this);
                                var rowDesignationID = $row.find('input[name="designation[]"]').val();
                                var $dropdown = $row.find('.empl-dropdown');

                                if (entryMap[rowDesignationID]) {
                                    let matchingEntry = entryMap[rowDesignationID];
                                    var name = matchingEntry.Name;
                                    var emplno = matchingEntry.Alloc_emplno;
                                    var tno = matchingEntry.tno;
                                    var dept = matchingEntry.DeptName;
                                    var design = matchingEntry.DesignationName;

                                    // Remove previously added first entry
                                    $dropdown.find('.added-first').remove();

                                    // Remove previous matching entry but keep other options
                                    $dropdown.find(`option[value="${emplno}"]`).not('.added-first').remove();

                                    // Prepend the matching employee as the first option
                                    $dropdown.prepend(`<option value="${emplno}" class="added-first" data-dept="${dept}" data-design="${design}" selected>${name} / ${tno}</option>`);

                                    // Update the department and designation fields
                                    $row.find('.dept-field').val(dept);
                                    $row.find('.design-field').val(design);

                                    // Trigger change event to update UI
                                    $dropdown.trigger('change');
                                }
                            });

                        } else {
                            updateEmployeeDropdown();
                        }
                    }
                });
            } catch (error) {
                alert('Error Message: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- // FOR TEAM AND NAME CHNAGE  -->
    <script>
        function teamNamevalue(div_id) {
            try {
                var selected_div = div_id.split('/');

                var DivID = selected_div[0];
                var Comp_DivID = selected_div[1];
                // var selected_div = "3";
                console.log('Company Division', Comp_DivID);
                if (Comp_DivID == "") {
                    alert('There is No Company Division Code in the Master Table Add it.');
                } else {


                    var selectedValue = $("input[name='Names']:checked").val();
                    console.log('Selected Name Type:', selectedValue);

                    if (selectedValue == "1") {
                        var Type = "1";
                    } else {
                        var Type = "2";
                    }


                    // TEAM CHANGE
                    $.ajax({
                        url: "{{ route('empl_alloc1') }}",
                        type: "GET",
                        data: {
                            selected_div: DivID,
                        },
                        dataType: 'json',
                        success: function(team) {
                            if (team.length > 0) {
                                console.log(team);

                                // Clear existing options
                                $('.team_select').empty();

                                // Append the "--Select Team--" option first
                                $('.team_select').append('<option value=""> --Select Team -- </option>');

                                // Populate dropdown with new options
                                $.each(team, function(index, option) {
                                    var teamOption = $('<option>', {
                                        value: option.Team_id,
                                        text: option.Team
                                    });

                                    $('.team_select').append(teamOption);
                                });

                                // Trigger change event to update hidden input
                                $('.team_select').trigger('change');
                            }
                        }
                    });

                    // NAME CHANGE
                    $.ajax({
                        url: "{{ route('emplalloc_NameChange') }}",
                        type: "GET",
                        data: {
                            selected_div: Comp_DivID,
                            Type: Type,
                        },
                        dataType: 'json',
                        success: function(Divwise_Name) {
                            console.log('Division Wise Name Change', Divwise_Name);

                            // Target the select dropdown
                            let dropdown = $(".empl-dropdown");

                            // Clear previous options
                            dropdown.empty();
                            dropdown.append('<option value="">-- Select Empl Name --</option>');

                            // Loop through the response and append options
                            $.each(Divwise_Name, function(index, item) {
                                dropdown.append(`
                            <option 
                                value="${item.Emplno}" 
                                data-dept="${item.DeptName}" 
                                data-design="${item.DesignationName}">
                                ${item.Name} / ${item.tno}
                            </option>
                        `);
                            });


                        },
                        error: function(xhr, status, error) {
                            console.error('AJAX Error:', status, error);
                        }
                    });
                }
            } catch (error) {
                alert('Error Message: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- // FOR SELECTED DIVISION & TEAM   -->
    <script>
        function zonevalue(team_id) {
            try {
                var selected_team = team_id;
                var selected_div = $('[name="div"]').val();
                var div = selected_div.split('/');
                var DivID = div[0];

                console.log(selected_team, DivID);

                $.ajax({
                    url: "{{ route('empl_alloc2') }}",
                    type: "GET",
                    data: {
                        selected_team: selected_team,
                        selected_div: DivID,
                    },
                    dataType: 'json',
                    success: function(zone) {
                        if (zone.length > 0) {
                            console.log(zone);

                            // Clear existing options
                            $('.zone_nam').empty();

                            // Append the "--Select Team--" option first
                            $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                            // Populate dropdown with new options
                            $.each(zone, function(index, option) {
                                var zoneOption = $('<option>', {
                                    value: option.Zone_id,
                                    text: option.Zone
                                });

                                $('.zone_nam').append(zoneOption);
                            });

                            // Trigger change event to update hidden input
                            $('.zone_nam').trigger('change');
                        }
                    }
                });
            } catch (error) {
                alert('Error Message: ' + error.message);
                console.error('Catch Error:', error);
            }
        }
    </script>

    <!-- // FOR SELECTED PERSONS DEPT DESIGN   -->
    <script>
        // Add a change event listener to the employee dropdowns
        $(document).ready(function() {
            $(document).on('change', '.empl-dropdown', function() {
                // Get the selected option element
                var selectedOption = $(this).find('option:selected');
                console.log("Selected option data-dept:", selectedOption.data('dept'));
                console.log("Selected option data-design:", selectedOption.data('design'));

                // Find the parent row
                var currentRow = $(this).closest('tr');
                console.log("Current row:", currentRow);

                // Update the department and designation fields within this row
                currentRow.find('.dept-field').val(selectedOption.data('dept'));
                currentRow.find('.design-field').val(selectedOption.data('design'));
            });
        });
    </script>


    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('date').value = getCurrentDate();
        document.getElementById('eff').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#AREA,#div,#Empl').select2();
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.empl-dropdown').select2();
        });
    </script>

    <!-- SEARCH for Employee Name column -->
    <!-- <script>
    // Initialize Select2 for Employee Name column
    $(document).ready(function() {
        $('#Empl_nam').select2({
            width: '100%', // Adjust the width as needed
            placeholder: '-- Select --',
            allowClear: true, // Adds a clear button to the dropdown
            minimumResultsForSearch: 1 // Display search input when at least 1 option is available
        });
    });
</script> -->

    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <!-- DELETING THE ROW -->
    <script>
        // This variable will store the row to be deleted
        var rowToDelete;

        $(document).on('click', '.delete-row', function() {
            // Save the row reference
            rowToDelete = $(this).closest('tr');
            // Show the modal
            $('#deleteConfirmModal').modal('show');
        });

        // Handle the confirmation button click
        $('#confirmDelete').on('click', function() {
            if (rowToDelete) {
                rowToDelete.remove();
                rowToDelete = null;
            }
            // Hide the modal
            $('#deleteConfirmModal').modal('hide');
        });
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection
</body>

</html>