<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>5S Kpi Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <link rel="stylesheet" href="assets/css/5s/select2.min.css">


    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>


    <!-- Include jQuery and Select2 libraries -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/js/select2.min.js"></script>



    <style>
        .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #fff;
            /* or another background color */
            z-index: 1;
        }
    </style>

    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')
    @endsection


    <div class="main-wrapper">
        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="page-header">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                            <h5 class="text-uppercase mb-0 mt-0 page-title">5S Kpi Report</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">

                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-3 col-lg-3">
                                        <div class="form-group" style="display: none;" id="DivisionOpt">
                                            <label>Division</label>
                                            <select id="filterDivision" class="form-control " name="div" required>
                                                <option value=""> --Select Division --</option>
                                                @foreach(collect($Rep_List)->unique('Division') as $row)
                                                @if($row['Division'] !== '-')
                                                <option value="{{$row['Division_id']}}">{{$row['Division']}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-lg-3">
                                        <div class="form-group" style="display: none;" id="TeamOpt">
                                            <label>Team</label>
                                            <select id="filterTeam" class="form-control" required>
                                                <option value="">-- Select Team --</option>
                                                @foreach(collect($Rep_List)->unique('Team') as $row)
                                                @if($row['Team'] !== '-')
                                                <option value="{{ $row['Team_id'] }}">{{ $row['Team'] }}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3 col-lg-3">
                                        <div class="form-group" style="display: none;" id="ZoneOpt">
                                            <label>Zone</label>
                                            <select id="filterZone" class="form-control" required>
                                                <option value="">-- Select Zone --</option>
                                                @foreach(collect($Rep_List)->unique('Zone') as $row)
                                                @if($row['Zone'] !== '-')
                                                <option value="{{ $row['Zone_id'] }}">{{ $row['Zone'] }}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3 col-lg-3">
                                        <div class="form-group" style="display: none;" id="MonthOpt">
                                            <label>Month</label>
                                            <select id="filterMonth" class="form-control" required>
                                                <option value="">-- Select Month --</option>
                                                @foreach(collect($Rep_List)->unique('Month_Year') as $row)
                                                @if($row['Month_Year'] !== '-')
                                                <option value="{{ $row['Month_Year'] }}">{{ $row['Month_Year'] }}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <input type="text" id="searchInput" class="form-control" placeholder="Search...">
                                    </div>
                                    <div class="text-center mb-3">
                                        <!-- <button type="button" class="btn btn-success" onclick="exportTableToExcel('datatable', 'Fives_KpiReport')">Download Excel</button> -->
                                        <button type="button" class="btn btn-success" onclick="exportVisibleTableToExcel()">Download Excel</button>
                                        <button type="button" id="clearButton" class="btn btn-info ml-5" onclick="clearPage()">CLEAR FILTER</button>
                                        <button type="button" id="RepButton" class="btn btn-warning ml-5" onclick="Report()">ALL REPORT</button>
                                        <button type="button" id="unallRepButton" class="btn btn-secondary ml-5" onclick="UNALLOCReport()">UNALLOCATE REPORT</button>
                                    </div>

                                    <!-- Spinner -->
                                    <div id="spinner" class="col-md-1" style="display: none;">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- UN ALLOCATED REPORT -->
                                <div class="table-responsive">
                                    <h5>UNALLOCATED REPORT </h5>
                                    <table class="table custom-table datatable" id="datatable1">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SNO</th>
                                                <th>NAME </th>
                                                <th>ZONE </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($Unall_Rep_List as $index => $Unall_Rep_Lists)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $Unall_Rep_Lists['Name'] }}</td>
                                                <td>
                                                    @php
                                                    // Define all values that mean "not allocated"
                                                    $invalidZones = ['A', 'B', 'C', 'D', 'E', 'F', 'A4'];
                                                    @endphp

                                                    @if(in_array($Unall_Rep_Lists['Zone'], $invalidZones))
                                                    Zone not Allocated
                                                    @else
                                                    {{ $Unall_Rep_Lists['Zone'] }}
                                                    @endif
                                                </td>

                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- ALL REPORT -->
                                <div class="table-responsive">
                                    <h5>ALL REPORT </h5>
                                    <table class="table custom-table datatable" id="datatable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SNO</th>
                                                <th>NAME </th>
                                                <th>MONTH </th>
                                                <th>DIVISION</th>
                                                <th>TEAM</th>
                                                <th>ZONE</th>
                                                <th>AVERAGE MARK</th>
                                                <th>KPI AVERAGE MARK</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($Rep_List as $index => $Rep_Lists)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $Rep_Lists['Name'] }} / {{ $Rep_Lists['tno'] }}</td>
                                                <td>{{ $Rep_Lists['Month_Year'] }}</td>
                                                <td>{{ $Rep_Lists['Division'] }}</td>
                                                <td>{{ $Rep_Lists['Team'] }}</td>
                                                <td>{{ $Rep_Lists['Zone'] }}</td>
                                                <td>{{ $Rep_Lists['Average'] }}</td>
                                                <td>{{ $Rep_Lists['Kpi_Pt'] }}</td>

                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script> -->
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="assets/js/5s/popper.min.js"></script>
    <script src="assets/js/5s/jquery-3.6.0.min.js"></script>
    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>
    <script src="assets/js/5s/jquery.slimscroll.js"></script>
    <script src="assets/js/5s/jquery.dataTables.min.js"></script>
    <script src="assets/js/5s/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/5s/app.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>


    <script>
        $(document).ready(function() {
            // Trigger FilterData when any filter changes
            $("#filterDivision, #filterTeam, #filterZone, #filterMonth").on("change", function() {
                FilterData();
            });

            // Optional: Trigger filter on pressing Enter in the search box
            $(document).ready(function() {
                $('#searchInput').on('keyup', function() {
                    let filter = $(this).val().toLowerCase();

                    // Apply search only to visible table
                    $('table:visible tbody tr').each(function() {
                        $(this).toggle($(this).text().toLowerCase().includes(filter));
                    });
                });
            });

            function FilterData() {
                $('#spinner').show();
                // Show the All Report table
                $("#datatable").closest('.table-responsive').show();


                var Div = $("#filterDivision").val() || 0;
                var Team = $("#filterTeam").val() || 0;
                var Zone = $("#filterZone").val() || 0;
                var Month = $("#filterMonth").val() || "-";

                console.log(Div, Team, Zone, Month, 'DataS');


                $.ajax({
                    url: "{{ route('Rep_Filter') }}",
                    type: "GET",
                    data: {
                        Div: Div,
                        Team: Team,
                        Zone: Zone,
                        Month: Month,
                    },
                    dataType: 'json',
                    success: function(Filter) {
                        console.log("Filter data received:", Filter);
                        var tableBody = $('#datatable tbody');
                        tableBody.empty(); // Clear existing table data

                        if (Filter.length > 0) {

                            for (var i = 0; i < Filter.length; i++) {
                                var rep = Filter[i];
                                var row = '<tr>' +
                                    '<td>' + (i + 1) + '</td>' + // SNO
                                    '<td>' + rep.Name + ' / ' + rep.tno + '</td>' +
                                    '<td>' + rep.Month_Year + '</td>' +
                                    '<td>' + rep.Division + '</td>' +
                                    '<td>' + rep.Team + '</td>' +
                                    '<td>' + rep.Zone + '</td>' +
                                    '<td>' + rep.Average + '</td>' +
                                    '<td>' + rep.Kpi_Pt + '</td>' +
                                    '</tr>';
                                tableBody.append(row);
                            }

                        } else {
                            tableBody.append('<tr><td colspan="8" class="text-center">NO DATA IS AVAILABLE</td></tr>');

                        }
                        $('#spinner').hide();
                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching FILTER:", error);
                        $('#spinner').hide();

                    }
                });
            }
        });
    </script>


    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            $('#searchInput').on('keyup', function() {
                let filter = $(this).val().toLowerCase();

                // Apply search only to visible table
                $('table:visible tbody tr').each(function() {
                    $(this).toggle($(this).text().toLowerCase().includes(filter));
                });
            });
        });
    </script>

    <!-- <script>
        $(document).ready(function() {
            $('#searchInput').on('keyup', function() {
                let filter = $(this).val().toLowerCase();
                $('#datatable tbody tr').each(function() {
                    $(this).toggle($(this).text().toLowerCase().includes(filter));
                });
            });
        });
    </script> -->

    <script>
        $(document).ready(function() {
            $("#datatable").closest('.table-responsive').hide(); // Hide ALL REPORT by default
        });
    </script>

    <!-- //CLEAR BUTTON -->
    <script>
        function Report() {
            $("#searchInput").val('');

            // Hide the Unallocated Report table
            $("#datatable1").closest('.table-responsive').hide();

            // Show the All Report table
            $("#datatable").closest('.table-responsive').show();

            $("#DivisionOpt,#TeamOpt, #ZoneOpt, #MonthOpt").css('display', 'block');


        }

        function UNALLOCReport() {
            $("#searchInput").val('');

            // Hide the Unallocated Report table
            $("#datatable1").closest('.table-responsive').show();

            // Show the All Report table
            $("#datatable").closest('.table-responsive').hide();

            $("#DivisionOpt,#TeamOpt, #ZoneOpt, #MonthOpt").css('display', 'none');

        }
    </script>


    <!-- EXCEL -->
    <script>
        function exportVisibleTableToExcel() {
            // Identify both tables
            let table1 = document.getElementById('datatable1'); // UNALLOCATED
            let table2 = document.getElementById('datatable'); // ALL REPORT

            let visibleTable = null;
            let filename = '';

            // Detect which table is currently visible
            if ($(table1).is(':visible') && !$(table2).is(':visible')) {
                visibleTable = table1;
                filename = 'Unallocated_Report';
            } else if ($(table2).is(':visible') && !$(table1).is(':visible')) {
                visibleTable = table2;
                filename = 'All_Report';
            } else if ($(table1).is(':visible') && $(table2).is(':visible')) {
                // Both visible — optional: export both into one workbook
                alert("Both tables are visible. Please show only one report at a time.");
                return;
            } else {
                alert("No table is visible to export!");
                return;
            }

            // Convert visible table to Excel
            let workbook = XLSX.utils.table_to_book(visibleTable, {
                sheet: "Report"
            });
            XLSX.writeFile(workbook, filename + ".xlsx");
        }
    </script>

    <!-- <script>
        function exportTableToExcel(tableID, filename = '') {
            let table = document.getElementById(tableID);
            let workbook = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });
            return XLSX.writeFile(workbook, filename ? filename + ".xlsx" : "excel_data.xlsx");
        }
    </script> -->

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#filterDivision, #filterTeam, #filterZone,#filterMonth').select2();
        });
    </script>


</body>

</html>