<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Designation Master Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- jQuery (Make sure it's included before Bootstrap JS) -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #fff;
            /* or another background color */
            z-index: 1;
        }
    </style>

    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')
    @endsection

    <div class="main-wrapper">
        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="page-header">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                            <h5 class="text-uppercase mb-0 mt-0 page-title">Designation Master Report</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">

                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <input type="text" id="searchInput" class="form-control" placeholder="Search...">
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table custom-table datatable" id="trainTable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SNO</th>
                                                <th>Designation Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($design as $index => $design1)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $design1['Name'] }}</td>

                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <br>
                                <div class="col-md-12 col-lg-12 save">
                                    <div class="text-center">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/5s_design_mas'">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            $('#searchInput').on('keyup', function() {
                let filter = $(this).val().toLowerCase();
                $('#trainTable tbody tr').each(function() {
                    $(this).toggle($(this).text().toLowerCase().includes(filter));
                });
            });
        });
    </script>

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="assets/js/5s/popper.min.js"></script>
    <script src="assets/js/5s/jquery-3.6.0.min.js"></script>
    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>
    <script src="assets/js/5s/jquery.slimscroll.js"></script>
    <script src="assets/js/5s/jquery.dataTables.min.js"></script>
    <script src="assets/js/5s/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/5s/app.js"></script>


</body>

</html>