<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title> Training Entry</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

</head>

<body>

    @extends('FiveS.5s_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('training_save') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title"> Training Entry</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>ENO</label>
                                                <input type="text" class="form-control" name="Eno" value="<?php echo $eno; ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" id="date" name="date" required min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                        <!-- <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Area</label>
                                                <select class="form-control" name="AREA" id="Select" required>
                                                    <option>--Select Area--</option>
                                                    @foreach ($area as $area1)
                                                    <option value="{{$area1['Rowid']}}">{{$area1['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div> -->
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Division</label>
                                                <select class="form-control" name="Division" id="Select" onchange="ToshowEmplName(this.value)" required>
                                                    <option value="">--Select Division--</option>
                                                    @foreach ($division as $divisions)
                                                    <option value="{{$divisions['Division_id']}}/{{$divisions['Comp_DivCode']}}">{{$divisions['Division']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-5 col-lg-3">
                                            <div class="form-group">
                                                <!-- <label>Empl Name Type </label> -->
                                                <div class="col-lg-6">
                                                    <input type="radio" name="Names" value="1" checked class="form-group mt-3"> Staffs Name
                                                </div>
                                                <div class="col-lg-12">
                                                    <input type="radio" name="Names" value="0" class="form-group mt-3"> Local Workers Name
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            <label>Add Employee Name</label>
                                            <div class="add-icon">
                                                <a href="javascript:void(0);" id="addRowBtn" onclick="addRow1()">
                                                    <img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <br>

                                    <div class="table-container">

                                        <table id="app_table" class="table   table-condensed">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Employee Name</th>
                                                    <th>Employee TNO</th>
                                                    <th>Department</th>
                                                    <th>Designation</th>
                                                    <th>Edit</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tableBody1">
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control empSelect" name="emp_no[]" id="Select" onchange="emplnovalue(this.value, this.parentNode.parentNode)" required>
                                                            <option value="">--Select Employee Name--</option>

                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="emp_tn[]" class="form-control Tno" readonly>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="dept[]" class="form-control Deptname" readonly>
                                                        <input type="hidden" name="dept1[]" class="form-control Deptcode" readonly>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="design[]" class="form-control DesignationName" readonly>
                                                        <input type="hidden" name="design1[]" class="form-control designationcode" readonly>
                                                    </td>
                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>



                                </div>

                                <div class="d-flex justify-content-around pb-2">
                                    <button type="button" id="clearButton" class="btn btn-primary ml-5" onclick="clearPage()">CLEAR</button>
                                    <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-success">
                                    <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/TrainReport'">Report</button>

                                    <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                    <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                </div>
                            </div>
                            <br>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        </div>

    </form>

    <!-- // TO SHOW EMPLOYEE NAME ACCORDING TO STAFF OR LOCAL WORKERS  -->
    <!-- <script>
        var cachedEmplName = []; // Global variable to store employee list

        function ToshowEmplName(divcode) {

            console.log('Division', divcode);


            var selectedValue = $("input[name='Names']:checked").val();
            console.log('Selected Name Type:', selectedValue);

            if (selectedValue == "1") {
                var Type = "1";
            } else {
                var Type = "2";
            }

            // NAME CHANGE
            $.ajax({
                url: "{{ route('train_Emplist') }}",
                type: "GET",
                data: {
                    divcode: "6",
                    Type: Type,
                },
                dataType: 'json',
                success: function(EmplName) {
                    console.log('Division Wise Name Change', EmplName);

                    // Store fetched data globally
                    cachedEmplName = EmplName;

                    // Target the select dropdown
                    let dropdown = $(".empSelect");

                    // Clear previous options
                    dropdown.empty();
                    dropdown.append('<option value="">-- Select Empl Name --</option>');

                    // Loop through the response and append options
                    $.each(EmplName, function(index, item) {
                        dropdown.append(`
                            <option 
                                value="${item.Emplno}">
                                ${item.Name} / ${item.tno}
                            </option>
                        `);
                    });


                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                }
            });
        }

        $(document).ready(function() {
            // Update on radio button change
            $("input[name='Names']").change(function() {
                var DivisionVal = $('[name="Division"]').val();

                console.log('Division value', DivisionVal);
                if (DivisionVal != '') {
                    ToshowEmplName();
                } else {
                    alert('Please Select the Division First.');
                }

            });
        });
    </script> -->


    <!-- // FOR ADD EMPL NAME  -->
    <script>
        var cachedEmplName = [];

        // <!-- // TO SHOW EMPLOYEE NAME ACCORDING TO STAFF OR LOCAL WORKERS  -->
        function ToshowEmplName(divcode) {

            console.log('Division', divcode);
            var selected_div = divcode.split('/');

            var DivID = selected_div[0];
            var Comp_DivID = selected_div[1];

            if (Comp_DivID == "") {
                alert('There is No Company Division Code in the Master Table Add it.');
            } else {

                var selectedValue = $("input[name='Names']:checked").val();
                console.log('Selected Name Type:', selectedValue);

                if (selectedValue == "1") {
                    var Type = "1";
                } else {
                    var Type = "2";
                }

                // NAME CHANGE
                $.ajax({
                    url: "{{ route('train_Emplist') }}",
                    type: "GET",
                    data: {
                        divcode: Comp_DivID,
                        Type: Type,
                    },
                    dataType: 'json',
                    success: function(EmplName) {
                        try {
                            console.log('Division Wise Name Change', EmplName);
                            if (EmplName.length > 0) {

                                // Store fetched data globally
                                cachedEmplName = EmplName;

                                // Target the select dropdown
                                let dropdown = $(".empSelect");

                                // Clear previous options
                                dropdown.empty();
                                $(".Tno, .Deptname, .Deptcode, .DesignationName, .designationcode").val('');
                                dropdown.append('<option value="">-- Select Empl Name --</option>');

                                // Loop through the response and append options
                                $.each(EmplName, function(index, item) {
                                    dropdown.append(`
                                <option 
                                    value="${item.Emplno}">
                                    ${item.Name} / ${item.tno}
                                </option>
                            `);
                                });
                            } else {
                                alert('Employee Name Does Not Passed');
                            }
                        } catch (error) {
                            alert('Error Message: ' + error.message);
                            console.error('Catch Error:', error);
                        }

                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('AJAX Error: ' + error);
                    }
                });
            }
        }

        // IF STAFFS OR LOCAL WORKS CHANGED
        $(document).ready(function() {
            // Update on radio button change
            $("input[name='Names']").change(function() {
                var DivisionVal = $('[name="Division"]').val();

                console.log('Division value', DivisionVal);
                if (DivisionVal != '') {
                    whenNameChange(DivisionVal);
                } else {
                    alert('Please Select the Division First.');
                }

            });
        });

        function whenNameChange(divcode) {

            console.log('Division', divcode);

            var selected_div = divcode.split('/');

            var DivID = selected_div[0];
            var Comp_DivID = selected_div[1];

            if (Comp_DivID == "") {
                alert('There is No Company Division Code in the Master Table Add it.');
            } else {

                var selectedValue = $("input[name='Names']:checked").val();
                console.log('Selected Name Type:', selectedValue);

                if (selectedValue == "1") {
                    var Type = "1";
                } else {
                    var Type = "2";
                }

                // NAME CHANGE
                $.ajax({
                    url: "{{ route('train_Emplist') }}",
                    type: "GET",
                    data: {
                        divcode: Comp_DivID,
                        Type: Type,
                    },
                    dataType: 'json',
                    success: function(EmplName) {
                        try {
                            console.log('When Name Division Wise', EmplName);
                            if (EmplName.length > 0) {

                                // Store fetched data globally
                                cachedEmplName = EmplName;

                                // Target the select dropdown
                                let dropdown = $(".empSelect");

                                // // Clear previous options
                                // dropdown.empty();
                                // $(".Tno, .Deptname, .Deptcode, .DesignationName, .designationcode").val('');
                                // dropdown.append('<option value="">-- Select Empl Name --</option>');

                                // Loop through the response and append options
                                $.each(EmplName, function(index, item) {
                                    dropdown.append(`
                                    <option 
                                        value="${item.Emplno}">
                                        ${item.Name} / ${item.tno}
                                    </option>
                                `);
                                });
                            } else {
                                alert('Employee Name Does Not Passed');
                            }
                        } catch (error) {
                            alert('Error Message: ' + error.message);
                            console.error('Catch Error:', error);
                        }

                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        alert('AJAX Error: ' + error);
                    }
                });
            }
        }

        // TO SHOW TNO,DEPARTMENT,DESIGNATION
        function emplnovalue(selected_emplno, row) {
            $.ajax({
                url: "{{ route('train_option') }}",
                type: "GET",
                data: {
                    selected_emplno: selected_emplno,
                },
                dataType: 'json',
                success: function(option) {
                    try {
                        console.log(option);
                        if (option.length > 0) {
                            // Update the fields in the current row
                            $(row).find('.Tno').val(option[0].Tno);
                            $(row).find('.Deptname').val(option[0].DeptName);
                            $(row).find('.Deptcode').val(option[0].Deptcode);
                            $(row).find('.DesignationName').val(option[0].DesignationName);
                            $(row).find('.designationcode').val(option[0].designationcode);
                        }
                    } catch (error) {
                        alert('Error Message: ' + error.message);
                        console.error('Catch Error:', error);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('AJAX Error: ' + error);
                }
            });
        }

        // TO ADD ROW 
        function addRow1() {
            try {
                var table = document.getElementById("app_table");
                var tbody = document.getElementById("tableBody1");


                var newRow = table.insertRow(table.rows.length);
                var cell1 = newRow.insertCell(0);
                var cell2 = newRow.insertCell(1);
                var cell3 = newRow.insertCell(2);
                var cell4 = newRow.insertCell(3);
                var cell5 = newRow.insertCell(4);
                var cell6 = newRow.insertCell(5);

                cell1.innerHTML = table.rows.length - 1; // SNO
                cell2.innerHTML = `<select class="form-control empSelect" name="emp_no[]" onchange="emplnovalue(this.value, this.parentNode.parentNode)" required>
                              </select>`; // EMPL NAME
                cell3.innerHTML = '<input type="text" name="emp_tn[]" class="form-control Tno" readonly>'; // EMPL TNO
                cell4.innerHTML = '<input type="text" name="dept[]" class="form-control Deptname" readonly><input type="hidden" name="dept1[]" class="form-control Deptcode" readonly>'; // DEPARTMENT
                cell5.innerHTML = '<input type="text" name="design[]" class="form-control DesignationName" readonly><input type="hidden" name="design1[]" class="form-control designationcode" readonly>'; // DESIGNATION
                cell6.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

                // Populate the new row's dropdown using cached data
                let newDropdown = $(newRow).find('.empSelect');
                newDropdown.append('<option value="">-- Select Empl Name --</option>');

                $.each(cachedEmplName, function(index, item) {
                    newDropdown.append(`<option value="${item.Emplno}">${item.Name} / ${item.tno}</option>`);
                });

                // Update the Select2 initialization script to use a class instead of an ID
                $(document).ready(function() {
                    $('.empSelect').select2();
                });
            } catch (error) {
                alert('Error Message: ' + error.message);
                console.error('Catch Error:', error);
            }

        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
        }
    </script>


    <!-- // FOR SELECTED EMPL NAME DEPT DIV  -->
    <!-- <script>
        function emplnovalue(empl_no) {
            var selected_emplno = empl_no;

            $.ajax({
                url: "{{ route('train_option') }}",
                type: "GET",
                data: {
                    selected_emplno: selected_emplno,
                },
                dataType: 'json',
                success: function(option) {
                    console.log(option);
                    if (option.length > 0) {

                        var Tno = option[0].Tno;
                        var Deptname = option[0].Deptname;
                        var Deptcode = option[0].Deptcode;
                        var DesignationName = option[0].DesignationName;
                        var designationcode = option[0].designationcode;
                      

                        $('.Tno').val(Tno);
                        $('.Deptname').val(Deptname);
                        $('.Deptcode').val(Deptcode);
                        $('.DesignationName').val(DesignationName);
                        $('.designationcode').val(designationcode);
                   

                    }
                }
            });
        }
    </script> -->

    <!-- // FOR ADD EMPL NAME  -->
    <!-- <script>
        function addRow1() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody1");

            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            var cell5 = newRow.insertCell(4);
            var cell6 = newRow.insertCell(5);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control select2" name="emp_no[]" id="emp_no" onchange="emplnovalue(this.value)"  required ><option value="">--Select Employee Name--</option>@foreach($Name as $Name1)<option value="{{$Name1['Emplno']}}">{{$Name1['Name']}}</option>@endforeach</select>'; // EMPL NAME
            cell3.innerHTML = '<input type="text" name="emp_tn[]" id="emp_tn" class="form-control Tno" readonly>'; // EMPL TNO
            cell4.innerHTML = '<input type="text" name="dept[]" id="dept" class="form-control Deptname" readonly><input type="hidden" name="dept1[]" id="dept1" class="form-control Deptcode" readonly>'; // DEPARTMENT
            cell5.innerHTML = '<input type="text" name="design[]" id="design" class="form-control DesignationName" readonly><input type="hidden" name="design1[]" id="design1" class="form-control designationcode" readonly>'; // DESIGNATION
            cell6.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            updateTotal();
        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        
    </script> -->



    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('date').value = getCurrentDate();
        document.getElementById('eff').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#Select').select2();
        });
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            // Update the ID to match the dynamically added row
            $('.empSelect').select2();
        });
    </script>

    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection
</body>

</html>