<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Company</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/5s_fav1.png" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
    <script src="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <script src="//code.jquery.com/jquery-1.11.1.min.js"></script>

    <!-- Include the necessary CSS links -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/css/bootstrap.min.css">

</head>

<body>
    <div class="col-md-12">
        @if(session('alert'))
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                var myModal = new bootstrap.Modal(document.getElementById('alertModal'));
                myModal.show();
            });
        </script>
        @endif
    </div>

    <!-- Modal -->
    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Company</h5>
                </div>
                <div class="modal-body">
                    <form action="5SDashboard" method="post">
                        @csrf
                        <select name="companyCode" id="compOption" class="form-select" required>
                            <option value="">--select--</option>
                            @foreach($decode as $decodes)

                            <option value="{{ $decodes['CompCode'] }}|{{ $decodes['CompAddress'] }}|{{ $decodes['CompName'] }}|{{ $decodes['CompTNGSTNo'] }}">{{ $decodes['CompName'] }}</option>
                            @endforeach
                        </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="submitForm" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- modal -->

    <div class="modal fade" id="alertModal" tabindex="-1" role="dialog" aria-labelledby="alertModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="alertModalLabel">Alert</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Choose a any one Comapny. -->
                    {{ session('alert') ?? 'Choose a company.' }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="btnOk" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!-- modal end -->


    <!-- company Choose -->

    <script>
        $(document).ready(function() {
            $('#staticBackdrop').modal({
                backdrop: 'static',
                keyboard: false
            });

            $("#submitForm").on("click", function() {
                if ($('#compOption').val() === "") {
                    $('#alertModal').modal('show');
                } else {
                    // Your existing code to handle the form submission
                    var csrfToken = $('meta[name="csrf-token"]').attr('content');
                    var formData = {
                        companyCode: $("#compOption").val(),
                        _token: csrfToken
                    };

                    $.ajax({
                        type: "GET",
                        url: "{{ route('compLogin') }}",
                        data: {
                            compCode: formData.companyCode
                        },
                        success: function(response) {
                            // Handle success if needed
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }
            });

            $("#btnOk").on("click", function() {
                // Your logic here, if needed
                $('#staticBackdrop').modal('hide');
                $('#anotherModal').modal('show');
            });
        });
    </script>



    <!-- Include the necessary Bootstrap 4 JS script -->


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>