<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Audit Entry Approval </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include jQuery and Select2 libraries -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/js/select2.min.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <!-- COLOR & FLAG -->
    <style>
        .custom-select10 {
            position: relative;
            display: inline-block;
            vertical-align: top;
            /* Aligns the dropdowns at the top */
            margin-bottom: 10px;
            /* Adjust as needed to maintain consistent spacing */
        }

        .custom-select10 .select-btn10 {
            padding: 20px 50px;
            /* Adjust the vertical padding */
            background-color: #f1f1f1;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            /* Aligns the content center vertically */
            align-items: center;
            /* Aligns the content center vertically */
        }

        /* Dropdown content */
        .custom-select-content10 {
            position: absolute;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            overflow: hidden;
            z-index: 1;
            top: 100%;
            /* Ensures dropdowns appear below the select button */
            width: 100%;
            /* Makes dropdown width same as the select button */
        }

        /* Custom option */
        .custom-option10 {
            /* display: flex; */
            align-items: center;
            padding: 5px;
            cursor: pointer;
        }

        /* Color indicator */
        .color-indicator10 {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>


    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }


        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }
    </style>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('audit_app_save') }}" enctype="multipart/form-data">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">audit entry Approval </h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>ENO</label>
                                                <input type="text" class="form-control" name="eno" id="eno" value="{{ request('E_NO') }}" readonly>
                                                <input type="hidden" class="form-control" name="rowid" id="rowid" value="{{ request('Rowid') }}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="text" class="form-control" name="date" id="date" value="{{ request('E_date') }}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Division</label>
                                                <input type="text" class="form-control" name="division" id="division" value="{{ request('Division') }}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Team / Floor </label>
                                                <input type="text" class="form-control" name="team" id="team" value="{{ request('Team') }}" readonly>

                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Zone / Department </label>
                                                <input type="text" class="form-control" name="zone" id="zone" value="{{ request('Zone') }}" readonly>

                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Flag</label>
                                                <input type="text" class="form-control" name="ty_flag" id="ty_flag" value="{{ request('Type_flag') }}" readonly>

                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Audit</label>
                                                <input type="text" class="form-control" name="typ_audit" id="typ_audit" value="{{ request('Type_audit') }}" readonly>

                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Flag Colour</label>
                                                <br>
                                                <div class="custom-select10 color-select10 " id="colorSelect10">
                                                    <div class="select-btn10 flagcol1"></div>
                                                    <div class="custom-select-content10" style="display: none;">

                                                    </div>
                                                </div>
                                                <input type="hidden" class="form-control" name="res_empl" id="res_empl" value="{{ request('Resp_emplno') }}" readonly>
                                            </div>
                                        </div>
                                        <!-- Hidden input field to store next verification dates -->
                                        <input type="hidden" id="nextVerificationDates" name="nextVerificationDates" readonly>
                                    </div>

                                    <br>
                                    <!-- // TABLE FOR AUDITED  -->
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th><input type="checkbox" id="selectAllCheckbox"> SNO</th>
                                                    <th>Check Point </th>
                                                    <th style="display: none;">Check Point1 </th>
                                                    <th>Alloted Flag</th>
                                                    <th>Next Verification Date </th>

                                                </tr>
                                            </thead>

                                            <tbody id="tableBody">


                                            </tbody>

                                        </table>
                                    </div>

                                    <br>
                                    <!-- // TABLE FOR REMARKS  -->
                                    <div class="table-container">
                                        <table id="app_table1" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Check Point </th>
                                                    <th>Remarks</th>

                                                </tr>
                                            </thead>
                                            <tbody id="tableBody1">

                                            </tbody>

                                        </table>
                                    </div>

                                    <br>
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="form-group">
                                                <label>Remarks</label>
                                                <input type="text" class="form-control" name="Remark" id="Remark" value="{{ request('Remark') }}" style="height: 100px;" readonly>
                                                <!-- <textarea class="form-control" rows="3" name="Remark" id="Remark" value="{{ request('Remark') }}" readonly></textarea> -->
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                            <div class="row">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <!-- <div class="form-group row">
                                                        <label for="ver_date" class="col-sm-4 col-form-label"> Next Verification Date </label>
                                                        <div class="col-sm-6">
                                                            <input type="text" class="form-control" name="nxt_date" id="nxt_date" value="{{ request('verf_date') }}" readonly>
                                                        </div>
                                                    </div> -->
                                                    <div class="form-group row">
                                                        <label for="attach_1" class="col-sm-4 col-form-label"> Attachement -1</label>
                                                        <div class="col-sm-6">
                                                            @if(request('Attach_1') !== 'NO File')
                                                            <a href="{{ asset('Flag_AuditEntry/' . request('Attach_1')) }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ request('Attach_1') }}">Attachment-1</a>
                                                            @else
                                                            <span>--</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_3" class="col-sm-4 col-form-label"> Attachement -3</label>
                                                        <div class="col-sm-6">
                                                            @if(request('Attach_3') !== 'NO File')
                                                            <a href="{{ asset('Flag_AuditEntry/' . request('Attach_3')) }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ request('Attach_3') }}">Attachment-3</a>
                                                            @else
                                                            <span>--</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_5" class="col-sm-4 col-form-label"> Attachement -5 </label>
                                                        <div class="col-sm-6">
                                                            @if(request('Attach_5') !== 'NO File')
                                                            <a href="{{ asset('Flag_AuditEntry/' . request('Attach_5')) }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ request('Attach_5') }}">Attachment-5</a>
                                                            @else
                                                            <span>--</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="form-group row">
                                                        <label for="attach_2" class="col-sm-4 col-form-label"> Attachement -2</label>
                                                        <div class="col-sm-6">
                                                            @if(request('Attach_2') !== 'NO File')
                                                            <a href="{{ asset('Flag_AuditEntry/' . request('Attach_2')) }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ request('Attach_2') }}">Attachment-2</a>
                                                            @else
                                                            <span>--</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_4" class="col-sm-4 col-form-label"> Attachement -4 </label>
                                                        <div class="col-sm-6">
                                                            @if(request('Attach_4') !== 'NO File')
                                                            <a href="{{ asset('Flag_AuditEntry/' . request('Attach_4')) }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ request('Attach_4') }}">Attachment-4</a>
                                                            @else
                                                            <span>--</span>
                                                            @endif
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="form-group">
                                                <label> Your Remarks</label>
                                                <textarea class="form-control" rows="3" name="your_Remark" id="your_Remark"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12 col-md-12">
                                    <div class="d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="Complete" id="save" class="btn btn-primary">
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/FLAG_Audit_List'">Back</button>
                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <!-- AJAX METHOD FOR GETTING DETAILS -->
    <script>
        $(document).ready(function() {

            // Function to toggle input field visibility based on checkbox status
            function toggleInputFieldVisibility() {
                var enabledCheckboxesCount = $('.check:enabled').length;
                var selectedEnabledCheckboxesCount = $('.check:enabled:checked').length;
                if (enabledCheckboxesCount === selectedEnabledCheckboxesCount && selectAllCheckbox) {
                    $('#your_Remark').closest('.row').show(); // Show input field
                    $('#save').click(function() {
                        var remarks = $('#your_Remark').val().trim();
                        if (remarks === "") {
                            alert("Please fill in your remarks.");
                            return false; // Prevent form submission
                        }

                    });
                } else {
                    $('#your_Remark').closest('.row').hide(); // Hide input field
                }
            }

            // Function to handle select all checkbox
            $('#selectAllCheckbox').change(function() {
                $('.check:enabled').prop('checked', $(this).prop('checked'));
                toggleInputFieldVisibility();
                updateNextVerificationDates();
            });

            // Function to update the value of the 'nextVerificationDates' input field
            function updateNextVerificationDates() {
                var dates = []; // Array to store enabled dates

                // Iterate over each Next Verification Date input field
                $('input[type="date"]:enabled').each(function() {
                    // Check if the input field is enabled and not part of the selected checkbox row
                    if (!$(this).prop('readonly') && !$(this).closest('tr').find('.check').is(':checked')) {
                        // Push the value of enabled input fields to the 'dates' array
                        dates.push($(this).val());
                    }
                });

                // Update the value of the 'nextVerificationDates' input field
                $('#nextVerificationDates').val(dates.join(', '));
            }




            // Hide the input field initially
            // toggleInputFieldVisibility();

            // AJAX call
            var rowid = $('#rowid').val();
            $.ajax({
                url: "{{ route('audit_appro') }}",
                type: "GET",
                data: {
                    rowid: rowid,
                },
                dataType: 'json',
                success: function(details) {
                    if (details.length > 0) {
                        console.log(details);
                        $.each(details, function(index, detail) {
                            var checkpoint = detail.Check_point;
                            var Check_pointID = detail.Check_pointID;
                            var flag = detail.Flag;
                            var checkSts = detail.Check_Sts;
                            var Nxt_verf_date = detail.Nxt_verf_date.split(' ')[0]; // Extract date part
                            var formattedDate = formatDate(Nxt_verf_date); // Format the date

                            // Render checkbox for all check points
                            $('#tableBody').append('<tr>' +
                                '<td>' +
                                '<label class="checkbox">' +
                                '<input type="checkbox" class="check" name="checkid[]" value="' + Check_pointID + '" ' + (checkSts === "CLOSE" ? "disabled" : "") + '>' +
                                (index + 1) + '' +
                                '</label>' +
                                '</td>' +
                                '<td>' + checkpoint + '</td>' +
                                '<td  style="display: none;">' +
                                '<input type="text" class="form-control" name="check[]" id="check" value="' + Check_pointID + '" required>' +
                                '</td>' +
                                '<td>' +
                                '<div class="custom-select10 color-select10">' +
                                '<div class="select-btn10" style="background-color: ' + flag + ';">' + '</div>' +
                                '<div class="custom-select-content10" style="display: none;">' +
                                '<input type="text" class="colorall" name="colorall[]" id="colorall">' +
                                '</div>' +
                                '</div>' +
                                '</td>' +
                                '<td>' +
                                '<input type="date" class="form-control" name="nxt_date[]" id="nxt_date_' + index + '" value="' + formattedDate + '" ' + (checkSts === "CLOSE" ? "readonly" : "") + ' required>' +
                                '</td>' +
                                '</tr>');
                        });

                        // Handle checkbox change event
                        $('.check').change(function() {
                            toggleInputFieldVisibility(); // Toggle input field visibility
                            updateNextVerificationDates(); // Update 'nextVerificationDates' input field value

                            // Find the parent row of the changed checkbox
                            var $parentRow = $(this).closest('tr');

                            // Check if the checkbox is checked
                            if ($(this).is(':checked')) {
                                // Set the Next Verification Date input field within this row to readonly
                                $parentRow.find('input[type="date"]').prop('readonly', true);
                            } else {
                                // If the checkbox is unchecked, remove the readonly attribute
                                $parentRow.find('input[type="date"]').prop('readonly', false);
                            }
                        });

                    }
                }
            });

            // Function to format date as "yyyy-MM-dd"
            function formatDate(dateString) {
                var parts = dateString.split('-');
                var formattedDate = parts[2] + '-' + parts[1] + '-' + parts[0];
                return formattedDate;
            }
            // Additional condition to show alert if no checkboxes are selected
            $('#save').click(function() {
                var selectedCheckboxesCount = $('.check:checked').length;

                // Check if any next verification date is not selected
                var allDatesSelected = true;
                $('input[type="date"]').each(function() {
                    // Check if the input field is not read-only and its value is empty
                    if (!$(this).prop('readonly') && $(this).val() === "") {
                        allDatesSelected = false;
                        return false; // Exit the loop early if any date is not selected
                    }
                });

                if (!allDatesSelected) {
                    alert("Please select the next verification date for all checkboxes.");
                    return false; // Prevent form submission
                }


                if (selectedCheckboxesCount === 0) {
                    alert("Please select at least one checkbox.");
                    return false; // Prevent form submission
                }
                // Continue with form submission if at least one checkbox is selected
            });
            
        });
    </script>

    <!-- AJAX METHOD FOR GETTING REMARKS -->
    <script>
        // Wait for the DOM to be ready
        $(document).ready(function() {
            // Get the value of rowid from the input field
            var rowid = $('#rowid').val();
            console.log(rowid);
            // Make the AJAX call
            $.ajax({
                url: "{{ route('audit_appro1') }}",
                type: "GET",
                data: {
                    rowid: rowid,
                },
                dataType: 'json',
                success: function(remarks) {
                    if (remarks.length > 0) {
                        console.log(remarks);
                        // Loop through each detail and populate the table
                        $.each(remarks, function(index, detail) {
                            var Check_point = detail.Check_point;
                            var Remarks = detail.Remarks;

                            // Append row to the table
                            $('#tableBody1').append('<tr>' +
                                '<td>' + (index + 1) + '</td>' +
                                '<td>' + Check_point + '</td>' +
                                '<td>' + Remarks + '</td>' +
                                '</tr>');
                        });

                    }
                }
            });
        });
    </script>


    <!-- FOR SHOWING THE FLAG COLOUR -->
    <script>
        // Get the value of the Flag from the URL parameter
        const urlParams = new URLSearchParams(window.location.search);
        const flagValue = urlParams.get('Flag');

        // Define a function to set the background color based on the flag value
        function setFlagColor(flag) {
            const flagElement = document.querySelector('.flagcol1');
            switch (flag) {
                case 'RED':
                    flagElement.style.backgroundColor = 'red';
                    break;
                case 'GREEN':
                    flagElement.style.backgroundColor = 'green';
                    break;
                case 'YELLOW':
                    flagElement.style.backgroundColor = 'yellow';
                    break;
                    // Add more cases for other flag colors if needed
                default:
                    // Set a default color or handle other cases as needed
                    flagElement.style.backgroundColor = 'No Color';
            }
        }

        // Call the function with the flag value
        setFlagColor(flagValue);
    </script>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>