<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Audit Entry List</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include jQuery and Select2 libraries -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/js/select2.min.js"></script>


    <!-- COLOR & FLAG -->
    <style>
        .custom-select10 {
            position: relative;
            display: inline-block;
            vertical-align: top;
            /* Aligns the dropdowns at the top */
            margin-bottom: 10px;
            /* Adjust as needed to maintain consistent spacing */
        }

        .custom-select10 .select-btn10 {
            padding: 20px 50px;
            /* Adjust the vertical padding */
            background-color: #f1f1f1;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            /* Aligns the content center vertically */
            align-items: center;
            /* Aligns the content center vertically */
        }

        /* Dropdown content */
        .custom-select-content10 {
            position: absolute;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            overflow: hidden;
            z-index: 1;
            top: 100%;
            /* Ensures dropdowns appear below the select button */
            width: 100%;
            /* Makes dropdown width same as the select button */
        }

        /* Custom option */
        .custom-option10 {
            /* display: flex; */
            align-items: center;
            padding: 5px;
            cursor: pointer;
        }

        /* Color indicator */
        .color-indicator10 {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>

    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }


        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }
    </style>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="" enctype="multipart/form-data">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">audit entry list</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">

                                    <!-- // TABLE FOR AUDITED  -->
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>ENO</th>
                                                    <th style="display: none;">Rowid</th>
                                                    <th>DATE</th>
                                                    <th>DIVISION</th>
                                                    <th>TEAM</th>
                                                    <th>ZONE</th>
                                                    <th>FLAG COLOUR</th>
                                                    <th>TYPE OF AUDIT </th>
                                                    <th>STATUS</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @foreach ($details as $index => $des)

                                                <tr>

                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $des['E_NO'] }}</td>
                                                    <td style="display: none;">{{ $des['Rowid'] }}</td>
                                                    <td>{{ date('d-m-Y', strtotime($des['E_date'])) }}</td>
                                                    <td>{{ $des['Division'] }}</td>
                                                    <td>{{ $des['Team'] }}</td>
                                                    <td>{{ $des['Zone'] }}</td>
                                                    <td>
                                                        <div class="custom-select10 color-select10">
                                                            <div class="select-btn10" style="background-color: {{ $des['Flag'] }} ;"> </div>
                                                            <div class="custom-select-content10" style="display: none;">
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>{{ $des['Type_audit'] }}</td>
                                                    <td>

                                                        @if ($des['Status'] == "OPEN")
                                                        <a href="FLAG_Audit_Approval?mode=view&Rowid={{$des['Rowid']}}&E_NO={{$des['E_NO']}}&E_date={{$des['E_date']}}&Division={{$des['Division']}}&Team={{$des['Team']}}&Zone={{$des['Zone']}}&Type_audit={{$des['Type_audit']}}&Flag={{$des['Flag']}}&Attach_1={{$des['Attach_1']}}&Attach_2={{$des['Attach_2']}}&Attach_3={{$des['Attach_3']}}&Attach_4={{$des['Attach_4']}}&Attach_5={{$des['Attach_5']}}&Remark={{$des['Remark']}}&verf_date={{$des['verf_date']}}&Type_flag={{$des['Type_flag']}}&Resp_emplno={{$des['Resp_emplno']}}">OPEN</a>
                                                        @else
                                                        {{ $des['Status'] }}
                                                        @endif

                                                    </td>

                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>

    </form>


    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('edate').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>


    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>