<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Audit Entry</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include jQuery and Select2 libraries -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.14/dist/js/select2.min.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <!-- COLOR & FLAG -->
    <style>
        .custom-select10 {
            position: relative;
            display: inline-block;
            vertical-align: top;
            /* Aligns the dropdowns at the top */
            margin-bottom: 10px;
            /* Adjust as needed to maintain consistent spacing */
        }

        .custom-select10 .select-btn10 {
            padding: 20px 50px;
            /* Adjust the vertical padding */
            background-color: #f1f1f1;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            /* Aligns the content center vertically */
            align-items: center;
            /* Aligns the content center vertically */
        }

        /* Dropdown content */
        .custom-select-content10 {
            position: absolute;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            overflow: hidden;
            z-index: 1;
            top: 100%;
            /* Ensures dropdowns appear below the select button */
            width: 100%;
            /* Makes dropdown width same as the select button */
        }

        /* Custom option */
        .custom-option10 {
            /* display: flex; */
            align-items: center;
            padding: 5px;
            cursor: pointer;
        }

        /* Color indicator */
        .color-indicator10 {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>


    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }


        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }
    </style>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('flag_audit_save') }}" enctype="multipart/form-data">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">audit entry </h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>ENO</label>
                                                <input type="text" class="form-control" name="eno" id="eno" value="<?php echo $eno; ?>"readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" name="edate" id="edate" readonly min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Division</label>
                                                <select class="form-control" name="div" id="div" onchange="divisionchange(this.value)" required>
                                                    <option value=""> --Select Division --</option>
                                                    @foreach ($division as $div)
                                                    <option value="{{$div['Division_id']}}">{{$div['Division']}}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" class="form-control" name="div_name" id="div_name" value=""readonly>                                           
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Team / Floor </label>
                                                <select class="form-control team_select" id="Team" name="Team" onchange="teamchange(this.value)" required>
                                                    <option value=""> --Select Team --</option>
                                                    <!-- Options will be dynamically added here -->
                                                </select>
                                                <input type="hidden" class="form-control" id="Team_nam" name="Team_nam" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Zone / Department </label>
                                                <select class="form-control zone_nam" id="zone_nam" name="zone_nam"  onchange="flagchange(this.value)" required>
                                                    <option value=""> --Select Zone --</option>
                                                    <!-- Options will be dynamically added here -->
                                                </select>
                                                <input type="hidden" class="form-control" name="zone_nam1" id="zone_nam1">
                                                <input type="hidden" class="form-control" name="resp_empl" id="resp_empl" value=""readonly>                                        
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Flag</label>
                                                <input type="text" class="form-control" name="typ_flag" id="typ_flag" value="<?php echo $typ_flag; ?>"readonly>
                                                <input type="hidden" class="form-control" name="typ_flag_id" id="typ_flag_id" value="<?php echo $typ_flag_id; ?>"readonly>                                          
                                              </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Audit</label>
                                                <select class="form-control" name="type_audit" id="type_audit" required>
                                                    <option>--Select Audit--</option>
                                                    @foreach ($typeaudit as $ty_audit)
                                                    <option value="{{$ty_audit['Rowid']}}">{{$ty_audit['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                            <label>Flag Colour</label>
                                            <br>
                                                <div class="custom-select10 color-select10 flagcol" id="colorSelect10">
                                                        <div class="select-btn10 flagcol1"></div>
                                                      <div class="custom-select-content10" style="display: none;">

                                                    </div>
                                                </div>
                                                <input type="hidden" class="flag_id" name="flag_id" id="flag_id">
                                            </div>
                                        </div>

                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>

                                    <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            <label>Add Check Point</label>
                                            <div class="add-icon">
                                                <a href="javascript:void(0);" id="addRowBtn" onclick="addRow()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- // TABLE FOR AUDITED  -->
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Check Point </th>
                                                    <th>Alloted Flag</th>
                                                    <!-- <th>Audit Flag</th> -->
                                                    <th>Remarks</th>
                                                    <th>Next Verification Date</th>
                                                    <th>Edit</th>
                                                </tr>
                                            </thead>

                                            <tbody id="tableBody">
                                                <tr id="row">
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control" name="check[]" id="check" onchange="flagshow(this.value , this)" required>
                                                            <option value="">--Select Check point--</option>
                                                            @foreach ($check_point as $check)
                                                            <option value="{{$check['Check_id']}}">{{$check['Check_point']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>

                                                    <td>
                                                        <div class="custom-select10 color-select10" id="colorSelect10">
                                                            <div class="select-btn10">
                                                            </div>
                                                            <div class="custom-select-content10" style="display: none;">

                                                                <input type="text" class="colorall" name="colorall[]" id="colorall">
                                                            </div>
                                                        </div>

                                                        <!-- <input type="hidden" name="alloted[]" id="alloted" class="form-control" readonly>
                                                        <div class="custom-select10 color-select10" id="colorSelect10">
                                                            <div class="select-btn10" style="background-color:;"></div>
                                                        </div> -->
                                                    </td>

                                                    <!-- OPTION -->
                                                    <!-- <td>
                                                        <div class="custom-select10 color-select10" id="colorSelect10">
                                                            <div class="select-btn10">
                                                                <i class="fa-solid fa-caret-down"></i>
                                                            </div>
                                                            <div class="custom-select-content10" style="display: none;">

                                                                @foreach ($flag as $res)
                                                                <div class="custom-option10" data-value="{{$res['Flag']}}" data-rowid="{{$res['Rowid']}}">
                                                                    <div class="color-indicator10" style="background-color: {{$res['Flag']}};"></div>
                                                                </div>
                                                                @endforeach

                                                            </div>
                                                        </div>
                                                        <input type="hidden" id="selectedRowIdInput" name="selectedRowId[]" readonly>
                                                    </td> -->
                                                    <td>
                                                        <input type="text" name="remarks[]" id="remarks" class="form-control">
                                                    </td>
                                                    <td>
                                                    <input type="date" class="form-control" name="nxt_date[]" id="nxt_date" required>

                                                    </td>
                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>

                                            </tbody>

                                        </table>
                                    </div>

                                    <!-- <br> -->
                                    <!-- <div class="row">
                                        <div class="col-md-3 col-lg-3 ml-3">
                                            <label>Add Check Point</label>
                                            <div class="add-icon">
                                                <a href="javascript:void(0);" id="addRowBtn" onclick="addRow1()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                            </div>
                                        </div>
                                    </div> -->
                                    <!-- <br> -->
                                    <!-- // TABLE FOR REMARKS  -->
                                    <!-- <div class="table-container">
                                        <table id="app_table1" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Check Point </th>
                                                    <th>Remarks</th>
                                                    <th>Edit</th>

                                                </tr>
                                            </thead>
                                            <tbody id="tableBody1">
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control" name="check1[]" id="check1" required>
                                                            <option value="">--Select Check point--</option>
                                                            @foreach ($check_point as $check)
                                                            <option value="{{$check['Check_id']}}">{{$check['Check_point']}}</option>
                                                            @endforeach
                                                        </select>

                                                    </td>
                                                    <td>
                                                        <input type="text" name="remarks[]" id="remarks" class="form-control">
                                                    </td>
                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>
                                            </tbody>

                                        </table>
                                    </div> -->

                                    <br>
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="form-group">
                                                <label>Remarks</label>
                                                <textarea class="form-control" rows="4" name="Remark" id="Remark" required></textarea>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                            <div class="row">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <!-- <div class="form-group row">
                                                        <label for="ver_date" class="col-sm-4 col-form-label"> Next Verification Date </label>
                                                        <div class="col-sm-6">
                                                            <input type="date" class="form-control" name="nxt_date" id="nxt_date" required>
                                                        </div>
                                                    </div> -->
                                                    <div class="form-group row">
                                                        <label for="attach_1" class="col-sm-4 col-form-label"> Attachement -1</label>
                                                        <div class="col-sm-6">
                                                            <!-- <input class="form-control" type="file" id="formFile1" name="formFile1"> -->
                                                            <input type="file" class="form-control" name="file1" id="file1">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_3" class="col-sm-4 col-form-label"> Attachement -3</label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file3" id="file3">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_5" class="col-sm-4 col-form-label"> Attachement -5 </label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file5" id="file5">
                                                        </div>
                                                    </div>
                                                    
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="form-group row">
                                                        <label for="attach_2" class="col-sm-4 col-form-label"> Attachement -2</label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file2" id="file2">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label for="attach_4" class="col-sm-4 col-form-label"> Attachement -4 </label>
                                                        <div class="col-sm-6">
                                                            <input type="file" class="form-control" name="file4" id="file4">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12 col-md-12">
                                    <div class="text-center">
                                        <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-primary">
                                        <button type="button" id="clearButton" class="btn btn-success ml-5" onclick="clearPage()">CLEAR</button>

                                        <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                        <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <!-- FOR AUDIT FLAG ID  -->
    <script>
        // Add an event listener to handle dropdown option selection
        document.addEventListener('DOMContentLoaded', function() {
            var colorSelect = document.getElementById('colorSelect10');
            var selectedRowIdInput = document.getElementById('selectedRowIdInput');

            colorSelect.addEventListener('click', function() {
                // Toggle dropdown content visibility
                var dropdownContent = colorSelect.querySelector('.custom-select-content10');
                dropdownContent.style.display = (dropdownContent.style.display === 'none') ? 'block' : 'none';
            });

            // Add event listener to each color option
            var colorOptions = document.querySelectorAll('.custom-option10');
            colorOptions.forEach(function(option) {
                option.addEventListener('click', function() {
                    // Get the data-rowid attribute value
                    var selectedRowId = option.getAttribute('data-rowid');

                    // Update the input box with the selected rowid
                    selectedRowIdInput.value = selectedRowId;

                    // Hide the dropdown content
                    var dropdownContent = colorSelect.querySelector('.custom-select-content10');
                    dropdownContent.style.display = 'none';
                });
            });
        });
    </script>

    <!-- AJAX METHOD FOR ALLOTED FLAG COLOUR -->
    <script>
        function flagshow(check_id, selectElement) {
            var selected_check = check_id;

            $.ajax({
                url: "{{ route('flag_audit2') }}",
                type: "GET",
                data: {
                    selected_check: selected_check,
                },
                dataType: 'json',
                success: function(flag) {
                    if (flag.length > 0) {
                        console.log(flag);

                        var flag_col = flag[0].Flag;
                        var FlagID = flag[0].FlagID;
                        console.log(flag_col, FlagID);

                        // Update the color of the select button in the next td
                        var currentColumn = $(selectElement).closest('td').next();
                        currentColumn.find('.custom-select10.color-select10 .select-btn10').css("background-color", flag_col);

                        // Update the value of the input field in the next td
                        currentColumn.find('.colorall').val(FlagID);
                    }
                }
            });
        }
    </script>


    <!-- // FOR AUDITED ADD -->
    <script>
        function addRow() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody");

            var firstRowDate = tbody.querySelector("#nxt_date").value;

            var newRow = table.insertRow(table.rows.length);
            var sno = table.rows.length - 1;

            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            var cell5 = newRow.insertCell(4);
            var cell6 = newRow.insertCell(5);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check[]" id="check" onchange="flagshow(this.value , this)" required>' +
                '<option value="">--Select Check point--</option>' +
                '@foreach ($check_point as $check)' +
                '<option value="{{$check['Check_id']}}">{{$check['Check_point']}}</option>' +
                '@endforeach' +
                '</select>';

            cell3.innerHTML = ' <div class="custom-select10 color-select10" id="colorSelect10_' + sno + '">' +
                '<div class="select-btn10">' +
                '</div>' +
                '<div class="custom-select-content10" style="display: none;">' +
                '<div class="custom-option10" data-value="">' +
                '<div class="color-indicator10" style="background-color:;"></div>' +
                '</div>' +
                '<input type="text" class="colorall" name="colorall[]">' +
                '</div>' +
                '</div>';

            // cell4.innerHTML = '<div class="custom-select10 color-select10" id="flagSelect10_' + sno + '">' +
            //     '<div class="select-btn10">' +
            //     '<i class="fa-solid fa-caret-down"></i>' +
            //     '</div>' +
            //     '<div class="custom-select-content10" style="display: none;">' +
            //     '@foreach ($flag as $res)' +
            //     '<div class="custom-option10" data-value="{{$res['Flag']}}" data-rowid="{{$res['Rowid']}}">' +
            //     '<div class="color-indicator10" style="background-color: {{$res['Flag']}};"></div>' +
            //     '</div>' +
            //     '@endforeach' +
            //     '</div>' +
            //     '</div>' +
            //     '<input type="hidden" id="selectedRowIdInput_' + sno + '" name="selectedRowId[]" readonly>';
            cell4.innerHTML = '<input type="text" name="remarks[]" id="remarks" class="form-control" >'; // remarks
            // cell5.innerHTML = '<input type="date" class="form-control" name="nxt_date[]" id="nxt_date" required>'; // next verif
            
            cell5.innerHTML = '<input type="date" class="form-control" name="nxt_date[]" id="nxt_date" value="' + firstRowDate + '" required>'; // next verif
    
            
            cell6.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Setting up color select functionality for the new row
            var colorSelectBtn = cell3.querySelector(".select-btn10");
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects(this);
                var selectContent = this.parentNode.querySelector(".custom-select-content10");
                selectContent.style.display = "block";
                selectedRowId.value = sno; // Store the index of the clicked row
                e.stopPropagation();
            });

            // Get the newly added selectedRowIdInput element
            var selectedRowIdInput = newRow.querySelector('input[name="selectedRowId[]"]');

            var colorOptions = cell3.querySelectorAll('.custom-option10');
            colorOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var value = option.getAttribute("data-value");
                    var colorIndicator = document.createElement("div");
                    colorIndicator.classList.add("color-indicator10");
                    colorIndicator.style.backgroundColor = value;
                    var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn10");
                    colorSelectBtn.textContent = ""; // Clear text
                    colorSelectBtn.appendChild(colorIndicator);
                    closeAllCustomSelects();

                    // Get the index of the clicked row
                    var rowIndex = selectedRowIdInput.value;

                    // Update the input field associated with the clicked row
                    selectedRowIdInput.value = option.getAttribute("data-rowid");
                });
            });

        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }
    </script>


    <!-- // FOR REMARKS  -->
    <!-- <script>
        function addRow1() {
            var table = document.getElementById("app_table1");
            var tbody = document.getElementById("tableBody1");

            var newRow = table.insertRow(table.rows.length);
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            // var cell5 = newRow.insertCell(4);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check1[]" id="check1" onchange="flagshow(this.value , this)" required>' +
                '<option value="">--Select Check point--</option>' +
                '@foreach ($check_point as $check)' +
                '<option value="{{$check['Check_id']}}">{{$check['Check_point']}}</option>' +
                '@endforeach' +
                '</select>';
            // cell3.innerHTML = '<input type="text" name="audited1[]" id="audited1" class="form-control"  >'; // Alloted
            cell3.innerHTML = '<input type="text" name="remarks[]" id="remarks" class="form-control" >'; // Audited
            cell4.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Initialize Select2 using ID
            // $(document).ready(function() {
            //     $('#check1' + (table.rows.length - 1)).select2();
            // });

            updateTotal();
        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }
    </script> -->

    <!-- AJAX METHOD FOR DIVISION SELECTION -->
    <script>

        function divisionchange(div_id) {
            var selected_div = div_id;

            $.ajax({
                url: "{{ route('flag_audit1') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                },
                dataType: 'json',
                success: function(division_id) {
                    if (division_id.length > 0) {
                        console.log(division_id);

                        var selectedDivisionName = $('#div option:selected').text();
                        $('#div_name').val(selectedDivisionName);

                        // Clear existing options
                        $('.team_select').empty();

                        // Append the "--Select Team--" option first
                        $('.team_select').append('<option value=""> --Select Team -- </option>');

                        // Populate dropdown with new options
                        $.each(division_id, function(index, option) {
                            var teamOption = $('<option>', {
                                value: option.Team_id,
                                text: option.Team
                            });

                            $('.team_select').append(teamOption);
                        });

                        // Trigger change event to update hidden input
                        $('.team_select').trigger('change');
                        
                        // // Clear existing options
                        // $('.zone_nam').empty();

                        // // Append the "--Select Zone--" option first
                        // $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                        // // Populate dropdown with new options
                        // $.each(division_id, function(index, option) {
                        //     var zoneOption = $('<option>', {
                        //         value: option.Rowid,
                        //         text: option.Zone
                        //     });

                        //     $('.zone_nam').append(zoneOption);
                        // });
                    }
                }
            });
        }

                // Function to handle team selection change
                $('.team_select').change(function() {
                    var selectedTeamName = $(this).find('option:selected').text();
                    $('#Team_nam').val(selectedTeamName);
                });

                // // Function to handle zone selection change
                // $('.zone_nam').change(function() {
                //     var selectedZoneName = $(this).find('option:selected').text();
                //     $('#zone_nam1').val(selectedZoneName);
                // });

    </script>
    
        <!-- AJAX METHOD FOR TEAM SELECTION -->
        <script>

                function teamchange(team_id) {
                    var selected_team = team_id;

                    $.ajax({
                        url: "{{ route('flag_audit4') }}",
                        type: "GET",
                        data: {
                            selected_team: selected_team,
                        },
                        dataType: 'json',
                        success: function(team_id) {
                            if (team_id.length > 0) {
                                console.log(team_id);

                                // var selectedDivisionName = $('#div option:selected').text();
                                // $('#div_name').val(selectedDivisionName);

                                // // Clear existing options
                                // $('.team_select').empty();

                                // // Append the "--Select Team--" option first
                                // $('.team_select').append('<option value=""> --Select Team -- </option>');

                                // // Populate dropdown with new options
                                // $.each(division_id, function(index, option) {
                                //     var teamOption = $('<option>', {
                                //         value: option.Team_id,
                                //         text: option.Team
                                //     });

                                //     $('.team_select').append(teamOption);
                                // });

                                // // Trigger change event to update hidden input
                                // $('.team_select').trigger('change');
                                
                                // Clear existing options
                                $('.zone_nam').empty();

                                // Append the "--Select Zone--" option first
                                $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                                // Populate dropdown with new options
                                $.each(team_id, function(index, option) {
                                    var zoneOption = $('<option>', {
                                        value: option.Zone_id,
                                        text: option.Zone
                                    });

                                    $('.zone_nam').append(zoneOption);
                                });
                            }
                        }
                    });
                }

                // Function to handle zone selection change
                $('.zone_nam').change(function() {
                    var selectedZoneName = $(this).find('option:selected').text();
                    $('#zone_nam1').val(selectedZoneName);
                });

        </script>
 <!-- AJAX METHOD FOR FLAG COLOR -->
<script>
    function flagchange(zone_id) {
        var zoneId = zone_id;
        var teamId = $('[name="Team"]').val();
        var div_id = $('[name="div"]').val();
        console.log(div_id, teamId, zoneId);

        $.ajax({
            url: "{{ route('flag_audit3') }}",
            type: "GET",
            data: {
                div_id: div_id,
                teamId: teamId,
                zoneId: zoneId,
            },
            dataType: 'json',
            success: function (flag_color) {
                if (flag_color.length > 0) {
                    console.log(flag_color);
                    
                    // Extract flag color and flag ID from the response
                    var Flag = flag_color[0].Flag;
                    var FlagID = flag_color[0].FlagID;
                    var Resp_emplno = flag_color[0].Resp_emplno;
                    console.log(Flag,FlagID);

                    // Display the flag color in the div
                    $('.flagcol .flagcol1').css("background-color", Flag);

                     // Set the flag ID in the input field
                        $('#flag_id').val(FlagID);
                       
                        $('#resp_empl').val(Resp_emplno);
                }
            }
        });
    }
</script>


    <!-- COLOR AND FLAG GROUP -->
    <script>
        // JavaScript for custom select functionality
        document.addEventListener("click", function(e) {
            closeAllCustomSelects(e.target);
        });

        // Function to close all custom selects except the one passed as argument
        function closeAllCustomSelects(exceptThis) {
            var customSelects = document.querySelectorAll(".custom-select10");
            customSelects.forEach(function(customSelect) {
                if (exceptThis !== customSelect && !customSelect.contains(exceptThis)) {
                    var content = customSelect.querySelector(".custom-select-content10");
                    content.style.display = "none";
                }
            });
        }

        // Handling color select
        var colorSelectBtns = document.querySelectorAll(".color-select10 .select-btn10");
        var colorOptions = document.querySelectorAll(".color-select10 .custom-option10");

        colorSelectBtns.forEach(function(colorSelectBtn, index) {
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                var selectContent = this.parentNode.querySelector(".custom-select-content10");
                selectContent.style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });
        });

        colorOptions.forEach(function(option) {
            option.addEventListener("click", function() {
                var value = option.getAttribute("data-value");
                var colorIndicator = document.createElement("div");
                colorIndicator.classList.add("color-indicator10");
                colorIndicator.style.backgroundColor = value;
                var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn10");
                colorSelectBtn.textContent = ""; // Clear text
                colorSelectBtn.appendChild(colorIndicator);
                closeAllCustomSelects();

                // Get the index of the clicked row
                var rowIndex = selectedRowId.value;

                // Update the input field associated with the clicked row
                var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="color"]');
                if (rowInput) {
                    rowInput.value = value;
                }
            });
        });

        // Handling flag select
        var flagSelects = document.querySelectorAll(".flag-select");
        flagSelects.forEach(function(flagSelect, index) {
            var flagSelectBtn = flagSelect.querySelector(".select-btn10");
            var flagOptions = flagSelect.querySelectorAll(".custom-option10");

            flagSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                flagSelect.querySelector(".custom-select-content10").style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });

            flagOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var flagIcon = option.querySelector("i").cloneNode(true); // Clone the flag icon
                    flagSelectBtn.textContent = ""; // Clear text
                    flagSelectBtn.appendChild(flagIcon); // Add the flag icon to the select button
                    closeAllCustomSelects(); // Close the dropdown
                    var value = option.getAttribute("data-value");
                    selectedFlagInput.value = value; // Update flag input value

                    // Update the input field associated with the clicked row
                    var rowIndex = selectedRowId.value;
                    var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="flag"]');
                    if (rowInput) {
                        rowInput.value = value;
                    }
                });
            });
        });
    </script>

    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('edate').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>


    <!-- SEARCH -->
    <!-- <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#div, #type_s, #type_audit,#Team').select2();
        });
    </script> -->


    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>