<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>CHECK LIST ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link rel="stylesheet" href="assets/css/5s/style.css">
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->
    <style>
        .total {
            margin-left: 475px;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }



        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }


        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }
    </style>


    <!-- COLOR & FLAG -->
    <style>
        .custom-select10 {
            position: relative;
            display: inline-block;
            vertical-align: top;
            /* Aligns the dropdowns at the top */
            margin-bottom: 10px;
            /* Adjust as needed to maintain consistent spacing */
        }

        .custom-select10 .select-btn10 {
            padding: 10px 15px;
            /* Adjust the vertical padding */
            background-color: #f1f1f1;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            /* Aligns the content center vertically */
            align-items: center;
            /* Aligns the content center vertically */
        }

        /* Dropdown content */
        .custom-select-content10 {
            position: absolute;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            overflow: hidden;
            z-index: 1;
            top: 100%;
            /* Ensures dropdowns appear below the select button */
            width: 100%;
            /* Makes dropdown width same as the select button */
        }

        /* Custom option */
        .custom-option10 {
            /* display: flex; */
            align-items: center;
            padding: 5px;
            cursor: pointer;
        }

        /* Color indicator */
        .color-indicator10 {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('flag_check_save') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>
                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">checklist</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Effect From </label>
                                                <input type="date" class="form-control" id="eff" name="eff" required min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Date </label>
                                                <input type="date" class="form-control" id="date" name="date" value="" required min="<?php echo date('Y-m-d'); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Type of Flag</label>
                                                <input type="text" class="form-control" name="typ_flag" id="typ_flag" value="<?php echo $typ_flag; ?>" readonly>
                                                <input type="hidden" class="form-control" name="typ_flag_id" id="typ_flag_id" value="<?php echo $typ_flag_id; ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <div class="form-group">
                                                <label>Add Checklist</label>
                                                <div class="add-icon">
                                                    <a href="javascript:void(0);" id="addRowBtn" onclick="addRow()"><img src="assets/img/5s/5spluss.png" alt="img" style="width: 30px; height: 30px;"></a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Add more col-md-3 or adjust the grid classes as needed for other input fields -->
                                    </div>
                                    <br>
                                    <div class="table-container">
                                        <table id="app_table" class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Checklist</th>
                                                    <th>Flag</th>
                                                    <th>Edit</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tableBody">
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <select class="form-control" name="check[]" id="check" required>
                                                            <option value="">--Select Check point--</option>
                                                            @foreach ($check_point as $check)
                                                            <option value="{{$check['Rowid']}}">{{$check['Name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>


                                                    <td>
                                                        <div class="custom-select10 color-select10" id="colorSelect10">
                                                            <div class="select-btn10">
                                                                <i class="fa-solid fa-caret-down"></i>
                                                            </div>
                                                            <div class="custom-select-content10" style="display: none;">

                                                                @foreach ($flag as $res)
                                                                <div class="custom-option10" data-value="{{$res['Flag']}}" data-rowid="{{$res['Rowid']}}">
                                                                    <div class="color-indicator10" style="background-color: {{$res['Flag']}};"></div>
                                                                </div>
                                                                @endforeach

                                                            </div>
                                                        </div>
                                                        <input type="hidden" id="selectedRowIdInput" name="selectedRowId[]" readonly>
                                                    </td>


                                                    <td>
                                                        <a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                    </td>
                                                </tr>
                                            </tbody>

                                        </table>
                                    </div>
                                    <br>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-primary">
                                        <button type="button" id="clearButton" class="btn btn-success ml-5" onclick="clearPage()">CLEAR</button>
                                        <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/FLAG_checklist_Report'">Report</button>


                                        <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                        <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                    </div>
                                </div>
                                <br>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </form>

    <!-- FOR AUDIT FLAG ID  -->
    <script>
        // Add event listener to the color selection
        document.addEventListener('DOMContentLoaded', function() {
            var colorOptions = document.querySelectorAll('.custom-option10');

            colorOptions.forEach(function(option) {
                option.addEventListener('click', function() {
                    var selectedRowId = this.getAttribute('data-rowid');
                    document.getElementById('selectedRowIdInput').value = selectedRowId;
                });
            });
        });
    </script>

    <!-- // FOR AUDITED ADD -->
    <script>
        function addRow() {
            var table = document.getElementById("app_table");
            var tbody = document.getElementById("tableBody");

            var newRow = table.insertRow(table.rows.length);
            var sno = table.rows.length - 1;

            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);

            cell1.innerHTML = table.rows.length - 1; // SNO
            cell2.innerHTML = '<select class="form-control" name="check[]" id="check' + (table.rows.length - 1) + '" onchange="checkvalue(this.value, this)" required>' +
                '<option value="">--Select Check point--</option>' +
                '@foreach ($check_point as $check)' +
                '<option value="{{$check['Rowid']}}">{{$check['Name']}}</option>' +
                '@endforeach' +
                '</select>';

            cell3.innerHTML = '<div class="custom-select10 color-select10">' +
                '<div class="select-btn10">' +
                '<i class="fa-solid fa-caret-down"></i>' +
                '</div>' +
                '<div class="custom-select-content10" style="display: none;">' +
                '@foreach ($flag as $res)' +
                '<div class="custom-option10" data-value="{{$res['Flag']}}" data-rowid="{{$res['Rowid']}}">' +
                '<div class="color-indicator10" style="background-color: {{$res['Flag']}};"></div>' +
                '</div>' +
                '@endforeach' +
                '</div>' +
                '</div>' +
                '<input type="hidden" class="selectedRowIdInput" name="selectedRowId[]" readonly>';

            cell4.innerHTML = '<a class="delete-set" onclick="confirmDelete(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>';

            // Setting up color select functionality for the new row
            var colorSelectBtn = cell3.querySelector(".select-btn10");
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects(this);
                var selectContent = this.parentNode.querySelector(".custom-select-content10");
                selectContent.style.display = "block";
                var selectedRowIdInput = this.parentNode.querySelector(".selectedRowIdInput");
                if (selectedRowIdInput) {
                    selectedRowIdInput.value = this.parentNode.querySelector(".custom-option10").getAttribute("data-rowid");
                }
                e.stopPropagation();
            });

            // Handling color option click
            var colorOptions = document.querySelectorAll(".color-select10 .custom-option10");
            colorOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var value = option.getAttribute("data-value");
                    var rowId = option.getAttribute("data-rowid"); // Get the data-rowid attribute value
                    console.log("Row ID:", rowId); // Log the row ID to check if it's fetched correctly
                    var colorIndicator = document.createElement("div");
                    colorIndicator.classList.add("color-indicator10");
                    colorIndicator.style.backgroundColor = value;
                    var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn10");
                    colorSelectBtn.textContent = ""; // Clear text
                    colorSelectBtn.appendChild(colorIndicator);
                    closeAllCustomSelects();

                    // Update the input field associated with the clicked row
                    var selectedRowIdInput = option.closest("td").querySelector(".selectedRowIdInput");
                    if (selectedRowIdInput) {
                        selectedRowIdInput.value = rowId;
                        console.log("Selected Row ID Input Value:", selectedRowIdInput.value); // Log the value after setting it
                    }
                });
            });

        }

        function confirmDelete(element) {
            var result = confirm("Are you sure you want to delete this row?");
            if (result) {
                deleteRow(element);
            }
        }

        function deleteRow(element) {
            var row = element.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }
    </script>

    <!-- COLOR AND FLAG GROUP -->
    <script>
        // JavaScript for custom select functionality
        document.addEventListener("click", function(e) {
            closeAllCustomSelects(e.target);
        });

        // Function to close all custom selects except the one passed as argument
        function closeAllCustomSelects(exceptThis) {
            var customSelects = document.querySelectorAll(".custom-select10");
            customSelects.forEach(function(customSelect) {
                if (exceptThis !== customSelect && !customSelect.contains(exceptThis)) {
                    var content = customSelect.querySelector(".custom-select-content10");
                    content.style.display = "none";
                }
            });
        }

        // Handling color select
        var colorSelectBtns = document.querySelectorAll(".color-select10 .select-btn10");
        var colorOptions = document.querySelectorAll(".color-select10 .custom-option10");

        colorSelectBtns.forEach(function(colorSelectBtn, index) {
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                var selectContent = this.parentNode.querySelector(".custom-select-content10");
                selectContent.style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });
        });

        colorOptions.forEach(function(option) {
            option.addEventListener("click", function() {
                var value = option.getAttribute("data-value");
                var colorIndicator = document.createElement("div");
                colorIndicator.classList.add("color-indicator10");
                colorIndicator.style.backgroundColor = value;
                var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn10");
                colorSelectBtn.textContent = ""; // Clear text
                colorSelectBtn.appendChild(colorIndicator);
                closeAllCustomSelects();

                // Get the index of the clicked row
                var rowIndex = selectedRowId.value;

                // Update the input field associated with the clicked row
                var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="color"]');
                if (rowInput) {
                    rowInput.value = value;
                }
            });
        });

        // Handling flag select
        var flagSelects = document.querySelectorAll(".flag-select");
        flagSelects.forEach(function(flagSelect, index) {
            var flagSelectBtn = flagSelect.querySelector(".select-btn10");
            var flagOptions = flagSelect.querySelectorAll(".custom-option10");

            flagSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                flagSelect.querySelector(".custom-select-content10").style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });

            flagOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var flagIcon = option.querySelector("i").cloneNode(true); // Clone the flag icon
                    flagSelectBtn.textContent = ""; // Clear text
                    flagSelectBtn.appendChild(flagIcon); // Add the flag icon to the select button
                    closeAllCustomSelects(); // Close the dropdown
                    var value = option.getAttribute("data-value");
                    selectedFlagInput.value = value; // Update flag input value

                    // Update the input field associated with the clicked row
                    var rowIndex = selectedRowId.value;
                    var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="flag"]');
                    if (rowInput) {
                        rowInput.value = value;
                    }
                });
            });
        });
    </script>

    <!-- //CURRENT DATE  -->
    <script>
        // Function to format the current date as "YYYY-MM-DD"
        function getCurrentDate() {
            var today = new Date();
            var year = today.getFullYear();
            var month = (today.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-indexed
            var day = today.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        // Set the current date as the default value for the date input
        document.getElementById('date').value = getCurrentDate();
        document.getElementById('eff').value = getCurrentDate();
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            // Update the ID to match the dynamically added row
            $('select[id^="Select"]').select2();
        });
    </script>

    <!-- <script>
    // Initialize Select2 using ID
    $(document).ready(function() {
        // Update the ID to match the dynamically added row
        $('.empSelect').select2();
    });
</script> -->


    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection
</body>

</html>