<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<title>Flag Dashboard - Gainup</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

	<link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

	<link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

	<link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

	<link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
	<link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

	<link rel="stylesheet" href="assets/css/5s/fullcalendar.min.css">

	<link rel="stylesheet" href="assets/css/5s/dataTables.bootstrap4.min.css">

	<link rel="stylesheet" href="assets/plugins/5s/morris/morris.css">

	<link rel="stylesheet" href="assets/css/5s/style.css">
	<!--[if lt IE 9]>
		<script src="assets/js/html5shiv.min.js"></script>
		<script src="assets/js/respond.min.js"></script>
	<![endif]-->

	<!-- COLOR & FLAG -->
	<style>
		.custom-select10 {
			position: relative;
			display: inline-block;
			vertical-align: top;
			/* Aligns the dropdowns at the top */
			margin-bottom: 10px;
			/* Adjust as needed to maintain consistent spacing */
		}

		.custom-select10 .select-btn10 {
			padding: 20px 50px;
			/* Adjust the vertical padding */
			background-color: #f1f1f1;
			border-radius: 5px;
			cursor: pointer;
			display: flex;
			/* Aligns the content center vertically */
			align-items: center;
			/* Aligns the content center vertically */
		}

		/* Dropdown content */
		.custom-select-content10 {
			position: absolute;
			background-color: #fff;
			box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
			border-radius: 5px;
			overflow: hidden;
			z-index: 1;
			top: 100%;
			/* Ensures dropdowns appear below the select button */
			width: 100%;
			/* Makes dropdown width same as the select button */
		}

		/* Custom option */
		.custom-option10 {
			/* display: flex; */
			align-items: center;
			padding: 5px;
			cursor: pointer;
		}

		/* Color indicator */
		.color-indicator10 {
			width: 30px;
			height: 30px;
			border-radius: 50%;
			margin-right: 5px;
		}

		.flag-indicator {
			width: 20px;
			height: 20px;
			border-radius: 50%;
			margin-right: 5px;
		}

		.table-responsive .row .col-sm-12 .dataTables_info {
			display: none !important;
		}

		.table-container {
			overflow-x: auto;
			max-height: 400px;
			/* Set a maximum height for the scrollable table */
		}

		.thead-light {
			position: sticky;
			top: 0;
		}
	</style>


</head>

<body>

	@extends('Flag.flag_nav')
	@section('content')

	<div class="page-wrapper">
		<div class="content container-fluid">

			<div class="page-header">
				<div class="row">
					<div class="col-md-6">
						<h3 class="page-title mb-0">Dashboard</h3>
					</div>
					<div class="col-md-6">
						<ul class="breadcrumb mb-0 p-0 float-right">
							<li class="breadcrumb-item"><a href="FLAG_Dashboard"><i class="fas fa-home"></i> Home</a>
							</li>
							<li class="breadcrumb-item"><span>Dashboard</span></li>
						</ul>
					</div>
				</div>
			</div>
			<!-- FIRST 4 BOXES -->
			<div class="row">
				<div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
					<div class="dash-widget dash-widget5">
						<span class="float-left"><img src="assets/img/5s/dash/dash_image.jpg" alt="" height="80" width="110"></span>
						<div class="dash-widget-info text-right">
							<span>MAIN BUILDING</span>
							<br>
							<span> (Last Audited Date)</span>
							<h3>

								@if($main_date == "01-01-1900")
								NOT AUDITED
								@else
								<?php echo $main_date; ?>
								@endif
							</h3>
						</div>
					</div>
				</div>
				<div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
					<div class="dash-widget dash-widget5">
						<div class="dash-widget-info text-left d-inline-block">
							<span>SPINNING</span>
							<br>
							<span> (Last Audited Date)</span>
							<h3>
								@if($spinn_date == "01-01-1900")
								NOT AUDITED
								@else
								<?php echo $spinn_date; ?>
								@endif

							</h3>
						</div>
						<span class="float-right"><img src="assets/img/5s/dash/dash_image1.jpg" height="80" width="100" alt=""></span>
					</div>
				</div>
				<div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
					<div class="dash-widget dash-widget5">
						<span class="float-left"><img src="assets/img/5s/dash/dash_image2.jpg" alt="" height="80" width="100"></span>
						<div class="dash-widget-info text-right">
							<span>TECHNOTEK</span>
							<br>
							<span> (Last Audited Date)</span>
							<h3>
								@if($techno_date == "01-01-1900")
								NOT AUDITED
								@else
								<?php echo $techno_date; ?>
								@endif
							</h3>
						</div>
					</div>
				</div>
				<div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
					<div class="dash-widget dash-widget5">
						<div class="dash-widget-info d-inline-block text-left">
							<span>Next Verification Date</span>
							<h3>
								
								@if($nxt_ver_date == "01-01-1900")
								NOT AUDITED
								@else
								<?php echo $nxt_ver_date; ?>
								@endif
							</h3>
						</div>
						<span class="float-right"><img src="assets/img/5s/dash/dash_nxt.jpg" alt="" width="120"></span>
					</div>
				</div>
			</div>
			<!-- AUDIT LIST & AUDIT PENDING LIST -->
			<div class="row">
				<div class="col-lg-6 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Audit List
									</div>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="table-responsive">
										<table class="table custom-table">
											<thead class="thead-light">
												<tr>
													<th>Audit Status </th>
													<th>Division</th>
													<th>Team</th>
													<th>Zone</th>
													<th>Flag Colour</th>
													<th>Date</th>
												</tr>
											</thead>
											<tbody>
												@foreach ($audit_list as $index => $des)

												<tr>
													<td>

														@if ($des['Status'] == "OPEN")
														<a class="avatar bg-green" title="OPEN">O</a>
														@elseif ($des['Status'] == "CLOSE")
														<a class="avatar bg-green" title="CLOSE">C</a>
														@else
														--
														@endif

													</td>
													<td>{{ $des['Division'] }}</td>
													<td>{{ $des['Team'] }}</td>
													<td>{{ $des['Zone'] }}</td>
													<td>
														<div class="custom-select10 color-select10">
															<div class="select-btn10" style="background-color: {{ $des['Flag'] }} ;"> </div>
															<div class="custom-select-content10" style="display: none;">
															</div>
														</div>
													</td>
													<td>{{ date('d-m-Y', strtotime($des['E_date'])) }}</td>
												</tr>
												@endforeach
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Audit Entry Pendings
									</div>
								</div>
								<!-- <div class="col text-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div> -->
							</div>
						</div>
						<div class="card-body">
							<div id="chart2"></div>
						</div>
					</div>
				</div>
			</div>
			<!-- CHECKLIST & TOTAL CHECKLIST -->
			<div class="row">
				<div class="col-lg-6 col-md-12 col-12 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Recent Checklists Flag
									</div>
								</div>
								<!-- <div class="col text-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div> -->
							</div>
						</div>
						<div class="card-body">
							<div id="bar"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-md-12 col-12 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Checklist
									</div>
								</div>
								<!-- <div class="col text-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div> -->
							</div>
						</div>
						<div class="card-body d-flex align-items-center justify-content-center overflow-hidden">
							<div id="train"> </div>
						</div>
					</div>
				</div>
			</div>


			<!-- <div class="row">
				<div class="col-lg-6 col-md-12 col-12 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Income Monthwise
									</div>
								</div>
								<div class="col text-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div id="chart4"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 d-flex">
					<div class="card flex-fill">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-auto">
									<div class="page-title">
										Audit List
									</div>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="table-responsive">
										<table class="table custom-table">
											<thead class="thead-light">
												<tr>
													<th>Audit Status </th>
													<th>Division</th>
													<th>Team</th>
													<th>Zone</th>
													<th>Flag Colour</th>
													<th>Date</th>
												</tr>
											</thead>
											<tbody>
												@foreach ($audit_list as $index => $des)

												<tr>
													<td>

														@if ($des['Status'] == "OPEN")
														<a class="avatar bg-green">O</a>
														@elseif ($des['Status'] == "CLOSE")
														<a class="avatar bg-green">C</a>
														@else
														--
														@endif

													</td>
													<td>{{ $des['Division'] }}</td>
													<td>{{ $des['Team'] }}</td>
													<td>{{ $des['Zone'] }}</td>
													<td>
														<div class="custom-select10 color-select10">
															<div class="select-btn10" style="background-color: {{ $des['Flag'] }} ;"> </div>
															<div class="custom-select-content10" style="display: none;">
															</div>
														</div>
													</td>
													<td>{{ date('d-m-Y', strtotime($des['E_date'])) }}</td>
												</tr>
												@endforeach
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div> -->
			<!-- <div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-sm-6">
									<div class="page-title">
										All Students
									</div>
								</div>
								<div class="col-sm-6 text-sm-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-outline-primary mr-2"><img src="assets/img/excel.png" alt=""><span class="ml-2">Excel</span></button>
										<button class="btn btn-outline-danger mr-2"><img src="assets/img/pdf.png" alt="" height="18"><span class="ml-2">PDF</span></button>
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div class="table-responsive">
								<table class="table custom-table">
									<thead class="thead-light">
										<tr>
											<th>Name </th>
											<th>Student ID</th>
											<th>Class</th>
											<th>Section</th>
											<th>Mobile</th>
											<th>Date of Birth</th>
											<th class="text-right">Action</th>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-1.jpg" alt=""></a><a href="profile.html">Parker <span></span></a></h2>
											</td>
											<td>ST-0d001</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-2.jpg" alt=""></a><a href="profile.html">Smith <span></span></a></h2>
											</td>
											<td>ST-0d002</td>
											<td>2</td>
											<td>B</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-3.jpg" alt=""></a><a href="profile.html">Hensley<span></span></a></h2>
											</td>
											<td>ST-0d003</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-4.jpg" alt=""></a><a href="profile.html">Friesen<span></span></a></h2>
											</td>
											<td>ST-0d004</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-5.jpg" alt=""></a><a href="profile.html">Jackson<span></span></a></h2>
											</td>
											<td>ST-0d005</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-6.jpg" alt=""></a><a href="profile.html">Mason<span></span></a></h2>
											</td>
											<td>ST-0d006</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
										<tr>
											<td>
												<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-7.jpg" alt=""></a><a href="profile.html">Garrett <span></span></a></h2>
											</td>
											<td>ST-0d007</td>
											<td>1</td>
											<td>A</td>
											<td>973-584-58700</td>
											<td>20/1/2021</td>
											<td class="text-right">
												<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
													<i class="far fa-edit"></i>
												</a>
												<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
													<i class="far fa-trash-alt"></i>
												</button>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header">
							<div class="row align-items-center">
								<div class="col-sm-6">
									<div class="page-title">
										New Students
									</div>
								</div>
								<div class="col-sm-6 text-sm-right">
									<div class=" mt-sm-0 mt-2">
										<button class="btn btn-outline-primary mr-2"><img src="assets/img/excel.png" alt=""><span class="ml-2">Excel</span></button>
										<button class="btn btn-outline-danger mr-2"><img src="assets/img/pdf.png" alt="" height="18"><span class="ml-2">PDF</span></button>
										<button class="btn btn-light" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
										<div class="dropdown-menu dropdown-menu-right">
											<a class="dropdown-item" href="#">Action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Another action</a>
											<div role="separator" class="dropdown-divider"></div>
											<a class="dropdown-item" href="#">Something else here</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12 col-12">
									<div class="table-responsive">
										<table class="table custom-table">
											<thead class="thead-light">
												<tr>
													<th>Name </th>
													<th>Student ID</th>
													<th>Parent Name</th>
													<th>Mobile</th>
													<th>Address</th>
													<th>Date Of Admition</th>
													<th>Fees Receipt</th>
													<th class="text-right">Action</th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-1.jpg" alt=""></a><a href="profile.html">Parker <span></span></a></h2>
													</td>
													<td>ST-0d001</td>
													<td>Mr. Johnson</td>
													<td>973-584-58700</td>
													<td>9946 Baker Rd. Marysville, </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-2.jpg" alt=""></a><a href="profile.html">Smith <span></span></a></h2>
													</td>
													<td>ST-0d002</td>
													<td>Mr. Luke Idaman</td>
													<td>973-584-58700</td>
													<td>193 S. Harrison Drive </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-3.jpg" alt=""></a><a href="profile.html">Hensley<span></span></a></h2>
													</td>
													<td>ST-0d003</td>
													<td>Mr. Kevin H</td>
													<td>973-584-58700</td>
													<td>8949 Golf St. Palm Coast </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-4.jpg" alt=""></a><a href="profile.html">Friesen<span></span></a></h2>
													</td>
													<td>ST-0d004</td>
													<td>Mr. Randy O</td>
													<td>973-584-58700</td>
													<td>23 Ohio Court Alexandria </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-5.jpg" alt=""></a><a href="profile.html">Jackson<span></span></a></h2>
													</td>
													<td>ST-0d005</td>
													<td>Mr. Steven</td>
													<td>973-584-58700</td>
													<td>338 North Cleveland Rd </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-6.jpg" alt=""></a><a href="profile.html">Mason<span></span></a></h2>
													</td>
													<td>ST-0d006</td>
													<td>Mr. Ervin</td>
													<td>973-584-58700</td>
													<td>7909 W. Sunnyslope St. </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
												<tr>
													<td>
														<h2><a href="profile.html" class="avatar text-white"><img src="assets/img/profile/img-7.jpg" alt=""></a>
															<a href="profile.html">Garrett <span></span></a>
														</h2>
													</td>
													<td>ST-0d007</td>
													<td>Mr. Marquz</td>
													<td>973-584-58700</td>
													<td>7361 Dunbar Street </td>
													<td>20/1/2021</td>
													<td><img src="assets/img/pdf.png" alt=""></td>
													<td class="text-right">
														<a href="edit-student.html" class="btn btn-primary btn-sm mb-1">
															<i class="far fa-edit"></i>
														</a>
														<button type="submit" data-toggle="modal" data-target="#delete_employee" class="btn btn-danger btn-sm mb-1">
															<i class="far fa-trash-alt"></i>
														</button>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div> -->

		</div>
	</div>

	</div>

	<!-- RECENT AUDIT PENDING -->
	<script>
		$(document).ready(function() {
			// Initialize empty arrays to store data for OPEN and CLOSE series
			var openData = [];
			var closeData = [];
			var divisionname = [];

			// Loop through the data received from the API response
			<?php foreach ($audit_pend as $entry) : ?>
				// Push the values for OPEN and CLOSE into the respective arrays
				openData.push(<?php echo $entry['Open_Count']; ?>);
				closeData.push(<?php echo $entry['Close_Count']; ?>);
				divisionname.push("<?php echo $entry['Division']; ?>"); // Add quotes around the division name
			<?php endforeach; ?>

			// Configure the chart options with the dynamically obtained data
			var options = {
				series: [{
						name: 'OPEN',
						data: openData
					},
					{
						name: 'CLOSE',
						data: closeData
					}
				],
				chart: {
					type: 'bar',
					height: 350
				},
				plotOptions: {
					bar: {
						horizontal: false,
						columnWidth: '55%',
						endingShape: 'rounded'
					}
				},
				dataLabels: {
					enabled: false
				},
				stroke: {
					show: true,
					width: 2,
					colors: ['transparent']
				},
				xaxis: {
					categories: divisionname // Use division names as x-axis categories
				},
				yaxis: {
					title: {
						text: ''
					}
				},
				colors: ["#8944D7", "#00B871"],
				fill: {
					opacity: 1
				},
				tooltip: {
					y: {
						formatter: function(val) {
							return "" + val + "";
						}
					}
				}
			};

			// Render the chart
			var chart = new ApexCharts(document.querySelector("#chart2"), options);
			chart.render();
		});
	</script>


	<!-- RECENT CHECKLIST DIVISION -->
	<script>
		$(document).ready(function() {
			var sBar = {
				chart: {
					height: 350,
					type: 'bar',
					toolbar: {
						show: false
					}
				},
				plotOptions: {
					bar: {
						horizontal: true,
					}
				},
				dataLabels: {
					enabled: false
				},
				series: [{
					data: [300, 430, 448, 470, 540, 580, 690, 1100, 1200, 1380]
					// divisionname
				}],
				xaxis: {
					categories: ['FIRE EXTINGUISHER BLOCKAGE', 'CALL POINT BLOCKAGE', 'FIRST AID BOX BLOCKAGE', 'EMERGENCY EXIT/ EXIT DOOR CLOSED', 'ALLEYWAY BLOCKAGE', 'France', 'Japan', 'United States', 'China', 'Germany'],
				}
			};
			var chart1 = new ApexCharts(document.querySelector("#bar"), sBar);
			chart1.render();
		});
	</script>


	<!--  CHECKLIST FLAG LIST -->
	<script>
		$(document).ready(function() {
			var checklist = <?php echo json_encode($checklist); ?>;

			// Morris.js Donut Chart (chart3)
			Morris.Donut({
				element: 'train',
				data: [{
						label: "Total Checklists",
						value: checklist['Total- Checklists'],
						labelColor: '#8944D7'
					},
					{
						label: "Red - Checklists",
						value: checklist['Red - Checklists'],
						labelColor: '#ff0000'
					},
					{
						label: "Green - Checklists",
						value: checklist['Green - Checklists'],
						labelColor: '#008000'
					},
					{
						label: "Amber - Checklists",
						value: checklist['Amber - Checklists'],
						labelColor: '#ffff00'
					}
				],
				colors: ['#8944D7', '#ff0000', '#008000', '#ffff00'],
				resize: true,
				redraw: true
			});
		});
	</script>


	<script src="assets/plugins/5s/apexchart/apexcharts.min.js"></script>
	<script src="assets/plugins/5s/apexchart/chart-data.js"></script>


	<script src="assets/js/5s/jquery-3.6.0.min.js"></script>

	<script src="assets/js/5s/bootstrap.bundle.min.js"></script>

	<script src="assets/js/5s/jquery.slimscroll.js"></script>

	<script src="assets/js/5s/select2.min.js"></script>
	<script src="assets/js/5s/moment.min.js"></script>

	<script src="assets/js/5s/fullcalendar.min.js"></script>
	<script src="assets/js/5s/jquery.fullcalendar.js"></script>

	<script src="assets/plugins/5s/morris/morris.min.js"></script>
	<script src="assets/plugins/5s/raphael/raphael-min.js"></script>
	<script src="assets/js/5s/apexcharts.js"></script>
	<script src="assets/js/5s/chart-data.js"></script>

	<script src="assets/js/5s/app.js"></script>

	@endsection
</body>

</html>