<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Zone Master Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- <script src="https://cdn.jsdelivr.net/npm/google-translate-api-browser@1.0.0/dist/index.js"></script> -->
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include the Google Translate API -->
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    <style>
        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

</head>

<body>


@extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>

                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">Zone master Report</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">

                        <div class="container">
                            <div class="col-md-12 col-lg-12">
                                <div class="card">
                                    <div class="card-body">
                                        <br>
                                        <div class="table-container">
                                            <table id="app_table" class="table">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>SNO</th>
                                                        <th>Zone Name</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($zonee as $index => $zon)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $zon['Zone'] }}</td>
                                                        
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-12 col-lg-12 save">
                                        <div class="text-center">
                                            <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/FLAG_zone'">Back</button>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </form>

    <script>
        function validateTamilInput(input) {
            // Regular expression to allow only Tamil characters
            var tamilRegex = /^[\u0B80-\u0BFF\s]+$/;

            // Get the input value
            var inputValue = input.value;

            // Check if the input matches the Tamil regex
            if (tamilRegex.test(inputValue)) {
                document.getElementById('tamilError').innerText = ''; // Clear any previous error message
            } else {
                document.getElementById('tamilError').innerText = 'Only Tamil characters are allowed.';
                input.value = ''; // Clear the input if it contains non-Tamil characters
            }
        }
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection
</body>

</html>