<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Flag Master</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- <script src="https://cdn.jsdelivr.net/npm/google-translate-api-browser@1.0.0/dist/index.js"></script> -->
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include the Google Translate API -->
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- COLOR & FLAG -->
    <style>
        .custom-select10 {
            position: relative;
            display: inline-block;
            vertical-align: top;
            /* Aligns the dropdowns at the top */
            margin-bottom: 10px;
            /* Adjust as needed to maintain consistent spacing */
        }

        .custom-select10 .select-btn10 {
            padding: 15px 15px;
            /* Adjust the vertical padding */
            background-color: #f1f1f1;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            /* Aligns the content center vertically */
            align-items: center;
            /* Aligns the content center vertically */
        }

        /* Dropdown content */
        .custom-select-content10 {
            position: absolute;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            overflow: hidden;
            z-index: 1;
            top: 100%;
            /* Ensures dropdowns appear below the select button */
            width: 100%;
            /* Makes dropdown width same as the select button */
        }

        /* Custom option */
        .custom-option10 {
            /* display: flex; */
            align-items: center;
            padding: 5px;
            cursor: pointer;
        }

        /* Color indicator */
        .color-indicator10 {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .flag-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .table-responsive .row .col-sm-12 .dataTables_info {
            display: none !important;
        }

        .table-container {
            overflow-x: auto;
            max-height: 400px;
            /* Set a maximum height for the scrollable table */
        }

        .thead-light {
            position: sticky;
            top: 0;
        }
    </style>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('flag_mas_save') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>

                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">Flag master</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">

                        <div class="container">
                            <div class="col-md-10 col-lg-10">
                                <div class="card">

                                    <div class="card-header">
                                        <div class="card-title" style="text-align: center; font-weight: bold; font-size: 20px; ">Flag Master </div>
                                    </div>
                                    <div class="card-body">
                                        <br>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Division Name</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="div" id="div" onchange="divisionchange(this.value)" required>
                                                    <option value=""> --Select Division --</option>

                                                    @foreach ($division as $div)
                                                    <option value="{{$div['Division_id']}}">{{$div['Division']}}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Team / Floor Name</label>
                                            <div class="col-sm-8">
                                                <select class="form-control team_select" id="Team" name="Team" onchange="teamchange(this.value)" required>
                                                    <option value=""> --Select Team --</option>
                                                    <!-- Options will be dynamically added here -->
                                                </select>
                                                <!-- <input type="hidden" class="form-control team_id" id="Team_id" name="Team_id" readonly required> -->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Zone / Department Name</label>
                                            <div class="col-sm-8">
                                                <select class="form-control zone_nam" id="Zone" name="Zone" required>
                                                    <option value=""> --Select Zone --</option>
                                                    <!-- Options will be dynamically added here -->
                                                </select>
                                                <!-- <input type="text" class="form-control" id="Zone" name="Zone" required> -->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Flag Colour</label>
                                            <div class="col-sm-8">
                                                <div class="custom-select10 color-select10" id="colorSelect10">
                                                    <div class="select-btn10">
                                                        <i class="fa-solid fa-caret-down"></i>
                                                    </div>
                                                    <div class="custom-select-content10" style="display: none;">

                                                        @foreach ($flag as $res)
                                                        <div class="custom-option10" data-value="{{$res['Flag']}}" data-rowid="{{$res['Rowid']}}">
                                                            <div class="color-indicator10" style="background-color: {{$res['Flag']}};"></div>
                                                        </div>
                                                        @endforeach

                                                    </div>
                                                </div>
                                                <input type="hidden" id="selectedRowIdInput" name="selectedRowId" readonly>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Responsible Person </label>
                                            <div class="col-sm-8">
                                                <select class="form-control" id="res_empl" name="res_empl" required>
                                                    <option value=""> --Select Name --</option>
                                                    @foreach($Name as $nam)
                                                    <option value="{{$nam['Emplno']}}">{{$nam['name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="col-lg-12 col-md-12">
                                            <div class="d-flex justify-content-around pb-2">
                                                <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-primary">
                                                <button type="button" id="clearButton" class="btn btn-success ml-5" onclick="clearPage()">CLEAR</button>
                                                <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/FLAG_flag_Report'">Report</button>


                                                <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                                <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </form>

    <!-- FOR AUDIT FLAG ID  -->
    <script>
        // Add event listener to the color selection
        document.addEventListener('DOMContentLoaded', function() {
            var colorOptions = document.querySelectorAll('.custom-option10');

            colorOptions.forEach(function(option) {
                option.addEventListener('click', function() {
                    var selectedRowId = this.getAttribute('data-rowid');
                    document.getElementById('selectedRowIdInput').value = selectedRowId;
                });
            });
        });
    </script>

    <!-- AJAX METHOD FOR DIVISION SELECTION -->
    <script>
        function divisionchange(div_id) {
            var selected_div = div_id;

            $.ajax({
                url: "{{ route('flag_mas1') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                },
                dataType: 'json',
                success: function(division_id) {
                    if (division_id.length > 0) {
                        console.log(division_id);

                        var Zone = division_id[0].Zone;
                        var Rowid = division_id[0].Rowid;

                        // Clear existing options
                        $('.team_select').empty();

                        // Append the "--Select Division--" option first
                        $('.team_select').append('<option value=""> --Select Team -- </option>');

                        // Populate dropdown with new options
                        $.each(division_id, function(index, option) {
                            var teamOption = $('<option>', {
                                value: option.Team_id,
                                text: option.Team
                            });

                            $('.team_select').append(teamOption);
                        });

                        // Trigger change event to update hidden input
                        $('.team_select').trigger('change');

                        // console.log(division_id.Zone);

                        // var zones = division_id.zones;

                        // // Clear existing options
                        // $('.zone_nam').empty();

                        // // Append the "--Select Zone--" option first
                        // $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                        // // Populate dropdown with new options
                        // $.each(division_id, function(index, option) {
                        //     var zoneOption = $('<option>', {
                        //         value: option.Rowid,
                        //         text: option.Zone
                        //     });

                        //     $('.zone_nam').append(zoneOption);
                        // });

                    }
                }
            });
        }
    </script>

        <!-- AJAX METHOD FOR TEAM SELECTION -->
    <script>
        function teamchange(team_id) {
            var selected_team= team_id;

            $.ajax({
                url: "{{ route('flag_mas2') }}",
                type: "GET",
                data: {
                    selected_team: selected_team,
                },
                dataType: 'json',
                success: function(team_id) {
                    if (team_id.length > 0) {
                        console.log(team_id);

                        // var Zone = team_id[0].Zone;
                        // var Zone_id = team_id[0].Zone_id;

                        // // Clear existing options
                        // $('.team_select').empty();

                        // // Append the "--Select Division--" option first
                        // $('.team_select').append('<option value=""> --Select Team -- </option>');

                        // // Populate dropdown with new options
                        // $.each(division_id, function(index, option) {
                        //     var teamOption = $('<option>', {
                        //         value: option.Team_id,
                        //         text: option.Team
                        //     });

                        //     $('.team_select').append(teamOption);
                        // });

                        // // Trigger change event to update hidden input
                        // $('.team_select').trigger('change');

                        // console.log(division_id.Zone);

                        // var zones = division_id.zones;

                        // Clear existing options
                        $('.zone_nam').empty();

                        // Append the "--Select Zone--" option first
                        $('.zone_nam').append('<option value=""> --Select Zone -- </option>');

                        // Populate dropdown with new options
                        $.each(team_id, function(index, option) {
                            var zoneOption = $('<option>', {
                                value: option.Zone_id,
                                text: option.Zone
                            });

                            $('.zone_nam').append(zoneOption);
                        });

                    }
                }
            });
        }
    </script>

    <!-- COLOR AND FLAG GROUP -->
    <script>
        // JavaScript for custom select functionality
        document.addEventListener("click", function(e) {
            closeAllCustomSelects(e.target);
        });

        // Function to close all custom selects except the one passed as argument
        function closeAllCustomSelects(exceptThis) {
            var customSelects = document.querySelectorAll(".custom-select10");
            customSelects.forEach(function(customSelect) {
                if (exceptThis !== customSelect && !customSelect.contains(exceptThis)) {
                    var content = customSelect.querySelector(".custom-select-content10");
                    content.style.display = "none";
                }
            });
        }

        // Handling color select
        var colorSelectBtns = document.querySelectorAll(".color-select10 .select-btn10");
        var colorOptions = document.querySelectorAll(".color-select10 .custom-option10");

        colorSelectBtns.forEach(function(colorSelectBtn, index) {
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                var selectContent = this.parentNode.querySelector(".custom-select-content10");
                selectContent.style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });
        });

        colorOptions.forEach(function(option) {
            option.addEventListener("click", function() {
                var value = option.getAttribute("data-value");
                var colorIndicator = document.createElement("div");
                colorIndicator.classList.add("color-indicator10");
                colorIndicator.style.backgroundColor = value;
                var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn10");
                colorSelectBtn.textContent = ""; // Clear text
                colorSelectBtn.appendChild(colorIndicator);
                closeAllCustomSelects();

                // Get the index of the clicked row
                var rowIndex = selectedRowId.value;

                // Update the input field associated with the clicked row
                var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="color"]');
                if (rowInput) {
                    rowInput.value = value;
                }
            });
        });

        // Handling flag select
        var flagSelects = document.querySelectorAll(".flag-select");
        flagSelects.forEach(function(flagSelect, index) {
            var flagSelectBtn = flagSelect.querySelector(".select-btn10");
            var flagOptions = flagSelect.querySelectorAll(".custom-option10");

            flagSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                flagSelect.querySelector(".custom-select-content10").style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });

            flagOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var flagIcon = option.querySelector("i").cloneNode(true); // Clone the flag icon
                    flagSelectBtn.textContent = ""; // Clear text
                    flagSelectBtn.appendChild(flagIcon); // Add the flag icon to the select button
                    closeAllCustomSelects(); // Close the dropdown
                    var value = option.getAttribute("data-value");
                    selectedFlagInput.value = value; // Update flag input value

                    // Update the input field associated with the clicked row
                    var rowIndex = selectedRowId.value;
                    var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="flag"]');
                    if (rowInput) {
                        rowInput.value = value;
                    }
                });
            });
        });
    </script>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2 using ID
        $(document).ready(function() {
            $('#res_empl,#Zone,#Team,#div').select2();
        });
    </script>

    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>