<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Zone / Department Master</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/5s/flag_logo.jpg">

    <link href="../../../../css?family=Roboto:300,400,500,700,900" rel="stylesheet">

    <link rel="stylesheet" href="assets/css/5s/bootstrap.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/plugins/5s/fontawesome/css/fontawesome.min.css">

    <link rel="stylesheet" href="assets/css/5s/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/5s/datetimepicker/css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="assets/css/5s/style.css">

    <!-- <script src="https://cdn.jsdelivr.net/npm/google-translate-api-browser@1.0.0/dist/index.js"></script> -->
    <!--[if lt IE 9]>
		<script src="assets/js/5s/html5shiv.min.js"></script>
		<script src="assets/js/5s/respond.min.js"></script>
	<![endif]-->

    <!-- Include the Google Translate API -->
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

</head>

<body>

    @extends('Flag.flag_nav')
    @section('content')

    <form id="validate" method="POST" action="{{ route('flag_zone') }}">
        @csrf

        <div class="page-wrapper">
            <div class="content container-fluid">
                <div class="col-md-12">
                    @if ($message = Session::get('success'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        <p>{{ $message }}</p>
                    </div>
                    @endif

                    @if(session('alert'))
                    <div id="successAlert1" class="alert alert-danger alert-dismissible fade show" role="alert" style="position: fixed; top: 80px; right: 10px; width: 30%; z-index: 9999;">
                        {{ session('alert') }}
                    </div>
                    @endif
                </div>

                <div class="page-header">
                    <!-- ... (unchanged) ... -->
                    <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                        <h5 class="text-uppercase mb-0 mt-0 page-title">zone / Department master</h5>
                    </div>
                </div>
                <div class="page-content">
                    <div class="row">

                        <div class="container">
                            <div class="col-md-10 col-lg-10">
                                <div class="card">

                                    <div class="card-header">
                                        <div class="card-title" style="text-align: center; font-weight: bold; font-size: 20px; ">Zone / Department Master </div>
                                    </div>
                                    <div class="card-body">
                                        <br>
                                        <div class="form-group row">
                                            <label for="check" class="col-sm-3 col-form-label">Zone / Department Name</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control" id="Zone" name="Zone" oninput="convertToUppercase(this)" required>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="col-lg-12 col-md-12">
                                            <div class="d-flex justify-content-around pb-2">
                                                <input type="submit" name="submit" value="SAVE" id="save" class="btn btn-primary">
                                                <button type="button" id="clearButton" class="btn btn-success ml-5" onclick="clearPage()">CLEAR</button>
                                                <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/FLAG_zonemas_Report'">Report</button>


                                                <!-- <button class="btn btn-primary mr-2" type="submit">Submit</button> -->
                                                <!-- <button class="btn btn-secondary" type="reset">Cancel</button> -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </form>


    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>


    <!-- // AJAX METHOD FOR SHOWING TEAM //  -->
    <script>
        function zonevalue(div_id) {
            var selected_div = div_id;

            $.ajax({
                url: "{{ route('flag_zone_mas1') }}",
                type: "GET",
                data: {
                    selected_div: selected_div,
                },
                dataType: 'json',
                success: function(options) {
                    if (options.length > 0) {
                        console.log(options);

                        // Clear existing options
                        $('.team_select').empty();

                        // Append the "--Select Division--" option first
                        $('.team_select').append('<option value=""> --Select Team -- </option>');

                        // Populate dropdown with new options
                        $.each(options, function(index, option) {
                            var teamOption = $('<option>', {
                                value: option.Rowid,
                                text: option.Team
                            });

                            $('.team_select').append(teamOption);
                        });

                        // Trigger change event to update hidden input
                        $('.team_select').trigger('change');
                    }
                }
            });
        }

    </script>


    <!-- CONVERT TO UPPERCASE LETTERS -->
    <script>
        function convertToUppercase(input) {
            input.value = input.value.toUpperCase();
        }
    </script>

    <!-- //CLEAR BUTTON -->
    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <!-- <script src="assets/js/5s/jquery-3.6.0.min.js"></script> -->
    <script src="assets/js/5s/popper.min.js"></script>

    <script src="assets/js/5s/bootstrap.bundle.min.js"></script>

    <script src="assets/js/5s/jquery.slimscroll.js"></script>

    <script src="assets/js/5s/select2.min.js"></script>

    <script src="assets/js/5s/moment.min.js"></script>
    <script src="assets/plugins/5s/datetimepicker/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="assets/js/5s/app.js"></script>

    @endsection

</body>

</html>