<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" /><!-- /Added by HTTrack -->

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="hwassets/img/favicon.png">
    <title>HW Add Asset</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/bootstrap.min.css">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/all.min.css">

    <!-- Feathericon CSS -->
    <link rel="stylesheet" href="hwassets/plugins/feather/feather.css">

    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/select2.min.css">

    <!-- Datatables CSS -->
    <link rel="stylesheet" href="hwassets/plugins/datatables/datatables.min.css">

    <!-- Calendar CSS -->
    <link rel="stylesheet" href="hwassets/plugins/simple-calendar/simple-calendar.css">

    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="hwassets/css/bootstrap-datetimepicker.min.css">

    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick-theme.css">

    <link rel="stylesheet" type="text/css" href="hwassets/plugins/light-gallery/css/lightgallery.min.css">

    <!-- Summernote CSS -->
    <link rel="stylesheet" href="hwassets/plugins/summernote/summernote-bs5.min.css">

    <link rel="stylesheet" type="text/css" href="hwassets/css/fullcalendar.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/style.css">

    <!-- HIDE THE DEFAULT INCREASE AND DECREASE BUTTON FOR THE TYPE="NUMBER" -->
    <style>
        /* Hide the default number input buttons */
        input[type="number"]::-webkit-inner-spin-button,
        input[type="number"]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type="number"] {
            -moz-appearance: textfield;
            /* Firefox */
        }
    </style>

</head>


<body>

    <div class="main-wrapper">

        @extends('Hardware_Asset.Navbar.hwnavbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="row">
                        <div class="col-sm-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="javascript:;">Assets </a>
                                </li>
                                <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                                <li class="breadcrumb-item active">Add Assets</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <form method="post" id="" action="{{ route('asset') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-heading">
                                                <h4>Add Assets</h4>
                                            </div>
                                        </div>
                                        <!-- ENO -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>ENO</label>
                                                <input type="text" name="eno" value="{{$resultEno}}" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- TYPE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label for="ass_type">Asset Type<span class="login-danger">*</span></label>
                                                <select name="ass_type" id="ass_type" class="form-control select2" required oninvalid="setCustomValidity('Please choose an Type')" onchange="resetCustomValidity()">
                                                    <option value="" selected disabled>Select Type</option>
                                                    @foreach($resultItem as $items)
                                                    <option value="{{ $items['Prefix'] }}" data-item="{{ $items['Item'] }}">{{ $items['Item'] }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" id="selected_item" name="selected_item" required>
                                            </div>
                                        </div>
                                        <!-- ID -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Asset ID</label>
                                                <input type="text" name="ass_id" id="ass_id" class="form-control" required style="pointer-events: none;">
                                            </div>
                                        </div>
                                        <!-- MODE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Mode<span class="login-danger"></span></label>
                                                <select name="ass_mode" id="mode-select" class="form-control select">
                                                    <option disabled selected>Select Type</option>
                                                    <option>Project</option>
                                                    <option>Store</option>
                                                    @php
                                                    $user_data=Session::get('user_data');
                                                    @endphp
                                                    @if($user_data == "GKA0100")
                                                    <option value="Opening">Opening</option>
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <!-- GRN NO - SELECT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="grn-select-container">
                                            <div class="form-group local-forms">
                                                <label for="grnno">GRN No<span class="login-danger">*</span></label>
                                                <select name="grn_no" id="grnno" class="form-control select2" required oninvalid="setCustomValidity('Please choose a Grn No')" onchange="resetCustomValidity()">
                                                    <option value="" selected disabled>Select GRN No</option>
                                                    @foreach($Grn_Inv as $Grn)
                                                    <option value="{{ $Grn['GRNNO'] }}" data-grndate="{{ date('Y-m-d', strtotime($Grn['GRNDATE'])) }}" data-invno="{{ $Grn['INVNO'] }}" data-invdate="{{ date('Y-m-d', strtotime($Grn['INVDATE'])) }}" data-supp_name="{{ $Grn['Supplier_Name'] }}" data-item_name="{{ $Grn['ITEMNAME'] }}">
                                                        {{ $Grn['GRNNO'] }} / {{ $Grn['ITEMNAME'] }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <!-- GRN NO - INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="grn-input-container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label for="grnno">GRN No </label>
                                                <input type="text" name="grnno_input" id="grnno_input" class="form-control">
                                            </div>
                                        </div>
                                        <!-- GRN DATE -->
                                        <div class="col-12 col-md-6 col-xl-4" id="grndate_container">
                                            <div class="form-group local-forms">
                                                <label for="grn_date">GRN Date <span class="login-danger">*</span></label>
                                                <input type="text" name="grn_date" id="grn_date" class="form-control" placeholder="GRN Date" readonly required oninvalid="setCustomValidity('Grn date is required')" onchange="resetCustomValidity()">
                                            </div>
                                        </div>
                                        <!-- GRN DATE-INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="grndate_input_container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label for="grn_date">GRN Date </label>
                                                <input type="date" name="grndate_input" id="grndate_input" class="form-control">
                                            </div>
                                        </div>
                                        <!-- INV NO -->
                                        <div class="col-12 col-md-6 col-xl-4" id="invono_container">
                                            <div class="form-group local-forms">
                                                <label>INV No<span class="login-danger">*</span></label>
                                                <input type="text" name="inv_no" id="inv_no" class="form-control" placeholder="INV No" readonly>
                                            </div>
                                        </div>
                                        <!-- INV NO INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="invono_input_container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label>INV No </label>
                                                <input type="text" name="invno_input" id="invno_input" class="form-control" placeholder="INV No">
                                            </div>
                                        </div>
                                        <!-- INV DATE -->
                                        <div class="col-12 col-md-6 col-xl-4" id="invdate_container">
                                            <div class="form-group local-forms">
                                                <label>INV Date<span class="login-danger">*</span></label>
                                                <input type="text" name="inv_date" id="inv_date" class="form-control" placeholder="INV Date" readonly>
                                            </div>
                                        </div>
                                        <!-- INV DATE- INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="invdate_input_container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label>INV Date</label>
                                                <input type="date" name="invdate_input" id="invdate_input" class="form-control">
                                            </div>
                                        </div>
                                        <!-- ITEM NAME -->
                                        <div class="col-12 col-md-6 col-xl-4" id="item_container">
                                            <div class="form-group local-forms">
                                                <label>Item Name<span class="login-danger">*</span></label>
                                                <input name="item_name" class="form-control" type="text" id="itemname" required oninvalid="setCustomValidity('Please enter Item Name')" onchange="resetCustomValidity()" oninput="this.value = this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <!-- ITEM NAME- INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="item_input_container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label>Item Name</label>
                                                <input name="itemname_input" class="form-control" type="text" id="itemname_input" oninput="this.value = this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <!-- MODEL -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Model<span class="login-danger"></span></label>
                                                <input name="model" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- MANUF -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Manufacturer<span class="login-danger"></span></label>
                                                <input name="manu" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- PUR DATE -->
                                        <div class="col-12 col-md-6 col-xl-4" id="purdate_container">
                                            <div class="form-group local-forms">
                                                <label>Purchase Date <span class="login-danger">*</span></label>
                                                <!-- <input type="date" name="pur_date" id="purDate" class="form-control" required onchange="update()"> -->
                                                <input type="text" name="pur_date" id="purDate" class="form-control" placeholder="Purchase Date" readonly onkeyup="update()">
                                            </div>
                                        </div>
                                        <!-- PUR DATE -INPUT -->
                                        <div class="col-12 col-md-6 col-xl-4" id="purdate_input_container" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label>Purchase Date </label>
                                                <!-- <input type="date" name="pur_date" id="purDate" class="form-control" required onchange="update()"> -->
                                                <input type="date" name="purdate_input" id="purDate_input" class="form-control">
                                            </div>
                                        </div>
                                        <!-- HD -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Hard Disk<span class="login-danger"></span></label>
                                                <input name="hd" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- RAM -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>RAM<span class="login-danger"></span></label>
                                                <input name="ram" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- OS -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>OS<span class="login-danger"></span></label>
                                                <input name="os" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- PROC -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Processor<span class="login-danger"></span></label>
                                                <input name="proc" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- IP -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>IP Address<span class="login-danger"></span></label>
                                                <input name="ip" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- MAC -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Serial No<span class="login-danger"></span></label>
                                                <input name="mac" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- SYS TYPE -->
                                        <div class="col-12 col-md-6 col-xl-4 d-none">
                                            <div class="form-group local-forms">
                                                <label>System Type<span class="login-danger"></span></label>
                                                <input name="sys_type" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- VALUE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Value<span class="login-danger"></span></label>
                                                <input name="value" class="form-control" type="text">
                                            </div>
                                        </div>
                                        <!-- WARRANTY - COUNT -->
                                        <div class="col-12 col-md-6 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>Count<span class="login-danger">*</span></label>
                                                <input class="form-control" type="number" id="warrantyCount" oninput="update()" min="1" required disabled>
                                            </div>
                                        </div>
                                        <!-- WARRANTY - M/Y -->
                                        <div class="col-12 col-md-6 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>M / Y<span class="login-danger">*</span></label>
                                                <select class="form-control select" id="warrantyMode" disabled oninvalid="setCustomValidity('Please choose an Type')" onchange="handleSelectChange()">
                                                    <option value="" selected disabled>Select Type</option>
                                                    <option value="Month">Month</option>
                                                    <option value="Year">Year</option>
                                                </select>
                                                <input type="text" id="selectedMY" class="form-control d-none" placeholder="enter m/y" required oninvalid="setCustomValidity('Please enter m/y')" onchange="resetCustomValidity()">
                                            </div>
                                        </div>
                                        <!-- COMBINED -->
                                        <div class="col-12 col-md-6 col-xl-6 d-none">
                                            <div class="form-group local-forms">
                                                <label>Combined Result<span class="login-danger"></span></label>
                                                <input name="warranty" class="form-control" type="text" id="combinedInput">
                                            </div>
                                        </div>
                                        <!-- END WARRENTY -->
                                        <div class="col-12 col-md-6 col-xl-6 d-none">
                                            <div class="form-group local-forms">
                                                <label>End Warranty<span class="login-danger"></span></label>
                                                <input class="form-control" type="text" name="endWarranty" id="endWarranty">
                                            </div>
                                        </div>
                                        <!-- Supplier -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Supplier<span class="login-danger"></span></label>
                                                <input name="supplier" id="supplier" class="form-control" type="text" placeholder="Supplier Name">
                                            </div>
                                        </div>
                                        <!-- IMAGE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <label class="local-top">Image 1<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image1" id="prodImgInput1" class="hide-input" onchange="previewImage1()">
                                                    <label for="file" class="upload" id="fileinputlable1">Choose File</label>
                                                </div>
                                            </div>
                                            <div id="imagePreview1" style="display:none; text-align: center;">
                                                <img id="preview1" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <label class="local-top">Image 2<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image2" id="prodImgInput2" class="hide-input" onchange="previewImage2()">
                                                    <label for="file" class="upload" id="fileinputlable2">Choose File</label>
                                                </div>
                                            </div>
                                            <div id="imagePreview2" style="display:none; text-align: center;">
                                                <img id="preview2" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- DESC -->
                                    <div class="col-12 col-sm-12">
                                        <div class="form-group local-forms">
                                            <label>Description <span class="login-danger"></span></label>
                                            <textarea name="desc" class="form-control" rows="3" cols="30"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="doctor-submit text-end">
                                            <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ASSIGNING GRN & INV VALUES  -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#grnno').on('change', function() {
                var selectedGrnNo = $(this).val();
                var selectedGrnDate = $(this).find('option:selected').data('grndate');
                var selectedInvNo = $(this).find('option:selected').data('invno');
                var selectedinvdate = $(this).find('option:selected').data('invdate');
                var selectedSupplier = $(this).find('option:selected').data('supp_name');
                var selectedItenName = $(this).find('option:selected').data('item_name');
                $('#grn_date').val(selectedGrnDate);
                $('#inv_no').val(selectedInvNo);
                $('#inv_date').val(selectedinvdate);
                $('#itemname').val(selectedItenName);
                $('#supplier').val(selectedSupplier);
                $('#purDate').val(selectedGrnDate);

                var Supplier_Name = document.getElementById('supplier');
                if (selectedSupplier != "") {
                    $('#supplier').val(selectedSupplier);
                    Supplier_Name.readOnly = true;
                }
                update();
            });

            $('#mode-select').on('change', function() {
                var selectedMode = $(this).val();

                var grnNoSelect = $('#grnno');
                var grnDateInput = $('#grn_date');
                var invNoInput = $('#inv_no');
                var invDateInput = $('#inv_date');
                var itemNameInput = $('#itemname');
                var purDateInput = $('#purDate');

                var warrantyCountInput = document.getElementById('warrantyCount');
                var warrantyModeSelect = document.getElementById('warrantyMode');


                if (selectedMode === 'Opening') {
                    // Show the input field and hide the select dropdown


                    warrantyCountInput.disabled = false;
                    warrantyModeSelect.disabled = false;

                    // GRN NO
                    $('#grn-select-container').hide();
                    $('#grn-input-container').show();

                    // GRN DATE
                    $('#grndate_container').hide();
                    $('#grndate_input_container').show();

                    // INV NO
                    $('#invono_container').hide();
                    $('#invono_input_container').show();

                    // INV DATE
                    $('#invdate_container').hide();
                    $('#invdate_input_container').show();

                    // ITEM NAME
                    $('#item_container').hide();
                    $('#item_input_container').show();

                    // PURCH DATE
                    $('#purdate_container').hide();
                    $('#purdate_input_container').show();

                    // Remove required attributes
                    grnNoSelect.removeAttr('required');
                    grnDateInput.removeAttr('required');
                    invNoInput.removeAttr('required');
                    invDateInput.removeAttr('required');
                    itemNameInput.removeAttr('required');
                    purDateInput.removeAttr('required');


                } else {

                    var warrantyCountInput = document.getElementById('warrantyCount');
                    var warrantyModeSelect = document.getElementById('warrantyMode');

                    warrantyCountInput.disabled = false;
                    warrantyModeSelect.disabled = false;

                    // Show the select dropdown and hide the input field
                    $('#grn-input-container').hide();
                    $('#grn-select-container').show();

                    // GRN DATE
                    $('#grndate_container').show();
                    $('#grndate_input_container').hide();

                    // INV NO
                    $('#invono_container').show();
                    $('#invono_input_container').hide();

                    // INV DATE
                    $('#invdate_container').show();
                    $('#invdate_input_container').hide();

                    // ITEM NAME
                    $('#item_container').show();
                    $('#item_input_container').hide();

                    // PURCH DATE
                    $('#purdate_container').show();
                    $('#purdate_input_container').hide();

                    // Add required attributes back
                    grnNoSelect.attr('required', 'required');
                    grnDateInput.attr('required', 'required');
                    invNoInput.attr('required', 'required');
                    invDateInput.attr('required', 'required');
                    itemNameInput.attr('required', 'required');
                    purDateInput.attr('required', 'required');
                }
            });
        });
    </script>

    <!-- <script>
        $(document).ready(function() {
            $('#mode-select').on('change', function() {
                var selectedMode = $(this).val();

                if (selectedMode === 'Opening') {
                    // Show the input field and hide the select dropdown

                    // GRN NO
                    $('#grn-select-container').hide();
                    $('#grn-input-container').show();

                    // GRN DATE
                    $('#grndate_container').hide();
                    $('#grndate_input_container').show();

                    // INV NO
                    $('#invono_container').hide();
                    $('#invono_input_container').show();

                    // INV DATE
                    $('#invdate_container').hide();
                    $('#invdate_input_container').show();

                    // ITEM NAME
                    $('#item_container').hide();
                    $('#item_input_container').show();

                    // PURCH DATE
                    $('#purdate_container').hide();
                    $('#purdate_input_container').show();

                } else {
                    // Show the select dropdown and hide the input field
                    $('#grn-input-container').hide();
                    $('#grn-select-container').show();

                    // GRN DATE
                    $('#grndate_container').show();
                    $('#grndate_input_container').hide();

                    // INV NO
                    $('#invono_container').show();
                    $('#invono_input_container').hide();

                    // INV DATE
                    $('#invdate_container').show();
                    $('#invdate_input_container').hide();

                    // ITEM NAME
                    $('#item_container').show();
                    $('#item_input_container').hide();

                    // PURCH DATE
                    $('#purdate_container').show();
                    $('#purdate_input_container').hide();
                }
            });
        });
    </script> -->

    <!-- REQUIRED -->
    <!-- WARRANTY COUNT AND MODE IN A INPUT -->
    <script>
        function handleSelectChange() {
            resetCustomValidity();
            update();
        }

        function resetCustomValidity() {
            document.getElementById('itemname').setCustomValidity('');
            document.getElementById('ass_type').setCustomValidity('');
            document.getElementById('grnno').setCustomValidity('');
            document.getElementById('warrantyMode').setCustomValidity('');
            document.getElementById('selectedMY').setCustomValidity('');
        }

        function update() {
            var purDateInput = document.getElementById('purDate');
            var warrantyCountInput = document.getElementById('warrantyCount');
            var warrantyModeSelect = document.getElementById('warrantyMode');
            var combinedInput = document.getElementById('combinedInput');
            var endWarrantyInput = document.getElementById('endWarranty');

            var selectedValue = warrantyModeSelect.options[warrantyModeSelect.selectedIndex].value;
            document.getElementById('selectedMY').value = selectedValue;

            // DONT ALLOW '.' AND LESS THAN '0'
            let value = warrantyCountInput.value;
            value = value.replace(/[^\d]/g, '');
            warrantyCountInput.value = value;

            // if (!purDateInput.value) {
            //     // Purchase date not selected, disable inputs and return
            //     warrantyCountInput.disabled = true;
            //     warrantyModeSelect.disabled = true;
            //     combinedInput.disabled = true;
            //     endWarrantyInput.value = '';
            //     return;
            // }

            console.log("Purchase : ", purDateInput.value);

            if (purDateInput != "") {
                warrantyCountInput.disabled = false;
                warrantyModeSelect.disabled = false;
                combinedInput.disabled = false;
            } else {
                warrantyCountInput.disabled = true;
                warrantyModeSelect.disabled = true;
                combinedInput.disabled = true;
            }

            var countValue = parseInt(warrantyCountInput.value);
            var modeValue = warrantyModeSelect.value;

            // Combine the values
            var combinedValue = countValue + ' ' + modeValue;

            // Set the combined value to the combinedInput field
            combinedInput.value = combinedValue;

            // Calculate end warranty date
            var endWarrantyDate = new Date(purDateInput.value);
            if (modeValue === 'Month') {
                endWarrantyDate.setMonth(endWarrantyDate.getMonth() + countValue);
            } else if (modeValue === 'Year') {
                endWarrantyDate.setFullYear(endWarrantyDate.getFullYear() + countValue);
            }

            // Format the end warranty date as dd-mm-yyyy
            var formattedEndWarranty = endWarrantyDate.getDate() + '-' + (endWarrantyDate.getMonth() + 1) + '-' + endWarrantyDate.getFullYear();
            endWarrantyInput.value = formattedEndWarranty;
        }
    </script>

    <!-- CLICKABLE CHOOSEN LABLE -->
    <script>
        document.getElementById("fileinputlable1").addEventListener("click", function() {
            document.getElementById("prodImgInput1").click();
        });
        document.getElementById("fileinputlable2").addEventListener("click", function() {
            document.getElementById("prodImgInput2").click();
        })
    </script>

    <!-- IMAGE 1-->
    <script>
        function previewImage1() {
            var input = document.getElementById('prodImgInput1');
            var preview = document.getElementById('preview1');
            var previewContainer = document.getElementById('imagePreview1');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>

    <!-- IMAGE 2-->
    <script>
        function previewImage2() {
            var input = document.getElementById('prodImgInput2');
            var preview = document.getElementById('preview2');
            var previewContainer = document.getElementById('imagePreview2');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>



    <div class="sidebar-overlay" data-reff=""></div>
    <!-- jQuery -->
    <script src="hwassets/js/jquery-3.7.0.min.js"></script>
    <!-- Bootstrap Core JS -->
    <script src="hwassets/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Js -->
    <script src="hwassets/js/feather.min.js"></script>
    <!-- Slimscroll -->
    <script src="hwassets/js/jquery.slimscroll.js"></script>
    <!-- Select2 Js -->
    <script src="hwassets/js/select2.min.js"></script>
    <!-- Datatables JS -->
    <script src="hwassets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="hwassets/plugins/datatables/datatables.min.js"></script>
    <!-- counterup JS -->
    <script src="hwassets/js/jquery.waypoints.js"></script>
    <script src="hwassets/js/jquery.counterup.min.js"></script>
    <!-- Apexchart JS -->
    <script src="hwassets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="hwassets/plugins/apexchart/chart-data.js"></script>
    <!-- Calendar Js -->
    <script src="hwassets/plugins/simple-calendar/jquery.simple-calendar.js"></script>
    <script src="hwassets/js/calander.js"></script>
    <!-- Circle Progress JS -->
    <script src="hwassets/js/circle-progress.min.js"></script>
    <!-- Slick JS -->
    <script src="hwassets/plugins/slick/slick.js"></script>
    <!-- Datepicker Core JS -->
    <script src="hwassets/plugins/moment/moment.min.js"></script>
    <script src="hwassets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="hwassets/plugins/light-gallery/js/lightgallery-all.min.js"></script>
    <!-- Summernote JS -->
    <script src="hwassets/plugins/summernote/summernote-bs5.min.js"></script>
    <!-- Ck Editor JS -->
    <script src="hwassets/js/ckeditor.js"></script>
    <!-- Full Calendar -->
    <script src="hwassets/js/jquery-ui.min.js"></script>
    <script src="hwassets/js/fullcalendar.min.js"></script>
    <script src="hwassets/js/jquery.fullcalendar.js"></script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <script data-navigate-once="true">
        window.livewireScriptConfig = {
            "csrf": "hU0lkwotxPRtX77i9lZ9z8EOooahpVoehQm3a7EO",
            "uri": "\/livewire\/update",
            "progressBar": ""
        };
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @if ($message = Session::get('ErrorMsg'))
    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('ErrorAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 10000);
    </script>
    @endif

    <script>
        $(document).ready(function() {
            $('#ass_type').change(function() {
                var selectedOption = $(this).find(':selected');
                var selectedPrefix = selectedOption.val();
                var selectedItem = selectedOption.data('item');

                // Set the hidden input value
                $('#selected_item').val(selectedItem);

                $.ajax({
                    url: '/hw_add_asset2',
                    method: 'get',
                    data: {
                        selectedPrefix: selectedPrefix,
                        selectedItem: selectedItem
                    },
                    success: function(response) {
                        // Handle the response and display the result
                        console.log(response);
                        $("#ass_id").val(response);
                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.error(error);
                    }
                });
            });
        });
    </script>

</body>
@endsection

</html>